@testset "Entropy" begin
    type_list = generate_test_types([Float32, N0f8], [Gray, RGB])

    # generated by `rand(MersenneTwister(0), 1:10, 10, 10)` in Julia 1.7-rc2
    img = Gray{Float32}[
        5   2   4   8  10   8  10   2  6  10
        8  10  10   8   3   5  10   8  1   2
        5   5   1   6   8   9  10   2  8   1
        7   9   5   1  10   8   8   3  7   5
        9   9   2  10   5  10   1   3  7   1
        1   8   5   9   9   1   5  10  9  10
        8   5   6   1   7   5   2   6  3   6
        1   8   2   4   6   2   6   2  4   8
        4   5   2   8   7   2   4   7  2   8
       10   1   1   6   4   1   8   3  6   8
    ]./10
    img_repeat = repeat(img, inner=(2,2), outer=(2, 2))
    for T in generate_test_types([Float32, N0f8], [Gray, RGB])
        A, A_repeat = T.(img), T.(img_repeat)
        for (ref, kind) in [(3.2183821803676587, :shannon),
                            (2.230812534286212, :nat),
                            (0.9688295738011105, :hartley)]
            # entropy only cares the distribution of the values thus we check the equalities
            rst = entropy(A; kind=kind)
            @test rst ≈ entropy(A./2; kind=kind) ≈ entropy(A_repeat;kind=kind)
            @test rst ≈ ref
        end
    end

    # For BitMatrix we have faster implementation, here we check that it
    # is equivalent to the fallback method.
    img_bool = img .> 0.5
    img_float = Float32.(img_bool)
    for kind in [:shannon, :nat, :hartley]
        @test entropy(img_bool; kind=kind) == entropy(img_float; kind=kind)
    end

    @test_throws ArgumentError entropy(img, kind=:something_wrong)
end
