# Release notes

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Version [v1.0.0] - 2025-10-22

### Other

* A 1.0 release of the package with no changes relative to the last release. ([#24], [#28])

## Version [v0.2.5] - 2024-06-12

### Added

* `iocapture` now accepts an `io_context` keyword argument that is passed to the `IOContext` that wraps `stdout` and `stderr`. ([#26])

## Version [v0.2.4] - 2023-01-17

### Added

* `iocapture` now accepts a `passthrough` keyword argument that passes through output to `stdout` as well as capturing it. ([#19], [#20])
* The new `capture_buffer` keyword argument allows to replace the internal `IOBuffer()` used for capturing, enabling arbitrary dynamic processing of the captured output. ([#21], [#23])

## Version [v0.2.3] - 2023-05-18

### Fixed

* User code that creates a lot of "method definition overwritten" warnings no longer stalls in `IOCapture.capture` due to a buffer not being emptied. ([JuliaDocs/Documenter.jl#2121][documenter-2121], [#15][github-15])

## Version [v0.2.2] - 2021-06-13

### Fixed

* `IOCapture.capture` now correctly handles the random number generator seeds on Julia 1.7. ([#11])

## Version [v0.2.1] - 2021-03-14

### Fixed

* User code that writes a lot into `stdout` or `stderr` no longer stalls in `IOCapture.capture` due to a buffer filling up. ([fredrikekre/Literate.jl#138], [#9])

## Version [v0.2.0] - 2020-11-08

### Breaking

* The `iocapture` function has been renamed to `capture` and is no longer exported. The recommended way to refer to the function by fully qualifying the name (i.e. `IOCapture.capture`). ([#3], [#6])

  **For upgrading:** Instances of `iocapture` (or `IOCapture.iocapture`) should be replaced by `IOCapture.capture`.

* The `throwerrors` keyword argument to `capture` (previously `iocapture`) has been renamed to `rethrow` and accepts now exception types as arguments (instead of `:interrupt`/`true`/`false`). ([#2], [#4], [#6])

  **For upgrading:**

  * Any uses of `throwerrors = ...` should be replaced by `rethrow = ...`.
  * `throwerrors = :interrupt` (or `rethrow = :interrupt`) should be replaced by `rethrow = InterrupException`.
  * `throwerrors = true` (or `rethrow = true`) should be replaced by `rethrow = Any`.
  * `throwerrors = false` (or `rethrow = false`) should be replaced by `rethrow = Union{}`.

## Version [v0.1.1] - 2020-10-29

### Added

* `iocapture` now accepts the `color` keyword argument to enable the capturing of ANSI color sequences (on Julia 1.6 and above). ([#1])

## Version [v0.1.0] - 2020-09-20

Initial release exporting the `iocapture` function.


<!-- Links generated by Changelog.jl -->

[v0.1.0]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.1.0
[v0.1.1]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.1.1
[v0.2.0]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.0
[v0.2.1]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.1
[v0.2.2]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.2
[v0.2.3]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.3
[v0.2.4]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.4
[v0.2.5]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v0.2.5
[v1.0.0]: https://github.com/JuliaDocs/IOCapture.jl/releases/tag/v1.0.0
[#1]: https://github.com/JuliaDocs/IOCapture.jl/issues/1
[#2]: https://github.com/JuliaDocs/IOCapture.jl/issues/2
[#3]: https://github.com/JuliaDocs/IOCapture.jl/issues/3
[#4]: https://github.com/JuliaDocs/IOCapture.jl/issues/4
[#6]: https://github.com/JuliaDocs/IOCapture.jl/issues/6
[#9]: https://github.com/JuliaDocs/IOCapture.jl/issues/9
[#11]: https://github.com/JuliaDocs/IOCapture.jl/issues/11
[#19]: https://github.com/JuliaDocs/IOCapture.jl/issues/19
[#20]: https://github.com/JuliaDocs/IOCapture.jl/issues/20
[#21]: https://github.com/JuliaDocs/IOCapture.jl/issues/21
[#23]: https://github.com/JuliaDocs/IOCapture.jl/issues/23
[#24]: https://github.com/JuliaDocs/IOCapture.jl/issues/24
[#26]: https://github.com/JuliaDocs/IOCapture.jl/issues/26
[#28]: https://github.com/JuliaDocs/IOCapture.jl/issues/28
[fredrikekre/Literate.jl#138]: https://github.com/fredrikekre/Literate.jl/issues/138
