module COFF

using StructIO, Base.BinaryPlatforms
import Base.BinaryPlatforms: Platform

# Bring in ObjectFile definitions
using ObjectFile
import ObjectFile: DynamicLink, DynamicLinks, RPath, ObjectHandle, Section, Sections, SectionRef,
                   Segment, Segments, SegmentRef, StrTab, Symbols, SymtabEntry, SymbolRef,
                   getindex, length, lastindex, iterate, keys, eltype, handle, header, path,
                   rpaths, canonical_rpaths, find_library, readmeta, seek, seekstart, skip,
                   iostream, position, read, readuntil, eof, endianness, is64bit, isrelocatable,
                   isexecutable, islibrary, isdynamic, mangle_section_name, mangle_symbol_name,
                   format_string, section_header_offset, section_header_size, section_header_type,
                   segment_header_offset, segment_header_size, segment_header_type, startaddr,
                   symtab_entry_offset, symtab_entry_size, symtab_entry_type, find_libraries,
                   findfirst, deref, section_name, section_size,
                   section_offset, section_address, section_number, segment_name, segment_offset,
                   segment_file_size, segment_memory_size, segment_address, strtab_lookup,
                   symbol_name, symbol_value, isundef, isglobal, islocal, isweak, symbol_number, symbol_section, symbol_offset
# Load in imported C #define constants
include("constants.jl")

# Start to bring in concrete types, in the order they're needed
include("COFFHeader.jl")
include("COFFOptionalHeader.jl")
include("COFFHandle.jl")
include("COFFSection.jl")
include("COFFStrTab.jl")
include("COFFSymbol.jl")
include("COFFDynamicLink.jl")

end # module COFF
