synth_imgs = [
    "Float64_0" => rand(127, 257),
    "Float64_1" => rand(127, 257, 1),
    "Float64_2" => rand(127, 257, 2),
    "Float64_3" => rand(127, 257, 3),
    "Float64_4" => rand(127, 257, 4),
    "Bool_0" => rand(Bool, 127, 257),
    "Bool_1" => rand(Bool, 127, 257, 1),
    "Bool_2" => rand(Bool, 127, 257, 2),
    "Bool_3" => rand(Bool, 127, 257, 3),
    "Bool_4" => rand(Bool, 127, 257, 4),
    "UInt8_0" => rand(UInt8, 127, 257),
    "UInt8_1" => rand(UInt8, 127, 257, 1),
    "UInt8_2" => rand(UInt8, 127, 257, 2),
    "UInt8_3" => rand(UInt8, 127, 257, 3),
    "UInt8_4" => rand(UInt8, 127, 257, 4),
    "UInt16_0" => rand(UInt16, 127, 257),
    "UInt16_1" => rand(UInt16, 127, 257, 1),
    "UInt16_2" => rand(UInt16, 127, 257, 2),
    "UInt16_3" => rand(UInt16, 127, 257, 3),
    "UInt16_4" => rand(UInt16, 127, 257, 4),
    "N0f8_0" => rand(N0f8, 127, 257),
    "N0f8_1" => rand(N0f8, 127, 257, 1),
    "N0f8_2" => rand(N0f8, 127, 257, 2),
    "N0f8_3" => rand(N0f8, 127, 257, 3),
    "N0f8_4" => rand(N0f8, 127, 257, 4),
    "N0f16_0" => rand(N0f16, 127, 257),
    "N0f16_1" => rand(N0f16, 127, 257, 1),
    "N0f16_2" => rand(N0f16, 127, 257, 2),
    "N0f16_3" => rand(N0f16, 127, 257, 3),
    "N0f16_4" => rand(N0f16, 127, 257, 4),
    "Gray" => rand(Gray, 127, 257),
    "GrayA" => rand(GrayA, 127, 257),
    "RGB" => rand(RGB, 127, 257),
    "RGBA" => rand(RGBA, 127, 257),
    "ARGB32" => reinterpret(ARGB32, rand(UInt32, 127, 257)),
    "Gray-Bool" => rand(Gray{Bool}, 127, 257),
    "Gray-N0f8" => rand(Gray{N0f8}, 127, 257),
    "GrayA-N0f8" => rand(GrayA{N0f8}, 127, 257),
    "RGB-N0f8" => rand(RGB{N0f8}, 127, 257),
    "RGBA-N0f8" => rand(RGBA{N0f8}, 127, 257),
    "Gray-N0f16" => rand(Gray{N0f16}, 127, 257),
    "GrayA-N0f16" => rand(GrayA{N0f16}, 127, 257),
    "RGB-N0f16" => rand(RGB{N0f16}, 127, 257),
    "RGBA-N0f16" => rand(RGBA{N0f16}, 127, 257),
    "Gray-N0f8" => rand(Gray{N0f8}, 127, 257),
    "GrayA-N0f8" => rand(GrayA{N0f8}, 127, 257),
    "Gray-Float64" => rand(Gray{Float64}, 127, 257),
    "GrayA-Float64" => rand(GrayA{Float64}, 127, 257),
    "RGB-Float64" => rand(RGB{Float64}, 127, 257),
    "RGBA-Float64" => rand(RGBA{Float64}, 127, 257),
]

edge_case_imgs = [
    ("BitArray_0", x -> _convert(Gray, N7f1, x), randn(127, 257) .> 0),
    ("BitArray_1", x -> _convert(Gray, N7f1, x), randn(127, 257, 1) .> 0),
    ("BitArray_2", x -> _convert(GrayA, N7f1, x), randn(127, 257, 2) .> 0),
    ("BitArray_3", x -> _convert(RGB, N7f1, x), randn(127, 257, 3) .> 0),
    ("BitArray_4", x -> _convert(RGBA, N7f1, x), randn(127, 257, 4) .> 0),
    ("N4f12_0", x -> _convert(Gray, N0f16, x), rand(N4f12, 127, 257)),
    ("N4f12_1", x -> _convert(Gray, N0f16, x), rand(N4f12, 127, 257, 1)),
    ("N4f12_2", x -> _convert(GrayA, N0f16, x), rand(N4f12, 127, 257, 2)),
    ("N4f12_3", x -> _convert(RGB, N0f16, x), rand(N4f12, 127, 257, 3)),
    ("N4f12_4", x -> _convert(RGBA, N0f16, x), rand(N4f12, 127, 257, 4)),
    ("BGR-N0f8", identity, rand(BGR{N0f8}, 127, 257)),
    ("BGR-N0f16", identity, rand(BGR{N0f16}, 127, 257)),
    ("BGR-Float64", identity, BGR{Float64}.(rand(BGR{N0f8}, 127, 257))),
    ("BGRA-N0f8", identity, rand(BGRA{N0f8}, 127, 257)),
    ("BGRA-N0f16", identity, rand(BGRA{N0f16}, 127, 257)),
    ("BGRA-Float64", identity, BGRA{Float64}.(rand(BGRA{N0f8}, 127, 257))),
    ("ABGR-N0f8", identity, rand(ABGR{N0f8}, 127, 257)),
    ("ABGR-N0f16", identity, rand(ABGR{N0f16}, 127, 257)),
    ("ABGR-Float64", identity, ABGR{Float64}.(rand(ABGR{N0f8}, 127, 257))),
    ("ARGB-N0f8", identity, rand(ARGB{N0f8}, 127, 257)),
    ("ARGB-N0f16", identity, rand(ARGB{N0f16}, 127, 257)),
    ("ARGB-Float64", identity, ARGB{Float64}.(rand(ARGB{N0f8}, 127, 257))),
]
