function M=cascaded_source_photonic(Ns,eAs,eBs,eD,Pd,VisF)
% Author: Prajit Dhara
% Function to calculate the cascaded source's photonic state
% Inputs:
% Ns: mean photon number per mode of the cascaded source model
% eAs: out-coupling efficiency for Alice's side 
%   Allowed range: [0,1]
%   Typical value: 1-1e-4
% eBs: out-coupling efficiency for Bob's side 
%   Allowed range: [0,1]
%   Typical value: 1-1e-4
% eD: detector efficiency 
%   Allowed range: [0,1]
%   Typical value: 0.9
% Pd: dark click probability per photonic mode (Allowed range: [0,1))
%   Allowed range: [0,1)
%   Typical value: 1e-8
% VisF: visibility of the Franson interferometer (Allowed range: [0,1])
%   Allowed range: [0,1]
%   Typical value: 0.99
% Outputs:
% M: Output state density matrix of the cascaded source 
%    (in the Fock basis)
% Use 'cascaded_source_basis.m' to obtain the basis ordering

cf=@(Ns,n) sqrt((Ns.^n)./(Ns+1).^(n+1));

c0=cf(Ns,0);
c1=cf(Ns,1);
c2=cf(Ns,2);

M=[(1/4).*((-1)+Pd).^2.*(4.*c0.^8.*Pd.^2+4.*c1.^8.*((-1)+eAs) ...
  .^2.*((-1)+eBs).^2.*((-1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+ ...
  4.*c0.^6.*Pd.*(2.*c2.^2.*(2+(-2).*eAs+eAs.^2+(-2).*eBs+ ...
  eBs.^2).*((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2) ...
  +eAs+eBs).*((-2).*Pd+eD.*((-1)+3.*Pd)))+4.*c0.^2.*c1.^4.*(( ...
  -1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd)) ...
  .*(c1.^2.*((-2)+eAs+eBs).*((-1).*Pd+eD.*((-1)+2.*Pd))+ ...
  c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -3)+5.*Pd)))+c0.^4.*(8.*c2.^4.*((-1)+eAs).^2.*((-1)+eBs) ...
  .^2.*((-1)+eD).^2.*(4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+eD.^2.* ...
  (1+(-6).*Pd+7.*Pd.^2))+4.*c1.^2.*c2.^2.*((-1)+eAs).*((-1)+ ...
  eBs).*((-2)+eAs+eBs).*((-1)+eD).*(2.*eD.*(3+(-7).*Pd).*Pd+ ...
  4.*Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2))+c1.^4.*(4.*(6+ ...
  eAs.^2+(-6).*eBs+eBs.^2+eAs.*((-6)+4.*eBs)).*Pd.^2+(-4).*(6+ ...
  eAs.^2+(-6).*eBs+eBs.^2+eAs.*((-6)+4.*eBs)).*eD.*Pd.*((-1)+ ...
  3.*Pd)+eD.^2.*(4+eAs.^2.*(1+(-3).*Pd).^2+eBs.^2.*(1+(-3).* ...
  Pd).^2+(-32).*Pd+52.*Pd.^2+(-4).*eBs.*(1+(-8).*Pd+13.*Pd.^2) ...
  +2.*eAs.*((-2)+eBs+16.*Pd+(-10).*eBs.*Pd+(-26).*Pd.^2+17.* ...
  eBs.*Pd.^2))))),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0;0,(-1/4).*eBs.*((-1)+Pd).^2.*(4.* ...
  c1.^8.*((-1)+eAs).^2.*((-1)+eBs).*((-1)+eD).^2.*(eD+Pd+(-2) ...
  .*eD.*Pd).^2+2.*c0.^6.*Pd.*(4.*c2.^2.*((-1)+eBs).*((-1)+eD) ...
  .*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)))+2.*c0.^2.*c1.^4.*((-1)+eAs).*((-1)+eD).*((-2).*Pd+eD.* ...
  ((-1)+3.*Pd)).*(c1.^2.*((-3)+eAs+2.*eBs).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+2.*c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*(( ...
  -2).*Pd+eD.*((-3)+5.*Pd)))+c0.^4.*(8.*c2.^4.*((-1)+eAs).^2.* ...
  ((-1)+eBs).*((-1)+eD).^2.*(4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+ ...
  eD.^2.*(1+(-6).*Pd+7.*Pd.^2))+2.*c1.^2.*c2.^2.*((-1)+eAs).*( ...
  (-3)+eAs+2.*eBs).*((-1)+eD).*(2.*eD.*(3+(-7).*Pd).*Pd+4.* ...
  Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2))+c1.^4.*(4.*((-3)+2.* ...
  eAs+eBs).*Pd.^2+(-4).*((-3)+2.*eAs+eBs).*eD.*Pd.*((-1)+3.* ...
  Pd)+eD.^2.*((-2)+eBs.*(1+(-3).*Pd).^2+16.*Pd+(-26).*Pd.^2+ ...
  eAs.*(1+(-10).*Pd+17.*Pd.^2))))),0,0,0,0,(1/4).*c0.^2.* ...
  c1.^2.*eD.*((-1)+Pd).^3.*(2.*c0.^4.*eAs.^(1/2).*eBs.^(1/2).* ...
  Pd+(-4).*c0.^3.*c2.*((1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs) ...
  .*eAs).^(1/2).*eBs.^(1/2)+eAs.^(1/2).*(1+(-1).*eBs).^(1/2).* ...
  ((-1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*Pd+2.*c1.^4.*(( ...
  -1)+eAs).*eAs.^(1/2).*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*(( ...
  -1).*Pd+eD.*((-1)+2.*Pd))+(-2).*c0.*c1.^2.*c2.*((-1).*(1+( ...
  -1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*eBs.^(1/2) ...
  +(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).* ...
  eBs.^(3/2)+((-1)+eAs).*eAs.^(1/2).*(1+(-1).*eBs).^(1/2).*(( ...
  -1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -1)+3.*Pd))+c0.^2.*(8.*c2.^2.*(1+(-1).*eAs).^(1/2).*((-1).*( ...
  (-1)+eAs).*eAs).^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2).*((-1)+eD).^2.*Pd+c1.^2.*eAs.^(1/2).* ...
  eBs.^(1/2).*((-2)+eAs+eBs).*((-2).*Pd+eD.*((-1)+3.*Pd)))),0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;0,0, ...
  (1/4).*c0.^2.*c2.^2.*eBs.^2.*((-1)+eD).*((-1)+Pd).^2.*(4.* ...
  c0.^4.*Pd.*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^4.*((-1)+eAs) ...
  .^2.*((-1)+eD).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+ ...
  (-14).*Pd+15.*Pd.^2))+2.*c0.^2.*((-1)+eAs).*(2.*c2.^2.*((-1) ...
  +eAs).*((-1)+eD).*(4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+eD.^2.*( ...
  1+(-6).*Pd+7.*Pd.^2))+c1.^2.*(2.*eD.*(3+(-7).*Pd).*Pd+4.* ...
  Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2)))),0,0,0,0,(-1/2).*2.^( ...
  -1/2).*c0.^3.*c1.^2.*c2.*eBs.^(1/2).*(eBs.^2).^(1/2).*((-1)+ ...
  eD).*eD.*((-1)+Pd).^3.*(2.*c0.*(c0.*eAs.^(1/2)+(-2).*c2.*(1+ ...
  (-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD) ...
  ).*Pd+c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.* ...
  Pd))),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0;0,0,0,(-1/4).*eBs.*((-1)+Pd).^2.*(4.*c1.^8.*((-1)+eAs) ...
  .^2.*((-1)+eBs).*((-1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+2.* ...
  c0.^6.*Pd.*(4.*c2.^2.*((-1)+eBs).*((-1)+eD).*((-1).*Pd+eD.*( ...
  (-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)))+2.*c0.^2.* ...
  c1.^4.*((-1)+eAs).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd)).*( ...
  c1.^2.*((-3)+eAs+2.*eBs).*((-1).*Pd+eD.*((-1)+2.*Pd))+2.* ...
  c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -3)+5.*Pd)))+c0.^4.*(8.*c2.^4.*((-1)+eAs).^2.*((-1)+eBs).*(( ...
  -1)+eD).^2.*(4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+eD.^2.*(1+(-6) ...
  .*Pd+7.*Pd.^2))+2.*c1.^2.*c2.^2.*((-1)+eAs).*((-3)+eAs+2.* ...
  eBs).*((-1)+eD).*(2.*eD.*(3+(-7).*Pd).*Pd+4.*Pd.^2+eD.^2.*( ...
  1+(-8).*Pd+11.*Pd.^2))+c1.^4.*(4.*((-3)+2.*eAs+eBs).*Pd.^2+( ...
  -4).*((-3)+2.*eAs+eBs).*eD.*Pd.*((-1)+3.*Pd)+eD.^2.*((-2)+ ...
  eBs.*(1+(-3).*Pd).^2+16.*Pd+(-26).*Pd.^2+eAs.*(1+(-10).*Pd+ ...
  17.*Pd.^2))))),0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/4).*c0.^2.* ...
  c1.^2.*eD.*((-1)+Pd).^3.*(2.*c0.^4.*eAs.^(1/2).*eBs.^(1/2).* ...
  Pd+(-4).*c0.^3.*c2.*((1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs) ...
  .*eAs).^(1/2).*eBs.^(1/2)+eAs.^(1/2).*(1+(-1).*eBs).^(1/2).* ...
  ((-1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*Pd+2.*c1.^4.*(( ...
  -1)+eAs).*eAs.^(1/2).*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*(( ...
  -1).*Pd+eD.*((-1)+2.*Pd))+(-2).*c0.*c1.^2.*c2.*((-1).*(1+( ...
  -1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*eBs.^(1/2) ...
  +(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).* ...
  eBs.^(3/2)+((-1)+eAs).*eAs.^(1/2).*(1+(-1).*eBs).^(1/2).*(( ...
  -1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -1)+3.*Pd))+c0.^2.*(8.*c2.^2.*(1+(-1).*eAs).^(1/2).*((-1).*( ...
  (-1)+eAs).*eAs).^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2).*((-1)+eD).^2.*Pd+c1.^2.*eAs.^(1/2).* ...
  eBs.^(1/2).*((-2)+eAs+eBs).*((-2).*Pd+eD.*((-1)+3.*Pd)))),0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;0,0,0,0,(1/4).*c1.^4.* ...
  eBs.^2.*((-1)+Pd).^2.*(4.*c1.^4.*((-1)+eAs).^2.*((-1)+eD) ...
  .^2.*(eD+Pd+(-2).*eD.*Pd).^2+c0.^4.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)).^2+2.*c0.^2.*((-1)+eAs).*((-1)+eD).*((-2).*Pd+eD.*((-1) ...
  +3.*Pd)).*(c1.^2.*((-2).*Pd+eD.*((-2)+4.*Pd))+c2.^2.*((-1)+ ...
  eAs).*((-1)+eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,( ...
  -1/4).*c0.^2.*c1.^4.*eBs.^(3/2).*eD.*((-1)+Pd).^3.*(2.* ...
  c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+c0.^2.*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))+( ...
  -2).*c0.*c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,0, ...
  0,0,0,0,(-1/4).*c0.^2.*c1.^4.*eBs.^(3/2).*eD.*((-1)+Pd).^3.* ...
  (2.*c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.* ...
  ((-1)+2.*Pd))+c0.^2.*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd)) ...
  +(-2).*c0.*c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,( ...
  1/4).*c0.^4.*c1.^4.*eAs.*eBs.*eD.^2.*((-1)+Pd).^4.*VisF,0,0, ...
  0,0,0,0,0,0,0,0,0;0,0,0,0,0,(1/4).*c0.^2.*c2.^2.*eBs.^2.*(( ...
  -1)+eD).*((-1)+Pd).^2.*(4.*c0.^4.*Pd.*((-1).*Pd+eD.*((-1)+ ...
  2.*Pd))+c1.^4.*((-1)+eAs).^2.*((-1)+eD).*(8.*eD.*(1+(-2).* ...
  Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2))+2.*c0.^2.*( ...
  (-1)+eAs).*(2.*c2.^2.*((-1)+eAs).*((-1)+eD).*(4.*eD.*(1+(-2) ...
  .*Pd).*Pd+2.*Pd.^2+eD.^2.*(1+(-6).*Pd+7.*Pd.^2))+c1.^2.*(2.* ...
  eD.*(3+(-7).*Pd).*Pd+4.*Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2)) ...
  )),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(-1/2).*2.^(-1/2).*c0.^3.* ...
  c1.^2.*c2.*eBs.^(1/2).*(eBs.^2).^(1/2).*((-1)+eD).*eD.*((-1) ...
  +Pd).^3.*(2.*c0.*(c0.*eAs.^(1/2)+(-2).*c2.*(1+(-1).*eAs).^( ...
  1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD)).*Pd+c1.^2.* ...
  ((-1)+eAs).*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0;0,(1/4).*c0.^2.*c1.^2.*eD.*((-1)+Pd) ...
  .^3.*(2.*c0.^4.*eAs.^(1/2).*eBs.^(1/2).*Pd+(-4).*c0.^3.*c2.* ...
  ((1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).* ...
  eBs.^(1/2)+eAs.^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2)).*((-1)+eD).*Pd+2.*c1.^4.*((-1)+eAs).* ...
  eAs.^(1/2).*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*((-1).*Pd+ ...
  eD.*((-1)+2.*Pd))+(-2).*c0.*c1.^2.*c2.*((-1).*(1+(-1).*eAs) ...
  .^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*eBs.^(1/2)+(1+(-1) ...
  .*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*eBs.^(3/2)+(( ...
  -1)+eAs).*eAs.^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2)).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))+ ...
  c0.^2.*(8.*c2.^2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).* ...
  eAs).^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs) ...
  .^(1/2).*((-1)+eD).^2.*Pd+c1.^2.*eAs.^(1/2).*eBs.^(1/2).*(( ...
  -2)+eAs+eBs).*((-2).*Pd+eD.*((-1)+3.*Pd)))),0,0,0,0,(-1/4).* ...
  eAs.*((-1)+Pd).^2.*(4.*c1.^8.*((-1)+eAs).*((-1)+eBs).^2.*(( ...
  -1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+2.*c0.^6.*Pd.*(4.* ...
  c2.^2.*((-1)+eAs).*((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+ ...
  c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)))+2.*c0.^2.*c1.^4.*((-1)+ ...
  eBs).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd)).*(c1.^2.*((-3)+ ...
  2.*eAs+eBs).*((-1).*Pd+eD.*((-1)+2.*Pd))+2.*c2.^2.*((-1)+ ...
  eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))+ ...
  c0.^4.*(8.*c2.^4.*((-1)+eAs).*((-1)+eBs).^2.*((-1)+eD).^2.*( ...
  4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+eD.^2.*(1+(-6).*Pd+7.* ...
  Pd.^2))+2.*c1.^2.*c2.^2.*((-1)+eBs).*((-3)+2.*eAs+eBs).*(( ...
  -1)+eD).*(2.*eD.*(3+(-7).*Pd).*Pd+4.*Pd.^2+eD.^2.*(1+(-8).* ...
  Pd+11.*Pd.^2))+c1.^4.*(4.*((-3)+eAs+2.*eBs).*Pd.^2+(-4).*(( ...
  -3)+eAs+2.*eBs).*eD.*Pd.*((-1)+3.*Pd)+eD.^2.*((-2)+eBs+eAs.* ...
  (1+(-3).*Pd).^2+16.*Pd+(-10).*eBs.*Pd+(-26).*Pd.^2+17.*eBs.* ...
  Pd.^2)))),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0;0,0,(-1/2).*2.^(-1/2).*c0.^3.*c1.^2.*c2.*eBs.^(1/2) ...
  .*(eBs.^2).^(1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*(2.*c0.*( ...
  c0.*eAs.^(1/2)+(-2).*c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+ ...
  eAs).*eAs).^(1/2).*((-1)+eD)).*Pd+c1.^2.*((-1)+eAs).*eAs.^( ...
  1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,(1/2).*eAs.*eBs.* ...
  ((-1)+eD).*((-1)+Pd).^2.*(2.*c1.^8.*((-1)+eAs).*((-1)+eBs).* ...
  ((-1)+eD).*(eD+Pd+(-2).*eD.*Pd).^2+c0.^2.*c1.^4.*((-2).*Pd+ ...
  eD.*((-1)+3.*Pd)).*(c1.^2.*((-2)+eAs+eBs).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+2.*c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*(( ...
  -2).*Pd+eD.*((-3)+5.*Pd)))+2.*c0.^4.*Pd.*(c1.^4.*((-1).*Pd+ ...
  eD.*((-1)+2.*Pd))+4.*c2.^4.*((-1)+eAs).*((-1)+eBs).*((-1)+ ...
  eD).^2.*((-1).*Pd+eD.*((-2)+3.*Pd))+c1.^2.*c2.^2.*((-2)+eAs+ ...
  eBs).*((-1)+eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,( ...
  -1/2).*2.^(-1/2).*c0.^3.*c1.^2.*c2.*eAs.^(1/2).*(eAs.^2).^( ...
  1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*(2.*c0.*(c0.*eBs.^(1/2)+( ...
  -2).*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs).^( ...
  1/2).*((-1)+eD)).*Pd+c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-2).* ...
  Pd+eD.*((-1)+3.*Pd))),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0;0,0,0,0,0,0,0,0,(-1/4).*c0.^2.*c2.^2.*eAs.*eBs.^2.*( ...
  (-1)+eD).^2.*((-1)+Pd).^2.*(8.*c0.^2.*c2.^2.*((-1)+eAs).*(( ...
  -1)+eD).*Pd.*((-1).*Pd+eD.*((-2)+3.*Pd))+2.*c0.^2.*c1.^2.* ...
  Pd.*((-2).*Pd+eD.*((-3)+5.*Pd))+c1.^4.*((-1)+eAs).*(8.*eD.*( ...
  1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2))),0, ...
  0,0,0,c0.^4.*c1.^2.*c2.^2.*eAs.^(1/2).*(eAs.^2).^(1/2).* ...
  eBs.^(1/2).*(eBs.^2).^(1/2).*((-1)+eD).^2.*eD.*((-1)+Pd) ...
  .^3.*Pd,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;0,0,0,0, ...
  (-1/4).*c0.^2.*c1.^4.*eBs.^(3/2).*eD.*((-1)+Pd).^3.*(2.* ...
  c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+c0.^2.*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))+( ...
  -2).*c0.*c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,( ...
  1/4).*eAs.*eBs.*((-1)+Pd).^2.*(4.*c1.^8.*((-1)+eAs).*((-1)+ ...
  eBs).*((-1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+c0.^4.*(4.* ...
  c2.^2.*((-1)+eAs).*((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+ ...
  c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd))).*(4.*c2.^2.*((-1)+eBs).* ...
  ((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.* ...
  ((-1)+3.*Pd)))+2.*c0.^2.*c1.^4.*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -1)+3.*Pd)).*(c1.^2.*((-2)+eAs+eBs).*((-1).*Pd+eD.*((-1)+2.* ...
  Pd))+2.*c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+ ...
  eD.*((-3)+5.*Pd)))),0,0,0,0,0,0,0,0,0,(1/4).*c0.^2.*c1.^4.* ...
  eAs.^(1/2).*eBs.^(1/2).*(c0.*eAs.^(1/2)+(-4).*c2.*(1+(-1).* ...
  eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD)).*( ...
  c0.*eBs.^(1/2)+(-4).*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2).*((-1)+eD)).*eD.^2.*((-1)+Pd).^4.*VisF,0, ...
  0,0,0,(-1/4).*c0.^2.*c1.^4.*eAs.^(3/2).*eD.*((-1)+Pd).^3.*( ...
  2.*c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.*( ...
  (-1)+2.*Pd))+c0.^2.*eBs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))+ ...
  (-2).*c0.*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,0, ...
  0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,(-1/2).*c1.^4.*eAs.*eBs.^2.* ...
  ((-1)+eD).*((-1)+Pd).^2.*(2.*c1.^4.*((-1)+eAs).*((-1)+eD).*( ...
  eD+Pd+(-2).*eD.*Pd).^2+c0.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)).*( ...
  c1.^2.*((-1).*Pd+eD.*((-1)+2.*Pd))+c2.^2.*((-1)+eAs).*((-1)+ ...
  eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,(1/2).*2.^(-1/2) ...
  .*c0.^3.*c1.^4.*c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(3/2) ...
  .*((-1)+eD).*eD.*((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.*Pd)), ...
  0,0,0,0,(1/2).*2.^(-1/2).*c0.^2.*c1.^4.*c2.*eAs.^(1/2).* ...
  eBs.*(eBs.^2).^(1/2).*((-1).*c0.*eAs.^(1/2)+4.*c2.*(1+(-1).* ...
  eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD)).*(( ...
  -1)+eD).*eD.^2.*((-1)+Pd).^4,0,0,0,0,(1/2).*c0.^2.*c1.^6.* ...
  eAs.^(3/2).*eBs.^(3/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*((-1).* ...
  Pd+eD.*((-1)+2.*Pd)),0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0, ...
  0,0,(-1/4).*c0.^2.*c2.^2.*eAs.*eBs.^2.*((-1)+eD).*((-1)+Pd) ...
  .^2.*(c1.^4.*((-1)+eAs).*((-1)+eD).*(8.*eD.*(1+(-2).*Pd).* ...
  Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2))+2.*c0.^2.*((-1) ...
  .*Pd+eD.*((-1)+2.*Pd)).*(4.*c2.^2.*((-1)+eAs).*((-1)+eD).*(( ...
  -1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)) ...
  )),0,0,0,0,0,0,0,0,0,0,(1/2).*2.^(-1/2).*c0.^2.*c1.^4.*c2.* ...
  eAs.^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1).*c0.*eAs.^(1/2)+4.* ...
  c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*(( ...
  -1)+eD)).*((-1)+eD).*eD.^2.*((-1)+Pd).^4,0,0,0,0,(1/2).*2.^( ...
  -1/2).*c0.^3.*c1.^4.*c2.*eAs.^(3/2).*eBs.^(1/2).*(eBs.^2).^( ...
  1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)),0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,(-1/2).*2.^(-1/2).* ...
  c0.^3.*c1.^2.*c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*((-1)+eD).* ...
  eD.*((-1)+Pd).^3.*(2.*c0.*(c0.*eBs.^(1/2)+(-2).*c2.*(1+(-1) ...
  .*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs).^(1/2).*((-1)+eD)).* ...
  Pd+c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd) ...
  )),0,0,0,0,(1/4).*c0.^2.*c2.^2.*eAs.^2.*((-1)+eD).*((-1)+Pd) ...
  .^2.*(4.*c0.^4.*Pd.*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^4.*((-1) ...
  +eBs).^2.*((-1)+eD).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+ ...
  eD.^2.*(3+(-14).*Pd+15.*Pd.^2))+2.*c0.^2.*((-1)+eBs).*(2.* ...
  c2.^2.*((-1)+eBs).*((-1)+eD).*(4.*eD.*(1+(-2).*Pd).*Pd+2.* ...
  Pd.^2+eD.^2.*(1+(-6).*Pd+7.*Pd.^2))+c1.^2.*(2.*eD.*(3+(-7).* ...
  Pd).*Pd+4.*Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2)))),0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,c0.^4.* ...
  c1.^2.*c2.^2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(1/2).*( ...
  eBs.^2).^(1/2).*((-1)+eD).^2.*eD.*((-1)+Pd).^3.*Pd,0,0,0,0,( ...
  -1/4).*c0.^2.*c2.^2.*eAs.^2.*eBs.*((-1)+eD).^2.*((-1)+Pd) ...
  .^2.*(8.*c0.^2.*c2.^2.*((-1)+eBs).*((-1)+eD).*Pd.*((-1).*Pd+ ...
  eD.*((-2)+3.*Pd))+2.*c0.^2.*c1.^2.*Pd.*((-2).*Pd+eD.*((-3)+ ...
  5.*Pd))+c1.^4.*((-1)+eBs).*(8.*eD.*(1+(-2).*Pd).*Pd+4.* ...
  Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2))),0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,c0.^4.* ...
  c2.^4.*eAs.^2.*eBs.^2.*((-1)+eD).^3.*((-1)+Pd).^2.*Pd.*((-1) ...
  .*Pd+eD.*((-2)+3.*Pd)),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0;0,0,0,0,0,0,0,0,0,0,(1/2).*2.^(-1/2).*c0.^3.*c1.^4.* ...
  c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(3/2).*((-1)+eD).*eD.* ...
  ((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.*Pd)),0,0,0,0,(-1/4).* ...
  c0.^2.*c2.^2.*eAs.^2.*eBs.*((-1)+eD).*((-1)+Pd).^2.*(c1.^4.* ...
  ((-1)+eBs).*((-1)+eD).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+ ...
  eD.^2.*(3+(-14).*Pd+15.*Pd.^2))+2.*c0.^2.*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd)).*(4.*c2.^2.*((-1)+eBs).*((-1)+eD).*((-1).*Pd+ ...
  eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)))),0,0, ...
  0,0,0,0,0,0,0,(1/2).*2.^(-1/2).*c0.^2.*c1.^4.*c2.*eAs.*( ...
  eAs.^2).^(1/2).*eBs.^(1/2).*((-1).*c0.*eBs.^(1/2)+4.*c2.*(1+ ...
  (-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs).^(1/2).*((-1)+eD) ...
  ).*((-1)+eD).*eD.^2.*((-1)+Pd).^4,0,0,0,0,0,0,0,0,0,0;0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,(1/4).*c0.^2.*c1.^4.*c2.^2.* ...
  eAs.^2.*eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*(8.*eD.*(1+(-2) ...
  .*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2)),0,0,0,0, ...
  0,0,0,0,0,(1/2).*c0.^2.*c1.^4.*c2.^2.*eAs.*(eAs.^2).^(1/2).* ...
  eBs.*(eBs.^2).^(1/2).*((-1)+eD).^2.*eD.^2.*((-1)+Pd).^4,0,0, ...
  0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,c0.^4.* ...
  c2.^4.*eAs.^2.*eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*(eD+Pd+( ...
  -2).*eD.*Pd).^2,0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^4.* ...
  c2.^2.*eAs.*(eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD) ...
  .^2.*eD.^2.*((-1)+Pd).^4,0,0,0,0,0,0,0;0,0,0,(1/4).*c0.^2.* ...
  c1.^2.*eD.*((-1)+Pd).^3.*(2.*c0.^4.*eAs.^(1/2).*eBs.^(1/2).* ...
  Pd+(-4).*c0.^3.*c2.*((1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs) ...
  .*eAs).^(1/2).*eBs.^(1/2)+eAs.^(1/2).*(1+(-1).*eBs).^(1/2).* ...
  ((-1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*Pd+2.*c1.^4.*(( ...
  -1)+eAs).*eAs.^(1/2).*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*(( ...
  -1).*Pd+eD.*((-1)+2.*Pd))+(-2).*c0.*c1.^2.*c2.*((-1).*(1+( ...
  -1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*eBs.^(1/2) ...
  +(1+(-1).*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).* ...
  eBs.^(3/2)+((-1)+eAs).*eAs.^(1/2).*(1+(-1).*eBs).^(1/2).*(( ...
  -1).*((-1)+eBs).*eBs).^(1/2)).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -1)+3.*Pd))+c0.^2.*(8.*c2.^2.*(1+(-1).*eAs).^(1/2).*((-1).*( ...
  (-1)+eAs).*eAs).^(1/2).*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2).*((-1)+eD).^2.*Pd+c1.^2.*eAs.^(1/2).* ...
  eBs.^(1/2).*((-2)+eAs+eBs).*((-2).*Pd+eD.*((-1)+3.*Pd)))),0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,(-1/4).*eAs.*((-1)+Pd).^2.*(4.* ...
  c1.^8.*((-1)+eAs).*((-1)+eBs).^2.*((-1)+eD).^2.*(eD+Pd+(-2) ...
  .*eD.*Pd).^2+2.*c0.^6.*Pd.*(4.*c2.^2.*((-1)+eAs).*((-1)+eD) ...
  .*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)))+2.*c0.^2.*c1.^4.*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.* ...
  ((-1)+3.*Pd)).*(c1.^2.*((-3)+2.*eAs+eBs).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+2.*c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*(( ...
  -2).*Pd+eD.*((-3)+5.*Pd)))+c0.^4.*(8.*c2.^4.*((-1)+eAs).*(( ...
  -1)+eBs).^2.*((-1)+eD).^2.*(4.*eD.*(1+(-2).*Pd).*Pd+2.* ...
  Pd.^2+eD.^2.*(1+(-6).*Pd+7.*Pd.^2))+2.*c1.^2.*c2.^2.*((-1)+ ...
  eBs).*((-3)+2.*eAs+eBs).*((-1)+eD).*(2.*eD.*(3+(-7).*Pd).* ...
  Pd+4.*Pd.^2+eD.^2.*(1+(-8).*Pd+11.*Pd.^2))+c1.^4.*(4.*((-3)+ ...
  eAs+2.*eBs).*Pd.^2+(-4).*((-3)+eAs+2.*eBs).*eD.*Pd.*((-1)+ ...
  3.*Pd)+eD.^2.*((-2)+eBs+eAs.*(1+(-3).*Pd).^2+16.*Pd+(-10).* ...
  eBs.*Pd+(-26).*Pd.^2+17.*eBs.*Pd.^2)))),0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0;0,0,0,0,(-1/4).*c0.^2.*c1.^4.*eBs.^(3/2).*eD.* ...
  ((-1)+Pd).^3.*(2.*c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-1)+eD).* ...
  ((-1).*Pd+eD.*((-1)+2.*Pd))+c0.^2.*eAs.^(1/2).*((-2).*Pd+ ...
  eD.*((-1)+3.*Pd))+(-2).*c0.*c2.*(1+(-1).*eAs).^(1/2).*((-1) ...
  .*((-1)+eAs).*eAs).^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+ ...
  3.*Pd))),0,0,0,0,(1/4).*c0.^2.*c1.^4.*eAs.^(1/2).*eBs.^(1/2) ...
  .*(c0.*eAs.^(1/2)+(-4).*c2.*(1+(-1).*eAs).^(1/2).*((-1).*(( ...
  -1)+eAs).*eAs).^(1/2).*((-1)+eD)).*(c0.*eBs.^(1/2)+(-4).* ...
  c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs).^(1/2).*(( ...
  -1)+eD)).*eD.^2.*((-1)+Pd).^4.*VisF,0,0,0,0,0,0,0,0,0,(1/4) ...
  .*eAs.*eBs.*((-1)+Pd).^2.*(4.*c1.^8.*((-1)+eAs).*((-1)+eBs) ...
  .*((-1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+c0.^4.*(4.*c2.^2.*(( ...
  -1)+eAs).*((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*(( ...
  -2).*Pd+eD.*((-1)+3.*Pd))).*(4.*c2.^2.*((-1)+eBs).*((-1)+eD) ...
  .*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)))+2.*c0.^2.*c1.^4.*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd) ...
  ).*(c1.^2.*((-2)+eAs+eBs).*((-1).*Pd+eD.*((-1)+2.*Pd))+2.* ...
  c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*(( ...
  -3)+5.*Pd)))),0,0,0,0,(-1/4).*c0.^2.*c1.^4.*eAs.^(3/2).*eD.* ...
  ((-1)+Pd).^3.*(2.*c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).* ...
  ((-1).*Pd+eD.*((-1)+2.*Pd))+c0.^2.*eBs.^(1/2).*((-2).*Pd+ ...
  eD.*((-1)+3.*Pd))+(-2).*c0.*c2.*(1+(-1).*eBs).^(1/2).*((-1) ...
  .*((-1)+eBs).*eBs).^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+ ...
  3.*Pd))),0,0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,(1/2).* ...
  2.^(-1/2).*c0.^2.*c1.^4.*c2.*eAs.^(1/2).*eBs.*(eBs.^2).^( ...
  1/2).*((-1).*c0.*eAs.^(1/2)+4.*c2.*(1+(-1).*eAs).^(1/2).*(( ...
  -1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD)).*((-1)+eD).*eD.^2.* ...
  ((-1)+Pd).^4,0,0,0,0,0,0,0,0,0,(-1/4).*c0.^2.*c2.^2.*eAs.* ...
  eBs.^2.*((-1)+eD).*((-1)+Pd).^2.*(c1.^4.*((-1)+eAs).*((-1)+ ...
  eD).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+ ...
  15.*Pd.^2))+2.*c0.^2.*((-1).*Pd+eD.*((-1)+2.*Pd)).*(4.* ...
  c2.^2.*((-1)+eAs).*((-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+ ...
  c1.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)))),0,0,0,0,(1/2).*2.^( ...
  -1/2).*c0.^3.*c1.^4.*c2.*eAs.^(3/2).*eBs.^(1/2).*(eBs.^2).^( ...
  1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)),0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,(-1/2).*2.^(-1/2).* ...
  c0.^3.*c1.^2.*c2.*eBs.^(1/2).*(eBs.^2).^(1/2).*((-1)+eD).* ...
  eD.*((-1)+Pd).^3.*(2.*c0.*(c0.*eAs.^(1/2)+(-2).*c2.*(1+(-1) ...
  .*eAs).^(1/2).*((-1).*((-1)+eAs).*eAs).^(1/2).*((-1)+eD)).* ...
  Pd+c1.^2.*((-1)+eAs).*eAs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd) ...
  )),0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2).*eAs.*eBs.*((-1)+eD) ...
  .*((-1)+Pd).^2.*(2.*c1.^8.*((-1)+eAs).*((-1)+eBs).*((-1)+eD) ...
  .*(eD+Pd+(-2).*eD.*Pd).^2+c0.^2.*c1.^4.*((-2).*Pd+eD.*((-1)+ ...
  3.*Pd)).*(c1.^2.*((-2)+eAs+eBs).*((-1).*Pd+eD.*((-1)+2.*Pd)) ...
  +2.*c2.^2.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.* ...
  ((-3)+5.*Pd)))+2.*c0.^4.*Pd.*(c1.^4.*((-1).*Pd+eD.*((-1)+2.* ...
  Pd))+4.*c2.^4.*((-1)+eAs).*((-1)+eBs).*((-1)+eD).^2.*((-1).* ...
  Pd+eD.*((-2)+3.*Pd))+c1.^2.*c2.^2.*((-2)+eAs+eBs).*((-1)+eD) ...
  .*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,0,0,0,0,(-1/2).*2.^( ...
  -1/2).*c0.^3.*c1.^2.*c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*((-1)+ ...
  eD).*eD.*((-1)+Pd).^3.*(2.*c0.*(c0.*eBs.^(1/2)+(-2).*c2.*(1+ ...
  (-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs).^(1/2).*((-1)+eD) ...
  ).*Pd+c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-2).*Pd+eD.*((-1)+3.* ...
  Pd))),0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,(1/2).*2.^(-1/2).* ...
  c0.^2.*c1.^4.*c2.*eAs.^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1).* ...
  c0.*eAs.^(1/2)+4.*c2.*(1+(-1).*eAs).^(1/2).*((-1).*((-1)+ ...
  eAs).*eAs).^(1/2).*((-1)+eD)).*((-1)+eD).*eD.^2.*((-1)+Pd) ...
  .^4,0,0,0,0,0,0,0,0,0,0,(-1/2).*c1.^4.*eAs.*eBs.^2.*((-1)+ ...
  eD).*((-1)+Pd).^2.*(2.*c1.^4.*((-1)+eAs).*((-1)+eD).*(eD+Pd+ ...
  (-2).*eD.*Pd).^2+c0.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)).*( ...
  c1.^2.*((-1).*Pd+eD.*((-1)+2.*Pd))+c2.^2.*((-1)+eAs).*((-1)+ ...
  eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,(1/2).*c0.^2.* ...
  c1.^6.*eAs.^(3/2).*eBs.^(3/2).*((-1)+eD).*eD.*((-1)+Pd).^3.* ...
  ((-1).*Pd+eD.*((-1)+2.*Pd)),0,0,0,(1/2).*2.^(-1/2).*c0.^3.* ...
  c1.^4.*c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(3/2).*((-1)+ ...
  eD).*eD.*((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.*Pd)),0,0,0,0; ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(-1/4).* ...
  c0.^2.*c2.^2.*eAs.*eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*(8.* ...
  c0.^2.*c2.^2.*((-1)+eAs).*((-1)+eD).*Pd.*((-1).*Pd+eD.*((-2) ...
  +3.*Pd))+2.*c0.^2.*c1.^2.*Pd.*((-2).*Pd+eD.*((-3)+5.*Pd))+ ...
  c1.^4.*((-1)+eAs).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.* ...
  (3+(-14).*Pd+15.*Pd.^2))),0,0,0,0,0,0,0,0,0,c0.^4.*c1.^2.* ...
  c2.^2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(1/2).*(eBs.^2).^( ...
  1/2).*((-1)+eD).^2.*eD.*((-1)+Pd).^3.*Pd,0,0;0,0,0,0,(1/4).* ...
  c0.^4.*c1.^4.*eAs.*eBs.*eD.^2.*((-1)+Pd).^4.*VisF,0,0,0,0,( ...
  -1/4).*c0.^2.*c1.^4.*eAs.^(3/2).*eD.*((-1)+Pd).^3.*(2.* ...
  c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.*(( ...
  -1)+2.*Pd))+c0.^2.*eBs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd))+( ...
  -2).*c0.*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,0, ...
  0,0,0,0,(-1/4).*c0.^2.*c1.^4.*eAs.^(3/2).*eD.*((-1)+Pd).^3.* ...
  (2.*c1.^2.*((-1)+eBs).*eBs.^(1/2).*((-1)+eD).*((-1).*Pd+eD.* ...
  ((-1)+2.*Pd))+c0.^2.*eBs.^(1/2).*((-2).*Pd+eD.*((-1)+3.*Pd)) ...
  +(-2).*c0.*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).*eBs) ...
  .^(1/2).*((-1)+eD).*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,( ...
  1/4).*c1.^4.*eAs.^2.*((-1)+Pd).^2.*(4.*c1.^4.*((-1)+eBs) ...
  .^2.*((-1)+eD).^2.*(eD+Pd+(-2).*eD.*Pd).^2+c0.^4.*((-2).*Pd+ ...
  eD.*((-1)+3.*Pd)).^2+2.*c0.^2.*((-1)+eBs).*((-1)+eD).*((-2) ...
  .*Pd+eD.*((-1)+3.*Pd)).*(c1.^2.*((-2).*Pd+eD.*((-2)+4.*Pd))+ ...
  c2.^2.*((-1)+eBs).*((-1)+eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))), ...
  0,0,0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.* ...
  c1.^6.*eAs.^(3/2).*eBs.^(3/2).*((-1)+eD).*eD.*((-1)+Pd).^3.* ...
  ((-1).*Pd+eD.*((-1)+2.*Pd)),0,0,0,0,(1/2).*2.^(-1/2).* ...
  c0.^2.*c1.^4.*c2.*eAs.*(eAs.^2).^(1/2).*eBs.^(1/2).*((-1).* ...
  c0.*eBs.^(1/2)+4.*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+ ...
  eBs).*eBs).^(1/2).*((-1)+eD)).*((-1)+eD).*eD.^2.*((-1)+Pd) ...
  .^4,0,0,0,0,(1/2).*2.^(-1/2).*c0.^3.*c1.^4.*c2.*eAs.^(3/2).* ...
  eBs.^(1/2).*(eBs.^2).^(1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*(( ...
  -2).*Pd+eD.*((-1)+3.*Pd)),0,0,0,0,(-1/2).*c1.^4.*eAs.^2.* ...
  eBs.*((-1)+eD).*((-1)+Pd).^2.*(2.*c1.^4.*((-1)+eBs).*((-1)+ ...
  eD).*(eD+Pd+(-2).*eD.*Pd).^2+c0.^2.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)).*(c1.^2.*((-1).*Pd+eD.*((-1)+2.*Pd))+c2.^2.*((-1)+eBs) ...
  .*((-1)+eD).*((-2).*Pd+eD.*((-3)+5.*Pd)))),0,0,0,0,0,0,0,0, ...
  0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^4.* ...
  c2.^2.*eAs.*(eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD) ...
  .^2.*eD.^2.*((-1)+Pd).^4,0,0,0,0,0,0,0,0,0,(1/4).*c0.^2.* ...
  c1.^4.*c2.^2.*eAs.^2.*eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*( ...
  8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.* ...
  Pd.^2)),0,0,0,0,0,0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,(1/2).*2.^( ...
  -1/2).*c0.^3.*c1.^4.*c2.*eAs.^(3/2).*eBs.^(1/2).*(eBs.^2).^( ...
  1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.* ...
  Pd)),0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^6.*eAs.^(3/2).* ...
  eBs.^(3/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*((-1).*Pd+eD.*((-1) ...
  +2.*Pd)),0,0,0,0,(-1/2).*c1.^4.*eAs.^2.*eBs.*((-1)+eD).*(( ...
  -1)+Pd).^2.*(2.*c1.^4.*((-1)+eBs).*((-1)+eD).*(eD+Pd+(-2).* ...
  eD.*Pd).^2+c0.^2.*((-2).*Pd+eD.*((-1)+3.*Pd)).*(c1.^2.*((-1) ...
  .*Pd+eD.*((-1)+2.*Pd))+c2.^2.*((-1)+eBs).*((-1)+eD).*((-2).* ...
  Pd+eD.*((-3)+5.*Pd)))),0,0,0,(1/2).*2.^(-1/2).*c0.^2.* ...
  c1.^4.*c2.*eAs.*(eAs.^2).^(1/2).*eBs.^(1/2).*((-1).*c0.* ...
  eBs.^(1/2)+4.*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs).* ...
  eBs).^(1/2).*((-1)+eD)).*((-1)+eD).*eD.^2.*((-1)+Pd).^4,0,0, ...
  0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^4.* ...
  c2.^2.*eAs.*(eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD) ...
  .^2.*eD.^2.*((-1)+Pd).^4,0,0,0,0,0,0,0,0,0,0,c1.^8.*eAs.^2.* ...
  eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*(eD+Pd+(-2).*eD.*Pd).^2, ...
  0,0,0,(1/2).*c0.^2.*c1.^4.*c2.^2.*eAs.*(eAs.^2).^(1/2).* ...
  eBs.*(eBs.^2).^(1/2).*((-1)+eD).^2.*eD.^2.*((-1)+Pd).^4,0,0, ...
  0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  (1/4).*c0.^2.*c1.^4.*c2.^2.*eAs.^2.*eBs.^2.*((-1)+eD).^2.*(( ...
  -1)+Pd).^2.*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+( ...
  -14).*Pd+15.*Pd.^2)),0,0,0,0,(1/2).*c0.^2.*c1.^4.*c2.^2.* ...
  eAs.*(eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD).^2.* ...
  eD.^2.*((-1)+Pd).^4,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,(-1/2).*2.^(-1/2).*c0.^3.*c1.^2.*c2.*eAs.^(1/2).*( ...
  eAs.^2).^(1/2).*((-1)+eD).*eD.*((-1)+Pd).^3.*(2.*c0.*(c0.* ...
  eBs.^(1/2)+(-2).*c2.*(1+(-1).*eBs).^(1/2).*((-1).*((-1)+eBs) ...
  .*eBs).^(1/2).*((-1)+eD)).*Pd+c1.^2.*((-1)+eBs).*eBs.^(1/2) ...
  .*((-2).*Pd+eD.*((-1)+3.*Pd))),0,0,0,0,0,0,0,0,(1/4).* ...
  c0.^2.*c2.^2.*eAs.^2.*((-1)+eD).*((-1)+Pd).^2.*(4.*c0.^4.* ...
  Pd.*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^4.*((-1)+eBs).^2.*((-1)+ ...
  eD).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+ ...
  15.*Pd.^2))+2.*c0.^2.*((-1)+eBs).*(2.*c2.^2.*((-1)+eBs).*(( ...
  -1)+eD).*(4.*eD.*(1+(-2).*Pd).*Pd+2.*Pd.^2+eD.^2.*(1+(-6).* ...
  Pd+7.*Pd.^2))+c1.^2.*(2.*eD.*(3+(-7).*Pd).*Pd+4.*Pd.^2+ ...
  eD.^2.*(1+(-8).*Pd+11.*Pd.^2)))),0,0,0,0,0;0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2).*2.^(-1/2).*c0.^3.*c1.^4.* ...
  c2.*eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(3/2).*((-1)+eD).*eD.* ...
  ((-1)+Pd).^3.*((-2).*Pd+eD.*((-1)+3.*Pd)),0,0,0,0,(1/2).* ...
  2.^(-1/2).*c0.^2.*c1.^4.*c2.*eAs.*(eAs.^2).^(1/2).*eBs.^( ...
  1/2).*((-1).*c0.*eBs.^(1/2)+4.*c2.*(1+(-1).*eBs).^(1/2).*(( ...
  -1).*((-1)+eBs).*eBs).^(1/2).*((-1)+eD)).*((-1)+eD).*eD.^2.* ...
  ((-1)+Pd).^4,0,0,0,(-1/4).*c0.^2.*c2.^2.*eAs.^2.*eBs.*((-1)+ ...
  eD).*((-1)+Pd).^2.*(c1.^4.*((-1)+eBs).*((-1)+eD).*(8.*eD.*( ...
  1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2))+2.* ...
  c0.^2.*((-1).*Pd+eD.*((-1)+2.*Pd)).*(4.*c2.^2.*((-1)+eBs).*( ...
  (-1)+eD).*((-1).*Pd+eD.*((-1)+2.*Pd))+c1.^2.*((-2).*Pd+eD.*( ...
  (-1)+3.*Pd)))),0,0,0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^4.*c2.^2.*eAs.*( ...
  eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD).^2.*eD.^2.*( ...
  (-1)+Pd).^4,0,0,0,c0.^4.*c2.^4.*eAs.^2.*eBs.^2.*((-1)+eD) ...
  .^2.*((-1)+Pd).^2.*(eD+Pd+(-2).*eD.*Pd).^2,0,0,0;0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,c0.^4.*c1.^2.*c2.^2.* ...
  eAs.^(1/2).*(eAs.^2).^(1/2).*eBs.^(1/2).*(eBs.^2).^(1/2).*(( ...
  -1)+eD).^2.*eD.*((-1)+Pd).^3.*Pd,0,0,0,0,0,0,0,0,0,(-1/4).* ...
  c0.^2.*c2.^2.*eAs.^2.*eBs.*((-1)+eD).^2.*((-1)+Pd).^2.*(8.* ...
  c0.^2.*c2.^2.*((-1)+eBs).*((-1)+eD).*Pd.*((-1).*Pd+eD.*((-2) ...
  +3.*Pd))+2.*c0.^2.*c1.^2.*Pd.*((-2).*Pd+eD.*((-3)+5.*Pd))+ ...
  c1.^4.*((-1)+eBs).*(8.*eD.*(1+(-2).*Pd).*Pd+4.*Pd.^2+eD.^2.* ...
  (3+(-14).*Pd+15.*Pd.^2))),0,0;0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,(1/2).*c0.^2.*c1.^4.*c2.^2.* ...
  eAs.*(eAs.^2).^(1/2).*eBs.*(eBs.^2).^(1/2).*((-1)+eD).^2.* ...
  eD.^2.*((-1)+Pd).^4,0,0,0,0,(1/4).*c0.^2.*c1.^4.*c2.^2.* ...
  eAs.^2.*eBs.^2.*((-1)+eD).^2.*((-1)+Pd).^2.*(8.*eD.*(1+(-2) ...
  .*Pd).*Pd+4.*Pd.^2+eD.^2.*(3+(-14).*Pd+15.*Pd.^2)),0;0,0,0, ...
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, ...
  0,0,c0.^4.*c2.^4.*eAs.^2.*eBs.^2.*((-1)+eD).^3.*((-1)+Pd) ...
  .^2.*Pd.*((-1).*Pd+eD.*((-2)+3.*Pd))];
