# RandomNumbers.jl Documentation

**RandomNumbers.jl** is a collection of Random Number Generators for the Julia language.

There are several kinds of RNG families in this package, provided as submodules.

The examples and detailed descriptions of each RNG can be found on the Manual pages.

## Manual Outline
```@contents
Pages = [
    "man/basics.md",
    "man/benchmark.md",
    "man/pcg.md",
    "man/mersenne-twisters.md",
    "man/random123.md",
    "man/xorshifts.md",
    "man/ref.md",
]
Depth = 2
```

## Library Outline
```@contents
Pages = [
    "lib/random-numbers.md",
    "lib/pcg.md",
    "lib/mersenne-twisters.md",
    "lib/random123.md",
    "lib/xorshifts.md",
]
Depth = 2
```
