module libffmpeg

using FFMPEG
export FFMPEG

const intptr_t = UInt
const time_t = Int

const AV_NOPTS_VALUE = 0x8000000000000000 % Int64
AV_VERSION_INT(a, b, c) = (a << 16 | b << 8) | c
AV_VERSION(a, b, c) = nothing
const AVPROBE_SCORE_MAX = 100
MKTAG(a, b, c, d) = (UInt32(a) | (UInt32(b) << 8) | (UInt32(c) << 16) | UInt32(d) << 24)
FFERRTAG(a, b, c, d) = -MKTAG(a, b, c, d)
macro AV_PIX_FMT_NE(be, le)
    return Symbol("AV_PIX_FMT_" * string(le))
end


mutable struct AVBuffer end

mutable struct AVBufferPool end

mutable struct AVDictionary end

mutable struct AVContainerFifo end

const VdpChromaType = UInt32

const VdpDevice = UInt32

const VdpDecoder = UInt32

# typedef VdpStatus VdpDecoderRender ( VdpDecoder decoder , VdpVideoSurface target , VdpPictureInfo const * picture_info , uint32_t bitstream_buffer_count , VdpBitstreamBuffer const * bitstream_buffers )
const VdpDecoderRender = Cvoid

# typedef VdpStatus VdpGetProcAddress ( VdpDevice device , VdpFuncId function_id , /* output parameters follow */ void * * function_pointer )
const VdpGetProcAddress = Cvoid

mutable struct AVIODirContext end

mutable struct AVFilterPad end

mutable struct AVFilterFormats end

mutable struct AVFilterChannelLayouts end

mutable struct _cl_device_id end

const cl_device_id = Ptr{_cl_device_id}

mutable struct _cl_context end

const cl_context = Ptr{_cl_context}

mutable struct _cl_command_queue end

const cl_command_queue = Ptr{_cl_command_queue}

mutable struct _cl_mem end

const cl_mem = Ptr{_cl_mem}

const VADisplay = Ptr{Cvoid}

const VAGenericID = Cuint

const VAConfigID = VAGenericID

const VASurfaceID = VAGenericID

const VAGenericValueType = UInt32
const VAGenericValueTypeInteger = 1 % UInt32
const VAGenericValueTypeFloat = 2 % UInt32
const VAGenericValueTypePointer = 3 % UInt32
const VAGenericValueTypeFunc = 4 % UInt32

# typedef void ( * VAGenericFunc ) ( void )
const VAGenericFunc = Ptr{Cvoid}

struct __JL_Ctag_92
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{__JL_Ctag_92}, f::Symbol)
    f === :i && return Ptr{Int32}(x + 0)
    f === :f && return Ptr{Cfloat}(x + 0)
    f === :p && return Ptr{Ptr{Cvoid}}(x + 0)
    f === :fn && return Ptr{VAGenericFunc}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_92, f::Symbol)
    r = Ref{__JL_Ctag_92}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_92}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_92}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::__JL_Ctag_92, private::Bool = false)
    (:i, :f, :p, :fn, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct _VAGenericValue
    data::NTuple{16, UInt8}
end

function Base.getproperty(x::Ptr{_VAGenericValue}, f::Symbol)
    f === :type && return Ptr{VAGenericValueType}(x + 0)
    f === :value && return Ptr{__JL_Ctag_92}(x + 8)
    return getfield(x, f)
end

function Base.getproperty(x::_VAGenericValue, f::Symbol)
    r = Ref{_VAGenericValue}(x)
    ptr = Base.unsafe_convert(Ptr{_VAGenericValue}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{_VAGenericValue}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::_VAGenericValue, private::Bool = false)
    (:type, :value, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

const VAGenericValue = _VAGenericValue

const VASurfaceAttribType = UInt32
const VASurfaceAttribNone = 0 % UInt32
const VASurfaceAttribPixelFormat = 1 % UInt32
const VASurfaceAttribMinWidth = 2 % UInt32
const VASurfaceAttribMaxWidth = 3 % UInt32
const VASurfaceAttribMinHeight = 4 % UInt32
const VASurfaceAttribMaxHeight = 5 % UInt32
const VASurfaceAttribMemoryType = 6 % UInt32
const VASurfaceAttribExternalBufferDescriptor = 7 % UInt32
const VASurfaceAttribUsageHint = 8 % UInt32
const VASurfaceAttribDRMFormatModifiers = 9 % UInt32
const VASurfaceAttribAlignmentSize = 10 % UInt32
const VASurfaceAttribCount = 11 % UInt32

struct _VASurfaceAttrib
    data::NTuple{24, UInt8}
end

function Base.getproperty(x::Ptr{_VASurfaceAttrib}, f::Symbol)
    f === :type && return Ptr{VASurfaceAttribType}(x + 0)
    f === :flags && return Ptr{UInt32}(x + 4)
    f === :value && return Ptr{VAGenericValue}(x + 8)
    return getfield(x, f)
end

function Base.getproperty(x::_VASurfaceAttrib, f::Symbol)
    r = Ref{_VASurfaceAttrib}(x)
    ptr = Base.unsafe_convert(Ptr{_VASurfaceAttrib}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{_VASurfaceAttrib}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::_VASurfaceAttrib, private::Bool = false)
    (:type, :flags, :value, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

const VASurfaceAttrib = _VASurfaceAttrib

"""
    av_ac3_parse_header(buf, size::Csize_t, bitstream_id, frame_size)

Extract the bitstream ID and the frame size from AC-3 data.
"""
function av_ac3_parse_header(buf, size::Csize_t, bitstream_id, frame_size)
    ccall((:av_ac3_parse_header, libavcodec), Cint, (Ptr{UInt8}, Csize_t, Ptr{UInt8}, Ptr{UInt16}), buf, size, bitstream_id, frame_size)
end

"""
    av_adts_header_parse(buf, samples, frames)

Extract the number of samples and frames from AAC data.

# Arguments
* `buf`:\\[in\\] pointer to AAC data buffer
* `samples`:\\[out\\] Pointer to where number of samples is written
* `frames`:\\[out\\] Pointer to where number of frames is written
# Returns
Returns 0 on success, error code on failure.
"""
function av_adts_header_parse(buf, samples, frames)
    ccall((:av_adts_header_parse, libavcodec), Cint, (Ptr{UInt8}, Ptr{UInt32}, Ptr{UInt8}), buf, samples, frames)
end

"""
    RcOverride

` lavc_encoding`
"""
struct RcOverride
    start_frame::Cint
    end_frame::Cint
    qscale::Cint
    quality_factor::Cfloat
end

"""
    AVOptionType

An option type determines: - for native access, the underlying C type of the field that an [`AVOption`](@ref) refers to; - for foreign access, the semantics of accessing the option through this API, e.g. which av\\_opt\\_get\\_*() and av\\_opt\\_set\\_*() functions can be called, or what format will [`av_opt_get`](@ref)()/[`av_opt_set`](@ref)() expect/produce.
"""
const AVOptionType = UInt32
const AV_OPT_TYPE_FLAGS = 1 % UInt32
const AV_OPT_TYPE_INT = 2 % UInt32
const AV_OPT_TYPE_INT64 = 3 % UInt32
const AV_OPT_TYPE_DOUBLE = 4 % UInt32
const AV_OPT_TYPE_FLOAT = 5 % UInt32
const AV_OPT_TYPE_STRING = 6 % UInt32
const AV_OPT_TYPE_RATIONAL = 7 % UInt32
const AV_OPT_TYPE_BINARY = 8 % UInt32
const AV_OPT_TYPE_DICT = 9 % UInt32
const AV_OPT_TYPE_UINT64 = 10 % UInt32
const AV_OPT_TYPE_CONST = 11 % UInt32
const AV_OPT_TYPE_IMAGE_SIZE = 12 % UInt32
const AV_OPT_TYPE_PIXEL_FMT = 13 % UInt32
const AV_OPT_TYPE_SAMPLE_FMT = 14 % UInt32
const AV_OPT_TYPE_VIDEO_RATE = 15 % UInt32
const AV_OPT_TYPE_DURATION = 16 % UInt32
const AV_OPT_TYPE_COLOR = 17 % UInt32
const AV_OPT_TYPE_BOOL = 18 % UInt32
const AV_OPT_TYPE_CHLAYOUT = 19 % UInt32
const AV_OPT_TYPE_UINT = 20 % UInt32
const AV_OPT_TYPE_FLAG_ARRAY = 65536 % UInt32

"""
    __JL_Ctag_95

Native access only, except when documented otherwise. the default value for scalar options
"""
struct __JL_Ctag_95
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{__JL_Ctag_95}, f::Symbol)
    f === :i64 && return Ptr{Int64}(x + 0)
    f === :dbl && return Ptr{Cdouble}(x + 0)
    f === :str && return Ptr{Cstring}(x + 0)
    f === :q && return Ptr{AVRational}(x + 0)
    f === :arr && return Ptr{Ptr{AVOptionArrayDef}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_95, f::Symbol)
    r = Ref{__JL_Ctag_95}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_95}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_95}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::__JL_Ctag_95, private::Bool = false)
    (:i64, :dbl, :str, :q, :arr, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVOption

[`AVOption`](@ref)
"""
struct AVOption
    data::NTuple{64, UInt8}
end

function Base.getproperty(x::Ptr{AVOption}, f::Symbol)
    f === :name && return Ptr{Cstring}(x + 0)
    f === :help && return Ptr{Cstring}(x + 8)
    f === :offset && return Ptr{Cint}(x + 16)
    f === :type && return Ptr{AVOptionType}(x + 20)
    f === :default_val && return Ptr{__JL_Ctag_95}(x + 24)
    f === :min && return Ptr{Cdouble}(x + 32)
    f === :max && return Ptr{Cdouble}(x + 40)
    f === :flags && return Ptr{Cint}(x + 48)
    f === :unit && return Ptr{Cstring}(x + 56)
    return getfield(x, f)
end

function Base.getproperty(x::AVOption, f::Symbol)
    r = Ref{AVOption}(x)
    ptr = Base.unsafe_convert(Ptr{AVOption}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVOption}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVOption, private::Bool = false)
    (:name, :help, :offset, :type, :default_val, :min, :max, :flags, :unit, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

const AVClassCategory = UInt32
const AV_CLASS_CATEGORY_NA = 0 % UInt32
const AV_CLASS_CATEGORY_INPUT = 1 % UInt32
const AV_CLASS_CATEGORY_OUTPUT = 2 % UInt32
const AV_CLASS_CATEGORY_MUXER = 3 % UInt32
const AV_CLASS_CATEGORY_DEMUXER = 4 % UInt32
const AV_CLASS_CATEGORY_ENCODER = 5 % UInt32
const AV_CLASS_CATEGORY_DECODER = 6 % UInt32
const AV_CLASS_CATEGORY_FILTER = 7 % UInt32
const AV_CLASS_CATEGORY_BITSTREAM_FILTER = 8 % UInt32
const AV_CLASS_CATEGORY_SWSCALER = 9 % UInt32
const AV_CLASS_CATEGORY_SWRESAMPLER = 10 % UInt32
const AV_CLASS_CATEGORY_HWDEVICE = 11 % UInt32
const AV_CLASS_CATEGORY_DEVICE_VIDEO_OUTPUT = 40 % UInt32
const AV_CLASS_CATEGORY_DEVICE_VIDEO_INPUT = 41 % UInt32
const AV_CLASS_CATEGORY_DEVICE_AUDIO_OUTPUT = 42 % UInt32
const AV_CLASS_CATEGORY_DEVICE_AUDIO_INPUT = 43 % UInt32
const AV_CLASS_CATEGORY_DEVICE_OUTPUT = 44 % UInt32
const AV_CLASS_CATEGORY_DEVICE_INPUT = 45 % UInt32
const AV_CLASS_CATEGORY_NB = 46 % UInt32

"""
    AVClass

Describe the class of an [`AVClass`](@ref) context structure. That is an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct (e.g. [`AVCodecContext`](@ref), [`AVFormatContext`](@ref) etc.).
"""
struct AVClass
    class_name::Cstring
    item_name::Ptr{Cvoid}
    option::Ptr{AVOption}
    version::Cint
    log_level_offset_offset::Cint
    parent_log_context_offset::Cint
    category::AVClassCategory
    get_category::Ptr{Cvoid}
    query_ranges::Ptr{Cvoid}
    child_next::Ptr{Cvoid}
    child_class_iterate::Ptr{Cvoid}
    state_flags_offset::Cint
end

"""
    AVMediaType

` lavu_media Media Type`

Media Type
"""
const AVMediaType = Int32
const AVMEDIA_TYPE_UNKNOWN = -1 % Int32
const AVMEDIA_TYPE_VIDEO = 0 % Int32
const AVMEDIA_TYPE_AUDIO = 1 % Int32
const AVMEDIA_TYPE_DATA = 2 % Int32
const AVMEDIA_TYPE_SUBTITLE = 3 % Int32
const AVMEDIA_TYPE_ATTACHMENT = 4 % Int32
const AVMEDIA_TYPE_NB = 5 % Int32

"""
    AVCodecID

Identify the syntax and semantics of the bitstream. The principle is roughly: Two decoders with the same ID can decode the same streams. Two encoders with the same ID can encode compatible streams. There may be slight deviations from the principle due to implementation details.

If you add a codec ID to this list, add it so that 1. no value of an existing codec ID changes (that would break ABI), 2. it is as close as possible to similar codecs

After adding new codec IDs, do not forget to add an entry to the codec descriptor list and bump libavcodec minor version.
"""
const AVCodecID = UInt32
const AV_CODEC_ID_NONE = 0 % UInt32
const AV_CODEC_ID_MPEG1VIDEO = 1 % UInt32
const AV_CODEC_ID_MPEG2VIDEO = 2 % UInt32
const AV_CODEC_ID_H261 = 3 % UInt32
const AV_CODEC_ID_H263 = 4 % UInt32
const AV_CODEC_ID_RV10 = 5 % UInt32
const AV_CODEC_ID_RV20 = 6 % UInt32
const AV_CODEC_ID_MJPEG = 7 % UInt32
const AV_CODEC_ID_MJPEGB = 8 % UInt32
const AV_CODEC_ID_LJPEG = 9 % UInt32
const AV_CODEC_ID_SP5X = 10 % UInt32
const AV_CODEC_ID_JPEGLS = 11 % UInt32
const AV_CODEC_ID_MPEG4 = 12 % UInt32
const AV_CODEC_ID_RAWVIDEO = 13 % UInt32
const AV_CODEC_ID_MSMPEG4V1 = 14 % UInt32
const AV_CODEC_ID_MSMPEG4V2 = 15 % UInt32
const AV_CODEC_ID_MSMPEG4V3 = 16 % UInt32
const AV_CODEC_ID_WMV1 = 17 % UInt32
const AV_CODEC_ID_WMV2 = 18 % UInt32
const AV_CODEC_ID_H263P = 19 % UInt32
const AV_CODEC_ID_H263I = 20 % UInt32
const AV_CODEC_ID_FLV1 = 21 % UInt32
const AV_CODEC_ID_SVQ1 = 22 % UInt32
const AV_CODEC_ID_SVQ3 = 23 % UInt32
const AV_CODEC_ID_DVVIDEO = 24 % UInt32
const AV_CODEC_ID_HUFFYUV = 25 % UInt32
const AV_CODEC_ID_CYUV = 26 % UInt32
const AV_CODEC_ID_H264 = 27 % UInt32
const AV_CODEC_ID_INDEO3 = 28 % UInt32
const AV_CODEC_ID_VP3 = 29 % UInt32
const AV_CODEC_ID_THEORA = 30 % UInt32
const AV_CODEC_ID_ASV1 = 31 % UInt32
const AV_CODEC_ID_ASV2 = 32 % UInt32
const AV_CODEC_ID_FFV1 = 33 % UInt32
const AV_CODEC_ID_4XM = 34 % UInt32
const AV_CODEC_ID_VCR1 = 35 % UInt32
const AV_CODEC_ID_CLJR = 36 % UInt32
const AV_CODEC_ID_MDEC = 37 % UInt32
const AV_CODEC_ID_ROQ = 38 % UInt32
const AV_CODEC_ID_INTERPLAY_VIDEO = 39 % UInt32
const AV_CODEC_ID_XAN_WC3 = 40 % UInt32
const AV_CODEC_ID_XAN_WC4 = 41 % UInt32
const AV_CODEC_ID_RPZA = 42 % UInt32
const AV_CODEC_ID_CINEPAK = 43 % UInt32
const AV_CODEC_ID_WS_VQA = 44 % UInt32
const AV_CODEC_ID_MSRLE = 45 % UInt32
const AV_CODEC_ID_MSVIDEO1 = 46 % UInt32
const AV_CODEC_ID_IDCIN = 47 % UInt32
const AV_CODEC_ID_8BPS = 48 % UInt32
const AV_CODEC_ID_SMC = 49 % UInt32
const AV_CODEC_ID_FLIC = 50 % UInt32
const AV_CODEC_ID_TRUEMOTION1 = 51 % UInt32
const AV_CODEC_ID_VMDVIDEO = 52 % UInt32
const AV_CODEC_ID_MSZH = 53 % UInt32
const AV_CODEC_ID_ZLIB = 54 % UInt32
const AV_CODEC_ID_QTRLE = 55 % UInt32
const AV_CODEC_ID_TSCC = 56 % UInt32
const AV_CODEC_ID_ULTI = 57 % UInt32
const AV_CODEC_ID_QDRAW = 58 % UInt32
const AV_CODEC_ID_VIXL = 59 % UInt32
const AV_CODEC_ID_QPEG = 60 % UInt32
const AV_CODEC_ID_PNG = 61 % UInt32
const AV_CODEC_ID_PPM = 62 % UInt32
const AV_CODEC_ID_PBM = 63 % UInt32
const AV_CODEC_ID_PGM = 64 % UInt32
const AV_CODEC_ID_PGMYUV = 65 % UInt32
const AV_CODEC_ID_PAM = 66 % UInt32
const AV_CODEC_ID_FFVHUFF = 67 % UInt32
const AV_CODEC_ID_RV30 = 68 % UInt32
const AV_CODEC_ID_RV40 = 69 % UInt32
const AV_CODEC_ID_VC1 = 70 % UInt32
const AV_CODEC_ID_WMV3 = 71 % UInt32
const AV_CODEC_ID_LOCO = 72 % UInt32
const AV_CODEC_ID_WNV1 = 73 % UInt32
const AV_CODEC_ID_AASC = 74 % UInt32
const AV_CODEC_ID_INDEO2 = 75 % UInt32
const AV_CODEC_ID_FRAPS = 76 % UInt32
const AV_CODEC_ID_TRUEMOTION2 = 77 % UInt32
const AV_CODEC_ID_BMP = 78 % UInt32
const AV_CODEC_ID_CSCD = 79 % UInt32
const AV_CODEC_ID_MMVIDEO = 80 % UInt32
const AV_CODEC_ID_ZMBV = 81 % UInt32
const AV_CODEC_ID_AVS = 82 % UInt32
const AV_CODEC_ID_SMACKVIDEO = 83 % UInt32
const AV_CODEC_ID_NUV = 84 % UInt32
const AV_CODEC_ID_KMVC = 85 % UInt32
const AV_CODEC_ID_FLASHSV = 86 % UInt32
const AV_CODEC_ID_CAVS = 87 % UInt32
const AV_CODEC_ID_JPEG2000 = 88 % UInt32
const AV_CODEC_ID_VMNC = 89 % UInt32
const AV_CODEC_ID_VP5 = 90 % UInt32
const AV_CODEC_ID_VP6 = 91 % UInt32
const AV_CODEC_ID_VP6F = 92 % UInt32
const AV_CODEC_ID_TARGA = 93 % UInt32
const AV_CODEC_ID_DSICINVIDEO = 94 % UInt32
const AV_CODEC_ID_TIERTEXSEQVIDEO = 95 % UInt32
const AV_CODEC_ID_TIFF = 96 % UInt32
const AV_CODEC_ID_GIF = 97 % UInt32
const AV_CODEC_ID_DXA = 98 % UInt32
const AV_CODEC_ID_DNXHD = 99 % UInt32
const AV_CODEC_ID_THP = 100 % UInt32
const AV_CODEC_ID_SGI = 101 % UInt32
const AV_CODEC_ID_C93 = 102 % UInt32
const AV_CODEC_ID_BETHSOFTVID = 103 % UInt32
const AV_CODEC_ID_PTX = 104 % UInt32
const AV_CODEC_ID_TXD = 105 % UInt32
const AV_CODEC_ID_VP6A = 106 % UInt32
const AV_CODEC_ID_AMV = 107 % UInt32
const AV_CODEC_ID_VB = 108 % UInt32
const AV_CODEC_ID_PCX = 109 % UInt32
const AV_CODEC_ID_SUNRAST = 110 % UInt32
const AV_CODEC_ID_INDEO4 = 111 % UInt32
const AV_CODEC_ID_INDEO5 = 112 % UInt32
const AV_CODEC_ID_MIMIC = 113 % UInt32
const AV_CODEC_ID_RL2 = 114 % UInt32
const AV_CODEC_ID_ESCAPE124 = 115 % UInt32
const AV_CODEC_ID_DIRAC = 116 % UInt32
const AV_CODEC_ID_BFI = 117 % UInt32
const AV_CODEC_ID_CMV = 118 % UInt32
const AV_CODEC_ID_MOTIONPIXELS = 119 % UInt32
const AV_CODEC_ID_TGV = 120 % UInt32
const AV_CODEC_ID_TGQ = 121 % UInt32
const AV_CODEC_ID_TQI = 122 % UInt32
const AV_CODEC_ID_AURA = 123 % UInt32
const AV_CODEC_ID_AURA2 = 124 % UInt32
const AV_CODEC_ID_V210X = 125 % UInt32
const AV_CODEC_ID_TMV = 126 % UInt32
const AV_CODEC_ID_V210 = 127 % UInt32
const AV_CODEC_ID_DPX = 128 % UInt32
const AV_CODEC_ID_MAD = 129 % UInt32
const AV_CODEC_ID_FRWU = 130 % UInt32
const AV_CODEC_ID_FLASHSV2 = 131 % UInt32
const AV_CODEC_ID_CDGRAPHICS = 132 % UInt32
const AV_CODEC_ID_R210 = 133 % UInt32
const AV_CODEC_ID_ANM = 134 % UInt32
const AV_CODEC_ID_BINKVIDEO = 135 % UInt32
const AV_CODEC_ID_IFF_ILBM = 136 % UInt32
const AV_CODEC_ID_KGV1 = 137 % UInt32
const AV_CODEC_ID_YOP = 138 % UInt32
const AV_CODEC_ID_VP8 = 139 % UInt32
const AV_CODEC_ID_PICTOR = 140 % UInt32
const AV_CODEC_ID_ANSI = 141 % UInt32
const AV_CODEC_ID_A64_MULTI = 142 % UInt32
const AV_CODEC_ID_A64_MULTI5 = 143 % UInt32
const AV_CODEC_ID_R10K = 144 % UInt32
const AV_CODEC_ID_MXPEG = 145 % UInt32
const AV_CODEC_ID_LAGARITH = 146 % UInt32
const AV_CODEC_ID_PRORES = 147 % UInt32
const AV_CODEC_ID_JV = 148 % UInt32
const AV_CODEC_ID_DFA = 149 % UInt32
const AV_CODEC_ID_WMV3IMAGE = 150 % UInt32
const AV_CODEC_ID_VC1IMAGE = 151 % UInt32
const AV_CODEC_ID_UTVIDEO = 152 % UInt32
const AV_CODEC_ID_BMV_VIDEO = 153 % UInt32
const AV_CODEC_ID_VBLE = 154 % UInt32
const AV_CODEC_ID_DXTORY = 155 % UInt32
const AV_CODEC_ID_V410 = 156 % UInt32
const AV_CODEC_ID_XWD = 157 % UInt32
const AV_CODEC_ID_CDXL = 158 % UInt32
const AV_CODEC_ID_XBM = 159 % UInt32
const AV_CODEC_ID_ZEROCODEC = 160 % UInt32
const AV_CODEC_ID_MSS1 = 161 % UInt32
const AV_CODEC_ID_MSA1 = 162 % UInt32
const AV_CODEC_ID_TSCC2 = 163 % UInt32
const AV_CODEC_ID_MTS2 = 164 % UInt32
const AV_CODEC_ID_CLLC = 165 % UInt32
const AV_CODEC_ID_MSS2 = 166 % UInt32
const AV_CODEC_ID_VP9 = 167 % UInt32
const AV_CODEC_ID_AIC = 168 % UInt32
const AV_CODEC_ID_ESCAPE130 = 169 % UInt32
const AV_CODEC_ID_G2M = 170 % UInt32
const AV_CODEC_ID_WEBP = 171 % UInt32
const AV_CODEC_ID_HNM4_VIDEO = 172 % UInt32
const AV_CODEC_ID_HEVC = 173 % UInt32
const AV_CODEC_ID_FIC = 174 % UInt32
const AV_CODEC_ID_ALIAS_PIX = 175 % UInt32
const AV_CODEC_ID_BRENDER_PIX = 176 % UInt32
const AV_CODEC_ID_PAF_VIDEO = 177 % UInt32
const AV_CODEC_ID_EXR = 178 % UInt32
const AV_CODEC_ID_VP7 = 179 % UInt32
const AV_CODEC_ID_SANM = 180 % UInt32
const AV_CODEC_ID_SGIRLE = 181 % UInt32
const AV_CODEC_ID_MVC1 = 182 % UInt32
const AV_CODEC_ID_MVC2 = 183 % UInt32
const AV_CODEC_ID_HQX = 184 % UInt32
const AV_CODEC_ID_TDSC = 185 % UInt32
const AV_CODEC_ID_HQ_HQA = 186 % UInt32
const AV_CODEC_ID_HAP = 187 % UInt32
const AV_CODEC_ID_DDS = 188 % UInt32
const AV_CODEC_ID_DXV = 189 % UInt32
const AV_CODEC_ID_SCREENPRESSO = 190 % UInt32
const AV_CODEC_ID_RSCC = 191 % UInt32
const AV_CODEC_ID_AVS2 = 192 % UInt32
const AV_CODEC_ID_PGX = 193 % UInt32
const AV_CODEC_ID_AVS3 = 194 % UInt32
const AV_CODEC_ID_MSP2 = 195 % UInt32
const AV_CODEC_ID_VVC = 196 % UInt32
const AV_CODEC_ID_Y41P = 197 % UInt32
const AV_CODEC_ID_AVRP = 198 % UInt32
const AV_CODEC_ID_012V = 199 % UInt32
const AV_CODEC_ID_AVUI = 200 % UInt32
const AV_CODEC_ID_TARGA_Y216 = 201 % UInt32
const AV_CODEC_ID_V308 = 202 % UInt32
const AV_CODEC_ID_V408 = 203 % UInt32
const AV_CODEC_ID_YUV4 = 204 % UInt32
const AV_CODEC_ID_AVRN = 205 % UInt32
const AV_CODEC_ID_CPIA = 206 % UInt32
const AV_CODEC_ID_XFACE = 207 % UInt32
const AV_CODEC_ID_SNOW = 208 % UInt32
const AV_CODEC_ID_SMVJPEG = 209 % UInt32
const AV_CODEC_ID_APNG = 210 % UInt32
const AV_CODEC_ID_DAALA = 211 % UInt32
const AV_CODEC_ID_CFHD = 212 % UInt32
const AV_CODEC_ID_TRUEMOTION2RT = 213 % UInt32
const AV_CODEC_ID_M101 = 214 % UInt32
const AV_CODEC_ID_MAGICYUV = 215 % UInt32
const AV_CODEC_ID_SHEERVIDEO = 216 % UInt32
const AV_CODEC_ID_YLC = 217 % UInt32
const AV_CODEC_ID_PSD = 218 % UInt32
const AV_CODEC_ID_PIXLET = 219 % UInt32
const AV_CODEC_ID_SPEEDHQ = 220 % UInt32
const AV_CODEC_ID_FMVC = 221 % UInt32
const AV_CODEC_ID_SCPR = 222 % UInt32
const AV_CODEC_ID_CLEARVIDEO = 223 % UInt32
const AV_CODEC_ID_XPM = 224 % UInt32
const AV_CODEC_ID_AV1 = 225 % UInt32
const AV_CODEC_ID_BITPACKED = 226 % UInt32
const AV_CODEC_ID_MSCC = 227 % UInt32
const AV_CODEC_ID_SRGC = 228 % UInt32
const AV_CODEC_ID_SVG = 229 % UInt32
const AV_CODEC_ID_GDV = 230 % UInt32
const AV_CODEC_ID_FITS = 231 % UInt32
const AV_CODEC_ID_IMM4 = 232 % UInt32
const AV_CODEC_ID_PROSUMER = 233 % UInt32
const AV_CODEC_ID_MWSC = 234 % UInt32
const AV_CODEC_ID_WCMV = 235 % UInt32
const AV_CODEC_ID_RASC = 236 % UInt32
const AV_CODEC_ID_HYMT = 237 % UInt32
const AV_CODEC_ID_ARBC = 238 % UInt32
const AV_CODEC_ID_AGM = 239 % UInt32
const AV_CODEC_ID_LSCR = 240 % UInt32
const AV_CODEC_ID_VP4 = 241 % UInt32
const AV_CODEC_ID_IMM5 = 242 % UInt32
const AV_CODEC_ID_MVDV = 243 % UInt32
const AV_CODEC_ID_MVHA = 244 % UInt32
const AV_CODEC_ID_CDTOONS = 245 % UInt32
const AV_CODEC_ID_MV30 = 246 % UInt32
const AV_CODEC_ID_NOTCHLC = 247 % UInt32
const AV_CODEC_ID_PFM = 248 % UInt32
const AV_CODEC_ID_MOBICLIP = 249 % UInt32
const AV_CODEC_ID_PHOTOCD = 250 % UInt32
const AV_CODEC_ID_IPU = 251 % UInt32
const AV_CODEC_ID_ARGO = 252 % UInt32
const AV_CODEC_ID_CRI = 253 % UInt32
const AV_CODEC_ID_SIMBIOSIS_IMX = 254 % UInt32
const AV_CODEC_ID_SGA_VIDEO = 255 % UInt32
const AV_CODEC_ID_GEM = 256 % UInt32
const AV_CODEC_ID_VBN = 257 % UInt32
const AV_CODEC_ID_JPEGXL = 258 % UInt32
const AV_CODEC_ID_QOI = 259 % UInt32
const AV_CODEC_ID_PHM = 260 % UInt32
const AV_CODEC_ID_RADIANCE_HDR = 261 % UInt32
const AV_CODEC_ID_WBMP = 262 % UInt32
const AV_CODEC_ID_MEDIA100 = 263 % UInt32
const AV_CODEC_ID_VQC = 264 % UInt32
const AV_CODEC_ID_PDV = 265 % UInt32
const AV_CODEC_ID_EVC = 266 % UInt32
const AV_CODEC_ID_RTV1 = 267 % UInt32
const AV_CODEC_ID_VMIX = 268 % UInt32
const AV_CODEC_ID_LEAD = 269 % UInt32
const AV_CODEC_ID_DNXUC = 270 % UInt32
const AV_CODEC_ID_RV60 = 271 % UInt32
const AV_CODEC_ID_JPEGXL_ANIM = 272 % UInt32
const AV_CODEC_ID_APV = 273 % UInt32
const AV_CODEC_ID_PRORES_RAW = 274 % UInt32
const AV_CODEC_ID_FIRST_AUDIO = 65536 % UInt32
const AV_CODEC_ID_PCM_S16LE = 65536 % UInt32
const AV_CODEC_ID_PCM_S16BE = 65537 % UInt32
const AV_CODEC_ID_PCM_U16LE = 65538 % UInt32
const AV_CODEC_ID_PCM_U16BE = 65539 % UInt32
const AV_CODEC_ID_PCM_S8 = 65540 % UInt32
const AV_CODEC_ID_PCM_U8 = 65541 % UInt32
const AV_CODEC_ID_PCM_MULAW = 65542 % UInt32
const AV_CODEC_ID_PCM_ALAW = 65543 % UInt32
const AV_CODEC_ID_PCM_S32LE = 65544 % UInt32
const AV_CODEC_ID_PCM_S32BE = 65545 % UInt32
const AV_CODEC_ID_PCM_U32LE = 65546 % UInt32
const AV_CODEC_ID_PCM_U32BE = 65547 % UInt32
const AV_CODEC_ID_PCM_S24LE = 65548 % UInt32
const AV_CODEC_ID_PCM_S24BE = 65549 % UInt32
const AV_CODEC_ID_PCM_U24LE = 65550 % UInt32
const AV_CODEC_ID_PCM_U24BE = 65551 % UInt32
const AV_CODEC_ID_PCM_S24DAUD = 65552 % UInt32
const AV_CODEC_ID_PCM_ZORK = 65553 % UInt32
const AV_CODEC_ID_PCM_S16LE_PLANAR = 65554 % UInt32
const AV_CODEC_ID_PCM_DVD = 65555 % UInt32
const AV_CODEC_ID_PCM_F32BE = 65556 % UInt32
const AV_CODEC_ID_PCM_F32LE = 65557 % UInt32
const AV_CODEC_ID_PCM_F64BE = 65558 % UInt32
const AV_CODEC_ID_PCM_F64LE = 65559 % UInt32
const AV_CODEC_ID_PCM_BLURAY = 65560 % UInt32
const AV_CODEC_ID_PCM_LXF = 65561 % UInt32
const AV_CODEC_ID_S302M = 65562 % UInt32
const AV_CODEC_ID_PCM_S8_PLANAR = 65563 % UInt32
const AV_CODEC_ID_PCM_S24LE_PLANAR = 65564 % UInt32
const AV_CODEC_ID_PCM_S32LE_PLANAR = 65565 % UInt32
const AV_CODEC_ID_PCM_S16BE_PLANAR = 65566 % UInt32
const AV_CODEC_ID_PCM_S64LE = 65567 % UInt32
const AV_CODEC_ID_PCM_S64BE = 65568 % UInt32
const AV_CODEC_ID_PCM_F16LE = 65569 % UInt32
const AV_CODEC_ID_PCM_F24LE = 65570 % UInt32
const AV_CODEC_ID_PCM_VIDC = 65571 % UInt32
const AV_CODEC_ID_PCM_SGA = 65572 % UInt32
const AV_CODEC_ID_ADPCM_IMA_QT = 69632 % UInt32
const AV_CODEC_ID_ADPCM_IMA_WAV = 69633 % UInt32
const AV_CODEC_ID_ADPCM_IMA_DK3 = 69634 % UInt32
const AV_CODEC_ID_ADPCM_IMA_DK4 = 69635 % UInt32
const AV_CODEC_ID_ADPCM_IMA_WS = 69636 % UInt32
const AV_CODEC_ID_ADPCM_IMA_SMJPEG = 69637 % UInt32
const AV_CODEC_ID_ADPCM_MS = 69638 % UInt32
const AV_CODEC_ID_ADPCM_4XM = 69639 % UInt32
const AV_CODEC_ID_ADPCM_XA = 69640 % UInt32
const AV_CODEC_ID_ADPCM_ADX = 69641 % UInt32
const AV_CODEC_ID_ADPCM_EA = 69642 % UInt32
const AV_CODEC_ID_ADPCM_G726 = 69643 % UInt32
const AV_CODEC_ID_ADPCM_CT = 69644 % UInt32
const AV_CODEC_ID_ADPCM_SWF = 69645 % UInt32
const AV_CODEC_ID_ADPCM_YAMAHA = 69646 % UInt32
const AV_CODEC_ID_ADPCM_SBPRO_4 = 69647 % UInt32
const AV_CODEC_ID_ADPCM_SBPRO_3 = 69648 % UInt32
const AV_CODEC_ID_ADPCM_SBPRO_2 = 69649 % UInt32
const AV_CODEC_ID_ADPCM_THP = 69650 % UInt32
const AV_CODEC_ID_ADPCM_IMA_AMV = 69651 % UInt32
const AV_CODEC_ID_ADPCM_EA_R1 = 69652 % UInt32
const AV_CODEC_ID_ADPCM_EA_R3 = 69653 % UInt32
const AV_CODEC_ID_ADPCM_EA_R2 = 69654 % UInt32
const AV_CODEC_ID_ADPCM_IMA_EA_SEAD = 69655 % UInt32
const AV_CODEC_ID_ADPCM_IMA_EA_EACS = 69656 % UInt32
const AV_CODEC_ID_ADPCM_EA_XAS = 69657 % UInt32
const AV_CODEC_ID_ADPCM_EA_MAXIS_XA = 69658 % UInt32
const AV_CODEC_ID_ADPCM_IMA_ISS = 69659 % UInt32
const AV_CODEC_ID_ADPCM_G722 = 69660 % UInt32
const AV_CODEC_ID_ADPCM_IMA_APC = 69661 % UInt32
const AV_CODEC_ID_ADPCM_VIMA = 69662 % UInt32
const AV_CODEC_ID_ADPCM_AFC = 69663 % UInt32
const AV_CODEC_ID_ADPCM_IMA_OKI = 69664 % UInt32
const AV_CODEC_ID_ADPCM_DTK = 69665 % UInt32
const AV_CODEC_ID_ADPCM_IMA_RAD = 69666 % UInt32
const AV_CODEC_ID_ADPCM_G726LE = 69667 % UInt32
const AV_CODEC_ID_ADPCM_THP_LE = 69668 % UInt32
const AV_CODEC_ID_ADPCM_PSX = 69669 % UInt32
const AV_CODEC_ID_ADPCM_AICA = 69670 % UInt32
const AV_CODEC_ID_ADPCM_IMA_DAT4 = 69671 % UInt32
const AV_CODEC_ID_ADPCM_MTAF = 69672 % UInt32
const AV_CODEC_ID_ADPCM_AGM = 69673 % UInt32
const AV_CODEC_ID_ADPCM_ARGO = 69674 % UInt32
const AV_CODEC_ID_ADPCM_IMA_SSI = 69675 % UInt32
const AV_CODEC_ID_ADPCM_ZORK = 69676 % UInt32
const AV_CODEC_ID_ADPCM_IMA_APM = 69677 % UInt32
const AV_CODEC_ID_ADPCM_IMA_ALP = 69678 % UInt32
const AV_CODEC_ID_ADPCM_IMA_MTF = 69679 % UInt32
const AV_CODEC_ID_ADPCM_IMA_CUNNING = 69680 % UInt32
const AV_CODEC_ID_ADPCM_IMA_MOFLEX = 69681 % UInt32
const AV_CODEC_ID_ADPCM_IMA_ACORN = 69682 % UInt32
const AV_CODEC_ID_ADPCM_XMD = 69683 % UInt32
const AV_CODEC_ID_ADPCM_IMA_XBOX = 69684 % UInt32
const AV_CODEC_ID_ADPCM_SANYO = 69685 % UInt32
const AV_CODEC_ID_AMR_NB = 73728 % UInt32
const AV_CODEC_ID_AMR_WB = 73729 % UInt32
const AV_CODEC_ID_RA_144 = 77824 % UInt32
const AV_CODEC_ID_RA_288 = 77825 % UInt32
const AV_CODEC_ID_ROQ_DPCM = 81920 % UInt32
const AV_CODEC_ID_INTERPLAY_DPCM = 81921 % UInt32
const AV_CODEC_ID_XAN_DPCM = 81922 % UInt32
const AV_CODEC_ID_SOL_DPCM = 81923 % UInt32
const AV_CODEC_ID_SDX2_DPCM = 81924 % UInt32
const AV_CODEC_ID_GREMLIN_DPCM = 81925 % UInt32
const AV_CODEC_ID_DERF_DPCM = 81926 % UInt32
const AV_CODEC_ID_WADY_DPCM = 81927 % UInt32
const AV_CODEC_ID_CBD2_DPCM = 81928 % UInt32
const AV_CODEC_ID_MP2 = 86016 % UInt32
const AV_CODEC_ID_MP3 = 86017 % UInt32
const AV_CODEC_ID_AAC = 86018 % UInt32
const AV_CODEC_ID_AC3 = 86019 % UInt32
const AV_CODEC_ID_DTS = 86020 % UInt32
const AV_CODEC_ID_VORBIS = 86021 % UInt32
const AV_CODEC_ID_DVAUDIO = 86022 % UInt32
const AV_CODEC_ID_WMAV1 = 86023 % UInt32
const AV_CODEC_ID_WMAV2 = 86024 % UInt32
const AV_CODEC_ID_MACE3 = 86025 % UInt32
const AV_CODEC_ID_MACE6 = 86026 % UInt32
const AV_CODEC_ID_VMDAUDIO = 86027 % UInt32
const AV_CODEC_ID_FLAC = 86028 % UInt32
const AV_CODEC_ID_MP3ADU = 86029 % UInt32
const AV_CODEC_ID_MP3ON4 = 86030 % UInt32
const AV_CODEC_ID_SHORTEN = 86031 % UInt32
const AV_CODEC_ID_ALAC = 86032 % UInt32
const AV_CODEC_ID_WESTWOOD_SND1 = 86033 % UInt32
const AV_CODEC_ID_GSM = 86034 % UInt32
const AV_CODEC_ID_QDM2 = 86035 % UInt32
const AV_CODEC_ID_COOK = 86036 % UInt32
const AV_CODEC_ID_TRUESPEECH = 86037 % UInt32
const AV_CODEC_ID_TTA = 86038 % UInt32
const AV_CODEC_ID_SMACKAUDIO = 86039 % UInt32
const AV_CODEC_ID_QCELP = 86040 % UInt32
const AV_CODEC_ID_WAVPACK = 86041 % UInt32
const AV_CODEC_ID_DSICINAUDIO = 86042 % UInt32
const AV_CODEC_ID_IMC = 86043 % UInt32
const AV_CODEC_ID_MUSEPACK7 = 86044 % UInt32
const AV_CODEC_ID_MLP = 86045 % UInt32
const AV_CODEC_ID_GSM_MS = 86046 % UInt32
const AV_CODEC_ID_ATRAC3 = 86047 % UInt32
const AV_CODEC_ID_APE = 86048 % UInt32
const AV_CODEC_ID_NELLYMOSER = 86049 % UInt32
const AV_CODEC_ID_MUSEPACK8 = 86050 % UInt32
const AV_CODEC_ID_SPEEX = 86051 % UInt32
const AV_CODEC_ID_WMAVOICE = 86052 % UInt32
const AV_CODEC_ID_WMAPRO = 86053 % UInt32
const AV_CODEC_ID_WMALOSSLESS = 86054 % UInt32
const AV_CODEC_ID_ATRAC3P = 86055 % UInt32
const AV_CODEC_ID_EAC3 = 86056 % UInt32
const AV_CODEC_ID_SIPR = 86057 % UInt32
const AV_CODEC_ID_MP1 = 86058 % UInt32
const AV_CODEC_ID_TWINVQ = 86059 % UInt32
const AV_CODEC_ID_TRUEHD = 86060 % UInt32
const AV_CODEC_ID_MP4ALS = 86061 % UInt32
const AV_CODEC_ID_ATRAC1 = 86062 % UInt32
const AV_CODEC_ID_BINKAUDIO_RDFT = 86063 % UInt32
const AV_CODEC_ID_BINKAUDIO_DCT = 86064 % UInt32
const AV_CODEC_ID_AAC_LATM = 86065 % UInt32
const AV_CODEC_ID_QDMC = 86066 % UInt32
const AV_CODEC_ID_CELT = 86067 % UInt32
const AV_CODEC_ID_G723_1 = 86068 % UInt32
const AV_CODEC_ID_G729 = 86069 % UInt32
const AV_CODEC_ID_8SVX_EXP = 86070 % UInt32
const AV_CODEC_ID_8SVX_FIB = 86071 % UInt32
const AV_CODEC_ID_BMV_AUDIO = 86072 % UInt32
const AV_CODEC_ID_RALF = 86073 % UInt32
const AV_CODEC_ID_IAC = 86074 % UInt32
const AV_CODEC_ID_ILBC = 86075 % UInt32
const AV_CODEC_ID_OPUS = 86076 % UInt32
const AV_CODEC_ID_COMFORT_NOISE = 86077 % UInt32
const AV_CODEC_ID_TAK = 86078 % UInt32
const AV_CODEC_ID_METASOUND = 86079 % UInt32
const AV_CODEC_ID_PAF_AUDIO = 86080 % UInt32
const AV_CODEC_ID_ON2AVC = 86081 % UInt32
const AV_CODEC_ID_DSS_SP = 86082 % UInt32
const AV_CODEC_ID_CODEC2 = 86083 % UInt32
const AV_CODEC_ID_FFWAVESYNTH = 86084 % UInt32
const AV_CODEC_ID_SONIC = 86085 % UInt32
const AV_CODEC_ID_SONIC_LS = 86086 % UInt32
const AV_CODEC_ID_EVRC = 86087 % UInt32
const AV_CODEC_ID_SMV = 86088 % UInt32
const AV_CODEC_ID_DSD_LSBF = 86089 % UInt32
const AV_CODEC_ID_DSD_MSBF = 86090 % UInt32
const AV_CODEC_ID_DSD_LSBF_PLANAR = 86091 % UInt32
const AV_CODEC_ID_DSD_MSBF_PLANAR = 86092 % UInt32
const AV_CODEC_ID_4GV = 86093 % UInt32
const AV_CODEC_ID_INTERPLAY_ACM = 86094 % UInt32
const AV_CODEC_ID_XMA1 = 86095 % UInt32
const AV_CODEC_ID_XMA2 = 86096 % UInt32
const AV_CODEC_ID_DST = 86097 % UInt32
const AV_CODEC_ID_ATRAC3AL = 86098 % UInt32
const AV_CODEC_ID_ATRAC3PAL = 86099 % UInt32
const AV_CODEC_ID_DOLBY_E = 86100 % UInt32
const AV_CODEC_ID_APTX = 86101 % UInt32
const AV_CODEC_ID_APTX_HD = 86102 % UInt32
const AV_CODEC_ID_SBC = 86103 % UInt32
const AV_CODEC_ID_ATRAC9 = 86104 % UInt32
const AV_CODEC_ID_HCOM = 86105 % UInt32
const AV_CODEC_ID_ACELP_KELVIN = 86106 % UInt32
const AV_CODEC_ID_MPEGH_3D_AUDIO = 86107 % UInt32
const AV_CODEC_ID_SIREN = 86108 % UInt32
const AV_CODEC_ID_HCA = 86109 % UInt32
const AV_CODEC_ID_FASTAUDIO = 86110 % UInt32
const AV_CODEC_ID_MSNSIREN = 86111 % UInt32
const AV_CODEC_ID_DFPWM = 86112 % UInt32
const AV_CODEC_ID_BONK = 86113 % UInt32
const AV_CODEC_ID_MISC4 = 86114 % UInt32
const AV_CODEC_ID_APAC = 86115 % UInt32
const AV_CODEC_ID_FTR = 86116 % UInt32
const AV_CODEC_ID_WAVARC = 86117 % UInt32
const AV_CODEC_ID_RKA = 86118 % UInt32
const AV_CODEC_ID_AC4 = 86119 % UInt32
const AV_CODEC_ID_OSQ = 86120 % UInt32
const AV_CODEC_ID_QOA = 86121 % UInt32
const AV_CODEC_ID_LC3 = 86122 % UInt32
const AV_CODEC_ID_G728 = 86123 % UInt32
const AV_CODEC_ID_FIRST_SUBTITLE = 94208 % UInt32
const AV_CODEC_ID_DVD_SUBTITLE = 94208 % UInt32
const AV_CODEC_ID_DVB_SUBTITLE = 94209 % UInt32
const AV_CODEC_ID_TEXT = 94210 % UInt32
const AV_CODEC_ID_XSUB = 94211 % UInt32
const AV_CODEC_ID_SSA = 94212 % UInt32
const AV_CODEC_ID_MOV_TEXT = 94213 % UInt32
const AV_CODEC_ID_HDMV_PGS_SUBTITLE = 94214 % UInt32
const AV_CODEC_ID_DVB_TELETEXT = 94215 % UInt32
const AV_CODEC_ID_SRT = 94216 % UInt32
const AV_CODEC_ID_MICRODVD = 94217 % UInt32
const AV_CODEC_ID_EIA_608 = 94218 % UInt32
const AV_CODEC_ID_JACOSUB = 94219 % UInt32
const AV_CODEC_ID_SAMI = 94220 % UInt32
const AV_CODEC_ID_REALTEXT = 94221 % UInt32
const AV_CODEC_ID_STL = 94222 % UInt32
const AV_CODEC_ID_SUBVIEWER1 = 94223 % UInt32
const AV_CODEC_ID_SUBVIEWER = 94224 % UInt32
const AV_CODEC_ID_SUBRIP = 94225 % UInt32
const AV_CODEC_ID_WEBVTT = 94226 % UInt32
const AV_CODEC_ID_MPL2 = 94227 % UInt32
const AV_CODEC_ID_VPLAYER = 94228 % UInt32
const AV_CODEC_ID_PJS = 94229 % UInt32
const AV_CODEC_ID_ASS = 94230 % UInt32
const AV_CODEC_ID_HDMV_TEXT_SUBTITLE = 94231 % UInt32
const AV_CODEC_ID_TTML = 94232 % UInt32
const AV_CODEC_ID_ARIB_CAPTION = 94233 % UInt32
const AV_CODEC_ID_IVTV_VBI = 94234 % UInt32
const AV_CODEC_ID_FIRST_UNKNOWN = 98304 % UInt32
const AV_CODEC_ID_TTF = 98304 % UInt32
const AV_CODEC_ID_SCTE_35 = 98305 % UInt32
const AV_CODEC_ID_EPG = 98306 % UInt32
const AV_CODEC_ID_BINTEXT = 98307 % UInt32
const AV_CODEC_ID_XBIN = 98308 % UInt32
const AV_CODEC_ID_IDF = 98309 % UInt32
const AV_CODEC_ID_OTF = 98310 % UInt32
const AV_CODEC_ID_SMPTE_KLV = 98311 % UInt32
const AV_CODEC_ID_DVD_NAV = 98312 % UInt32
const AV_CODEC_ID_TIMED_ID3 = 98313 % UInt32
const AV_CODEC_ID_BIN_DATA = 98314 % UInt32
const AV_CODEC_ID_SMPTE_2038 = 98315 % UInt32
const AV_CODEC_ID_LCEVC = 98316 % UInt32
const AV_CODEC_ID_SMPTE_436M_ANC = 98317 % UInt32
const AV_CODEC_ID_PROBE = 102400 % UInt32
const AV_CODEC_ID_MPEG2TS = 131072 % UInt32
const AV_CODEC_ID_MPEG4SYSTEMS = 131073 % UInt32
const AV_CODEC_ID_FFMETADATA = 135168 % UInt32
const AV_CODEC_ID_WRAPPED_AVFRAME = 135169 % UInt32
const AV_CODEC_ID_VNULL = 135170 % UInt32
const AV_CODEC_ID_ANULL = 135171 % UInt32

"""
    AVRational

Rational number (pair of numerator and denominator).
"""
struct AVRational
    num::Cint
    den::Cint
end

"""
    AVPixelFormat

Pixel format.

!!! note

    [`AV_PIX_FMT_RGB32`](@ref) is handled in an endian-specific manner. An RGBA color is put together as: (A << 24) | (R << 16) | (G << 8) | B This is stored as BGRA on little-endian CPU architectures and ARGB on big-endian CPUs.

!!! note

    If the resolution is not a multiple of the chroma subsampling factor then the chroma plane resolution must be rounded up.

\\par When the pixel format is palettized RGB32 (AV\\_PIX\\_FMT\\_PAL8), the palettized image data is stored in [`AVFrame`](@ref).data[0]. The palette is transported in [`AVFrame`](@ref).data[1], is 1024 bytes long (256 4-byte entries) and is formatted the same as in [`AV_PIX_FMT_RGB32`](@ref) described above (i.e., it is also endian-specific). Note also that the individual RGB32 palette components stored in [`AVFrame`](@ref).data[1] should be in the range 0..255. This is important as many custom PAL8 video codecs that were designed to run on the IBM VGA graphics adapter use 6-bit palette components.

\\par For all the 8 bits per pixel formats, an RGB32 palette is in data[1] like for pal8. This palette is filled in automatically by the function allocating the picture.
"""
const AVPixelFormat = Int32
const AV_PIX_FMT_NONE = -1 % Int32
const AV_PIX_FMT_YUV420P = 0 % Int32
const AV_PIX_FMT_YUYV422 = 1 % Int32
const AV_PIX_FMT_RGB24 = 2 % Int32
const AV_PIX_FMT_BGR24 = 3 % Int32
const AV_PIX_FMT_YUV422P = 4 % Int32
const AV_PIX_FMT_YUV444P = 5 % Int32
const AV_PIX_FMT_YUV410P = 6 % Int32
const AV_PIX_FMT_YUV411P = 7 % Int32
const AV_PIX_FMT_GRAY8 = 8 % Int32
const AV_PIX_FMT_MONOWHITE = 9 % Int32
const AV_PIX_FMT_MONOBLACK = 10 % Int32
const AV_PIX_FMT_PAL8 = 11 % Int32
const AV_PIX_FMT_YUVJ420P = 12 % Int32
const AV_PIX_FMT_YUVJ422P = 13 % Int32
const AV_PIX_FMT_YUVJ444P = 14 % Int32
const AV_PIX_FMT_UYVY422 = 15 % Int32
const AV_PIX_FMT_UYYVYY411 = 16 % Int32
const AV_PIX_FMT_BGR8 = 17 % Int32
const AV_PIX_FMT_BGR4 = 18 % Int32
const AV_PIX_FMT_BGR4_BYTE = 19 % Int32
const AV_PIX_FMT_RGB8 = 20 % Int32
const AV_PIX_FMT_RGB4 = 21 % Int32
const AV_PIX_FMT_RGB4_BYTE = 22 % Int32
const AV_PIX_FMT_NV12 = 23 % Int32
const AV_PIX_FMT_NV21 = 24 % Int32
const AV_PIX_FMT_ARGB = 25 % Int32
const AV_PIX_FMT_RGBA = 26 % Int32
const AV_PIX_FMT_ABGR = 27 % Int32
const AV_PIX_FMT_BGRA = 28 % Int32
const AV_PIX_FMT_GRAY16BE = 29 % Int32
const AV_PIX_FMT_GRAY16LE = 30 % Int32
const AV_PIX_FMT_YUV440P = 31 % Int32
const AV_PIX_FMT_YUVJ440P = 32 % Int32
const AV_PIX_FMT_YUVA420P = 33 % Int32
const AV_PIX_FMT_RGB48BE = 34 % Int32
const AV_PIX_FMT_RGB48LE = 35 % Int32
const AV_PIX_FMT_RGB565BE = 36 % Int32
const AV_PIX_FMT_RGB565LE = 37 % Int32
const AV_PIX_FMT_RGB555BE = 38 % Int32
const AV_PIX_FMT_RGB555LE = 39 % Int32
const AV_PIX_FMT_BGR565BE = 40 % Int32
const AV_PIX_FMT_BGR565LE = 41 % Int32
const AV_PIX_FMT_BGR555BE = 42 % Int32
const AV_PIX_FMT_BGR555LE = 43 % Int32
const AV_PIX_FMT_VAAPI = 44 % Int32
const AV_PIX_FMT_YUV420P16LE = 45 % Int32
const AV_PIX_FMT_YUV420P16BE = 46 % Int32
const AV_PIX_FMT_YUV422P16LE = 47 % Int32
const AV_PIX_FMT_YUV422P16BE = 48 % Int32
const AV_PIX_FMT_YUV444P16LE = 49 % Int32
const AV_PIX_FMT_YUV444P16BE = 50 % Int32
const AV_PIX_FMT_DXVA2_VLD = 51 % Int32
const AV_PIX_FMT_RGB444LE = 52 % Int32
const AV_PIX_FMT_RGB444BE = 53 % Int32
const AV_PIX_FMT_BGR444LE = 54 % Int32
const AV_PIX_FMT_BGR444BE = 55 % Int32
const AV_PIX_FMT_YA8 = 56 % Int32
const AV_PIX_FMT_Y400A = 56 % Int32
const AV_PIX_FMT_GRAY8A = 56 % Int32
const AV_PIX_FMT_BGR48BE = 57 % Int32
const AV_PIX_FMT_BGR48LE = 58 % Int32
const AV_PIX_FMT_YUV420P9BE = 59 % Int32
const AV_PIX_FMT_YUV420P9LE = 60 % Int32
const AV_PIX_FMT_YUV420P10BE = 61 % Int32
const AV_PIX_FMT_YUV420P10LE = 62 % Int32
const AV_PIX_FMT_YUV422P10BE = 63 % Int32
const AV_PIX_FMT_YUV422P10LE = 64 % Int32
const AV_PIX_FMT_YUV444P9BE = 65 % Int32
const AV_PIX_FMT_YUV444P9LE = 66 % Int32
const AV_PIX_FMT_YUV444P10BE = 67 % Int32
const AV_PIX_FMT_YUV444P10LE = 68 % Int32
const AV_PIX_FMT_YUV422P9BE = 69 % Int32
const AV_PIX_FMT_YUV422P9LE = 70 % Int32
const AV_PIX_FMT_GBRP = 71 % Int32
const AV_PIX_FMT_GBR24P = 71 % Int32
const AV_PIX_FMT_GBRP9BE = 72 % Int32
const AV_PIX_FMT_GBRP9LE = 73 % Int32
const AV_PIX_FMT_GBRP10BE = 74 % Int32
const AV_PIX_FMT_GBRP10LE = 75 % Int32
const AV_PIX_FMT_GBRP16BE = 76 % Int32
const AV_PIX_FMT_GBRP16LE = 77 % Int32
const AV_PIX_FMT_YUVA422P = 78 % Int32
const AV_PIX_FMT_YUVA444P = 79 % Int32
const AV_PIX_FMT_YUVA420P9BE = 80 % Int32
const AV_PIX_FMT_YUVA420P9LE = 81 % Int32
const AV_PIX_FMT_YUVA422P9BE = 82 % Int32
const AV_PIX_FMT_YUVA422P9LE = 83 % Int32
const AV_PIX_FMT_YUVA444P9BE = 84 % Int32
const AV_PIX_FMT_YUVA444P9LE = 85 % Int32
const AV_PIX_FMT_YUVA420P10BE = 86 % Int32
const AV_PIX_FMT_YUVA420P10LE = 87 % Int32
const AV_PIX_FMT_YUVA422P10BE = 88 % Int32
const AV_PIX_FMT_YUVA422P10LE = 89 % Int32
const AV_PIX_FMT_YUVA444P10BE = 90 % Int32
const AV_PIX_FMT_YUVA444P10LE = 91 % Int32
const AV_PIX_FMT_YUVA420P16BE = 92 % Int32
const AV_PIX_FMT_YUVA420P16LE = 93 % Int32
const AV_PIX_FMT_YUVA422P16BE = 94 % Int32
const AV_PIX_FMT_YUVA422P16LE = 95 % Int32
const AV_PIX_FMT_YUVA444P16BE = 96 % Int32
const AV_PIX_FMT_YUVA444P16LE = 97 % Int32
const AV_PIX_FMT_VDPAU = 98 % Int32
const AV_PIX_FMT_XYZ12LE = 99 % Int32
const AV_PIX_FMT_XYZ12BE = 100 % Int32
const AV_PIX_FMT_NV16 = 101 % Int32
const AV_PIX_FMT_NV20LE = 102 % Int32
const AV_PIX_FMT_NV20BE = 103 % Int32
const AV_PIX_FMT_RGBA64BE = 104 % Int32
const AV_PIX_FMT_RGBA64LE = 105 % Int32
const AV_PIX_FMT_BGRA64BE = 106 % Int32
const AV_PIX_FMT_BGRA64LE = 107 % Int32
const AV_PIX_FMT_YVYU422 = 108 % Int32
const AV_PIX_FMT_YA16BE = 109 % Int32
const AV_PIX_FMT_YA16LE = 110 % Int32
const AV_PIX_FMT_GBRAP = 111 % Int32
const AV_PIX_FMT_GBRAP16BE = 112 % Int32
const AV_PIX_FMT_GBRAP16LE = 113 % Int32
const AV_PIX_FMT_QSV = 114 % Int32
const AV_PIX_FMT_MMAL = 115 % Int32
const AV_PIX_FMT_D3D11VA_VLD = 116 % Int32
const AV_PIX_FMT_CUDA = 117 % Int32
const AV_PIX_FMT_0RGB = 118 % Int32
const AV_PIX_FMT_RGB0 = 119 % Int32
const AV_PIX_FMT_0BGR = 120 % Int32
const AV_PIX_FMT_BGR0 = 121 % Int32
const AV_PIX_FMT_YUV420P12BE = 122 % Int32
const AV_PIX_FMT_YUV420P12LE = 123 % Int32
const AV_PIX_FMT_YUV420P14BE = 124 % Int32
const AV_PIX_FMT_YUV420P14LE = 125 % Int32
const AV_PIX_FMT_YUV422P12BE = 126 % Int32
const AV_PIX_FMT_YUV422P12LE = 127 % Int32
const AV_PIX_FMT_YUV422P14BE = 128 % Int32
const AV_PIX_FMT_YUV422P14LE = 129 % Int32
const AV_PIX_FMT_YUV444P12BE = 130 % Int32
const AV_PIX_FMT_YUV444P12LE = 131 % Int32
const AV_PIX_FMT_YUV444P14BE = 132 % Int32
const AV_PIX_FMT_YUV444P14LE = 133 % Int32
const AV_PIX_FMT_GBRP12BE = 134 % Int32
const AV_PIX_FMT_GBRP12LE = 135 % Int32
const AV_PIX_FMT_GBRP14BE = 136 % Int32
const AV_PIX_FMT_GBRP14LE = 137 % Int32
const AV_PIX_FMT_YUVJ411P = 138 % Int32
const AV_PIX_FMT_BAYER_BGGR8 = 139 % Int32
const AV_PIX_FMT_BAYER_RGGB8 = 140 % Int32
const AV_PIX_FMT_BAYER_GBRG8 = 141 % Int32
const AV_PIX_FMT_BAYER_GRBG8 = 142 % Int32
const AV_PIX_FMT_BAYER_BGGR16LE = 143 % Int32
const AV_PIX_FMT_BAYER_BGGR16BE = 144 % Int32
const AV_PIX_FMT_BAYER_RGGB16LE = 145 % Int32
const AV_PIX_FMT_BAYER_RGGB16BE = 146 % Int32
const AV_PIX_FMT_BAYER_GBRG16LE = 147 % Int32
const AV_PIX_FMT_BAYER_GBRG16BE = 148 % Int32
const AV_PIX_FMT_BAYER_GRBG16LE = 149 % Int32
const AV_PIX_FMT_BAYER_GRBG16BE = 150 % Int32
const AV_PIX_FMT_YUV440P10LE = 151 % Int32
const AV_PIX_FMT_YUV440P10BE = 152 % Int32
const AV_PIX_FMT_YUV440P12LE = 153 % Int32
const AV_PIX_FMT_YUV440P12BE = 154 % Int32
const AV_PIX_FMT_AYUV64LE = 155 % Int32
const AV_PIX_FMT_AYUV64BE = 156 % Int32
const AV_PIX_FMT_VIDEOTOOLBOX = 157 % Int32
const AV_PIX_FMT_P010LE = 158 % Int32
const AV_PIX_FMT_P010BE = 159 % Int32
const AV_PIX_FMT_GBRAP12BE = 160 % Int32
const AV_PIX_FMT_GBRAP12LE = 161 % Int32
const AV_PIX_FMT_GBRAP10BE = 162 % Int32
const AV_PIX_FMT_GBRAP10LE = 163 % Int32
const AV_PIX_FMT_MEDIACODEC = 164 % Int32
const AV_PIX_FMT_GRAY12BE = 165 % Int32
const AV_PIX_FMT_GRAY12LE = 166 % Int32
const AV_PIX_FMT_GRAY10BE = 167 % Int32
const AV_PIX_FMT_GRAY10LE = 168 % Int32
const AV_PIX_FMT_P016LE = 169 % Int32
const AV_PIX_FMT_P016BE = 170 % Int32
const AV_PIX_FMT_D3D11 = 171 % Int32
const AV_PIX_FMT_GRAY9BE = 172 % Int32
const AV_PIX_FMT_GRAY9LE = 173 % Int32
const AV_PIX_FMT_GBRPF32BE = 174 % Int32
const AV_PIX_FMT_GBRPF32LE = 175 % Int32
const AV_PIX_FMT_GBRAPF32BE = 176 % Int32
const AV_PIX_FMT_GBRAPF32LE = 177 % Int32
const AV_PIX_FMT_DRM_PRIME = 178 % Int32
const AV_PIX_FMT_OPENCL = 179 % Int32
const AV_PIX_FMT_GRAY14BE = 180 % Int32
const AV_PIX_FMT_GRAY14LE = 181 % Int32
const AV_PIX_FMT_GRAYF32BE = 182 % Int32
const AV_PIX_FMT_GRAYF32LE = 183 % Int32
const AV_PIX_FMT_YUVA422P12BE = 184 % Int32
const AV_PIX_FMT_YUVA422P12LE = 185 % Int32
const AV_PIX_FMT_YUVA444P12BE = 186 % Int32
const AV_PIX_FMT_YUVA444P12LE = 187 % Int32
const AV_PIX_FMT_NV24 = 188 % Int32
const AV_PIX_FMT_NV42 = 189 % Int32
const AV_PIX_FMT_VULKAN = 190 % Int32
const AV_PIX_FMT_Y210BE = 191 % Int32
const AV_PIX_FMT_Y210LE = 192 % Int32
const AV_PIX_FMT_X2RGB10LE = 193 % Int32
const AV_PIX_FMT_X2RGB10BE = 194 % Int32
const AV_PIX_FMT_X2BGR10LE = 195 % Int32
const AV_PIX_FMT_X2BGR10BE = 196 % Int32
const AV_PIX_FMT_P210BE = 197 % Int32
const AV_PIX_FMT_P210LE = 198 % Int32
const AV_PIX_FMT_P410BE = 199 % Int32
const AV_PIX_FMT_P410LE = 200 % Int32
const AV_PIX_FMT_P216BE = 201 % Int32
const AV_PIX_FMT_P216LE = 202 % Int32
const AV_PIX_FMT_P416BE = 203 % Int32
const AV_PIX_FMT_P416LE = 204 % Int32
const AV_PIX_FMT_VUYA = 205 % Int32
const AV_PIX_FMT_RGBAF16BE = 206 % Int32
const AV_PIX_FMT_RGBAF16LE = 207 % Int32
const AV_PIX_FMT_VUYX = 208 % Int32
const AV_PIX_FMT_P012LE = 209 % Int32
const AV_PIX_FMT_P012BE = 210 % Int32
const AV_PIX_FMT_Y212BE = 211 % Int32
const AV_PIX_FMT_Y212LE = 212 % Int32
const AV_PIX_FMT_XV30BE = 213 % Int32
const AV_PIX_FMT_XV30LE = 214 % Int32
const AV_PIX_FMT_XV36BE = 215 % Int32
const AV_PIX_FMT_XV36LE = 216 % Int32
const AV_PIX_FMT_RGBF32BE = 217 % Int32
const AV_PIX_FMT_RGBF32LE = 218 % Int32
const AV_PIX_FMT_RGBAF32BE = 219 % Int32
const AV_PIX_FMT_RGBAF32LE = 220 % Int32
const AV_PIX_FMT_P212BE = 221 % Int32
const AV_PIX_FMT_P212LE = 222 % Int32
const AV_PIX_FMT_P412BE = 223 % Int32
const AV_PIX_FMT_P412LE = 224 % Int32
const AV_PIX_FMT_GBRAP14BE = 225 % Int32
const AV_PIX_FMT_GBRAP14LE = 226 % Int32
const AV_PIX_FMT_D3D12 = 227 % Int32
const AV_PIX_FMT_AYUV = 228 % Int32
const AV_PIX_FMT_UYVA = 229 % Int32
const AV_PIX_FMT_VYU444 = 230 % Int32
const AV_PIX_FMT_V30XBE = 231 % Int32
const AV_PIX_FMT_V30XLE = 232 % Int32
const AV_PIX_FMT_RGBF16BE = 233 % Int32
const AV_PIX_FMT_RGBF16LE = 234 % Int32
const AV_PIX_FMT_RGBA128BE = 235 % Int32
const AV_PIX_FMT_RGBA128LE = 236 % Int32
const AV_PIX_FMT_RGB96BE = 237 % Int32
const AV_PIX_FMT_RGB96LE = 238 % Int32
const AV_PIX_FMT_Y216BE = 239 % Int32
const AV_PIX_FMT_Y216LE = 240 % Int32
const AV_PIX_FMT_XV48BE = 241 % Int32
const AV_PIX_FMT_XV48LE = 242 % Int32
const AV_PIX_FMT_GBRPF16BE = 243 % Int32
const AV_PIX_FMT_GBRPF16LE = 244 % Int32
const AV_PIX_FMT_GBRAPF16BE = 245 % Int32
const AV_PIX_FMT_GBRAPF16LE = 246 % Int32
const AV_PIX_FMT_GRAYF16BE = 247 % Int32
const AV_PIX_FMT_GRAYF16LE = 248 % Int32
const AV_PIX_FMT_AMF_SURFACE = 249 % Int32
const AV_PIX_FMT_GRAY32BE = 250 % Int32
const AV_PIX_FMT_GRAY32LE = 251 % Int32
const AV_PIX_FMT_YAF32BE = 252 % Int32
const AV_PIX_FMT_YAF32LE = 253 % Int32
const AV_PIX_FMT_YAF16BE = 254 % Int32
const AV_PIX_FMT_YAF16LE = 255 % Int32
const AV_PIX_FMT_GBRAP32BE = 256 % Int32
const AV_PIX_FMT_GBRAP32LE = 257 % Int32
const AV_PIX_FMT_YUV444P10MSBBE = 258 % Int32
const AV_PIX_FMT_YUV444P10MSBLE = 259 % Int32
const AV_PIX_FMT_YUV444P12MSBBE = 260 % Int32
const AV_PIX_FMT_YUV444P12MSBLE = 261 % Int32
const AV_PIX_FMT_GBRP10MSBBE = 262 % Int32
const AV_PIX_FMT_GBRP10MSBLE = 263 % Int32
const AV_PIX_FMT_GBRP12MSBBE = 264 % Int32
const AV_PIX_FMT_GBRP12MSBLE = 265 % Int32
const AV_PIX_FMT_OHCODEC = 266 % Int32
const AV_PIX_FMT_NB = 267 % Int32

"""
    AVSampleFormat

Audio sample formats

- The data described by the sample format is always in native-endian order. Sample values can be expressed by native C types, hence the lack of a signed 24-bit sample format even though it is a common raw audio data format.

- The floating-point formats are based on full volume being in the range [-1.0, 1.0]. Any values outside this range are beyond full volume level.

- The data layout as used in [`av_samples_fill_arrays`](@ref)() and elsewhere in FFmpeg (such as [`AVFrame`](@ref) in libavcodec) is as follows:

\\par For planar sample formats, each audio channel is in a separate data plane, and linesize is the buffer size, in bytes, for a single plane. All data planes must be the same size. For packed sample formats, only the first data plane is used, and samples for each channel are interleaved. In this case, linesize is the buffer size, in bytes, for the 1 plane.
"""
const AVSampleFormat = Int32
const AV_SAMPLE_FMT_NONE = -1 % Int32
const AV_SAMPLE_FMT_U8 = 0 % Int32
const AV_SAMPLE_FMT_S16 = 1 % Int32
const AV_SAMPLE_FMT_S32 = 2 % Int32
const AV_SAMPLE_FMT_FLT = 3 % Int32
const AV_SAMPLE_FMT_DBL = 4 % Int32
const AV_SAMPLE_FMT_U8P = 5 % Int32
const AV_SAMPLE_FMT_S16P = 6 % Int32
const AV_SAMPLE_FMT_S32P = 7 % Int32
const AV_SAMPLE_FMT_FLTP = 8 % Int32
const AV_SAMPLE_FMT_DBLP = 9 % Int32
const AV_SAMPLE_FMT_S64 = 10 % Int32
const AV_SAMPLE_FMT_S64P = 11 % Int32
const AV_SAMPLE_FMT_NB = 12 % Int32

"""
    AVProfile

[`AVProfile`](@ref).
"""
struct AVProfile
    profile::Cint
    name::Cstring
end

const AVChannelOrder = UInt32
const AV_CHANNEL_ORDER_UNSPEC = 0 % UInt32
const AV_CHANNEL_ORDER_NATIVE = 1 % UInt32
const AV_CHANNEL_ORDER_CUSTOM = 2 % UInt32
const AV_CHANNEL_ORDER_AMBISONIC = 3 % UInt32
const FF_CHANNEL_ORDER_NB = 4 % UInt32

"""
    __JL_Ctag_93

Details about which channels are present in this layout. For AV\\_CHANNEL\\_ORDER\\_UNSPEC, this field is undefined and must not be used.
"""
struct __JL_Ctag_93
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{__JL_Ctag_93}, f::Symbol)
    f === :mask && return Ptr{UInt64}(x + 0)
    f === :map && return Ptr{Ptr{AVChannelCustom}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_93, f::Symbol)
    r = Ref{__JL_Ctag_93}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_93}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_93}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::__JL_Ctag_93, private::Bool = false)
    (:mask, :map, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVChannelLayout

An [`AVChannelLayout`](@ref) holds information about the channel layout of audio data.

A channel layout here is defined as a set of channels ordered in a specific way (unless the channel order is AV\\_CHANNEL\\_ORDER\\_UNSPEC, in which case an [`AVChannelLayout`](@ref) carries only the channel count). All orders may be treated as if they were AV\\_CHANNEL\\_ORDER\\_UNSPEC by ignoring everything but the channel count, as long as [`av_channel_layout_check`](@ref)() considers they are valid.

Unlike most structures in FFmpeg, sizeof([`AVChannelLayout`](@ref)) is a part of the public ABI and may be used by the caller. E.g. it may be allocated on stack or embedded in caller-defined structs.

[`AVChannelLayout`](@ref) can be initialized as follows: - default initialization with {0}, followed by setting all used fields correctly; - by assigning one of the predefined AV\\_CHANNEL\\_LAYOUT\\_* initializers; - with a constructor function, such as [`av_channel_layout_default`](@ref)(), [`av_channel_layout_from_mask`](@ref)() or [`av_channel_layout_from_string`](@ref)().

The channel layout must be uninitialized with [`av_channel_layout_uninit`](@ref)()

Copying an [`AVChannelLayout`](@ref) via assigning is forbidden, [`av_channel_layout_copy`](@ref)() must be used instead (and its return value should be checked)

No new fields may be added to it without a major version bump, except for new elements of the union fitting in sizeof(uint64\\_t).
"""
struct AVChannelLayout
    data::NTuple{24, UInt8}
end

function Base.getproperty(x::Ptr{AVChannelLayout}, f::Symbol)
    f === :order && return Ptr{AVChannelOrder}(x + 0)
    f === :nb_channels && return Ptr{Cint}(x + 4)
    f === :u && return Ptr{__JL_Ctag_93}(x + 8)
    f === :opaque && return Ptr{Ptr{Cvoid}}(x + 16)
    return getfield(x, f)
end

function Base.getproperty(x::AVChannelLayout, f::Symbol)
    r = Ref{AVChannelLayout}(x)
    ptr = Base.unsafe_convert(Ptr{AVChannelLayout}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVChannelLayout}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVChannelLayout, private::Bool = false)
    (:order, :nb_channels, :u, :opaque, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVCodec

[`AVCodec`](@ref).
"""
struct AVCodec
    data::NTuple{96, UInt8}
end

function Base.getproperty(x::Ptr{AVCodec}, f::Symbol)
    f === :name && return Ptr{Cstring}(x + 0)
    f === :long_name && return Ptr{Cstring}(x + 8)
    f === :type && return Ptr{AVMediaType}(x + 16)
    f === :id && return Ptr{AVCodecID}(x + 20)
    f === :capabilities && return Ptr{Cint}(x + 24)
    f === :max_lowres && return Ptr{UInt8}(x + 28)
    f === :supported_framerates && return Ptr{Ptr{AVRational}}(x + 32)
    f === :pix_fmts && return Ptr{Ptr{AVPixelFormat}}(x + 40)
    f === :supported_samplerates && return Ptr{Ptr{Cint}}(x + 48)
    f === :sample_fmts && return Ptr{Ptr{AVSampleFormat}}(x + 56)
    f === :priv_class && return Ptr{Ptr{AVClass}}(x + 64)
    f === :profiles && return Ptr{Ptr{AVProfile}}(x + 72)
    f === :wrapper_name && return Ptr{Cstring}(x + 80)
    f === :ch_layouts && return Ptr{Ptr{AVChannelLayout}}(x + 88)
    return getfield(x, f)
end

function Base.getproperty(x::AVCodec, f::Symbol)
    r = Ref{AVCodec}(x)
    ptr = Base.unsafe_convert(Ptr{AVCodec}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVCodec}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVCodec, private::Bool = false)
    (:name, :long_name, :type, :id, :capabilities, :max_lowres, :supported_framerates, :pix_fmts, :supported_samplerates, :sample_fmts, :priv_class, :profiles, :wrapper_name, :ch_layouts, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

mutable struct AVCodecInternal end

"""
    AVColorPrimaries

Chromaticity coordinates of the source primaries. These values match the ones defined by ISO/IEC 23091-2\\_2019 subclause 8.1 and ITU-T H.273.
"""
const AVColorPrimaries = UInt32
const AVCOL_PRI_RESERVED0 = 0 % UInt32
const AVCOL_PRI_BT709 = 1 % UInt32
const AVCOL_PRI_UNSPECIFIED = 2 % UInt32
const AVCOL_PRI_RESERVED = 3 % UInt32
const AVCOL_PRI_BT470M = 4 % UInt32
const AVCOL_PRI_BT470BG = 5 % UInt32
const AVCOL_PRI_SMPTE170M = 6 % UInt32
const AVCOL_PRI_SMPTE240M = 7 % UInt32
const AVCOL_PRI_FILM = 8 % UInt32
const AVCOL_PRI_BT2020 = 9 % UInt32
const AVCOL_PRI_SMPTE428 = 10 % UInt32
const AVCOL_PRI_SMPTEST428_1 = 10 % UInt32
const AVCOL_PRI_SMPTE431 = 11 % UInt32
const AVCOL_PRI_SMPTE432 = 12 % UInt32
const AVCOL_PRI_EBU3213 = 22 % UInt32
const AVCOL_PRI_JEDEC_P22 = 22 % UInt32
const AVCOL_PRI_NB = 23 % UInt32

"""
    AVColorTransferCharacteristic

Color Transfer Characteristic. These values match the ones defined by ISO/IEC 23091-2\\_2019 subclause 8.2.
"""
const AVColorTransferCharacteristic = UInt32
const AVCOL_TRC_RESERVED0 = 0 % UInt32
const AVCOL_TRC_BT709 = 1 % UInt32
const AVCOL_TRC_UNSPECIFIED = 2 % UInt32
const AVCOL_TRC_RESERVED = 3 % UInt32
const AVCOL_TRC_GAMMA22 = 4 % UInt32
const AVCOL_TRC_GAMMA28 = 5 % UInt32
const AVCOL_TRC_SMPTE170M = 6 % UInt32
const AVCOL_TRC_SMPTE240M = 7 % UInt32
const AVCOL_TRC_LINEAR = 8 % UInt32
const AVCOL_TRC_LOG = 9 % UInt32
const AVCOL_TRC_LOG_SQRT = 10 % UInt32
const AVCOL_TRC_IEC61966_2_4 = 11 % UInt32
const AVCOL_TRC_BT1361_ECG = 12 % UInt32
const AVCOL_TRC_IEC61966_2_1 = 13 % UInt32
const AVCOL_TRC_BT2020_10 = 14 % UInt32
const AVCOL_TRC_BT2020_12 = 15 % UInt32
const AVCOL_TRC_SMPTE2084 = 16 % UInt32
const AVCOL_TRC_SMPTEST2084 = 16 % UInt32
const AVCOL_TRC_SMPTE428 = 17 % UInt32
const AVCOL_TRC_SMPTEST428_1 = 17 % UInt32
const AVCOL_TRC_ARIB_STD_B67 = 18 % UInt32
const AVCOL_TRC_NB = 19 % UInt32

"""
    AVColorSpace

YUV colorspace type. These values match the ones defined by ISO/IEC 23091-2\\_2019 subclause 8.3.
"""
const AVColorSpace = UInt32
const AVCOL_SPC_RGB = 0 % UInt32
const AVCOL_SPC_BT709 = 1 % UInt32
const AVCOL_SPC_UNSPECIFIED = 2 % UInt32
const AVCOL_SPC_RESERVED = 3 % UInt32
const AVCOL_SPC_FCC = 4 % UInt32
const AVCOL_SPC_BT470BG = 5 % UInt32
const AVCOL_SPC_SMPTE170M = 6 % UInt32
const AVCOL_SPC_SMPTE240M = 7 % UInt32
const AVCOL_SPC_YCGCO = 8 % UInt32
const AVCOL_SPC_YCOCG = 8 % UInt32
const AVCOL_SPC_BT2020_NCL = 9 % UInt32
const AVCOL_SPC_BT2020_CL = 10 % UInt32
const AVCOL_SPC_SMPTE2085 = 11 % UInt32
const AVCOL_SPC_CHROMA_DERIVED_NCL = 12 % UInt32
const AVCOL_SPC_CHROMA_DERIVED_CL = 13 % UInt32
const AVCOL_SPC_ICTCP = 14 % UInt32
const AVCOL_SPC_IPT_C2 = 15 % UInt32
const AVCOL_SPC_YCGCO_RE = 16 % UInt32
const AVCOL_SPC_YCGCO_RO = 17 % UInt32
const AVCOL_SPC_NB = 18 % UInt32

"""
    AVColorRange

Visual content value range.

These values are based on definitions that can be found in multiple specifications, such as ITU-T BT.709 (3.4 - Quantization of RGB, luminance and colour-difference signals), ITU-T BT.2020 (Table 5 - Digital Representation) as well as ITU-T BT.2100 (Table 9 - Digital 10- and 12-bit integer representation). At the time of writing, the BT.2100 one is recommended, as it also defines the full range representation.

Common definitions: - For RGB and luma planes such as Y in YCbCr and I in ICtCp, 'E' is the original value in range of 0.0 to 1.0. - For chroma planes such as Cb,Cr and Ct,Cp, 'E' is the original value in range of -0.5 to 0.5. - 'n' is the output bit depth. - For additional definitions such as rounding and clipping to valid n bit unsigned integer range, please refer to BT.2100 (Table 9).
"""
const AVColorRange = UInt32
const AVCOL_RANGE_UNSPECIFIED = 0 % UInt32
const AVCOL_RANGE_MPEG = 1 % UInt32
const AVCOL_RANGE_JPEG = 2 % UInt32
const AVCOL_RANGE_NB = 3 % UInt32

"""
    AVChromaLocation

Location of chroma samples.

Illustration showing the location of the first (top left) chroma sample of the image, the left shows only luma, the right shows the location of the chroma sample, the 2 could be imagined to overlay each other but are drawn separately due to limitations of ASCII

1st 2nd 1st 2nd horizontal luma sample positions v v v v \\_\\_\\_\\_\\_\\_ \\_\\_\\_\\_\\_\\_1st luma line > |X X ... |3 4 X ... X are luma samples, | |1 2 1-6 are possible chroma positions2nd luma line > |X X ... |5 6 X ... 0 is undefined/unknown position
"""
const AVChromaLocation = UInt32
const AVCHROMA_LOC_UNSPECIFIED = 0 % UInt32
const AVCHROMA_LOC_LEFT = 1 % UInt32
const AVCHROMA_LOC_CENTER = 2 % UInt32
const AVCHROMA_LOC_TOPLEFT = 3 % UInt32
const AVCHROMA_LOC_TOP = 4 % UInt32
const AVCHROMA_LOC_BOTTOMLEFT = 5 % UInt32
const AVCHROMA_LOC_BOTTOM = 6 % UInt32
const AVCHROMA_LOC_NB = 7 % UInt32

const AVFieldOrder = UInt32
const AV_FIELD_UNKNOWN = 0 % UInt32
const AV_FIELD_PROGRESSIVE = 1 % UInt32
const AV_FIELD_TT = 2 % UInt32
const AV_FIELD_BB = 3 % UInt32
const AV_FIELD_TB = 4 % UInt32
const AV_FIELD_BT = 5 % UInt32

const AVAudioServiceType = UInt32
const AV_AUDIO_SERVICE_TYPE_MAIN = 0 % UInt32
const AV_AUDIO_SERVICE_TYPE_EFFECTS = 1 % UInt32
const AV_AUDIO_SERVICE_TYPE_VISUALLY_IMPAIRED = 2 % UInt32
const AV_AUDIO_SERVICE_TYPE_HEARING_IMPAIRED = 3 % UInt32
const AV_AUDIO_SERVICE_TYPE_DIALOGUE = 4 % UInt32
const AV_AUDIO_SERVICE_TYPE_COMMENTARY = 5 % UInt32
const AV_AUDIO_SERVICE_TYPE_EMERGENCY = 6 % UInt32
const AV_AUDIO_SERVICE_TYPE_VOICE_OVER = 7 % UInt32
const AV_AUDIO_SERVICE_TYPE_KARAOKE = 8 % UInt32
const AV_AUDIO_SERVICE_TYPE_NB = 9 % UInt32

"""
    AVHWAccel

` lavc_hwaccel AVHWAccel`

!!! note

    Nothing in this structure should be accessed by the user. At some point in future it will not be externally visible at all.

@{
"""
struct AVHWAccel
    name::Cstring
    type::AVMediaType
    id::AVCodecID
    pix_fmt::AVPixelFormat
    capabilities::Cint
end

"""
    AVBufferRef

A reference to a data buffer.

The size of this struct is not a part of the public ABI and it is not meant to be allocated directly.
"""
struct AVBufferRef
    buffer::Ptr{AVBuffer}
    data::Ptr{UInt8}
    size::Csize_t
end

"""
    AVDiscard

` lavc_decoding`
"""
const AVDiscard = Int32
const AVDISCARD_NONE = -16 % Int32
const AVDISCARD_DEFAULT = 0 % Int32
const AVDISCARD_NONREF = 8 % Int32
const AVDISCARD_BIDIR = 16 % Int32
const AVDISCARD_NONINTRA = 24 % Int32
const AVDISCARD_NONKEY = 32 % Int32
const AVDISCARD_ALL = 48 % Int32

"""
    AVCodecDescriptor

This struct describes the properties of a single codec described by an [`AVCodecID`](@ref).

# See also
[`avcodec_descriptor_get`](@ref)()
"""
struct AVCodecDescriptor
    id::AVCodecID
    type::AVMediaType
    name::Cstring
    long_name::Cstring
    props::Cint
    mime_types::Ptr{Cstring}
    profiles::Ptr{AVProfile}
end

"""
    AVPacketSideDataType

` lavc_packet_side_data AVPacketSideData`

Types and functions for working with [`AVPacketSideData`](@ref). @{
"""
const AVPacketSideDataType = UInt32
const AV_PKT_DATA_PALETTE = 0 % UInt32
const AV_PKT_DATA_NEW_EXTRADATA = 1 % UInt32
const AV_PKT_DATA_PARAM_CHANGE = 2 % UInt32
const AV_PKT_DATA_H263_MB_INFO = 3 % UInt32
const AV_PKT_DATA_REPLAYGAIN = 4 % UInt32
const AV_PKT_DATA_DISPLAYMATRIX = 5 % UInt32
const AV_PKT_DATA_STEREO3D = 6 % UInt32
const AV_PKT_DATA_AUDIO_SERVICE_TYPE = 7 % UInt32
const AV_PKT_DATA_QUALITY_STATS = 8 % UInt32
const AV_PKT_DATA_FALLBACK_TRACK = 9 % UInt32
const AV_PKT_DATA_CPB_PROPERTIES = 10 % UInt32
const AV_PKT_DATA_SKIP_SAMPLES = 11 % UInt32
const AV_PKT_DATA_JP_DUALMONO = 12 % UInt32
const AV_PKT_DATA_STRINGS_METADATA = 13 % UInt32
const AV_PKT_DATA_SUBTITLE_POSITION = 14 % UInt32
const AV_PKT_DATA_MATROSKA_BLOCKADDITIONAL = 15 % UInt32
const AV_PKT_DATA_WEBVTT_IDENTIFIER = 16 % UInt32
const AV_PKT_DATA_WEBVTT_SETTINGS = 17 % UInt32
const AV_PKT_DATA_METADATA_UPDATE = 18 % UInt32
const AV_PKT_DATA_MPEGTS_STREAM_ID = 19 % UInt32
const AV_PKT_DATA_MASTERING_DISPLAY_METADATA = 20 % UInt32
const AV_PKT_DATA_SPHERICAL = 21 % UInt32
const AV_PKT_DATA_CONTENT_LIGHT_LEVEL = 22 % UInt32
const AV_PKT_DATA_A53_CC = 23 % UInt32
const AV_PKT_DATA_ENCRYPTION_INIT_INFO = 24 % UInt32
const AV_PKT_DATA_ENCRYPTION_INFO = 25 % UInt32
const AV_PKT_DATA_AFD = 26 % UInt32
const AV_PKT_DATA_PRFT = 27 % UInt32
const AV_PKT_DATA_ICC_PROFILE = 28 % UInt32
const AV_PKT_DATA_DOVI_CONF = 29 % UInt32
const AV_PKT_DATA_S12M_TIMECODE = 30 % UInt32
const AV_PKT_DATA_DYNAMIC_HDR10_PLUS = 31 % UInt32
const AV_PKT_DATA_IAMF_MIX_GAIN_PARAM = 32 % UInt32
const AV_PKT_DATA_IAMF_DEMIXING_INFO_PARAM = 33 % UInt32
const AV_PKT_DATA_IAMF_RECON_GAIN_INFO_PARAM = 34 % UInt32
const AV_PKT_DATA_AMBIENT_VIEWING_ENVIRONMENT = 35 % UInt32
const AV_PKT_DATA_FRAME_CROPPING = 36 % UInt32
const AV_PKT_DATA_LCEVC = 37 % UInt32
const AV_PKT_DATA_3D_REFERENCE_DISPLAYS = 38 % UInt32
const AV_PKT_DATA_RTCP_SR = 39 % UInt32
const AV_PKT_DATA_NB = 40 % UInt32

"""
    AVPacketSideData

This structure stores auxiliary information for decoding, presenting, or otherwise processing the coded stream. It is typically exported by demuxers and encoders and can be fed to decoders and muxers either in a per packet basis, or as global side data (applying to the entire coded stream).

Global side data is handled as follows: - During demuxing, it may be exported through AVCodecParameters.coded_side_data "[`AVStream`](@ref)'s codec parameters", which can then be passed as input to decoders through the AVCodecContext.coded_side_data "decoder context's side data", for initialization. - For muxing, it can be fed through AVCodecParameters.coded_side_data "[`AVStream`](@ref)'s codec parameters", typically the output of encoders through the AVCodecContext.coded_side_data "encoder context's side data", for initialization.

Packet specific side data is handled as follows: - During demuxing, it may be exported through AVPacket.side_data "[`AVPacket`](@ref)'s side data", which can then be passed as input to decoders. - For muxing, it can be fed through AVPacket.side_data "[`AVPacket`](@ref)'s side data", typically the output of encoders.

Different modules may accept or export different types of side data depending on media type and codec. Refer to AVPacketSideDataType for a list of defined types and where they may be found or used.
"""
struct AVPacketSideData
    data::Ptr{UInt8}
    size::Csize_t
    type::AVPacketSideDataType
end

"""
    AVFrameSideDataType

` lavu_frame AVFrame`

` lavu_data`

@{ [`AVFrame`](@ref) is an abstraction for reference-counted raw multimedia data.
"""
const AVFrameSideDataType = UInt32
const AV_FRAME_DATA_PANSCAN = 0 % UInt32
const AV_FRAME_DATA_A53_CC = 1 % UInt32
const AV_FRAME_DATA_STEREO3D = 2 % UInt32
const AV_FRAME_DATA_MATRIXENCODING = 3 % UInt32
const AV_FRAME_DATA_DOWNMIX_INFO = 4 % UInt32
const AV_FRAME_DATA_REPLAYGAIN = 5 % UInt32
const AV_FRAME_DATA_DISPLAYMATRIX = 6 % UInt32
const AV_FRAME_DATA_AFD = 7 % UInt32
const AV_FRAME_DATA_MOTION_VECTORS = 8 % UInt32
const AV_FRAME_DATA_SKIP_SAMPLES = 9 % UInt32
const AV_FRAME_DATA_AUDIO_SERVICE_TYPE = 10 % UInt32
const AV_FRAME_DATA_MASTERING_DISPLAY_METADATA = 11 % UInt32
const AV_FRAME_DATA_GOP_TIMECODE = 12 % UInt32
const AV_FRAME_DATA_SPHERICAL = 13 % UInt32
const AV_FRAME_DATA_CONTENT_LIGHT_LEVEL = 14 % UInt32
const AV_FRAME_DATA_ICC_PROFILE = 15 % UInt32
const AV_FRAME_DATA_S12M_TIMECODE = 16 % UInt32
const AV_FRAME_DATA_DYNAMIC_HDR_PLUS = 17 % UInt32
const AV_FRAME_DATA_REGIONS_OF_INTEREST = 18 % UInt32
const AV_FRAME_DATA_VIDEO_ENC_PARAMS = 19 % UInt32
const AV_FRAME_DATA_SEI_UNREGISTERED = 20 % UInt32
const AV_FRAME_DATA_FILM_GRAIN_PARAMS = 21 % UInt32
const AV_FRAME_DATA_DETECTION_BBOXES = 22 % UInt32
const AV_FRAME_DATA_DOVI_RPU_BUFFER = 23 % UInt32
const AV_FRAME_DATA_DOVI_METADATA = 24 % UInt32
const AV_FRAME_DATA_DYNAMIC_HDR_VIVID = 25 % UInt32
const AV_FRAME_DATA_AMBIENT_VIEWING_ENVIRONMENT = 26 % UInt32
const AV_FRAME_DATA_VIDEO_HINT = 27 % UInt32
const AV_FRAME_DATA_LCEVC = 28 % UInt32
const AV_FRAME_DATA_VIEW_ID = 29 % UInt32
const AV_FRAME_DATA_3D_REFERENCE_DISPLAYS = 30 % UInt32

"""
    AVFrameSideData

Structure to hold side data for an [`AVFrame`](@ref).

sizeof([`AVFrameSideData`](@ref)) is not a part of the public ABI, so new fields may be added to the end with a minor bump.
"""
struct AVFrameSideData
    type::AVFrameSideDataType
    data::Ptr{UInt8}
    size::Csize_t
    metadata::Ptr{AVDictionary}
    buf::Ptr{AVBufferRef}
end

"""
    AVCodecContext

main external API structure. New fields can be added to the end with minor version bumps. Removal, reordering and changes to existing fields require a major version bump. You can use AVOptions (av\\_opt* / av\\_set/get*()) to access these fields from user applications. The name string for AVOptions options matches the associated command line parameter name and can be found in libavcodec/options\\_table.h The [`AVOption`](@ref)/command line parameter names differ in some cases from the C structure field names for historic reasons or brevity. sizeof([`AVCodecContext`](@ref)) must not be used outside libav*.
"""
struct AVCodecContext
    data::NTuple{864, UInt8}
end

function Base.getproperty(x::Ptr{AVCodecContext}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :log_level_offset && return Ptr{Cint}(x + 8)
    f === :codec_type && return Ptr{AVMediaType}(x + 12)
    f === :codec && return Ptr{Ptr{AVCodec}}(x + 16)
    f === :codec_id && return Ptr{AVCodecID}(x + 24)
    f === :codec_tag && return Ptr{Cuint}(x + 28)
    f === :priv_data && return Ptr{Ptr{Cvoid}}(x + 32)
    f === :internal && return Ptr{Ptr{AVCodecInternal}}(x + 40)
    f === :opaque && return Ptr{Ptr{Cvoid}}(x + 48)
    f === :bit_rate && return Ptr{Int64}(x + 56)
    f === :flags && return Ptr{Cint}(x + 64)
    f === :flags2 && return Ptr{Cint}(x + 68)
    f === :extradata && return Ptr{Ptr{UInt8}}(x + 72)
    f === :extradata_size && return Ptr{Cint}(x + 80)
    f === :time_base && return Ptr{AVRational}(x + 84)
    f === :pkt_timebase && return Ptr{AVRational}(x + 92)
    f === :framerate && return Ptr{AVRational}(x + 100)
    f === :delay && return Ptr{Cint}(x + 108)
    f === :width && return Ptr{Cint}(x + 112)
    f === :height && return Ptr{Cint}(x + 116)
    f === :coded_width && return Ptr{Cint}(x + 120)
    f === :coded_height && return Ptr{Cint}(x + 124)
    f === :sample_aspect_ratio && return Ptr{AVRational}(x + 128)
    f === :pix_fmt && return Ptr{AVPixelFormat}(x + 136)
    f === :sw_pix_fmt && return Ptr{AVPixelFormat}(x + 140)
    f === :color_primaries && return Ptr{AVColorPrimaries}(x + 144)
    f === :color_trc && return Ptr{AVColorTransferCharacteristic}(x + 148)
    f === :colorspace && return Ptr{AVColorSpace}(x + 152)
    f === :color_range && return Ptr{AVColorRange}(x + 156)
    f === :chroma_sample_location && return Ptr{AVChromaLocation}(x + 160)
    f === :field_order && return Ptr{AVFieldOrder}(x + 164)
    f === :refs && return Ptr{Cint}(x + 168)
    f === :has_b_frames && return Ptr{Cint}(x + 172)
    f === :slice_flags && return Ptr{Cint}(x + 176)
    f === :draw_horiz_band && return Ptr{Ptr{Cvoid}}(x + 184)
    f === :get_format && return Ptr{Ptr{Cvoid}}(x + 192)
    f === :max_b_frames && return Ptr{Cint}(x + 200)
    f === :b_quant_factor && return Ptr{Cfloat}(x + 204)
    f === :b_quant_offset && return Ptr{Cfloat}(x + 208)
    f === :i_quant_factor && return Ptr{Cfloat}(x + 212)
    f === :i_quant_offset && return Ptr{Cfloat}(x + 216)
    f === :lumi_masking && return Ptr{Cfloat}(x + 220)
    f === :temporal_cplx_masking && return Ptr{Cfloat}(x + 224)
    f === :spatial_cplx_masking && return Ptr{Cfloat}(x + 228)
    f === :p_masking && return Ptr{Cfloat}(x + 232)
    f === :dark_masking && return Ptr{Cfloat}(x + 236)
    f === :nsse_weight && return Ptr{Cint}(x + 240)
    f === :me_cmp && return Ptr{Cint}(x + 244)
    f === :me_sub_cmp && return Ptr{Cint}(x + 248)
    f === :mb_cmp && return Ptr{Cint}(x + 252)
    f === :ildct_cmp && return Ptr{Cint}(x + 256)
    f === :dia_size && return Ptr{Cint}(x + 260)
    f === :last_predictor_count && return Ptr{Cint}(x + 264)
    f === :me_pre_cmp && return Ptr{Cint}(x + 268)
    f === :pre_dia_size && return Ptr{Cint}(x + 272)
    f === :me_subpel_quality && return Ptr{Cint}(x + 276)
    f === :me_range && return Ptr{Cint}(x + 280)
    f === :mb_decision && return Ptr{Cint}(x + 284)
    f === :intra_matrix && return Ptr{Ptr{UInt16}}(x + 288)
    f === :inter_matrix && return Ptr{Ptr{UInt16}}(x + 296)
    f === :chroma_intra_matrix && return Ptr{Ptr{UInt16}}(x + 304)
    f === :intra_dc_precision && return Ptr{Cint}(x + 312)
    f === :mb_lmin && return Ptr{Cint}(x + 316)
    f === :mb_lmax && return Ptr{Cint}(x + 320)
    f === :bidir_refine && return Ptr{Cint}(x + 324)
    f === :keyint_min && return Ptr{Cint}(x + 328)
    f === :gop_size && return Ptr{Cint}(x + 332)
    f === :mv0_threshold && return Ptr{Cint}(x + 336)
    f === :slices && return Ptr{Cint}(x + 340)
    f === :sample_rate && return Ptr{Cint}(x + 344)
    f === :sample_fmt && return Ptr{AVSampleFormat}(x + 348)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 352)
    f === :frame_size && return Ptr{Cint}(x + 376)
    f === :block_align && return Ptr{Cint}(x + 380)
    f === :cutoff && return Ptr{Cint}(x + 384)
    f === :audio_service_type && return Ptr{AVAudioServiceType}(x + 388)
    f === :request_sample_fmt && return Ptr{AVSampleFormat}(x + 392)
    f === :initial_padding && return Ptr{Cint}(x + 396)
    f === :trailing_padding && return Ptr{Cint}(x + 400)
    f === :seek_preroll && return Ptr{Cint}(x + 404)
    f === :get_buffer2 && return Ptr{Ptr{Cvoid}}(x + 408)
    f === :bit_rate_tolerance && return Ptr{Cint}(x + 416)
    f === :global_quality && return Ptr{Cint}(x + 420)
    f === :compression_level && return Ptr{Cint}(x + 424)
    f === :qcompress && return Ptr{Cfloat}(x + 428)
    f === :qblur && return Ptr{Cfloat}(x + 432)
    f === :qmin && return Ptr{Cint}(x + 436)
    f === :qmax && return Ptr{Cint}(x + 440)
    f === :max_qdiff && return Ptr{Cint}(x + 444)
    f === :rc_buffer_size && return Ptr{Cint}(x + 448)
    f === :rc_override_count && return Ptr{Cint}(x + 452)
    f === :rc_override && return Ptr{Ptr{RcOverride}}(x + 456)
    f === :rc_max_rate && return Ptr{Int64}(x + 464)
    f === :rc_min_rate && return Ptr{Int64}(x + 472)
    f === :rc_max_available_vbv_use && return Ptr{Cfloat}(x + 480)
    f === :rc_min_vbv_overflow_use && return Ptr{Cfloat}(x + 484)
    f === :rc_initial_buffer_occupancy && return Ptr{Cint}(x + 488)
    f === :trellis && return Ptr{Cint}(x + 492)
    f === :stats_out && return Ptr{Cstring}(x + 496)
    f === :stats_in && return Ptr{Cstring}(x + 504)
    f === :workaround_bugs && return Ptr{Cint}(x + 512)
    f === :strict_std_compliance && return Ptr{Cint}(x + 516)
    f === :error_concealment && return Ptr{Cint}(x + 520)
    f === :debug && return Ptr{Cint}(x + 524)
    f === :err_recognition && return Ptr{Cint}(x + 528)
    f === :hwaccel && return Ptr{Ptr{AVHWAccel}}(x + 536)
    f === :hwaccel_context && return Ptr{Ptr{Cvoid}}(x + 544)
    f === :hw_frames_ctx && return Ptr{Ptr{AVBufferRef}}(x + 552)
    f === :hw_device_ctx && return Ptr{Ptr{AVBufferRef}}(x + 560)
    f === :hwaccel_flags && return Ptr{Cint}(x + 568)
    f === :extra_hw_frames && return Ptr{Cint}(x + 572)
    f === :error && return Ptr{NTuple{8, UInt64}}(x + 576)
    f === :dct_algo && return Ptr{Cint}(x + 640)
    f === :idct_algo && return Ptr{Cint}(x + 644)
    f === :bits_per_coded_sample && return Ptr{Cint}(x + 648)
    f === :bits_per_raw_sample && return Ptr{Cint}(x + 652)
    f === :thread_count && return Ptr{Cint}(x + 656)
    f === :thread_type && return Ptr{Cint}(x + 660)
    f === :active_thread_type && return Ptr{Cint}(x + 664)
    f === :execute && return Ptr{Ptr{Cvoid}}(x + 672)
    f === :execute2 && return Ptr{Ptr{Cvoid}}(x + 680)
    f === :profile && return Ptr{Cint}(x + 688)
    f === :level && return Ptr{Cint}(x + 692)
    f === :properties && return Ptr{Cuint}(x + 696)
    f === :skip_loop_filter && return Ptr{AVDiscard}(x + 700)
    f === :skip_idct && return Ptr{AVDiscard}(x + 704)
    f === :skip_frame && return Ptr{AVDiscard}(x + 708)
    f === :skip_alpha && return Ptr{Cint}(x + 712)
    f === :skip_top && return Ptr{Cint}(x + 716)
    f === :skip_bottom && return Ptr{Cint}(x + 720)
    f === :lowres && return Ptr{Cint}(x + 724)
    f === :codec_descriptor && return Ptr{Ptr{AVCodecDescriptor}}(x + 728)
    f === :sub_charenc && return Ptr{Cstring}(x + 736)
    f === :sub_charenc_mode && return Ptr{Cint}(x + 744)
    f === :subtitle_header_size && return Ptr{Cint}(x + 748)
    f === :subtitle_header && return Ptr{Ptr{UInt8}}(x + 752)
    f === :dump_separator && return Ptr{Ptr{UInt8}}(x + 760)
    f === :codec_whitelist && return Ptr{Cstring}(x + 768)
    f === :coded_side_data && return Ptr{Ptr{AVPacketSideData}}(x + 776)
    f === :nb_coded_side_data && return Ptr{Cint}(x + 784)
    f === :export_side_data && return Ptr{Cint}(x + 788)
    f === :max_pixels && return Ptr{Int64}(x + 792)
    f === :apply_cropping && return Ptr{Cint}(x + 800)
    f === :discard_damaged_percentage && return Ptr{Cint}(x + 804)
    f === :max_samples && return Ptr{Int64}(x + 808)
    f === :get_encode_buffer && return Ptr{Ptr{Cvoid}}(x + 816)
    f === :frame_num && return Ptr{Int64}(x + 824)
    f === :side_data_prefer_packet && return Ptr{Ptr{Cint}}(x + 832)
    f === :nb_side_data_prefer_packet && return Ptr{Cuint}(x + 840)
    f === :decoded_side_data && return Ptr{Ptr{Ptr{AVFrameSideData}}}(x + 848)
    f === :nb_decoded_side_data && return Ptr{Cint}(x + 856)
    return getfield(x, f)
end

function Base.getproperty(x::AVCodecContext, f::Symbol)
    r = Ref{AVCodecContext}(x)
    ptr = Base.unsafe_convert(Ptr{AVCodecContext}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVCodecContext}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVCodecContext, private::Bool = false)
    (:av_class, :log_level_offset, :codec_type, :codec, :codec_id, :codec_tag, :priv_data, :internal, :opaque, :bit_rate, :flags, :flags2, :extradata, :extradata_size, :time_base, :pkt_timebase, :framerate, :delay, :width, :height, :coded_width, :coded_height, :sample_aspect_ratio, :pix_fmt, :sw_pix_fmt, :color_primaries, :color_trc, :colorspace, :color_range, :chroma_sample_location, :field_order, :refs, :has_b_frames, :slice_flags, :draw_horiz_band, :get_format, :max_b_frames, :b_quant_factor, :b_quant_offset, :i_quant_factor, :i_quant_offset, :lumi_masking, :temporal_cplx_masking, :spatial_cplx_masking, :p_masking, :dark_masking, :nsse_weight, :me_cmp, :me_sub_cmp, :mb_cmp, :ildct_cmp, :dia_size, :last_predictor_count, :me_pre_cmp, :pre_dia_size, :me_subpel_quality, :me_range, :mb_decision, :intra_matrix, :inter_matrix, :chroma_intra_matrix, :intra_dc_precision, :mb_lmin, :mb_lmax, :bidir_refine, :keyint_min, :gop_size, :mv0_threshold, :slices, :sample_rate, :sample_fmt, :ch_layout, :frame_size, :block_align, :cutoff, :audio_service_type, :request_sample_fmt, :initial_padding, :trailing_padding, :seek_preroll, :get_buffer2, :bit_rate_tolerance, :global_quality, :compression_level, :qcompress, :qblur, :qmin, :qmax, :max_qdiff, :rc_buffer_size, :rc_override_count, :rc_override, :rc_max_rate, :rc_min_rate, :rc_max_available_vbv_use, :rc_min_vbv_overflow_use, :rc_initial_buffer_occupancy, :trellis, :stats_out, :stats_in, :workaround_bugs, :strict_std_compliance, :error_concealment, :debug, :err_recognition, :hwaccel, :hwaccel_context, :hw_frames_ctx, :hw_device_ctx, :hwaccel_flags, :extra_hw_frames, :error, :dct_algo, :idct_algo, :bits_per_coded_sample, :bits_per_raw_sample, :thread_count, :thread_type, :active_thread_type, :execute, :execute2, :profile, :level, :properties, :skip_loop_filter, :skip_idct, :skip_frame, :skip_alpha, :skip_top, :skip_bottom, :lowres, :codec_descriptor, :sub_charenc, :sub_charenc_mode, :subtitle_header_size, :subtitle_header, :dump_separator, :codec_whitelist, :coded_side_data, :nb_coded_side_data, :export_side_data, :max_pixels, :apply_cropping, :discard_damaged_percentage, :max_samples, :get_encode_buffer, :frame_num, :side_data_prefer_packet, :nb_side_data_prefer_packet, :decoded_side_data, :nb_decoded_side_data, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVSubtitleType

@}
"""
const AVSubtitleType = UInt32
const SUBTITLE_NONE = 0 % UInt32
const SUBTITLE_BITMAP = 1 % UInt32
const SUBTITLE_TEXT = 2 % UInt32
const SUBTITLE_ASS = 3 % UInt32

struct AVSubtitleRect
    x::Cint
    y::Cint
    w::Cint
    h::Cint
    nb_colors::Cint
    data::NTuple{4, Ptr{UInt8}}
    linesize::NTuple{4, Cint}
    flags::Cint
    type::AVSubtitleType
    text::Cstring
    ass::Cstring
end

struct AVSubtitle
    format::UInt16
    start_display_time::UInt32
    end_display_time::UInt32
    num_rects::Cuint
    rects::Ptr{Ptr{AVSubtitleRect}}
    pts::Int64
end

"""
    avcodec_version()

Return the [`LIBAVCODEC_VERSION_INT`](@ref) constant.
"""
function avcodec_version()
    ccall((:avcodec_version, libavcodec), Cuint, ())
end

"""
    avcodec_configuration()

Return the libavcodec build-time configuration.
"""
function avcodec_configuration()
    ccall((:avcodec_configuration, libavcodec), Cstring, ())
end

"""
    avcodec_license()

Return the libavcodec license.
"""
function avcodec_license()
    ccall((:avcodec_license, libavcodec), Cstring, ())
end

"""
    avcodec_alloc_context3(codec)

Allocate an [`AVCodecContext`](@ref) and set its fields to default values. The resulting struct should be freed with [`avcodec_free_context`](@ref)().

# Arguments
* `codec`: if non-NULL, allocate private data and initialize defaults for the given codec. It is illegal to then call [`avcodec_open2`](@ref)() with a different codec. If NULL, then the codec-specific defaults won't be initialized, which may result in suboptimal default settings (this is important mainly for encoders, e.g. libx264).
# Returns
An [`AVCodecContext`](@ref) filled with default values or NULL on failure.
"""
function avcodec_alloc_context3(codec)
    ccall((:avcodec_alloc_context3, libavcodec), Ptr{AVCodecContext}, (Ptr{AVCodec},), codec)
end

"""
    avcodec_free_context(avctx)

Free the codec context and everything associated with it and write NULL to the provided pointer.
"""
function avcodec_free_context(avctx)
    ccall((:avcodec_free_context, libavcodec), Cvoid, (Ptr{Ptr{AVCodecContext}},), avctx)
end

"""
    avcodec_get_class()

Get the [`AVClass`](@ref) for [`AVCodecContext`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function avcodec_get_class()
    ccall((:avcodec_get_class, libavcodec), Ptr{AVClass}, ())
end

"""
    avcodec_get_subtitle_rect_class()

Get the [`AVClass`](@ref) for [`AVSubtitleRect`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function avcodec_get_subtitle_rect_class()
    ccall((:avcodec_get_subtitle_rect_class, libavcodec), Ptr{AVClass}, ())
end

"""
    AVCodecParameters

This struct describes the properties of an encoded stream.

sizeof([`AVCodecParameters`](@ref)) is not a part of the public ABI, this struct must be allocated with [`avcodec_parameters_alloc`](@ref)() and freed with [`avcodec_parameters_free`](@ref)().
"""
struct AVCodecParameters
    data::NTuple{176, UInt8}
end

function Base.getproperty(x::Ptr{AVCodecParameters}, f::Symbol)
    f === :codec_type && return Ptr{AVMediaType}(x + 0)
    f === :codec_id && return Ptr{AVCodecID}(x + 4)
    f === :codec_tag && return Ptr{UInt32}(x + 8)
    f === :extradata && return Ptr{Ptr{UInt8}}(x + 16)
    f === :extradata_size && return Ptr{Cint}(x + 24)
    f === :coded_side_data && return Ptr{Ptr{AVPacketSideData}}(x + 32)
    f === :nb_coded_side_data && return Ptr{Cint}(x + 40)
    f === :format && return Ptr{Cint}(x + 44)
    f === :bit_rate && return Ptr{Int64}(x + 48)
    f === :bits_per_coded_sample && return Ptr{Cint}(x + 56)
    f === :bits_per_raw_sample && return Ptr{Cint}(x + 60)
    f === :profile && return Ptr{Cint}(x + 64)
    f === :level && return Ptr{Cint}(x + 68)
    f === :width && return Ptr{Cint}(x + 72)
    f === :height && return Ptr{Cint}(x + 76)
    f === :sample_aspect_ratio && return Ptr{AVRational}(x + 80)
    f === :framerate && return Ptr{AVRational}(x + 88)
    f === :field_order && return Ptr{AVFieldOrder}(x + 96)
    f === :color_range && return Ptr{AVColorRange}(x + 100)
    f === :color_primaries && return Ptr{AVColorPrimaries}(x + 104)
    f === :color_trc && return Ptr{AVColorTransferCharacteristic}(x + 108)
    f === :color_space && return Ptr{AVColorSpace}(x + 112)
    f === :chroma_location && return Ptr{AVChromaLocation}(x + 116)
    f === :video_delay && return Ptr{Cint}(x + 120)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 128)
    f === :sample_rate && return Ptr{Cint}(x + 152)
    f === :block_align && return Ptr{Cint}(x + 156)
    f === :frame_size && return Ptr{Cint}(x + 160)
    f === :initial_padding && return Ptr{Cint}(x + 164)
    f === :trailing_padding && return Ptr{Cint}(x + 168)
    f === :seek_preroll && return Ptr{Cint}(x + 172)
    return getfield(x, f)
end

function Base.getproperty(x::AVCodecParameters, f::Symbol)
    r = Ref{AVCodecParameters}(x)
    ptr = Base.unsafe_convert(Ptr{AVCodecParameters}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVCodecParameters}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVCodecParameters, private::Bool = false)
    (:codec_type, :codec_id, :codec_tag, :extradata, :extradata_size, :coded_side_data, :nb_coded_side_data, :format, :bit_rate, :bits_per_coded_sample, :bits_per_raw_sample, :profile, :level, :width, :height, :sample_aspect_ratio, :framerate, :field_order, :color_range, :color_primaries, :color_trc, :color_space, :chroma_location, :video_delay, :ch_layout, :sample_rate, :block_align, :frame_size, :initial_padding, :trailing_padding, :seek_preroll, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    avcodec_parameters_from_context(par, codec)

Fill the parameters struct based on the values from the supplied codec context. Any allocated fields in par are freed and replaced with duplicates of the corresponding fields in codec.

# Returns
>= 0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function avcodec_parameters_from_context(par, codec)
    ccall((:avcodec_parameters_from_context, libavcodec), Cint, (Ptr{AVCodecParameters}, Ptr{AVCodecContext}), par, codec)
end

"""
    avcodec_parameters_to_context(codec, par)

Fill the codec context based on the values from the supplied codec parameters. Any allocated fields in codec that have a corresponding field in par are freed and replaced with duplicates of the corresponding field in par. Fields in codec that do not have a counterpart in par are not touched.

# Returns
>= 0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function avcodec_parameters_to_context(codec, par)
    ccall((:avcodec_parameters_to_context, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVCodecParameters}), codec, par)
end

"""
    avcodec_open2(avctx, codec, options)

Initialize the [`AVCodecContext`](@ref) to use the given [`AVCodec`](@ref). Prior to using this function the context has to be allocated with [`avcodec_alloc_context3`](@ref)().

The functions [`avcodec_find_decoder_by_name`](@ref)(), [`avcodec_find_encoder_by_name`](@ref)(), [`avcodec_find_decoder`](@ref)() and [`avcodec_find_encoder`](@ref)() provide an easy way for retrieving a codec.

Depending on the codec, you might need to set options in the codec context also for decoding (e.g. width, height, or the pixel or audio sample format in the case the information is not available in the bitstream, as when decoding raw audio or video).

Options in the codec context can be set either by setting them in the options [`AVDictionary`](@ref), or by setting the values in the context itself, directly or by using the [`av_opt_set`](@ref)() API before calling this function.

Example:

```c++
 av_dict_set(&opts, "b", "2.5M", 0);
 codec = avcodec_find_decoder(AV_CODEC_ID_H264);
 if (!codec)
     exit(1);

 context = avcodec_alloc_context3(codec);

 if (avcodec_open2(context, codec, opts) < 0)
     exit(1);
```

In the case [`AVCodecParameters`](@ref) are available (e.g. when demuxing a stream using libavformat, and accessing the [`AVStream`](@ref) contained in the demuxer), the codec parameters can be copied to the codec context using [`avcodec_parameters_to_context`](@ref)(), as in the following example:

```c++
 AVStream *stream = ...;
 context = avcodec_alloc_context3(codec);
 if (avcodec_parameters_to_context(context, stream->codecpar) < 0)
     exit(1);
 if (avcodec_open2(context, codec, NULL) < 0)
     exit(1);
```

!!! note

    Always call this function before using decoding routines (such as avcodec_receive_frame()).

# Arguments
* `avctx`: The context to initialize.
* `codec`: The codec to open this context for. If a non-NULL codec has been previously passed to [`avcodec_alloc_context3`](@ref)() or for this context, then this parameter MUST be either NULL or equal to the previously passed codec.
* `options`: A dictionary filled with [`AVCodecContext`](@ref) and codec-private options, which are set on top of the options already set in avctx, can be NULL. On return this object will be filled with options that were not found in the avctx codec context.
# Returns
zero on success, a negative value on error
# See also
[`avcodec_alloc_context3`](@ref)(), [`avcodec_find_decoder`](@ref)(), [`avcodec_find_encoder`](@ref)(), [`av_dict_set`](@ref)(), [`av_opt_set`](@ref)(), [`av_opt_find`](@ref)(), [`avcodec_parameters_to_context`](@ref)()
"""
function avcodec_open2(avctx, codec, options)
    ccall((:avcodec_open2, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVCodec}, Ptr{Ptr{AVDictionary}}), avctx, codec, options)
end

"""
    avsubtitle_free(sub)

Free all allocated data in the given subtitle struct.

# Arguments
* `sub`: [`AVSubtitle`](@ref) to free.
"""
function avsubtitle_free(sub)
    ccall((:avsubtitle_free, libavcodec), Cvoid, (Ptr{AVSubtitle},), sub)
end

"""
    AVPictureType

@} @}

` lavu_picture Image related`

AVPicture types, pixel formats and basic image planes manipulation.

@{
"""
const AVPictureType = UInt32
const AV_PICTURE_TYPE_NONE = 0 % UInt32
const AV_PICTURE_TYPE_I = 1 % UInt32
const AV_PICTURE_TYPE_P = 2 % UInt32
const AV_PICTURE_TYPE_B = 3 % UInt32
const AV_PICTURE_TYPE_S = 4 % UInt32
const AV_PICTURE_TYPE_SI = 5 % UInt32
const AV_PICTURE_TYPE_SP = 6 % UInt32
const AV_PICTURE_TYPE_BI = 7 % UInt32

"""
    AVFrame

This structure describes decoded (raw) audio or video data.

[`AVFrame`](@ref) must be allocated using [`av_frame_alloc`](@ref)(). Note that this only allocates the [`AVFrame`](@ref) itself, the buffers for the data must be managed through other means (see below). [`AVFrame`](@ref) must be freed with [`av_frame_free`](@ref)().

[`AVFrame`](@ref) is typically allocated once and then reused multiple times to hold different data (e.g. a single [`AVFrame`](@ref) to hold frames received from a decoder). In such a case, [`av_frame_unref`](@ref)() will free any references held by the frame and reset it to its original clean state before it is reused again.

The data described by an [`AVFrame`](@ref) is usually reference counted through the [`AVBuffer`](@ref) API. The underlying buffer references are stored in [`AVFrame`](@ref).buf / [`AVFrame`](@ref).extended\\_buf. An [`AVFrame`](@ref) is considered to be reference counted if at least one reference is set, i.e. if [`AVFrame`](@ref).buf[0] != NULL. In such a case, every single data plane must be contained in one of the buffers in [`AVFrame`](@ref).buf or [`AVFrame`](@ref).extended\\_buf. There may be a single buffer for all the data, or one separate buffer for each plane, or anything in between.

sizeof([`AVFrame`](@ref)) is not a part of the public ABI, so new fields may be added to the end with a minor bump.

Fields can be accessed through AVOptions, the name string used, matches the C structure field name for fields accessible through AVOptions.
"""
struct AVFrame
    data::NTuple{416, UInt8}
end

function Base.getproperty(x::Ptr{AVFrame}, f::Symbol)
    f === :data && return Ptr{NTuple{8, Ptr{UInt8}}}(x + 0)
    f === :linesize && return Ptr{NTuple{8, Cint}}(x + 64)
    f === :extended_data && return Ptr{Ptr{Ptr{UInt8}}}(x + 96)
    f === :width && return Ptr{Cint}(x + 104)
    f === :height && return Ptr{Cint}(x + 108)
    f === :nb_samples && return Ptr{Cint}(x + 112)
    f === :format && return Ptr{Cint}(x + 116)
    f === :pict_type && return Ptr{AVPictureType}(x + 120)
    f === :sample_aspect_ratio && return Ptr{AVRational}(x + 124)
    f === :pts && return Ptr{Int64}(x + 136)
    f === :pkt_dts && return Ptr{Int64}(x + 144)
    f === :time_base && return Ptr{AVRational}(x + 152)
    f === :quality && return Ptr{Cint}(x + 160)
    f === :opaque && return Ptr{Ptr{Cvoid}}(x + 168)
    f === :repeat_pict && return Ptr{Cint}(x + 176)
    f === :sample_rate && return Ptr{Cint}(x + 180)
    f === :buf && return Ptr{NTuple{8, Ptr{AVBufferRef}}}(x + 184)
    f === :extended_buf && return Ptr{Ptr{Ptr{AVBufferRef}}}(x + 248)
    f === :nb_extended_buf && return Ptr{Cint}(x + 256)
    f === :side_data && return Ptr{Ptr{Ptr{AVFrameSideData}}}(x + 264)
    f === :nb_side_data && return Ptr{Cint}(x + 272)
    f === :flags && return Ptr{Cint}(x + 276)
    f === :color_range && return Ptr{AVColorRange}(x + 280)
    f === :color_primaries && return Ptr{AVColorPrimaries}(x + 284)
    f === :color_trc && return Ptr{AVColorTransferCharacteristic}(x + 288)
    f === :colorspace && return Ptr{AVColorSpace}(x + 292)
    f === :chroma_location && return Ptr{AVChromaLocation}(x + 296)
    f === :best_effort_timestamp && return Ptr{Int64}(x + 304)
    f === :metadata && return Ptr{Ptr{AVDictionary}}(x + 312)
    f === :decode_error_flags && return Ptr{Cint}(x + 320)
    f === :hw_frames_ctx && return Ptr{Ptr{AVBufferRef}}(x + 328)
    f === :opaque_ref && return Ptr{Ptr{AVBufferRef}}(x + 336)
    f === :crop_top && return Ptr{Csize_t}(x + 344)
    f === :crop_bottom && return Ptr{Csize_t}(x + 352)
    f === :crop_left && return Ptr{Csize_t}(x + 360)
    f === :crop_right && return Ptr{Csize_t}(x + 368)
    f === :private_ref && return Ptr{Ptr{Cvoid}}(x + 376)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 384)
    f === :duration && return Ptr{Int64}(x + 408)
    return getfield(x, f)
end

function Base.getproperty(x::AVFrame, f::Symbol)
    r = Ref{AVFrame}(x)
    ptr = Base.unsafe_convert(Ptr{AVFrame}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVFrame}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVFrame, private::Bool = false)
    (:data, :linesize, :extended_data, :width, :height, :nb_samples, :format, :pict_type, :sample_aspect_ratio, :pts, :pkt_dts, :time_base, :quality, :opaque, :repeat_pict, :sample_rate, :buf, :extended_buf, :nb_extended_buf, :side_data, :nb_side_data, :flags, :color_range, :color_primaries, :color_trc, :colorspace, :chroma_location, :best_effort_timestamp, :metadata, :decode_error_flags, :hw_frames_ctx, :opaque_ref, :crop_top, :crop_bottom, :crop_left, :crop_right, :private_ref, :ch_layout, :duration, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    avcodec_default_get_buffer2(s, frame, flags::Integer)

The default callback for [`AVCodecContext`](@ref).get\\_buffer2(). It is made public so it can be called by custom get\\_buffer2() implementations for decoders without [`AV_CODEC_CAP_DR1`](@ref) set.
"""
function avcodec_default_get_buffer2(s, frame, flags::Integer)
    ccall((:avcodec_default_get_buffer2, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVFrame}, Cint), s, frame, flags)
end

"""
    AVPacket

This structure stores compressed data. It is typically exported by demuxers and then passed as input to decoders, or received as output from encoders and then passed to muxers.

For video, it should typically contain one compressed frame. For audio it may contain several compressed frames. Encoders are allowed to output empty packets, with no compressed data, containing only side data (e.g. to update some stream parameters at the end of encoding).

The semantics of data ownership depends on the buf field. If it is set, the packet data is dynamically allocated and is valid indefinitely until a call to [`av_packet_unref`](@ref)() reduces the reference count to 0.

If the buf field is not set [`av_packet_ref`](@ref)() would make a copy instead of increasing the reference count.

The side data is always allocated with [`av_malloc`](@ref)(), copied by [`av_packet_ref`](@ref)() and freed by [`av_packet_unref`](@ref)().

sizeof([`AVPacket`](@ref)) being a part of the public ABI is deprecated. once [`av_init_packet`](@ref)() is removed, new packets will only be able to be allocated with [`av_packet_alloc`](@ref)(), and new fields may be added to the end of the struct with a minor bump.

# See also
[`av_packet_alloc`](@ref), [`av_packet_ref`](@ref), [`av_packet_unref`](@ref)
"""
struct AVPacket
    buf::Ptr{AVBufferRef}
    pts::Int64
    dts::Int64
    data::Ptr{UInt8}
    size::Cint
    stream_index::Cint
    flags::Cint
    side_data::Ptr{AVPacketSideData}
    side_data_elems::Cint
    duration::Int64
    pos::Int64
    opaque::Ptr{Cvoid}
    opaque_ref::Ptr{AVBufferRef}
    time_base::AVRational
end

"""
    avcodec_default_get_encode_buffer(s, pkt, flags::Integer)

The default callback for [`AVCodecContext`](@ref).get\\_encode\\_buffer(). It is made public so it can be called by custom get\\_encode\\_buffer() implementations for encoders without [`AV_CODEC_CAP_DR1`](@ref) set.
"""
function avcodec_default_get_encode_buffer(s, pkt, flags::Integer)
    ccall((:avcodec_default_get_encode_buffer, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVPacket}, Cint), s, pkt, flags)
end

"""
    avcodec_align_dimensions(s, width, height)

Modify width and height values so that they will result in a memory buffer that is acceptable for the codec if you do not use any horizontal padding.

May only be used if a codec with [`AV_CODEC_CAP_DR1`](@ref) has been opened.
"""
function avcodec_align_dimensions(s, width, height)
    ccall((:avcodec_align_dimensions, libavcodec), Cvoid, (Ptr{AVCodecContext}, Ptr{Cint}, Ptr{Cint}), s, width, height)
end

"""
    avcodec_align_dimensions2(s, width, height, linesize_align)

Modify width and height values so that they will result in a memory buffer that is acceptable for the codec if you also ensure that all line sizes are a multiple of the respective linesize\\_align[i].

May only be used if a codec with [`AV_CODEC_CAP_DR1`](@ref) has been opened.
"""
function avcodec_align_dimensions2(s, width, height, linesize_align)
    ccall((:avcodec_align_dimensions2, libavcodec), Cvoid, (Ptr{AVCodecContext}, Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), s, width, height, linesize_align)
end

"""
    avcodec_decode_subtitle2(avctx, sub, got_sub_ptr, avpkt)

Decode a subtitle message. Return a negative value on error, otherwise return the number of bytes used. If no subtitle could be decompressed, got\\_sub\\_ptr is zero. Otherwise, the subtitle is stored in *sub. Note that [`AV_CODEC_CAP_DR1`](@ref) is not available for subtitle codecs. This is for simplicity, because the performance difference is expected to be negligible and reusing a get\\_buffer written for video codecs would probably perform badly due to a potentially very different allocation pattern.

Some decoders (those marked with [`AV_CODEC_CAP_DELAY`](@ref)) have a delay between input and output. This means that for some packets they will not immediately produce decoded output and need to be flushed at the end of decoding to get all the decoded data. Flushing is done by calling this function with packets with avpkt->data set to NULL and avpkt->size set to 0 until it stops returning subtitles. It is safe to flush even those decoders that are not marked with [`AV_CODEC_CAP_DELAY`](@ref), then no subtitles will be returned.

!!! note

    The [`AVCodecContext`](@ref) MUST have been opened with avcodec_open2() before packets may be fed to the decoder.

# Arguments
* `avctx`: the codec context
* `sub`:\\[out\\] The preallocated [`AVSubtitle`](@ref) in which the decoded subtitle will be stored, must be freed with [`avsubtitle_free`](@ref) if *got\\_sub\\_ptr is set.
* `got_sub_ptr`:\\[in,out\\] Zero if no subtitle could be decompressed, otherwise, it is nonzero.
* `avpkt`:\\[in\\] The input [`AVPacket`](@ref) containing the input buffer.
"""
function avcodec_decode_subtitle2(avctx, sub, got_sub_ptr, avpkt)
    ccall((:avcodec_decode_subtitle2, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVSubtitle}, Ptr{Cint}, Ptr{AVPacket}), avctx, sub, got_sub_ptr, avpkt)
end

"""
    avcodec_send_packet(avctx, avpkt)

Supply raw packet data as input to a decoder.

Internally, this call will copy relevant [`AVCodecContext`](@ref) fields, which can influence decoding per-packet, and apply them when the packet is actually decoded. (For example [`AVCodecContext`](@ref).skip\\_frame, which might direct the decoder to drop the frame contained by the packet sent with this function.)

!!! warning

    The input buffer, avpkt->data must be [`AV_INPUT_BUFFER_PADDING_SIZE`](@ref) larger than the actual read bytes because some optimized bitstream readers read 32 or 64 bits at once and could read over the end.

!!! note

    The [`AVCodecContext`](@ref) MUST have been opened with avcodec_open2() before packets may be fed to the decoder.

\\retval0 success

\\retvalAVERROR(EAGAIN) input is not accepted in the current state - user must read output with [`avcodec_receive_frame`](@ref)() (once all output is read, the packet should be resent, and the call will not fail with EAGAIN).

\\retvalAVERROR_EOF the decoder has been flushed, and no new packets can be sent to it (also returned if more than 1 flush packet is sent)

\\retvalAVERROR(EINVAL) codec not opened, it is an encoder, or requires flush

\\retvalAVERROR(ENOMEM) failed to add packet to internal queue, or similar

\\retval"another negative error code" legitimate decoding errors

# Arguments
* `avctx`: codec context
* `avpkt`:\\[in\\] The input [`AVPacket`](@ref). Usually, this will be a single video frame, or several complete audio frames. Ownership of the packet remains with the caller, and the decoder will not write to the packet. The decoder may create a reference to the packet data (or copy it if the packet is not reference-counted). Unlike with older APIs, the packet is always fully consumed, and if it contains multiple frames (e.g. some audio codecs), will require you to call [`avcodec_receive_frame`](@ref)() multiple times afterwards before you can send a new packet. It can be NULL (or an [`AVPacket`](@ref) with data set to NULL and size set to 0); in this case, it is considered a flush packet, which signals the end of the stream. Sending the first flush packet will return success. Subsequent ones are unnecessary and will return [`AVERROR_EOF`](@ref). If the decoder still has frames buffered, it will return them after sending a flush packet.
"""
function avcodec_send_packet(avctx, avpkt)
    ccall((:avcodec_send_packet, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVPacket}), avctx, avpkt)
end

"""
    avcodec_receive_frame(avctx, frame)

Return decoded output data from a decoder or encoder (when the AV_CODEC_FLAG_RECON_FRAME flag is used).

\\retval0 success, a frame was returned

\\retvalAVERROR(EAGAIN) output is not available in this state - user must try to send new input

\\retvalAVERROR_EOF the codec has been fully flushed, and there will be no more output frames

\\retvalAVERROR(EINVAL) codec not opened, or it is an encoder without the AV_CODEC_FLAG_RECON_FRAME flag enabled

\\retval"other negative error code" legitimate decoding errors

# Arguments
* `avctx`: codec context
* `frame`: This will be set to a reference-counted video or audio frame (depending on the decoder type) allocated by the codec. Note that the function will always call [`av_frame_unref`](@ref)(frame) before doing anything else.
"""
function avcodec_receive_frame(avctx, frame)
    ccall((:avcodec_receive_frame, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVFrame}), avctx, frame)
end

"""
    avcodec_send_frame(avctx, frame)

Supply a raw video or audio frame to the encoder. Use [`avcodec_receive_packet`](@ref)() to retrieve buffered output packets.

For audio: If [`AV_CODEC_CAP_VARIABLE_FRAME_SIZE`](@ref) is set, then each frame can have any number of samples. If it is not set, frame->nb\\_samples must be equal to avctx->frame\\_size for all frames except the last. The final frame may be smaller than avctx->frame\\_size.

\\retval0 success

\\retvalAVERROR(EAGAIN) input is not accepted in the current state - user must read output with [`avcodec_receive_packet`](@ref)() (once all output is read, the packet should be resent, and the call will not fail with EAGAIN).

\\retvalAVERROR_EOF the encoder has been flushed, and no new frames can be sent to it

\\retvalAVERROR(EINVAL) codec not opened, it is a decoder, or requires flush

\\retvalAVERROR(ENOMEM) failed to add packet to internal queue, or similar

\\retval"another negative error code" legitimate encoding errors

# Arguments
* `avctx`: codec context
* `frame`:\\[in\\] [`AVFrame`](@ref) containing the raw audio or video frame to be encoded. Ownership of the frame remains with the caller, and the encoder will not write to the frame. The encoder may create a reference to the frame data (or copy it if the frame is not reference-counted). It can be NULL, in which case it is considered a flush packet. This signals the end of the stream. If the encoder still has packets buffered, it will return them after this call. Once flushing mode has been entered, additional flush packets are ignored, and sending frames will return [`AVERROR_EOF`](@ref).
"""
function avcodec_send_frame(avctx, frame)
    ccall((:avcodec_send_frame, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVFrame}), avctx, frame)
end

"""
    avcodec_receive_packet(avctx, avpkt)

Read encoded data from the encoder.

\\retval0 success

\\retvalAVERROR(EAGAIN) output is not available in the current state - user must try to send input

\\retvalAVERROR_EOF the encoder has been fully flushed, and there will be no more output packets

\\retvalAVERROR(EINVAL) codec not opened, or it is a decoder

\\retval"another negative error code" legitimate encoding errors

# Arguments
* `avctx`: codec context
* `avpkt`: This will be set to a reference-counted packet allocated by the encoder. Note that the function will always call [`av_packet_unref`](@ref)(avpkt) before doing anything else.
"""
function avcodec_receive_packet(avctx, avpkt)
    ccall((:avcodec_receive_packet, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVPacket}), avctx, avpkt)
end

"""
    avcodec_get_hw_frames_parameters(avctx, device_ref, hw_pix_fmt::AVPixelFormat, out_frames_ref)

Create and return a [`AVHWFramesContext`](@ref) with values adequate for hardware decoding. This is meant to get called from the get\\_format callback, and is a helper for preparing a [`AVHWFramesContext`](@ref) for [`AVCodecContext`](@ref).hw\\_frames\\_ctx. This API is for decoding with certain hardware acceleration modes/APIs only.

The returned [`AVHWFramesContext`](@ref) is not initialized. The caller must do this with [`av_hwframe_ctx_init`](@ref)().

Calling this function is not a requirement, but makes it simpler to avoid codec or hardware API specific details when manually allocating frames.

Alternatively to this, an API user can set [`AVCodecContext`](@ref).hw\\_device\\_ctx, which sets up [`AVCodecContext`](@ref).hw\\_frames\\_ctx fully automatically, and makes it unnecessary to call this function or having to care about [`AVHWFramesContext`](@ref) initialization at all.

There are a number of requirements for calling this function:

- It must be called from get\\_format with the same avctx parameter that was passed to get\\_format. Calling it outside of get\\_format is not allowed, and can trigger undefined behavior. - The function is not always supported (see description of return values). Even if this function returns successfully, hwaccel initialization could fail later. (The degree to which implementations check whether the stream is actually supported varies. Some do this check only after the user's get\\_format callback returns.) - The hw\\_pix\\_fmt must be one of the choices suggested by get\\_format. If the user decides to use a [`AVHWFramesContext`](@ref) prepared with this API function, the user must return the same hw\\_pix\\_fmt from get\\_format. - The device\\_ref passed to this function must support the given hw\\_pix\\_fmt. - After calling this API function, it is the user's responsibility to initialize the [`AVHWFramesContext`](@ref) (returned by the out\\_frames\\_ref parameter), and to set [`AVCodecContext`](@ref).hw\\_frames\\_ctx to it. If done, this must be done before returning from get\\_format (this is implied by the normal [`AVCodecContext`](@ref).hw\\_frames\\_ctx API rules). - The [`AVHWFramesContext`](@ref) parameters may change every time time get\\_format is called. Also, [`AVCodecContext`](@ref).hw\\_frames\\_ctx is reset before get\\_format. So you are inherently required to go through this process again on every get\\_format call. - It is perfectly possible to call this function without actually using the resulting [`AVHWFramesContext`](@ref). One use-case might be trying to reuse a previously initialized [`AVHWFramesContext`](@ref), and calling this API function only to test whether the required frame parameters have changed. - Fields that use dynamically allocated values of any kind must not be set by the user unless setting them is explicitly allowed by the documentation. If the user sets [`AVHWFramesContext`](@ref).free and [`AVHWFramesContext`](@ref).user\\_opaque, the new free callback must call the potentially set previous free callback. This API call may set any dynamically allocated fields, including the free callback.

The function will set at least the following fields on [`AVHWFramesContext`](@ref) (potentially more, depending on hwaccel API):

- All fields set by [`av_hwframe_ctx_alloc`](@ref)(). - Set the format field to hw\\_pix\\_fmt. - Set the sw\\_format field to the most suited and most versatile format. (An implication is that this will prefer generic formats over opaque formats with arbitrary restrictions, if possible.) - Set the width/height fields to the coded frame size, rounded up to the API-specific minimum alignment. - Only \\_if\\_ the hwaccel requires a pre-allocated pool: set the initial\\_pool\\_size field to the number of maximum reference surfaces possible with the codec, plus 1 surface for the user to work (meaning the user can safely reference at most 1 decoded surface at a time), plus additional buffering introduced by frame threading. If the hwaccel does not require pre-allocation, the field is left to 0, and the decoder will allocate new surfaces on demand during decoding. - Possibly [`AVHWFramesContext`](@ref).hwctx fields, depending on the underlying hardware API.

Essentially, out\\_frames\\_ref returns the same as [`av_hwframe_ctx_alloc`](@ref)(), but with basic frame parameters set.

The function is stateless, and does not change the [`AVCodecContext`](@ref) or the device\\_ref [`AVHWDeviceContext`](@ref).

# Arguments
* `avctx`: The context which is currently calling get\\_format, and which implicitly contains all state needed for filling the returned [`AVHWFramesContext`](@ref) properly.
* `device_ref`: A reference to the [`AVHWDeviceContext`](@ref) describing the device which will be used by the hardware decoder.
* `hw_pix_fmt`: The hwaccel format you are going to return from get\\_format.
* `out_frames_ref`: On success, set to a reference to an \\_uninitialized\\_ [`AVHWFramesContext`](@ref), created from the given device\\_ref. Fields will be set to values required for decoding. Not changed if an error is returned.
# Returns
zero on success, a negative value on error. The following error codes have special semantics: [`AVERROR`](@ref)(ENOENT): the decoder does not support this functionality. Setup is always manual, or it is a decoder which does not support setting [`AVCodecContext`](@ref).hw\\_frames\\_ctx at all, or it is a software format. [`AVERROR`](@ref)(EINVAL): it is known that hardware decoding is not supported for this configuration, or the device\\_ref is not supported for the hwaccel referenced by hw\\_pix\\_fmt.
"""
function avcodec_get_hw_frames_parameters(avctx, device_ref, hw_pix_fmt::AVPixelFormat, out_frames_ref)
    ccall((:avcodec_get_hw_frames_parameters, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVBufferRef}, AVPixelFormat, Ptr{Ptr{AVBufferRef}}), avctx, device_ref, hw_pix_fmt, out_frames_ref)
end

const AVCodecConfig = UInt32
const AV_CODEC_CONFIG_PIX_FORMAT = 0 % UInt32
const AV_CODEC_CONFIG_FRAME_RATE = 1 % UInt32
const AV_CODEC_CONFIG_SAMPLE_RATE = 2 % UInt32
const AV_CODEC_CONFIG_SAMPLE_FORMAT = 3 % UInt32
const AV_CODEC_CONFIG_CHANNEL_LAYOUT = 4 % UInt32
const AV_CODEC_CONFIG_COLOR_RANGE = 5 % UInt32
const AV_CODEC_CONFIG_COLOR_SPACE = 6 % UInt32

"""
    avcodec_get_supported_config(avctx, codec, config::AVCodecConfig, flags::Integer, out_configs, out_num_configs)

Retrieve a list of all supported values for a given configuration type.

# Arguments
* `avctx`: An optional context to use. Values such as `strict_std_compliance` may affect the result. If NULL, default values are used.
* `codec`: The codec to query, or NULL to use avctx->codec.
* `config`: The configuration to query.
* `flags`: Currently unused; should be set to zero.
* `out_configs`: On success, set to a list of configurations, terminated by a config-specific terminator, or NULL if all possible values are supported.
* `out_num_configs`: On success, set to the number of elements inout\\_configs, excluding the terminator. Optional.
"""
function avcodec_get_supported_config(avctx, codec, config::AVCodecConfig, flags::Integer, out_configs, out_num_configs)
    ccall((:avcodec_get_supported_config, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVCodec}, AVCodecConfig, Cuint, Ptr{Ptr{Cvoid}}, Ptr{Cint}), avctx, codec, config, flags, out_configs, out_num_configs)
end

"""
    AVPictureStructure

` lavc_parsing Frame parsing`

@{
"""
const AVPictureStructure = UInt32
const AV_PICTURE_STRUCTURE_UNKNOWN = 0 % UInt32
const AV_PICTURE_STRUCTURE_TOP_FIELD = 1 % UInt32
const AV_PICTURE_STRUCTURE_BOTTOM_FIELD = 2 % UInt32
const AV_PICTURE_STRUCTURE_FRAME = 3 % UInt32

struct AVCodecParser
    codec_ids::NTuple{7, Cint}
    priv_data_size::Cint
    parser_init::Ptr{Cvoid}
    parser_parse::Ptr{Cvoid}
    parser_close::Ptr{Cvoid}
    split::Ptr{Cvoid}
end

struct AVCodecParserContext
    priv_data::Ptr{Cvoid}
    parser::Ptr{AVCodecParser}
    frame_offset::Int64
    cur_offset::Int64
    next_frame_offset::Int64
    pict_type::Cint
    repeat_pict::Cint
    pts::Int64
    dts::Int64
    last_pts::Int64
    last_dts::Int64
    fetch_timestamp::Cint
    cur_frame_start_index::Cint
    cur_frame_offset::NTuple{4, Int64}
    cur_frame_pts::NTuple{4, Int64}
    cur_frame_dts::NTuple{4, Int64}
    flags::Cint
    offset::Int64
    cur_frame_end::NTuple{4, Int64}
    key_frame::Cint
    dts_sync_point::Cint
    dts_ref_dts_delta::Cint
    pts_dts_delta::Cint
    cur_frame_pos::NTuple{4, Int64}
    pos::Int64
    last_pos::Int64
    duration::Cint
    field_order::AVFieldOrder
    picture_structure::AVPictureStructure
    output_picture_number::Cint
    width::Cint
    height::Cint
    coded_width::Cint
    coded_height::Cint
    format::Cint
end

"""
    av_parser_iterate(opaque)

Iterate over all registered codec parsers.

# Arguments
* `opaque`: a pointer where libavcodec will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered codec parser or NULL when the iteration is finished
"""
function av_parser_iterate(opaque)
    ccall((:av_parser_iterate, libavcodec), Ptr{AVCodecParser}, (Ptr{Ptr{Cvoid}},), opaque)
end

function av_parser_init(codec_id::Integer)
    ccall((:av_parser_init, libavcodec), Ptr{AVCodecParserContext}, (Cint,), codec_id)
end

"""
    av_parser_parse2(s, avctx, poutbuf, poutbuf_size, buf, buf_size::Integer, pts::Int64, dts::Int64, pos::Int64)

Parse a packet.

Example:

```c++
   while(in_len){
       len = av_parser_parse2(myparser, AVCodecContext, &data, &size,
                                        in_data, in_len,
                                        pts, dts, pos);
       in_data += len;
       in_len  -= len;

       if(size)
          decode_frame(data, size);
   }
```

# Arguments
* `s`: parser context.
* `avctx`: codec context.
* `poutbuf`: set to pointer to parsed buffer or NULL if not yet finished.
* `poutbuf_size`: set to size of parsed buffer or zero if not yet finished.
* `buf`: input buffer.
* `buf_size`: buffer size in bytes without the padding. I.e. the full buffer size is assumed to be buf\\_size + [`AV_INPUT_BUFFER_PADDING_SIZE`](@ref). To signal EOF, this should be 0 (so that the last frame can be output).
* `pts`: input presentation timestamp.
* `dts`: input decoding timestamp.
* `pos`: input byte position in stream.
# Returns
the number of bytes of the input bitstream used.
"""
function av_parser_parse2(s, avctx, poutbuf, poutbuf_size, buf, buf_size::Integer, pts::Int64, dts::Int64, pos::Int64)
    ccall((:av_parser_parse2, libavcodec), Cint, (Ptr{AVCodecParserContext}, Ptr{AVCodecContext}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{UInt8}, Cint, Int64, Int64, Int64), s, avctx, poutbuf, poutbuf_size, buf, buf_size, pts, dts, pos)
end

function av_parser_close(s)
    ccall((:av_parser_close, libavcodec), Cvoid, (Ptr{AVCodecParserContext},), s)
end

"""
    avcodec_encode_subtitle(avctx, buf, buf_size::Integer, sub)

` lavc_encoding`

@{
"""
function avcodec_encode_subtitle(avctx, buf, buf_size::Integer, sub)
    ccall((:avcodec_encode_subtitle, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{UInt8}, Cint, Ptr{AVSubtitle}), avctx, buf, buf_size, sub)
end

"""
    avcodec_pix_fmt_to_codec_tag(pix_fmt::AVPixelFormat)

Return a value representing the fourCC code associated to the pixel format pix\\_fmt, or 0 if no associated fourCC code can be found.
"""
function avcodec_pix_fmt_to_codec_tag(pix_fmt::AVPixelFormat)
    ccall((:avcodec_pix_fmt_to_codec_tag, libavcodec), Cuint, (AVPixelFormat,), pix_fmt)
end

"""
    avcodec_find_best_pix_fmt_of_list(pix_fmt_list, src_pix_fmt::AVPixelFormat, has_alpha::Integer, loss_ptr)

Find the best pixel format to convert to given a certain source pixel format. When converting from one pixel format to another, information loss may occur. For example, when converting from RGB24 to GRAY, the color information will be lost. Similarly, other losses occur when converting from some formats to other formats. avcodec\\_find\\_best\\_pix\\_fmt\\_of\\_2() searches which of the given pixel formats should be used to suffer the least amount of loss. The pixel formats from which it chooses one, are determined by the pix\\_fmt\\_list parameter.

# Arguments
* `pix_fmt_list`:\\[in\\] AV\\_PIX\\_FMT\\_NONE terminated array of pixel formats to choose from
* `src_pix_fmt`:\\[in\\] source pixel format
* `has_alpha`:\\[in\\] Whether the source pixel format alpha channel is used.
* `loss_ptr`:\\[out\\] Combination of flags informing you what kind of losses will occur.
# Returns
The best pixel format to convert to or -1 if none was found.
"""
function avcodec_find_best_pix_fmt_of_list(pix_fmt_list, src_pix_fmt::AVPixelFormat, has_alpha::Integer, loss_ptr)
    ccall((:avcodec_find_best_pix_fmt_of_list, libavcodec), AVPixelFormat, (Ptr{AVPixelFormat}, AVPixelFormat, Cint, Ptr{Cint}), pix_fmt_list, src_pix_fmt, has_alpha, loss_ptr)
end

function avcodec_default_get_format(s, fmt)
    ccall((:avcodec_default_get_format, libavcodec), AVPixelFormat, (Ptr{AVCodecContext}, Ptr{AVPixelFormat}), s, fmt)
end

"""
    avcodec_string(buf, buf_size::Integer, enc, encode::Integer)

@}
"""
function avcodec_string(buf, buf_size::Integer, enc, encode::Integer)
    ccall((:avcodec_string, libavcodec), Cvoid, (Cstring, Cint, Ptr{AVCodecContext}, Cint), buf, buf_size, enc, encode)
end

function avcodec_default_execute(c, func, arg, ret, count::Integer, size::Integer)
    ccall((:avcodec_default_execute, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cint}, Cint, Cint), c, func, arg, ret, count, size)
end

function avcodec_default_execute2(c, func, arg, ret, count::Integer)
    ccall((:avcodec_default_execute2, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cint}, Cint), c, func, arg, ret, count)
end

"""
    avcodec_fill_audio_frame(frame, nb_channels::Integer, sample_fmt::AVSampleFormat, buf, buf_size::Integer, align::Integer)

Fill [`AVFrame`](@ref) audio data and linesize pointers.

The buffer buf must be a preallocated buffer with a size big enough to contain the specified samples amount. The filled [`AVFrame`](@ref) data pointers will point to this buffer.

[`AVFrame`](@ref) extended\\_data channel pointers are allocated if necessary for planar audio.

\\todo return the size in bytes required to store the samples in case of success, at the next libavutil bump

# Arguments
* `frame`: the [`AVFrame`](@ref) frame->nb\\_samples must be set prior to calling the function. This function fills in frame->data, frame->extended\\_data, frame->linesize[0].
* `nb_channels`: channel count
* `sample_fmt`: sample format
* `buf`: buffer to use for frame data
* `buf_size`: size of buffer
* `align`: plane size sample alignment (0 = default)
# Returns
>=0 on success, negative error code on failure
"""
function avcodec_fill_audio_frame(frame, nb_channels::Integer, sample_fmt::AVSampleFormat, buf, buf_size::Integer, align::Integer)
    ccall((:avcodec_fill_audio_frame, libavcodec), Cint, (Ptr{AVFrame}, Cint, AVSampleFormat, Ptr{UInt8}, Cint, Cint), frame, nb_channels, sample_fmt, buf, buf_size, align)
end

"""
    avcodec_flush_buffers(avctx)

Reset the internal codec state / flush internal buffers. Should be called e.g. when seeking or when switching to a different stream.

!!! note

    for decoders, this function just releases any references the decoder might keep internally, but the caller's references remain valid.

!!! note

    for encoders, this function will only do something if the encoder declares support for [`AV_CODEC_CAP_ENCODER_FLUSH`](@ref). When called, the encoder will drain any remaining packets, and can then be reused for a different stream (as opposed to sending a null frame which will leave the encoder in a permanent EOF state after draining). This can be desirable if the cost of tearing down and replacing the encoder instance is high.
"""
function avcodec_flush_buffers(avctx)
    ccall((:avcodec_flush_buffers, libavcodec), Cvoid, (Ptr{AVCodecContext},), avctx)
end

"""
    av_get_audio_frame_duration(avctx, frame_bytes::Integer)

Return audio frame duration.

# Arguments
* `avctx`: codec context
* `frame_bytes`: size of the frame, or 0 if unknown
# Returns
frame duration, in samples, if known. 0 if not able to determine.
"""
function av_get_audio_frame_duration(avctx, frame_bytes::Integer)
    ccall((:av_get_audio_frame_duration, libavcodec), Cint, (Ptr{AVCodecContext}, Cint), avctx, frame_bytes)
end

"""
    av_fast_padded_malloc(ptr, size, min_size::Csize_t)

Same behaviour [`av_fast_malloc`](@ref) but the buffer has additional [`AV_INPUT_BUFFER_PADDING_SIZE`](@ref) at the end which will always be 0.

In addition the whole buffer will initially and after resizes be 0-initialized so that no uninitialized data will ever appear.
"""
function av_fast_padded_malloc(ptr, size, min_size::Csize_t)
    ccall((:av_fast_padded_malloc, libavcodec), Cvoid, (Ptr{Cvoid}, Ptr{Cuint}, Csize_t), ptr, size, min_size)
end

"""
    av_fast_padded_mallocz(ptr, size, min_size::Csize_t)

Same behaviour [`av_fast_padded_malloc`](@ref) except that buffer will always be 0-initialized after call.
"""
function av_fast_padded_mallocz(ptr, size, min_size::Csize_t)
    ccall((:av_fast_padded_mallocz, libavcodec), Cvoid, (Ptr{Cvoid}, Ptr{Cuint}, Csize_t), ptr, size, min_size)
end

"""
    avcodec_is_open(s)

# Returns
a positive value if s is open (i.e. [`avcodec_open2`](@ref)() was called on it), 0 otherwise.
"""
function avcodec_is_open(s)
    ccall((:avcodec_is_open, libavcodec), Cint, (Ptr{AVCodecContext},), s)
end

"""
    AVDCT

[`AVDCT`](@ref) context.

!!! note

    function pointers can be NULL if the specific features have been disabled at build time.
"""
struct AVDCT
    av_class::Ptr{AVClass}
    idct::Ptr{Cvoid}
    idct_permutation::NTuple{64, UInt8}
    fdct::Ptr{Cvoid}
    dct_algo::Cint
    idct_algo::Cint
    get_pixels::Ptr{Cvoid}
    bits_per_sample::Cint
    get_pixels_unaligned::Ptr{Cvoid}
end

"""
    avcodec_dct_alloc()

Allocates a [`AVDCT`](@ref) context. This needs to be initialized with [`avcodec_dct_init`](@ref)() after optionally configuring it with AVOptions.

To free it use [`av_free`](@ref)()
"""
function avcodec_dct_alloc()
    ccall((:avcodec_dct_alloc, libavcodec), Ptr{AVDCT}, ())
end

function avcodec_dct_init(arg1)
    ccall((:avcodec_dct_init, libavcodec), Cint, (Ptr{AVDCT},), arg1)
end

function avcodec_dct_get_class()
    ccall((:avcodec_dct_get_class, libavcodec), Ptr{AVClass}, ())
end

struct AVBitStreamFilter
    name::Cstring
    codec_ids::Ptr{AVCodecID}
    priv_class::Ptr{AVClass}
end

"""
    AVBSFContext

The bitstream filter state.

This struct must be allocated with [`av_bsf_alloc`](@ref)() and freed with [`av_bsf_free`](@ref)().

The fields in the struct will only be changed (by the caller or by the filter) as described in their documentation, and are to be considered immutable otherwise.
"""
struct AVBSFContext
    av_class::Ptr{AVClass}
    filter::Ptr{AVBitStreamFilter}
    priv_data::Ptr{Cvoid}
    par_in::Ptr{AVCodecParameters}
    par_out::Ptr{AVCodecParameters}
    time_base_in::AVRational
    time_base_out::AVRational
end

"""
    av_bsf_get_by_name(name)

# Returns
a bitstream filter with the specified name or NULL if no such bitstream filter exists.
"""
function av_bsf_get_by_name(name)
    ccall((:av_bsf_get_by_name, libavcodec), Ptr{AVBitStreamFilter}, (Cstring,), name)
end

"""
    av_bsf_iterate(opaque)

Iterate over all registered bitstream filters.

# Arguments
* `opaque`: a pointer where libavcodec will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered bitstream filter or NULL when the iteration is finished
"""
function av_bsf_iterate(opaque)
    ccall((:av_bsf_iterate, libavcodec), Ptr{AVBitStreamFilter}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    av_bsf_alloc(filter, ctx)

Allocate a context for a given bitstream filter. The caller must fill in the context parameters as described in the documentation and then call [`av_bsf_init`](@ref)() before sending any data to the filter.

# Arguments
* `filter`: the filter for which to allocate an instance.
* `ctx`:\\[out\\] a pointer into which the pointer to the newly-allocated context will be written. It must be freed with [`av_bsf_free`](@ref)() after the filtering is done.
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function av_bsf_alloc(filter, ctx)
    ccall((:av_bsf_alloc, libavcodec), Cint, (Ptr{AVBitStreamFilter}, Ptr{Ptr{AVBSFContext}}), filter, ctx)
end

"""
    av_bsf_init(ctx)

Prepare the filter for use, after all the parameters and options have been set.

# Arguments
* `ctx`: a [`AVBSFContext`](@ref) previously allocated with [`av_bsf_alloc`](@ref)()
"""
function av_bsf_init(ctx)
    ccall((:av_bsf_init, libavcodec), Cint, (Ptr{AVBSFContext},), ctx)
end

"""
    av_bsf_send_packet(ctx, pkt)

Submit a packet for filtering.

After sending each packet, the filter must be completely drained by calling [`av_bsf_receive_packet`](@ref)() repeatedly until it returns [`AVERROR`](@ref)(EAGAIN) or [`AVERROR_EOF`](@ref).

# Arguments
* `ctx`: an initialized [`AVBSFContext`](@ref)
* `pkt`: the packet to filter. The bitstream filter will take ownership of the packet and reset the contents of pkt. pkt is not touched if an error occurs. If pkt is empty (i.e. NULL, or pkt->data is NULL and pkt->side\\_data\\_elems zero), it signals the end of the stream (i.e. no more non-empty packets will be sent; sending more empty packets does nothing) and will cause the filter to output any packets it may have buffered internally.
# Returns
- 0 on success. - [`AVERROR`](@ref)(EAGAIN) if packets need to be retrieved from the filter (using [`av_bsf_receive_packet`](@ref)()) before new input can be consumed. - Another negative [`AVERROR`](@ref) value if an error occurs.
"""
function av_bsf_send_packet(ctx, pkt)
    ccall((:av_bsf_send_packet, libavcodec), Cint, (Ptr{AVBSFContext}, Ptr{AVPacket}), ctx, pkt)
end

"""
    av_bsf_receive_packet(ctx, pkt)

Retrieve a filtered packet.

!!! note

    one input packet may result in several output packets, so after sending a packet with [`av_bsf_send_packet`](@ref)(), this function needs to be called repeatedly until it stops returning 0. It is also possible for a filter to output fewer packets than were sent to it, so this function may return [`AVERROR`](@ref)(EAGAIN) immediately after a successful [`av_bsf_send_packet`](@ref)() call.

# Arguments
* `ctx`: an initialized [`AVBSFContext`](@ref)
* `pkt`:\\[out\\] this struct will be filled with the contents of the filtered packet. It is owned by the caller and must be freed using [`av_packet_unref`](@ref)() when it is no longer needed. This parameter should be "clean" (i.e. freshly allocated with [`av_packet_alloc`](@ref)() or unreffed with [`av_packet_unref`](@ref)()) when this function is called. If this function returns successfully, the contents of pkt will be completely overwritten by the returned data. On failure, pkt is not touched.
# Returns
- 0 on success. - [`AVERROR`](@ref)(EAGAIN) if more packets need to be sent to the filter (using [`av_bsf_send_packet`](@ref)()) to get more output. - [`AVERROR_EOF`](@ref) if there will be no further output from the filter. - Another negative [`AVERROR`](@ref) value if an error occurs.
"""
function av_bsf_receive_packet(ctx, pkt)
    ccall((:av_bsf_receive_packet, libavcodec), Cint, (Ptr{AVBSFContext}, Ptr{AVPacket}), ctx, pkt)
end

"""
    av_bsf_flush(ctx)

Reset the internal bitstream filter state. Should be called e.g. when seeking.
"""
function av_bsf_flush(ctx)
    ccall((:av_bsf_flush, libavcodec), Cvoid, (Ptr{AVBSFContext},), ctx)
end

"""
    av_bsf_free(ctx)

Free a bitstream filter context and everything associated with it; write NULL into the supplied pointer.
"""
function av_bsf_free(ctx)
    ccall((:av_bsf_free, libavcodec), Cvoid, (Ptr{Ptr{AVBSFContext}},), ctx)
end

"""
    av_bsf_get_class()

Get the [`AVClass`](@ref) for [`AVBSFContext`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function av_bsf_get_class()
    ccall((:av_bsf_get_class, libavcodec), Ptr{AVClass}, ())
end

mutable struct AVBSFList end

"""
    av_bsf_list_alloc()

Allocate empty list of bitstream filters. The list must be later freed by [`av_bsf_list_free`](@ref)() or finalized by [`av_bsf_list_finalize`](@ref)().

# Returns
Pointer to AVBSFList on success, NULL in case of failure
"""
function av_bsf_list_alloc()
    ccall((:av_bsf_list_alloc, libavcodec), Ptr{AVBSFList}, ())
end

"""
    av_bsf_list_free(lst)

Free list of bitstream filters.

# Arguments
* `lst`: Pointer to pointer returned by [`av_bsf_list_alloc`](@ref)()
"""
function av_bsf_list_free(lst)
    ccall((:av_bsf_list_free, libavcodec), Cvoid, (Ptr{Ptr{AVBSFList}},), lst)
end

"""
    av_bsf_list_append(lst, bsf)

Append bitstream filter to the list of bitstream filters.

# Arguments
* `lst`: List to append to
* `bsf`: Filter context to be appended
# Returns
>=0 on success, negative [`AVERROR`](@ref) in case of failure
"""
function av_bsf_list_append(lst, bsf)
    ccall((:av_bsf_list_append, libavcodec), Cint, (Ptr{AVBSFList}, Ptr{AVBSFContext}), lst, bsf)
end

"""
    av_bsf_list_append2(lst, bsf_name, options)

Construct new bitstream filter context given it's name and options and append it to the list of bitstream filters.

# Arguments
* `lst`: List to append to
* `bsf_name`: Name of the bitstream filter
* `options`: Options for the bitstream filter, can be set to NULL
# Returns
>=0 on success, negative [`AVERROR`](@ref) in case of failure
"""
function av_bsf_list_append2(lst, bsf_name, options)
    ccall((:av_bsf_list_append2, libavcodec), Cint, (Ptr{AVBSFList}, Cstring, Ptr{Ptr{AVDictionary}}), lst, bsf_name, options)
end

"""
    av_bsf_list_finalize(lst, bsf)

Finalize list of bitstream filters.

This function will transform AVBSFList to single AVBSFContext, so the whole chain of bitstream filters can be treated as single filter freshly allocated by [`av_bsf_alloc`](@ref)(). If the call is successful, AVBSFList structure is freed and lst will be set to NULL. In case of failure, caller is responsible for freeing the structure by [`av_bsf_list_free`](@ref)()

# Arguments
* `lst`: Filter list structure to be transformed
* `bsf`:\\[out\\] Pointer to be set to newly created AVBSFContext structure representing the chain of bitstream filters
# Returns
>=0 on success, negative [`AVERROR`](@ref) in case of failure
"""
function av_bsf_list_finalize(lst, bsf)
    ccall((:av_bsf_list_finalize, libavcodec), Cint, (Ptr{Ptr{AVBSFList}}, Ptr{Ptr{AVBSFContext}}), lst, bsf)
end

"""
    av_bsf_list_parse_str(str, bsf)

Parse string describing list of bitstream filters and create single AVBSFContext describing the whole chain of bitstream filters. Resulting AVBSFContext can be treated as any other AVBSFContext freshly allocated by [`av_bsf_alloc`](@ref)().

# Arguments
* `str`: String describing chain of bitstream filters in format `bsf1[=opt1=val1:opt2=val2][,bsf2]`
* `bsf`:\\[out\\] Pointer to be set to newly created AVBSFContext structure representing the chain of bitstream filters
# Returns
>=0 on success, negative [`AVERROR`](@ref) in case of failure
"""
function av_bsf_list_parse_str(str, bsf)
    ccall((:av_bsf_list_parse_str, libavcodec), Cint, (Cstring, Ptr{Ptr{AVBSFContext}}), str, bsf)
end

"""
    av_bsf_get_null_filter(bsf)

Get null/pass-through bitstream filter.

# Arguments
* `bsf`:\\[out\\] Pointer to be set to new instance of pass-through bitstream filter
# Returns
"""
function av_bsf_get_null_filter(bsf)
    ccall((:av_bsf_get_null_filter, libavcodec), Cint, (Ptr{Ptr{AVBSFContext}},), bsf)
end

"""
    av_codec_iterate(opaque)

Iterate over all registered codecs.

# Arguments
* `opaque`: a pointer where libavcodec will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered codec or NULL when the iteration is finished
"""
function av_codec_iterate(opaque)
    ccall((:av_codec_iterate, libavcodec), Ptr{AVCodec}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    avcodec_find_decoder(id::AVCodecID)

Find a registered decoder with a matching codec ID.

# Arguments
* `id`: [`AVCodecID`](@ref) of the requested decoder
# Returns
A decoder if one was found, NULL otherwise.
"""
function avcodec_find_decoder(id::AVCodecID)
    ccall((:avcodec_find_decoder, libavcodec), Ptr{AVCodec}, (AVCodecID,), id)
end

"""
    avcodec_find_decoder_by_name(name)

Find a registered decoder with the specified name.

# Arguments
* `name`: name of the requested decoder
# Returns
A decoder if one was found, NULL otherwise.
"""
function avcodec_find_decoder_by_name(name)
    ccall((:avcodec_find_decoder_by_name, libavcodec), Ptr{AVCodec}, (Cstring,), name)
end

"""
    avcodec_find_encoder(id::AVCodecID)

Find a registered encoder with a matching codec ID.

# Arguments
* `id`: [`AVCodecID`](@ref) of the requested encoder
# Returns
An encoder if one was found, NULL otherwise.
"""
function avcodec_find_encoder(id::AVCodecID)
    ccall((:avcodec_find_encoder, libavcodec), Ptr{AVCodec}, (AVCodecID,), id)
end

"""
    avcodec_find_encoder_by_name(name)

Find a registered encoder with the specified name.

# Arguments
* `name`: name of the requested encoder
# Returns
An encoder if one was found, NULL otherwise.
"""
function avcodec_find_encoder_by_name(name)
    ccall((:avcodec_find_encoder_by_name, libavcodec), Ptr{AVCodec}, (Cstring,), name)
end

"""
    av_codec_is_encoder(codec)

# Returns
a non-zero number if codec is an encoder, zero otherwise
"""
function av_codec_is_encoder(codec)
    ccall((:av_codec_is_encoder, libavcodec), Cint, (Ptr{AVCodec},), codec)
end

"""
    av_codec_is_decoder(codec)

# Returns
a non-zero number if codec is a decoder, zero otherwise
"""
function av_codec_is_decoder(codec)
    ccall((:av_codec_is_decoder, libavcodec), Cint, (Ptr{AVCodec},), codec)
end

"""
    av_get_profile_name(codec, profile::Integer)

Return a name for the specified profile, if available.

# Arguments
* `codec`: the codec that is searched for the given profile
* `profile`: the profile value for which a name is requested
# Returns
A name for the profile if found, NULL otherwise.
"""
function av_get_profile_name(codec, profile::Integer)
    ccall((:av_get_profile_name, libavcodec), Cstring, (Ptr{AVCodec}, Cint), codec, profile)
end

const __JL_Ctag_11 = UInt32
const AV_CODEC_HW_CONFIG_METHOD_HW_DEVICE_CTX = 1 % UInt32
const AV_CODEC_HW_CONFIG_METHOD_HW_FRAMES_CTX = 2 % UInt32
const AV_CODEC_HW_CONFIG_METHOD_INTERNAL = 4 % UInt32
const AV_CODEC_HW_CONFIG_METHOD_AD_HOC = 8 % UInt32

const AVHWDeviceType = UInt32
const AV_HWDEVICE_TYPE_NONE = 0 % UInt32
const AV_HWDEVICE_TYPE_VDPAU = 1 % UInt32
const AV_HWDEVICE_TYPE_CUDA = 2 % UInt32
const AV_HWDEVICE_TYPE_VAAPI = 3 % UInt32
const AV_HWDEVICE_TYPE_DXVA2 = 4 % UInt32
const AV_HWDEVICE_TYPE_QSV = 5 % UInt32
const AV_HWDEVICE_TYPE_VIDEOTOOLBOX = 6 % UInt32
const AV_HWDEVICE_TYPE_D3D11VA = 7 % UInt32
const AV_HWDEVICE_TYPE_DRM = 8 % UInt32
const AV_HWDEVICE_TYPE_OPENCL = 9 % UInt32
const AV_HWDEVICE_TYPE_MEDIACODEC = 10 % UInt32
const AV_HWDEVICE_TYPE_VULKAN = 11 % UInt32
const AV_HWDEVICE_TYPE_D3D12VA = 12 % UInt32
const AV_HWDEVICE_TYPE_AMF = 13 % UInt32
const AV_HWDEVICE_TYPE_OHCODEC = 14 % UInt32

struct AVCodecHWConfig
    pix_fmt::AVPixelFormat
    methods::Cint
    device_type::AVHWDeviceType
end

"""
    avcodec_get_hw_config(codec, index::Integer)

Retrieve supported hardware configurations for a codec.

Values of index from zero to some maximum return the indexed configuration descriptor; all other values return NULL. If the codec does not support any hardware configurations then it will always return NULL.
"""
function avcodec_get_hw_config(codec, index::Integer)
    ccall((:avcodec_get_hw_config, libavcodec), Ptr{AVCodecHWConfig}, (Ptr{AVCodec}, Cint), codec, index)
end

"""
    avcodec_descriptor_get(id::AVCodecID)

# Returns
descriptor for given codec ID or NULL if no descriptor exists.
"""
function avcodec_descriptor_get(id::AVCodecID)
    ccall((:avcodec_descriptor_get, libavcodec), Ptr{AVCodecDescriptor}, (AVCodecID,), id)
end

"""
    avcodec_descriptor_next(prev)

Iterate over all codec descriptors known to libavcodec.

# Arguments
* `prev`: previous descriptor. NULL to get the first descriptor.
# Returns
next descriptor or NULL after the last descriptor
"""
function avcodec_descriptor_next(prev)
    ccall((:avcodec_descriptor_next, libavcodec), Ptr{AVCodecDescriptor}, (Ptr{AVCodecDescriptor},), prev)
end

"""
    avcodec_descriptor_get_by_name(name)

# Returns
codec descriptor with the given name or NULL if no such descriptor exists.
"""
function avcodec_descriptor_get_by_name(name)
    ccall((:avcodec_descriptor_get_by_name, libavcodec), Ptr{AVCodecDescriptor}, (Cstring,), name)
end

"""
    avcodec_get_type(codec_id::AVCodecID)

Get the type of the given codec.
"""
function avcodec_get_type(codec_id::AVCodecID)
    ccall((:avcodec_get_type, libavcodec), AVMediaType, (AVCodecID,), codec_id)
end

"""
    avcodec_get_name(id::AVCodecID)

Get the name of a codec.

# Returns
a static string identifying the codec; never NULL
"""
function avcodec_get_name(id::AVCodecID)
    ccall((:avcodec_get_name, libavcodec), Cstring, (AVCodecID,), id)
end

"""
    av_get_bits_per_sample(codec_id::AVCodecID)

Return codec bits per sample.

# Arguments
* `codec_id`:\\[in\\] the codec
# Returns
Number of bits per sample or zero if unknown for the given codec.
"""
function av_get_bits_per_sample(codec_id::AVCodecID)
    ccall((:av_get_bits_per_sample, libavcodec), Cint, (AVCodecID,), codec_id)
end

"""
    av_get_exact_bits_per_sample(codec_id::AVCodecID)

Return codec bits per sample. Only return non-zero if the bits per sample is exactly correct, not an approximation.

# Arguments
* `codec_id`:\\[in\\] the codec
# Returns
Number of bits per sample or zero if unknown for the given codec.
"""
function av_get_exact_bits_per_sample(codec_id::AVCodecID)
    ccall((:av_get_exact_bits_per_sample, libavcodec), Cint, (AVCodecID,), codec_id)
end

"""
    avcodec_profile_name(codec_id::AVCodecID, profile::Integer)

Return a name for the specified profile, if available.

!!! note

    unlike [`av_get_profile_name`](@ref)(), which searches a list of profiles supported by a specific decoder or encoder implementation, this function searches the list of profiles from the [`AVCodecDescriptor`](@ref)

# Arguments
* `codec_id`: the ID of the codec to which the requested profile belongs
* `profile`: the profile value for which a name is requested
# Returns
A name for the profile if found, NULL otherwise.
"""
function avcodec_profile_name(codec_id::AVCodecID, profile::Integer)
    ccall((:avcodec_profile_name, libavcodec), Cstring, (AVCodecID, Cint), codec_id, profile)
end

"""
    av_get_pcm_codec(fmt::AVSampleFormat, be::Integer)

Return the PCM codec associated with a sample format.

# Arguments
* `be`: endianness, 0 for little, 1 for big, -1 (or anything else) for native
# Returns
AV\\_CODEC\\_ID\\_PCM\\_* or AV\\_CODEC\\_ID\\_NONE
"""
function av_get_pcm_codec(fmt::AVSampleFormat, be::Integer)
    ccall((:av_get_pcm_codec, libavcodec), AVCodecID, (AVSampleFormat, Cint), fmt, be)
end

"""
    avcodec_parameters_alloc()

Allocate a new [`AVCodecParameters`](@ref) and set its fields to default values (unknown/invalid/0). The returned struct must be freed with [`avcodec_parameters_free`](@ref)().
"""
function avcodec_parameters_alloc()
    ccall((:avcodec_parameters_alloc, libavcodec), Ptr{AVCodecParameters}, ())
end

"""
    avcodec_parameters_free(par)

Free an [`AVCodecParameters`](@ref) instance and everything associated with it and write NULL to the supplied pointer.
"""
function avcodec_parameters_free(par)
    ccall((:avcodec_parameters_free, libavcodec), Cvoid, (Ptr{Ptr{AVCodecParameters}},), par)
end

"""
    avcodec_parameters_copy(dst, src)

Copy the contents of src to dst. Any allocated fields in dst are freed and replaced with newly allocated duplicates of the corresponding fields in src.

# Returns
>= 0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function avcodec_parameters_copy(dst, src)
    ccall((:avcodec_parameters_copy, libavcodec), Cint, (Ptr{AVCodecParameters}, Ptr{AVCodecParameters}), dst, src)
end

"""
    av_get_audio_frame_duration2(par, frame_bytes::Integer)

This function is the same as [`av_get_audio_frame_duration`](@ref)(), except it works with [`AVCodecParameters`](@ref) instead of an [`AVCodecContext`](@ref).
"""
function av_get_audio_frame_duration2(par, frame_bytes::Integer)
    ccall((:av_get_audio_frame_duration2, libavcodec), Cint, (Ptr{AVCodecParameters}, Cint), par, frame_bytes)
end

struct AVD3D11VAContext
    decoder::Ptr{Cint}
    video_context::Ptr{Cint}
    cfg::Ptr{Cint}
    surface_count::Cuint
    surface::Ptr{Ptr{Cint}}
    workaround::UInt64
    report_id::Cuint
    context_mutex::Cint
end

"""
    av_d3d11va_alloc_context()

Allocate an [`AVD3D11VAContext`](@ref).

# Returns
Newly-allocated [`AVD3D11VAContext`](@ref) or NULL on failure.
"""
function av_d3d11va_alloc_context()
    ccall((:av_d3d11va_alloc_context, libavcodec), Ptr{AVD3D11VAContext}, ())
end

"""
    AVPanScan

Pan Scan area. This specifies the area which should be displayed. Note there may be multiple such areas for one frame.
"""
struct AVPanScan
    id::Cint
    width::Cint
    height::Cint
    position::NTuple{3, NTuple{2, Int16}}
end

"""
    AVCPBProperties

This structure describes the bitrate properties of an encoded bitstream. It roughly corresponds to a subset the VBV parameters for MPEG-2 or HRD parameters for H.264/HEVC.
"""
struct AVCPBProperties
    max_bitrate::Int64
    min_bitrate::Int64
    avg_bitrate::Int64
    buffer_size::Int64
    vbv_delay::UInt64
end

"""
    av_cpb_properties_alloc(size)

Allocate a CPB properties structure and initialize its fields to default values.

# Arguments
* `size`: if non-NULL, the size of the allocated struct will be written here. This is useful for embedding it in side data.
# Returns
the newly allocated struct or NULL on failure
"""
function av_cpb_properties_alloc(size)
    ccall((:av_cpb_properties_alloc, libavcodec), Ptr{AVCPBProperties}, (Ptr{Csize_t},), size)
end

"""
    AVProducerReferenceTime

This structure supplies correlation between a packet timestamp and a wall clock production time. The definition follows the Producer Reference Time ('prft') as defined in ISO/IEC 14496-12
"""
struct AVProducerReferenceTime
    wallclock::Int64
    flags::Cint
end

"""
    AVRTCPSenderReport

RTCP SR (Sender Report) information

The received sender report information for an RTSP stream, exposed as AV\\_PKT\\_DATA\\_RTCP\\_SR side data.
"""
struct AVRTCPSenderReport
    ssrc::UInt32
    ntp_timestamp::UInt64
    rtp_timestamp::UInt32
    sender_nb_packets::UInt32
    sender_nb_bytes::UInt32
end

"""
    av_xiphlacing(s, v::Integer)

Encode extradata length to a buffer. Used by xiph codecs.

# Arguments
* `s`: buffer to write to; must be at least (v/255+1) bytes long
* `v`: size of extradata in bytes
# Returns
number of bytes written to the buffer.
"""
function av_xiphlacing(s, v::Integer)
    ccall((:av_xiphlacing, libavcodec), Cuint, (Ptr{Cuchar}, Cuint), s, v)
end

"""
    DiracParseCodes

Parse code values:

Dirac Specification -> 9.6.1 Table 9.1

VC-2 Specification -> 10.4.1 Table 10.1
"""
const DiracParseCodes = UInt32
const DIRAC_PCODE_SEQ_HEADER = 0 % UInt32
const DIRAC_PCODE_END_SEQ = 16 % UInt32
const DIRAC_PCODE_AUX = 32 % UInt32
const DIRAC_PCODE_PAD = 48 % UInt32
const DIRAC_PCODE_PICTURE_CODED = 8 % UInt32
const DIRAC_PCODE_PICTURE_RAW = 72 % UInt32
const DIRAC_PCODE_PICTURE_LOW_DEL = 200 % UInt32
const DIRAC_PCODE_PICTURE_HQ = 232 % UInt32
const DIRAC_PCODE_INTER_NOREF_CO1 = 10 % UInt32
const DIRAC_PCODE_INTER_NOREF_CO2 = 9 % UInt32
const DIRAC_PCODE_INTER_REF_CO1 = 13 % UInt32
const DIRAC_PCODE_INTER_REF_CO2 = 14 % UInt32
const DIRAC_PCODE_INTRA_REF_CO = 12 % UInt32
const DIRAC_PCODE_INTRA_REF_RAW = 76 % UInt32
const DIRAC_PCODE_INTRA_REF_PICT = 204 % UInt32
const DIRAC_PCODE_MAGIC = 1111638852 % UInt32

struct DiracVersionInfo
    major::Cint
    minor::Cint
end

struct AVDiracSeqHeader
    width::Cuint
    height::Cuint
    chroma_format::UInt8
    interlaced::UInt8
    top_field_first::UInt8
    frame_rate_index::UInt8
    aspect_ratio_index::UInt8
    clean_width::UInt16
    clean_height::UInt16
    clean_left_offset::UInt16
    clean_right_offset::UInt16
    pixel_range_index::UInt8
    color_spec_index::UInt8
    profile::Cint
    level::Cint
    framerate::AVRational
    sample_aspect_ratio::AVRational
    pix_fmt::AVPixelFormat
    color_range::AVColorRange
    color_primaries::AVColorPrimaries
    color_trc::AVColorTransferCharacteristic
    colorspace::AVColorSpace
    version::DiracVersionInfo
    bit_depth::Cint
end

"""
    av_dirac_parse_sequence_header(dsh, buf, buf_size::Csize_t, log_ctx)

Parse a Dirac sequence header.

# Arguments
* `dsh`: this function will allocate and fill an [`AVDiracSeqHeader`](@ref) struct and write it into this pointer. The caller must free it with [`av_free`](@ref)().
* `buf`: the data buffer
* `buf_size`: the size of the data buffer in bytes
* `log_ctx`: if non-NULL, this function will log errors here
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function av_dirac_parse_sequence_header(dsh, buf, buf_size::Csize_t, log_ctx)
    ccall((:av_dirac_parse_sequence_header, libavcodec), Cint, (Ptr{Ptr{AVDiracSeqHeader}}, Ptr{UInt8}, Csize_t, Ptr{Cvoid}), dsh, buf, buf_size, log_ctx)
end

struct AVDVProfile
    dsf::Cint
    video_stype::Cint
    frame_size::Cint
    difseg_size::Cint
    n_difchan::Cint
    time_base::AVRational
    ltc_divisor::Cint
    height::Cint
    width::Cint
    sar::NTuple{2, AVRational}
    pix_fmt::AVPixelFormat
    bpm::Cint
    block_sizes::Ptr{UInt8}
    audio_stride::Cint
    audio_min_samples::NTuple{3, Cint}
    audio_samples_dist::NTuple{5, Cint}
    audio_shuffle::Ptr{NTuple{9, UInt8}}
end

"""
    av_dv_frame_profile(sys, frame, buf_size::Integer)

Get a DV profile for the provided compressed frame.

# Arguments
* `sys`: the profile used for the previous frame, may be NULL
* `frame`: the compressed data buffer
* `buf_size`: size of the buffer in bytes
# Returns
the DV profile for the supplied data or NULL on failure
"""
function av_dv_frame_profile(sys, frame, buf_size::Integer)
    ccall((:av_dv_frame_profile, libavcodec), Ptr{AVDVProfile}, (Ptr{AVDVProfile}, Ptr{UInt8}, Cuint), sys, frame, buf_size)
end

"""
    av_dv_codec_profile(width::Integer, height::Integer, pix_fmt::AVPixelFormat)

Get a DV profile for the provided stream parameters.
"""
function av_dv_codec_profile(width::Integer, height::Integer, pix_fmt::AVPixelFormat)
    ccall((:av_dv_codec_profile, libavcodec), Ptr{AVDVProfile}, (Cint, Cint, AVPixelFormat), width, height, pix_fmt)
end

"""
    av_dv_codec_profile2(width::Integer, height::Integer, pix_fmt::AVPixelFormat, frame_rate::AVRational)

Get a DV profile for the provided stream parameters. The frame rate is used as a best-effort parameter.
"""
function av_dv_codec_profile2(width::Integer, height::Integer, pix_fmt::AVPixelFormat, frame_rate::AVRational)
    ccall((:av_dv_codec_profile2, libavcodec), Ptr{AVDVProfile}, (Cint, Cint, AVPixelFormat, AVRational), width, height, pix_fmt, frame_rate)
end

struct dxva_context
    decoder::Ptr{Cint}
    cfg::Ptr{Cint}
    surface_count::Cuint
    surface::Ptr{Cint}
    workaround::UInt64
    report_id::Cuint
end

function av_jni_set_java_vm(vm, log_ctx)
    ccall((:av_jni_set_java_vm, libavcodec), Cint, (Ptr{Cvoid}, Ptr{Cvoid}), vm, log_ctx)
end

function av_jni_get_java_vm(log_ctx)
    ccall((:av_jni_get_java_vm, libavcodec), Ptr{Cvoid}, (Ptr{Cvoid},), log_ctx)
end

function av_jni_set_android_app_ctx(app_ctx, log_ctx)
    ccall((:av_jni_set_android_app_ctx, libavcodec), Cint, (Ptr{Cvoid}, Ptr{Cvoid}), app_ctx, log_ctx)
end

function av_jni_get_android_app_ctx()
    ccall((:av_jni_get_android_app_ctx, libavcodec), Ptr{Cvoid}, ())
end

"""
    AVMediaCodecContext

This structure holds a reference to a android/view/Surface object that will be used as output by the decoder.
"""
struct AVMediaCodecContext
    surface::Ptr{Cvoid}
end

"""
    av_mediacodec_alloc_context()

Allocate and initialize a MediaCodec context.

When decoding with MediaCodec is finished, the caller must free the MediaCodec context with [`av_mediacodec_default_free`](@ref).

# Returns
a pointer to a newly allocated [`AVMediaCodecContext`](@ref) on success, NULL otherwise
"""
function av_mediacodec_alloc_context()
    ccall((:av_mediacodec_alloc_context, libavcodec), Ptr{AVMediaCodecContext}, ())
end

"""
    av_mediacodec_default_init(avctx, ctx, surface)

Convenience function that sets up the MediaCodec context.

# Arguments
* `avctx`: codec context
* `ctx`: MediaCodec context to initialize
* `surface`: reference to an android/view/Surface
# Returns
0 on success, < 0 otherwise
"""
function av_mediacodec_default_init(avctx, ctx, surface)
    ccall((:av_mediacodec_default_init, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{AVMediaCodecContext}, Ptr{Cvoid}), avctx, ctx, surface)
end

"""
    av_mediacodec_default_free(avctx)

This function must be called to free the MediaCodec context initialized with [`av_mediacodec_default_init`](@ref)().

# Arguments
* `avctx`: codec context
"""
function av_mediacodec_default_free(avctx)
    ccall((:av_mediacodec_default_free, libavcodec), Cvoid, (Ptr{AVCodecContext},), avctx)
end

mutable struct MediaCodecBuffer end

"""
Opaque structure representing a MediaCodec buffer to render.
"""
const AVMediaCodecBuffer = MediaCodecBuffer

"""
    av_mediacodec_release_buffer(buffer, render::Integer)

Release a MediaCodec buffer and render it to the surface that is associated with the decoder. This function should only be called once on a given buffer, once released the underlying buffer returns to the codec, thus subsequent calls to this function will have no effect.

# Arguments
* `buffer`: the buffer to render
* `render`: 1 to release and render the buffer to the surface or 0 to discard the buffer
# Returns
0 on success, < 0 otherwise
"""
function av_mediacodec_release_buffer(buffer, render::Integer)
    ccall((:av_mediacodec_release_buffer, libavcodec), Cint, (Ptr{AVMediaCodecBuffer}, Cint), buffer, render)
end

"""
    av_mediacodec_render_buffer_at_time(buffer, time::Int64)

Release a MediaCodec buffer and render it at the given time to the surface that is associated with the decoder. The timestamp must be within one second of the current `java/lang/System#nanoTime()` (which is implemented using `CLOCK_MONOTONIC` on Android). See the Android MediaCodec documentation of [`android/media/MediaCodec#releaseOutputBuffer(int,long)`][0] for more details.

[0]: https://developer.android.com/reference/android/media/MediaCodec#releaseOutputBuffer(int,20long)

# Arguments
* `buffer`: the buffer to render
* `time`: timestamp in nanoseconds of when to render the buffer
# Returns
0 on success, < 0 otherwise
"""
function av_mediacodec_render_buffer_at_time(buffer, time::Int64)
    ccall((:av_mediacodec_render_buffer_at_time, libavcodec), Cint, (Ptr{AVMediaCodecBuffer}, Int64), buffer, time)
end

"""
    av_packet_side_data_new(psd, pnb_sd, type::AVPacketSideDataType, size::Csize_t, flags::Integer)

Allocate a new packet side data.

# Arguments
* `sd`: pointer to an array of side data to which the side data should be added. *sd may be NULL, in which case the array will be initialized.
* `nb_sd`: pointer to an integer containing the number of entries in the array. The integer value will be increased by 1 on success.
* `type`: side data type
* `size`: desired side data size
* `flags`: currently unused. Must be zero
# Returns
pointer to freshly allocated side data on success, or NULL otherwise.
"""
function av_packet_side_data_new(psd, pnb_sd, type::AVPacketSideDataType, size::Csize_t, flags::Integer)
    ccall((:av_packet_side_data_new, libavcodec), Ptr{AVPacketSideData}, (Ptr{Ptr{AVPacketSideData}}, Ptr{Cint}, AVPacketSideDataType, Csize_t, Cint), psd, pnb_sd, type, size, flags)
end

"""
    av_packet_side_data_add(sd, nb_sd, type::AVPacketSideDataType, data, size::Csize_t, flags::Integer)

Wrap existing data as packet side data.

# Arguments
* `sd`: pointer to an array of side data to which the side data should be added. *sd may be NULL, in which case the array will be initialized
* `nb_sd`: pointer to an integer containing the number of entries in the array. The integer value will be increased by 1 on success.
* `type`: side data type
* `data`: a data array. It must be allocated with the [`av_malloc`](@ref)() family of functions. The ownership of the data is transferred to the side data array on success
* `size`: size of the data array
* `flags`: currently unused. Must be zero
# Returns
pointer to freshly allocated side data on success, or NULL otherwise On failure, the side data array is unchanged and the data remains owned by the caller.
"""
function av_packet_side_data_add(sd, nb_sd, type::AVPacketSideDataType, data, size::Csize_t, flags::Integer)
    ccall((:av_packet_side_data_add, libavcodec), Ptr{AVPacketSideData}, (Ptr{Ptr{AVPacketSideData}}, Ptr{Cint}, AVPacketSideDataType, Ptr{Cvoid}, Csize_t, Cint), sd, nb_sd, type, data, size, flags)
end

"""
    av_packet_side_data_get(sd, nb_sd::Integer, type::AVPacketSideDataType)

Get side information from a side data array.

# Arguments
* `sd`: the array from which the side data should be fetched
* `nb_sd`: value containing the number of entries in the array.
* `type`: desired side information type
# Returns
pointer to side data if present or NULL otherwise
"""
function av_packet_side_data_get(sd, nb_sd::Integer, type::AVPacketSideDataType)
    ccall((:av_packet_side_data_get, libavcodec), Ptr{AVPacketSideData}, (Ptr{AVPacketSideData}, Cint, AVPacketSideDataType), sd, nb_sd, type)
end

"""
    av_packet_side_data_remove(sd, nb_sd, type::AVPacketSideDataType)

Remove side data of the given type from a side data array.

# Arguments
* `sd`: the array from which the side data should be removed
* `nb_sd`: pointer to an integer containing the number of entries in the array. Will be reduced by the amount of entries removed upon return
* `type`: side information type
"""
function av_packet_side_data_remove(sd, nb_sd, type::AVPacketSideDataType)
    ccall((:av_packet_side_data_remove, libavcodec), Cvoid, (Ptr{AVPacketSideData}, Ptr{Cint}, AVPacketSideDataType), sd, nb_sd, type)
end

"""
    av_packet_side_data_free(sd, nb_sd)

Convenience function to free all the side data stored in an array, and the array itself.

# Arguments
* `sd`: pointer to array of side data to free. Will be set to NULL upon return.
* `nb_sd`: pointer to an integer containing the number of entries in the array. Will be set to 0 upon return.
"""
function av_packet_side_data_free(sd, nb_sd)
    ccall((:av_packet_side_data_free, libavcodec), Cvoid, (Ptr{Ptr{AVPacketSideData}}, Ptr{Cint}), sd, nb_sd)
end

function av_packet_side_data_name(type::AVPacketSideDataType)
    ccall((:av_packet_side_data_name, libavcodec), Cstring, (AVPacketSideDataType,), type)
end

struct AVPacketList
    pkt::AVPacket
    next::Ptr{AVPacketList}
end

const AVSideDataParamChangeFlags = UInt32
const AV_SIDE_DATA_PARAM_CHANGE_SAMPLE_RATE = 4 % UInt32
const AV_SIDE_DATA_PARAM_CHANGE_DIMENSIONS = 8 % UInt32

"""
    av_packet_alloc()

Allocate an [`AVPacket`](@ref) and set its fields to default values. The resulting struct must be freed using [`av_packet_free`](@ref)().

!!! note

    this only allocates the [`AVPacket`](@ref) itself, not the data buffers. Those must be allocated through other means such as [`av_new_packet`](@ref).

# Returns
An [`AVPacket`](@ref) filled with default values or NULL on failure.
# See also
[`av_new_packet`](@ref)
"""
function av_packet_alloc()
    ccall((:av_packet_alloc, libavcodec), Ptr{AVPacket}, ())
end

"""
    av_packet_clone(src)

Create a new packet that references the same data as src.

This is a shortcut for [`av_packet_alloc`](@ref)()+[`av_packet_ref`](@ref)().

# Returns
newly created [`AVPacket`](@ref) on success, NULL on error.
# See also
[`av_packet_alloc`](@ref), [`av_packet_ref`](@ref)
"""
function av_packet_clone(src)
    ccall((:av_packet_clone, libavcodec), Ptr{AVPacket}, (Ptr{AVPacket},), src)
end

"""
    av_packet_free(pkt)

Free the packet, if the packet is reference counted, it will be unreferenced first.

!!! note

    passing NULL is a no-op.

# Arguments
* `pkt`: packet to be freed. The pointer will be set to NULL.
"""
function av_packet_free(pkt)
    ccall((:av_packet_free, libavcodec), Cvoid, (Ptr{Ptr{AVPacket}},), pkt)
end

"""
    av_init_packet(pkt)

Initialize optional fields of a packet with default values.

Note, this does not touch the data and size members, which have to be initialized separately.

!!! compat "Deprecated"

    This function is deprecated. Once it's removed, sizeof([`AVPacket`](@ref)) will not be a part of the ABI anymore.

# Arguments
* `pkt`: packet
# See also
[`av_packet_alloc`](@ref), [`av_packet_unref`](@ref)
"""
function av_init_packet(pkt)
    ccall((:av_init_packet, libavcodec), Cvoid, (Ptr{AVPacket},), pkt)
end

"""
    av_new_packet(pkt, size::Integer)

Allocate the payload of a packet and initialize its fields with default values.

# Arguments
* `pkt`: packet
* `size`: wanted payload size
# Returns
0 if OK, AVERROR\\_xxx otherwise
"""
function av_new_packet(pkt, size::Integer)
    ccall((:av_new_packet, libavcodec), Cint, (Ptr{AVPacket}, Cint), pkt, size)
end

"""
    av_shrink_packet(pkt, size::Integer)

Reduce packet size, correctly zeroing padding

# Arguments
* `pkt`: packet
* `size`: new size
"""
function av_shrink_packet(pkt, size::Integer)
    ccall((:av_shrink_packet, libavcodec), Cvoid, (Ptr{AVPacket}, Cint), pkt, size)
end

"""
    av_grow_packet(pkt, grow_by::Integer)

Increase packet size, correctly zeroing padding

# Arguments
* `pkt`: packet
* `grow_by`: number of bytes by which to increase the size of the packet
"""
function av_grow_packet(pkt, grow_by::Integer)
    ccall((:av_grow_packet, libavcodec), Cint, (Ptr{AVPacket}, Cint), pkt, grow_by)
end

"""
    av_packet_from_data(pkt, data, size::Integer)

Initialize a reference-counted packet from [`av_malloc`](@ref)()ed data.

# Arguments
* `pkt`: packet to be initialized. This function will set the data, size, and buf fields, all others are left untouched.
* `data`: Data allocated by [`av_malloc`](@ref)() to be used as packet data. If this function returns successfully, the data is owned by the underlying [`AVBuffer`](@ref). The caller may not access the data through other means.
* `size`: size of data in bytes, without the padding. I.e. the full buffer size is assumed to be size + [`AV_INPUT_BUFFER_PADDING_SIZE`](@ref).
# Returns
0 on success, a negative [`AVERROR`](@ref) on error
"""
function av_packet_from_data(pkt, data, size::Integer)
    ccall((:av_packet_from_data, libavcodec), Cint, (Ptr{AVPacket}, Ptr{UInt8}, Cint), pkt, data, size)
end

"""
    av_packet_new_side_data(pkt, type::AVPacketSideDataType, size::Csize_t)

Allocate new information of a packet.

# Arguments
* `pkt`: packet
* `type`: side information type
* `size`: side information size
# Returns
pointer to fresh allocated data or NULL otherwise
"""
function av_packet_new_side_data(pkt, type::AVPacketSideDataType, size::Csize_t)
    ccall((:av_packet_new_side_data, libavcodec), Ptr{UInt8}, (Ptr{AVPacket}, AVPacketSideDataType, Csize_t), pkt, type, size)
end

"""
    av_packet_add_side_data(pkt, type::AVPacketSideDataType, data, size::Csize_t)

Wrap an existing array as a packet side data.

# Arguments
* `pkt`: packet
* `type`: side information type
* `data`: the side data array. It must be allocated with the [`av_malloc`](@ref)() family of functions. The ownership of the data is transferred to pkt.
* `size`: side information size
# Returns
a non-negative number on success, a negative [`AVERROR`](@ref) code on failure. On failure, the packet is unchanged and the data remains owned by the caller.
"""
function av_packet_add_side_data(pkt, type::AVPacketSideDataType, data, size::Csize_t)
    ccall((:av_packet_add_side_data, libavcodec), Cint, (Ptr{AVPacket}, AVPacketSideDataType, Ptr{UInt8}, Csize_t), pkt, type, data, size)
end

"""
    av_packet_shrink_side_data(pkt, type::AVPacketSideDataType, size::Csize_t)

Shrink the already allocated side data buffer

# Arguments
* `pkt`: packet
* `type`: side information type
* `size`: new side information size
# Returns
0 on success, < 0 on failure
"""
function av_packet_shrink_side_data(pkt, type::AVPacketSideDataType, size::Csize_t)
    ccall((:av_packet_shrink_side_data, libavcodec), Cint, (Ptr{AVPacket}, AVPacketSideDataType, Csize_t), pkt, type, size)
end

"""
    av_packet_get_side_data(pkt, type::AVPacketSideDataType, size)

Get side information from packet.

# Arguments
* `pkt`: packet
* `type`: desired side information type
* `size`: If supplied, *size will be set to the size of the side data or to zero if the desired side data is not present.
# Returns
pointer to data if present or NULL otherwise
"""
function av_packet_get_side_data(pkt, type::AVPacketSideDataType, size)
    ccall((:av_packet_get_side_data, libavcodec), Ptr{UInt8}, (Ptr{AVPacket}, AVPacketSideDataType, Ptr{Csize_t}), pkt, type, size)
end

"""
    av_packet_pack_dictionary(dict, size)

Pack a dictionary for use in side\\_data.

# Arguments
* `dict`: The dictionary to pack.
* `size`: pointer to store the size of the returned data
# Returns
pointer to data if successful, NULL otherwise
"""
function av_packet_pack_dictionary(dict, size)
    ccall((:av_packet_pack_dictionary, libavcodec), Ptr{UInt8}, (Ptr{AVDictionary}, Ptr{Csize_t}), dict, size)
end

"""
    av_packet_unpack_dictionary(data, size::Csize_t, dict)

Unpack a dictionary from side\\_data.

# Arguments
* `data`: data from side\\_data
* `size`: size of the data
* `dict`: the metadata storage dictionary
# Returns
0 on success, < 0 on failure
"""
function av_packet_unpack_dictionary(data, size::Csize_t, dict)
    ccall((:av_packet_unpack_dictionary, libavcodec), Cint, (Ptr{UInt8}, Csize_t, Ptr{Ptr{AVDictionary}}), data, size, dict)
end

"""
    av_packet_free_side_data(pkt)

Convenience function to free all the side data stored. All the other fields stay untouched.

# Arguments
* `pkt`: packet
"""
function av_packet_free_side_data(pkt)
    ccall((:av_packet_free_side_data, libavcodec), Cvoid, (Ptr{AVPacket},), pkt)
end

"""
    av_packet_ref(dst, src)

Setup a new reference to the data described by a given packet

If src is reference-counted, setup dst as a new reference to the buffer in src. Otherwise allocate a new buffer in dst and copy the data from src into it.

All the other fields are copied from src.

# Arguments
* `dst`: Destination packet. Will be completely overwritten.
* `src`: Source packet
# Returns
0 on success, a negative [`AVERROR`](@ref) on error. On error, dst will be blank (as if returned by [`av_packet_alloc`](@ref)()).
# See also
[`av_packet_unref`](@ref)
"""
function av_packet_ref(dst, src)
    ccall((:av_packet_ref, libavcodec), Cint, (Ptr{AVPacket}, Ptr{AVPacket}), dst, src)
end

"""
    av_packet_unref(pkt)

Wipe the packet.

Unreference the buffer referenced by the packet and reset the remaining packet fields to their default values.

# Arguments
* `pkt`: The packet to be unreferenced.
"""
function av_packet_unref(pkt)
    ccall((:av_packet_unref, libavcodec), Cvoid, (Ptr{AVPacket},), pkt)
end

"""
    av_packet_move_ref(dst, src)

Move every field in src to dst and reset src.

# Arguments
* `src`: Source packet, will be reset
* `dst`: Destination packet
# See also
[`av_packet_unref`](@ref)
"""
function av_packet_move_ref(dst, src)
    ccall((:av_packet_move_ref, libavcodec), Cvoid, (Ptr{AVPacket}, Ptr{AVPacket}), dst, src)
end

"""
    av_packet_copy_props(dst, src)

Copy only "properties" fields from src to dst.

Properties for the purpose of this function are all the fields beside those related to the packet data (buf, data, size)

# Arguments
* `dst`: Destination packet
* `src`: Source packet
# Returns
0 on success [`AVERROR`](@ref) on failure.
"""
function av_packet_copy_props(dst, src)
    ccall((:av_packet_copy_props, libavcodec), Cint, (Ptr{AVPacket}, Ptr{AVPacket}), dst, src)
end

"""
    av_packet_make_refcounted(pkt)

Ensure the data described by a given packet is reference counted.

!!! note

    This function does not ensure that the reference will be writable. Use [`av_packet_make_writable`](@ref) instead for that purpose.

# Arguments
* `pkt`: packet whose data should be made reference counted.
# Returns
0 on success, a negative [`AVERROR`](@ref) on error. On failure, the packet is unchanged.
# See also
[`av_packet_ref`](@ref), [`av_packet_make_writable`](@ref)
"""
function av_packet_make_refcounted(pkt)
    ccall((:av_packet_make_refcounted, libavcodec), Cint, (Ptr{AVPacket},), pkt)
end

"""
    av_packet_make_writable(pkt)

Create a writable reference for the data described by a given packet, avoiding data copy if possible.

# Arguments
* `pkt`: Packet whose data should be made writable.
# Returns
0 on success, a negative [`AVERROR`](@ref) on failure. On failure, the packet is unchanged.
"""
function av_packet_make_writable(pkt)
    ccall((:av_packet_make_writable, libavcodec), Cint, (Ptr{AVPacket},), pkt)
end

"""
    av_packet_rescale_ts(pkt, tb_src::AVRational, tb_dst::AVRational)

Convert valid timing fields (timestamps / durations) in a packet from one timebase to another. Timestamps with unknown values ([`AV_NOPTS_VALUE`](@ref)) will be ignored.

# Arguments
* `pkt`: packet on which the conversion will be performed
* `tb_src`: source timebase, in which the timing fields in pkt are expressed
* `tb_dst`: destination timebase, to which the timing fields will be converted
"""
function av_packet_rescale_ts(pkt, tb_src::AVRational, tb_dst::AVRational)
    ccall((:av_packet_rescale_ts, libavcodec), Cvoid, (Ptr{AVPacket}, AVRational, AVRational), pkt, tb_src, tb_dst)
end

"""
    av_container_fifo_alloc_avpacket(flags::Integer)

Allocate an [`AVContainerFifo`](@ref) instance for [`AVPacket`](@ref).

# Arguments
* `flags`: currently unused
"""
function av_container_fifo_alloc_avpacket(flags::Integer)
    ccall((:av_container_fifo_alloc_avpacket, libavcodec), Ptr{AVContainerFifo}, (Cuint,), flags)
end

struct AVQSVContext
    session::Cint
    iopattern::Cint
    ext_buffers::Ptr{Ptr{Cint}}
    nb_ext_buffers::Cint
    opaque_alloc::Cint
    nb_opaque_surfaces::Cint
    opaque_surfaces::Ptr{AVBufferRef}
    opaque_alloc_type::Cint
end

"""
    av_qsv_alloc_context()

Allocate a new context.

It must be freed by the caller with [`av_free`](@ref)().
"""
function av_qsv_alloc_context()
    ccall((:av_qsv_alloc_context, libavcodec), Ptr{AVQSVContext}, ())
end

"""
    AVSmpte436mAncIterator

Iterator over the ANC packets in a single AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref)'s data
"""
struct AVSmpte436mAncIterator
    anc_packets_left::UInt16
    size_left::Cint
    data_left::Ptr{UInt8}
end

"""
    AVSmpte436mWrappingType

Wrapping Type from Table 7 (page 13) of: https://pub.smpte.org/latest/st436/s436m-2006.pdf
"""
const AVSmpte436mWrappingType = UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_VANC_FRAME = 1 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_VANC_FIELD_1 = 2 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_VANC_FIELD_2 = 3 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_VANC_PROGRESSIVE_FRAME = 4 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_HANC_FRAME = 17 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_HANC_FIELD_1 = 18 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_HANC_FIELD_2 = 19 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_HANC_PROGRESSIVE_FRAME = 20 % UInt32
const AV_SMPTE_436M_WRAPPING_TYPE_MAX = 255 % UInt32

"""
    AVSmpte436mPayloadSampleCoding

Payload Sample Coding from Table 4 (page 10) and Table 7 (page 13) of: https://pub.smpte.org/latest/st436/s436m-2006.pdf
"""
const AVSmpte436mPayloadSampleCoding = UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_1BIT_LUMA = 1 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_1BIT_COLOR_DIFF = 2 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_1BIT_LUMA_AND_COLOR_DIFF = 3 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_LUMA = 4 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_COLOR_DIFF = 5 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_LUMA_AND_COLOR_DIFF = 6 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_10BIT_LUMA = 7 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_10BIT_COLOR_DIFF = 8 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_10BIT_LUMA_AND_COLOR_DIFF = 9 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_LUMA_WITH_PARITY_ERROR = 10 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_COLOR_DIFF_WITH_PARITY_ERROR = 11 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_8BIT_LUMA_AND_COLOR_DIFF_WITH_PARITY_ERROR = 12 % UInt32
const AV_SMPTE_436M_PAYLOAD_SAMPLE_CODING_MAX = 255 % UInt32

"""
    AVSmpte291mAnc8bit

An ANC packet with an 8-bit payload. This can be decoded from [`AVSmpte436mCodedAnc`](@ref)::payload.

Note: Some ANC packets need a 10-bit payload, if stored in this struct, the most-significant 2 bits of each sample are discarded.
"""
struct AVSmpte291mAnc8bit
    did::UInt8
    sdid_or_dbn::UInt8
    data_count::UInt8
    payload::NTuple{255, UInt8}
    checksum::UInt8
end

"""
    AVSmpte436mCodedAnc

An encoded ANC packet within a single AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref)'s data. The repeated section of Table 7 (page 13) of: https://pub.smpte.org/latest/st436/s436m-2006.pdf
"""
struct AVSmpte436mCodedAnc
    line_number::UInt16
    wrapping_type::AVSmpte436mWrappingType
    payload_sample_coding::AVSmpte436mPayloadSampleCoding
    payload_sample_count::UInt16
    payload_array_length::UInt32
    payload::NTuple{348, UInt8}
end

"""
    av_smpte_436m_coded_anc_validate(anc)

Validate a [`AVSmpte436mCodedAnc`](@ref) structure. Doesn't check if the payload is valid.

# Arguments
* `anc`:\\[in\\] ANC packet to validate
# Returns
0 on success, [`AVERROR`](@ref) codes otherwise.
"""
function av_smpte_436m_coded_anc_validate(anc)
    ccall((:av_smpte_436m_coded_anc_validate, libavcodec), Cint, (Ptr{AVSmpte436mCodedAnc},), anc)
end

"""
    av_smpte_436m_anc_encode(out, size::Integer, anc_packet_count::Integer, anc_packets)

Encode ANC packets into a single AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref)'s data.

# Arguments
* `anc_packet_count`:\\[in\\] number of ANC packets to encode
* `anc_packets`:\\[in\\] the ANC packets to encode
* `size`:\\[in\\] the size of out. ignored if out is NULL.
* `out`:\\[out\\] Output bytes. Doesn't write anything if out is NULL.
# Returns
the number of bytes written on success, [`AVERROR`](@ref) codes otherwise. If out is NULL, returns the number of bytes it would have written.
"""
function av_smpte_436m_anc_encode(out, size::Integer, anc_packet_count::Integer, anc_packets)
    ccall((:av_smpte_436m_anc_encode, libavcodec), Cint, (Ptr{UInt8}, Cint, Cint, Ptr{AVSmpte436mCodedAnc}), out, size, anc_packet_count, anc_packets)
end

"""
    av_smpte_436m_anc_append(pkt, anc_packet_count::Integer, anc_packets)

Append more ANC packets to a single AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref)'s data.

# Arguments
* `anc_packet_count`:\\[in\\] number of ANC packets to encode
* `anc_packets`:\\[in\\] the ANC packets to encode
* `pkt`: the [`AVPacket`](@ref) to append to. it must either be size 0 or contain valid SMPTE\\_436M\\_ANC data.
# Returns
0 on success, [`AVERROR`](@ref) codes otherwise.
"""
function av_smpte_436m_anc_append(pkt, anc_packet_count::Integer, anc_packets)
    ccall((:av_smpte_436m_anc_append, libavcodec), Cint, (Ptr{AVPacket}, Cint, Ptr{AVSmpte436mCodedAnc}), pkt, anc_packet_count, anc_packets)
end

"""
    av_smpte_436m_anc_iter_init(iter, buf, buf_size::Integer)

Set up iteration over the ANC packets in a single AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref)'s data.

# Arguments
* `buf`:\\[in\\] Pointer to the data from a AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref).
* `buf_size`:\\[in\\] Size of the data from a AV\\_CODEC\\_ID\\_SMPTE\\_436M\\_ANC [`AVPacket`](@ref).
* `iter`:\\[out\\] Pointer to the iterator.
# Returns
0 on success, [`AVERROR`](@ref) codes otherwise.
"""
function av_smpte_436m_anc_iter_init(iter, buf, buf_size::Integer)
    ccall((:av_smpte_436m_anc_iter_init, libavcodec), Cint, (Ptr{AVSmpte436mAncIterator}, Ptr{UInt8}, Cint), iter, buf, buf_size)
end

"""
    av_smpte_436m_anc_iter_next(iter, anc)

Get the next ANC packet from the iterator, advancing the iterator.

# Arguments
* `iter`:\\[in,out\\] Pointer to the iterator.
* `anc`:\\[out\\] The returned ANC packet.
# Returns
0 on success, [`AVERROR_EOF`](@ref) when the iterator has reached the end, [`AVERROR`](@ref) codes otherwise.
"""
function av_smpte_436m_anc_iter_next(iter, anc)
    ccall((:av_smpte_436m_anc_iter_next, libavcodec), Cint, (Ptr{AVSmpte436mAncIterator}, Ptr{AVSmpte436mCodedAnc}), iter, anc)
end

"""
    av_smpte_436m_coded_anc_payload_size(sample_coding::AVSmpte436mPayloadSampleCoding, sample_count::UInt16)

Get the minimum number of bytes needed to store a [`AVSmpte436mCodedAnc`](@ref) payload.

# Arguments
* `sample_coding`: the payload sample coding
* `sample_count`: the number of samples stored in the payload
# Returns
returns the minimum number of bytes needed, on error returns < 0. always <= SMPTE\\_436M\\_CODED\\_ANC\\_PAYLOAD\\_CAPACITY
"""
function av_smpte_436m_coded_anc_payload_size(sample_coding::AVSmpte436mPayloadSampleCoding, sample_count::UInt16)
    ccall((:av_smpte_436m_coded_anc_payload_size, libavcodec), Cint, (AVSmpte436mPayloadSampleCoding, UInt16), sample_coding, sample_count)
end

"""
    av_smpte_291m_anc_8bit_decode(out, sample_coding::AVSmpte436mPayloadSampleCoding, sample_count::UInt16, payload, log_ctx)

Decode a [`AVSmpte436mCodedAnc`](@ref) payload into [`AVSmpte291mAnc8bit`](@ref)

# Arguments
* `sample_coding`:\\[in\\] the payload sample coding
* `sample_count`:\\[in\\] the number of samples stored in the payload
* `payload`:\\[in\\] the bytes storing the payload, the needed size can be obtained from avpriv\\_smpte\\_436m\\_coded\\_anc\\_payload\\_size
* `log_ctx`:\\[in\\] context pointer for [`av_log`](@ref)
* `out`:\\[out\\] The decoded ANC packet.
# Returns
returns 0 on success, otherwise < 0.
"""
function av_smpte_291m_anc_8bit_decode(out, sample_coding::AVSmpte436mPayloadSampleCoding, sample_count::UInt16, payload, log_ctx)
    ccall((:av_smpte_291m_anc_8bit_decode, libavcodec), Cint, (Ptr{AVSmpte291mAnc8bit}, AVSmpte436mPayloadSampleCoding, UInt16, Ptr{UInt8}, Ptr{Cvoid}), out, sample_coding, sample_count, payload, log_ctx)
end

"""
    av_smpte_291m_anc_8bit_fill_checksum(anc)

Fill in the correct checksum for a [`AVSmpte291mAnc8bit`](@ref)

# Arguments
* `anc`:\\[in,out\\] The ANC packet.
"""
function av_smpte_291m_anc_8bit_fill_checksum(anc)
    ccall((:av_smpte_291m_anc_8bit_fill_checksum, libavcodec), Cvoid, (Ptr{AVSmpte291mAnc8bit},), anc)
end

"""
    av_smpte_291m_anc_8bit_get_sample_count(anc, sample_coding::AVSmpte436mPayloadSampleCoding, log_ctx)

Compute the sample count needed to encode a [`AVSmpte291mAnc8bit`](@ref) into a [`AVSmpte436mCodedAnc`](@ref) payload

# Arguments
* `anc`:\\[in\\] The ANC packet.
* `sample_coding`:\\[in\\] The sample coding.
* `log_ctx`:\\[in\\] context pointer for [`av_log`](@ref)
# Returns
returns the sample count on success, otherwise < 0.
"""
function av_smpte_291m_anc_8bit_get_sample_count(anc, sample_coding::AVSmpte436mPayloadSampleCoding, log_ctx)
    ccall((:av_smpte_291m_anc_8bit_get_sample_count, libavcodec), Cint, (Ptr{AVSmpte291mAnc8bit}, AVSmpte436mPayloadSampleCoding, Ptr{Cvoid}), anc, sample_coding, log_ctx)
end

"""
    av_smpte_291m_anc_8bit_encode(out, line_number::UInt16, wrapping_type::AVSmpte436mWrappingType, sample_coding::AVSmpte436mPayloadSampleCoding, payload, log_ctx)

Encode a [`AVSmpte291mAnc8bit`](@ref) into a [`AVSmpte436mCodedAnc`](@ref)

# Arguments
* `line_number`:\\[in\\] the line number the ANC packet is on
* `wrapping_type`:\\[in\\] the wrapping type
* `sample_coding`:\\[in\\] the payload sample coding
* `payload`:\\[in\\] the ANC packet to encode.
* `log_ctx`:\\[in\\] context pointer for [`av_log`](@ref)
* `out`:\\[out\\] The encoded ANC packet.
# Returns
returns 0 on success, otherwise < 0.
"""
function av_smpte_291m_anc_8bit_encode(out, line_number::UInt16, wrapping_type::AVSmpte436mWrappingType, sample_coding::AVSmpte436mPayloadSampleCoding, payload, log_ctx)
    ccall((:av_smpte_291m_anc_8bit_encode, libavcodec), Cint, (Ptr{AVSmpte436mCodedAnc}, UInt16, AVSmpte436mWrappingType, AVSmpte436mPayloadSampleCoding, Ptr{AVSmpte291mAnc8bit}, Ptr{Cvoid}), out, line_number, wrapping_type, sample_coding, payload, log_ctx)
end

"""
    av_smpte_291m_anc_8bit_extract_cta_708(anc, cc_data, log_ctx)

Try to decode an ANC packet into EIA-608/CTA-708 data (AV\\_CODEC\\_ID\\_EIA\\_608). This

# Arguments
* `anc`:\\[in\\] The ANC packet.
* `log_ctx`:\\[in\\] Context pointer for [`av_log`](@ref)
* `cc_data`:\\[out\\] the buffer to store the extracted EIA-608/CTA-708 data, you can pass NULL to not store the data. the required size is 3 * cc\\_count bytes. SMPTE\\_291M\\_ANC\\_PAYLOAD\\_CAPACITY is always enough size.
# Returns
returns cc\\_count (>= 0) on success, [`AVERROR`](@ref)(EAGAIN) if it wasn't a CTA-708 ANC packet, < 0 on error.
"""
function av_smpte_291m_anc_8bit_extract_cta_708(anc, cc_data, log_ctx)
    ccall((:av_smpte_291m_anc_8bit_extract_cta_708, libavcodec), Cint, (Ptr{AVSmpte291mAnc8bit}, Ptr{UInt8}, Ptr{Cvoid}), anc, cc_data, log_ctx)
end

# typedef int ( * AVVDPAU_Render2 ) ( struct AVCodecContext * , struct AVFrame * , const VdpPictureInfo * , uint32_t , const VdpBitstreamBuffer * )
const AVVDPAU_Render2 = Ptr{Cvoid}

"""
    AVVDPAUContext

This structure is used to share data between the libavcodec library and the client video application. This structure will be allocated and stored in [`AVCodecContext`](@ref).hwaccel\\_context by [`av_vdpau_bind_context`](@ref)(). Members can be set by the user once during initialization or through each [`AVCodecContext`](@ref).get\\_buffer() function call. In any case, they must be valid prior to calling decoding functions.

The size of this structure is not a part of the public ABI and must not be used outside of libavcodec.
"""
struct AVVDPAUContext
    decoder::VdpDecoder
    render::Ptr{VdpDecoderRender}
    render2::AVVDPAU_Render2
end

"""
    av_vdpau_bind_context(avctx, device::VdpDevice, get_proc_address, flags::Integer)

Associate a VDPAU device with a codec context for hardware acceleration. This function is meant to be called from the get\\_format() codec callback, or earlier. It can also be called after [`avcodec_flush_buffers`](@ref)() to change the underlying VDPAU device mid-stream (e.g. to recover from non-transparent display preemption).

!!! note

    get\\_format() must return AV\\_PIX\\_FMT\\_VDPAU if this function completes successfully.

# Arguments
* `avctx`: decoding context whose get\\_format() callback is invoked
* `device`: VDPAU device handle to use for hardware acceleration
* `get_proc_address`: VDPAU device driver
* `flags`: zero of more OR'd AV\\_HWACCEL\\_FLAG\\_* flags
# Returns
0 on success, an [`AVERROR`](@ref) code on failure.
"""
function av_vdpau_bind_context(avctx, device::VdpDevice, get_proc_address, flags::Integer)
    ccall((:av_vdpau_bind_context, libavcodec), Cint, (Ptr{AVCodecContext}, VdpDevice, Ptr{VdpGetProcAddress}, Cuint), avctx, device, get_proc_address, flags)
end

"""
    av_vdpau_get_surface_parameters(avctx, type, width, height)

Gets the parameters to create an adequate VDPAU video surface for the codec context using VDPAU hardware decoding acceleration.

!!! note

    Behavior is undefined if the context was not successfully bound to a VDPAU device using [`av_vdpau_bind_context`](@ref)().

# Arguments
* `avctx`: the codec context being used for decoding the stream
* `type`: storage space for the VDPAU video surface chroma type (or NULL to ignore)
* `width`: storage space for the VDPAU video surface pixel width (or NULL to ignore)
* `height`: storage space for the VDPAU video surface pixel height (or NULL to ignore)
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_vdpau_get_surface_parameters(avctx, type, width, height)
    ccall((:av_vdpau_get_surface_parameters, libavcodec), Cint, (Ptr{AVCodecContext}, Ptr{VdpChromaType}, Ptr{UInt32}, Ptr{UInt32}), avctx, type, width, height)
end

struct AVVideotoolboxContext
    session::Cint
    cv_pix_fmt_type::Cint
    cm_fmt_desc::Cint
    cm_codec_type::Cint
end

mutable struct AVVorbisParseContext end

"""
    av_vorbis_parse_init(extradata, extradata_size::Integer)

Allocate and initialize the Vorbis parser using headers in the extradata.
"""
function av_vorbis_parse_init(extradata, extradata_size::Integer)
    ccall((:av_vorbis_parse_init, libavcodec), Ptr{AVVorbisParseContext}, (Ptr{UInt8}, Cint), extradata, extradata_size)
end

"""
    av_vorbis_parse_free(s)

Free the parser and everything associated with it.
"""
function av_vorbis_parse_free(s)
    ccall((:av_vorbis_parse_free, libavcodec), Cvoid, (Ptr{Ptr{AVVorbisParseContext}},), s)
end

"""
    av_vorbis_parse_frame_flags(s, buf, buf_size::Integer, flags)

Get the duration for a Vorbis packet.

If `flags` is `NULL`, special frames are considered invalid.

# Arguments
* `s`: Vorbis parser context
* `buf`: buffer containing a Vorbis frame
* `buf_size`: size of the buffer
* `flags`: flags for special frames
"""
function av_vorbis_parse_frame_flags(s, buf, buf_size::Integer, flags)
    ccall((:av_vorbis_parse_frame_flags, libavcodec), Cint, (Ptr{AVVorbisParseContext}, Ptr{UInt8}, Cint, Ptr{Cint}), s, buf, buf_size, flags)
end

"""
    av_vorbis_parse_frame(s, buf, buf_size::Integer)

Get the duration for a Vorbis packet.

# Arguments
* `s`: Vorbis parser context
* `buf`: buffer containing a Vorbis frame
* `buf_size`: size of the buffer
"""
function av_vorbis_parse_frame(s, buf, buf_size::Integer)
    ccall((:av_vorbis_parse_frame, libavcodec), Cint, (Ptr{AVVorbisParseContext}, Ptr{UInt8}, Cint), s, buf, buf_size)
end

function av_vorbis_parse_reset(s)
    ccall((:av_vorbis_parse_reset, libavcodec), Cvoid, (Ptr{AVVorbisParseContext},), s)
end

"""
    avdevice_version()

Return the [`LIBAVDEVICE_VERSION_INT`](@ref) constant.
"""
function avdevice_version()
    ccall((:avdevice_version, libavdevice), Cuint, ())
end

"""
    avdevice_configuration()

Return the libavdevice build-time configuration.
"""
function avdevice_configuration()
    ccall((:avdevice_configuration, libavdevice), Cstring, ())
end

"""
    avdevice_license()

Return the libavdevice license.
"""
function avdevice_license()
    ccall((:avdevice_license, libavdevice), Cstring, ())
end

"""
    avdevice_register_all()

Initialize libavdevice and register all the input and output devices.
"""
function avdevice_register_all()
    ccall((:avdevice_register_all, libavdevice), Cvoid, ())
end

"""
**********************************************
"""
mutable struct AVCodecTag end

"""
    AVInputFormat

` lavf_decoding`

@{
"""
struct AVInputFormat
    name::Cstring
    long_name::Cstring
    flags::Cint
    extensions::Cstring
    codec_tag::Ptr{Ptr{AVCodecTag}}
    priv_class::Ptr{AVClass}
    mime_type::Cstring
end

"""
    av_input_audio_device_next(d)

Audio input devices iterator.

If d is NULL, returns the first registered input audio/video device, if d is non-NULL, returns the next registered input audio/video device after d or NULL if d is the last one.
"""
function av_input_audio_device_next(d)
    ccall((:av_input_audio_device_next, libavdevice), Ptr{AVInputFormat}, (Ptr{AVInputFormat},), d)
end

"""
    av_input_video_device_next(d)

Video input devices iterator.

If d is NULL, returns the first registered input audio/video device, if d is non-NULL, returns the next registered input audio/video device after d or NULL if d is the last one.
"""
function av_input_video_device_next(d)
    ccall((:av_input_video_device_next, libavdevice), Ptr{AVInputFormat}, (Ptr{AVInputFormat},), d)
end

"""
    AVOutputFormat

` lavf_encoding`

@{
"""
struct AVOutputFormat
    name::Cstring
    long_name::Cstring
    mime_type::Cstring
    extensions::Cstring
    audio_codec::AVCodecID
    video_codec::AVCodecID
    subtitle_codec::AVCodecID
    flags::Cint
    codec_tag::Ptr{Ptr{AVCodecTag}}
    priv_class::Ptr{AVClass}
end

"""
    av_output_audio_device_next(d)

Audio output devices iterator.

If d is NULL, returns the first registered output audio/video device, if d is non-NULL, returns the next registered output audio/video device after d or NULL if d is the last one.
"""
function av_output_audio_device_next(d)
    ccall((:av_output_audio_device_next, libavdevice), Ptr{AVOutputFormat}, (Ptr{AVOutputFormat},), d)
end

"""
    av_output_video_device_next(d)

Video output devices iterator.

If d is NULL, returns the first registered output audio/video device, if d is non-NULL, returns the next registered output audio/video device after d or NULL if d is the last one.
"""
function av_output_video_device_next(d)
    ccall((:av_output_video_device_next, libavdevice), Ptr{AVOutputFormat}, (Ptr{AVOutputFormat},), d)
end

struct AVDeviceRect
    x::Cint
    y::Cint
    width::Cint
    height::Cint
end

"""
    AVAppToDevMessageType

Message types used by [`avdevice_app_to_dev_control_message`](@ref)().
"""
const AVAppToDevMessageType = UInt32
const AV_APP_TO_DEV_NONE = 1313820229 % UInt32
const AV_APP_TO_DEV_WINDOW_SIZE = 1195724621 % UInt32
const AV_APP_TO_DEV_WINDOW_REPAINT = 1380274241 % UInt32
const AV_APP_TO_DEV_PAUSE = 1346458912 % UInt32
const AV_APP_TO_DEV_PLAY = 1347174745 % UInt32
const AV_APP_TO_DEV_TOGGLE_PAUSE = 1346458964 % UInt32
const AV_APP_TO_DEV_SET_VOLUME = 1398165324 % UInt32
const AV_APP_TO_DEV_MUTE = 541939028 % UInt32
const AV_APP_TO_DEV_UNMUTE = 1431131476 % UInt32
const AV_APP_TO_DEV_TOGGLE_MUTE = 1414354260 % UInt32
const AV_APP_TO_DEV_GET_VOLUME = 1196838732 % UInt32
const AV_APP_TO_DEV_GET_MUTE = 1196250452 % UInt32

"""
    AVDevToAppMessageType

Message types used by [`avdevice_dev_to_app_control_message`](@ref)().
"""
const AVDevToAppMessageType = UInt32
const AV_DEV_TO_APP_NONE = 1313820229 % UInt32
const AV_DEV_TO_APP_CREATE_WINDOW_BUFFER = 1111708229 % UInt32
const AV_DEV_TO_APP_PREPARE_WINDOW_BUFFER = 1112560197 % UInt32
const AV_DEV_TO_APP_DISPLAY_WINDOW_BUFFER = 1111771475 % UInt32
const AV_DEV_TO_APP_DESTROY_WINDOW_BUFFER = 1111770451 % UInt32
const AV_DEV_TO_APP_BUFFER_OVERFLOW = 1112491596 % UInt32
const AV_DEV_TO_APP_BUFFER_UNDERFLOW = 1112884812 % UInt32
const AV_DEV_TO_APP_BUFFER_READABLE = 1112687648 % UInt32
const AV_DEV_TO_APP_BUFFER_WRITABLE = 1113018912 % UInt32
const AV_DEV_TO_APP_MUTE_STATE_CHANGED = 1129141588 % UInt32
const AV_DEV_TO_APP_VOLUME_LEVEL_CHANGED = 1129729868 % UInt32

"""
    AVIOContext

Bytestream IO Context. New public fields can be added with minor version bumps. Removal, reordering and changes to existing public fields require a major version bump. sizeof([`AVIOContext`](@ref)) must not be used outside libav*.

!!! note

    None of the function pointers in [`AVIOContext`](@ref) should be called directly, they should only be set by the client application when implementing custom I/O. Normally these are set to the function pointers specified in [`avio_alloc_context`](@ref)()
"""
struct AVIOContext
    av_class::Ptr{AVClass}
    buffer::Ptr{Cuchar}
    buffer_size::Cint
    buf_ptr::Ptr{Cuchar}
    buf_end::Ptr{Cuchar}
    opaque::Ptr{Cvoid}
    read_packet::Ptr{Cvoid}
    write_packet::Ptr{Cvoid}
    seek::Ptr{Cvoid}
    pos::Int64
    eof_reached::Cint
    error::Cint
    write_flag::Cint
    max_packet_size::Cint
    min_packet_size::Cint
    checksum::Culong
    checksum_ptr::Ptr{Cuchar}
    update_checksum::Ptr{Cvoid}
    read_pause::Ptr{Cvoid}
    read_seek::Ptr{Cvoid}
    seekable::Cint
    direct::Cint
    protocol_whitelist::Cstring
    protocol_blacklist::Cstring
    write_data_type::Ptr{Cvoid}
    ignore_boundary_point::Cint
    buf_ptr_max::Ptr{Cuchar}
    bytes_read::Int64
    bytes_written::Int64
end

"""
    AVStream

Stream structure. New fields can be added to the end with minor version bumps. Removal, reordering and changes to existing fields require a major version bump. sizeof([`AVStream`](@ref)) must not be used outside libav*.
"""
struct AVStream
    av_class::Ptr{AVClass}
    index::Cint
    id::Cint
    codecpar::Ptr{AVCodecParameters}
    priv_data::Ptr{Cvoid}
    time_base::AVRational
    start_time::Int64
    duration::Int64
    nb_frames::Int64
    disposition::Cint
    discard::AVDiscard
    sample_aspect_ratio::AVRational
    metadata::Ptr{AVDictionary}
    avg_frame_rate::AVRational
    attached_pic::AVPacket
    event_flags::Cint
    r_frame_rate::AVRational
    pts_wrap_bits::Cint
end

const AVStreamGroupParamsType = UInt32
const AV_STREAM_GROUP_PARAMS_NONE = 0 % UInt32
const AV_STREAM_GROUP_PARAMS_IAMF_AUDIO_ELEMENT = 1 % UInt32
const AV_STREAM_GROUP_PARAMS_IAMF_MIX_PRESENTATION = 2 % UInt32
const AV_STREAM_GROUP_PARAMS_TILE_GRID = 3 % UInt32
const AV_STREAM_GROUP_PARAMS_LCEVC = 4 % UInt32

"""
    __JL_Ctag_91

Group type-specific parameters
"""
struct __JL_Ctag_91
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{__JL_Ctag_91}, f::Symbol)
    f === :iamf_audio_element && return Ptr{Ptr{AVIAMFAudioElement}}(x + 0)
    f === :iamf_mix_presentation && return Ptr{Ptr{AVIAMFMixPresentation}}(x + 0)
    f === :tile_grid && return Ptr{Ptr{AVStreamGroupTileGrid}}(x + 0)
    f === :lcevc && return Ptr{Ptr{AVStreamGroupLCEVC}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_91, f::Symbol)
    r = Ref{__JL_Ctag_91}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_91}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_91}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::__JL_Ctag_91, private::Bool = false)
    (:iamf_audio_element, :iamf_mix_presentation, :tile_grid, :lcevc, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct AVStreamGroup
    data::NTuple{80, UInt8}
end

function Base.getproperty(x::Ptr{AVStreamGroup}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :priv_data && return Ptr{Ptr{Cvoid}}(x + 8)
    f === :index && return Ptr{Cuint}(x + 16)
    f === :id && return Ptr{Int64}(x + 24)
    f === :type && return Ptr{AVStreamGroupParamsType}(x + 32)
    f === :params && return Ptr{__JL_Ctag_91}(x + 40)
    f === :metadata && return Ptr{Ptr{AVDictionary}}(x + 48)
    f === :nb_streams && return Ptr{Cuint}(x + 56)
    f === :streams && return Ptr{Ptr{Ptr{AVStream}}}(x + 64)
    f === :disposition && return Ptr{Cint}(x + 72)
    return getfield(x, f)
end

function Base.getproperty(x::AVStreamGroup, f::Symbol)
    r = Ref{AVStreamGroup}(x)
    ptr = Base.unsafe_convert(Ptr{AVStreamGroup}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVStreamGroup}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVStreamGroup, private::Bool = false)
    (:av_class, :priv_data, :index, :id, :type, :params, :metadata, :nb_streams, :streams, :disposition, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct AVChapter
    id::Int64
    time_base::AVRational
    start::Int64
    _end::Int64
    metadata::Ptr{AVDictionary}
end

"""
    AVProgram

New fields can be added to the end with minor version bumps. Removal, reordering and changes to existing fields require a major version bump. sizeof([`AVProgram`](@ref)) must not be used outside libav*.
"""
struct AVProgram
    id::Cint
    flags::Cint
    discard::AVDiscard
    stream_index::Ptr{Cuint}
    nb_stream_indexes::Cuint
    metadata::Ptr{AVDictionary}
    program_num::Cint
    pmt_pid::Cint
    pcr_pid::Cint
    pmt_version::Cint
    start_time::Int64
    end_time::Int64
    pts_wrap_reference::Int64
    pts_wrap_behavior::Cint
end

"""
    AVIOInterruptCB

Callback for checking whether to abort blocking functions. [`AVERROR_EXIT`](@ref) is returned in this case by the interrupted function. During blocking operations, callback is called with opaque as parameter. If the callback returns 1, the blocking operation will be aborted.

No members can be added to this struct without a major bump, if new elements have been added after this struct in [`AVFormatContext`](@ref) or [`AVIOContext`](@ref).
"""
struct AVIOInterruptCB
    callback::Ptr{Cvoid}
    opaque::Ptr{Cvoid}
end

"""
    AVDurationEstimationMethod

The duration of a video can be estimated through various ways, and this enum can be used to know how the duration was estimated.
"""
const AVDurationEstimationMethod = UInt32
const AVFMT_DURATION_FROM_PTS = 0 % UInt32
const AVFMT_DURATION_FROM_STREAM = 1 % UInt32
const AVFMT_DURATION_FROM_BITRATE = 2 % UInt32

# typedef int ( * av_format_control_message ) ( struct AVFormatContext * s , int type , void * data , size_t data_size )
"""
Callback used by devices to communicate with application.
"""
const av_format_control_message = Ptr{Cvoid}

"""
    AVFormatContext

Format I/O context. New fields can be added to the end with minor version bumps. Removal, reordering and changes to existing fields require a major version bump. sizeof([`AVFormatContext`](@ref)) must not be used outside libav*, use [`avformat_alloc_context`](@ref)() to create an [`AVFormatContext`](@ref).

Fields can be accessed through AVOptions (av\\_opt*), the name string used matches the associated command line parameter name and can be found in libavformat/options\\_table.h. The [`AVOption`](@ref)/command line parameter names differ in some cases from the C structure field names for historic reasons or brevity.
"""
struct AVFormatContext
    av_class::Ptr{AVClass}
    iformat::Ptr{AVInputFormat}
    oformat::Ptr{AVOutputFormat}
    priv_data::Ptr{Cvoid}
    pb::Ptr{AVIOContext}
    ctx_flags::Cint
    nb_streams::Cuint
    streams::Ptr{Ptr{AVStream}}
    nb_stream_groups::Cuint
    stream_groups::Ptr{Ptr{AVStreamGroup}}
    nb_chapters::Cuint
    chapters::Ptr{Ptr{AVChapter}}
    url::Cstring
    start_time::Int64
    duration::Int64
    bit_rate::Int64
    packet_size::Cuint
    max_delay::Cint
    flags::Cint
    probesize::Int64
    max_analyze_duration::Int64
    key::Ptr{UInt8}
    keylen::Cint
    nb_programs::Cuint
    programs::Ptr{Ptr{AVProgram}}
    video_codec_id::AVCodecID
    audio_codec_id::AVCodecID
    subtitle_codec_id::AVCodecID
    data_codec_id::AVCodecID
    metadata::Ptr{AVDictionary}
    start_time_realtime::Int64
    fps_probe_size::Cint
    error_recognition::Cint
    interrupt_callback::AVIOInterruptCB
    debug::Cint
    max_streams::Cint
    max_index_size::Cuint
    max_picture_buffer::Cuint
    max_interleave_delta::Int64
    max_ts_probe::Cint
    max_chunk_duration::Cint
    max_chunk_size::Cint
    max_probe_packets::Cint
    strict_std_compliance::Cint
    event_flags::Cint
    avoid_negative_ts::Cint
    audio_preload::Cint
    use_wallclock_as_timestamps::Cint
    skip_estimate_duration_from_pts::Cint
    avio_flags::Cint
    duration_estimation_method::AVDurationEstimationMethod
    skip_initial_bytes::Int64
    correct_ts_overflow::Cuint
    seek2any::Cint
    flush_packets::Cint
    probe_score::Cint
    format_probesize::Cint
    codec_whitelist::Cstring
    format_whitelist::Cstring
    protocol_whitelist::Cstring
    protocol_blacklist::Cstring
    io_repositioned::Cint
    video_codec::Ptr{AVCodec}
    audio_codec::Ptr{AVCodec}
    subtitle_codec::Ptr{AVCodec}
    data_codec::Ptr{AVCodec}
    metadata_header_padding::Cint
    opaque::Ptr{Cvoid}
    control_message_cb::av_format_control_message
    output_ts_offset::Int64
    dump_separator::Ptr{UInt8}
    io_open::Ptr{Cvoid}
    io_close2::Ptr{Cvoid}
    duration_probesize::Int64
end

"""
    avdevice_app_to_dev_control_message(s, type::AVAppToDevMessageType, data, data_size::Csize_t)

Send control message from application to device.

# Arguments
* `s`: device context.
* `type`: message type.
* `data`: message data. Exact type depends on message type.
* `data_size`: size of message data.
# Returns
>= 0 on success, negative on error. [`AVERROR`](@ref)(ENOSYS) when device doesn't implement handler of the message.
"""
function avdevice_app_to_dev_control_message(s, type::AVAppToDevMessageType, data, data_size::Csize_t)
    ccall((:avdevice_app_to_dev_control_message, libavdevice), Cint, (Ptr{AVFormatContext}, AVAppToDevMessageType, Ptr{Cvoid}, Csize_t), s, type, data, data_size)
end

"""
    avdevice_dev_to_app_control_message(s, type::AVDevToAppMessageType, data, data_size::Csize_t)

Send control message from device to application.

# Arguments
* `s`: device context.
* `type`: message type.
* `data`: message data. Can be NULL.
* `data_size`: size of message data.
# Returns
>= 0 on success, negative on error. [`AVERROR`](@ref)(ENOSYS) when application doesn't implement handler of the message.
"""
function avdevice_dev_to_app_control_message(s, type::AVDevToAppMessageType, data, data_size::Csize_t)
    ccall((:avdevice_dev_to_app_control_message, libavdevice), Cint, (Ptr{AVFormatContext}, AVDevToAppMessageType, Ptr{Cvoid}, Csize_t), s, type, data, data_size)
end

"""
    AVDeviceInfo

Structure describes basic parameters of the device.
"""
struct AVDeviceInfo
    device_name::Cstring
    device_description::Cstring
    media_types::Ptr{AVMediaType}
    nb_media_types::Cint
end

"""
    AVDeviceInfoList

List of devices.
"""
struct AVDeviceInfoList
    devices::Ptr{Ptr{AVDeviceInfo}}
    nb_devices::Cint
    default_device::Cint
end

"""
    avdevice_list_devices(s, device_list)

List devices.

Returns available device names and their parameters.

!!! note

    : Some devices may accept system-dependent device names that cannot be autodetected. The list returned by this function cannot be assumed to be always completed.

# Arguments
* `s`: device context.
* `device_list`:\\[out\\] list of autodetected devices.
# Returns
count of autodetected devices, negative on error.
"""
function avdevice_list_devices(s, device_list)
    ccall((:avdevice_list_devices, libavdevice), Cint, (Ptr{AVFormatContext}, Ptr{Ptr{AVDeviceInfoList}}), s, device_list)
end

"""
    avdevice_free_list_devices(device_list)

Convenient function to free result of [`avdevice_list_devices`](@ref)().

# Arguments
* `device_list`: device list to be freed.
"""
function avdevice_free_list_devices(device_list)
    ccall((:avdevice_free_list_devices, libavdevice), Cvoid, (Ptr{Ptr{AVDeviceInfoList}},), device_list)
end

"""
    avdevice_list_input_sources(device, device_name, device_options, device_list)

List devices.

Returns available device names and their parameters. These are convenient wrappers for [`avdevice_list_devices`](@ref)(). Device context is allocated and deallocated internally.

!!! note

    device argument takes precedence over device\\_name when both are set.

# Arguments
* `device`: device format. May be NULL if device name is set.
* `device_name`: device name. May be NULL if device format is set.
* `device_options`: An [`AVDictionary`](@ref) filled with device-private options. May be NULL. The same options must be passed later to [`avformat_write_header`](@ref)() for output devices or [`avformat_open_input`](@ref)() for input devices, or at any other place that affects device-private options.
* `device_list`:\\[out\\] list of autodetected devices
# Returns
count of autodetected devices, negative on error.
"""
function avdevice_list_input_sources(device, device_name, device_options, device_list)
    ccall((:avdevice_list_input_sources, libavdevice), Cint, (Ptr{AVInputFormat}, Cstring, Ptr{AVDictionary}, Ptr{Ptr{AVDeviceInfoList}}), device, device_name, device_options, device_list)
end

function avdevice_list_output_sinks(device, device_name, device_options, device_list)
    ccall((:avdevice_list_output_sinks, libavdevice), Cint, (Ptr{AVOutputFormat}, Cstring, Ptr{AVDictionary}, Ptr{Ptr{AVDeviceInfoList}}), device, device_name, device_options, device_list)
end

"""
    avfilter_version()

Return the [`LIBAVFILTER_VERSION_INT`](@ref) constant.
"""
function avfilter_version()
    ccall((:avfilter_version, libavfilter), Cuint, ())
end

"""
    avfilter_configuration()

Return the libavfilter build-time configuration.
"""
function avfilter_configuration()
    ccall((:avfilter_configuration, libavfilter), Cstring, ())
end

"""
    avfilter_license()

Return the libavfilter license.
"""
function avfilter_license()
    ccall((:avfilter_license, libavfilter), Cstring, ())
end

"""
    AVFilter

Filter definition. This defines the pads a filter contains, and all the callback functions used to interact with the filter.
"""
struct AVFilter
    name::Cstring
    description::Cstring
    inputs::Ptr{AVFilterPad}
    outputs::Ptr{AVFilterPad}
    priv_class::Ptr{AVClass}
    flags::Cint
end

# typedef int ( avfilter_execute_func ) ( AVFilterContext * ctx , avfilter_action_func * func , void * arg , int * ret , int nb_jobs )
"""
A function executing multiple jobs, possibly in parallel.

# Arguments
* `ctx`: the filter context to which the jobs belong
* `func`: the function to be called multiple times
* `arg`: the argument to be passed to func
* `ret`: a nb\\_jobs-sized array to be filled with return values from each invocation of func
* `nb_jobs`: the number of jobs to execute
# Returns
0 on success, a negative [`AVERROR`](@ref) on error
"""
const avfilter_execute_func = Cvoid

struct AVFilterGraph
    av_class::Ptr{AVClass}
    filters::Ptr{Ptr{Cvoid}} # filters::Ptr{Ptr{AVFilterContext}}
    nb_filters::Cuint
    scale_sws_opts::Cstring
    thread_type::Cint
    nb_threads::Cint
    opaque::Ptr{Cvoid}
    execute::Ptr{avfilter_execute_func}
    aresample_swr_opts::Cstring
    max_buffered_frames::Cuint
end

function Base.getproperty(x::AVFilterGraph, f::Symbol)
    f === :filters && return Ptr{Ptr{AVFilterContext}}(getfield(x, f))
    return getfield(x, f)
end

mutable struct AVFilterCommand end

"""
    AVFilterContext

An instance of a filter
"""
struct AVFilterContext
    data::NTuple{152, UInt8}
end

function Base.getproperty(x::Ptr{AVFilterContext}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :filter && return Ptr{Ptr{AVFilter}}(x + 8)
    f === :name && return Ptr{Cstring}(x + 16)
    f === :input_pads && return Ptr{Ptr{AVFilterPad}}(x + 24)
    f === :inputs && return Ptr{Ptr{Ptr{AVFilterLink}}}(x + 32)
    f === :nb_inputs && return Ptr{Cuint}(x + 40)
    f === :output_pads && return Ptr{Ptr{AVFilterPad}}(x + 48)
    f === :outputs && return Ptr{Ptr{Ptr{AVFilterLink}}}(x + 56)
    f === :nb_outputs && return Ptr{Cuint}(x + 64)
    f === :priv && return Ptr{Ptr{Cvoid}}(x + 72)
    f === :graph && return Ptr{Ptr{AVFilterGraph}}(x + 80)
    f === :thread_type && return Ptr{Cint}(x + 88)
    f === :nb_threads && return Ptr{Cint}(x + 92)
    f === :command_queue && return Ptr{Ptr{AVFilterCommand}}(x + 96)
    f === :enable_str && return Ptr{Cstring}(x + 104)
    f === :enable && return Ptr{Ptr{Cvoid}}(x + 112)
    f === :var_values && return Ptr{Ptr{Cdouble}}(x + 120)
    f === :is_disabled && return Ptr{Cint}(x + 128)
    f === :hw_device_ctx && return Ptr{Ptr{AVBufferRef}}(x + 136)
    f === :ready && return Ptr{Cuint}(x + 144)
    f === :extra_hw_frames && return Ptr{Cint}(x + 148)
    return getfield(x, f)
end

function Base.getproperty(x::AVFilterContext, f::Symbol)
    r = Ref{AVFilterContext}(x)
    ptr = Base.unsafe_convert(Ptr{AVFilterContext}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVFilterContext}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVFilterContext, private::Bool = false)
    (:av_class, :filter, :name, :input_pads, :inputs, :nb_inputs, :output_pads, :outputs, :nb_outputs, :priv, :graph, :thread_type, :nb_threads, :command_queue, :enable_str, :enable, :var_values, :is_disabled, :hw_device_ctx, :ready, :extra_hw_frames, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVFilterFormatsConfig

Lists of formats / etc. supported by an end of a link.

This structure is directly part of [`AVFilterLink`](@ref), in two copies: one for the source filter, one for the destination filter.

These lists are used for negotiating the format to actually be used, which will be loaded into the format and channel\\_layout members of [`AVFilterLink`](@ref), when chosen.
"""
struct AVFilterFormatsConfig
    formats::Ptr{AVFilterFormats}
    samplerates::Ptr{AVFilterFormats}
    channel_layouts::Ptr{AVFilterChannelLayouts}
    color_spaces::Ptr{AVFilterFormats}
    color_ranges::Ptr{AVFilterFormats}
end

"""
    AVFilterLink

A link between two filters. This contains pointers to the source and destination filters between which this link exists, and the indexes of the pads involved. In addition, this link also contains the parameters which have been negotiated and agreed upon between the filter, such as image dimensions, format, etc.

Applications must not normally access the link structure directly. Use the buffersrc and buffersink API instead. In the future, access to the header may be reserved for filters implementation.
"""
struct AVFilterLink
    data::NTuple{200, UInt8}
end

function Base.getproperty(x::Ptr{AVFilterLink}, f::Symbol)
    f === :src && return Ptr{Ptr{AVFilterContext}}(x + 0)
    f === :srcpad && return Ptr{Ptr{AVFilterPad}}(x + 8)
    f === :dst && return Ptr{Ptr{AVFilterContext}}(x + 16)
    f === :dstpad && return Ptr{Ptr{AVFilterPad}}(x + 24)
    f === :type && return Ptr{AVMediaType}(x + 32)
    f === :format && return Ptr{Cint}(x + 36)
    f === :w && return Ptr{Cint}(x + 40)
    f === :h && return Ptr{Cint}(x + 44)
    f === :sample_aspect_ratio && return Ptr{AVRational}(x + 48)
    f === :colorspace && return Ptr{AVColorSpace}(x + 56)
    f === :color_range && return Ptr{AVColorRange}(x + 60)
    f === :sample_rate && return Ptr{Cint}(x + 64)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 72)
    f === :time_base && return Ptr{AVRational}(x + 96)
    f === :side_data && return Ptr{Ptr{Ptr{AVFrameSideData}}}(x + 104)
    f === :nb_side_data && return Ptr{Cint}(x + 112)
    f === :incfg && return Ptr{AVFilterFormatsConfig}(x + 120)
    f === :outcfg && return Ptr{AVFilterFormatsConfig}(x + 160)
    return getfield(x, f)
end

function Base.getproperty(x::AVFilterLink, f::Symbol)
    r = Ref{AVFilterLink}(x)
    ptr = Base.unsafe_convert(Ptr{AVFilterLink}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVFilterLink}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVFilterLink, private::Bool = false)
    (:src, :srcpad, :dst, :dstpad, :type, :format, :w, :h, :sample_aspect_ratio, :colorspace, :color_range, :sample_rate, :ch_layout, :time_base, :side_data, :nb_side_data, :incfg, :outcfg, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    avfilter_pad_get_name(pads, pad_idx::Integer)

Get the name of an [`AVFilterPad`](@ref).

# Arguments
* `pads`: an array of AVFilterPads
* `pad_idx`: index of the pad in the array; it is the caller's responsibility to ensure the index is valid
# Returns
name of the pad\\_idx'th pad in pads
"""
function avfilter_pad_get_name(pads, pad_idx::Integer)
    ccall((:avfilter_pad_get_name, libavfilter), Cstring, (Ptr{AVFilterPad}, Cint), pads, pad_idx)
end

"""
    avfilter_pad_get_type(pads, pad_idx::Integer)

Get the type of an [`AVFilterPad`](@ref).

# Arguments
* `pads`: an array of AVFilterPads
* `pad_idx`: index of the pad in the array; it is the caller's responsibility to ensure the index is valid
# Returns
type of the pad\\_idx'th pad in pads
"""
function avfilter_pad_get_type(pads, pad_idx::Integer)
    ccall((:avfilter_pad_get_type, libavfilter), AVMediaType, (Ptr{AVFilterPad}, Cint), pads, pad_idx)
end

"""
    avfilter_link_get_hw_frames_ctx(link)

Get the hardware frames context of a filter link.

# Arguments
* `link`: an [`AVFilterLink`](@ref)
# Returns
a ref-counted copy of the link's hw\\_frames\\_ctx field if there is a hardware frames context associated with the link or NULL otherwise. The returned [`AVBufferRef`](@ref) needs to be released with [`av_buffer_unref`](@ref)() when it is no longer used.
"""
function avfilter_link_get_hw_frames_ctx(link)
    ccall((:avfilter_link_get_hw_frames_ctx, libavfilter), Ptr{AVBufferRef}, (Ptr{AVFilterLink},), link)
end

"""
    avfilter_filter_pad_count(filter, is_output::Integer)

Get the number of elements in an [`AVFilter`](@ref)'s inputs or outputs array.
"""
function avfilter_filter_pad_count(filter, is_output::Integer)
    ccall((:avfilter_filter_pad_count, libavfilter), Cuint, (Ptr{AVFilter}, Cint), filter, is_output)
end

"""
    avfilter_link(src, srcpad::Integer, dst, dstpad::Integer)

Link two filters together.

# Arguments
* `src`: the source filter
* `srcpad`: index of the output pad on the source filter
* `dst`: the destination filter
* `dstpad`: index of the input pad on the destination filter
# Returns
zero on success
"""
function avfilter_link(src, srcpad::Integer, dst, dstpad::Integer)
    ccall((:avfilter_link, libavfilter), Cint, (Ptr{AVFilterContext}, Cuint, Ptr{AVFilterContext}, Cuint), src, srcpad, dst, dstpad)
end

"""
    avfilter_process_command(filter, cmd, arg, res, res_len::Integer, flags::Integer)

Make the filter instance process a command. It is recommended to use [`avfilter_graph_send_command`](@ref)().
"""
function avfilter_process_command(filter, cmd, arg, res, res_len::Integer, flags::Integer)
    ccall((:avfilter_process_command, libavfilter), Cint, (Ptr{AVFilterContext}, Cstring, Cstring, Cstring, Cint, Cint), filter, cmd, arg, res, res_len, flags)
end

"""
    av_filter_iterate(opaque)

Iterate over all registered filters.

# Arguments
* `opaque`: a pointer where libavfilter will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered filter or NULL when the iteration is finished
"""
function av_filter_iterate(opaque)
    ccall((:av_filter_iterate, libavfilter), Ptr{AVFilter}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    avfilter_get_by_name(name)

Get a filter definition matching the given name.

# Arguments
* `name`: the filter name to find
# Returns
the filter definition, if any matching one is registered. NULL if none found.
"""
function avfilter_get_by_name(name)
    ccall((:avfilter_get_by_name, libavfilter), Ptr{AVFilter}, (Cstring,), name)
end

"""
    avfilter_init_str(ctx, args)

Initialize a filter with the supplied parameters.

# Arguments
* `ctx`: uninitialized filter context to initialize
* `args`: Options to initialize the filter with. This must be a ':'-separated list of options in the 'key=value' form. May be NULL if the options have been set directly using the AVOptions API or there are no options that need to be set.
# Returns
0 on success, a negative [`AVERROR`](@ref) on failure
"""
function avfilter_init_str(ctx, args)
    ccall((:avfilter_init_str, libavfilter), Cint, (Ptr{AVFilterContext}, Cstring), ctx, args)
end

"""
    avfilter_init_dict(ctx, options)

Initialize a filter with the supplied dictionary of options.

!!! note

    This function and [`avfilter_init_str`](@ref)() do essentially the same thing, the difference is in manner in which the options are passed. It is up to the calling code to choose whichever is more preferable. The two functions also behave differently when some of the provided options are not declared as supported by the filter. In such a case, [`avfilter_init_str`](@ref)() will fail, but this function will leave those extra options in the options [`AVDictionary`](@ref) and continue as usual.

# Arguments
* `ctx`: uninitialized filter context to initialize
* `options`: An [`AVDictionary`](@ref) filled with options for this filter. On return this parameter will be destroyed and replaced with a dict containing options that were not found. This dictionary must be freed by the caller. May be NULL, then this function is equivalent to [`avfilter_init_str`](@ref)() with the second parameter set to NULL.
# Returns
0 on success, a negative [`AVERROR`](@ref) on failure
"""
function avfilter_init_dict(ctx, options)
    ccall((:avfilter_init_dict, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{Ptr{AVDictionary}}), ctx, options)
end

"""
    avfilter_free(filter)

Free a filter context. This will also remove the filter from its filtergraph's list of filters.

# Arguments
* `filter`: the filter to free
"""
function avfilter_free(filter)
    ccall((:avfilter_free, libavfilter), Cvoid, (Ptr{AVFilterContext},), filter)
end

"""
    avfilter_insert_filter(link, filt, filt_srcpad_idx::Integer, filt_dstpad_idx::Integer)

Insert a filter in the middle of an existing link.

# Arguments
* `link`: the link into which the filter should be inserted
* `filt`: the filter to be inserted
* `filt_srcpad_idx`: the input pad on the filter to connect
* `filt_dstpad_idx`: the output pad on the filter to connect
# Returns
zero on success
"""
function avfilter_insert_filter(link, filt, filt_srcpad_idx::Integer, filt_dstpad_idx::Integer)
    ccall((:avfilter_insert_filter, libavfilter), Cint, (Ptr{AVFilterLink}, Ptr{AVFilterContext}, Cuint, Cuint), link, filt, filt_srcpad_idx, filt_dstpad_idx)
end

"""
    avfilter_get_class()

# Returns
[`AVClass`](@ref) for [`AVFilterContext`](@ref).
# See also
[`av_opt_find`](@ref)().
"""
function avfilter_get_class()
    ccall((:avfilter_get_class, libavfilter), Ptr{AVClass}, ())
end

# typedef int ( avfilter_action_func ) ( AVFilterContext * ctx , void * arg , int jobnr , int nb_jobs )
"""
A function pointer passed to the AVFilterGraph.execute callback to be executed multiple times, possibly in parallel.

# Arguments
* `ctx`: the filter context the job belongs to
* `arg`: an opaque parameter passed through from AVFilterGraph.execute
* `jobnr`: the index of the job being executed
* `nb_jobs`: the total number of jobs
# Returns
0 on success, a negative [`AVERROR`](@ref) on error
"""
const avfilter_action_func = Cvoid

"""
    avfilter_graph_alloc()

Allocate a filter graph.

# Returns
the allocated filter graph on success or NULL.
"""
function avfilter_graph_alloc()
    ccall((:avfilter_graph_alloc, libavfilter), Ptr{AVFilterGraph}, ())
end

"""
    avfilter_graph_alloc_filter(graph, filter, name)

Create a new filter instance in a filter graph.

# Arguments
* `graph`: graph in which the new filter will be used
* `filter`: the filter to create an instance of
* `name`: Name to give to the new instance (will be copied to [`AVFilterContext`](@ref).name). This may be used by the caller to identify different filters, libavfilter itself assigns no semantics to this parameter. May be NULL.
# Returns
the context of the newly created filter instance (note that it is also retrievable directly through [`AVFilterGraph`](@ref).filters or with [`avfilter_graph_get_filter`](@ref)()) on success or NULL on failure.
"""
function avfilter_graph_alloc_filter(graph, filter, name)
    ccall((:avfilter_graph_alloc_filter, libavfilter), Ptr{AVFilterContext}, (Ptr{AVFilterGraph}, Ptr{AVFilter}, Cstring), graph, filter, name)
end

"""
    avfilter_graph_get_filter(graph, name)

Get a filter instance identified by instance name from graph.

# Arguments
* `graph`: filter graph to search through.
* `name`: filter instance name (should be unique in the graph).
# Returns
the pointer to the found filter instance or NULL if it cannot be found.
"""
function avfilter_graph_get_filter(graph, name)
    ccall((:avfilter_graph_get_filter, libavfilter), Ptr{AVFilterContext}, (Ptr{AVFilterGraph}, Cstring), graph, name)
end

"""
    avfilter_graph_create_filter(filt_ctx, filt, name, args, opaque, graph_ctx)

A convenience wrapper that allocates and initializes a filter in a single step. The filter instance is created from the filter filt and inited with the parameter args. opaque is currently ignored.

In case of success put in *filt\\_ctx the pointer to the created filter instance, otherwise set *filt\\_ctx to NULL.

!!! warning

    Since the filter is initialized after this function successfully returns, you MUST NOT set any further options on it. If you need to do that, call ::[`avfilter_graph_alloc_filter`](@ref)(), followed by setting the options, followed by ::[`avfilter_init_dict`](@ref)() instead of this function.

# Arguments
* `name`: the instance name to give to the created filter instance
* `graph_ctx`: the filter graph
# Returns
a negative [`AVERROR`](@ref) error code in case of failure, a non negative value otherwise
"""
function avfilter_graph_create_filter(filt_ctx, filt, name, args, opaque, graph_ctx)
    ccall((:avfilter_graph_create_filter, libavfilter), Cint, (Ptr{Ptr{AVFilterContext}}, Ptr{AVFilter}, Cstring, Cstring, Ptr{Cvoid}, Ptr{AVFilterGraph}), filt_ctx, filt, name, args, opaque, graph_ctx)
end

"""
    avfilter_graph_set_auto_convert(graph, flags::Integer)

Enable or disable automatic format conversion inside the graph.

Note that format conversion can still happen inside explicitly inserted scale and aresample filters.

# Arguments
* `flags`: any of the AVFILTER\\_AUTO\\_CONVERT\\_* constants
"""
function avfilter_graph_set_auto_convert(graph, flags::Integer)
    ccall((:avfilter_graph_set_auto_convert, libavfilter), Cvoid, (Ptr{AVFilterGraph}, Cuint), graph, flags)
end

const __JL_Ctag_34 = Int32
const AVFILTER_AUTO_CONVERT_ALL = 0 % Int32
const AVFILTER_AUTO_CONVERT_NONE = -1 % Int32

"""
    avfilter_graph_config(graphctx, log_ctx)

Check validity and configure all the links and formats in the graph.

# Arguments
* `graphctx`: the filter graph
* `log_ctx`: context used for logging
# Returns
>= 0 in case of success, a negative [`AVERROR`](@ref) code otherwise
"""
function avfilter_graph_config(graphctx, log_ctx)
    ccall((:avfilter_graph_config, libavfilter), Cint, (Ptr{AVFilterGraph}, Ptr{Cvoid}), graphctx, log_ctx)
end

"""
    avfilter_graph_free(graph)

Free a graph, destroy its links, and set *graph to NULL. If *graph is NULL, do nothing.
"""
function avfilter_graph_free(graph)
    ccall((:avfilter_graph_free, libavfilter), Cvoid, (Ptr{Ptr{AVFilterGraph}},), graph)
end

"""
    AVFilterInOut

A linked-list of the inputs/outputs of the filter chain.

This is mainly useful for [`avfilter_graph_parse`](@ref)() / [`avfilter_graph_parse2`](@ref)(), where it is used to communicate open (unlinked) inputs and outputs from and to the caller. This struct specifies, per each not connected pad contained in the graph, the filter context and the pad index required for establishing a link.
"""
struct AVFilterInOut
    name::Cstring
    filter_ctx::Ptr{AVFilterContext}
    pad_idx::Cint
    next::Ptr{AVFilterInOut}
end

"""
    avfilter_inout_alloc()

Allocate a single [`AVFilterInOut`](@ref) entry. Must be freed with [`avfilter_inout_free`](@ref)().

# Returns
allocated [`AVFilterInOut`](@ref) on success, NULL on failure.
"""
function avfilter_inout_alloc()
    ccall((:avfilter_inout_alloc, libavfilter), Ptr{AVFilterInOut}, ())
end

"""
    avfilter_inout_free(inout)

Free the supplied list of [`AVFilterInOut`](@ref) and set *inout to NULL. If *inout is NULL, do nothing.
"""
function avfilter_inout_free(inout)
    ccall((:avfilter_inout_free, libavfilter), Cvoid, (Ptr{Ptr{AVFilterInOut}},), inout)
end

"""
    avfilter_graph_parse(graph, filters, inputs, outputs, log_ctx)

Add a graph described by a string to a graph.

!!! note

    The caller must provide the lists of inputs and outputs, which therefore must be known before calling the function.

!!! note

    The inputs parameter describes inputs of the already existing part of the graph; i.e. from the point of view of the newly created part, they are outputs. Similarly the outputs parameter describes outputs of the already existing filters, which are provided as inputs to the parsed filters.

# Arguments
* `graph`: the filter graph where to link the parsed graph context
* `filters`: string to be parsed
* `inputs`: linked list to the inputs of the graph
* `outputs`: linked list to the outputs of the graph
# Returns
zero on success, a negative [`AVERROR`](@ref) code on error
"""
function avfilter_graph_parse(graph, filters, inputs, outputs, log_ctx)
    ccall((:avfilter_graph_parse, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Ptr{AVFilterInOut}, Ptr{AVFilterInOut}, Ptr{Cvoid}), graph, filters, inputs, outputs, log_ctx)
end

"""
    avfilter_graph_parse_ptr(graph, filters, inputs, outputs, log_ctx)

Add a graph described by a string to a graph.

In the graph filters description, if the input label of the first filter is not specified, "in" is assumed; if the output label of the last filter is not specified, "out" is assumed.

# Arguments
* `graph`: the filter graph where to link the parsed graph context
* `filters`: string to be parsed
* `inputs`: pointer to a linked list to the inputs of the graph, may be NULL. If non-NULL, *inputs is updated to contain the list of open inputs after the parsing, should be freed with [`avfilter_inout_free`](@ref)().
* `outputs`: pointer to a linked list to the outputs of the graph, may be NULL. If non-NULL, *outputs is updated to contain the list of open outputs after the parsing, should be freed with [`avfilter_inout_free`](@ref)().
# Returns
non negative on success, a negative [`AVERROR`](@ref) code on error
"""
function avfilter_graph_parse_ptr(graph, filters, inputs, outputs, log_ctx)
    ccall((:avfilter_graph_parse_ptr, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Ptr{Ptr{AVFilterInOut}}, Ptr{Ptr{AVFilterInOut}}, Ptr{Cvoid}), graph, filters, inputs, outputs, log_ctx)
end

"""
    avfilter_graph_parse2(graph, filters, inputs, outputs)

Add a graph described by a string to a graph.

!!! note

    This function returns the inputs and outputs that are left unlinked after parsing the graph and the caller then deals with them.

!!! note

    This function makes no reference whatsoever to already existing parts of the graph and the inputs parameter will on return contain inputs of the newly parsed part of the graph. Analogously the outputs parameter will contain outputs of the newly created filters.

# Arguments
* `graph`:\\[in\\] the filter graph where to link the parsed graph context
* `filters`:\\[in\\] string to be parsed
* `inputs`:\\[out\\] a linked list of all free (unlinked) inputs of the parsed graph will be returned here. It is to be freed by the caller using [`avfilter_inout_free`](@ref)().
* `outputs`:\\[out\\] a linked list of all free (unlinked) outputs of the parsed graph will be returned here. It is to be freed by the caller using [`avfilter_inout_free`](@ref)().
# Returns
zero on success, a negative [`AVERROR`](@ref) code on error
"""
function avfilter_graph_parse2(graph, filters, inputs, outputs)
    ccall((:avfilter_graph_parse2, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Ptr{Ptr{AVFilterInOut}}, Ptr{Ptr{AVFilterInOut}}), graph, filters, inputs, outputs)
end

"""
    AVFilterPadParams

Parameters of a filter's input or output pad.

Created as a child of [`AVFilterParams`](@ref) by [`avfilter_graph_segment_parse`](@ref)(). Freed in [`avfilter_graph_segment_free`](@ref)().
"""
struct AVFilterPadParams
    label::Cstring
end

"""
    AVFilterParams

Parameters describing a filter to be created in a filtergraph.

Created as a child of [`AVFilterGraphSegment`](@ref) by [`avfilter_graph_segment_parse`](@ref)(). Freed in [`avfilter_graph_segment_free`](@ref)().
"""
struct AVFilterParams
    filter::Ptr{AVFilterContext}
    filter_name::Cstring
    instance_name::Cstring
    opts::Ptr{AVDictionary}
    inputs::Ptr{Ptr{AVFilterPadParams}}
    nb_inputs::Cuint
    outputs::Ptr{Ptr{AVFilterPadParams}}
    nb_outputs::Cuint
end

"""
    AVFilterChain

A filterchain is a list of filter specifications.

Created as a child of [`AVFilterGraphSegment`](@ref) by [`avfilter_graph_segment_parse`](@ref)(). Freed in [`avfilter_graph_segment_free`](@ref)().
"""
struct AVFilterChain
    filters::Ptr{Ptr{AVFilterParams}}
    nb_filters::Csize_t
end

"""
    AVFilterGraphSegment

A parsed representation of a filtergraph segment.

A filtergraph segment is conceptually a list of filterchains, with some supplementary information (e.g. format conversion flags).

Created by [`avfilter_graph_segment_parse`](@ref)(). Must be freed with [`avfilter_graph_segment_free`](@ref)().
"""
struct AVFilterGraphSegment
    graph::Ptr{AVFilterGraph}
    chains::Ptr{Ptr{AVFilterChain}}
    nb_chains::Csize_t
    scale_sws_opts::Cstring
end

"""
    avfilter_graph_segment_parse(graph, graph_str, flags::Integer, seg)

Parse a textual filtergraph description into an intermediate form.

This intermediate representation is intended to be modified by the caller as described in the documentation of [`AVFilterGraphSegment`](@ref) and its children, and then applied to the graph either manually or with other avfilter\\_graph\\_segment\\_*() functions. See the documentation for [`avfilter_graph_segment_apply`](@ref)() for the canonical way to apply [`AVFilterGraphSegment`](@ref).

\\retval"non-negative number" success

\\retval"negative error code" failure

# Arguments
* `graph`: Filter graph the parsed segment is associated with. Will only be used for logging and similar auxiliary purposes. The graph will not be actually modified by this function - the parsing results are instead stored in seg for further processing.
* `graph_str`: a string describing the filtergraph segment
* `flags`: reserved for future use, caller must set to 0 for now
* `seg`: A pointer to the newly-created [`AVFilterGraphSegment`](@ref) is written here on success. The graph segment is owned by the caller and must be freed with [`avfilter_graph_segment_free`](@ref)() before graph itself is freed.
"""
function avfilter_graph_segment_parse(graph, graph_str, flags::Integer, seg)
    ccall((:avfilter_graph_segment_parse, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Cint, Ptr{Ptr{AVFilterGraphSegment}}), graph, graph_str, flags, seg)
end

"""
    avfilter_graph_segment_create_filters(seg, flags::Integer)

Create filters specified in a graph segment.

Walk through the creation-pending [`AVFilterParams`](@ref) in the segment and create new filter instances for them. Creation-pending params are those where [`AVFilterParams`](@ref).filter\\_name is non-NULL (and hence [`AVFilterParams`](@ref).filter is NULL). All other [`AVFilterParams`](@ref) instances are ignored.

For any filter created by this function, the corresponding [`AVFilterParams`](@ref).filter is set to the newly-created filter context, [`AVFilterParams`](@ref).filter\\_name and [`AVFilterParams`](@ref).instance\\_name are freed and set to NULL.

\\retval"non-negative number" Success, all creation-pending filters were successfully created

\\retvalAVERROR_FILTER_NOT_FOUND some filter's name did not correspond to a known filter

\\retval"another negative error code" other failures

!!! note

    Calling this function multiple times is safe, as it is idempotent.

# Arguments
* `seg`: the filtergraph segment to process
* `flags`: reserved for future use, caller must set to 0 for now
"""
function avfilter_graph_segment_create_filters(seg, flags::Integer)
    ccall((:avfilter_graph_segment_create_filters, libavfilter), Cint, (Ptr{AVFilterGraphSegment}, Cint), seg, flags)
end

"""
    avfilter_graph_segment_apply_opts(seg, flags::Integer)

Apply parsed options to filter instances in a graph segment.

Walk through all filter instances in the graph segment that have option dictionaries associated with them and apply those options with [`av_opt_set_dict2`](@ref)(..., [`AV_OPT_SEARCH_CHILDREN`](@ref)). [`AVFilterParams`](@ref).opts is replaced by the dictionary output by [`av_opt_set_dict2`](@ref)(), which should be empty (NULL) if all options were successfully applied.

If any options could not be found, this function will continue processing all other filters and finally return [`AVERROR_OPTION_NOT_FOUND`](@ref) (unless another error happens). The calling program may then deal with unapplied options as it wishes.

Any creation-pending filters (see [`avfilter_graph_segment_create_filters`](@ref)()) present in the segment will cause this function to fail. [`AVFilterParams`](@ref) with no associated filter context are simply skipped.

\\retval"non-negative number" Success, all options were successfully applied.

\\retvalAVERROR_OPTION_NOT_FOUND some options were not found in a filter

\\retval"another negative error code" other failures

!!! note

    Calling this function multiple times is safe, as it is idempotent.

# Arguments
* `seg`: the filtergraph segment to process
* `flags`: reserved for future use, caller must set to 0 for now
"""
function avfilter_graph_segment_apply_opts(seg, flags::Integer)
    ccall((:avfilter_graph_segment_apply_opts, libavfilter), Cint, (Ptr{AVFilterGraphSegment}, Cint), seg, flags)
end

"""
    avfilter_graph_segment_init(seg, flags::Integer)

Initialize all filter instances in a graph segment.

Walk through all filter instances in the graph segment and call [`avfilter_init_dict`](@ref)(..., NULL) on those that have not been initialized yet.

Any creation-pending filters (see [`avfilter_graph_segment_create_filters`](@ref)()) present in the segment will cause this function to fail. [`AVFilterParams`](@ref) with no associated filter context or whose filter context is already initialized, are simply skipped.

\\retval"non-negative number" Success, all filter instances were successfully initialized

\\retval"negative error code" failure

!!! note

    Calling this function multiple times is safe, as it is idempotent.

# Arguments
* `seg`: the filtergraph segment to process
* `flags`: reserved for future use, caller must set to 0 for now
"""
function avfilter_graph_segment_init(seg, flags::Integer)
    ccall((:avfilter_graph_segment_init, libavfilter), Cint, (Ptr{AVFilterGraphSegment}, Cint), seg, flags)
end

"""
    avfilter_graph_segment_link(seg, flags::Integer, inputs, outputs)

Link filters in a graph segment.

Walk through all filter instances in the graph segment and try to link all unlinked input and output pads. Any creation-pending filters (see [`avfilter_graph_segment_create_filters`](@ref)()) present in the segment will cause this function to fail. Disabled filters and already linked pads are skipped.

Every filter output pad that has a corresponding [`AVFilterPadParams`](@ref) with a non-NULL label is - linked to the input with the matching label, if one exists; - exported in the outputs linked list otherwise, with the label preserved. Unlabeled outputs are - linked to the first unlinked unlabeled input in the next non-disabled filter in the chain, if one exists - exported in the outputs linked list otherwise, with NULL label

Similarly, unlinked input pads are exported in the inputs linked list.

\\retval"non-negative number" success

\\retval"negative error code" failure

!!! note

    Calling this function multiple times is safe, as it is idempotent.

# Arguments
* `seg`: the filtergraph segment to process
* `flags`: reserved for future use, caller must set to 0 for now
* `inputs`:\\[out\\] a linked list of all free (unlinked) inputs of the filters in this graph segment will be returned here. It is to be freed by the caller using [`avfilter_inout_free`](@ref)().
* `outputs`:\\[out\\] a linked list of all free (unlinked) outputs of the filters in this graph segment will be returned here. It is to be freed by the caller using [`avfilter_inout_free`](@ref)().
"""
function avfilter_graph_segment_link(seg, flags::Integer, inputs, outputs)
    ccall((:avfilter_graph_segment_link, libavfilter), Cint, (Ptr{AVFilterGraphSegment}, Cint, Ptr{Ptr{AVFilterInOut}}, Ptr{Ptr{AVFilterInOut}}), seg, flags, inputs, outputs)
end

"""
    avfilter_graph_segment_apply(seg, flags::Integer, inputs, outputs)

Apply all filter/link descriptions from a graph segment to the associated filtergraph.

This functions is currently equivalent to calling the following in sequence: - [`avfilter_graph_segment_create_filters`](@ref)(); - [`avfilter_graph_segment_apply_opts`](@ref)(); - [`avfilter_graph_segment_init`](@ref)(); - [`avfilter_graph_segment_link`](@ref)(); failing if any of them fails. This list may be extended in the future.

Since the above functions are idempotent, the caller may call some of them manually, then do some custom processing on the filtergraph, then call this function to do the rest.

\\retval"non-negative number" success

\\retval"negative error code" failure

!!! note

    Calling this function multiple times is safe, as it is idempotent.

# Arguments
* `seg`: the filtergraph segment to process
* `flags`: reserved for future use, caller must set to 0 for now
* `inputs`:\\[out\\] passed to [`avfilter_graph_segment_link`](@ref)()
* `outputs`:\\[out\\] passed to [`avfilter_graph_segment_link`](@ref)()
"""
function avfilter_graph_segment_apply(seg, flags::Integer, inputs, outputs)
    ccall((:avfilter_graph_segment_apply, libavfilter), Cint, (Ptr{AVFilterGraphSegment}, Cint, Ptr{Ptr{AVFilterInOut}}, Ptr{Ptr{AVFilterInOut}}), seg, flags, inputs, outputs)
end

"""
    avfilter_graph_segment_free(seg)

Free the provided [`AVFilterGraphSegment`](@ref) and everything associated with it.

!!! note

    The filter contexts ([`AVFilterParams`](@ref).filter) are owned by [`AVFilterGraph`](@ref) rather than [`AVFilterGraphSegment`](@ref), so they are not freed.

# Arguments
* `seg`: double pointer to the [`AVFilterGraphSegment`](@ref) to be freed. NULL will be written to this pointer on exit from this function.
"""
function avfilter_graph_segment_free(seg)
    ccall((:avfilter_graph_segment_free, libavfilter), Cvoid, (Ptr{Ptr{AVFilterGraphSegment}},), seg)
end

"""
    avfilter_graph_send_command(graph, target, cmd, arg, res, res_len::Integer, flags::Integer)

Send a command to one or more filter instances.

# Arguments
* `graph`: the filter graph
* `target`: the filter(s) to which the command should be sent "all" sends to all filters otherwise it can be a filter or filter instance name which will send the command to all matching filters.
* `cmd`: the command to send, for handling simplicity all commands must be alphanumeric only
* `arg`: the argument for the command
* `res`: a buffer with size res\\_size where the filter(s) can return a response.
# Returns
>=0 on success otherwise an error code. [`AVERROR`](@ref)(ENOSYS) on unsupported commands
"""
function avfilter_graph_send_command(graph, target, cmd, arg, res, res_len::Integer, flags::Integer)
    ccall((:avfilter_graph_send_command, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Cstring, Cstring, Cstring, Cint, Cint), graph, target, cmd, arg, res, res_len, flags)
end

"""
    avfilter_graph_queue_command(graph, target, cmd, arg, flags::Integer, ts::Cdouble)

Queue a command for one or more filter instances.

!!! note

    As this executes commands after this function returns, no return code from the filter is provided, also [`AVFILTER_CMD_FLAG_ONE`](@ref) is not supported.

# Arguments
* `graph`: the filter graph
* `target`: the filter(s) to which the command should be sent "all" sends to all filters otherwise it can be a filter or filter instance name which will send the command to all matching filters.
* `cmd`: the command to sent, for handling simplicity all commands must be alphanumeric only
* `arg`: the argument for the command
* `ts`: time at which the command should be sent to the filter
"""
function avfilter_graph_queue_command(graph, target, cmd, arg, flags::Integer, ts::Cdouble)
    ccall((:avfilter_graph_queue_command, libavfilter), Cint, (Ptr{AVFilterGraph}, Cstring, Cstring, Cstring, Cint, Cdouble), graph, target, cmd, arg, flags, ts)
end

"""
    avfilter_graph_dump(graph, options)

Dump a graph into a human-readable string representation.

# Arguments
* `graph`: the graph to dump
* `options`: formatting options; currently ignored
# Returns
a string, or NULL in case of memory allocation failure; the string must be freed using [`av_free`](@ref)
"""
function avfilter_graph_dump(graph, options)
    ccall((:avfilter_graph_dump, libavfilter), Cstring, (Ptr{AVFilterGraph}, Cstring), graph, options)
end

"""
    avfilter_graph_request_oldest(graph)

Request a frame on the oldest sink link.

If the request returns [`AVERROR_EOF`](@ref), try the next.

Note that this function is not meant to be the sole scheduling mechanism of a filtergraph, only a convenience function to help drain a filtergraph in a balanced way under normal circumstances.

Also note that [`AVERROR_EOF`](@ref) does not mean that frames did not arrive on some of the sinks during the process. When there are multiple sink links, in case the requested link returns an EOF, this may cause a filter to flush pending frames which are sent to another sink link, although unrequested.

# Returns
the return value of ff\\_request\\_frame(), or [`AVERROR_EOF`](@ref) if all links returned [`AVERROR_EOF`](@ref)
"""
function avfilter_graph_request_oldest(graph)
    ccall((:avfilter_graph_request_oldest, libavfilter), Cint, (Ptr{AVFilterGraph},), graph)
end

"""
    av_buffersink_get_frame_flags(ctx, frame, flags::Integer)

Get a frame with filtered data from sink and put it in frame.

# Arguments
* `ctx`: pointer to a buffersink or abuffersink filter context.
* `frame`: pointer to an allocated frame that will be filled with data. The data must be freed using [`av_frame_unref`](@ref)() / [`av_frame_free`](@ref)()
* `flags`: a combination of AV\\_BUFFERSINK\\_FLAG\\_* flags
# Returns
>= 0 in for success, a negative [`AVERROR`](@ref) code for failure.
"""
function av_buffersink_get_frame_flags(ctx, frame, flags::Integer)
    ccall((:av_buffersink_get_frame_flags, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}, Cint), ctx, frame, flags)
end

"""
    av_buffersink_set_frame_size(ctx, frame_size::Integer)

Set the frame size for an audio buffer sink.

All calls to av\\_buffersink\\_get\\_buffer\\_ref will return a buffer with exactly the specified number of samples, or [`AVERROR`](@ref)(EAGAIN) if there is not enough. The last buffer at EOF will be padded with 0.
"""
function av_buffersink_set_frame_size(ctx, frame_size::Integer)
    ccall((:av_buffersink_set_frame_size, libavfilter), Cvoid, (Ptr{AVFilterContext}, Cuint), ctx, frame_size)
end

"""
    av_buffersink_get_type(ctx)

` lavfi_buffersink_accessors Buffer sink accessors`

Get the properties of the stream @{
"""
function av_buffersink_get_type(ctx)
    ccall((:av_buffersink_get_type, libavfilter), AVMediaType, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_time_base(ctx)
    ccall((:av_buffersink_get_time_base, libavfilter), AVRational, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_format(ctx)
    ccall((:av_buffersink_get_format, libavfilter), Cint, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_frame_rate(ctx)
    ccall((:av_buffersink_get_frame_rate, libavfilter), AVRational, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_w(ctx)
    ccall((:av_buffersink_get_w, libavfilter), Cint, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_h(ctx)
    ccall((:av_buffersink_get_h, libavfilter), Cint, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_sample_aspect_ratio(ctx)
    ccall((:av_buffersink_get_sample_aspect_ratio, libavfilter), AVRational, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_colorspace(ctx)
    ccall((:av_buffersink_get_colorspace, libavfilter), AVColorSpace, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_color_range(ctx)
    ccall((:av_buffersink_get_color_range, libavfilter), AVColorRange, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_channels(ctx)
    ccall((:av_buffersink_get_channels, libavfilter), Cint, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_ch_layout(ctx, ch_layout)
    ccall((:av_buffersink_get_ch_layout, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVChannelLayout}), ctx, ch_layout)
end

function av_buffersink_get_sample_rate(ctx)
    ccall((:av_buffersink_get_sample_rate, libavfilter), Cint, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_hw_frames_ctx(ctx)
    ccall((:av_buffersink_get_hw_frames_ctx, libavfilter), Ptr{AVBufferRef}, (Ptr{AVFilterContext},), ctx)
end

function av_buffersink_get_side_data(ctx, nb_side_data)
    ccall((:av_buffersink_get_side_data, libavfilter), Ptr{Ptr{AVFrameSideData}}, (Ptr{AVFilterContext}, Ptr{Cint}), ctx, nb_side_data)
end

"""
    av_buffersink_get_frame(ctx, frame)

Get a frame with filtered data from sink and put it in frame.

# Arguments
* `ctx`: pointer to a context of a buffersink or abuffersink [`AVFilter`](@ref).
* `frame`: pointer to an allocated frame that will be filled with data. The data must be freed using [`av_frame_unref`](@ref)() / [`av_frame_free`](@ref)()
# Returns
- >= 0 if a frame was successfully returned. - [`AVERROR`](@ref)(EAGAIN) if no frames are available at this point; more input frames must be added to the filtergraph to get more output. - [`AVERROR_EOF`](@ref) if there will be no more output frames on this sink. - A different negative [`AVERROR`](@ref) code in other failure cases.
"""
function av_buffersink_get_frame(ctx, frame)
    ccall((:av_buffersink_get_frame, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}), ctx, frame)
end

"""
    av_buffersink_get_samples(ctx, frame, nb_samples::Integer)

Same as [`av_buffersink_get_frame`](@ref)(), but with the ability to specify the number of samples read. This function is less efficient than [`av_buffersink_get_frame`](@ref)(), because it copies the data around.

!!! warning

    do not mix this function with [`av_buffersink_get_frame`](@ref)(). Use only one or the other with a single sink, not both.

# Arguments
* `ctx`: pointer to a context of the abuffersink [`AVFilter`](@ref).
* `frame`: pointer to an allocated frame that will be filled with data. The data must be freed using [`av_frame_unref`](@ref)() / [`av_frame_free`](@ref)() frame will contain exactly nb\\_samples audio samples, except at the end of stream, when it can contain less than nb\\_samples.
# Returns
The return codes have the same meaning as for [`av_buffersink_get_frame`](@ref)().
"""
function av_buffersink_get_samples(ctx, frame, nb_samples::Integer)
    ccall((:av_buffersink_get_samples, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}, Cint), ctx, frame, nb_samples)
end

"""
    __JL_Ctag_41

` lavfi_buffersrc Buffer source API`

` lavfi`

@{
"""
const __JL_Ctag_41 = UInt32
const AV_BUFFERSRC_FLAG_NO_CHECK_FORMAT = 1 % UInt32
const AV_BUFFERSRC_FLAG_PUSH = 4 % UInt32
const AV_BUFFERSRC_FLAG_KEEP_REF = 8 % UInt32

"""
    av_buffersrc_get_nb_failed_requests(buffer_src)

Get the number of failed requests.

A failed request is when the request\\_frame method is called while no frame is present in the buffer. The number is reset when a frame is added.
"""
function av_buffersrc_get_nb_failed_requests(buffer_src)
    ccall((:av_buffersrc_get_nb_failed_requests, libavfilter), Cuint, (Ptr{AVFilterContext},), buffer_src)
end

"""
    AVBufferSrcParameters

This structure contains the parameters describing the frames that will be passed to this filter.

It should be allocated with [`av_buffersrc_parameters_alloc`](@ref)() and freed with [`av_free`](@ref)(). All the allocated fields in it remain owned by the caller.
"""
struct AVBufferSrcParameters
    data::NTuple{104, UInt8}
end

function Base.getproperty(x::Ptr{AVBufferSrcParameters}, f::Symbol)
    f === :format && return Ptr{Cint}(x + 0)
    f === :time_base && return Ptr{AVRational}(x + 4)
    f === :width && return Ptr{Cint}(x + 12)
    f === :height && return Ptr{Cint}(x + 16)
    f === :sample_aspect_ratio && return Ptr{AVRational}(x + 20)
    f === :frame_rate && return Ptr{AVRational}(x + 28)
    f === :hw_frames_ctx && return Ptr{Ptr{AVBufferRef}}(x + 40)
    f === :sample_rate && return Ptr{Cint}(x + 48)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 56)
    f === :color_space && return Ptr{AVColorSpace}(x + 80)
    f === :color_range && return Ptr{AVColorRange}(x + 84)
    f === :side_data && return Ptr{Ptr{Ptr{AVFrameSideData}}}(x + 88)
    f === :nb_side_data && return Ptr{Cint}(x + 96)
    return getfield(x, f)
end

function Base.getproperty(x::AVBufferSrcParameters, f::Symbol)
    r = Ref{AVBufferSrcParameters}(x)
    ptr = Base.unsafe_convert(Ptr{AVBufferSrcParameters}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVBufferSrcParameters}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVBufferSrcParameters, private::Bool = false)
    (:format, :time_base, :width, :height, :sample_aspect_ratio, :frame_rate, :hw_frames_ctx, :sample_rate, :ch_layout, :color_space, :color_range, :side_data, :nb_side_data, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    av_buffersrc_parameters_alloc()

Allocate a new [`AVBufferSrcParameters`](@ref) instance. It should be freed by the caller with [`av_free`](@ref)().
"""
function av_buffersrc_parameters_alloc()
    ccall((:av_buffersrc_parameters_alloc, libavfilter), Ptr{AVBufferSrcParameters}, ())
end

"""
    av_buffersrc_parameters_set(ctx, param)

Initialize the buffersrc or abuffersrc filter with the provided parameters. This function may be called multiple times, the later calls override the previous ones. Some of the parameters may also be set through AVOptions, then whatever method is used last takes precedence.

# Arguments
* `ctx`: an instance of the buffersrc or abuffersrc filter
* `param`: the stream parameters. The frames later passed to this filter must conform to those parameters. All the allocated fields in param remain owned by the caller, libavfilter will make internal copies or references when necessary.
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_buffersrc_parameters_set(ctx, param)
    ccall((:av_buffersrc_parameters_set, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVBufferSrcParameters}), ctx, param)
end

"""
    av_buffersrc_write_frame(ctx, frame)

Add a frame to the buffer source.

This function is equivalent to [`av_buffersrc_add_frame_flags`](@ref)() with the AV\\_BUFFERSRC\\_FLAG\\_KEEP\\_REF flag.

# Arguments
* `ctx`: an instance of the buffersrc filter
* `frame`: frame to be added. If the frame is reference counted, this function will make a new reference to it. Otherwise the frame data will be copied.
# Returns
0 on success, a negative [`AVERROR`](@ref) on error
"""
function av_buffersrc_write_frame(ctx, frame)
    ccall((:av_buffersrc_write_frame, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}), ctx, frame)
end

"""
    av_buffersrc_add_frame(ctx, frame)

Add a frame to the buffer source.

!!! note

    the difference between this function and [`av_buffersrc_write_frame`](@ref)() is that [`av_buffersrc_write_frame`](@ref)() creates a new reference to the input frame, while this function takes ownership of the reference passed to it.

This function is equivalent to [`av_buffersrc_add_frame_flags`](@ref)() without the AV\\_BUFFERSRC\\_FLAG\\_KEEP\\_REF flag.

# Arguments
* `ctx`: an instance of the buffersrc filter
* `frame`: frame to be added. If the frame is reference counted, this function will take ownership of the reference(s) and reset the frame. Otherwise the frame data will be copied. If this function returns an error, the input frame is not touched.
# Returns
0 on success, a negative [`AVERROR`](@ref) on error.
"""
function av_buffersrc_add_frame(ctx, frame)
    ccall((:av_buffersrc_add_frame, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}), ctx, frame)
end

"""
    av_buffersrc_add_frame_flags(buffer_src, frame, flags::Integer)

Add a frame to the buffer source.

By default, if the frame is reference-counted, this function will take ownership of the reference(s) and reset the frame. This can be controlled using the flags.

If this function returns an error, the input frame is not touched.

# Arguments
* `buffer_src`: pointer to a buffer source context
* `frame`: a frame, or NULL to mark EOF
* `flags`: a combination of AV\\_BUFFERSRC\\_FLAG\\_*
# Returns
>= 0 in case of success, a negative [`AVERROR`](@ref) code in case of failure
"""
function av_buffersrc_add_frame_flags(buffer_src, frame, flags::Integer)
    ccall((:av_buffersrc_add_frame_flags, libavfilter), Cint, (Ptr{AVFilterContext}, Ptr{AVFrame}, Cint), buffer_src, frame, flags)
end

"""
    av_buffersrc_close(ctx, pts::Int64, flags::Integer)

Close the buffer source after EOF.

This is similar to passing NULL to [`av_buffersrc_add_frame_flags`](@ref)() except it takes the timestamp of the EOF, i.e. the timestamp of the end of the last frame.
"""
function av_buffersrc_close(ctx, pts::Int64, flags::Integer)
    ccall((:av_buffersrc_close, libavfilter), Cint, (Ptr{AVFilterContext}, Int64, Cuint), ctx, pts, flags)
end

"""
    av_get_packet(s, pkt, size::Integer)

Allocate and read the payload of a packet and initialize its fields with default values.

# Arguments
* `s`: associated IO context
* `pkt`: packet
* `size`: desired payload size
# Returns
>0 (read size) if OK, AVERROR\\_xxx otherwise
"""
function av_get_packet(s, pkt, size::Integer)
    ccall((:av_get_packet, libavformat), Cint, (Ptr{AVIOContext}, Ptr{AVPacket}, Cint), s, pkt, size)
end

"""
    av_append_packet(s, pkt, size::Integer)

Read data and append it to the current content of the [`AVPacket`](@ref). If pkt->size is 0 this is identical to [`av_get_packet`](@ref). Note that this uses [`av_grow_packet`](@ref) and thus involves a realloc which is inefficient. Thus this function should only be used when there is no reasonable way to know (an upper bound of) the final size.

# Arguments
* `s`: associated IO context
* `pkt`: packet
* `size`: amount of data to read
# Returns
>0 (read size) if OK, AVERROR\\_xxx otherwise, previous data will not be lost even if an error occurs.
"""
function av_append_packet(s, pkt, size::Integer)
    ccall((:av_append_packet, libavformat), Cint, (Ptr{AVIOContext}, Ptr{AVPacket}, Cint), s, pkt, size)
end

"""
    AVProbeData

This structure contains the data a format has to probe a file.
"""
struct AVProbeData
    filename::Cstring
    buf::Ptr{Cuchar}
    buf_size::Cint
    mime_type::Cstring
end

"""
    AVStreamParseType

@}
"""
const AVStreamParseType = UInt32
const AVSTREAM_PARSE_NONE = 0 % UInt32
const AVSTREAM_PARSE_FULL = 1 % UInt32
const AVSTREAM_PARSE_HEADERS = 2 % UInt32
const AVSTREAM_PARSE_TIMESTAMPS = 3 % UInt32
const AVSTREAM_PARSE_FULL_ONCE = 4 % UInt32
const AVSTREAM_PARSE_FULL_RAW = 5 % UInt32

struct AVIndexEntry
    data::NTuple{24, UInt8}
end

function Base.getproperty(x::Ptr{AVIndexEntry}, f::Symbol)
    f === :pos && return Ptr{Int64}(x + 0)
    f === :timestamp && return Ptr{Int64}(x + 8)
    f === :flags && return (Ptr{Cint}(x + 16), 0, 2)
    f === :size && return (Ptr{Cint}(x + 16), 2, 30)
    f === :min_distance && return Ptr{Cint}(x + 20)
    return getfield(x, f)
end

function Base.getproperty(x::AVIndexEntry, f::Symbol)
    r = Ref{AVIndexEntry}(x)
    ptr = Base.unsafe_convert(Ptr{AVIndexEntry}, r)
    fptr = getproperty(ptr, f)
    begin
        if fptr isa Ptr
            return GC.@preserve(r, unsafe_load(fptr))
        else
            (baseptr, offset, width) = fptr
            ty = eltype(baseptr)
            baseptr32 = convert(Ptr{UInt32}, baseptr)
            u64 = GC.@preserve(r, unsafe_load(baseptr32))
            if offset + width > 32
                u64 |= GC.@preserve(r, unsafe_load(baseptr32 + 4)) << 32
            end
            u64 = u64 >> offset & (1 << width - 1)
            return u64 % ty
        end
    end
end

function Base.setproperty!(x::Ptr{AVIndexEntry}, f::Symbol, v)
    fptr = getproperty(x, f)
    if fptr isa Ptr
        unsafe_store!(getproperty(x, f), v)
    else
        (baseptr, offset, width) = fptr
        baseptr32 = convert(Ptr{UInt32}, baseptr)
        u64 = unsafe_load(baseptr32)
        straddle = offset + width > 32
        if straddle
            u64 |= unsafe_load(baseptr32 + 4) << 32
        end
        mask = 1 << width - 1
        u64 &= ~(mask << offset)
        u64 |= (unsigned(v) & mask) << offset
        unsafe_store!(baseptr32, u64 & typemax(UInt32))
        if straddle
            unsafe_store!(baseptr32 + 4, u64 >> 32)
        end
    end
end

function Base.propertynames(x::AVIndexEntry, private::Bool = false)
    (:pos, :timestamp, :flags, :size, :min_distance, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    av_disposition_from_string(disp)

# Returns
The AV\\_DISPOSITION\\_* flag corresponding to disp or a negative error code if disp does not correspond to a known stream disposition.
"""
function av_disposition_from_string(disp)
    ccall((:av_disposition_from_string, libavformat), Cint, (Cstring,), disp)
end

"""
    av_disposition_to_string(disposition::Integer)

# Arguments
* `disposition`: a combination of AV\\_DISPOSITION\\_* values
# Returns
The string description corresponding to the lowest set bit in disposition. NULL when the lowest set bit does not correspond to a known disposition or when disposition is 0.
"""
function av_disposition_to_string(disposition::Integer)
    ccall((:av_disposition_to_string, libavformat), Cstring, (Cint,), disposition)
end

"""
    __JL_Ctag_94

An nb_tiles sized array of offsets in pixels from the topleft edge of the canvas, indicating where each stream should be placed. It must be allocated with the [`av_malloc`](@ref)() family of functions.

- demuxing: set by libavformat, must not be modified by the caller. - muxing: set by the caller before [`avformat_write_header`](@ref)().

Freed by libavformat in [`avformat_free_context`](@ref)().
"""
struct __JL_Ctag_94
    idx::Cuint
    horizontal::Cint
    vertical::Cint
end
function Base.getproperty(x::Ptr{__JL_Ctag_94}, f::Symbol)
    f === :idx && return Ptr{Cuint}(x + 0)
    f === :horizontal && return Ptr{Cint}(x + 4)
    f === :vertical && return Ptr{Cint}(x + 8)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_94, f::Symbol)
    r = Ref{__JL_Ctag_94}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_94}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_94}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end


"""
    AVStreamGroupTileGrid

[`AVStreamGroupTileGrid`](@ref) holds information on how to combine several independent images on a single canvas for presentation.

The output should be a AVStreamGroupTileGrid.background "background" colored AVStreamGroupTileGrid.coded_width "coded\\_width" x AVStreamGroupTileGrid.coded_height "coded\\_height" canvas where a AVStreamGroupTileGrid.nb_tiles "nb\\_tiles" amount of tiles are placed in the order they appear in the AVStreamGroupTileGrid.offsets "offsets" array, at the exact offset described for them. In particular, if two or more tiles overlap, the image with higher index in the AVStreamGroupTileGrid.offsets "offsets" array takes priority. Note that a single image may be used multiple times, i.e. multiple entries in AVStreamGroupTileGrid.offsets "offsets" may have the same value of idx.

The following is an example of a simple grid with 3 rows and 4 columns:

+---+---+---+---+ | 0 | 1 | 2 | 3 | +---+---+---+---+ | 4 | 5 | 6 | 7 | +---+---+---+---+ | 8 | 9 |10 |11 | +---+---+---+---+

Assuming all tiles have a dimension of 512x512, the AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of the first AVStreamGroup.streams "stream" in the group is "0,0", the AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of the second AVStreamGroup.streams "stream" in the group is "512,0", the AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of the fifth AVStreamGroup.streams "stream" in the group is "0,512", the AVStreamGroupTileGrid.offsets "offset", of the topleft pixel of the sixth AVStreamGroup.streams "stream" in the group is "512,512", etc.

The following is an example of a canvas with overlapping tiles:

+-----------+ | %%%%% | |***%3%%@@| |**0%%%%2@| |***##1@@@| | ##### | +-----------+

Assuming a canvas with size 1024x1024 and all tiles with a dimension of 512x512, a possible AVStreamGroupTileGrid.offsets "offset" for the topleft pixel of the first AVStreamGroup.streams "stream" in the group would be 0x256, the AVStreamGroupTileGrid.offsets "offset" for the topleft pixel of the second AVStreamGroup.streams "stream" in the group would be 256x512, the AVStreamGroupTileGrid.offsets "offset" for the topleft pixel of the third AVStreamGroup.streams "stream" in the group would be 512x256, and the AVStreamGroupTileGrid.offsets "offset" for the topleft pixel of the fourth AVStreamGroup.streams "stream" in the group would be 256x0.

sizeof([`AVStreamGroupTileGrid`](@ref)) is not a part of the ABI and may only be allocated by [`avformat_stream_group_create`](@ref)().
"""
struct AVStreamGroupTileGrid
    data::NTuple{72, UInt8}
end

function Base.getproperty(x::Ptr{AVStreamGroupTileGrid}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :nb_tiles && return Ptr{Cuint}(x + 8)
    f === :coded_width && return Ptr{Cint}(x + 12)
    f === :coded_height && return Ptr{Cint}(x + 16)
    f === :offsets && return Ptr{Ptr{__JL_Ctag_94}}(x + 24)
    f === :background && return Ptr{NTuple{4, UInt8}}(x + 32)
    f === :horizontal_offset && return Ptr{Cint}(x + 36)
    f === :vertical_offset && return Ptr{Cint}(x + 40)
    f === :width && return Ptr{Cint}(x + 44)
    f === :height && return Ptr{Cint}(x + 48)
    f === :coded_side_data && return Ptr{Ptr{AVPacketSideData}}(x + 56)
    f === :nb_coded_side_data && return Ptr{Cint}(x + 64)
    return getfield(x, f)
end

function Base.getproperty(x::AVStreamGroupTileGrid, f::Symbol)
    r = Ref{AVStreamGroupTileGrid}(x)
    ptr = Base.unsafe_convert(Ptr{AVStreamGroupTileGrid}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVStreamGroupTileGrid}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVStreamGroupTileGrid, private::Bool = false)
    (:av_class, :nb_tiles, :coded_width, :coded_height, :offsets, :background, :horizontal_offset, :vertical_offset, :width, :height, :coded_side_data, :nb_coded_side_data, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVStreamGroupLCEVC

[`AVStreamGroupLCEVC`](@ref) is meant to define the relation between video streams and a data stream containing LCEVC enhancement layer NALUs.

No more than one stream of AVCodecParameters.codec_type "codec\\_type" AVMEDIA\\_TYPE\\_DATA shall be present, and it must be of AVCodecParameters.codec_id "codec\\_id" AV\\_CODEC\\_ID\\_LCEVC.
"""
struct AVStreamGroupLCEVC
    av_class::Ptr{AVClass}
    lcevc_index::Cuint
    width::Cint
    height::Cint
end

function av_stream_get_parser(s)
    ccall((:av_stream_get_parser, libavformat), Ptr{AVCodecParserContext}, (Ptr{AVStream},), s)
end

function av_stream_get_first_dts(st)
    ccall((:av_stream_get_first_dts, libavformat), Int64, (Ptr{AVStream},), st)
end

# typedef int ( * AVOpenCallback ) ( struct AVFormatContext * s , AVIOContext * * pb , const char * url , int flags , const AVIOInterruptCB * int_cb , AVDictionary * * options )
const AVOpenCallback = Ptr{Cvoid}

"""
    avformat_version()

Return the [`LIBAVFORMAT_VERSION_INT`](@ref) constant.
"""
function avformat_version()
    ccall((:avformat_version, libavformat), Cuint, ())
end

"""
    avformat_configuration()

Return the libavformat build-time configuration.
"""
function avformat_configuration()
    ccall((:avformat_configuration, libavformat), Cstring, ())
end

"""
    avformat_license()

Return the libavformat license.
"""
function avformat_license()
    ccall((:avformat_license, libavformat), Cstring, ())
end

"""
    avformat_network_init()

Do global initialization of network libraries. This is optional, and not recommended anymore.

This functions only exists to work around thread-safety issues with older GnuTLS or OpenSSL libraries. If libavformat is linked to newer versions of those libraries, or if you do not use them, calling this function is unnecessary. Otherwise, you need to call this function before any other threads using them are started.

This function will be deprecated once support for older GnuTLS and OpenSSL libraries is removed, and this function has no purpose anymore.
"""
function avformat_network_init()
    ccall((:avformat_network_init, libavformat), Cint, ())
end

"""
    avformat_network_deinit()

Undo the initialization done by [`avformat_network_init`](@ref). Call it only once for each time you called [`avformat_network_init`](@ref).
"""
function avformat_network_deinit()
    ccall((:avformat_network_deinit, libavformat), Cint, ())
end

"""
    av_muxer_iterate(opaque)

Iterate over all registered muxers.

# Arguments
* `opaque`: a pointer where libavformat will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered muxer or NULL when the iteration is finished
"""
function av_muxer_iterate(opaque)
    ccall((:av_muxer_iterate, libavformat), Ptr{AVOutputFormat}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    av_demuxer_iterate(opaque)

Iterate over all registered demuxers.

# Arguments
* `opaque`: a pointer where libavformat will store the iteration state. Must point to NULL to start the iteration.
# Returns
the next registered demuxer or NULL when the iteration is finished
"""
function av_demuxer_iterate(opaque)
    ccall((:av_demuxer_iterate, libavformat), Ptr{AVInputFormat}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    avformat_alloc_context()

Allocate an [`AVFormatContext`](@ref). [`avformat_free_context`](@ref)() can be used to free the context and everything allocated by the framework within it.
"""
function avformat_alloc_context()
    ccall((:avformat_alloc_context, libavformat), Ptr{AVFormatContext}, ())
end

"""
    avformat_free_context(s)

Free an [`AVFormatContext`](@ref) and all its streams.

# Arguments
* `s`: context to free
"""
function avformat_free_context(s)
    ccall((:avformat_free_context, libavformat), Cvoid, (Ptr{AVFormatContext},), s)
end

"""
    avformat_get_class()

Get the [`AVClass`](@ref) for [`AVFormatContext`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function avformat_get_class()
    ccall((:avformat_get_class, libavformat), Ptr{AVClass}, ())
end

"""
    av_stream_get_class()

Get the [`AVClass`](@ref) for [`AVStream`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function av_stream_get_class()
    ccall((:av_stream_get_class, libavformat), Ptr{AVClass}, ())
end

"""
    av_stream_group_get_class()

Get the [`AVClass`](@ref) for [`AVStreamGroup`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function av_stream_group_get_class()
    ccall((:av_stream_group_get_class, libavformat), Ptr{AVClass}, ())
end

"""
    avformat_stream_group_name(type::AVStreamGroupParamsType)

# Returns
a string identifying the stream group type, or NULL if unknown
"""
function avformat_stream_group_name(type::AVStreamGroupParamsType)
    ccall((:avformat_stream_group_name, libavformat), Cstring, (AVStreamGroupParamsType,), type)
end

"""
    avformat_stream_group_create(s, type::AVStreamGroupParamsType, options)

Add a new empty stream group to a media file.

When demuxing, it may be called by the demuxer in read\\_header(). If the flag [`AVFMTCTX_NOHEADER`](@ref) is set in s.ctx\\_flags, then it may also be called in read\\_packet().

When muxing, may be called by the user before [`avformat_write_header`](@ref)().

User is required to call [`avformat_free_context`](@ref)() to clean up the allocation by [`avformat_stream_group_create`](@ref)().

New streams can be added to the group with [`avformat_stream_group_add_stream`](@ref)().

# Arguments
* `s`: media file handle
# Returns
newly created group or NULL on error.
# See also
[`avformat_new_stream`](@ref), [`avformat_stream_group_add_stream`](@ref).
"""
function avformat_stream_group_create(s, type::AVStreamGroupParamsType, options)
    ccall((:avformat_stream_group_create, libavformat), Ptr{AVStreamGroup}, (Ptr{AVFormatContext}, AVStreamGroupParamsType, Ptr{Ptr{AVDictionary}}), s, type, options)
end

"""
    avformat_new_stream(s, c)

Add a new stream to a media file.

When demuxing, it is called by the demuxer in read\\_header(). If the flag [`AVFMTCTX_NOHEADER`](@ref) is set in s.ctx\\_flags, then it may also be called in read\\_packet().

When muxing, should be called by the user before [`avformat_write_header`](@ref)().

User is required to call [`avformat_free_context`](@ref)() to clean up the allocation by [`avformat_new_stream`](@ref)().

# Arguments
* `s`: media file handle
* `c`: unused, does nothing
# Returns
newly created stream or NULL on error.
"""
function avformat_new_stream(s, c)
    ccall((:avformat_new_stream, libavformat), Ptr{AVStream}, (Ptr{AVFormatContext}, Ptr{AVCodec}), s, c)
end

"""
    avformat_stream_group_add_stream(stg, st)

Add an already allocated stream to a stream group.

When demuxing, it may be called by the demuxer in read\\_header(). If the flag [`AVFMTCTX_NOHEADER`](@ref) is set in s.ctx\\_flags, then it may also be called in read\\_packet().

When muxing, may be called by the user before [`avformat_write_header`](@ref)() after having allocated a new group with [`avformat_stream_group_create`](@ref)() and stream with [`avformat_new_stream`](@ref)().

User is required to call [`avformat_free_context`](@ref)() to clean up the allocation by [`avformat_stream_group_add_stream`](@ref)().

\\retval0 success

\\retvalAVERROR(EEXIST) the stream was already in the group

\\retval"another negative error code" legitimate errors

# Arguments
* `stg`: stream group belonging to a media file.
* `st`: stream in the media file to add to the group.
# See also
[`avformat_new_stream`](@ref), [`avformat_stream_group_create`](@ref).
"""
function avformat_stream_group_add_stream(stg, st)
    ccall((:avformat_stream_group_add_stream, libavformat), Cint, (Ptr{AVStreamGroup}, Ptr{AVStream}), stg, st)
end

function av_new_program(s, id::Integer)
    ccall((:av_new_program, libavformat), Ptr{AVProgram}, (Ptr{AVFormatContext}, Cint), s, id)
end

"""
    avformat_alloc_output_context2(ctx, oformat, format_name, filename)

Allocate an [`AVFormatContext`](@ref) for an output format. [`avformat_free_context`](@ref)() can be used to free the context and everything allocated by the framework within it.

# Arguments
* `ctx`: pointee is set to the created format context, or to NULL in case of failure
* `oformat`: format to use for allocating the context, if NULL format\\_name and filename are used instead
* `format_name`: the name of output format to use for allocating the context, if NULL filename is used instead
* `filename`: the name of the filename to use for allocating the context, may be NULL
# Returns
>= 0 in case of success, a negative [`AVERROR`](@ref) code in case of failure
"""
function avformat_alloc_output_context2(ctx, oformat, format_name, filename)
    ccall((:avformat_alloc_output_context2, libavformat), Cint, (Ptr{Ptr{AVFormatContext}}, Ptr{AVOutputFormat}, Cstring, Cstring), ctx, oformat, format_name, filename)
end

"""
    av_find_input_format(short_name)

Find [`AVInputFormat`](@ref) based on the short name of the input format.
"""
function av_find_input_format(short_name)
    ccall((:av_find_input_format, libavformat), Ptr{AVInputFormat}, (Cstring,), short_name)
end

"""
    av_probe_input_format(pd, is_opened::Integer)

Guess the file format.

# Arguments
* `pd`: data to be probed
* `is_opened`: Whether the file is already opened; determines whether demuxers with or without [`AVFMT_NOFILE`](@ref) are probed.
"""
function av_probe_input_format(pd, is_opened::Integer)
    ccall((:av_probe_input_format, libavformat), Ptr{AVInputFormat}, (Ptr{AVProbeData}, Cint), pd, is_opened)
end

"""
    av_probe_input_format2(pd, is_opened::Integer, score_max)

Guess the file format.

# Arguments
* `pd`: data to be probed
* `is_opened`: Whether the file is already opened; determines whether demuxers with or without [`AVFMT_NOFILE`](@ref) are probed.
* `score_max`: A probe score larger that this is required to accept a detection, the variable is set to the actual detection score afterwards. If the score is <= [`AVPROBE_SCORE_MAX`](@ref) / 4 it is recommended to retry with a larger probe buffer.
"""
function av_probe_input_format2(pd, is_opened::Integer, score_max)
    ccall((:av_probe_input_format2, libavformat), Ptr{AVInputFormat}, (Ptr{AVProbeData}, Cint, Ptr{Cint}), pd, is_opened, score_max)
end

"""
    av_probe_input_format3(pd, is_opened::Integer, score_ret)

Guess the file format.

# Arguments
* `is_opened`: Whether the file is already opened; determines whether demuxers with or without [`AVFMT_NOFILE`](@ref) are probed.
* `score_ret`: The score of the best detection.
"""
function av_probe_input_format3(pd, is_opened::Integer, score_ret)
    ccall((:av_probe_input_format3, libavformat), Ptr{AVInputFormat}, (Ptr{AVProbeData}, Cint, Ptr{Cint}), pd, is_opened, score_ret)
end

"""
    av_probe_input_buffer2(pb, fmt, url, logctx, offset::Integer, max_probe_size::Integer)

Probe a bytestream to determine the input format. Each time a probe returns with a score that is too low, the probe buffer size is increased and another attempt is made. When the maximum probe size is reached, the input format with the highest score is returned.

# Arguments
* `pb`: the bytestream to probe
* `fmt`: the input format is put here
* `url`: the url of the stream
* `logctx`: the log context
* `offset`: the offset within the bytestream to probe from
* `max_probe_size`: the maximum probe buffer size (zero for default)
# Returns
the score in case of success, a negative value corresponding to an the maximal score is [`AVPROBE_SCORE_MAX`](@ref) [`AVERROR`](@ref) code otherwise
"""
function av_probe_input_buffer2(pb, fmt, url, logctx, offset::Integer, max_probe_size::Integer)
    ccall((:av_probe_input_buffer2, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Ptr{AVInputFormat}}, Cstring, Ptr{Cvoid}, Cuint, Cuint), pb, fmt, url, logctx, offset, max_probe_size)
end

"""
    av_probe_input_buffer(pb, fmt, url, logctx, offset::Integer, max_probe_size::Integer)

Like [`av_probe_input_buffer2`](@ref)() but returns 0 on success
"""
function av_probe_input_buffer(pb, fmt, url, logctx, offset::Integer, max_probe_size::Integer)
    ccall((:av_probe_input_buffer, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Ptr{AVInputFormat}}, Cstring, Ptr{Cvoid}, Cuint, Cuint), pb, fmt, url, logctx, offset, max_probe_size)
end

"""
    avformat_open_input(ps, url, fmt, options)

Open an input stream and read the header. The codecs are not opened. The stream must be closed with [`avformat_close_input`](@ref)().

!!! note

    If you want to use custom IO, preallocate the format context and set its pb field.

# Arguments
* `ps`: Pointer to user-supplied [`AVFormatContext`](@ref) (allocated by [`avformat_alloc_context`](@ref)). May be a pointer to NULL, in which case an [`AVFormatContext`](@ref) is allocated by this function and written into ps. Note that a user-supplied [`AVFormatContext`](@ref) will be freed on failure and its pointer set to NULL.
* `url`: URL of the stream to open.
* `fmt`: If non-NULL, this parameter forces a specific input format. Otherwise the format is autodetected.
* `options`: A dictionary filled with [`AVFormatContext`](@ref) and demuxer-private options. On return this parameter will be destroyed and replaced with a dict containing options that were not found. May be NULL.
# Returns
0 on success; on failure: frees ps, sets its pointer to NULL, and returns a negative [`AVERROR`](@ref).
"""
function avformat_open_input(ps, url, fmt, options)
    ccall((:avformat_open_input, libavformat), Cint, (Ptr{Ptr{AVFormatContext}}, Cstring, Ptr{AVInputFormat}, Ptr{Ptr{AVDictionary}}), ps, url, fmt, options)
end

"""
    avformat_find_stream_info(ic, options)

Read packets of a media file to get stream information. This is useful for file formats with no headers such as MPEG. This function also computes the real framerate in case of MPEG-2 repeat frame mode. The logical file position is not changed by this function; examined packets may be buffered for later processing.

!!! note

    this function isn't guaranteed to open all the codecs, so options being non-empty at return is a perfectly normal behavior.

\\todo Let the user decide somehow what information is needed so that we do not waste time getting stuff the user does not need.

# Arguments
* `ic`: media file handle
* `options`: If non-NULL, an ic.nb\\_streams long array of pointers to dictionaries, where i-th member contains options for codec corresponding to i-th stream. On return each dictionary will be filled with options that were not found.
# Returns
>=0 if OK, AVERROR\\_xxx on error
"""
function avformat_find_stream_info(ic, options)
    ccall((:avformat_find_stream_info, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{Ptr{AVDictionary}}), ic, options)
end

"""
    av_find_program_from_stream(ic, last, s::Integer)

Find the programs which belong to a given stream.

# Arguments
* `ic`: media file handle
* `last`: the last found program, the search will start after this program, or from the beginning if it is NULL
* `s`: stream index
# Returns
the next program which belongs to s, NULL if no program is found or the last program is not among the programs of ic.
"""
function av_find_program_from_stream(ic, last, s::Integer)
    ccall((:av_find_program_from_stream, libavformat), Ptr{AVProgram}, (Ptr{AVFormatContext}, Ptr{AVProgram}, Cint), ic, last, s)
end

function av_program_add_stream_index(ac, progid::Integer, idx::Integer)
    ccall((:av_program_add_stream_index, libavformat), Cvoid, (Ptr{AVFormatContext}, Cint, Cuint), ac, progid, idx)
end

"""
    av_find_best_stream(ic, type::AVMediaType, wanted_stream_nb::Integer, related_stream::Integer, decoder_ret, flags::Integer)

Find the "best" stream in the file. The best stream is determined according to various heuristics as the most likely to be what the user expects. If the decoder parameter is non-NULL, [`av_find_best_stream`](@ref) will find the default decoder for the stream's codec; streams for which no decoder can be found are ignored.

!!! note

    If [`av_find_best_stream`](@ref) returns successfully and decoder\\_ret is not NULL, then *decoder\\_ret is guaranteed to be set to a valid [`AVCodec`](@ref).

# Arguments
* `ic`: media file handle
* `type`: stream type: video, audio, subtitles, etc.
* `wanted_stream_nb`: user-requested stream number, or -1 for automatic selection
* `related_stream`: try to find a stream related (eg. in the same program) to this one, or -1 if none
* `decoder_ret`: if non-NULL, returns the decoder for the selected stream
* `flags`: flags; none are currently defined
# Returns
the non-negative stream number in case of success, [`AVERROR_STREAM_NOT_FOUND`](@ref) if no stream with the requested type could be found, [`AVERROR_DECODER_NOT_FOUND`](@ref) if streams were found but no decoder
"""
function av_find_best_stream(ic, type::AVMediaType, wanted_stream_nb::Integer, related_stream::Integer, decoder_ret, flags::Integer)
    ccall((:av_find_best_stream, libavformat), Cint, (Ptr{AVFormatContext}, AVMediaType, Cint, Cint, Ptr{Ptr{AVCodec}}, Cint), ic, type, wanted_stream_nb, related_stream, decoder_ret, flags)
end

"""
    av_read_frame(s, pkt)

Return the next frame of a stream. This function returns what is stored in the file, and does not validate that what is there are valid frames for the decoder. It will split what is stored in the file into frames and return one for each call. It will not omit invalid data between valid frames so as to give the decoder the maximum information possible for decoding.

On success, the returned packet is reference-counted (pkt->buf is set) and valid indefinitely. The packet must be freed with [`av_packet_unref`](@ref)() when it is no longer needed. For video, the packet contains exactly one frame. For audio, it contains an integer number of frames if each frame has a known fixed size (e.g. PCM or ADPCM data). If the audio frames have a variable size (e.g. MPEG audio), then it contains one frame.

pkt->pts, pkt->dts and pkt->duration are always set to correct values in [`AVStream`](@ref).time\\_base units (and guessed if the format cannot provide them). pkt->pts can be [`AV_NOPTS_VALUE`](@ref) if the video format has B-frames, so it is better to rely on pkt->dts if you do not decompress the payload.

!!! note

    pkt will be initialized, so it may be uninitialized, but it must not contain data that needs to be freed.

# Returns
0 if OK, < 0 on error or end of file. On error, pkt will be blank (as if it came from [`av_packet_alloc`](@ref)()).
"""
function av_read_frame(s, pkt)
    ccall((:av_read_frame, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{AVPacket}), s, pkt)
end

"""
    av_seek_frame(s, stream_index::Integer, timestamp::Int64, flags::Integer)

Seek to the keyframe at timestamp. 'timestamp' in 'stream\\_index'.

# Arguments
* `s`: media file handle
* `stream_index`: If stream\\_index is (-1), a default stream is selected, and timestamp is automatically converted from [`AV_TIME_BASE`](@ref) units to the stream specific time\\_base.
* `timestamp`: Timestamp in [`AVStream`](@ref).time\\_base units or, if no stream is specified, in [`AV_TIME_BASE`](@ref) units.
* `flags`: flags which select direction and seeking mode
# Returns
>= 0 on success
"""
function av_seek_frame(s, stream_index::Integer, timestamp::Int64, flags::Integer)
    ccall((:av_seek_frame, libavformat), Cint, (Ptr{AVFormatContext}, Cint, Int64, Cint), s, stream_index, timestamp, flags)
end

"""
    avformat_seek_file(s, stream_index::Integer, min_ts::Int64, ts::Int64, max_ts::Int64, flags::Integer)

Seek to timestamp ts. Seeking will be done so that the point from which all active streams can be presented successfully will be closest to ts and within min/max\\_ts. Active streams are all streams that have [`AVStream`](@ref).discard < AVDISCARD\\_ALL.

If flags contain [`AVSEEK_FLAG_BYTE`](@ref), then all timestamps are in bytes and are the file position (this may not be supported by all demuxers). If flags contain [`AVSEEK_FLAG_FRAME`](@ref), then all timestamps are in frames in the stream with stream\\_index (this may not be supported by all demuxers). Otherwise all timestamps are in units of the stream selected by stream\\_index or if stream\\_index is -1, in [`AV_TIME_BASE`](@ref) units. If flags contain [`AVSEEK_FLAG_ANY`](@ref), then non-keyframes are treated as keyframes (this may not be supported by all demuxers). If flags contain [`AVSEEK_FLAG_BACKWARD`](@ref), it is ignored.

!!! note

    This is part of the new seek API which is still under construction.

# Arguments
* `s`: media file handle
* `stream_index`: index of the stream which is used as time base reference
* `min_ts`: smallest acceptable timestamp
* `ts`: target timestamp
* `max_ts`: largest acceptable timestamp
* `flags`: flags
# Returns
>=0 on success, error code otherwise
"""
function avformat_seek_file(s, stream_index::Integer, min_ts::Int64, ts::Int64, max_ts::Int64, flags::Integer)
    ccall((:avformat_seek_file, libavformat), Cint, (Ptr{AVFormatContext}, Cint, Int64, Int64, Int64, Cint), s, stream_index, min_ts, ts, max_ts, flags)
end

"""
    avformat_flush(s)

Discard all internally buffered data. This can be useful when dealing with discontinuities in the byte stream. Generally works only with formats that can resync. This includes headerless formats like MPEG-TS/TS but should also work with NUT, Ogg and in a limited way AVI for example.

The set of streams, the detected duration, stream parameters and codecs do not change when calling this function. If you want a complete reset, it's better to open a new [`AVFormatContext`](@ref).

This does not flush the [`AVIOContext`](@ref) (s->pb). If necessary, call [`avio_flush`](@ref)(s->pb) before calling this function.

# Arguments
* `s`: media file handle
# Returns
>=0 on success, error code otherwise
"""
function avformat_flush(s)
    ccall((:avformat_flush, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

"""
    av_read_play(s)

Start playing a network-based stream (e.g. RTSP stream) at the current position.
"""
function av_read_play(s)
    ccall((:av_read_play, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

"""
    av_read_pause(s)

Pause a network-based stream (e.g. RTSP stream).

Use [`av_read_play`](@ref)() to resume it.
"""
function av_read_pause(s)
    ccall((:av_read_pause, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

"""
    avformat_close_input(s)

Close an opened input [`AVFormatContext`](@ref). Free it and all its contents and set *s to NULL.
"""
function avformat_close_input(s)
    ccall((:avformat_close_input, libavformat), Cvoid, (Ptr{Ptr{AVFormatContext}},), s)
end

"""
    avformat_write_header(s, options)

Allocate the stream private data and write the stream header to an output media file.

\\retvalAVSTREAM_INIT_IN_WRITE_HEADER On success, if the codec had not already been fully initialized in [`avformat_init_output`](@ref)().

\\retvalAVSTREAM_INIT_IN_INIT_OUTPUT On success, if the codec had already been fully initialized in [`avformat_init_output`](@ref)().

\\retvalAVERROR A negative [`AVERROR`](@ref) on failure.

# Arguments
* `s`: Media file handle, must be allocated with [`avformat_alloc_context`](@ref)(). Its AVFormatContext.oformat "oformat" field must be set to the desired output format; Its AVFormatContext.pb "pb" field must be set to an already opened ::[`AVIOContext`](@ref).
* `options`: An ::[`AVDictionary`](@ref) filled with [`AVFormatContext`](@ref) and muxer-private options. On return this parameter will be destroyed and replaced with a dict containing options that were not found. May be NULL.
# See also
[`av_opt_find`](@ref), [`av_dict_set`](@ref), [`avio_open`](@ref), av\\_oformat\\_next, [`avformat_init_output`](@ref).
"""
function avformat_write_header(s, options)
    ccall((:avformat_write_header, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{Ptr{AVDictionary}}), s, options)
end

"""
    avformat_init_output(s, options)

Allocate the stream private data and initialize the codec, but do not write the header. May optionally be used before [`avformat_write_header`](@ref)() to initialize stream parameters before actually writing the header. If using this function, do not pass the same options to [`avformat_write_header`](@ref)().

\\retvalAVSTREAM_INIT_IN_WRITE_HEADER On success, if the codec requires [`avformat_write_header`](@ref) to fully initialize.

\\retvalAVSTREAM_INIT_IN_INIT_OUTPUT On success, if the codec has been fully initialized.

\\retvalAVERROR Anegative [`AVERROR`](@ref) on failure.

# Arguments
* `s`: Media file handle, must be allocated with [`avformat_alloc_context`](@ref)(). Its AVFormatContext.oformat "oformat" field must be set to the desired output format; Its AVFormatContext.pb "pb" field must be set to an already opened ::[`AVIOContext`](@ref).
* `options`: An ::[`AVDictionary`](@ref) filled with [`AVFormatContext`](@ref) and muxer-private options. On return this parameter will be destroyed and replaced with a dict containing options that were not found. May be NULL.
# See also
[`av_opt_find`](@ref), [`av_dict_set`](@ref), [`avio_open`](@ref), av\\_oformat\\_next, [`avformat_write_header`](@ref).
"""
function avformat_init_output(s, options)
    ccall((:avformat_init_output, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{Ptr{AVDictionary}}), s, options)
end

"""
    av_write_frame(s, pkt)

Write a packet to an output media file.

This function passes the packet directly to the muxer, without any buffering or reordering. The caller is responsible for correctly interleaving the packets if the format requires it. Callers that want libavformat to handle the interleaving should call [`av_interleaved_write_frame`](@ref)() instead of this function.

# Arguments
* `s`: media file handle
* `pkt`: The packet containing the data to be written. Note that unlike [`av_interleaved_write_frame`](@ref)(), this function does not take ownership of the packet passed to it (though some muxers may make an internal reference to the input packet). <br> This parameter can be NULL (at any time, not just at the end), in order to immediately flush data buffered within the muxer, for muxers that buffer up data internally before writing it to the output. <br> Packet's AVPacket.stream_index "stream\\_index" field must be set to the index of the corresponding stream in AVFormatContext.streams "s->streams". <br> The timestamps (AVPacket.pts "pts", AVPacket.dts "dts") must be set to correct values in the stream's timebase (unless the output format is flagged with the [`AVFMT_NOTIMESTAMPS`](@ref) flag, then they can be set to [`AV_NOPTS_VALUE`](@ref)). The dts for subsequent packets passed to this function must be strictly increasing when compared in their respective timebases (unless the output format is flagged with the [`AVFMT_TS_NONSTRICT`](@ref), then they merely have to be nondecreasing). AVPacket.duration "duration") should also be set if known.
# Returns
< 0 on error, = 0 if OK, 1 if flushed and there is no more data to flush
# See also
[`av_interleaved_write_frame`](@ref)()
"""
function av_write_frame(s, pkt)
    ccall((:av_write_frame, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{AVPacket}), s, pkt)
end

"""
    av_interleaved_write_frame(s, pkt)

Write a packet to an output media file ensuring correct interleaving.

This function will buffer the packets internally as needed to make sure the packets in the output file are properly interleaved, usually ordered by increasing dts. Callers doing their own interleaving should call [`av_write_frame`](@ref)() instead of this function.

Using this function instead of [`av_write_frame`](@ref)() can give muxers advance knowledge of future packets, improving e.g. the behaviour of the mp4 muxer for VFR content in fragmenting mode.

# Arguments
* `s`: media file handle
* `pkt`: The packet containing the data to be written. <br> If the packet is reference-counted, this function will take ownership of this reference and unreference it later when it sees fit. If the packet is not reference-counted, libavformat will make a copy. The returned packet will be blank (as if returned from [`av_packet_alloc`](@ref)()), even on error. <br> This parameter can be NULL (at any time, not just at the end), to flush the interleaving queues. <br> Packet's AVPacket.stream_index "stream\\_index" field must be set to the index of the corresponding stream in AVFormatContext.streams "s->streams". <br> The timestamps (AVPacket.pts "pts", AVPacket.dts "dts") must be set to correct values in the stream's timebase (unless the output format is flagged with the [`AVFMT_NOTIMESTAMPS`](@ref) flag, then they can be set to [`AV_NOPTS_VALUE`](@ref)). The dts for subsequent packets in one stream must be strictly increasing (unless the output format is flagged with the [`AVFMT_TS_NONSTRICT`](@ref), then they merely have to be nondecreasing). AVPacket.duration "duration" should also be set if known.
# Returns
0 on success, a negative [`AVERROR`](@ref) on error.
# See also
[`av_write_frame`](@ref)(), [`AVFormatContext`](@ref).max\\_interleave\\_delta
"""
function av_interleaved_write_frame(s, pkt)
    ccall((:av_interleaved_write_frame, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{AVPacket}), s, pkt)
end

"""
    av_write_uncoded_frame(s, stream_index::Integer, frame)

Write an uncoded frame to an output media file.

The frame must be correctly interleaved according to the container specification; if not, [`av_interleaved_write_uncoded_frame`](@ref)() must be used.

See [`av_interleaved_write_uncoded_frame`](@ref)() for details.
"""
function av_write_uncoded_frame(s, stream_index::Integer, frame)
    ccall((:av_write_uncoded_frame, libavformat), Cint, (Ptr{AVFormatContext}, Cint, Ptr{AVFrame}), s, stream_index, frame)
end

"""
    av_interleaved_write_uncoded_frame(s, stream_index::Integer, frame)

Write an uncoded frame to an output media file.

If the muxer supports it, this function makes it possible to write an [`AVFrame`](@ref) structure directly, without encoding it into a packet. It is mostly useful for devices and similar special muxers that use raw video or PCM data and will not serialize it into a byte stream.

To test whether it is possible to use it with a given muxer and stream, use [`av_write_uncoded_frame_query`](@ref)().

The caller gives up ownership of the frame and must not access it afterwards.

# Returns
>=0 for success, a negative code on error
"""
function av_interleaved_write_uncoded_frame(s, stream_index::Integer, frame)
    ccall((:av_interleaved_write_uncoded_frame, libavformat), Cint, (Ptr{AVFormatContext}, Cint, Ptr{AVFrame}), s, stream_index, frame)
end

"""
    av_write_uncoded_frame_query(s, stream_index::Integer)

Test whether a muxer supports uncoded frame.

# Returns
>=0 if an uncoded frame can be written to that muxer and stream, <0 if not
"""
function av_write_uncoded_frame_query(s, stream_index::Integer)
    ccall((:av_write_uncoded_frame_query, libavformat), Cint, (Ptr{AVFormatContext}, Cint), s, stream_index)
end

"""
    av_write_trailer(s)

Write the stream trailer to an output media file and free the file private data.

May only be called after a successful call to [`avformat_write_header`](@ref).

# Arguments
* `s`: media file handle
# Returns
0 if OK, AVERROR\\_xxx on error
"""
function av_write_trailer(s)
    ccall((:av_write_trailer, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

"""
    av_guess_format(short_name, filename, mime_type)

Return the output format in the list of registered output formats which best matches the provided parameters, or return NULL if there is no match.

# Arguments
* `short_name`: if non-NULL checks if short\\_name matches with the names of the registered formats
* `filename`: if non-NULL checks if filename terminates with the extensions of the registered formats
* `mime_type`: if non-NULL checks if mime\\_type matches with the MIME type of the registered formats
"""
function av_guess_format(short_name, filename, mime_type)
    ccall((:av_guess_format, libavformat), Ptr{AVOutputFormat}, (Cstring, Cstring, Cstring), short_name, filename, mime_type)
end

"""
    av_guess_codec(fmt, short_name, filename, mime_type, type::AVMediaType)

Guess the codec ID based upon muxer and filename.
"""
function av_guess_codec(fmt, short_name, filename, mime_type, type::AVMediaType)
    ccall((:av_guess_codec, libavformat), AVCodecID, (Ptr{AVOutputFormat}, Cstring, Cstring, Cstring, AVMediaType), fmt, short_name, filename, mime_type, type)
end

"""
    av_get_output_timestamp(s, stream::Integer, dts, wall)

Get timing information for the data currently output. The exact meaning of "currently output" depends on the format. It is mostly relevant for devices that have an internal buffer and/or work in real time.

\\retval0 Success

\\retvalAVERROR(ENOSYS) The format does not support it

!!! note

    Some formats or devices may not allow to measure dts and wall atomically.

# Arguments
* `s`: media file handle
* `stream`: stream in the media file
* `dts`:\\[out\\] DTS of the last packet output for the stream, in stream time\\_base units
* `wall`:\\[out\\] absolute time when that packet whas output, in microsecond
"""
function av_get_output_timestamp(s, stream::Integer, dts, wall)
    ccall((:av_get_output_timestamp, libavformat), Cint, (Ptr{AVFormatContext}, Cint, Ptr{Int64}, Ptr{Int64}), s, stream, dts, wall)
end

"""
    av_hex_dump(f, buf, size::Integer)

Send a nice hexadecimal dump of a buffer to the specified file stream.

# Arguments
* `f`: The file stream pointer where the dump should be sent to.
* `buf`: buffer
* `size`: buffer size
# See also
[`av_hex_dump_log`](@ref), [`av_pkt_dump2`](@ref), [`av_pkt_dump_log2`](@ref)
"""
function av_hex_dump(f, buf, size::Integer)
    ccall((:av_hex_dump, libavformat), Cvoid, (Ptr{Libc.FILE}, Ptr{UInt8}, Cint), f, buf, size)
end

"""
    av_hex_dump_log(avcl, level::Integer, buf, size::Integer)

Send a nice hexadecimal dump of a buffer to the log.

# Arguments
* `avcl`: A pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct.
* `level`: The importance level of the message, lower values signifying higher importance.
* `buf`: buffer
* `size`: buffer size
# See also
[`av_hex_dump`](@ref), [`av_pkt_dump2`](@ref), [`av_pkt_dump_log2`](@ref)
"""
function av_hex_dump_log(avcl, level::Integer, buf, size::Integer)
    ccall((:av_hex_dump_log, libavformat), Cvoid, (Ptr{Cvoid}, Cint, Ptr{UInt8}, Cint), avcl, level, buf, size)
end

"""
    av_pkt_dump2(f, pkt, dump_payload::Integer, st)

Send a nice dump of a packet to the specified file stream.

# Arguments
* `f`: The file stream pointer where the dump should be sent to.
* `pkt`: packet to dump
* `dump_payload`: True if the payload must be displayed, too.
* `st`: [`AVStream`](@ref) that the packet belongs to
"""
function av_pkt_dump2(f, pkt, dump_payload::Integer, st)
    ccall((:av_pkt_dump2, libavformat), Cvoid, (Ptr{Libc.FILE}, Ptr{AVPacket}, Cint, Ptr{AVStream}), f, pkt, dump_payload, st)
end

"""
    av_pkt_dump_log2(avcl, level::Integer, pkt, dump_payload::Integer, st)

Send a nice dump of a packet to the log.

# Arguments
* `avcl`: A pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct.
* `level`: The importance level of the message, lower values signifying higher importance.
* `pkt`: packet to dump
* `dump_payload`: True if the payload must be displayed, too.
* `st`: [`AVStream`](@ref) that the packet belongs to
"""
function av_pkt_dump_log2(avcl, level::Integer, pkt, dump_payload::Integer, st)
    ccall((:av_pkt_dump_log2, libavformat), Cvoid, (Ptr{Cvoid}, Cint, Ptr{AVPacket}, Cint, Ptr{AVStream}), avcl, level, pkt, dump_payload, st)
end

"""
    av_codec_get_id(tags, tag::Integer)

Get the [`AVCodecID`](@ref) for the given codec tag tag. If no codec id is found returns AV\\_CODEC\\_ID\\_NONE.

# Arguments
* `tags`: list of supported codec\\_id-codec\\_tag pairs, as stored in [`AVInputFormat`](@ref).codec\\_tag and [`AVOutputFormat`](@ref).codec\\_tag
* `tag`: codec tag to match to a codec ID
"""
function av_codec_get_id(tags, tag::Integer)
    ccall((:av_codec_get_id, libavformat), AVCodecID, (Ptr{Ptr{AVCodecTag}}, Cuint), tags, tag)
end

"""
    av_codec_get_tag(tags, id::AVCodecID)

Get the codec tag for the given codec id id. If no codec tag is found returns 0.

# Arguments
* `tags`: list of supported codec\\_id-codec\\_tag pairs, as stored in [`AVInputFormat`](@ref).codec\\_tag and [`AVOutputFormat`](@ref).codec\\_tag
* `id`: codec ID to match to a codec tag
"""
function av_codec_get_tag(tags, id::AVCodecID)
    ccall((:av_codec_get_tag, libavformat), Cuint, (Ptr{Ptr{AVCodecTag}}, AVCodecID), tags, id)
end

"""
    av_codec_get_tag2(tags, id::AVCodecID, tag)

Get the codec tag for the given codec id.

# Arguments
* `tags`: list of supported codec\\_id - codec\\_tag pairs, as stored in [`AVInputFormat`](@ref).codec\\_tag and [`AVOutputFormat`](@ref).codec\\_tag
* `id`: codec id that should be searched for in the list
* `tag`: A pointer to the found tag
# Returns
0 if id was not found in tags, > 0 if it was found
"""
function av_codec_get_tag2(tags, id::AVCodecID, tag)
    ccall((:av_codec_get_tag2, libavformat), Cint, (Ptr{Ptr{AVCodecTag}}, AVCodecID, Ptr{Cuint}), tags, id, tag)
end

function av_find_default_stream_index(s)
    ccall((:av_find_default_stream_index, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

"""
    av_index_search_timestamp(st, timestamp::Int64, flags::Integer)

Get the index for a specific timestamp.

# Arguments
* `st`: stream that the timestamp belongs to
* `timestamp`: timestamp to retrieve the index for
* `flags`: if [`AVSEEK_FLAG_BACKWARD`](@ref) then the returned index will correspond to the timestamp which is <= the requested one, if backward is 0, then it will be >= if [`AVSEEK_FLAG_ANY`](@ref) seek to any frame, only keyframes otherwise
# Returns
< 0 if no such timestamp could be found
"""
function av_index_search_timestamp(st, timestamp::Int64, flags::Integer)
    ccall((:av_index_search_timestamp, libavformat), Cint, (Ptr{AVStream}, Int64, Cint), st, timestamp, flags)
end

"""
    avformat_index_get_entries_count(st)

Get the index entry count for the given [`AVStream`](@ref).

# Arguments
* `st`: stream
# Returns
the number of index entries in the stream
"""
function avformat_index_get_entries_count(st)
    ccall((:avformat_index_get_entries_count, libavformat), Cint, (Ptr{AVStream},), st)
end

"""
    avformat_index_get_entry(st, idx::Integer)

Get the [`AVIndexEntry`](@ref) corresponding to the given index.

!!! note

    The pointer returned by this function is only guaranteed to be valid until any function that takes the stream or the parent [`AVFormatContext`](@ref) as input argument is called.

# Arguments
* `st`: Stream containing the requested [`AVIndexEntry`](@ref).
* `idx`: The desired index.
# Returns
A pointer to the requested [`AVIndexEntry`](@ref) if it exists, NULL otherwise.
"""
function avformat_index_get_entry(st, idx::Integer)
    ccall((:avformat_index_get_entry, libavformat), Ptr{AVIndexEntry}, (Ptr{AVStream}, Cint), st, idx)
end

"""
    avformat_index_get_entry_from_timestamp(st, wanted_timestamp::Int64, flags::Integer)

Get the [`AVIndexEntry`](@ref) corresponding to the given timestamp.

!!! note

    The pointer returned by this function is only guaranteed to be valid until any function that takes the stream or the parent [`AVFormatContext`](@ref) as input argument is called.

# Arguments
* `st`: Stream containing the requested [`AVIndexEntry`](@ref).
* `wanted_timestamp`: Timestamp to retrieve the index entry for.
* `flags`: If [`AVSEEK_FLAG_BACKWARD`](@ref) then the returned entry will correspond to the timestamp which is <= the requested one, if backward is 0, then it will be >= if [`AVSEEK_FLAG_ANY`](@ref) seek to any frame, only keyframes otherwise.
# Returns
A pointer to the requested [`AVIndexEntry`](@ref) if it exists, NULL otherwise.
"""
function avformat_index_get_entry_from_timestamp(st, wanted_timestamp::Int64, flags::Integer)
    ccall((:avformat_index_get_entry_from_timestamp, libavformat), Ptr{AVIndexEntry}, (Ptr{AVStream}, Int64, Cint), st, wanted_timestamp, flags)
end

"""
    av_add_index_entry(st, pos::Int64, timestamp::Int64, size::Integer, distance::Integer, flags::Integer)

Add an index entry into a sorted list. Update the entry if the list already contains it.

# Arguments
* `timestamp`: timestamp in the time base of the given stream
"""
function av_add_index_entry(st, pos::Int64, timestamp::Int64, size::Integer, distance::Integer, flags::Integer)
    ccall((:av_add_index_entry, libavformat), Cint, (Ptr{AVStream}, Int64, Int64, Cint, Cint, Cint), st, pos, timestamp, size, distance, flags)
end

"""
    av_url_split(proto, proto_size::Integer, authorization, authorization_size::Integer, hostname, hostname_size::Integer, port_ptr, path, path_size::Integer, url)

Split a URL string into components.

The pointers to buffers for storing individual components may be null, in order to ignore that component. Buffers for components not found are set to empty strings. If the port is not found, it is set to a negative value.

# Arguments
* `proto`: the buffer for the protocol
* `proto_size`: the size of the proto buffer
* `authorization`: the buffer for the authorization
* `authorization_size`: the size of the authorization buffer
* `hostname`: the buffer for the host name
* `hostname_size`: the size of the hostname buffer
* `port_ptr`: a pointer to store the port number in
* `path`: the buffer for the path
* `path_size`: the size of the path buffer
* `url`: the URL to split
"""
function av_url_split(proto, proto_size::Integer, authorization, authorization_size::Integer, hostname, hostname_size::Integer, port_ptr, path, path_size::Integer, url)
    ccall((:av_url_split, libavformat), Cvoid, (Cstring, Cint, Cstring, Cint, Cstring, Cint, Ptr{Cint}, Cstring, Cint, Cstring), proto, proto_size, authorization, authorization_size, hostname, hostname_size, port_ptr, path, path_size, url)
end

"""
    av_dump_format(ic, index::Integer, url, is_output::Integer)

Print detailed information about the input or output format, such as duration, bitrate, streams, container, programs, metadata, side data, codec and time base.

# Arguments
* `ic`: the context to analyze
* `index`: index of the stream to dump information about
* `url`: the URL to print, such as source or destination file
* `is_output`: Select whether the specified context is an input(0) or output(1)
"""
function av_dump_format(ic, index::Integer, url, is_output::Integer)
    ccall((:av_dump_format, libavformat), Cvoid, (Ptr{AVFormatContext}, Cint, Cstring, Cint), ic, index, url, is_output)
end

"""
    av_get_frame_filename2(buf, buf_size::Integer, path, number::Integer, flags::Integer)

Return in 'buf' the path with 'd' replaced by a number.

Also handles the '0nd' format where 'n' is the total number of digits and '%%'.

# Arguments
* `buf`: destination buffer
* `buf_size`: destination buffer size
* `path`: numbered sequence string
* `number`: frame number
* `flags`: AV\\_FRAME\\_FILENAME\\_FLAGS\\_*
# Returns
0 if OK, -1 on format error
"""
function av_get_frame_filename2(buf, buf_size::Integer, path, number::Integer, flags::Integer)
    ccall((:av_get_frame_filename2, libavformat), Cint, (Cstring, Cint, Cstring, Cint, Cint), buf, buf_size, path, number, flags)
end

function av_get_frame_filename(buf, buf_size::Integer, path, number::Integer)
    ccall((:av_get_frame_filename, libavformat), Cint, (Cstring, Cint, Cstring, Cint), buf, buf_size, path, number)
end

"""
    av_filename_number_test(filename)

Check whether filename actually is a numbered sequence generator.

# Arguments
* `filename`: possible numbered sequence string
# Returns
1 if a valid numbered sequence string, 0 otherwise
"""
function av_filename_number_test(filename)
    ccall((:av_filename_number_test, libavformat), Cint, (Cstring,), filename)
end

"""
    av_sdp_create(ac, n_files::Integer, buf, size::Integer)

Generate an SDP for an RTP session.

Note, this overwrites the id values of AVStreams in the muxer contexts for getting unique dynamic payload types.

# Arguments
* `ac`: array of AVFormatContexts describing the RTP streams. If the array is composed by only one context, such context can contain multiple AVStreams (one [`AVStream`](@ref) per RTP stream). Otherwise, all the contexts in the array (an [`AVCodecContext`](@ref) per RTP stream) must contain only one [`AVStream`](@ref).
* `n_files`: number of AVCodecContexts contained in ac
* `buf`: buffer where the SDP will be stored (must be allocated by the caller)
* `size`: the size of the buffer
# Returns
0 if OK, AVERROR\\_xxx on error
"""
function av_sdp_create(ac, n_files::Integer, buf, size::Integer)
    ccall((:av_sdp_create, libavformat), Cint, (Ptr{Ptr{AVFormatContext}}, Cint, Cstring, Cint), ac, n_files, buf, size)
end

"""
    av_match_ext(filename, extensions)

Return a positive value if the given filename has one of the given extensions, 0 otherwise.

# Arguments
* `filename`: file name to check against the given extensions
* `extensions`: a comma-separated list of filename extensions
"""
function av_match_ext(filename, extensions)
    ccall((:av_match_ext, libavformat), Cint, (Cstring, Cstring), filename, extensions)
end

"""
    avformat_query_codec(ofmt, codec_id::AVCodecID, std_compliance::Integer)

Test if the given container can store a codec.

# Arguments
* `ofmt`: container to check for compatibility
* `codec_id`: codec to potentially store in container
* `std_compliance`: standards compliance level, one of FF\\_COMPLIANCE\\_*
# Returns
1 if codec with ID codec\\_id can be stored in ofmt, 0 if it cannot. A negative number if this information is not available.
"""
function avformat_query_codec(ofmt, codec_id::AVCodecID, std_compliance::Integer)
    ccall((:avformat_query_codec, libavformat), Cint, (Ptr{AVOutputFormat}, AVCodecID, Cint), ofmt, codec_id, std_compliance)
end

"""
    avformat_get_riff_video_tags()

` riff_fourcc RIFF FourCCs`

@{ Get the tables mapping RIFF FourCCs to libavcodec AVCodecIDs. The tables are meant to be passed to [`av_codec_get_id`](@ref)()/[`av_codec_get_tag`](@ref)() as in the following code:

```c++
 uint32_t tag = MKTAG('H', '2', '6', '4');
 const struct AVCodecTag *table[] = { avformat_get_riff_video_tags(), 0 };
 enum AVCodecID id = av_codec_get_id(table, tag);
```

# Returns
the table mapping RIFF FourCCs for video to libavcodec [`AVCodecID`](@ref).
"""
function avformat_get_riff_video_tags()
    ccall((:avformat_get_riff_video_tags, libavformat), Ptr{AVCodecTag}, ())
end

"""
    avformat_get_riff_audio_tags()

# Returns
the table mapping RIFF FourCCs for audio to [`AVCodecID`](@ref).
"""
function avformat_get_riff_audio_tags()
    ccall((:avformat_get_riff_audio_tags, libavformat), Ptr{AVCodecTag}, ())
end

"""
    avformat_get_mov_video_tags()

# Returns
the table mapping MOV FourCCs for video to libavcodec [`AVCodecID`](@ref).
"""
function avformat_get_mov_video_tags()
    ccall((:avformat_get_mov_video_tags, libavformat), Ptr{AVCodecTag}, ())
end

"""
    avformat_get_mov_audio_tags()

# Returns
the table mapping MOV FourCCs for audio to [`AVCodecID`](@ref).
"""
function avformat_get_mov_audio_tags()
    ccall((:avformat_get_mov_audio_tags, libavformat), Ptr{AVCodecTag}, ())
end

"""
    av_guess_sample_aspect_ratio(format, stream, frame)

Guess the sample aspect ratio of a frame, based on both the stream and the frame aspect ratio.

Since the frame aspect ratio is set by the codec but the stream aspect ratio is set by the demuxer, these two may not be equal. This function tries to return the value that you should use if you would like to display the frame.

Basic logic is to use the stream aspect ratio if it is set to something sane otherwise use the frame aspect ratio. This way a container setting, which is usually easy to modify can override the coded value in the frames.

# Arguments
* `format`: the format context which the stream is part of
* `stream`: the stream which the frame is part of
* `frame`: the frame with the aspect ratio to be determined
# Returns
the guessed (valid) sample\\_aspect\\_ratio, 0/1 if no idea
"""
function av_guess_sample_aspect_ratio(format, stream, frame)
    ccall((:av_guess_sample_aspect_ratio, libavformat), AVRational, (Ptr{AVFormatContext}, Ptr{AVStream}, Ptr{AVFrame}), format, stream, frame)
end

"""
    av_guess_frame_rate(ctx, stream, frame)

Guess the frame rate, based on both the container and codec information.

# Arguments
* `ctx`: the format context which the stream is part of
* `stream`: the stream which the frame is part of
* `frame`: the frame for which the frame rate should be determined, may be NULL
# Returns
the guessed (valid) frame rate, 0/1 if no idea
"""
function av_guess_frame_rate(ctx, stream, frame)
    ccall((:av_guess_frame_rate, libavformat), AVRational, (Ptr{AVFormatContext}, Ptr{AVStream}, Ptr{AVFrame}), ctx, stream, frame)
end

"""
    avformat_match_stream_specifier(s, st, spec)

Check if the stream st contained in s is matched by the stream specifier spec.

See the "stream specifiers" chapter in the documentation for the syntax of spec.

!!! note

    A stream specifier can match several streams in the format.

# Returns
>0 if st is matched by spec; 0 if st is not matched by spec; [`AVERROR`](@ref) code if spec is invalid
"""
function avformat_match_stream_specifier(s, st, spec)
    ccall((:avformat_match_stream_specifier, libavformat), Cint, (Ptr{AVFormatContext}, Ptr{AVStream}, Cstring), s, st, spec)
end

function avformat_queue_attached_pictures(s)
    ccall((:avformat_queue_attached_pictures, libavformat), Cint, (Ptr{AVFormatContext},), s)
end

const AVTimebaseSource = Int32
const AVFMT_TBCF_AUTO = -1 % Int32
const AVFMT_TBCF_DECODER = 0 % Int32
const AVFMT_TBCF_DEMUXER = 1 % Int32
const AVFMT_TBCF_R_FRAMERATE = 2 % Int32

"""
    avformat_transfer_internal_stream_timing_info(ofmt, ost, ist, copy_tb::AVTimebaseSource)

!!! compat "Deprecated"

    do not call this function
"""
function avformat_transfer_internal_stream_timing_info(ofmt, ost, ist, copy_tb::AVTimebaseSource)
    ccall((:avformat_transfer_internal_stream_timing_info, libavformat), Cint, (Ptr{AVOutputFormat}, Ptr{AVStream}, Ptr{AVStream}, AVTimebaseSource), ofmt, ost, ist, copy_tb)
end

"""
    av_stream_get_codec_timebase(st)

!!! compat "Deprecated"

    do not call this function
"""
function av_stream_get_codec_timebase(st)
    ccall((:av_stream_get_codec_timebase, libavformat), AVRational, (Ptr{AVStream},), st)
end

"""
    avio_print_string_array(s, strings)

Write a NULL terminated array of strings to the context. Usually you don't need to use this function directly but its macro wrapper, [`avio_print`](@ref).
"""
function avio_print_string_array(s, strings)
    ccall((:avio_print_string_array, libavformat), Cvoid, (Ptr{AVIOContext}, Ptr{Cstring}), s, strings)
end

"""
    AVIODirEntryType

Directory entry types.
"""
const AVIODirEntryType = UInt32
const AVIO_ENTRY_UNKNOWN = 0 % UInt32
const AVIO_ENTRY_BLOCK_DEVICE = 1 % UInt32
const AVIO_ENTRY_CHARACTER_DEVICE = 2 % UInt32
const AVIO_ENTRY_DIRECTORY = 3 % UInt32
const AVIO_ENTRY_NAMED_PIPE = 4 % UInt32
const AVIO_ENTRY_SYMBOLIC_LINK = 5 % UInt32
const AVIO_ENTRY_SOCKET = 6 % UInt32
const AVIO_ENTRY_FILE = 7 % UInt32
const AVIO_ENTRY_SERVER = 8 % UInt32
const AVIO_ENTRY_SHARE = 9 % UInt32
const AVIO_ENTRY_WORKGROUP = 10 % UInt32

"""
    AVIODirEntry

Describes single entry of the directory.

Only name and type fields are guaranteed be set. Rest of fields are protocol or/and platform dependent and might be unknown.
"""
struct AVIODirEntry
    name::Cstring
    type::Cint
    utf8::Cint
    size::Int64
    modification_timestamp::Int64
    access_timestamp::Int64
    status_change_timestamp::Int64
    user_id::Int64
    group_id::Int64
    filemode::Int64
end

"""
    AVIODataMarkerType

Different data types that can be returned via the AVIO write\\_data\\_type callback.
"""
const AVIODataMarkerType = UInt32
const AVIO_DATA_MARKER_HEADER = 0 % UInt32
const AVIO_DATA_MARKER_SYNC_POINT = 1 % UInt32
const AVIO_DATA_MARKER_BOUNDARY_POINT = 2 % UInt32
const AVIO_DATA_MARKER_UNKNOWN = 3 % UInt32
const AVIO_DATA_MARKER_TRAILER = 4 % UInt32
const AVIO_DATA_MARKER_FLUSH_POINT = 5 % UInt32

"""
    avio_find_protocol_name(url)

Return the name of the protocol that will handle the passed URL.

NULL is returned if no protocol could be found for the given URL.

# Returns
Name of the protocol or NULL.
"""
function avio_find_protocol_name(url)
    ccall((:avio_find_protocol_name, libavformat), Cstring, (Cstring,), url)
end

"""
    avio_check(url, flags::Integer)

Return AVIO\\_FLAG\\_* access flags corresponding to the access permissions of the resource in url, or a negative value corresponding to an [`AVERROR`](@ref) code in case of failure. The returned access flags are masked by the value in flags.

!!! note

    This function is intrinsically unsafe, in the sense that the checked resource may change its existence or permission status from one call to another. Thus you should not trust the returned value, unless you are sure that no other processes are accessing the checked resource.
"""
function avio_check(url, flags::Integer)
    ccall((:avio_check, libavformat), Cint, (Cstring, Cint), url, flags)
end

"""
    avio_open_dir(s, url, options)

Open directory for reading.

# Arguments
* `s`: directory read context. Pointer to a NULL pointer must be passed.
* `url`: directory to be listed.
* `options`: A dictionary filled with protocol-private options. On return this parameter will be destroyed and replaced with a dictionary containing options that were not found. May be NULL.
# Returns
>=0 on success or negative on error.
"""
function avio_open_dir(s, url, options)
    ccall((:avio_open_dir, libavformat), Cint, (Ptr{Ptr{AVIODirContext}}, Cstring, Ptr{Ptr{AVDictionary}}), s, url, options)
end

"""
    avio_read_dir(s, next)

Get next directory entry.

Returned entry must be freed with [`avio_free_directory_entry`](@ref)(). In particular it may outlive [`AVIODirContext`](@ref).

# Arguments
* `s`: directory read context.
* `next`:\\[out\\] next entry or NULL when no more entries.
# Returns
>=0 on success or negative on error. End of list is not considered an error.
"""
function avio_read_dir(s, next)
    ccall((:avio_read_dir, libavformat), Cint, (Ptr{AVIODirContext}, Ptr{Ptr{AVIODirEntry}}), s, next)
end

"""
    avio_close_dir(s)

Close directory.

!!! note

    Entries created using [`avio_read_dir`](@ref)() are not deleted and must be freeded with [`avio_free_directory_entry`](@ref)().

# Arguments
* `s`: directory read context.
# Returns
>=0 on success or negative on error.
"""
function avio_close_dir(s)
    ccall((:avio_close_dir, libavformat), Cint, (Ptr{Ptr{AVIODirContext}},), s)
end

"""
    avio_free_directory_entry(entry)

Free entry allocated by [`avio_read_dir`](@ref)().

# Arguments
* `entry`: entry to be freed.
"""
function avio_free_directory_entry(entry)
    ccall((:avio_free_directory_entry, libavformat), Cvoid, (Ptr{Ptr{AVIODirEntry}},), entry)
end

"""
    avio_alloc_context(buffer, buffer_size::Integer, write_flag::Integer, opaque, read_packet, write_packet, seek)

Allocate and initialize an [`AVIOContext`](@ref) for buffered I/O. It must be later freed with [`avio_context_free`](@ref)().

# Arguments
* `buffer`: Memory block for input/output operations via [`AVIOContext`](@ref). The buffer must be allocated with [`av_malloc`](@ref)() and friends. It may be freed and replaced with a new buffer by libavformat. [`AVIOContext`](@ref).buffer holds the buffer currently in use, which must be later freed with [`av_free`](@ref)().
* `buffer_size`: The buffer size is very important for performance. For protocols with fixed blocksize it should be set to this blocksize. For others a typical size is a cache page, e.g. 4kb.
* `write_flag`: Set to 1 if the buffer should be writable, 0 otherwise.
* `opaque`: An opaque pointer to user-specific data.
* `read_packet`: A function for refilling the buffer, may be NULL. For stream protocols, must never return 0 but rather a proper [`AVERROR`](@ref) code.
* `write_packet`: A function for writing the buffer contents, may be NULL. The function may not change the input buffers content.
* `seek`: A function for seeking to specified byte position, may be NULL.
# Returns
Allocated [`AVIOContext`](@ref) or NULL on failure.
"""
function avio_alloc_context(buffer, buffer_size::Integer, write_flag::Integer, opaque, read_packet, write_packet, seek)
    ccall((:avio_alloc_context, libavformat), Ptr{AVIOContext}, (Ptr{Cuchar}, Cint, Cint, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}), buffer, buffer_size, write_flag, opaque, read_packet, write_packet, seek)
end

"""
    avio_context_free(s)

Free the supplied IO context and everything associated with it.

# Arguments
* `s`: Double pointer to the IO context. This function will write NULL into s.
"""
function avio_context_free(s)
    ccall((:avio_context_free, libavformat), Cvoid, (Ptr{Ptr{AVIOContext}},), s)
end

function avio_w8(s, b::Integer)
    ccall((:avio_w8, libavformat), Cvoid, (Ptr{AVIOContext}, Cint), s, b)
end

function avio_write(s, buf, size::Integer)
    ccall((:avio_write, libavformat), Cvoid, (Ptr{AVIOContext}, Ptr{Cuchar}, Cint), s, buf, size)
end

function avio_wl64(s, val::UInt64)
    ccall((:avio_wl64, libavformat), Cvoid, (Ptr{AVIOContext}, UInt64), s, val)
end

function avio_wb64(s, val::UInt64)
    ccall((:avio_wb64, libavformat), Cvoid, (Ptr{AVIOContext}, UInt64), s, val)
end

function avio_wl32(s, val::Integer)
    ccall((:avio_wl32, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

function avio_wb32(s, val::Integer)
    ccall((:avio_wb32, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

function avio_wl24(s, val::Integer)
    ccall((:avio_wl24, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

function avio_wb24(s, val::Integer)
    ccall((:avio_wb24, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

function avio_wl16(s, val::Integer)
    ccall((:avio_wl16, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

function avio_wb16(s, val::Integer)
    ccall((:avio_wb16, libavformat), Cvoid, (Ptr{AVIOContext}, Cuint), s, val)
end

"""
    avio_put_str(s, str)

Write a NULL-terminated string.

# Returns
number of bytes written.
"""
function avio_put_str(s, str)
    ccall((:avio_put_str, libavformat), Cint, (Ptr{AVIOContext}, Cstring), s, str)
end

"""
    avio_put_str16le(s, str)

Convert an UTF-8 string to UTF-16LE and write it.

# Arguments
* `s`: the [`AVIOContext`](@ref)
* `str`: NULL-terminated UTF-8 string
# Returns
number of bytes written.
"""
function avio_put_str16le(s, str)
    ccall((:avio_put_str16le, libavformat), Cint, (Ptr{AVIOContext}, Cstring), s, str)
end

"""
    avio_put_str16be(s, str)

Convert an UTF-8 string to UTF-16BE and write it.

# Arguments
* `s`: the [`AVIOContext`](@ref)
* `str`: NULL-terminated UTF-8 string
# Returns
number of bytes written.
"""
function avio_put_str16be(s, str)
    ccall((:avio_put_str16be, libavformat), Cint, (Ptr{AVIOContext}, Cstring), s, str)
end

"""
    avio_write_marker(s, time::Int64, type::AVIODataMarkerType)

Mark the written bytestream as a specific type.

Zero-length ranges are omitted from the output.

# Arguments
* `s`: the [`AVIOContext`](@ref)
* `time`: the stream time the current bytestream pos corresponds to (in [`AV_TIME_BASE`](@ref) units), or [`AV_NOPTS_VALUE`](@ref) if unknown or not applicable
* `type`: the kind of data written starting at the current pos
"""
function avio_write_marker(s, time::Int64, type::AVIODataMarkerType)
    ccall((:avio_write_marker, libavformat), Cvoid, (Ptr{AVIOContext}, Int64, AVIODataMarkerType), s, time, type)
end

"""
    avio_seek(s, offset::Int64, whence::Integer)

fseek() equivalent for [`AVIOContext`](@ref).

# Returns
new position or [`AVERROR`](@ref).
"""
function avio_seek(s, offset::Int64, whence::Integer)
    ccall((:avio_seek, libavformat), Int64, (Ptr{AVIOContext}, Int64, Cint), s, offset, whence)
end

"""
    avio_skip(s, offset::Int64)

Skip given number of bytes forward

# Returns
new position or [`AVERROR`](@ref).
"""
function avio_skip(s, offset::Int64)
    ccall((:avio_skip, libavformat), Int64, (Ptr{AVIOContext}, Int64), s, offset)
end

"""
    avio_tell(s)

ftell() equivalent for [`AVIOContext`](@ref).

# Returns
position or [`AVERROR`](@ref).
"""
function avio_tell(s)
    ccall((:avio_tell, libavformat), Int64, (Ptr{AVIOContext},), s)
end

"""
    avio_size(s)

Get the filesize.

# Returns
filesize or [`AVERROR`](@ref)
"""
function avio_size(s)
    ccall((:avio_size, libavformat), Int64, (Ptr{AVIOContext},), s)
end

"""
    avio_feof(s)

Similar to feof() but also returns nonzero on read errors.

# Returns
non zero if and only if at end of file or a read error happened when reading.
"""
function avio_feof(s)
    ccall((:avio_feof, libavformat), Cint, (Ptr{AVIOContext},), s)
end

"""
    avio_flush(s)

Force flushing of buffered data.

For write streams, force the buffered data to be immediately written to the output, without to wait to fill the internal buffer.

For read streams, discard all currently buffered data, and advance the reported file position to that of the underlying stream. This does not read new data, and does not perform any seeks.
"""
function avio_flush(s)
    ccall((:avio_flush, libavformat), Cvoid, (Ptr{AVIOContext},), s)
end

"""
    avio_read(s, buf, size::Integer)

Read size bytes from [`AVIOContext`](@ref) into buf.

# Returns
number of bytes read or [`AVERROR`](@ref)
"""
function avio_read(s, buf, size::Integer)
    ccall((:avio_read, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Cuchar}, Cint), s, buf, size)
end

"""
    avio_read_partial(s, buf, size::Integer)

Read size bytes from [`AVIOContext`](@ref) into buf. Unlike [`avio_read`](@ref)(), this is allowed to read fewer bytes than requested. The missing bytes can be read in the next call. This always tries to read at least 1 byte. Useful to reduce latency in certain cases.

# Returns
number of bytes read or [`AVERROR`](@ref)
"""
function avio_read_partial(s, buf, size::Integer)
    ccall((:avio_read_partial, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Cuchar}, Cint), s, buf, size)
end

"""
    avio_r8(s)

` Functions for reading from AVIOContext`

@{

!!! note

    return 0 if EOF, so you cannot use it if EOF handling is necessary
"""
function avio_r8(s)
    ccall((:avio_r8, libavformat), Cint, (Ptr{AVIOContext},), s)
end

function avio_rl16(s)
    ccall((:avio_rl16, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rl24(s)
    ccall((:avio_rl24, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rl32(s)
    ccall((:avio_rl32, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rl64(s)
    ccall((:avio_rl64, libavformat), UInt64, (Ptr{AVIOContext},), s)
end

function avio_rb16(s)
    ccall((:avio_rb16, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rb24(s)
    ccall((:avio_rb24, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rb32(s)
    ccall((:avio_rb32, libavformat), Cuint, (Ptr{AVIOContext},), s)
end

function avio_rb64(s)
    ccall((:avio_rb64, libavformat), UInt64, (Ptr{AVIOContext},), s)
end

"""
    avio_get_str(pb, maxlen::Integer, buf, buflen::Integer)

Read a string from pb into buf. The reading will terminate when either a NULL character was encountered, maxlen bytes have been read, or nothing more can be read from pb. The result is guaranteed to be NULL-terminated, it will be truncated if buf is too small. Note that the string is not interpreted or validated in any way, it might get truncated in the middle of a sequence for multi-byte encodings.

# Returns
number of bytes read (is always <= maxlen). If reading ends on EOF or error, the return value will be one more than bytes actually read.
"""
function avio_get_str(pb, maxlen::Integer, buf, buflen::Integer)
    ccall((:avio_get_str, libavformat), Cint, (Ptr{AVIOContext}, Cint, Cstring, Cint), pb, maxlen, buf, buflen)
end

"""
    avio_get_str16le(pb, maxlen::Integer, buf, buflen::Integer)

Read a UTF-16 string from pb and convert it to UTF-8. The reading will terminate when either a null or invalid character was encountered or maxlen bytes have been read.

# Returns
number of bytes read (is always <= maxlen)
"""
function avio_get_str16le(pb, maxlen::Integer, buf, buflen::Integer)
    ccall((:avio_get_str16le, libavformat), Cint, (Ptr{AVIOContext}, Cint, Cstring, Cint), pb, maxlen, buf, buflen)
end

function avio_get_str16be(pb, maxlen::Integer, buf, buflen::Integer)
    ccall((:avio_get_str16be, libavformat), Cint, (Ptr{AVIOContext}, Cint, Cstring, Cint), pb, maxlen, buf, buflen)
end

"""
    avio_open(s, url, flags::Integer)

Create and initialize a [`AVIOContext`](@ref) for accessing the resource indicated by url.

!!! note

    When the resource indicated by url has been opened in read+write mode, the [`AVIOContext`](@ref) can be used only for writing.

# Arguments
* `s`: Used to return the pointer to the created [`AVIOContext`](@ref). In case of failure the pointed to value is set to NULL.
* `url`: resource to access
* `flags`: flags which control how the resource indicated by url is to be opened
# Returns
>= 0 in case of success, a negative value corresponding to an [`AVERROR`](@ref) code in case of failure
"""
function avio_open(s, url, flags::Integer)
    ccall((:avio_open, libavformat), Cint, (Ptr{Ptr{AVIOContext}}, Cstring, Cint), s, url, flags)
end

"""
    avio_open2(s, url, flags::Integer, int_cb, options)

Create and initialize a [`AVIOContext`](@ref) for accessing the resource indicated by url.

!!! note

    When the resource indicated by url has been opened in read+write mode, the [`AVIOContext`](@ref) can be used only for writing.

# Arguments
* `s`: Used to return the pointer to the created [`AVIOContext`](@ref). In case of failure the pointed to value is set to NULL.
* `url`: resource to access
* `flags`: flags which control how the resource indicated by url is to be opened
* `int_cb`: an interrupt callback to be used at the protocols level
* `options`: A dictionary filled with protocol-private options. On return this parameter will be destroyed and replaced with a dict containing options that were not found. May be NULL.
# Returns
>= 0 in case of success, a negative value corresponding to an [`AVERROR`](@ref) code in case of failure
"""
function avio_open2(s, url, flags::Integer, int_cb, options)
    ccall((:avio_open2, libavformat), Cint, (Ptr{Ptr{AVIOContext}}, Cstring, Cint, Ptr{AVIOInterruptCB}, Ptr{Ptr{AVDictionary}}), s, url, flags, int_cb, options)
end

"""
    avio_close(s)

Close the resource accessed by the [`AVIOContext`](@ref) s and free it. This function can only be used if s was opened by [`avio_open`](@ref)().

The internal buffer is automatically flushed before closing the resource.

# Returns
0 on success, an [`AVERROR`](@ref) < 0 on error.
# See also
[`avio_closep`](@ref)
"""
function avio_close(s)
    ccall((:avio_close, libavformat), Cint, (Ptr{AVIOContext},), s)
end

"""
    avio_closep(s)

Close the resource accessed by the [`AVIOContext`](@ref) *s, free it and set the pointer pointing to it to NULL. This function can only be used if s was opened by [`avio_open`](@ref)().

The internal buffer is automatically flushed before closing the resource.

# Returns
0 on success, an [`AVERROR`](@ref) < 0 on error.
# See also
[`avio_close`](@ref)
"""
function avio_closep(s)
    ccall((:avio_closep, libavformat), Cint, (Ptr{Ptr{AVIOContext}},), s)
end

"""
    avio_open_dyn_buf(s)

Open a write only memory stream.

# Arguments
* `s`: new IO context
# Returns
zero if no error.
"""
function avio_open_dyn_buf(s)
    ccall((:avio_open_dyn_buf, libavformat), Cint, (Ptr{Ptr{AVIOContext}},), s)
end

"""
    avio_get_dyn_buf(s, pbuffer)

Return the written size and a pointer to the buffer. The [`AVIOContext`](@ref) stream is left intact. The buffer must NOT be freed. No padding is added to the buffer.

# Arguments
* `s`: IO context
* `pbuffer`: pointer to a byte buffer
# Returns
the length of the byte buffer
"""
function avio_get_dyn_buf(s, pbuffer)
    ccall((:avio_get_dyn_buf, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Ptr{UInt8}}), s, pbuffer)
end

"""
    avio_close_dyn_buf(s, pbuffer)

Return the written size and a pointer to the buffer. The buffer must be freed with [`av_free`](@ref)(). Padding of [`AV_INPUT_BUFFER_PADDING_SIZE`](@ref) is added to the buffer.

# Arguments
* `s`: IO context
* `pbuffer`: pointer to a byte buffer
# Returns
the length of the byte buffer
"""
function avio_close_dyn_buf(s, pbuffer)
    ccall((:avio_close_dyn_buf, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Ptr{UInt8}}), s, pbuffer)
end

"""
    avio_enum_protocols(opaque, output::Integer)

Iterate through names of available protocols.

# Arguments
* `opaque`: A private pointer representing current protocol. It must be a pointer to NULL on first iteration and will be updated by successive calls to [`avio_enum_protocols`](@ref).
* `output`: If set to 1, iterate over output protocols, otherwise over input protocols.
# Returns
A static string containing the name of current protocol or NULL
"""
function avio_enum_protocols(opaque, output::Integer)
    ccall((:avio_enum_protocols, libavformat), Cstring, (Ptr{Ptr{Cvoid}}, Cint), opaque, output)
end

"""
    avio_protocol_get_class(name)

Get [`AVClass`](@ref) by names of available protocols.

# Returns
A [`AVClass`](@ref) of input protocol name or NULL
"""
function avio_protocol_get_class(name)
    ccall((:avio_protocol_get_class, libavformat), Ptr{AVClass}, (Cstring,), name)
end

"""
    avio_pause(h, pause::Integer)

Pause and resume playing - only meaningful if using a network streaming protocol (e.g. MMS).

# Arguments
* `h`: IO context from which to call the read\\_pause function pointer
* `pause`: 1 for pause, 0 for resume
"""
function avio_pause(h, pause::Integer)
    ccall((:avio_pause, libavformat), Cint, (Ptr{AVIOContext}, Cint), h, pause)
end

"""
    avio_seek_time(h, stream_index::Integer, timestamp::Int64, flags::Integer)

Seek to a given timestamp relative to some component stream. Only meaningful if using a network streaming protocol (e.g. MMS.).

# Arguments
* `h`: IO context from which to call the seek function pointers
* `stream_index`: The stream index that the timestamp is relative to. If stream\\_index is (-1) the timestamp should be in [`AV_TIME_BASE`](@ref) units from the beginning of the presentation. If a stream\\_index >= 0 is used and the protocol does not support seeking based on component streams, the call will fail.
* `timestamp`: timestamp in [`AVStream`](@ref).time\\_base units or if there is no stream specified then in [`AV_TIME_BASE`](@ref) units.
* `flags`: Optional combination of [`AVSEEK_FLAG_BACKWARD`](@ref), [`AVSEEK_FLAG_BYTE`](@ref) and [`AVSEEK_FLAG_ANY`](@ref). The protocol may silently ignore [`AVSEEK_FLAG_BACKWARD`](@ref) and [`AVSEEK_FLAG_ANY`](@ref), but [`AVSEEK_FLAG_BYTE`](@ref) will fail if used and not supported.
# Returns
>= 0 on success
# See also
[`AVInputFormat`](@ref)::read\\_seek
"""
function avio_seek_time(h, stream_index::Integer, timestamp::Int64, flags::Integer)
    ccall((:avio_seek_time, libavformat), Int64, (Ptr{AVIOContext}, Cint, Int64, Cint), h, stream_index, timestamp, flags)
end

"""
    AVBPrint

Buffer to print data progressively

The string buffer grows as necessary and is always 0-terminated. The content of the string is never accessed, and thus is encoding-agnostic and can even hold binary data.

Small buffers are kept in the structure itself, and thus require no memory allocation at all (unless the contents of the buffer is needed after the structure goes out of scope). This is almost as lightweight as declaring a local `char buf[512]`.

The length of the string can go beyond the allocated size: the buffer is then truncated, but the functions still keep account of the actual total length.

In other words, [`AVBPrint`](@ref).len can be greater than [`AVBPrint`](@ref).size and records the total length of what would have been to the buffer if there had been enough memory.

Append operations do not need to be tested for failure: if a memory allocation fails, data stop being appended to the buffer, but the length is still updated. This situation can be tested with [`av_bprint_is_complete`](@ref)().

The [`AVBPrint`](@ref).size\\_max field determines several possible behaviours: - `size\\_max = -1` (= `UINT_MAX`) or any large value will let the buffer be reallocated as necessary, with an amortized linear cost. - `size\\_max = 0` prevents writing anything to the buffer: only the total length is computed. The write operations can then possibly be repeated in a buffer with exactly the necessary size (using `size\\_init = size\\_max = len + 1`). - `size\\_max = 1` is automatically replaced by the exact size available in the structure itself, thus ensuring no dynamic memory allocation. The internal buffer is large enough to hold a reasonable paragraph of text, such as the current paragraph.
"""
struct AVBPrint
    str::Cstring
    len::Cuint
    size::Cuint
    size_max::Cuint
    reserved_internal_buffer::NTuple{1, Cchar}
    reserved_padding::NTuple{1000, Cchar}
end

"""
    avio_read_to_bprint(h, pb, max_size::Csize_t)

Read contents of h into print buffer, up to max\\_size bytes, or up to EOF.

# Returns
0 for success (max\\_size bytes read or EOF reached), negative error code otherwise
"""
function avio_read_to_bprint(h, pb, max_size::Csize_t)
    ccall((:avio_read_to_bprint, libavformat), Cint, (Ptr{AVIOContext}, Ptr{AVBPrint}, Csize_t), h, pb, max_size)
end

"""
    avio_accept(s, c)

Accept and allocate a client context on a server context.

# Arguments
* `s`: the server context
* `c`: the client context, must be unallocated
# Returns
>= 0 on success or a negative value corresponding to an [`AVERROR`](@ref) on failure
"""
function avio_accept(s, c)
    ccall((:avio_accept, libavformat), Cint, (Ptr{AVIOContext}, Ptr{Ptr{AVIOContext}}), s, c)
end

"""
    avio_handshake(c)

Perform one step of the protocol handshake to accept a new client. This function must be called on a client returned by [`avio_accept`](@ref)() before using it as a read/write context. It is separate from [`avio_accept`](@ref)() because it may block. A step of the handshake is defined by places where the application may decide to change the proceedings. For example, on a protocol with a request header and a reply header, each one can constitute a step because the application may use the parameters from the request to change parameters in the reply; or each individual chunk of the request can constitute a step. If the handshake is already finished, [`avio_handshake`](@ref)() does nothing and returns 0 immediately.

# Arguments
* `c`: the client context to perform the handshake on
# Returns
0 on a complete and successful handshake > 0 if the handshake progressed, but is not complete < 0 for an [`AVERROR`](@ref) code
"""
function avio_handshake(c)
    ccall((:avio_handshake, libavformat), Cint, (Ptr{AVIOContext},), c)
end

"""
` lavu_adler32 Adler-32`

` lavu_hash`

Adler-32 hash function implementation.

@{
"""
const AVAdler = UInt32

"""
    av_adler32_update(adler::AVAdler, buf, len::Csize_t)

Calculate the Adler32 checksum of a buffer.

Passing the return value to a subsequent [`av_adler32_update`](@ref)() call allows the checksum of multiple buffers to be calculated as though they were concatenated.

# Arguments
* `adler`: initial checksum value
* `buf`: pointer to input buffer
* `len`: size of input buffer
# Returns
updated checksum
"""
function av_adler32_update(adler::AVAdler, buf, len::Csize_t)
    ccall((:av_adler32_update, libavutil), AVAdler, (AVAdler, Ptr{UInt8}, Csize_t), adler, buf, len)
end

mutable struct AVAES end

"""
    av_aes_alloc()

Allocate an [`AVAES`](@ref) context.
"""
function av_aes_alloc()
    ccall((:av_aes_alloc, libavutil), Ptr{AVAES}, ())
end

"""
    av_aes_init(a, key, key_bits::Integer, decrypt::Integer)

Initialize an [`AVAES`](@ref) context.

# Arguments
* `a`: The [`AVAES`](@ref) context
* `key`: Pointer to the key
* `key_bits`: 128, 192 or 256
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_aes_init(a, key, key_bits::Integer, decrypt::Integer)
    ccall((:av_aes_init, libavutil), Cint, (Ptr{AVAES}, Ptr{UInt8}, Cint, Cint), a, key, key_bits, decrypt)
end

"""
    av_aes_crypt(a, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context.

# Arguments
* `a`: The [`AVAES`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 16 byte blocks
* `iv`: initialization vector for CBC mode, if NULL then ECB will be used
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_aes_crypt(a, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_aes_crypt, libavutil), Cvoid, (Ptr{AVAES}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), a, dst, src, count, iv, decrypt)
end

mutable struct AVAESCTR end

"""
    av_aes_ctr_alloc()

Allocate an [`AVAESCTR`](@ref) context.
"""
function av_aes_ctr_alloc()
    ccall((:av_aes_ctr_alloc, libavutil), Ptr{AVAESCTR}, ())
end

"""
    av_aes_ctr_init(a, key)

Initialize an [`AVAESCTR`](@ref) context.

# Arguments
* `a`: The [`AVAESCTR`](@ref) context to initialize
* `key`: encryption key, must have a length of [`AES_CTR_KEY_SIZE`](@ref)
"""
function av_aes_ctr_init(a, key)
    ccall((:av_aes_ctr_init, libavutil), Cint, (Ptr{AVAESCTR}, Ptr{UInt8}), a, key)
end

"""
    av_aes_ctr_free(a)

Release an [`AVAESCTR`](@ref) context.

# Arguments
* `a`: The [`AVAESCTR`](@ref) context
"""
function av_aes_ctr_free(a)
    ccall((:av_aes_ctr_free, libavutil), Cvoid, (Ptr{AVAESCTR},), a)
end

"""
    av_aes_ctr_crypt(a, dst, src, size::Integer)

Process a buffer using a previously initialized context.

# Arguments
* `a`: The [`AVAESCTR`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `size`: the size of src and dst
"""
function av_aes_ctr_crypt(a, dst, src, size::Integer)
    ccall((:av_aes_ctr_crypt, libavutil), Cvoid, (Ptr{AVAESCTR}, Ptr{UInt8}, Ptr{UInt8}, Cint), a, dst, src, size)
end

"""
    av_aes_ctr_get_iv(a)

Get the current iv
"""
function av_aes_ctr_get_iv(a)
    ccall((:av_aes_ctr_get_iv, libavutil), Ptr{UInt8}, (Ptr{AVAESCTR},), a)
end

"""
    av_aes_ctr_set_random_iv(a)

Generate a random iv
"""
function av_aes_ctr_set_random_iv(a)
    ccall((:av_aes_ctr_set_random_iv, libavutil), Cvoid, (Ptr{AVAESCTR},), a)
end

"""
    av_aes_ctr_set_iv(a, iv)

Forcefully change the 8-byte iv
"""
function av_aes_ctr_set_iv(a, iv)
    ccall((:av_aes_ctr_set_iv, libavutil), Cvoid, (Ptr{AVAESCTR}, Ptr{UInt8}), a, iv)
end

"""
    av_aes_ctr_set_full_iv(a, iv)

Forcefully change the "full" 16-byte iv, including the counter
"""
function av_aes_ctr_set_full_iv(a, iv)
    ccall((:av_aes_ctr_set_full_iv, libavutil), Cvoid, (Ptr{AVAESCTR}, Ptr{UInt8}), a, iv)
end

"""
    av_aes_ctr_increment_iv(a)

Increment the top 64 bit of the iv (performed after each frame)
"""
function av_aes_ctr_increment_iv(a)
    ccall((:av_aes_ctr_increment_iv, libavutil), Cvoid, (Ptr{AVAESCTR},), a)
end

"""
    AVAmbientViewingEnvironment

Ambient viewing environment metadata as defined by H.274. The values are saved in AVRationals so that they keep their exactness, while allowing for easy access to a double value with f.ex. [`av_q2d`](@ref).

!!! note

    sizeof([`AVAmbientViewingEnvironment`](@ref)) is not part of the public ABI, and it must be allocated using [`av_ambient_viewing_environment_alloc`](@ref).
"""
struct AVAmbientViewingEnvironment
    ambient_illuminance::AVRational
    ambient_light_x::AVRational
    ambient_light_y::AVRational
end

"""
    av_ambient_viewing_environment_alloc(size)

Allocate an [`AVAmbientViewingEnvironment`](@ref) structure.

# Returns
the newly allocated struct or NULL on failure
"""
function av_ambient_viewing_environment_alloc(size)
    ccall((:av_ambient_viewing_environment_alloc, libavutil), Ptr{AVAmbientViewingEnvironment}, (Ptr{Csize_t},), size)
end

"""
    av_ambient_viewing_environment_create_side_data(frame)

Allocate and add an [`AVAmbientViewingEnvironment`](@ref) structure to an existing [`AVFrame`](@ref) as side data.

# Returns
the newly allocated struct, or NULL on failure
"""
function av_ambient_viewing_environment_create_side_data(frame)
    ccall((:av_ambient_viewing_environment_create_side_data, libavutil), Ptr{AVAmbientViewingEnvironment}, (Ptr{AVFrame},), frame)
end

mutable struct AVAudioFifo end

"""
    av_audio_fifo_free(af)

Free an [`AVAudioFifo`](@ref).

# Arguments
* `af`: [`AVAudioFifo`](@ref) to free
"""
function av_audio_fifo_free(af)
    ccall((:av_audio_fifo_free, libavutil), Cvoid, (Ptr{AVAudioFifo},), af)
end

"""
    av_audio_fifo_alloc(sample_fmt::AVSampleFormat, channels::Integer, nb_samples::Integer)

Allocate an [`AVAudioFifo`](@ref).

# Arguments
* `sample_fmt`: sample format
* `channels`: number of channels
* `nb_samples`: initial allocation size, in samples
# Returns
newly allocated [`AVAudioFifo`](@ref), or NULL on error
"""
function av_audio_fifo_alloc(sample_fmt::AVSampleFormat, channels::Integer, nb_samples::Integer)
    ccall((:av_audio_fifo_alloc, libavutil), Ptr{AVAudioFifo}, (AVSampleFormat, Cint, Cint), sample_fmt, channels, nb_samples)
end

"""
    av_audio_fifo_realloc(af, nb_samples::Integer)

Reallocate an [`AVAudioFifo`](@ref).

# Arguments
* `af`: [`AVAudioFifo`](@ref) to reallocate
* `nb_samples`: new allocation size, in samples
# Returns
0 if OK, or negative [`AVERROR`](@ref) code on failure
"""
function av_audio_fifo_realloc(af, nb_samples::Integer)
    ccall((:av_audio_fifo_realloc, libavutil), Cint, (Ptr{AVAudioFifo}, Cint), af, nb_samples)
end

"""
    av_audio_fifo_write(af, data, nb_samples::Integer)

Write data to an [`AVAudioFifo`](@ref).

The [`AVAudioFifo`](@ref) will be reallocated automatically if the available space is less than nb\\_samples.

# Arguments
* `af`: [`AVAudioFifo`](@ref) to write to
* `data`: audio data plane pointers
* `nb_samples`: number of samples to write
# Returns
number of samples actually written, or negative [`AVERROR`](@ref) code on failure. If successful, the number of samples actually written will always be nb\\_samples.
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout.
"""
function av_audio_fifo_write(af, data, nb_samples::Integer)
    ccall((:av_audio_fifo_write, libavutil), Cint, (Ptr{AVAudioFifo}, Ptr{Ptr{Cvoid}}, Cint), af, data, nb_samples)
end

"""
    av_audio_fifo_peek(af, data, nb_samples::Integer)

Peek data from an [`AVAudioFifo`](@ref).

# Arguments
* `af`: [`AVAudioFifo`](@ref) to read from
* `data`: audio data plane pointers
* `nb_samples`: number of samples to peek
# Returns
number of samples actually peek, or negative [`AVERROR`](@ref) code on failure. The number of samples actually peek will not be greater than nb\\_samples, and will only be less than nb\\_samples if [`av_audio_fifo_size`](@ref) is less than nb\\_samples.
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout.
"""
function av_audio_fifo_peek(af, data, nb_samples::Integer)
    ccall((:av_audio_fifo_peek, libavutil), Cint, (Ptr{AVAudioFifo}, Ptr{Ptr{Cvoid}}, Cint), af, data, nb_samples)
end

"""
    av_audio_fifo_peek_at(af, data, nb_samples::Integer, offset::Integer)

Peek data from an [`AVAudioFifo`](@ref).

# Arguments
* `af`: [`AVAudioFifo`](@ref) to read from
* `data`: audio data plane pointers
* `nb_samples`: number of samples to peek
* `offset`: offset from current read position
# Returns
number of samples actually peek, or negative [`AVERROR`](@ref) code on failure. The number of samples actually peek will not be greater than nb\\_samples, and will only be less than nb\\_samples if [`av_audio_fifo_size`](@ref) is less than nb\\_samples.
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout.
"""
function av_audio_fifo_peek_at(af, data, nb_samples::Integer, offset::Integer)
    ccall((:av_audio_fifo_peek_at, libavutil), Cint, (Ptr{AVAudioFifo}, Ptr{Ptr{Cvoid}}, Cint, Cint), af, data, nb_samples, offset)
end

"""
    av_audio_fifo_read(af, data, nb_samples::Integer)

Read data from an [`AVAudioFifo`](@ref).

# Arguments
* `af`: [`AVAudioFifo`](@ref) to read from
* `data`: audio data plane pointers
* `nb_samples`: number of samples to read
# Returns
number of samples actually read, or negative [`AVERROR`](@ref) code on failure. The number of samples actually read will not be greater than nb\\_samples, and will only be less than nb\\_samples if [`av_audio_fifo_size`](@ref) is less than nb\\_samples.
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout.
"""
function av_audio_fifo_read(af, data, nb_samples::Integer)
    ccall((:av_audio_fifo_read, libavutil), Cint, (Ptr{AVAudioFifo}, Ptr{Ptr{Cvoid}}, Cint), af, data, nb_samples)
end

"""
    av_audio_fifo_drain(af, nb_samples::Integer)

Drain data from an [`AVAudioFifo`](@ref).

Removes the data without reading it.

# Arguments
* `af`: [`AVAudioFifo`](@ref) to drain
* `nb_samples`: number of samples to drain
# Returns
0 if OK, or negative [`AVERROR`](@ref) code on failure
"""
function av_audio_fifo_drain(af, nb_samples::Integer)
    ccall((:av_audio_fifo_drain, libavutil), Cint, (Ptr{AVAudioFifo}, Cint), af, nb_samples)
end

"""
    av_audio_fifo_reset(af)

Reset the [`AVAudioFifo`](@ref) buffer.

This empties all data in the buffer.

# Arguments
* `af`: [`AVAudioFifo`](@ref) to reset
"""
function av_audio_fifo_reset(af)
    ccall((:av_audio_fifo_reset, libavutil), Cvoid, (Ptr{AVAudioFifo},), af)
end

"""
    av_audio_fifo_size(af)

Get the current number of samples in the [`AVAudioFifo`](@ref) available for reading.

# Arguments
* `af`: the [`AVAudioFifo`](@ref) to query
# Returns
number of samples available for reading
"""
function av_audio_fifo_size(af)
    ccall((:av_audio_fifo_size, libavutil), Cint, (Ptr{AVAudioFifo},), af)
end

"""
    av_audio_fifo_space(af)

Get the current number of samples in the [`AVAudioFifo`](@ref) available for writing.

# Arguments
* `af`: the [`AVAudioFifo`](@ref) to query
# Returns
number of samples available for writing
"""
function av_audio_fifo_space(af)
    ccall((:av_audio_fifo_space, libavutil), Cint, (Ptr{AVAudioFifo},), af)
end

"""
    av_assert0_fpu()

Assert that floating point operations can be executed.

This will [`av_assert0`](@ref)() that the cpu is not in MMX state on X86
"""
function av_assert0_fpu()
    ccall((:av_assert0_fpu, libavutil), Cvoid, ())
end

"""
    av_strstart(str, pfx, ptr)

Return non-zero if pfx is a prefix of str. If it is, *ptr is set to the address of the first character in str after the prefix.

# Arguments
* `str`: input string
* `pfx`: prefix to test
* `ptr`: updated if the prefix is matched inside str
# Returns
non-zero if the prefix matches, zero otherwise
"""
function av_strstart(str, pfx, ptr)
    ccall((:av_strstart, libavutil), Cint, (Cstring, Cstring, Ptr{Cstring}), str, pfx, ptr)
end

"""
    av_stristart(str, pfx, ptr)

Return non-zero if pfx is a prefix of str independent of case. If it is, *ptr is set to the address of the first character in str after the prefix.

# Arguments
* `str`: input string
* `pfx`: prefix to test
* `ptr`: updated if the prefix is matched inside str
# Returns
non-zero if the prefix matches, zero otherwise
"""
function av_stristart(str, pfx, ptr)
    ccall((:av_stristart, libavutil), Cint, (Cstring, Cstring, Ptr{Cstring}), str, pfx, ptr)
end

"""
    av_stristr(haystack, needle)

Locate the first case-independent occurrence in the string haystack of the string needle. A zero-length string needle is considered to match at the start of haystack.

This function is a case-insensitive version of the standard strstr().

# Arguments
* `haystack`: string to search in
* `needle`: string to search for
# Returns
pointer to the located match within haystack or a null pointer if no match
"""
function av_stristr(haystack, needle)
    ccall((:av_stristr, libavutil), Cstring, (Cstring, Cstring), haystack, needle)
end

"""
    av_strnstr(haystack, needle, hay_length::Csize_t)

Locate the first occurrence of the string needle in the string haystack where not more than hay\\_length characters are searched. A zero-length string needle is considered to match at the start of haystack.

This function is a length-limited version of the standard strstr().

# Arguments
* `haystack`: string to search in
* `needle`: string to search for
* `hay_length`: length of string to search in
# Returns
pointer to the located match within haystack or a null pointer if no match
"""
function av_strnstr(haystack, needle, hay_length::Csize_t)
    ccall((:av_strnstr, libavutil), Cstring, (Cstring, Cstring, Csize_t), haystack, needle, hay_length)
end

"""
    av_strlcpy(dst, src, size::Csize_t)

Copy the string src to dst, but no more than size - 1 bytes, and null-terminate dst.

This function is the same as BSD strlcpy().

!!! warning

    since the return value is the length of src, src absolutely \\_must\\_ be a properly 0-terminated string, otherwise this will read beyond the end of the buffer and possibly crash.

# Arguments
* `dst`: destination buffer
* `src`: source string
* `size`: size of destination buffer
# Returns
the length of src
"""
function av_strlcpy(dst, src, size::Csize_t)
    ccall((:av_strlcpy, libavutil), Csize_t, (Cstring, Cstring, Csize_t), dst, src, size)
end

"""
    av_strlcat(dst, src, size::Csize_t)

Append the string src to the string dst, but to a total length of no more than size - 1 bytes, and null-terminate dst.

This function is similar to BSD strlcat(), but differs when size <= strlen(dst).

!!! warning

    since the return value use the length of src and dst, these absolutely \\_must\\_ be a properly 0-terminated strings, otherwise this will read beyond the end of the buffer and possibly crash.

# Arguments
* `dst`: destination buffer
* `src`: source string
* `size`: size of destination buffer
# Returns
the total length of src and dst
"""
function av_strlcat(dst, src, size::Csize_t)
    ccall((:av_strlcat, libavutil), Csize_t, (Cstring, Cstring, Csize_t), dst, src, size)
end

"""
    av_strnlen(s, len::Csize_t)

Get the count of continuous non zero chars starting from the beginning.

# Arguments
* `s`: the string whose length to count
* `len`: maximum number of characters to check in the string, that is the maximum value which is returned by the function
"""
function av_strnlen(s, len::Csize_t)
    ccall((:av_strnlen, libavutil), Csize_t, (Cstring, Csize_t), s, len)
end

"""
    av_get_token(buf, term)

Unescape the given string until a non escaped terminating char, and return the token corresponding to the unescaped string.

The normal \\ and ' escaping is supported. Leading and trailing whitespaces are removed, unless they are escaped with '\\' or are enclosed between ''.

# Arguments
* `buf`: the buffer to parse, buf will be updated to point to the terminating char
* `term`: a 0-terminated list of terminating chars
# Returns
the malloced unescaped string, which must be av\\_freed by the user, NULL in case of allocation failure
"""
function av_get_token(buf, term)
    ccall((:av_get_token, libavutil), Cstring, (Ptr{Cstring}, Cstring), buf, term)
end

"""
    av_strtok(s, delim, saveptr)

Split the string into several tokens which can be accessed by successive calls to [`av_strtok`](@ref)().

A token is defined as a sequence of characters not belonging to the set specified in delim.

On the first call to [`av_strtok`](@ref)(), s should point to the string to parse, and the value of saveptr is ignored. In subsequent calls, s should be NULL, and saveptr should be unchanged since the previous call.

This function is similar to strtok\\_r() defined in POSIX.1.

# Arguments
* `s`: the string to parse, may be NULL
* `delim`: 0-terminated list of token delimiters, must be non-NULL
* `saveptr`: user-provided pointer which points to stored information necessary for [`av_strtok`](@ref)() to continue scanning the same string. saveptr is updated to point to the next character after the first delimiter found, or to NULL if the string was terminated
# Returns
the found token, or NULL when no token is found
"""
function av_strtok(s, delim, saveptr)
    ccall((:av_strtok, libavutil), Cstring, (Cstring, Cstring, Ptr{Cstring}), s, delim, saveptr)
end

"""
    av_isdigit(c::Integer)

Locale-independent conversion of ASCII isdigit.
"""
function av_isdigit(c::Integer)
    ccall((:av_isdigit, libavutil), Cint, (Cint,), c)
end

"""
    av_isgraph(c::Integer)

Locale-independent conversion of ASCII isgraph.
"""
function av_isgraph(c::Integer)
    ccall((:av_isgraph, libavutil), Cint, (Cint,), c)
end

"""
    av_isspace(c::Integer)

Locale-independent conversion of ASCII isspace.
"""
function av_isspace(c::Integer)
    ccall((:av_isspace, libavutil), Cint, (Cint,), c)
end

"""
    av_toupper(c::Integer)

Locale-independent conversion of ASCII characters to uppercase.
"""
function av_toupper(c::Integer)
    ccall((:av_toupper, libavutil), Cint, (Cint,), c)
end

"""
    av_tolower(c::Integer)

Locale-independent conversion of ASCII characters to lowercase.
"""
function av_tolower(c::Integer)
    ccall((:av_tolower, libavutil), Cint, (Cint,), c)
end

"""
    av_isxdigit(c::Integer)

Locale-independent conversion of ASCII isxdigit.
"""
function av_isxdigit(c::Integer)
    ccall((:av_isxdigit, libavutil), Cint, (Cint,), c)
end

"""
    av_strcasecmp(a, b)

Locale-independent case-insensitive compare.

!!! note

    This means only ASCII-range characters are case-insensitive
"""
function av_strcasecmp(a, b)
    ccall((:av_strcasecmp, libavutil), Cint, (Cstring, Cstring), a, b)
end

"""
    av_strncasecmp(a, b, n::Csize_t)

Locale-independent case-insensitive compare.

!!! note

    This means only ASCII-range characters are case-insensitive
"""
function av_strncasecmp(a, b, n::Csize_t)
    ccall((:av_strncasecmp, libavutil), Cint, (Cstring, Cstring, Csize_t), a, b, n)
end

"""
    av_strireplace(str, from, to)

Locale-independent strings replace.

!!! note

    This means only ASCII-range characters are replaced.
"""
function av_strireplace(str, from, to)
    ccall((:av_strireplace, libavutil), Cstring, (Cstring, Cstring, Cstring), str, from, to)
end

"""
    av_basename(path)

Thread safe basename.

# Arguments
* `path`: the string to parse, on DOS both \\ and / are considered separators.
# Returns
pointer to the basename substring. If path does not contain a slash, the function returns a copy of path. If path is a NULL pointer or points to an empty string, a pointer to a string "." is returned.
"""
function av_basename(path)
    ccall((:av_basename, libavutil), Cstring, (Cstring,), path)
end

"""
    av_dirname(path)

Thread safe dirname.

!!! note

    the function may modify the contents of the path, so copies should be passed.

# Arguments
* `path`: the string to parse, on DOS both \\ and / are considered separators.
# Returns
A pointer to a string that's the parent directory of path. If path is a NULL pointer or points to an empty string, a pointer to a string "." is returned.
"""
function av_dirname(path)
    ccall((:av_dirname, libavutil), Cstring, (Cstring,), path)
end

"""
    av_match_name(name, names)

Match instances of a name in a comma-separated list of names. List entries are checked from the start to the end of the names list, the first match ends further processing. If an entry prefixed with '-' matches, then 0 is returned. The "ALL" list entry is considered to match all names.

# Arguments
* `name`: Name to look for.
* `names`: List of names.
# Returns
1 on match, 0 otherwise.
"""
function av_match_name(name, names)
    ccall((:av_match_name, libavutil), Cint, (Cstring, Cstring), name, names)
end

"""
    av_append_path_component(path, component)

Append path component to the existing path. Path separator '/' is placed between when needed. Resulting string have to be freed with [`av_free`](@ref)().

# Arguments
* `path`: base path
* `component`: component to be appended
# Returns
new path or NULL on error.
"""
function av_append_path_component(path, component)
    ccall((:av_append_path_component, libavutil), Cstring, (Cstring, Cstring), path, component)
end

const AVEscapeMode = UInt32
const AV_ESCAPE_MODE_AUTO = 0 % UInt32
const AV_ESCAPE_MODE_BACKSLASH = 1 % UInt32
const AV_ESCAPE_MODE_QUOTE = 2 % UInt32
const AV_ESCAPE_MODE_XML = 3 % UInt32

"""
    av_escape(dst, src, special_chars, mode::AVEscapeMode, flags::Integer)

Escape string in src, and put the escaped string in an allocated string in *dst, which must be freed with [`av_free`](@ref)().

# Arguments
* `dst`: pointer where an allocated string is put
* `src`: string to escape, must be non-NULL
* `special_chars`: string containing the special characters which need to be escaped, can be NULL
* `mode`: escape mode to employ, see AV\\_ESCAPE\\_MODE\\_* macros. Any unknown value for mode will be considered equivalent to AV\\_ESCAPE\\_MODE\\_BACKSLASH, but this behaviour can change without notice.
* `flags`: flags which control how to escape, see AV\\_ESCAPE\\_FLAG\\_ macros
# Returns
the length of the allocated string, or a negative error code in case of error
# See also
[`av_bprint_escape`](@ref)()
"""
function av_escape(dst, src, special_chars, mode::AVEscapeMode, flags::Integer)
    ccall((:av_escape, libavutil), Cint, (Ptr{Cstring}, Cstring, Cstring, AVEscapeMode, Cint), dst, src, special_chars, mode, flags)
end

"""
    av_utf8_decode(codep, bufp, buf_end, flags::Integer)

Read and decode a single UTF-8 code point (character) from the buffer in *buf, and update *buf to point to the next byte to decode.

In case of an invalid byte sequence, the pointer will be updated to the next byte after the invalid sequence and the function will return an error code.

Depending on the specified flags, the function will also fail in case the decoded code point does not belong to a valid range.

!!! note

    For speed-relevant code a carefully implemented use of [`GET_UTF8`](@ref)() may be preferred.

# Arguments
* `codep`: pointer used to return the parsed code in case of success. The value in *codep is set even in case the range check fails.
* `bufp`: pointer to the address the first byte of the sequence to decode, updated by the function to point to the byte next after the decoded sequence
* `buf_end`: pointer to the end of the buffer, points to the next byte past the last in the buffer. This is used to avoid buffer overreads (in case of an unfinished UTF-8 sequence towards the end of the buffer).
* `flags`: a collection of AV\\_UTF8\\_FLAG\\_* flags
# Returns
>= 0 in case a sequence was successfully read, a negative value in case of invalid sequence
"""
function av_utf8_decode(codep, bufp, buf_end, flags::Integer)
    ccall((:av_utf8_decode, libavutil), Cint, (Ptr{Int32}, Ptr{Ptr{UInt8}}, Ptr{UInt8}, Cuint), codep, bufp, buf_end, flags)
end

"""
    av_match_list(name, list, separator::Cchar)

Check if a name is in a list.

# Returns
0 if not found, or the 1 based index where it has been found in the list.
"""
function av_match_list(name, list, separator::Cchar)
    ccall((:av_match_list, libavutil), Cint, (Cstring, Cstring, Cchar), name, list, separator)
end

"""
    av_int_list_length_for_size(elsize::Integer, list, term::UInt64)

Compute the length of an integer list.

# Arguments
* `elsize`: size in bytes of each list element (only 1, 2, 4 or 8)
* `term`: list terminator (usually 0 or -1)
* `list`: pointer to the list
# Returns
length of the list, in elements, not counting the terminator
"""
function av_int_list_length_for_size(elsize::Integer, list, term::UInt64)
    ccall((:av_int_list_length_for_size, libavutil), Cuint, (Cuint, Ptr{Cvoid}, UInt64), elsize, list, term)
end

"""
    av_fourcc_make_string(buf, fourcc::Integer)

Fill the provided buffer with a string containing a FourCC (four-character code) representation.

# Arguments
* `buf`: a buffer with size in bytes of at least [`AV_FOURCC_MAX_STRING_SIZE`](@ref)
* `fourcc`: the fourcc to represent
# Returns
the buffer in input
"""
function av_fourcc_make_string(buf, fourcc::Integer)
    ccall((:av_fourcc_make_string, libavutil), Cstring, (Cstring, UInt32), buf, fourcc)
end

"""
    avutil_version()

Return the [`LIBAVUTIL_VERSION_INT`](@ref) constant.
"""
function avutil_version()
    ccall((:avutil_version, libavutil), Cuint, ())
end

"""
    av_version_info()

Return an informative version string. This usually is the actual release version number or a git commit description. This string has no fixed format and can change any time. It should never be parsed by code.
"""
function av_version_info()
    ccall((:av_version_info, libavutil), Cstring, ())
end

"""
    avutil_configuration()

Return the libavutil build-time configuration.
"""
function avutil_configuration()
    ccall((:avutil_configuration, libavutil), Cstring, ())
end

"""
    avutil_license()

Return the libavutil license.
"""
function avutil_license()
    ccall((:avutil_license, libavutil), Cstring, ())
end

"""
    av_get_media_type_string(media_type::AVMediaType)

Return a string describing the media\\_type enum, NULL if media\\_type is unknown.
"""
function av_get_media_type_string(media_type::AVMediaType)
    ccall((:av_get_media_type_string, libavutil), Cstring, (AVMediaType,), media_type)
end

"""
    av_get_picture_type_char(pict_type::AVPictureType)

Return a single letter to describe the given picture type pict\\_type.

# Arguments
* `pict_type`:\\[in\\] the picture type
# Returns
a single character representing the picture type, '?' if pict\\_type is unknown
"""
function av_get_picture_type_char(pict_type::AVPictureType)
    ccall((:av_get_picture_type_char, libavutil), Cchar, (AVPictureType,), pict_type)
end

"""
    av_x_if_null(p, x)

Return x default pointer in case p is NULL.
"""
function av_x_if_null(p, x)
    ccall((:av_x_if_null, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Ptr{Cvoid}), p, x)
end

"""
    av_get_time_base_q()

Return the fractional representation of the internal time base.
"""
function av_get_time_base_q()
    ccall((:av_get_time_base_q, libavutil), AVRational, ())
end

"""
    av_base64_decode(out, in, out_size::Integer)

Decode a base64-encoded string.

# Arguments
* `out`: buffer for decoded data
* `in`: null-terminated input string
* `out_size`: size in bytes of the out buffer, must be at least 3/4 of the length of in, that is [`AV_BASE64_DECODE_SIZE`](@ref)(strlen(in))
# Returns
number of bytes written, or a negative value in case of invalid input
"""
function av_base64_decode(out, in, out_size::Integer)
    ccall((:av_base64_decode, libavutil), Cint, (Ptr{UInt8}, Cstring, Cint), out, in, out_size)
end

"""
    av_base64_encode(out, out_size::Integer, in, in_size::Integer)

Encode data to base64 and null-terminate.

# Arguments
* `out`: buffer for encoded data
* `out_size`: size in bytes of the out buffer (including the null terminator), must be at least [`AV_BASE64_SIZE`](@ref)(in\\_size)
* `in`: input buffer containing the data to encode
* `in_size`: size in bytes of the in buffer
# Returns
out or NULL in case of error
"""
function av_base64_encode(out, out_size::Integer, in, in_size::Integer)
    ccall((:av_base64_encode, libavutil), Cstring, (Cstring, Cint, Ptr{UInt8}, Cint), out, out_size, in, in_size)
end

struct AVBlowfish
    p::NTuple{18, UInt32}
    s::NTuple{4, NTuple{256, UInt32}}
end

"""
    av_blowfish_alloc()

Allocate an [`AVBlowfish`](@ref) context.
"""
function av_blowfish_alloc()
    ccall((:av_blowfish_alloc, libavutil), Ptr{AVBlowfish}, ())
end

"""
    av_blowfish_init(ctx, key, key_len::Integer)

Initialize an [`AVBlowfish`](@ref) context.

# Arguments
* `ctx`: an [`AVBlowfish`](@ref) context
* `key`: a key
* `key_len`: length of the key
"""
function av_blowfish_init(ctx, key, key_len::Integer)
    ccall((:av_blowfish_init, libavutil), Cvoid, (Ptr{AVBlowfish}, Ptr{UInt8}, Cint), ctx, key, key_len)
end

"""
    av_blowfish_crypt_ecb(ctx, xl, xr, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context.

# Arguments
* `ctx`: an [`AVBlowfish`](@ref) context
* `xl`: left four bytes halves of input to be encrypted
* `xr`: right four bytes halves of input to be encrypted
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_blowfish_crypt_ecb(ctx, xl, xr, decrypt::Integer)
    ccall((:av_blowfish_crypt_ecb, libavutil), Cvoid, (Ptr{AVBlowfish}, Ptr{UInt32}, Ptr{UInt32}, Cint), ctx, xl, xr, decrypt)
end

"""
    av_blowfish_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context.

# Arguments
* `ctx`: an [`AVBlowfish`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, if NULL ECB will be used
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_blowfish_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_blowfish_crypt, libavutil), Cvoid, (Ptr{AVBlowfish}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

"""
    ff_pad_helper_AVBPrint

Buffer to print data progressively

The string buffer grows as necessary and is always 0-terminated. The content of the string is never accessed, and thus is encoding-agnostic and can even hold binary data.

Small buffers are kept in the structure itself, and thus require no memory allocation at all (unless the contents of the buffer is needed after the structure goes out of scope). This is almost as lightweight as declaring a local `char buf[512]`.

The length of the string can go beyond the allocated size: the buffer is then truncated, but the functions still keep account of the actual total length.

In other words, [`AVBPrint`](@ref).len can be greater than [`AVBPrint`](@ref).size and records the total length of what would have been to the buffer if there had been enough memory.

Append operations do not need to be tested for failure: if a memory allocation fails, data stop being appended to the buffer, but the length is still updated. This situation can be tested with [`av_bprint_is_complete`](@ref)().

The [`AVBPrint`](@ref).size\\_max field determines several possible behaviours: - `size\\_max = -1` (= `UINT_MAX`) or any large value will let the buffer be reallocated as necessary, with an amortized linear cost. - `size\\_max = 0` prevents writing anything to the buffer: only the total length is computed. The write operations can then possibly be repeated in a buffer with exactly the necessary size (using `size\\_init = size\\_max = len + 1`). - `size\\_max = 1` is automatically replaced by the exact size available in the structure itself, thus ensuring no dynamic memory allocation. The internal buffer is large enough to hold a reasonable paragraph of text, such as the current paragraph.
"""
struct ff_pad_helper_AVBPrint
    str::Cstring
    len::Cuint
    size::Cuint
    size_max::Cuint
    reserved_internal_buffer::NTuple{1, Cchar}
end

"""
    av_bprint_init(buf, size_init::Integer, size_max::Integer)

Init a print buffer.

# Arguments
* `buf`: buffer to init
* `size_init`: initial size (including the final 0)
* `size_max`: maximum size; - `0` means do not write anything, just count the length - `1` is replaced by the maximum value for automatic storage any large value means that the internal buffer will be reallocated as needed up to that limit - `-1` is converted to `UINT_MAX`, the largest limit possible. Check also `AV\\_BPRINT\\_SIZE\\_*` macros.
"""
function av_bprint_init(buf, size_init::Integer, size_max::Integer)
    ccall((:av_bprint_init, libavutil), Cvoid, (Ptr{AVBPrint}, Cuint, Cuint), buf, size_init, size_max)
end

"""
    av_bprint_init_for_buffer(buf, buffer, size::Integer)

Init a print buffer using a pre-existing buffer.

The buffer will not be reallocated. In case size equals zero, the [`AVBPrint`](@ref) will be initialized to use the internal buffer as if using [`AV_BPRINT_SIZE_COUNT_ONLY`](@ref) with [`av_bprint_init`](@ref)().

# Arguments
* `buf`: buffer structure to init
* `buffer`: byte buffer to use for the string data
* `size`: size of buffer
"""
function av_bprint_init_for_buffer(buf, buffer, size::Integer)
    ccall((:av_bprint_init_for_buffer, libavutil), Cvoid, (Ptr{AVBPrint}, Cstring, Cuint), buf, buffer, size)
end

"""
    av_bprint_chars(buf, c::Cchar, n::Integer)

Append char c n times to a print buffer.
"""
function av_bprint_chars(buf, c::Cchar, n::Integer)
    ccall((:av_bprint_chars, libavutil), Cvoid, (Ptr{AVBPrint}, Cchar, Cuint), buf, c, n)
end

"""
    av_bprint_append_data(buf, data, size::Integer)

Append data to a print buffer.

# Arguments
* `buf`: bprint buffer to use
* `data`: pointer to data
* `size`: size of data
"""
function av_bprint_append_data(buf, data, size::Integer)
    ccall((:av_bprint_append_data, libavutil), Cvoid, (Ptr{AVBPrint}, Cstring, Cuint), buf, data, size)
end

mutable struct tm end

"""
    av_bprint_strftime(buf, fmt, tm_)

Append a formatted date and time to a print buffer.

!!! note

    due to poor design of the standard strftime function, it may produce poor results if the format string expands to a very long text and the bprint buffer is near the limit stated by the size\\_max option.

# Arguments
* `buf`: bprint buffer to use
* `fmt`: date and time format string, see strftime()
* `tm`: broken-down time structure to translate
"""
function av_bprint_strftime(buf, fmt, tm_)
    ccall((:av_bprint_strftime, libavutil), Cvoid, (Ptr{AVBPrint}, Cstring, Ptr{tm}), buf, fmt, tm_)
end

"""
    av_bprint_get_buffer(buf, size::Integer, mem, actual_size)

Allocate bytes in the buffer for external use.

# Arguments
* `buf`:\\[in\\] buffer structure
* `size`:\\[in\\] required size
* `mem`:\\[out\\] pointer to the memory area
* `actual_size`:\\[out\\] size of the memory area after allocation; can be larger or smaller than size
"""
function av_bprint_get_buffer(buf, size::Integer, mem, actual_size)
    ccall((:av_bprint_get_buffer, libavutil), Cvoid, (Ptr{AVBPrint}, Cuint, Ptr{Ptr{Cuchar}}, Ptr{Cuint}), buf, size, mem, actual_size)
end

"""
    av_bprint_clear(buf)

Reset the string to "" but keep internal allocated data.
"""
function av_bprint_clear(buf)
    ccall((:av_bprint_clear, libavutil), Cvoid, (Ptr{AVBPrint},), buf)
end

"""
    av_bprint_is_complete(buf)

Test if the print buffer is complete (not truncated).

It may have been truncated due to a memory allocation failure or the size\\_max limit (compare size and size\\_max if necessary).
"""
function av_bprint_is_complete(buf)
    ccall((:av_bprint_is_complete, libavutil), Cint, (Ptr{AVBPrint},), buf)
end

"""
    av_bprint_finalize(buf, ret_str)

Finalize a print buffer.

The print buffer can no longer be used afterwards, but the len and size fields are still valid.

* [out] ret\\_str if not NULL, used to return a permanent copy of the buffer contents, or NULL if memory allocation fails; if NULL, the buffer is discarded and freed

# Returns
0 for success or error code (probably [`AVERROR`](@ref)(ENOMEM))
"""
function av_bprint_finalize(buf, ret_str)
    ccall((:av_bprint_finalize, libavutil), Cint, (Ptr{AVBPrint}, Ptr{Cstring}), buf, ret_str)
end

"""
    av_bprint_escape(dstbuf, src, special_chars, mode::AVEscapeMode, flags::Integer)

Escape the content in src and append it to dstbuf.

# Arguments
* `dstbuf`: already inited destination bprint buffer
* `src`: string containing the text to escape
* `special_chars`: string containing the special characters which need to be escaped, can be NULL
* `mode`: escape mode to employ, see AV\\_ESCAPE\\_MODE\\_* macros. Any unknown value for mode will be considered equivalent to AV\\_ESCAPE\\_MODE\\_BACKSLASH, but this behaviour can change without notice.
* `flags`: flags which control how to escape, see AV\\_ESCAPE\\_FLAG\\_* macros
"""
function av_bprint_escape(dstbuf, src, special_chars, mode::AVEscapeMode, flags::Integer)
    ccall((:av_bprint_escape, libavutil), Cvoid, (Ptr{AVBPrint}, Cstring, Cstring, AVEscapeMode, Cint), dstbuf, src, special_chars, mode, flags)
end

function av_bswap16(x::UInt16)
    ccall((:av_bswap16, libavutil), UInt16, (UInt16,), x)
end

function av_bswap32(x::Integer)
    ccall((:av_bswap32, libavutil), UInt32, (UInt32,), x)
end

function av_bswap64(x::UInt64)
    ccall((:av_bswap64, libavutil), UInt64, (UInt64,), x)
end

"""
    av_buffer_alloc(size::Csize_t)

Allocate an [`AVBuffer`](@ref) of the given size using [`av_malloc`](@ref)().

# Returns
an [`AVBufferRef`](@ref) of given size or NULL when out of memory
"""
function av_buffer_alloc(size::Csize_t)
    ccall((:av_buffer_alloc, libavutil), Ptr{AVBufferRef}, (Csize_t,), size)
end

"""
    av_buffer_allocz(size::Csize_t)

Same as [`av_buffer_alloc`](@ref)(), except the returned buffer will be initialized to zero.
"""
function av_buffer_allocz(size::Csize_t)
    ccall((:av_buffer_allocz, libavutil), Ptr{AVBufferRef}, (Csize_t,), size)
end

"""
    av_buffer_create(data, size::Csize_t, free, opaque, flags::Integer)

Create an [`AVBuffer`](@ref) from an existing array.

If this function is successful, data is owned by the [`AVBuffer`](@ref). The caller may only access data through the returned [`AVBufferRef`](@ref) and references derived from it. If this function fails, data is left untouched.

# Arguments
* `data`: data array
* `size`: size of data in bytes
* `free`: a callback for freeing this buffer's data
* `opaque`: parameter to be got for processing or passed to free
* `flags`: a combination of AV\\_BUFFER\\_FLAG\\_*
# Returns
an [`AVBufferRef`](@ref) referring to data on success, NULL on failure.
"""
function av_buffer_create(data, size::Csize_t, free, opaque, flags::Integer)
    ccall((:av_buffer_create, libavutil), Ptr{AVBufferRef}, (Ptr{UInt8}, Csize_t, Ptr{Cvoid}, Ptr{Cvoid}, Cint), data, size, free, opaque, flags)
end

"""
    av_buffer_default_free(opaque, data)

Default free callback, which calls [`av_free`](@ref)() on the buffer data. This function is meant to be passed to [`av_buffer_create`](@ref)(), not called directly.
"""
function av_buffer_default_free(opaque, data)
    ccall((:av_buffer_default_free, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{UInt8}), opaque, data)
end

"""
    av_buffer_ref(buf)

Create a new reference to an [`AVBuffer`](@ref).

# Returns
a new [`AVBufferRef`](@ref) referring to the same [`AVBuffer`](@ref) as buf or NULL on failure.
"""
function av_buffer_ref(buf)
    ccall((:av_buffer_ref, libavutil), Ptr{AVBufferRef}, (Ptr{AVBufferRef},), buf)
end

"""
    av_buffer_unref(buf)

Free a given reference and automatically free the buffer if there are no more references to it.

# Arguments
* `buf`: the reference to be freed. The pointer is set to NULL on return.
"""
function av_buffer_unref(buf)
    ccall((:av_buffer_unref, libavutil), Cvoid, (Ptr{Ptr{AVBufferRef}},), buf)
end

"""
    av_buffer_is_writable(buf)

# Returns
1 if the caller may write to the data referred to by buf (which is true if and only if buf is the only reference to the underlying [`AVBuffer`](@ref)). Return 0 otherwise. A positive answer is valid until [`av_buffer_ref`](@ref)() is called on buf.
"""
function av_buffer_is_writable(buf)
    ccall((:av_buffer_is_writable, libavutil), Cint, (Ptr{AVBufferRef},), buf)
end

"""
    av_buffer_get_opaque(buf)

# Returns
the opaque parameter set by [`av_buffer_create`](@ref).
"""
function av_buffer_get_opaque(buf)
    ccall((:av_buffer_get_opaque, libavutil), Ptr{Cvoid}, (Ptr{AVBufferRef},), buf)
end

function av_buffer_get_ref_count(buf)
    ccall((:av_buffer_get_ref_count, libavutil), Cint, (Ptr{AVBufferRef},), buf)
end

"""
    av_buffer_make_writable(buf)

Create a writable reference from a given buffer reference, avoiding data copy if possible.

# Arguments
* `buf`: buffer reference to make writable. On success, buf is either left untouched, or it is unreferenced and a new writable [`AVBufferRef`](@ref) is written in its place. On failure, buf is left untouched.
# Returns
0 on success, a negative [`AVERROR`](@ref) on failure.
"""
function av_buffer_make_writable(buf)
    ccall((:av_buffer_make_writable, libavutil), Cint, (Ptr{Ptr{AVBufferRef}},), buf)
end

"""
    av_buffer_realloc(buf, size::Csize_t)

Reallocate a given buffer.

!!! note

    the buffer is actually reallocated with [`av_realloc`](@ref)() only if it was initially allocated through [`av_buffer_realloc`](@ref)(NULL) and there is only one reference to it (i.e. the one passed to this function). In all other cases a new buffer is allocated and the data is copied.

# Arguments
* `buf`: a buffer reference to reallocate. On success, buf will be unreferenced and a new reference with the required size will be written in its place. On failure buf will be left untouched. *buf may be NULL, then a new buffer is allocated.
* `size`: required new buffer size.
# Returns
0 on success, a negative [`AVERROR`](@ref) on failure.
"""
function av_buffer_realloc(buf, size::Csize_t)
    ccall((:av_buffer_realloc, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, Csize_t), buf, size)
end

"""
    av_buffer_replace(dst, src)

Ensure dst refers to the same data as src.

When *dst is already equivalent to src, do nothing. Otherwise unreference dst and replace it with a new reference to src.

# Arguments
* `dst`: Pointer to either a valid buffer reference or NULL. On success, this will point to a buffer reference equivalent to src. On failure, dst will be left untouched.
* `src`: A buffer reference to replace dst with. May be NULL, then this function is equivalent to [`av_buffer_unref`](@ref)(dst).
# Returns
0 on success [`AVERROR`](@ref)(ENOMEM) on memory allocation failure.
"""
function av_buffer_replace(dst, src)
    ccall((:av_buffer_replace, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, Ptr{AVBufferRef}), dst, src)
end

"""
    av_buffer_pool_init(size::Csize_t, alloc)

Allocate and initialize a buffer pool.

# Arguments
* `size`: size of each buffer in this pool
* `alloc`: a function that will be used to allocate new buffers when the pool is empty. May be NULL, then the default allocator will be used ([`av_buffer_alloc`](@ref)()).
# Returns
newly created buffer pool on success, NULL on error.
"""
function av_buffer_pool_init(size::Csize_t, alloc)
    ccall((:av_buffer_pool_init, libavutil), Ptr{AVBufferPool}, (Csize_t, Ptr{Cvoid}), size, alloc)
end

"""
    av_buffer_pool_init2(size::Csize_t, opaque, alloc, pool_free)

Allocate and initialize a buffer pool with a more complex allocator.

# Arguments
* `size`: size of each buffer in this pool
* `opaque`: arbitrary user data used by the allocator
* `alloc`: a function that will be used to allocate new buffers when the pool is empty. May be NULL, then the default allocator will be used ([`av_buffer_alloc`](@ref)()).
* `pool_free`: a function that will be called immediately before the pool is freed. I.e. after [`av_buffer_pool_uninit`](@ref)() is called by the caller and all the frames are returned to the pool and freed. It is intended to uninitialize the user opaque data. May be NULL.
# Returns
newly created buffer pool on success, NULL on error.
"""
function av_buffer_pool_init2(size::Csize_t, opaque, alloc, pool_free)
    ccall((:av_buffer_pool_init2, libavutil), Ptr{AVBufferPool}, (Csize_t, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}), size, opaque, alloc, pool_free)
end

"""
    av_buffer_pool_uninit(pool)

Mark the pool as being available for freeing. It will actually be freed only once all the allocated buffers associated with the pool are released. Thus it is safe to call this function while some of the allocated buffers are still in use.

# Arguments
* `pool`: pointer to the pool to be freed. It will be set to NULL.
"""
function av_buffer_pool_uninit(pool)
    ccall((:av_buffer_pool_uninit, libavutil), Cvoid, (Ptr{Ptr{AVBufferPool}},), pool)
end

"""
    av_buffer_pool_get(pool)

Allocate a new [`AVBuffer`](@ref), reusing an old buffer from the pool when available. This function may be called simultaneously from multiple threads.

# Returns
a reference to the new buffer on success, NULL on error.
"""
function av_buffer_pool_get(pool)
    ccall((:av_buffer_pool_get, libavutil), Ptr{AVBufferRef}, (Ptr{AVBufferPool},), pool)
end

"""
    av_buffer_pool_buffer_get_opaque(ref)

Query the original opaque parameter of an allocated buffer in the pool.

!!! note

    the opaque parameter of ref is used by the buffer pool implementation, therefore you have to use this function to access the original opaque parameter of an allocated buffer.

# Arguments
* `ref`: a buffer reference to a buffer returned by [`av_buffer_pool_get`](@ref).
# Returns
the opaque parameter set by the buffer allocator function of the buffer pool.
"""
function av_buffer_pool_buffer_get_opaque(ref)
    ccall((:av_buffer_pool_buffer_get_opaque, libavutil), Ptr{Cvoid}, (Ptr{AVBufferRef},), ref)
end

mutable struct AVCAMELLIA end

"""
    av_camellia_alloc()

Allocate an [`AVCAMELLIA`](@ref) context To free the struct: [`av_free`](@ref)(ptr)
"""
function av_camellia_alloc()
    ccall((:av_camellia_alloc, libavutil), Ptr{AVCAMELLIA}, ())
end

"""
    av_camellia_init(ctx, key, key_bits::Integer)

Initialize an [`AVCAMELLIA`](@ref) context.

# Arguments
* `ctx`: an [`AVCAMELLIA`](@ref) context
* `key`: a key of 16, 24, 32 bytes used for encryption/decryption
* `key_bits`: number of keybits: possible are 128, 192, 256
"""
function av_camellia_init(ctx, key, key_bits::Integer)
    ccall((:av_camellia_init, libavutil), Cint, (Ptr{AVCAMELLIA}, Ptr{UInt8}, Cint), ctx, key, key_bits)
end

"""
    av_camellia_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context

# Arguments
* `ctx`: an [`AVCAMELLIA`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 16 byte blocks
* `iv`: initialization vector for CBC mode, NULL for ECB mode
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_camellia_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_camellia_crypt, libavutil), Cvoid, (Ptr{AVCAMELLIA}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

mutable struct AVCAST5 end

"""
    av_cast5_alloc()

Allocate an [`AVCAST5`](@ref) context To free the struct: [`av_free`](@ref)(ptr)
"""
function av_cast5_alloc()
    ccall((:av_cast5_alloc, libavutil), Ptr{AVCAST5}, ())
end

"""
    av_cast5_init(ctx, key, key_bits::Integer)

Initialize an [`AVCAST5`](@ref) context.

# Arguments
* `ctx`: an [`AVCAST5`](@ref) context
* `key`: a key of 5,6,...16 bytes used for encryption/decryption
* `key_bits`: number of keybits: possible are 40,48,...,128
# Returns
0 on success, less than 0 on failure
"""
function av_cast5_init(ctx, key, key_bits::Integer)
    ccall((:av_cast5_init, libavutil), Cint, (Ptr{AVCAST5}, Ptr{UInt8}, Cint), ctx, key, key_bits)
end

"""
    av_cast5_crypt(ctx, dst, src, count::Integer, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context, ECB mode only

# Arguments
* `ctx`: an [`AVCAST5`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_cast5_crypt(ctx, dst, src, count::Integer, decrypt::Integer)
    ccall((:av_cast5_crypt, libavutil), Cvoid, (Ptr{AVCAST5}, Ptr{UInt8}, Ptr{UInt8}, Cint, Cint), ctx, dst, src, count, decrypt)
end

"""
    av_cast5_crypt2(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context

# Arguments
* `ctx`: an [`AVCAST5`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, NULL for ECB mode
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_cast5_crypt2(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_cast5_crypt2, libavutil), Cvoid, (Ptr{AVCAST5}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

"""
    AVChannel

` lavu_audio_channels Audio channels`

` lavu_audio`

Audio channel layout utility functions

@{
"""
const AVChannel = Int32
const AV_CHAN_NONE = -1 % Int32
const AV_CHAN_FRONT_LEFT = 0 % Int32
const AV_CHAN_FRONT_RIGHT = 1 % Int32
const AV_CHAN_FRONT_CENTER = 2 % Int32
const AV_CHAN_LOW_FREQUENCY = 3 % Int32
const AV_CHAN_BACK_LEFT = 4 % Int32
const AV_CHAN_BACK_RIGHT = 5 % Int32
const AV_CHAN_FRONT_LEFT_OF_CENTER = 6 % Int32
const AV_CHAN_FRONT_RIGHT_OF_CENTER = 7 % Int32
const AV_CHAN_BACK_CENTER = 8 % Int32
const AV_CHAN_SIDE_LEFT = 9 % Int32
const AV_CHAN_SIDE_RIGHT = 10 % Int32
const AV_CHAN_TOP_CENTER = 11 % Int32
const AV_CHAN_TOP_FRONT_LEFT = 12 % Int32
const AV_CHAN_TOP_FRONT_CENTER = 13 % Int32
const AV_CHAN_TOP_FRONT_RIGHT = 14 % Int32
const AV_CHAN_TOP_BACK_LEFT = 15 % Int32
const AV_CHAN_TOP_BACK_CENTER = 16 % Int32
const AV_CHAN_TOP_BACK_RIGHT = 17 % Int32
const AV_CHAN_STEREO_LEFT = 29 % Int32
const AV_CHAN_STEREO_RIGHT = 30 % Int32
const AV_CHAN_WIDE_LEFT = 31 % Int32
const AV_CHAN_WIDE_RIGHT = 32 % Int32
const AV_CHAN_SURROUND_DIRECT_LEFT = 33 % Int32
const AV_CHAN_SURROUND_DIRECT_RIGHT = 34 % Int32
const AV_CHAN_LOW_FREQUENCY_2 = 35 % Int32
const AV_CHAN_TOP_SIDE_LEFT = 36 % Int32
const AV_CHAN_TOP_SIDE_RIGHT = 37 % Int32
const AV_CHAN_BOTTOM_FRONT_CENTER = 38 % Int32
const AV_CHAN_BOTTOM_FRONT_LEFT = 39 % Int32
const AV_CHAN_BOTTOM_FRONT_RIGHT = 40 % Int32
const AV_CHAN_SIDE_SURROUND_LEFT = 41 % Int32
const AV_CHAN_SIDE_SURROUND_RIGHT = 42 % Int32
const AV_CHAN_TOP_SURROUND_LEFT = 43 % Int32
const AV_CHAN_TOP_SURROUND_RIGHT = 44 % Int32
const AV_CHAN_BINAURAL_LEFT = 61 % Int32
const AV_CHAN_BINAURAL_RIGHT = 62 % Int32
const AV_CHAN_UNUSED = 512 % Int32
const AV_CHAN_UNKNOWN = 768 % Int32
const AV_CHAN_AMBISONIC_BASE = 1024 % Int32
const AV_CHAN_AMBISONIC_END = 2047 % Int32

const AVMatrixEncoding = UInt32
const AV_MATRIX_ENCODING_NONE = 0 % UInt32
const AV_MATRIX_ENCODING_DOLBY = 1 % UInt32
const AV_MATRIX_ENCODING_DPLII = 2 % UInt32
const AV_MATRIX_ENCODING_DPLIIX = 3 % UInt32
const AV_MATRIX_ENCODING_DPLIIZ = 4 % UInt32
const AV_MATRIX_ENCODING_DOLBYEX = 5 % UInt32
const AV_MATRIX_ENCODING_DOLBYHEADPHONE = 6 % UInt32
const AV_MATRIX_ENCODING_NB = 7 % UInt32

"""
    AVChannelCustom

An [`AVChannelCustom`](@ref) defines a single channel within a custom order layout

Unlike most structures in FFmpeg, sizeof([`AVChannelCustom`](@ref)) is a part of the public ABI.

No new fields may be added to it without a major version bump.
"""
struct AVChannelCustom
    id::AVChannel
    name::NTuple{16, Cchar}
    opaque::Ptr{Cvoid}
end

"""
    av_channel_name(buf, buf_size::Csize_t, channel::AVChannel)

Get a human readable string in an abbreviated form describing a given channel. This is the inverse function of av_channel_from_string().

# Arguments
* `buf`: pre-allocated buffer where to put the generated string
* `buf_size`: size in bytes of the buffer.
* `channel`: the [`AVChannel`](@ref) whose name to get
# Returns
amount of bytes needed to hold the output string, or a negative [`AVERROR`](@ref) on failure. If the returned value is bigger than buf\\_size, then the string was truncated.
"""
function av_channel_name(buf, buf_size::Csize_t, channel::AVChannel)
    ccall((:av_channel_name, libavutil), Cint, (Cstring, Csize_t, AVChannel), buf, buf_size, channel)
end

"""
    av_channel_name_bprint(bp, channel_id::AVChannel)

bprint variant of [`av_channel_name`](@ref)().

!!! note

    the string will be appended to the bprint buffer.
"""
function av_channel_name_bprint(bp, channel_id::AVChannel)
    ccall((:av_channel_name_bprint, libavutil), Cvoid, (Ptr{AVBPrint}, AVChannel), bp, channel_id)
end

"""
    av_channel_description(buf, buf_size::Csize_t, channel::AVChannel)

Get a human readable string describing a given channel.

# Arguments
* `buf`: pre-allocated buffer where to put the generated string
* `buf_size`: size in bytes of the buffer.
* `channel`: the [`AVChannel`](@ref) whose description to get
# Returns
amount of bytes needed to hold the output string, or a negative [`AVERROR`](@ref) on failure. If the returned value is bigger than buf\\_size, then the string was truncated.
"""
function av_channel_description(buf, buf_size::Csize_t, channel::AVChannel)
    ccall((:av_channel_description, libavutil), Cint, (Cstring, Csize_t, AVChannel), buf, buf_size, channel)
end

"""
    av_channel_description_bprint(bp, channel_id::AVChannel)

bprint variant of [`av_channel_description`](@ref)().

!!! note

    the string will be appended to the bprint buffer.
"""
function av_channel_description_bprint(bp, channel_id::AVChannel)
    ccall((:av_channel_description_bprint, libavutil), Cvoid, (Ptr{AVBPrint}, AVChannel), bp, channel_id)
end

"""
    av_channel_from_string(name)

This is the inverse function of av_channel_name().

# Returns
the channel with the given name AV\\_CHAN\\_NONE when name does not identify a known channel
"""
function av_channel_from_string(name)
    ccall((:av_channel_from_string, libavutil), AVChannel, (Cstring,), name)
end

"""
    av_channel_layout_custom_init(channel_layout, nb_channels::Integer)

Initialize a custom channel layout with the specified number of channels. The channel map will be allocated and the designation of all channels will be set to AV\\_CHAN\\_UNKNOWN.

This is only a convenience helper function, a custom channel layout can also be constructed without using this.

# Arguments
* `channel_layout`: the layout structure to be initialized
* `nb_channels`: the number of channels
# Returns
0 on success [`AVERROR`](@ref)(EINVAL) if the number of channels <= 0 [`AVERROR`](@ref)(ENOMEM) if the channel map could not be allocated
"""
function av_channel_layout_custom_init(channel_layout, nb_channels::Integer)
    ccall((:av_channel_layout_custom_init, libavutil), Cint, (Ptr{AVChannelLayout}, Cint), channel_layout, nb_channels)
end

"""
    av_channel_layout_from_mask(channel_layout, mask::UInt64)

Initialize a native channel layout from a bitmask indicating which channels are present.

# Arguments
* `channel_layout`: the layout structure to be initialized
* `mask`: bitmask describing the channel layout
# Returns
0 on success [`AVERROR`](@ref)(EINVAL) for invalid mask values
"""
function av_channel_layout_from_mask(channel_layout, mask::UInt64)
    ccall((:av_channel_layout_from_mask, libavutil), Cint, (Ptr{AVChannelLayout}, UInt64), channel_layout, mask)
end

"""
    av_channel_layout_from_string(channel_layout, str)

Initialize a channel layout from a given string description. The input string can be represented by: - the formal channel layout name (returned by [`av_channel_layout_describe`](@ref)()) - single or multiple channel names (returned by [`av_channel_name`](@ref)(), eg. "FL", or concatenated with "+", each optionally containing a custom name after a "@", eg. "FL@Left+FR@Right+LFE") - a decimal or hexadecimal value of a native channel layout (eg. "4" or "0x4") - the number of channels with default layout (eg. "4c") - the number of unordered channels (eg. "4C" or "4 channels") - the ambisonic order followed by optional non-diegetic channels (eg. "ambisonic 2+stereo") On error, the channel layout will remain uninitialized, but not necessarily untouched.

# Arguments
* `channel_layout`: uninitialized channel layout for the result
* `str`: string describing the channel layout
# Returns
0 on success parsing the channel layout [`AVERROR`](@ref)(EINVAL) if an invalid channel layout string was provided [`AVERROR`](@ref)(ENOMEM) if there was not enough memory
"""
function av_channel_layout_from_string(channel_layout, str)
    ccall((:av_channel_layout_from_string, libavutil), Cint, (Ptr{AVChannelLayout}, Cstring), channel_layout, str)
end

"""
    av_channel_layout_default(ch_layout, nb_channels::Integer)

Get the default channel layout for a given number of channels.

# Arguments
* `ch_layout`: the layout structure to be initialized
* `nb_channels`: number of channels
"""
function av_channel_layout_default(ch_layout, nb_channels::Integer)
    ccall((:av_channel_layout_default, libavutil), Cvoid, (Ptr{AVChannelLayout}, Cint), ch_layout, nb_channels)
end

"""
    av_channel_layout_standard(opaque)

Iterate over all standard channel layouts.

# Arguments
* `opaque`: a pointer where libavutil will store the iteration state. Must point to NULL to start the iteration.
# Returns
the standard channel layout or NULL when the iteration is finished
"""
function av_channel_layout_standard(opaque)
    ccall((:av_channel_layout_standard, libavutil), Ptr{AVChannelLayout}, (Ptr{Ptr{Cvoid}},), opaque)
end

"""
    av_channel_layout_uninit(channel_layout)

Free any allocated data in the channel layout and reset the channel count to 0.

# Arguments
* `channel_layout`: the layout structure to be uninitialized
"""
function av_channel_layout_uninit(channel_layout)
    ccall((:av_channel_layout_uninit, libavutil), Cvoid, (Ptr{AVChannelLayout},), channel_layout)
end

"""
    av_channel_layout_copy(dst, src)

Make a copy of a channel layout. This differs from just assigning src to dst in that it allocates and copies the map for AV\\_CHANNEL\\_ORDER\\_CUSTOM.

!!! note

    the destination channel\\_layout will be always uninitialized before copy.

# Arguments
* `dst`: destination channel layout
* `src`: source channel layout
# Returns
0 on success, a negative [`AVERROR`](@ref) on error.
"""
function av_channel_layout_copy(dst, src)
    ccall((:av_channel_layout_copy, libavutil), Cint, (Ptr{AVChannelLayout}, Ptr{AVChannelLayout}), dst, src)
end

"""
    av_channel_layout_describe(channel_layout, buf, buf_size::Csize_t)

Get a human-readable string describing the channel layout properties. The string will be in the same format that is accepted by av_channel_layout_from_string(), allowing to rebuild the same channel layout, except for opaque pointers.

# Arguments
* `channel_layout`: channel layout to be described
* `buf`: pre-allocated buffer where to put the generated string
* `buf_size`: size in bytes of the buffer.
# Returns
amount of bytes needed to hold the output string, or a negative [`AVERROR`](@ref) on failure. If the returned value is bigger than buf\\_size, then the string was truncated.
"""
function av_channel_layout_describe(channel_layout, buf, buf_size::Csize_t)
    ccall((:av_channel_layout_describe, libavutil), Cint, (Ptr{AVChannelLayout}, Cstring, Csize_t), channel_layout, buf, buf_size)
end

"""
    av_channel_layout_describe_bprint(channel_layout, bp)

bprint variant of [`av_channel_layout_describe`](@ref)().

!!! note

    the string will be appended to the bprint buffer.

# Returns
0 on success, or a negative [`AVERROR`](@ref) value on failure.
"""
function av_channel_layout_describe_bprint(channel_layout, bp)
    ccall((:av_channel_layout_describe_bprint, libavutil), Cint, (Ptr{AVChannelLayout}, Ptr{AVBPrint}), channel_layout, bp)
end

"""
    av_channel_layout_channel_from_index(channel_layout, idx::Integer)

Get the channel with the given index in a channel layout.

# Arguments
* `channel_layout`: input channel layout
* `idx`: index of the channel
# Returns
channel with the index idx in channel\\_layout on success or AV\\_CHAN\\_NONE on failure (if idx is not valid or the channel order is unspecified)
"""
function av_channel_layout_channel_from_index(channel_layout, idx::Integer)
    ccall((:av_channel_layout_channel_from_index, libavutil), AVChannel, (Ptr{AVChannelLayout}, Cuint), channel_layout, idx)
end

"""
    av_channel_layout_index_from_channel(channel_layout, channel::AVChannel)

Get the index of a given channel in a channel layout. In case multiple channels are found, only the first match will be returned.

# Arguments
* `channel_layout`: input channel layout
* `channel`: the channel whose index to obtain
# Returns
index of channel in channel\\_layout on success or a negative number if channel is not present in channel\\_layout.
"""
function av_channel_layout_index_from_channel(channel_layout, channel::AVChannel)
    ccall((:av_channel_layout_index_from_channel, libavutil), Cint, (Ptr{AVChannelLayout}, AVChannel), channel_layout, channel)
end

"""
    av_channel_layout_index_from_string(channel_layout, name)

Get the index in a channel layout of a channel described by the given string. In case multiple channels are found, only the first match will be returned.

This function accepts channel names in the same format as av_channel_from_string().

# Arguments
* `channel_layout`: input channel layout
* `name`: string describing the channel whose index to obtain
# Returns
a channel index described by the given string, or a negative [`AVERROR`](@ref) value.
"""
function av_channel_layout_index_from_string(channel_layout, name)
    ccall((:av_channel_layout_index_from_string, libavutil), Cint, (Ptr{AVChannelLayout}, Cstring), channel_layout, name)
end

"""
    av_channel_layout_channel_from_string(channel_layout, name)

Get a channel described by the given string.

This function accepts channel names in the same format as av_channel_from_string().

# Arguments
* `channel_layout`: input channel layout
* `name`: string describing the channel to obtain
# Returns
a channel described by the given string in channel\\_layout on success or AV\\_CHAN\\_NONE on failure (if the string is not valid or the channel order is unspecified)
"""
function av_channel_layout_channel_from_string(channel_layout, name)
    ccall((:av_channel_layout_channel_from_string, libavutil), AVChannel, (Ptr{AVChannelLayout}, Cstring), channel_layout, name)
end

"""
    av_channel_layout_subset(channel_layout, mask::UInt64)

Find out what channels from a given set are present in a channel layout, without regard for their positions.

# Arguments
* `channel_layout`: input channel layout
* `mask`: a combination of AV\\_CH\\_* representing a set of channels
# Returns
a bitfield representing all the channels from mask that are present in channel\\_layout
"""
function av_channel_layout_subset(channel_layout, mask::UInt64)
    ccall((:av_channel_layout_subset, libavutil), UInt64, (Ptr{AVChannelLayout}, UInt64), channel_layout, mask)
end

"""
    av_channel_layout_check(channel_layout)

Check whether a channel layout is valid, i.e. can possibly describe audio data.

# Arguments
* `channel_layout`: input channel layout
# Returns
1 if channel\\_layout is valid, 0 otherwise.
"""
function av_channel_layout_check(channel_layout)
    ccall((:av_channel_layout_check, libavutil), Cint, (Ptr{AVChannelLayout},), channel_layout)
end

"""
    av_channel_layout_compare(chl, chl1)

Check whether two channel layouts are semantically the same, i.e. the same channels are present on the same positions in both.

If one of the channel layouts is AV\\_CHANNEL\\_ORDER\\_UNSPEC, while the other is not, they are considered to be unequal. If both are AV\\_CHANNEL\\_ORDER\\_UNSPEC, they are considered equal iff the channel counts are the same in both.

# Arguments
* `chl`: input channel layout
* `chl1`: input channel layout
# Returns
0 if chl and chl1 are equal, 1 if they are not equal. A negative [`AVERROR`](@ref) code if one or both are invalid.
"""
function av_channel_layout_compare(chl, chl1)
    ccall((:av_channel_layout_compare, libavutil), Cint, (Ptr{AVChannelLayout}, Ptr{AVChannelLayout}), chl, chl1)
end

"""
    av_channel_layout_ambisonic_order(channel_layout)

Return the order if the layout is n-th order standard-order ambisonic. The presence of optional extra non-diegetic channels at the end is not taken into account.

# Arguments
* `channel_layout`: input channel layout
# Returns
the order of the layout, a negative error code otherwise.
"""
function av_channel_layout_ambisonic_order(channel_layout)
    ccall((:av_channel_layout_ambisonic_order, libavutil), Cint, (Ptr{AVChannelLayout},), channel_layout)
end

"""
    av_channel_layout_retype(channel_layout, order::AVChannelOrder, flags::Integer)

Change the [`AVChannelOrder`](@ref) of a channel layout.

Change of [`AVChannelOrder`](@ref) can be either lossless or lossy. In case of a lossless conversion all the channel designations and the associated channel names (if any) are kept. On a lossy conversion the channel names and channel designations might be lost depending on the capabilities of the desired [`AVChannelOrder`](@ref). Note that some conversions are simply not possible in which case this function returns [`AVERROR`](@ref)(ENOSYS).

The following conversions are supported:

Any -> Custom : Always possible, always lossless. Any -> Unspecified: Always possible, lossless if channel designations are all unknown and channel names are not used, lossy otherwise. Custom -> Ambisonic : Possible if it contains ambisonic channels with optional non-diegetic channels in the end. Lossy if the channels have custom names, lossless otherwise. Custom -> Native : Possible if it contains native channels in native order. Lossy if the channels have custom names, lossless otherwise.

On error this function keeps the original channel layout untouched.

# Arguments
* `channel_layout`: channel layout which will be changed
* `order`: the desired channel layout order
* `flags`: a combination of AV\\_CHANNEL\\_LAYOUT\\_RETYPE\\_FLAG\\_* constants
# Returns
0 if the conversion was successful and lossless or if the channel layout was already in the desired order >0 if the conversion was successful but lossy [`AVERROR`](@ref)(ENOSYS) if the conversion was not possible (or would be lossy and [`AV_CHANNEL_LAYOUT_RETYPE_FLAG_LOSSLESS`](@ref) was specified) [`AVERROR`](@ref)(EINVAL), [`AVERROR`](@ref)(ENOMEM) on error
"""
function av_channel_layout_retype(channel_layout, order::AVChannelOrder, flags::Integer)
    ccall((:av_channel_layout_retype, libavutil), Cint, (Ptr{AVChannelLayout}, AVChannelOrder, Cint), channel_layout, order, flags)
end

"""
    av_ceil_log2_c(x::Integer)

Compute ceil(log2(x)).

# Arguments
* `x`: value used to compute ceil(log2(x))
# Returns
computed ceiling of log2(x)
"""
function av_ceil_log2_c(x::Integer)
    ccall((:av_ceil_log2_c, libavutil), Cint, (Cint,), x)
end

"""
    av_clip_c(a::Integer, amin::Integer, amax::Integer)

Clip a signed integer value into the amin-amax range.

# Arguments
* `a`: value to clip
* `amin`: minimum value of the clip range
* `amax`: maximum value of the clip range
# Returns
clipped value
"""
function av_clip_c(a::Integer, amin::Integer, amax::Integer)
    ccall((:av_clip_c, libavutil), Cint, (Cint, Cint, Cint), a, amin, amax)
end

"""
    av_clip64_c(a::Int64, amin::Int64, amax::Int64)

Clip a signed 64bit integer value into the amin-amax range.

# Arguments
* `a`: value to clip
* `amin`: minimum value of the clip range
* `amax`: maximum value of the clip range
# Returns
clipped value
"""
function av_clip64_c(a::Int64, amin::Int64, amax::Int64)
    ccall((:av_clip64_c, libavutil), Int64, (Int64, Int64, Int64), a, amin, amax)
end

"""
    av_clip_uint8_c(a::Integer)

Clip a signed integer value into the 0-255 range.

# Arguments
* `a`: value to clip
# Returns
clipped value
"""
function av_clip_uint8_c(a::Integer)
    ccall((:av_clip_uint8_c, libavutil), UInt8, (Cint,), a)
end

"""
    av_clip_int8_c(a::Integer)

Clip a signed integer value into the -128,127 range.

# Arguments
* `a`: value to clip
# Returns
clipped value
"""
function av_clip_int8_c(a::Integer)
    ccall((:av_clip_int8_c, libavutil), Int8, (Cint,), a)
end

"""
    av_clip_uint16_c(a::Integer)

Clip a signed integer value into the 0-65535 range.

# Arguments
* `a`: value to clip
# Returns
clipped value
"""
function av_clip_uint16_c(a::Integer)
    ccall((:av_clip_uint16_c, libavutil), UInt16, (Cint,), a)
end

"""
    av_clip_int16_c(a::Integer)

Clip a signed integer value into the -32768,32767 range.

# Arguments
* `a`: value to clip
# Returns
clipped value
"""
function av_clip_int16_c(a::Integer)
    ccall((:av_clip_int16_c, libavutil), Int16, (Cint,), a)
end

"""
    av_clipl_int32_c(a::Int64)

Clip a signed 64-bit integer value into the -2147483648,2147483647 range.

# Arguments
* `a`: value to clip
# Returns
clipped value
"""
function av_clipl_int32_c(a::Int64)
    ccall((:av_clipl_int32_c, libavutil), Int32, (Int64,), a)
end

"""
    av_clip_intp2_c(a::Integer, p::Integer)

Clip a signed integer into the -(2^p),(2^p-1) range.

# Arguments
* `a`: value to clip
* `p`: bit position to clip at
# Returns
clipped value
"""
function av_clip_intp2_c(a::Integer, p::Integer)
    ccall((:av_clip_intp2_c, libavutil), Cint, (Cint, Cint), a, p)
end

"""
    av_clip_uintp2_c(a::Integer, p::Integer)

Clip a signed integer to an unsigned power of two range.

# Arguments
* `a`: value to clip
* `p`: bit position to clip at
# Returns
clipped value
"""
function av_clip_uintp2_c(a::Integer, p::Integer)
    ccall((:av_clip_uintp2_c, libavutil), Cuint, (Cint, Cint), a, p)
end

"""
    av_sat_add32_c(a::Integer, b::Integer)

Add two signed 32-bit values with saturation.

# Arguments
* `a`: one value
* `b`: another value
# Returns
sum with signed saturation
"""
function av_sat_add32_c(a::Integer, b::Integer)
    ccall((:av_sat_add32_c, libavutil), Cint, (Cint, Cint), a, b)
end

"""
    av_sat_dadd32_c(a::Integer, b::Integer)

Add a doubled value to another value with saturation at both stages.

# Arguments
* `a`: first value
* `b`: value doubled and added to a
# Returns
sum sat(a + sat(2*b)) with signed saturation
"""
function av_sat_dadd32_c(a::Integer, b::Integer)
    ccall((:av_sat_dadd32_c, libavutil), Cint, (Cint, Cint), a, b)
end

"""
    av_sat_sub32_c(a::Integer, b::Integer)

Subtract two signed 32-bit values with saturation.

# Arguments
* `a`: one value
* `b`: another value
# Returns
difference with signed saturation
"""
function av_sat_sub32_c(a::Integer, b::Integer)
    ccall((:av_sat_sub32_c, libavutil), Cint, (Cint, Cint), a, b)
end

"""
    av_sat_dsub32_c(a::Integer, b::Integer)

Subtract a doubled value from another value with saturation at both stages.

# Arguments
* `a`: first value
* `b`: value doubled and subtracted from a
# Returns
difference sat(a - sat(2*b)) with signed saturation
"""
function av_sat_dsub32_c(a::Integer, b::Integer)
    ccall((:av_sat_dsub32_c, libavutil), Cint, (Cint, Cint), a, b)
end

"""
    av_sat_add64_c(a::Int64, b::Int64)

Add two signed 64-bit values with saturation.

# Arguments
* `a`: one value
* `b`: another value
# Returns
sum with signed saturation
"""
function av_sat_add64_c(a::Int64, b::Int64)
    ccall((:av_sat_add64_c, libavutil), Int64, (Int64, Int64), a, b)
end

"""
    av_sat_sub64_c(a::Int64, b::Int64)

Subtract two signed 64-bit values with saturation.

# Arguments
* `a`: one value
* `b`: another value
# Returns
difference with signed saturation
"""
function av_sat_sub64_c(a::Int64, b::Int64)
    ccall((:av_sat_sub64_c, libavutil), Int64, (Int64, Int64), a, b)
end

"""
    av_clipf_c(a::Cfloat, amin::Cfloat, amax::Cfloat)

Clip a float value into the amin-amax range. If a is nan or -inf amin will be returned. If a is +inf amax will be returned.

# Arguments
* `a`: value to clip
* `amin`: minimum value of the clip range
* `amax`: maximum value of the clip range
# Returns
clipped value
"""
function av_clipf_c(a::Cfloat, amin::Cfloat, amax::Cfloat)
    ccall((:av_clipf_c, libavutil), Cfloat, (Cfloat, Cfloat, Cfloat), a, amin, amax)
end

"""
    av_clipd_c(a::Cdouble, amin::Cdouble, amax::Cdouble)

Clip a double value into the amin-amax range. If a is nan or -inf amin will be returned. If a is +inf amax will be returned.

# Arguments
* `a`: value to clip
* `amin`: minimum value of the clip range
* `amax`: maximum value of the clip range
# Returns
clipped value
"""
function av_clipd_c(a::Cdouble, amin::Cdouble, amax::Cdouble)
    ccall((:av_clipd_c, libavutil), Cdouble, (Cdouble, Cdouble, Cdouble), a, amin, amax)
end

"""
    av_zero_extend_c(a::Integer, p::Integer)

Clear high bits from an unsigned integer starting with specific bit position

# Arguments
* `a`: value to clip
* `p`: bit position to clip at. Must be between 0 and 31.
# Returns
clipped value
"""
function av_zero_extend_c(a::Integer, p::Integer)
    ccall((:av_zero_extend_c, libavutil), Cuint, (Cuint, Cuint), a, p)
end

"""
    av_popcount_c(x::Integer)

Count number of bits set to one in x

# Arguments
* `x`: value to count bits of
# Returns
the number of bits set to one in x
"""
function av_popcount_c(x::Integer)
    ccall((:av_popcount_c, libavutil), Cint, (UInt32,), x)
end

"""
    av_popcount64_c(x::UInt64)

Count number of bits set to one in x

# Arguments
* `x`: value to count bits of
# Returns
the number of bits set to one in x
"""
function av_popcount64_c(x::UInt64)
    ccall((:av_popcount64_c, libavutil), Cint, (UInt64,), x)
end

function av_parity_c(v::Integer)
    ccall((:av_parity_c, libavutil), Cint, (UInt32,), v)
end

function av_mod_uintp2_c(a::Integer, p::Integer)
    ccall((:av_mod_uintp2_c, libavutil), Cuint, (Cuint, Cuint), a, p)
end

function av_log2(v::Integer)
    ccall((:av_log2, libavutil), Cint, (Cuint,), v)
end

function av_log2_16bit(v::Integer)
    ccall((:av_log2_16bit, libavutil), Cint, (Cuint,), v)
end

const AVContainerFifoFlags = UInt32
const AV_CONTAINER_FIFO_FLAG_REF = 1 % UInt32
const AV_CONTAINER_FIFO_FLAG_USER = 65536 % UInt32

"""
    av_container_fifo_alloc(opaque, container_alloc, container_reset, container_free, fifo_transfer, flags::Integer)

Allocate a new [`AVContainerFifo`](@ref) for the container type defined by provided callbacks.

# Arguments
* `opaque`: user data that will be passed to the callbacks provided to this function
* `container_alloc`: allocate a new container instance and return a pointer to it, or NULL on failure
* `container_reset`: reset the provided container instance to a clean state
* `container_free`: free the provided container instance
* `fifo_transfer`: Transfer the contents of container src to dst.
* `flags`: currently unused
# Returns
newly allocated [`AVContainerFifo`](@ref), or NULL on failure
"""
function av_container_fifo_alloc(opaque, container_alloc, container_reset, container_free, fifo_transfer, flags::Integer)
    ccall((:av_container_fifo_alloc, libavutil), Ptr{AVContainerFifo}, (Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Cuint), opaque, container_alloc, container_reset, container_free, fifo_transfer, flags)
end

"""
    av_container_fifo_alloc_avframe(flags::Integer)

Allocate an [`AVContainerFifo`](@ref) instance for AVFrames.

# Arguments
* `flags`: currently unused
"""
function av_container_fifo_alloc_avframe(flags::Integer)
    ccall((:av_container_fifo_alloc_avframe, libavutil), Ptr{AVContainerFifo}, (Cuint,), flags)
end

"""
    av_container_fifo_free(cf)

Free a [`AVContainerFifo`](@ref) and everything in it.
"""
function av_container_fifo_free(cf)
    ccall((:av_container_fifo_free, libavutil), Cvoid, (Ptr{Ptr{AVContainerFifo}},), cf)
end

"""
    av_container_fifo_write(cf, obj, flags::Integer)

Write the contents of obj to the FIFO.

The fifo\\_transfer() callback previously provided to [`av_container_fifo_alloc`](@ref)() will be called with obj as src in order to perform the actual transfer.
"""
function av_container_fifo_write(cf, obj, flags::Integer)
    ccall((:av_container_fifo_write, libavutil), Cint, (Ptr{AVContainerFifo}, Ptr{Cvoid}, Cuint), cf, obj, flags)
end

"""
    av_container_fifo_read(cf, obj, flags::Integer)

Read the next available object from the FIFO into obj.

The fifo\\_read() callback previously provided to [`av_container_fifo_alloc`](@ref)() will be called with obj as dst in order to perform the actual transfer.
"""
function av_container_fifo_read(cf, obj, flags::Integer)
    ccall((:av_container_fifo_read, libavutil), Cint, (Ptr{AVContainerFifo}, Ptr{Cvoid}, Cuint), cf, obj, flags)
end

"""
    av_container_fifo_peek(cf, pobj, offset::Csize_t)

Access objects stored in the FIFO without retrieving them. The fifo\\_transfer() callback will NOT be invoked and the FIFO state will not be modified.

\\retval0 success, a pointer was written into pobj

\\retvalAVERROR(EINVAL) invalid offset value

# Arguments
* `pobj`: Pointer to the object stored in the FIFO will be written here on success. The object remains owned by the FIFO and the caller may only access it as long as the FIFO is not modified.
* `offset`: Position of the object to retrieve - 0 is the next item that would be read, 1 the one after, etc. Must be smaller than [`av_container_fifo_can_read`](@ref)().
"""
function av_container_fifo_peek(cf, pobj, offset::Csize_t)
    ccall((:av_container_fifo_peek, libavutil), Cint, (Ptr{AVContainerFifo}, Ptr{Ptr{Cvoid}}, Csize_t), cf, pobj, offset)
end

"""
    av_container_fifo_drain(cf, nb_elems::Csize_t)

Discard the specified number of elements from the FIFO.

# Arguments
* `nb_elems`: number of elements to discard, MUST NOT be larger than [`av_fifo_can_read`](@ref)(f)
"""
function av_container_fifo_drain(cf, nb_elems::Csize_t)
    ccall((:av_container_fifo_drain, libavutil), Cvoid, (Ptr{AVContainerFifo}, Csize_t), cf, nb_elems)
end

"""
    av_container_fifo_can_read(cf)

# Returns
number of objects available for reading
"""
function av_container_fifo_can_read(cf)
    ccall((:av_container_fifo_can_read, libavutil), Csize_t, (Ptr{AVContainerFifo},), cf)
end

"""
    av_get_cpu_flags()

Return the flags which specify extensions supported by the CPU. The returned value is affected by [`av_force_cpu_flags`](@ref)() if that was used before. So [`av_get_cpu_flags`](@ref)() can easily be used in an application to detect the enabled cpu flags.
"""
function av_get_cpu_flags()
    ccall((:av_get_cpu_flags, libavutil), Cint, ())
end

"""
    av_force_cpu_flags(flags::Integer)

Disables cpu detection and forces the specified flags. -1 is a special case that disables forcing of specific flags.
"""
function av_force_cpu_flags(flags::Integer)
    ccall((:av_force_cpu_flags, libavutil), Cvoid, (Cint,), flags)
end

"""
    av_parse_cpu_caps(flags, s)

Parse CPU caps from a string and update the given AV\\_CPU\\_* flags based on that.

# Returns
negative on error.
"""
function av_parse_cpu_caps(flags, s)
    ccall((:av_parse_cpu_caps, libavutil), Cint, (Ptr{Cuint}, Cstring), flags, s)
end

"""
    av_cpu_count()

# Returns
the number of logical CPU cores present.
"""
function av_cpu_count()
    ccall((:av_cpu_count, libavutil), Cint, ())
end

"""
    av_cpu_force_count(count::Integer)

Overrides cpu count detection and forces the specified count. Count < 1 disables forcing of specific count.
"""
function av_cpu_force_count(count::Integer)
    ccall((:av_cpu_force_count, libavutil), Cvoid, (Cint,), count)
end

"""
    av_cpu_max_align()

Get the maximum data alignment that may be required by FFmpeg.

Note that this is affected by the build configuration and the CPU flags mask, so e.g. if the CPU supports AVX, but libavutil has been built with --disable-avx or the [`AV_CPU_FLAG_AVX`](@ref) flag has been disabled through av\\_set\\_cpu\\_flags\\_mask(), then this function will behave as if AVX is not present.
"""
function av_cpu_max_align()
    ccall((:av_cpu_max_align, libavutil), Csize_t, ())
end

"""
` lavu_crc32 CRC`

` lavu_hash`

CRC (Cyclic Redundancy Check) hash function implementation.

This module supports numerous CRC polynomials, in addition to the most widely used CRC-32-IEEE. See AVCRCId for a list of available polynomials.

@{
"""
const AVCRC = UInt32

const AVCRCId = UInt32
const AV_CRC_8_ATM = 0 % UInt32
const AV_CRC_16_ANSI = 1 % UInt32
const AV_CRC_16_CCITT = 2 % UInt32
const AV_CRC_32_IEEE = 3 % UInt32
const AV_CRC_32_IEEE_LE = 4 % UInt32
const AV_CRC_16_ANSI_LE = 5 % UInt32
const AV_CRC_24_IEEE = 6 % UInt32
const AV_CRC_8_EBU = 7 % UInt32
const AV_CRC_MAX = 8 % UInt32

"""
    av_crc_init(ctx, le::Integer, bits::Integer, poly::Integer, ctx_size::Integer)

Initialize a CRC table.

# Arguments
* `ctx`: must be an array of size sizeof([`AVCRC`](@ref))*257 or sizeof([`AVCRC`](@ref))*1024
* `le`: If 1, the lowest bit represents the coefficient for the highest exponent of the corresponding polynomial (both for poly and actual CRC). If 0, you must swap the CRC parameter and the result of [`av_crc`](@ref) if you need the standard representation (can be simplified in most cases to e.g. bswap16): [`av_bswap32`](@ref)(crc << (32-bits))
* `bits`: number of bits for the CRC
* `poly`: generator polynomial without the x**bits coefficient, in the representation as specified by le
* `ctx_size`: size of ctx in bytes
# Returns
<0 on failure
"""
function av_crc_init(ctx, le::Integer, bits::Integer, poly::Integer, ctx_size::Integer)
    ccall((:av_crc_init, libavutil), Cint, (Ptr{AVCRC}, Cint, Cint, UInt32, Cint), ctx, le, bits, poly, ctx_size)
end

"""
    av_crc_get_table(crc_id::AVCRCId)

Get an initialized standard CRC table.

# Arguments
* `crc_id`: ID of a standard CRC
# Returns
a pointer to the CRC table or NULL on failure
"""
function av_crc_get_table(crc_id::AVCRCId)
    ccall((:av_crc_get_table, libavutil), Ptr{AVCRC}, (AVCRCId,), crc_id)
end

"""
    av_crc(ctx, crc::Integer, buffer, length::Csize_t)

Calculate the CRC of a block.

# Arguments
* `ctx`: initialized [`AVCRC`](@ref) array (see [`av_crc_init`](@ref)())
* `crc`: CRC of previous blocks if any or initial value for CRC
* `buffer`: buffer whose CRC to calculate
* `length`: length of the buffer
# Returns
CRC updated with the data from the given block
# See also
[`av_crc_init`](@ref)() "le" parameter
"""
function av_crc(ctx, crc::Integer, buffer, length::Csize_t)
    ccall((:av_crc, libavutil), UInt32, (Ptr{AVCRC}, UInt32, Ptr{UInt8}, Csize_t), ctx, crc, buffer, length)
end

"""
    AVLumaCoefficients

Struct containing luma coefficients to be used for RGB to YUV/YCoCg, or similar calculations.
"""
struct AVLumaCoefficients
    cr::AVRational
    cg::AVRational
    cb::AVRational
end

"""
    AVCIExy

Struct containing chromaticity x and y values for the standard CIE 1931 chromaticity definition.
"""
struct AVCIExy
    x::AVRational
    y::AVRational
end

"""
    AVPrimaryCoefficients

Struct defining the red, green, and blue primary locations in terms of CIE 1931 chromaticity x and y.
"""
struct AVPrimaryCoefficients
    r::AVCIExy
    g::AVCIExy
    b::AVCIExy
end

"""
Struct defining white point location in terms of CIE 1931 chromaticity x and y.
"""
const AVWhitepointCoefficients = AVCIExy

"""
    AVColorPrimariesDesc

Struct that contains both white point location and primaries location, providing the complete description of a color gamut.
"""
struct AVColorPrimariesDesc
    wp::AVWhitepointCoefficients
    prim::AVPrimaryCoefficients
end

# typedef double ( * av_csp_trc_function ) ( double )
"""
Function pointer representing a double -> double transfer function that performs either an OETF transfer function, or alternatively an inverse EOTF function (in particular, for SMPTE ST 2084 / PQ). This function inputs linear light, and outputs gamma encoded light.

See ITU-T H.273 for more information.
"""
const av_csp_trc_function = Ptr{Cvoid}

"""
    av_csp_luma_coeffs_from_avcsp(csp::AVColorSpace)

Retrieves the Luma coefficients necessary to construct a conversion matrix from an enum constant describing the colorspace.

# Arguments
* `csp`: An enum constant indicating YUV or similar colorspace.
# Returns
The Luma coefficients associated with that colorspace, or NULL if the constant is unknown to libavutil.
"""
function av_csp_luma_coeffs_from_avcsp(csp::AVColorSpace)
    ccall((:av_csp_luma_coeffs_from_avcsp, libavutil), Ptr{AVLumaCoefficients}, (AVColorSpace,), csp)
end

"""
    av_csp_primaries_desc_from_id(prm::AVColorPrimaries)

Retrieves a complete gamut description from an enum constant describing the color primaries.

# Arguments
* `prm`: An enum constant indicating primaries
# Returns
A description of the colorspace gamut associated with that enum constant, or NULL if the constant is unknown to libavutil.
"""
function av_csp_primaries_desc_from_id(prm::AVColorPrimaries)
    ccall((:av_csp_primaries_desc_from_id, libavutil), Ptr{AVColorPrimariesDesc}, (AVColorPrimaries,), prm)
end

"""
    av_csp_primaries_id_from_desc(prm)

Detects which enum [`AVColorPrimaries`](@ref) constant corresponds to the given complete gamut description.

# Arguments
* `prm`: A description of the colorspace gamut
# Returns
The enum constant associated with this gamut, or AVCOL\\_PRI\\_UNSPECIFIED if no clear match can be identified.
# See also
enum [`AVColorPrimaries`](@ref)
"""
function av_csp_primaries_id_from_desc(prm)
    ccall((:av_csp_primaries_id_from_desc, libavutil), AVColorPrimaries, (Ptr{AVColorPrimariesDesc},), prm)
end

"""
    av_csp_approximate_trc_gamma(trc::AVColorTransferCharacteristic)

Determine a suitable 'gamma' value to match the supplied [`AVColorTransferCharacteristic`](@ref).

See Apple Technical Note TN2257 (https://developer.apple.com/library/mac/technotes/tn2257/\\_index.html)

This function returns the gamma exponent for the OETF. For example, sRGB is approximated by gamma 2.2, not by gamma 0.45455.

# Returns
Will return an approximation to the simple gamma function matching the supplied Transfer Characteristic, Will return 0.0 for any we cannot reasonably match against.
"""
function av_csp_approximate_trc_gamma(trc::AVColorTransferCharacteristic)
    ccall((:av_csp_approximate_trc_gamma, libavutil), Cdouble, (AVColorTransferCharacteristic,), trc)
end

"""
    av_csp_trc_func_from_id(trc::AVColorTransferCharacteristic)

Determine the function needed to apply the given [`AVColorTransferCharacteristic`](@ref) to linear input.

The function returned should expect a nominal domain and range of [0.0-1.0] values outside of this range maybe valid depending on the chosen characteristic function.

# Returns
Will return pointer to the function matching the supplied Transfer Characteristic. If unspecified will return NULL:
"""
function av_csp_trc_func_from_id(trc::AVColorTransferCharacteristic)
    ccall((:av_csp_trc_func_from_id, libavutil), av_csp_trc_function, (AVColorTransferCharacteristic,), trc)
end

"""
    av_csp_trc_func_inv_from_id(trc::AVColorTransferCharacteristic)

Returns the mathematical inverse of the corresponding TRC function.
"""
function av_csp_trc_func_inv_from_id(trc::AVColorTransferCharacteristic)
    ccall((:av_csp_trc_func_inv_from_id, libavutil), av_csp_trc_function, (AVColorTransferCharacteristic,), trc)
end

# typedef void ( * av_csp_eotf_function ) ( double Lw , double Lb , double c [ 3 ] )
"""
Function pointer representing an ITU EOTF transfer for a given reference display configuration.

# Arguments
* `Lw`: The white point luminance of the display, in nits (cd/m^2).
* `Lb`: The black point luminance of the display, in nits (cd/m^2).
"""
const av_csp_eotf_function = Ptr{Cvoid}

"""
    av_csp_itu_eotf(trc::AVColorTransferCharacteristic)

Returns the ITU EOTF corresponding to a given TRC. This converts from the signal level [0,1] to the raw output display luminance in nits (cd/m^2). This is done per channel in RGB space, except for AVCOL\\_TRC\\_SMPTE428, which assumes CIE XYZ in- and output.

!!! note

    In general, the resulting function is defined (wherever possible) for out-of-range values, even though these values do not have a physical meaning on the given display. Users should clamp inputs (or outputs) if this behavior is not desired.

This is also the case for functions like PQ, which are defined over an absolute signal range independent of the target display capabilities.

# Returns
A pointer to the function implementing the given TRC, or NULL if no such function is defined.
"""
function av_csp_itu_eotf(trc::AVColorTransferCharacteristic)
    ccall((:av_csp_itu_eotf, libavutil), av_csp_eotf_function, (AVColorTransferCharacteristic,), trc)
end

"""
    av_csp_itu_eotf_inv(trc::AVColorTransferCharacteristic)

Returns the mathematical inverse of the corresponding EOTF.
"""
function av_csp_itu_eotf_inv(trc::AVColorTransferCharacteristic)
    ccall((:av_csp_itu_eotf_inv, libavutil), av_csp_eotf_function, (AVColorTransferCharacteristic,), trc)
end

"""
    AVDES

` lavu_des DES`

` lavu_crypto`

@{
"""
struct AVDES
    round_keys::NTuple{3, NTuple{16, UInt64}}
    triple_des::Cint
end

"""
    av_des_alloc()

Allocate an [`AVDES`](@ref) context.
"""
function av_des_alloc()
    ccall((:av_des_alloc, libavutil), Ptr{AVDES}, ())
end

"""
    av_des_init(d, key, key_bits::Integer, decrypt::Integer)

Initializes an [`AVDES`](@ref) context.

# Arguments
* `d`: pointer to a [`AVDES`](@ref) structure to initialize
* `key`: pointer to the key to use
* `key_bits`: must be 64 or 192
* `decrypt`: 0 for encryption/CBC-MAC, 1 for decryption
# Returns
zero on success, negative value otherwise
"""
function av_des_init(d, key, key_bits::Integer, decrypt::Integer)
    ccall((:av_des_init, libavutil), Cint, (Ptr{AVDES}, Ptr{UInt8}, Cint, Cint), d, key, key_bits, decrypt)
end

"""
    av_des_crypt(d, dst, src, count::Integer, iv, decrypt::Integer)

Encrypts / decrypts using the DES algorithm.

# Arguments
* `d`: pointer to the [`AVDES`](@ref) structure
* `dst`: destination array, can be equal to src, must be 8-byte aligned
* `src`: source array, can be equal to dst, must be 8-byte aligned, may be NULL
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, if NULL then ECB will be used, must be 8-byte aligned
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_des_crypt(d, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_des_crypt, libavutil), Cvoid, (Ptr{AVDES}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), d, dst, src, count, iv, decrypt)
end

"""
    av_des_mac(d, dst, src, count::Integer)

Calculates CBC-MAC using the DES algorithm.

# Arguments
* `d`: pointer to the [`AVDES`](@ref) structure
* `dst`: destination array, can be equal to src, must be 8-byte aligned
* `src`: source array, can be equal to dst, must be 8-byte aligned, may be NULL
* `count`: number of 8 byte blocks
"""
function av_des_mac(d, dst, src, count::Integer)
    ccall((:av_des_mac, libavutil), Cvoid, (Ptr{AVDES}, Ptr{UInt8}, Ptr{UInt8}, Cint), d, dst, src, count)
end

struct AVDetectionBBox
    x::Cint
    y::Cint
    w::Cint
    h::Cint
    detect_label::NTuple{64, Cchar}
    detect_confidence::AVRational
    classify_count::UInt32
    classify_labels::NTuple{4, NTuple{64, Cchar}}
    classify_confidences::NTuple{4, AVRational}
end

struct AVDetectionBBoxHeader
    source::NTuple{256, Cchar}
    nb_bboxes::UInt32
    bboxes_offset::Csize_t
    bbox_size::Csize_t
end

function av_get_detection_bbox(header, idx::Integer)
    ccall((:av_get_detection_bbox, libavutil), Ptr{AVDetectionBBox}, (Ptr{AVDetectionBBoxHeader}, Cuint), header, idx)
end

"""
    av_detection_bbox_alloc(nb_bboxes::Integer, out_size)

Allocates memory for [`AVDetectionBBoxHeader`](@ref), plus an array of {

```c++
 nb_bboxes}
 AVDetectionBBox, and initializes the variables.
 Can be freed with a normal av_free() call.

 @param nb_bboxes number of AVDetectionBBox structures to allocate
 @param out_size if non-NULL, the size in bytes of the resulting data array is
 written here.
 

```
"""
function av_detection_bbox_alloc(nb_bboxes::Integer, out_size)
    ccall((:av_detection_bbox_alloc, libavutil), Ptr{AVDetectionBBoxHeader}, (UInt32, Ptr{Csize_t}), nb_bboxes, out_size)
end

"""
    av_detection_bbox_create_side_data(frame, nb_bboxes::Integer)

Allocates memory for [`AVDetectionBBoxHeader`](@ref), plus an array of {

```c++
 nb_bboxes}
 AVDetectionBBox, in the given AVFrame {@code frame} as AVFrameSideData of type
 AV_FRAME_DATA_DETECTION_BBOXES and initializes the variables.
 

```
"""
function av_detection_bbox_create_side_data(frame, nb_bboxes::Integer)
    ccall((:av_detection_bbox_create_side_data, libavutil), Ptr{AVDetectionBBoxHeader}, (Ptr{AVFrame}, UInt32), frame, nb_bboxes)
end

"""
    AVDictionaryEntry

@}
"""
struct AVDictionaryEntry
    key::Cstring
    value::Cstring
end

"""
    av_dict_get(m, key, prev, flags::Integer)

Get a dictionary entry with matching key.

The returned entry key or value must not be changed, or it will cause undefined behavior.

# Arguments
* `prev`: Set to the previous matching element to find the next. If set to NULL the first matching element is returned.
* `key`: Matching key
* `flags`: A collection of AV\\_DICT\\_* flags controlling how the entry is retrieved
# Returns
Found entry or NULL in case no matching entry was found in the dictionary
"""
function av_dict_get(m, key, prev, flags::Integer)
    ccall((:av_dict_get, libavutil), Ptr{AVDictionaryEntry}, (Ptr{AVDictionary}, Cstring, Ptr{AVDictionaryEntry}, Cint), m, key, prev, flags)
end

"""
    av_dict_iterate(m, prev)

Iterate over a dictionary

Iterates through all entries in the dictionary.

!!! warning

    The returned [`AVDictionaryEntry`](@ref) key/value must not be changed.

!!! warning

    As [`av_dict_set`](@ref)() invalidates all previous entries returned by this function, it must not be called while iterating over the dict.

Typical usage:

```c++
 const AVDictionaryEntry *e = NULL;
 while ((e = av_dict_iterate(m, e))) {
     // ...
 }
```

\\retvalAVDictionaryEntry* The next element in the dictionary

\\retvalNULL No more elements in the dictionary

# Arguments
* `m`: The dictionary to iterate over
* `prev`: Pointer to the previous [`AVDictionaryEntry`](@ref), NULL initially
"""
function av_dict_iterate(m, prev)
    ccall((:av_dict_iterate, libavutil), Ptr{AVDictionaryEntry}, (Ptr{AVDictionary}, Ptr{AVDictionaryEntry}), m, prev)
end

"""
    av_dict_count(m)

Get number of entries in dictionary.

# Arguments
* `m`: dictionary
# Returns
number of entries in dictionary
"""
function av_dict_count(m)
    ccall((:av_dict_count, libavutil), Cint, (Ptr{AVDictionary},), m)
end

"""
    av_dict_set(pm, key, value, flags::Integer)

Set the given entry in *pm, overwriting an existing entry.

Note: If [`AV_DICT_DONT_STRDUP_KEY`](@ref) or [`AV_DICT_DONT_STRDUP_VAL`](@ref) is set, these arguments will be freed on error.

!!! warning

    Adding a new entry to a dictionary invalidates all existing entries previously returned with [`av_dict_get`](@ref)() or [`av_dict_iterate`](@ref)().

# Arguments
* `pm`: Pointer to a pointer to a dictionary struct. If *pm is NULL a dictionary struct is allocated and put in *pm.
* `key`: Entry key to add to *pm (will either be av\\_strduped or added as a new key depending on flags)
* `value`: Entry value to add to *pm (will be av\\_strduped or added as a new key depending on flags). Passing a NULL value will cause an existing entry to be deleted.
# Returns
>= 0 on success otherwise an error code <0
"""
function av_dict_set(pm, key, value, flags::Integer)
    ccall((:av_dict_set, libavutil), Cint, (Ptr{Ptr{AVDictionary}}, Cstring, Cstring, Cint), pm, key, value, flags)
end

"""
    av_dict_set_int(pm, key, value::Int64, flags::Integer)

Convenience wrapper for [`av_dict_set`](@ref)() that converts the value to a string and stores it.

Note: If ::[`AV_DICT_DONT_STRDUP_KEY`](@ref) is set, key will be freed on error.
"""
function av_dict_set_int(pm, key, value::Int64, flags::Integer)
    ccall((:av_dict_set_int, libavutil), Cint, (Ptr{Ptr{AVDictionary}}, Cstring, Int64, Cint), pm, key, value, flags)
end

"""
    av_dict_parse_string(pm, str, key_val_sep, pairs_sep, flags::Integer)

Parse the key/value pairs list and add the parsed entries to a dictionary.

In case of failure, all the successfully set entries are stored in *pm. You may need to manually free the created dictionary.

# Arguments
* `key_val_sep`: A 0-terminated list of characters used to separate key from value
* `pairs_sep`: A 0-terminated list of characters used to separate two pairs from each other
* `flags`: Flags to use when adding to the dictionary. ::[`AV_DICT_DONT_STRDUP_KEY`](@ref) and ::[`AV_DICT_DONT_STRDUP_VAL`](@ref) are ignored since the key/value tokens will always be duplicated.
# Returns
0 on success, negative [`AVERROR`](@ref) code on failure
"""
function av_dict_parse_string(pm, str, key_val_sep, pairs_sep, flags::Integer)
    ccall((:av_dict_parse_string, libavutil), Cint, (Ptr{Ptr{AVDictionary}}, Cstring, Cstring, Cstring, Cint), pm, str, key_val_sep, pairs_sep, flags)
end

"""
    av_dict_copy(dst, src, flags::Integer)

Copy entries from one [`AVDictionary`](@ref) struct into another.

!!! note

    Metadata is read using the ::[`AV_DICT_IGNORE_SUFFIX`](@ref) flag

# Arguments
* `dst`: Pointer to a pointer to a [`AVDictionary`](@ref) struct to copy into. If *dst is NULL, this function will allocate a struct for you and put it in *dst
* `src`: Pointer to the source [`AVDictionary`](@ref) struct to copy items from.
* `flags`: Flags to use when setting entries in *dst
# Returns
0 on success, negative [`AVERROR`](@ref) code on failure. If dst was allocated by this function, callers should free the associated memory.
"""
function av_dict_copy(dst, src, flags::Integer)
    ccall((:av_dict_copy, libavutil), Cint, (Ptr{Ptr{AVDictionary}}, Ptr{AVDictionary}, Cint), dst, src, flags)
end

"""
    av_dict_free(m)

Free all the memory allocated for an [`AVDictionary`](@ref) struct and all keys and values.
"""
function av_dict_free(m)
    ccall((:av_dict_free, libavutil), Cvoid, (Ptr{Ptr{AVDictionary}},), m)
end

"""
    av_dict_get_string(m, buffer, key_val_sep::Cchar, pairs_sep::Cchar)

Get dictionary entries as a string.

Create a string containing dictionary's entries. Such string may be passed back to [`av_dict_parse_string`](@ref)().

!!! note

    String is escaped with backslashes ('\\').

!!! warning

    Separators cannot be neither '\\' nor '\\0'. They also cannot be the same.

# Arguments
* `m`:\\[in\\] The dictionary
* `buffer`:\\[out\\] Pointer to buffer that will be allocated with string containing entries. Buffer must be freed by the caller when is no longer needed.
* `key_val_sep`:\\[in\\] Character used to separate key from value
* `pairs_sep`:\\[in\\] Character used to separate two pairs from each other
# Returns
>= 0 on success, negative on error
"""
function av_dict_get_string(m, buffer, key_val_sep::Cchar, pairs_sep::Cchar)
    ccall((:av_dict_get_string, libavutil), Cint, (Ptr{AVDictionary}, Ptr{Cstring}, Cchar, Cchar), m, buffer, key_val_sep, pairs_sep)
end

"""
    av_display_rotation_get(matrix)

Extract the rotation component of the transformation matrix.

!!! note

    floating point numbers are inherently inexact, so callers are recommended to round the return value to nearest integer before use.

# Arguments
* `matrix`: the transformation matrix
# Returns
the angle (in degrees) by which the transformation rotates the frame counterclockwise. The angle will be in range [-180.0, 180.0], or NaN if the matrix is singular.
"""
function av_display_rotation_get(matrix)
    ccall((:av_display_rotation_get, libavutil), Cdouble, (Ptr{Int32},), matrix)
end

"""
    av_display_rotation_set(matrix, angle::Cdouble)

Initialize a transformation matrix describing a pure clockwise rotation by the specified angle (in degrees).

# Arguments
* `matrix`:\\[out\\] a transformation matrix (will be fully overwritten by this function)
* `angle`: rotation angle in degrees.
"""
function av_display_rotation_set(matrix, angle::Cdouble)
    ccall((:av_display_rotation_set, libavutil), Cvoid, (Ptr{Int32}, Cdouble), matrix, angle)
end

"""
    av_display_matrix_flip(matrix, hflip::Integer, vflip::Integer)

Flip the input matrix horizontally and/or vertically.

# Arguments
* `matrix`:\\[in,out\\] a transformation matrix
* `hflip`: whether the matrix should be flipped horizontally
* `vflip`: whether the matrix should be flipped vertically
"""
function av_display_matrix_flip(matrix, hflip::Integer, vflip::Integer)
    ccall((:av_display_matrix_flip, libavutil), Cvoid, (Ptr{Int32}, Cint, Cint), matrix, hflip, vflip)
end

struct AVDOVIDecoderConfigurationRecord
    dv_version_major::UInt8
    dv_version_minor::UInt8
    dv_profile::UInt8
    dv_level::UInt8
    rpu_present_flag::UInt8
    el_present_flag::UInt8
    bl_present_flag::UInt8
    dv_bl_signal_compatibility_id::UInt8
    dv_md_compression::UInt8
end

const AVDOVICompression = UInt32
const AV_DOVI_COMPRESSION_NONE = 0 % UInt32
const AV_DOVI_COMPRESSION_LIMITED = 1 % UInt32
const AV_DOVI_COMPRESSION_RESERVED = 2 % UInt32
const AV_DOVI_COMPRESSION_EXTENDED = 3 % UInt32

"""
    av_dovi_alloc(size)

Allocate a [`AVDOVIDecoderConfigurationRecord`](@ref) structure and initialize its fields to default values.

# Returns
the newly allocated struct or NULL on failure
"""
function av_dovi_alloc(size)
    ccall((:av_dovi_alloc, libavutil), Ptr{AVDOVIDecoderConfigurationRecord}, (Ptr{Csize_t},), size)
end

"""
    AVDOVIRpuDataHeader

Dolby Vision RPU data header.

!!! note

    sizeof([`AVDOVIRpuDataHeader`](@ref)) is not part of the public ABI.
"""
struct AVDOVIRpuDataHeader
    rpu_type::UInt8
    rpu_format::UInt16
    vdr_rpu_profile::UInt8
    vdr_rpu_level::UInt8
    chroma_resampling_explicit_filter_flag::UInt8
    coef_data_type::UInt8
    coef_log2_denom::UInt8
    vdr_rpu_normalized_idc::UInt8
    bl_video_full_range_flag::UInt8
    bl_bit_depth::UInt8
    el_bit_depth::UInt8
    vdr_bit_depth::UInt8
    spatial_resampling_filter_flag::UInt8
    el_spatial_resampling_filter_flag::UInt8
    disable_residual_flag::UInt8
    ext_mapping_idc_0_4::UInt8
    ext_mapping_idc_5_7::UInt8
end

const AVDOVIMappingMethod = UInt32
const AV_DOVI_MAPPING_POLYNOMIAL = 0 % UInt32
const AV_DOVI_MAPPING_MMR = 1 % UInt32

struct AVDOVIReshapingCurve
    num_pivots::UInt8
    pivots::NTuple{9, UInt16}
    mapping_idc::NTuple{8, AVDOVIMappingMethod}
    poly_order::NTuple{8, UInt8}
    poly_coef::NTuple{8, NTuple{3, Int64}}
    mmr_order::NTuple{8, UInt8}
    mmr_constant::NTuple{8, Int64}
    mmr_coef::NTuple{8, NTuple{3, NTuple{7, Int64}}}
end

const AVDOVINLQMethod = Int32
const AV_DOVI_NLQ_NONE = -1 % Int32
const AV_DOVI_NLQ_LINEAR_DZ = 0 % Int32

"""
    AVDOVINLQParams

Coefficients of the non-linear inverse quantization. For the interpretation of these, see ETSI GS CCM 001.
"""
struct AVDOVINLQParams
    nlq_offset::UInt16
    vdr_in_max::UInt64
    linear_deadzone_slope::UInt64
    linear_deadzone_threshold::UInt64
end

"""
    AVDOVIDataMapping

Dolby Vision RPU data mapping parameters.

!!! note

    sizeof([`AVDOVIDataMapping`](@ref)) is not part of the public ABI.
"""
struct AVDOVIDataMapping
    vdr_rpu_id::UInt8
    mapping_color_space::UInt8
    mapping_chroma_format_idc::UInt8
    curves::NTuple{3, AVDOVIReshapingCurve}
    nlq_method_idc::AVDOVINLQMethod
    num_x_partitions::UInt32
    num_y_partitions::UInt32
    nlq::NTuple{3, AVDOVINLQParams}
    nlq_pivots::NTuple{2, UInt16}
end

"""
    AVDOVIColorMetadata

Dolby Vision RPU colorspace metadata parameters.

!!! note

    sizeof([`AVDOVIColorMetadata`](@ref)) is not part of the public ABI.
"""
struct AVDOVIColorMetadata
    dm_metadata_id::UInt8
    scene_refresh_flag::UInt8
    ycc_to_rgb_matrix::NTuple{9, AVRational}
    ycc_to_rgb_offset::NTuple{3, AVRational}
    rgb_to_lms_matrix::NTuple{9, AVRational}
    signal_eotf::UInt16
    signal_eotf_param0::UInt16
    signal_eotf_param1::UInt16
    signal_eotf_param2::UInt32
    signal_bit_depth::UInt8
    signal_color_space::UInt8
    signal_chroma_format::UInt8
    signal_full_range_flag::UInt8
    source_min_pq::UInt16
    source_max_pq::UInt16
    source_diagonal::UInt16
end

struct AVDOVIDmLevel1
    min_pq::UInt16
    max_pq::UInt16
    avg_pq::UInt16
end

struct AVDOVIDmLevel2
    target_max_pq::UInt16
    trim_slope::UInt16
    trim_offset::UInt16
    trim_power::UInt16
    trim_chroma_weight::UInt16
    trim_saturation_gain::UInt16
    ms_weight::Int16
end

struct AVDOVIDmLevel3
    min_pq_offset::UInt16
    max_pq_offset::UInt16
    avg_pq_offset::UInt16
end

struct AVDOVIDmLevel4
    anchor_pq::UInt16
    anchor_power::UInt16
end

struct AVDOVIDmLevel5
    left_offset::UInt16
    right_offset::UInt16
    top_offset::UInt16
    bottom_offset::UInt16
end

struct AVDOVIDmLevel6
    max_luminance::UInt16
    min_luminance::UInt16
    max_cll::UInt16
    max_fall::UInt16
end

struct AVDOVIDmLevel8
    target_display_index::UInt8
    trim_slope::UInt16
    trim_offset::UInt16
    trim_power::UInt16
    trim_chroma_weight::UInt16
    trim_saturation_gain::UInt16
    ms_weight::UInt16
    target_mid_contrast::UInt16
    clip_trim::UInt16
    saturation_vector_field::NTuple{6, UInt8}
    hue_vector_field::NTuple{6, UInt8}
end

struct AVDOVIDmLevel9
    source_primary_index::UInt8
    source_display_primaries::AVColorPrimariesDesc
end

struct AVDOVIDmLevel10
    target_display_index::UInt8
    target_max_pq::UInt16
    target_min_pq::UInt16
    target_primary_index::UInt8
    target_display_primaries::AVColorPrimariesDesc
end

struct AVDOVIDmLevel11
    content_type::UInt8
    whitepoint::UInt8
    reference_mode_flag::UInt8
    sharpness::UInt8
    noise_reduction::UInt8
    mpeg_noise_reduction::UInt8
    frame_rate_conversion::UInt8
    brightness::UInt8
    color::UInt8
end

struct AVDOVIDmLevel254
    dm_mode::UInt8
    dm_version_index::UInt8
end

struct AVDOVIDmLevel255
    dm_run_mode::UInt8
    dm_run_version::UInt8
    dm_debug::NTuple{4, UInt8}
end

"""
    AVDOVIDmData

Dolby Vision metadata extension block. Dynamic extension blocks may change from frame to frame, while static blocks are constant throughout the entire sequence.

!!! note

    sizeof([`AVDOVIDmData`](@ref)) is not part of the public API.
"""
struct AVDOVIDmData
    data::NTuple{76, UInt8}
end

function Base.getproperty(x::Ptr{AVDOVIDmData}, f::Symbol)
    f === :level && return Ptr{UInt8}(x + 0)
    f === :l1 && return Ptr{AVDOVIDmLevel1}(x + 4)
    f === :l2 && return Ptr{AVDOVIDmLevel2}(x + 4)
    f === :l3 && return Ptr{AVDOVIDmLevel3}(x + 4)
    f === :l4 && return Ptr{AVDOVIDmLevel4}(x + 4)
    f === :l5 && return Ptr{AVDOVIDmLevel5}(x + 4)
    f === :l6 && return Ptr{AVDOVIDmLevel6}(x + 4)
    f === :l8 && return Ptr{AVDOVIDmLevel8}(x + 4)
    f === :l9 && return Ptr{AVDOVIDmLevel9}(x + 4)
    f === :l10 && return Ptr{AVDOVIDmLevel10}(x + 4)
    f === :l11 && return Ptr{AVDOVIDmLevel11}(x + 4)
    f === :l254 && return Ptr{AVDOVIDmLevel254}(x + 4)
    f === :l255 && return Ptr{AVDOVIDmLevel255}(x + 4)
    return getfield(x, f)
end

function Base.getproperty(x::AVDOVIDmData, f::Symbol)
    r = Ref{AVDOVIDmData}(x)
    ptr = Base.unsafe_convert(Ptr{AVDOVIDmData}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVDOVIDmData}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVDOVIDmData, private::Bool = false)
    (:level, :l1, :l2, :l3, :l4, :l5, :l6, :l8, :l9, :l10, :l11, :l254, :l255, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVDOVIMetadata

Combined struct representing a combination of header, mapping and color metadata, for attaching to frames as side data.

!!! note

    The struct must be allocated with [`av_dovi_metadata_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVDOVIMetadata
    header_offset::Csize_t
    mapping_offset::Csize_t
    color_offset::Csize_t
    ext_block_offset::Csize_t
    ext_block_size::Csize_t
    num_ext_blocks::Cint
end

function av_dovi_get_header(data)
    ccall((:av_dovi_get_header, libavutil), Ptr{AVDOVIRpuDataHeader}, (Ptr{AVDOVIMetadata},), data)
end

function av_dovi_get_mapping(data)
    ccall((:av_dovi_get_mapping, libavutil), Ptr{AVDOVIDataMapping}, (Ptr{AVDOVIMetadata},), data)
end

function av_dovi_get_color(data)
    ccall((:av_dovi_get_color, libavutil), Ptr{AVDOVIColorMetadata}, (Ptr{AVDOVIMetadata},), data)
end

function av_dovi_get_ext(data, index::Integer)
    ccall((:av_dovi_get_ext, libavutil), Ptr{AVDOVIDmData}, (Ptr{AVDOVIMetadata}, Cint), data, index)
end

"""
    av_dovi_find_level(data, level::UInt8)

Find an extension block with a given level, or NULL. In the case of multiple extension blocks, only the first is returned.
"""
function av_dovi_find_level(data, level::UInt8)
    ccall((:av_dovi_find_level, libavutil), Ptr{AVDOVIDmData}, (Ptr{AVDOVIMetadata}, UInt8), data, level)
end

"""
    av_dovi_metadata_alloc(size)

Allocate an [`AVDOVIMetadata`](@ref) structure and initialize its fields to default values.

# Arguments
* `size`: If this parameter is non-NULL, the size in bytes of the allocated struct will be written here on success
# Returns
the newly allocated struct or NULL on failure
"""
function av_dovi_metadata_alloc(size)
    ccall((:av_dovi_metadata_alloc, libavutil), Ptr{AVDOVIMetadata}, (Ptr{Csize_t},), size)
end

"""
    AVDownmixType

Possible downmix types.
"""
const AVDownmixType = UInt32
const AV_DOWNMIX_TYPE_UNKNOWN = 0 % UInt32
const AV_DOWNMIX_TYPE_LORO = 1 % UInt32
const AV_DOWNMIX_TYPE_LTRT = 2 % UInt32
const AV_DOWNMIX_TYPE_DPLII = 3 % UInt32
const AV_DOWNMIX_TYPE_NB = 4 % UInt32

"""
    AVDownmixInfo

This structure describes optional metadata relevant to a downmix procedure.

All fields are set by the decoder to the value indicated in the audio bitstream (if present), or to a "sane" default otherwise.
"""
struct AVDownmixInfo
    preferred_downmix_type::AVDownmixType
    center_mix_level::Cdouble
    center_mix_level_ltrt::Cdouble
    surround_mix_level::Cdouble
    surround_mix_level_ltrt::Cdouble
    lfe_mix_level::Cdouble
end

"""
    av_downmix_info_update_side_data(frame)

Get a frame's AV\\_FRAME\\_DATA\\_DOWNMIX\\_INFO side data for editing.

If the side data is absent, it is created and added to the frame.

# Arguments
* `frame`: the frame for which the side data is to be obtained or created
# Returns
the [`AVDownmixInfo`](@ref) structure to be edited by the caller, or NULL if the structure cannot be allocated.
"""
function av_downmix_info_update_side_data(frame)
    ccall((:av_downmix_info_update_side_data, libavutil), Ptr{AVDownmixInfo}, (Ptr{AVFrame},), frame)
end

struct AVSubsampleEncryptionInfo
    bytes_of_clear_data::Cuint
    bytes_of_protected_data::Cuint
end

"""
    AVEncryptionInfo

This describes encryption info for a packet. This contains frame-specific info for how to decrypt the packet before passing it to the decoder.

The size of this struct is not part of the public ABI.
"""
struct AVEncryptionInfo
    scheme::UInt32
    crypt_byte_block::UInt32
    skip_byte_block::UInt32
    key_id::Ptr{UInt8}
    key_id_size::UInt32
    iv::Ptr{UInt8}
    iv_size::UInt32
    subsamples::Ptr{AVSubsampleEncryptionInfo}
    subsample_count::UInt32
end

"""
    AVEncryptionInitInfo

This describes info used to initialize an encryption key system.

The size of this struct is not part of the public ABI.
"""
struct AVEncryptionInitInfo
    system_id::Ptr{UInt8}
    system_id_size::UInt32
    key_ids::Ptr{Ptr{UInt8}}
    num_key_ids::UInt32
    key_id_size::UInt32
    data::Ptr{UInt8}
    data_size::UInt32
    next::Ptr{AVEncryptionInitInfo}
end

"""
    av_encryption_info_alloc(subsample_count::Integer, key_id_size::Integer, iv_size::Integer)

Allocates an [`AVEncryptionInfo`](@ref) structure and sub-pointers to hold the given number of subsamples. This will allocate pointers for the key ID, IV, and subsample entries, set the size members, and zero-initialize the rest.

# Arguments
* `subsample_count`: The number of subsamples.
* `key_id_size`: The number of bytes in the key ID, should be 16.
* `iv_size`: The number of bytes in the IV, should be 16.
# Returns
The new [`AVEncryptionInfo`](@ref) structure, or NULL on error.
"""
function av_encryption_info_alloc(subsample_count::Integer, key_id_size::Integer, iv_size::Integer)
    ccall((:av_encryption_info_alloc, libavutil), Ptr{AVEncryptionInfo}, (UInt32, UInt32, UInt32), subsample_count, key_id_size, iv_size)
end

"""
    av_encryption_info_clone(info)

Allocates an [`AVEncryptionInfo`](@ref) structure with a copy of the given data.

# Returns
The new [`AVEncryptionInfo`](@ref) structure, or NULL on error.
"""
function av_encryption_info_clone(info)
    ccall((:av_encryption_info_clone, libavutil), Ptr{AVEncryptionInfo}, (Ptr{AVEncryptionInfo},), info)
end

"""
    av_encryption_info_free(info)

Frees the given encryption info object. This MUST NOT be used to free the side-data data pointer, that should use normal side-data methods.
"""
function av_encryption_info_free(info)
    ccall((:av_encryption_info_free, libavutil), Cvoid, (Ptr{AVEncryptionInfo},), info)
end

"""
    av_encryption_info_get_side_data(side_data, side_data_size::Csize_t)

Creates a copy of the [`AVEncryptionInfo`](@ref) that is contained in the given side data. The resulting object should be passed to [`av_encryption_info_free`](@ref)() when done.

# Returns
The new [`AVEncryptionInfo`](@ref) structure, or NULL on error.
"""
function av_encryption_info_get_side_data(side_data, side_data_size::Csize_t)
    ccall((:av_encryption_info_get_side_data, libavutil), Ptr{AVEncryptionInfo}, (Ptr{UInt8}, Csize_t), side_data, side_data_size)
end

"""
    av_encryption_info_add_side_data(info, side_data_size)

Allocates and initializes side data that holds a copy of the given encryption info. The resulting pointer should be either freed using [`av_free`](@ref) or given to [`av_packet_add_side_data`](@ref)().

# Returns
The new side-data pointer, or NULL.
"""
function av_encryption_info_add_side_data(info, side_data_size)
    ccall((:av_encryption_info_add_side_data, libavutil), Ptr{UInt8}, (Ptr{AVEncryptionInfo}, Ptr{Csize_t}), info, side_data_size)
end

"""
    av_encryption_init_info_alloc(system_id_size::Integer, num_key_ids::Integer, key_id_size::Integer, data_size::Integer)

Allocates an [`AVEncryptionInitInfo`](@ref) structure and sub-pointers to hold the given sizes. This will allocate pointers and set all the fields.

# Returns
The new [`AVEncryptionInitInfo`](@ref) structure, or NULL on error.
"""
function av_encryption_init_info_alloc(system_id_size::Integer, num_key_ids::Integer, key_id_size::Integer, data_size::Integer)
    ccall((:av_encryption_init_info_alloc, libavutil), Ptr{AVEncryptionInitInfo}, (UInt32, UInt32, UInt32, UInt32), system_id_size, num_key_ids, key_id_size, data_size)
end

"""
    av_encryption_init_info_free(info)

Frees the given encryption init info object. This MUST NOT be used to free the side-data data pointer, that should use normal side-data methods.
"""
function av_encryption_init_info_free(info)
    ccall((:av_encryption_init_info_free, libavutil), Cvoid, (Ptr{AVEncryptionInitInfo},), info)
end

"""
    av_encryption_init_info_get_side_data(side_data, side_data_size::Csize_t)

Creates a copy of the [`AVEncryptionInitInfo`](@ref) that is contained in the given side data. The resulting object should be passed to [`av_encryption_init_info_free`](@ref)() when done.

# Returns
The new [`AVEncryptionInitInfo`](@ref) structure, or NULL on error.
"""
function av_encryption_init_info_get_side_data(side_data, side_data_size::Csize_t)
    ccall((:av_encryption_init_info_get_side_data, libavutil), Ptr{AVEncryptionInitInfo}, (Ptr{UInt8}, Csize_t), side_data, side_data_size)
end

"""
    av_encryption_init_info_add_side_data(info, side_data_size)

Allocates and initializes side data that holds a copy of the given encryption init info. The resulting pointer should be either freed using [`av_free`](@ref) or given to [`av_packet_add_side_data`](@ref)().

# Returns
The new side-data pointer, or NULL.
"""
function av_encryption_init_info_add_side_data(info, side_data_size)
    ccall((:av_encryption_init_info_add_side_data, libavutil), Ptr{UInt8}, (Ptr{AVEncryptionInitInfo}, Ptr{Csize_t}), info, side_data_size)
end

"""
    av_make_error_string(errbuf, errbuf_size::Csize_t, errnum::Integer)

Fill the provided buffer with a string containing an error string corresponding to the [`AVERROR`](@ref) code errnum.

# Arguments
* `errbuf`: a buffer
* `errbuf_size`: size in bytes of errbuf
* `errnum`: error code to describe
# Returns
the buffer in input, filled with the error description
# See also
[`av_strerror`](@ref)()
"""
function av_make_error_string(errbuf, errbuf_size::Csize_t, errnum::Integer)
    ccall((:av_make_error_string, libavutil), Cstring, (Cstring, Csize_t, Cint), errbuf, errbuf_size, errnum)
end

"""
    av_strerror(errnum::Integer, errbuf, errbuf_size::Csize_t)

Put a description of the [`AVERROR`](@ref) code errnum in errbuf. In case of failure the global variable errno is set to indicate the error. Even in case of failure [`av_strerror`](@ref)() will print a generic error message indicating the errnum provided to errbuf.

# Arguments
* `errnum`: error code to describe
* `errbuf`: buffer to which description is written
* `errbuf_size`: the size in bytes of errbuf
# Returns
0 on success, a negative value if a description for errnum cannot be found
"""
function av_strerror(errnum::Integer, errbuf, errbuf_size::Csize_t)
    ccall((:av_strerror, libavutil), Cint, (Cint, Cstring, Csize_t), errnum, errbuf, errbuf_size)
end

mutable struct AVExpr end

"""
    av_expr_parse_and_eval(res, s, const_names, const_values, func1_names, funcs1, func2_names, funcs2, opaque, log_offset::Integer, log_ctx)

Parse and evaluate an expression. Note, this is significantly slower than [`av_expr_eval`](@ref)().

# Arguments
* `res`: a pointer to a double where is put the result value of the expression, or NAN in case of error
* `s`: expression as a zero terminated string, for example "1+2^3+5*5+sin(2/3)"
* `const_names`: NULL terminated array of zero terminated strings of constant identifiers, for example {"PI", "E", 0}
* `const_values`: a zero terminated array of values for the identifiers from const\\_names
* `func1_names`: NULL terminated array of zero terminated strings of funcs1 identifiers
* `funcs1`: NULL terminated array of function pointers for functions which take 1 argument
* `func2_names`: NULL terminated array of zero terminated strings of funcs2 identifiers
* `funcs2`: NULL terminated array of function pointers for functions which take 2 arguments
* `opaque`: a pointer which will be passed to all functions from funcs1 and funcs2
* `log_offset`: log level offset, can be used to silence error messages
* `log_ctx`: parent logging context
# Returns
>= 0 in case of success, a negative value corresponding to an [`AVERROR`](@ref) code otherwise
"""
function av_expr_parse_and_eval(res, s, const_names, const_values, func1_names, funcs1, func2_names, funcs2, opaque, log_offset::Integer, log_ctx)
    ccall((:av_expr_parse_and_eval, libavutil), Cint, (Ptr{Cdouble}, Cstring, Ptr{Cstring}, Ptr{Cdouble}, Ptr{Cstring}, Ptr{Ptr{Cvoid}}, Ptr{Cstring}, Ptr{Ptr{Cvoid}}, Ptr{Cvoid}, Cint, Ptr{Cvoid}), res, s, const_names, const_values, func1_names, funcs1, func2_names, funcs2, opaque, log_offset, log_ctx)
end

"""
    av_expr_parse(expr, s, const_names, func1_names, funcs1, func2_names, funcs2, log_offset::Integer, log_ctx)

Parse an expression.

# Arguments
* `expr`: a pointer where is put an [`AVExpr`](@ref) containing the parsed value in case of successful parsing, or NULL otherwise. The pointed to [`AVExpr`](@ref) must be freed with [`av_expr_free`](@ref)() by the user when it is not needed anymore.
* `s`: expression as a zero terminated string, for example "1+2^3+5*5+sin(2/3)"
* `const_names`: NULL terminated array of zero terminated strings of constant identifiers, for example {"PI", "E", 0}
* `func1_names`: NULL terminated array of zero terminated strings of funcs1 identifiers
* `funcs1`: NULL terminated array of function pointers for functions which take 1 argument
* `func2_names`: NULL terminated array of zero terminated strings of funcs2 identifiers
* `funcs2`: NULL terminated array of function pointers for functions which take 2 arguments
* `log_offset`: log level offset, can be used to silence error messages
* `log_ctx`: parent logging context
# Returns
>= 0 in case of success, a negative value corresponding to an [`AVERROR`](@ref) code otherwise
"""
function av_expr_parse(expr, s, const_names, func1_names, funcs1, func2_names, funcs2, log_offset::Integer, log_ctx)
    ccall((:av_expr_parse, libavutil), Cint, (Ptr{Ptr{AVExpr}}, Cstring, Ptr{Cstring}, Ptr{Cstring}, Ptr{Ptr{Cvoid}}, Ptr{Cstring}, Ptr{Ptr{Cvoid}}, Cint, Ptr{Cvoid}), expr, s, const_names, func1_names, funcs1, func2_names, funcs2, log_offset, log_ctx)
end

"""
    av_expr_eval(e, const_values, opaque)

Evaluate a previously parsed expression.

# Arguments
* `e`: the [`AVExpr`](@ref) to evaluate
* `const_values`: a zero terminated array of values for the identifiers from [`av_expr_parse`](@ref)() const\\_names
* `opaque`: a pointer which will be passed to all functions from funcs1 and funcs2
# Returns
the value of the expression
"""
function av_expr_eval(e, const_values, opaque)
    ccall((:av_expr_eval, libavutil), Cdouble, (Ptr{AVExpr}, Ptr{Cdouble}, Ptr{Cvoid}), e, const_values, opaque)
end

"""
    av_expr_count_vars(e, counter, size::Integer)

Track the presence of variables and their number of occurrences in a parsed expression

# Arguments
* `e`: the [`AVExpr`](@ref) to track variables in
* `counter`: a zero-initialized array where the count of each variable will be stored
* `size`: size of array
# Returns
0 on success, a negative value indicates that no expression or array was passed or size was zero
"""
function av_expr_count_vars(e, counter, size::Integer)
    ccall((:av_expr_count_vars, libavutil), Cint, (Ptr{AVExpr}, Ptr{Cuint}, Cint), e, counter, size)
end

"""
    av_expr_count_func(e, counter, size::Integer, arg::Integer)

Track the presence of user provided functions and their number of occurrences in a parsed expression.

# Arguments
* `e`: the [`AVExpr`](@ref) to track user provided functions in
* `counter`: a zero-initialized array where the count of each function will be stored if you passed 5 functions with 2 arguments to [`av_expr_parse`](@ref)() then for arg=2 this will use up to 5 entries.
* `size`: size of array
* `arg`: number of arguments the counted functions have
# Returns
0 on success, a negative value indicates that no expression or array was passed or size was zero
"""
function av_expr_count_func(e, counter, size::Integer, arg::Integer)
    ccall((:av_expr_count_func, libavutil), Cint, (Ptr{AVExpr}, Ptr{Cuint}, Cint, Cint), e, counter, size, arg)
end

"""
    av_expr_free(e)

Free a parsed expression previously created with [`av_expr_parse`](@ref)().
"""
function av_expr_free(e)
    ccall((:av_expr_free, libavutil), Cvoid, (Ptr{AVExpr},), e)
end

"""
    av_strtod(numstr, tail)

Parse the string in numstr and return its value as a double. If the string is empty, contains only whitespaces, or does not contain an initial substring that has the expected syntax for a floating-point number, no conversion is performed. In this case, returns a value of zero and the value returned in tail is the value of numstr.

# Arguments
* `numstr`: a string representing a number, may contain one of the International System number postfixes, for example 'K', 'M', 'G'. If 'i' is appended after the postfix, powers of 2 are used instead of powers of 10. The 'B' postfix multiplies the value by 8, and can be appended after another postfix or used alone. This allows using for example 'KB', 'MiB', 'G' and 'B' as postfix.
* `tail`: if non-NULL puts here the pointer to the char next after the last parsed character
"""
function av_strtod(numstr, tail)
    ccall((:av_strtod, libavutil), Cdouble, (Cstring, Ptr{Cstring}), numstr, tail)
end

mutable struct AVExecutor end

struct AVTask
    next::Ptr{AVTask}
end

struct AVTaskCallbacks
    user_data::Ptr{Cvoid}
    local_context_size::Cint
    priority_higher::Ptr{Cvoid}
    ready::Ptr{Cvoid}
    run::Ptr{Cvoid}
end

"""
    av_executor_alloc(callbacks, thread_count::Integer)

Alloc executor

# Arguments
* `callbacks`: callback structure for executor
* `thread_count`: worker thread number, 0 for run on caller's thread directly
# Returns
return the executor
"""
function av_executor_alloc(callbacks, thread_count::Integer)
    ccall((:av_executor_alloc, libavutil), Ptr{AVExecutor}, (Ptr{AVTaskCallbacks}, Cint), callbacks, thread_count)
end

"""
    av_executor_free(e)

Free executor

# Arguments
* `e`: pointer to executor
"""
function av_executor_free(e)
    ccall((:av_executor_free, libavutil), Cvoid, (Ptr{Ptr{AVExecutor}},), e)
end

"""
    av_executor_execute(e, t)

Add task to executor

# Arguments
* `e`: pointer to executor
* `t`: pointer to task. If NULL, it will wakeup one work thread
"""
function av_executor_execute(e, t)
    ccall((:av_executor_execute, libavutil), Cvoid, (Ptr{AVExecutor}, Ptr{AVTask}), e, t)
end

mutable struct AVFifo end

# typedef int AVFifoCB ( void * opaque , void * buf , size_t * nb_elems )
"""
Callback for writing or reading from a FIFO, passed to (and invoked from) the av\\_fifo\\_*\\_cb() functions. It may be invoked multiple times from a single av\\_fifo\\_*\\_cb() call and may process less data than the maximum size indicated by nb\\_elems.

# Arguments
* `opaque`: the opaque pointer provided to the av\\_fifo\\_*\\_cb() function
* `buf`: the buffer for reading or writing the data, depending on which av\\_fifo\\_*\\_cb function is called
* `nb_elems`: On entry contains the maximum number of elements that can be read from / written into buf. On success, the callback should update it to contain the number of elements actually written.
# Returns
0 on success, a negative error code on failure (will be returned from the invoking av\\_fifo\\_*\\_cb() function)
"""
const AVFifoCB = Cvoid

"""
    av_fifo_alloc2(elems::Csize_t, elem_size::Csize_t, flags::Integer)

Allocate and initialize an [`AVFifo`](@ref) with a given element size.

# Arguments
* `elems`: initial number of elements that can be stored in the FIFO
* `elem_size`: Size in bytes of a single element. Further operations on the returned FIFO will implicitly use this element size.
* `flags`: a combination of AV\\_FIFO\\_FLAG\\_*
# Returns
newly-allocated [`AVFifo`](@ref) on success, a negative error code on failure
"""
function av_fifo_alloc2(elems::Csize_t, elem_size::Csize_t, flags::Integer)
    ccall((:av_fifo_alloc2, libavutil), Ptr{AVFifo}, (Csize_t, Csize_t, Cuint), elems, elem_size, flags)
end

"""
    av_fifo_elem_size(f)

# Returns
Element size for FIFO operations. This element size is set at FIFO allocation and remains constant during its lifetime
"""
function av_fifo_elem_size(f)
    ccall((:av_fifo_elem_size, libavutil), Csize_t, (Ptr{AVFifo},), f)
end

"""
    av_fifo_auto_grow_limit(f, max_elems::Csize_t)

Set the maximum size (in elements) to which the FIFO can be resized automatically. Has no effect unless [`AV_FIFO_FLAG_AUTO_GROW`](@ref) is used.
"""
function av_fifo_auto_grow_limit(f, max_elems::Csize_t)
    ccall((:av_fifo_auto_grow_limit, libavutil), Cvoid, (Ptr{AVFifo}, Csize_t), f, max_elems)
end

"""
    av_fifo_can_read(f)

# Returns
number of elements available for reading from the given FIFO.
"""
function av_fifo_can_read(f)
    ccall((:av_fifo_can_read, libavutil), Csize_t, (Ptr{AVFifo},), f)
end

"""
    av_fifo_can_write(f)

In other words, this number of elements or less is guaranteed to fit into the FIFO. More data may be written when the [`AV_FIFO_FLAG_AUTO_GROW`](@ref) flag was specified at FIFO creation, but this may involve memory allocation, which can fail.

# Returns
Number of elements that can be written into the given FIFO without growing it.
"""
function av_fifo_can_write(f)
    ccall((:av_fifo_can_write, libavutil), Csize_t, (Ptr{AVFifo},), f)
end

"""
    av_fifo_grow2(f, inc::Csize_t)

Enlarge an [`AVFifo`](@ref).

On success, the FIFO will be large enough to hold exactly inc + [`av_fifo_can_read`](@ref)() + [`av_fifo_can_write`](@ref)() elements. In case of failure, the old FIFO is kept unchanged.

# Arguments
* `f`: [`AVFifo`](@ref) to resize
* `inc`: number of elements to allocate for, in addition to the current allocated size
# Returns
a non-negative number on success, a negative error code on failure
"""
function av_fifo_grow2(f, inc::Csize_t)
    ccall((:av_fifo_grow2, libavutil), Cint, (Ptr{AVFifo}, Csize_t), f, inc)
end

"""
    av_fifo_write(f, buf, nb_elems::Csize_t)

Write data into a FIFO.

In case nb\\_elems > [`av_fifo_can_write`](@ref)(f) and the [`AV_FIFO_FLAG_AUTO_GROW`](@ref) flag was not specified at FIFO creation, nothing is written and an error is returned.

Calling function is guaranteed to succeed if nb\\_elems <= [`av_fifo_can_write`](@ref)(f).

# Arguments
* `f`: the FIFO buffer
* `buf`: Data to be written. nb\\_elems * [`av_fifo_elem_size`](@ref)(f) bytes will be read from buf on success.
* `nb_elems`: number of elements to write into FIFO
# Returns
a non-negative number on success, a negative error code on failure
"""
function av_fifo_write(f, buf, nb_elems::Csize_t)
    ccall((:av_fifo_write, libavutil), Cint, (Ptr{AVFifo}, Ptr{Cvoid}, Csize_t), f, buf, nb_elems)
end

"""
    av_fifo_write_from_cb(f, read_cb::AVFifoCB, opaque, nb_elems)

Write data from a user-provided callback into a FIFO.

# Arguments
* `f`: the FIFO buffer
* `read_cb`: Callback supplying the data to the FIFO. May be called multiple times.
* `opaque`: opaque user data to be provided to read\\_cb
* `nb_elems`: Should point to the maximum number of elements that can be written. Will be updated to contain the number of elements actually written.
# Returns
non-negative number on success, a negative error code on failure
"""
function av_fifo_write_from_cb(f, read_cb::AVFifoCB, opaque, nb_elems)
    ccall((:av_fifo_write_from_cb, libavutil), Cint, (Ptr{AVFifo}, AVFifoCB, Ptr{Cvoid}, Ptr{Csize_t}), f, read_cb, opaque, nb_elems)
end

"""
    av_fifo_read(f, buf, nb_elems::Csize_t)

Read data from a FIFO.

In case nb\\_elems > [`av_fifo_can_read`](@ref)(f), nothing is read and an error is returned.

# Arguments
* `f`: the FIFO buffer
* `buf`: Buffer to store the data. nb\\_elems * [`av_fifo_elem_size`](@ref)(f) bytes will be written into buf on success.
* `nb_elems`: number of elements to read from FIFO
# Returns
a non-negative number on success, a negative error code on failure
"""
function av_fifo_read(f, buf, nb_elems::Csize_t)
    ccall((:av_fifo_read, libavutil), Cint, (Ptr{AVFifo}, Ptr{Cvoid}, Csize_t), f, buf, nb_elems)
end

"""
    av_fifo_read_to_cb(f, write_cb::AVFifoCB, opaque, nb_elems)

Feed data from a FIFO into a user-provided callback.

# Arguments
* `f`: the FIFO buffer
* `write_cb`: Callback the data will be supplied to. May be called multiple times.
* `opaque`: opaque user data to be provided to write\\_cb
* `nb_elems`: Should point to the maximum number of elements that can be read. Will be updated to contain the total number of elements actually sent to the callback.
# Returns
non-negative number on success, a negative error code on failure
"""
function av_fifo_read_to_cb(f, write_cb::AVFifoCB, opaque, nb_elems)
    ccall((:av_fifo_read_to_cb, libavutil), Cint, (Ptr{AVFifo}, AVFifoCB, Ptr{Cvoid}, Ptr{Csize_t}), f, write_cb, opaque, nb_elems)
end

"""
    av_fifo_peek(f, buf, nb_elems::Csize_t, offset::Csize_t)

Read data from a FIFO without modifying FIFO state.

Returns an error if an attempt is made to peek to nonexistent elements (i.e. if offset + nb\\_elems is larger than [`av_fifo_can_read`](@ref)(f)).

# Arguments
* `f`: the FIFO buffer
* `buf`: Buffer to store the data. nb\\_elems * [`av_fifo_elem_size`](@ref)(f) bytes will be written into buf.
* `nb_elems`: number of elements to read from FIFO
* `offset`: number of initial elements to skip.
# Returns
a non-negative number on success, a negative error code on failure
"""
function av_fifo_peek(f, buf, nb_elems::Csize_t, offset::Csize_t)
    ccall((:av_fifo_peek, libavutil), Cint, (Ptr{AVFifo}, Ptr{Cvoid}, Csize_t, Csize_t), f, buf, nb_elems, offset)
end

"""
    av_fifo_peek_to_cb(f, write_cb::AVFifoCB, opaque, nb_elems, offset::Csize_t)

Feed data from a FIFO into a user-provided callback.

# Arguments
* `f`: the FIFO buffer
* `write_cb`: Callback the data will be supplied to. May be called multiple times.
* `opaque`: opaque user data to be provided to write\\_cb
* `nb_elems`: Should point to the maximum number of elements that can be read. Will be updated to contain the total number of elements actually sent to the callback.
* `offset`: number of initial elements to skip; offset + *nb\\_elems must not be larger than [`av_fifo_can_read`](@ref)(f).
# Returns
a non-negative number on success, a negative error code on failure
"""
function av_fifo_peek_to_cb(f, write_cb::AVFifoCB, opaque, nb_elems, offset::Csize_t)
    ccall((:av_fifo_peek_to_cb, libavutil), Cint, (Ptr{AVFifo}, AVFifoCB, Ptr{Cvoid}, Ptr{Csize_t}, Csize_t), f, write_cb, opaque, nb_elems, offset)
end

"""
    av_fifo_drain2(f, size::Csize_t)

Discard the specified amount of data from an [`AVFifo`](@ref).

# Arguments
* `size`: number of elements to discard, MUST NOT be larger than [`av_fifo_can_read`](@ref)(f)
"""
function av_fifo_drain2(f, size::Csize_t)
    ccall((:av_fifo_drain2, libavutil), Cvoid, (Ptr{AVFifo}, Csize_t), f, size)
end

function av_fifo_reset2(f)
    ccall((:av_fifo_reset2, libavutil), Cvoid, (Ptr{AVFifo},), f)
end

"""
    av_fifo_freep2(f)

Free an [`AVFifo`](@ref) and reset pointer to NULL.

# Arguments
* `f`: Pointer to an [`AVFifo`](@ref) to free. *f == NULL is allowed.
"""
function av_fifo_freep2(f)
    ccall((:av_fifo_freep2, libavutil), Cvoid, (Ptr{Ptr{AVFifo}},), f)
end

"""
    av_file_map(filename, bufptr, size, log_offset::Integer, log_ctx)

Read the file with name filename, and put its content in a newly allocated buffer or map it with mmap() when available. In case of success set *bufptr to the read or mmapped buffer, and *size to the size in bytes of the buffer in *bufptr. Unlike mmap this function succeeds with zero sized files, in this case *bufptr will be set to NULL and *size will be set to 0. The returned buffer must be released with [`av_file_unmap`](@ref)().

# Arguments
* `filename`: path to the file
* `bufptr`:\\[out\\] pointee is set to the mapped or allocated buffer
* `size`:\\[out\\] pointee is set to the size in bytes of the buffer
* `log_offset`: loglevel offset used for logging
* `log_ctx`: context used for logging
# Returns
a non negative number in case of success, a negative value corresponding to an [`AVERROR`](@ref) error code in case of failure
"""
function av_file_map(filename, bufptr, size, log_offset::Integer, log_ctx)
    ccall((:av_file_map, libavutil), Cint, (Cstring, Ptr{Ptr{UInt8}}, Ptr{Csize_t}, Cint, Ptr{Cvoid}), filename, bufptr, size, log_offset, log_ctx)
end

"""
    av_file_unmap(bufptr, size::Csize_t)

Unmap or free the buffer bufptr created by [`av_file_map`](@ref)().

# Arguments
* `bufptr`: the buffer previously created with [`av_file_map`](@ref)()
* `size`: size in bytes of bufptr, must be the same as returned by [`av_file_map`](@ref)()
"""
function av_file_unmap(bufptr, size::Csize_t)
    ccall((:av_file_unmap, libavutil), Cvoid, (Ptr{UInt8}, Csize_t), bufptr, size)
end

const AVFilmGrainParamsType = UInt32
const AV_FILM_GRAIN_PARAMS_NONE = 0 % UInt32
const AV_FILM_GRAIN_PARAMS_AV1 = 1 % UInt32
const AV_FILM_GRAIN_PARAMS_H274 = 2 % UInt32

"""
    AVFilmGrainAOMParams

This structure describes how to handle film grain synthesis for AOM codecs.

!!! note

    The struct must be allocated as part of [`AVFilmGrainParams`](@ref) using [`av_film_grain_params_alloc`](@ref)(). Its size is not a part of the public ABI.
"""
struct AVFilmGrainAOMParams
    num_y_points::Cint
    y_points::NTuple{14, NTuple{2, UInt8}}
    chroma_scaling_from_luma::Cint
    num_uv_points::NTuple{2, Cint}
    uv_points::NTuple{2, NTuple{10, NTuple{2, UInt8}}}
    scaling_shift::Cint
    ar_coeff_lag::Cint
    ar_coeffs_y::NTuple{24, Int8}
    ar_coeffs_uv::NTuple{2, NTuple{25, Int8}}
    ar_coeff_shift::Cint
    grain_scale_shift::Cint
    uv_mult::NTuple{2, Cint}
    uv_mult_luma::NTuple{2, Cint}
    uv_offset::NTuple{2, Cint}
    overlap_flag::Cint
    limit_output_range::Cint
end

"""
    AVFilmGrainH274Params

This structure describes how to handle film grain synthesis for codecs using the ITU-T H.274 Versatile supplemental enhancement information message.

!!! note

    The struct must be allocated as part of [`AVFilmGrainParams`](@ref) using [`av_film_grain_params_alloc`](@ref)(). Its size is not a part of the public ABI.
"""
struct AVFilmGrainH274Params
    model_id::Cint
    blending_mode_id::Cint
    log2_scale_factor::Cint
    component_model_present::NTuple{3, Cint}
    num_intensity_intervals::NTuple{3, UInt16}
    num_model_values::NTuple{3, UInt8}
    intensity_interval_lower_bound::NTuple{3, NTuple{256, UInt8}}
    intensity_interval_upper_bound::NTuple{3, NTuple{256, UInt8}}
    comp_model_value::NTuple{3, NTuple{256, NTuple{6, Int16}}}
end

"""
    __JL_Ctag_96

Additional fields may be added both here and in any structure included. If a codec's film grain structure differs slightly over another codec's, fields within may change meaning depending on the type.
"""
struct __JL_Ctag_96
    data::NTuple{10788, UInt8}
end

function Base.getproperty(x::Ptr{__JL_Ctag_96}, f::Symbol)
    f === :aom && return Ptr{AVFilmGrainAOMParams}(x + 0)
    f === :h274 && return Ptr{AVFilmGrainH274Params}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::__JL_Ctag_96, f::Symbol)
    r = Ref{__JL_Ctag_96}(x)
    ptr = Base.unsafe_convert(Ptr{__JL_Ctag_96}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{__JL_Ctag_96}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::__JL_Ctag_96, private::Bool = false)
    (:aom, :h274, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVFilmGrainParams

This structure describes how to handle film grain synthesis in video for specific codecs. Must be present on every frame where film grain is meant to be synthesised for correct presentation.

!!! note

    The struct must be allocated with [`av_film_grain_params_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVFilmGrainParams
    data::NTuple{10848, UInt8}
end

function Base.getproperty(x::Ptr{AVFilmGrainParams}, f::Symbol)
    f === :type && return Ptr{AVFilmGrainParamsType}(x + 0)
    f === :seed && return Ptr{UInt64}(x + 8)
    f === :width && return Ptr{Cint}(x + 16)
    f === :height && return Ptr{Cint}(x + 20)
    f === :subsampling_x && return Ptr{Cint}(x + 24)
    f === :subsampling_y && return Ptr{Cint}(x + 28)
    f === :color_range && return Ptr{AVColorRange}(x + 32)
    f === :color_primaries && return Ptr{AVColorPrimaries}(x + 36)
    f === :color_trc && return Ptr{AVColorTransferCharacteristic}(x + 40)
    f === :color_space && return Ptr{AVColorSpace}(x + 44)
    f === :bit_depth_luma && return Ptr{Cint}(x + 48)
    f === :bit_depth_chroma && return Ptr{Cint}(x + 52)
    f === :codec && return Ptr{__JL_Ctag_96}(x + 56)
    return getfield(x, f)
end

function Base.getproperty(x::AVFilmGrainParams, f::Symbol)
    r = Ref{AVFilmGrainParams}(x)
    ptr = Base.unsafe_convert(Ptr{AVFilmGrainParams}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVFilmGrainParams}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVFilmGrainParams, private::Bool = false)
    (:type, :seed, :width, :height, :subsampling_x, :subsampling_y, :color_range, :color_primaries, :color_trc, :color_space, :bit_depth_luma, :bit_depth_chroma, :codec, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    av_film_grain_params_alloc(size)

Allocate an [`AVFilmGrainParams`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)(). If size is not NULL it will be set to the number of bytes allocated.

# Returns
An [`AVFilmGrainParams`](@ref) filled with default values or NULL on failure.
"""
function av_film_grain_params_alloc(size)
    ccall((:av_film_grain_params_alloc, libavutil), Ptr{AVFilmGrainParams}, (Ptr{Csize_t},), size)
end

"""
    av_film_grain_params_create_side_data(frame)

Allocate a complete [`AVFilmGrainParams`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVFilmGrainParams`](@ref) structure to be filled by caller.
"""
function av_film_grain_params_create_side_data(frame)
    ccall((:av_film_grain_params_create_side_data, libavutil), Ptr{AVFilmGrainParams}, (Ptr{AVFrame},), frame)
end

"""
    av_film_grain_params_select(frame)

Select the most appropriate film grain parameters set for the frame, taking into account the frame's format, resolution and video signal characteristics.

!!! note

    , for H.274, this may select a film grain parameter set with greater chroma resolution than the frame. Users should take care to correctly adjust the chroma grain frequency to the frame.
"""
function av_film_grain_params_select(frame)
    ccall((:av_film_grain_params_select, libavutil), Ptr{AVFilmGrainParams}, (Ptr{AVFrame},), frame)
end

const AVActiveFormatDescription = UInt32
const AV_AFD_SAME = 8 % UInt32
const AV_AFD_4_3 = 9 % UInt32
const AV_AFD_16_9 = 10 % UInt32
const AV_AFD_14_9 = 11 % UInt32
const AV_AFD_4_3_SP_14_9 = 13 % UInt32
const AV_AFD_16_9_SP_14_9 = 14 % UInt32
const AV_AFD_SP_4_3 = 15 % UInt32

const AVSideDataProps = UInt32
const AV_SIDE_DATA_PROP_GLOBAL = 1 % UInt32
const AV_SIDE_DATA_PROP_MULTI = 2 % UInt32
const AV_SIDE_DATA_PROP_SIZE_DEPENDENT = 4 % UInt32
const AV_SIDE_DATA_PROP_COLOR_DEPENDENT = 8 % UInt32
const AV_SIDE_DATA_PROP_CHANNEL_DEPENDENT = 16 % UInt32

"""
    AVSideDataDescriptor

This struct describes the properties of a side data type. Its instance corresponding to a given type can be obtained from [`av_frame_side_data_desc`](@ref)().
"""
struct AVSideDataDescriptor
    name::Cstring
    props::Cuint
end

"""
    AVRegionOfInterest

Structure describing a single Region Of Interest.

When multiple regions are defined in a single side-data block, they should be ordered from most to least important - some encoders are only capable of supporting a limited number of distinct regions, so will have to truncate the list.

When overlapping regions are defined, the first region containing a given area of the frame applies.
"""
struct AVRegionOfInterest
    self_size::UInt32
    top::Cint
    bottom::Cint
    left::Cint
    right::Cint
    qoffset::AVRational
end

"""
    av_frame_alloc()

Allocate an [`AVFrame`](@ref) and set its fields to default values. The resulting struct must be freed using [`av_frame_free`](@ref)().

!!! note

    this only allocates the [`AVFrame`](@ref) itself, not the data buffers. Those must be allocated through other means, e.g. with [`av_frame_get_buffer`](@ref)() or manually.

# Returns
An [`AVFrame`](@ref) filled with default values or NULL on failure.
"""
function av_frame_alloc()
    ccall((:av_frame_alloc, libavutil), Ptr{AVFrame}, ())
end

"""
    av_frame_free(frame)

Free the frame and any dynamically allocated objects in it, e.g. extended\\_data. If the frame is reference counted, it will be unreferenced first.

# Arguments
* `frame`: frame to be freed. The pointer will be set to NULL.
"""
function av_frame_free(frame)
    ccall((:av_frame_free, libavutil), Cvoid, (Ptr{Ptr{AVFrame}},), frame)
end

"""
    av_frame_ref(dst, src)

Set up a new reference to the data described by the source frame.

Copy frame properties from src to dst and create a new reference for each [`AVBufferRef`](@ref) from src.

If src is not reference counted, new buffers are allocated and the data is copied.

!!! warning

    : dst MUST have been either unreferenced with [`av_frame_unref`](@ref)(dst), or newly allocated with [`av_frame_alloc`](@ref)() before calling this function, or undefined behavior will occur.

# Returns
0 on success, a negative [`AVERROR`](@ref) on error
"""
function av_frame_ref(dst, src)
    ccall((:av_frame_ref, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    av_frame_replace(dst, src)

Ensure the destination frame refers to the same data described by the source frame, either by creating a new reference for each [`AVBufferRef`](@ref) from src if they differ from those in dst, by allocating new buffers and copying data if src is not reference counted, or by unrefencing it if src is empty.

Frame properties on dst will be replaced by those from src.

# Returns
0 on success, a negative [`AVERROR`](@ref) on error. On error, dst is unreferenced.
"""
function av_frame_replace(dst, src)
    ccall((:av_frame_replace, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    av_frame_clone(src)

Create a new frame that references the same data as src.

This is a shortcut for [`av_frame_alloc`](@ref)()+[`av_frame_ref`](@ref)().

# Returns
newly created [`AVFrame`](@ref) on success, NULL on error.
"""
function av_frame_clone(src)
    ccall((:av_frame_clone, libavutil), Ptr{AVFrame}, (Ptr{AVFrame},), src)
end

"""
    av_frame_unref(frame)

Unreference all the buffers referenced by frame and reset the frame fields.
"""
function av_frame_unref(frame)
    ccall((:av_frame_unref, libavutil), Cvoid, (Ptr{AVFrame},), frame)
end

"""
    av_frame_move_ref(dst, src)

Move everything contained in src to dst and reset src.

!!! warning

    : dst is not unreferenced, but directly overwritten without reading or deallocating its contents. Call [`av_frame_unref`](@ref)(dst) manually before calling this function to ensure that no memory is leaked.
"""
function av_frame_move_ref(dst, src)
    ccall((:av_frame_move_ref, libavutil), Cvoid, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    av_frame_get_buffer(frame, align::Integer)

Allocate new buffer(s) for audio or video data.

The following fields must be set on frame before calling this function: - format (pixel format for video, sample format for audio) - width and height for video - nb\\_samples and ch\\_layout for audio

This function will fill [`AVFrame`](@ref).data and [`AVFrame`](@ref).buf arrays and, if necessary, allocate and fill [`AVFrame`](@ref).extended\\_data and [`AVFrame`](@ref).extended\\_buf. For planar formats, one buffer will be allocated for each plane.

!!! warning

    : if frame already has been allocated, calling this function will leak memory. In addition, undefined behavior can occur in certain cases.

# Arguments
* `frame`: frame in which to store the new buffers.
* `align`: Required buffer size and data pointer alignment. If equal to 0, alignment will be chosen automatically for the current CPU. It is highly recommended to pass 0 here unless you know what you are doing.
# Returns
0 on success, a negative [`AVERROR`](@ref) on error.
"""
function av_frame_get_buffer(frame, align::Integer)
    ccall((:av_frame_get_buffer, libavutil), Cint, (Ptr{AVFrame}, Cint), frame, align)
end

"""
    av_frame_is_writable(frame)

Check if the frame data is writable.

If 1 is returned the answer is valid until [`av_buffer_ref`](@ref)() is called on any of the underlying AVBufferRefs (e.g. through [`av_frame_ref`](@ref)() or directly).

# Returns
A positive value if the frame data is writable (which is true if and only if each of the underlying buffers has only one reference, namely the one stored in this frame). Return 0 otherwise.
# See also
[`av_frame_make_writable`](@ref)(), [`av_buffer_is_writable`](@ref)()
"""
function av_frame_is_writable(frame)
    ccall((:av_frame_is_writable, libavutil), Cint, (Ptr{AVFrame},), frame)
end

"""
    av_frame_make_writable(frame)

Ensure that the frame data is writable, avoiding data copy if possible.

Do nothing if the frame is writable, allocate new buffers and copy the data if it is not. Non-refcounted frames behave as non-writable, i.e. a copy is always made.

# Returns
0 on success, a negative [`AVERROR`](@ref) on error.
# See also
[`av_frame_is_writable`](@ref)(), [`av_buffer_is_writable`](@ref)(), [`av_buffer_make_writable`](@ref)()
"""
function av_frame_make_writable(frame)
    ccall((:av_frame_make_writable, libavutil), Cint, (Ptr{AVFrame},), frame)
end

"""
    av_frame_copy(dst, src)

Copy the frame data from src to dst.

This function does not allocate anything, dst must be already initialized and allocated with the same parameters as src.

This function only copies the frame data (i.e. the contents of the data / extended data arrays), not any other properties.

# Returns
>= 0 on success, a negative [`AVERROR`](@ref) on error.
"""
function av_frame_copy(dst, src)
    ccall((:av_frame_copy, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    av_frame_copy_props(dst, src)

Copy only "metadata" fields from src to dst.

Metadata for the purpose of this function are those fields that do not affect the data layout in the buffers. E.g. pts, sample rate (for audio) or sample aspect ratio (for video), but not width/height or channel layout. Side data is also copied.
"""
function av_frame_copy_props(dst, src)
    ccall((:av_frame_copy_props, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    av_frame_get_plane_buffer(frame, plane::Integer)

Get the buffer reference a given data plane is stored in.

# Arguments
* `frame`: the frame to get the plane's buffer from
* `plane`: index of the data plane of interest in frame->extended\\_data.
# Returns
the buffer reference that contains the plane or NULL if the input frame is not valid.
"""
function av_frame_get_plane_buffer(frame, plane::Integer)
    ccall((:av_frame_get_plane_buffer, libavutil), Ptr{AVBufferRef}, (Ptr{AVFrame}, Cint), frame, plane)
end

"""
    av_frame_new_side_data(frame, type::AVFrameSideDataType, size::Csize_t)

Add a new side data to a frame.

# Arguments
* `frame`: a frame to which the side data should be added
* `type`: type of the added side data
* `size`: size of the side data
# Returns
newly added side data on success, NULL on error
"""
function av_frame_new_side_data(frame, type::AVFrameSideDataType, size::Csize_t)
    ccall((:av_frame_new_side_data, libavutil), Ptr{AVFrameSideData}, (Ptr{AVFrame}, AVFrameSideDataType, Csize_t), frame, type, size)
end

"""
    av_frame_new_side_data_from_buf(frame, type::AVFrameSideDataType, buf)

Add a new side data to a frame from an existing [`AVBufferRef`](@ref)

# Arguments
* `frame`: a frame to which the side data should be added
* `type`: the type of the added side data
* `buf`: an [`AVBufferRef`](@ref) to add as side data. The ownership of the reference is transferred to the frame.
# Returns
newly added side data on success, NULL on error. On failure the frame is unchanged and the [`AVBufferRef`](@ref) remains owned by the caller.
"""
function av_frame_new_side_data_from_buf(frame, type::AVFrameSideDataType, buf)
    ccall((:av_frame_new_side_data_from_buf, libavutil), Ptr{AVFrameSideData}, (Ptr{AVFrame}, AVFrameSideDataType, Ptr{AVBufferRef}), frame, type, buf)
end

"""
    av_frame_get_side_data(frame, type::AVFrameSideDataType)

# Returns
a pointer to the side data of a given type on success, NULL if there is no side data with such type in this frame.
"""
function av_frame_get_side_data(frame, type::AVFrameSideDataType)
    ccall((:av_frame_get_side_data, libavutil), Ptr{AVFrameSideData}, (Ptr{AVFrame}, AVFrameSideDataType), frame, type)
end

"""
    av_frame_remove_side_data(frame, type::AVFrameSideDataType)

Remove and free all side data instances of the given type.
"""
function av_frame_remove_side_data(frame, type::AVFrameSideDataType)
    ccall((:av_frame_remove_side_data, libavutil), Cvoid, (Ptr{AVFrame}, AVFrameSideDataType), frame, type)
end

"""
    __JL_Ctag_57

Flags for frame cropping.
"""
const __JL_Ctag_57 = UInt32
const AV_FRAME_CROP_UNALIGNED = 1 % UInt32

"""
    av_frame_apply_cropping(frame, flags::Integer)

Crop the given video [`AVFrame`](@ref) according to its crop\\_left/crop\\_top/crop\\_right/ crop\\_bottom fields. If cropping is successful, the function will adjust the data pointers and the width/height fields, and set the crop fields to 0.

In all cases, the cropping boundaries will be rounded to the inherent alignment of the pixel format. In some cases, such as for opaque hwaccel formats, the left/top cropping is ignored. The crop fields are set to 0 even if the cropping was rounded or ignored.

# Arguments
* `frame`: the frame which should be cropped
* `flags`: Some combination of AV\\_FRAME\\_CROP\\_* flags, or 0.
# Returns
>= 0 on success, a negative [`AVERROR`](@ref) on error. If the cropping fields were invalid, [`AVERROR`](@ref)(ERANGE) is returned, and nothing is changed.
"""
function av_frame_apply_cropping(frame, flags::Integer)
    ccall((:av_frame_apply_cropping, libavutil), Cint, (Ptr{AVFrame}, Cint), frame, flags)
end

"""
    av_frame_side_data_name(type::AVFrameSideDataType)

# Returns
a string identifying the side data type
"""
function av_frame_side_data_name(type::AVFrameSideDataType)
    ccall((:av_frame_side_data_name, libavutil), Cstring, (AVFrameSideDataType,), type)
end

"""
    av_frame_side_data_desc(type::AVFrameSideDataType)

# Returns
side data descriptor corresponding to a given side data type, NULL when not available.
"""
function av_frame_side_data_desc(type::AVFrameSideDataType)
    ccall((:av_frame_side_data_desc, libavutil), Ptr{AVSideDataDescriptor}, (AVFrameSideDataType,), type)
end

"""
    av_frame_side_data_free(sd, nb_sd)

Free all side data entries and their contents, then zeroes out the values which the pointers are pointing to.

# Arguments
* `sd`: pointer to array of side data to free. Will be set to NULL upon return.
* `nb_sd`: pointer to an integer containing the number of entries in the array. Will be set to 0 upon return.
"""
function av_frame_side_data_free(sd, nb_sd)
    ccall((:av_frame_side_data_free, libavutil), Cvoid, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}), sd, nb_sd)
end

"""
    av_frame_side_data_new(sd, nb_sd, type::AVFrameSideDataType, size::Csize_t, flags::Integer)

Add new side data entry to an array.

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_UNIQUE`](@ref) being set, entries of matching [`AVFrameSideDataType`](@ref) will be removed before the addition is attempted.

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_REPLACE`](@ref) being set, if an entry of the same type already exists, it will be replaced instead.

# Arguments
* `sd`: pointer to array of side data to which to add another entry, or to NULL in order to start a new array.
* `nb_sd`: pointer to an integer containing the number of entries in the array.
* `type`: type of the added side data
* `size`: size of the side data
* `flags`: Some combination of AV\\_FRAME\\_SIDE\\_DATA\\_FLAG\\_* flags, or 0.
# Returns
newly added side data on success, NULL on error.
"""
function av_frame_side_data_new(sd, nb_sd, type::AVFrameSideDataType, size::Csize_t, flags::Integer)
    ccall((:av_frame_side_data_new, libavutil), Ptr{AVFrameSideData}, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}, AVFrameSideDataType, Csize_t, Cuint), sd, nb_sd, type, size, flags)
end

"""
    av_frame_side_data_add(sd, nb_sd, type::AVFrameSideDataType, buf, flags::Integer)

Add a new side data entry to an array from an existing [`AVBufferRef`](@ref).

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_UNIQUE`](@ref) being set, entries of matching [`AVFrameSideDataType`](@ref) will be removed before the addition is attempted.

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_REPLACE`](@ref) being set, if an entry of the same type already exists, it will be replaced instead.

# Arguments
* `sd`: pointer to array of side data to which to add another entry, or to NULL in order to start a new array.
* `nb_sd`: pointer to an integer containing the number of entries in the array.
* `type`: type of the added side data
* `buf`: Pointer to [`AVBufferRef`](@ref) to add to the array. On success, the function takes ownership of the [`AVBufferRef`](@ref) and *buf is set to NULL, unless [`AV_FRAME_SIDE_DATA_FLAG_NEW_REF`](@ref) is set in which case the ownership will remain with the caller.
* `flags`: Some combination of AV\\_FRAME\\_SIDE\\_DATA\\_FLAG\\_* flags, or 0.
# Returns
newly added side data on success, NULL on error.
"""
function av_frame_side_data_add(sd, nb_sd, type::AVFrameSideDataType, buf, flags::Integer)
    ccall((:av_frame_side_data_add, libavutil), Ptr{AVFrameSideData}, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}, AVFrameSideDataType, Ptr{Ptr{AVBufferRef}}, Cuint), sd, nb_sd, type, buf, flags)
end

"""
    av_frame_side_data_clone(sd, nb_sd, src, flags::Integer)

Add a new side data entry to an array based on existing side data, taking a reference towards the contained [`AVBufferRef`](@ref).

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_UNIQUE`](@ref) being set, entries of matching [`AVFrameSideDataType`](@ref) will be removed before the addition is attempted.

!!! note

    In case of [`AV_FRAME_SIDE_DATA_FLAG_REPLACE`](@ref) being set, if an entry of the same type already exists, it will be replaced instead.

# Arguments
* `sd`: pointer to array of side data to which to add another entry, or to NULL in order to start a new array.
* `nb_sd`: pointer to an integer containing the number of entries in the array.
* `src`: side data to be cloned, with a new reference utilized for the buffer.
* `flags`: Some combination of AV\\_FRAME\\_SIDE\\_DATA\\_FLAG\\_* flags, or 0.
# Returns
negative error code on failure, >=0 on success.
"""
function av_frame_side_data_clone(sd, nb_sd, src, flags::Integer)
    ccall((:av_frame_side_data_clone, libavutil), Cint, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}, Ptr{AVFrameSideData}, Cuint), sd, nb_sd, src, flags)
end

"""
    av_frame_side_data_get_c(sd, nb_sd::Integer, type::AVFrameSideDataType)

Get a side data entry of a specific type from an array.

# Arguments
* `sd`: array of side data.
* `nb_sd`: integer containing the number of entries in the array.
* `type`: type of side data to be queried
# Returns
a pointer to the side data of a given type on success, NULL if there is no side data with such type in this set.
"""
function av_frame_side_data_get_c(sd, nb_sd::Integer, type::AVFrameSideDataType)
    ccall((:av_frame_side_data_get_c, libavutil), Ptr{AVFrameSideData}, (Ptr{Ptr{AVFrameSideData}}, Cint, AVFrameSideDataType), sd, nb_sd, type)
end

"""
    av_frame_side_data_get(sd, nb_sd::Integer, type::AVFrameSideDataType)

Wrapper around [`av_frame_side_data_get_c`](@ref)() to workaround the limitation that for any type T the conversion from T * const * to const T * const * is not performed automatically in C.

# See also
[`av_frame_side_data_get_c`](@ref)()
"""
function av_frame_side_data_get(sd, nb_sd::Integer, type::AVFrameSideDataType)
    ccall((:av_frame_side_data_get, libavutil), Ptr{AVFrameSideData}, (Ptr{Ptr{AVFrameSideData}}, Cint, AVFrameSideDataType), sd, nb_sd, type)
end

"""
    av_frame_side_data_remove(sd, nb_sd, type::AVFrameSideDataType)

Remove and free all side data instances of the given type from an array.
"""
function av_frame_side_data_remove(sd, nb_sd, type::AVFrameSideDataType)
    ccall((:av_frame_side_data_remove, libavutil), Cvoid, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}, AVFrameSideDataType), sd, nb_sd, type)
end

"""
    av_frame_side_data_remove_by_props(sd, nb_sd, props::Integer)

Remove and free all side data instances that match any of the given side data properties. (See enum [`AVSideDataProps`](@ref))
"""
function av_frame_side_data_remove_by_props(sd, nb_sd, props::Integer)
    ccall((:av_frame_side_data_remove_by_props, libavutil), Cvoid, (Ptr{Ptr{Ptr{AVFrameSideData}}}, Ptr{Cint}, Cint), sd, nb_sd, props)
end

"""
` ffhash.c`

This example is a simple command line application that takes one or more arguments. It demonstrates a typical use of the hashing API with allocation, initialization, updating, and finalizing.
"""
mutable struct AVHashContext end

"""
    av_hash_alloc(ctx, name)

Allocate a hash context for the algorithm specified by name.

!!! note

    The context is not initialized after a call to this function; you must call [`av_hash_init`](@ref)() to do so.

# Returns
>= 0 for success, a negative error code for failure
"""
function av_hash_alloc(ctx, name)
    ccall((:av_hash_alloc, libavutil), Cint, (Ptr{Ptr{AVHashContext}}, Cstring), ctx, name)
end

"""
    av_hash_names(i::Integer)

Get the names of available hash algorithms.

This function can be used to enumerate the algorithms.

# Arguments
* `i`:\\[in\\] Index of the hash algorithm, starting from 0
# Returns
Pointer to a static string or `NULL` if `i` is out of range
"""
function av_hash_names(i::Integer)
    ccall((:av_hash_names, libavutil), Cstring, (Cint,), i)
end

"""
    av_hash_get_name(ctx)

Get the name of the algorithm corresponding to the given hash context.
"""
function av_hash_get_name(ctx)
    ccall((:av_hash_get_name, libavutil), Cstring, (Ptr{AVHashContext},), ctx)
end

"""
    av_hash_get_size(ctx)

Get the size of the resulting hash value in bytes.

The maximum value this function will currently return is available as macro #[`AV_HASH_MAX_SIZE`](@ref).

# Arguments
* `ctx`:\\[in\\] Hash context
# Returns
Size of the hash value in bytes
"""
function av_hash_get_size(ctx)
    ccall((:av_hash_get_size, libavutil), Cint, (Ptr{AVHashContext},), ctx)
end

"""
    av_hash_init(ctx)

Initialize or reset a hash context.

# Arguments
* `ctx`:\\[in,out\\] Hash context
"""
function av_hash_init(ctx)
    ccall((:av_hash_init, libavutil), Cvoid, (Ptr{AVHashContext},), ctx)
end

"""
    av_hash_update(ctx, src, len::Csize_t)

Update a hash context with additional data.

# Arguments
* `ctx`:\\[in,out\\] Hash context
* `src`:\\[in\\] Data to be added to the hash context
* `len`:\\[in\\] Size of the additional data
"""
function av_hash_update(ctx, src, len::Csize_t)
    ccall((:av_hash_update, libavutil), Cvoid, (Ptr{AVHashContext}, Ptr{UInt8}, Csize_t), ctx, src, len)
end

"""
    av_hash_final(ctx, dst)

Finalize a hash context and compute the actual hash value.

The minimum size of `dst` buffer is given by [`av_hash_get_size`](@ref)() or #[`AV_HASH_MAX_SIZE`](@ref). The use of the latter macro is discouraged.

It is not safe to update or finalize a hash context again, if it has already been finalized.

# Arguments
* `ctx`:\\[in,out\\] Hash context
* `dst`:\\[out\\] Where the final hash value will be stored
# See also
[`av_hash_final_bin`](@ref)() provides an alternative API
"""
function av_hash_final(ctx, dst)
    ccall((:av_hash_final, libavutil), Cvoid, (Ptr{AVHashContext}, Ptr{UInt8}), ctx, dst)
end

"""
    av_hash_final_bin(ctx, dst, size::Integer)

Finalize a hash context and store the actual hash value in a buffer.

It is not safe to update or finalize a hash context again, if it has already been finalized.

If `size` is smaller than the hash size (given by [`av_hash_get_size`](@ref)()), the hash is truncated; if size is larger, the buffer is padded with 0.

# Arguments
* `ctx`:\\[in,out\\] Hash context
* `dst`:\\[out\\] Where the final hash value will be stored
* `size`:\\[in\\] Number of bytes to write to `dst`
"""
function av_hash_final_bin(ctx, dst, size::Integer)
    ccall((:av_hash_final_bin, libavutil), Cvoid, (Ptr{AVHashContext}, Ptr{UInt8}, Cint), ctx, dst, size)
end

"""
    av_hash_final_hex(ctx, dst, size::Integer)

Finalize a hash context and store the hexadecimal representation of the actual hash value as a string.

It is not safe to update or finalize a hash context again, if it has already been finalized.

The string is always 0-terminated.

If `size` is smaller than `2 * hash\\_size + 1`, where `hash_size` is the value returned by [`av_hash_get_size`](@ref)(), the string will be truncated.

# Arguments
* `ctx`:\\[in,out\\] Hash context
* `dst`:\\[out\\] Where the string will be stored
* `size`:\\[in\\] Maximum number of bytes to write to `dst`
"""
function av_hash_final_hex(ctx, dst, size::Integer)
    ccall((:av_hash_final_hex, libavutil), Cvoid, (Ptr{AVHashContext}, Ptr{UInt8}, Cint), ctx, dst, size)
end

"""
    av_hash_final_b64(ctx, dst, size::Integer)

Finalize a hash context and store the Base64 representation of the actual hash value as a string.

It is not safe to update or finalize a hash context again, if it has already been finalized.

The string is always 0-terminated.

If `size` is smaller than [`AV_BASE64_SIZE`](@ref)(hash\\_size), where `hash_size` is the value returned by [`av_hash_get_size`](@ref)(), the string will be truncated.

# Arguments
* `ctx`:\\[in,out\\] Hash context
* `dst`:\\[out\\] Where the final hash value will be stored
* `size`:\\[in\\] Maximum number of bytes to write to `dst`
"""
function av_hash_final_b64(ctx, dst, size::Integer)
    ccall((:av_hash_final_b64, libavutil), Cvoid, (Ptr{AVHashContext}, Ptr{UInt8}, Cint), ctx, dst, size)
end

"""
    av_hash_freep(ctx)

Free hash context and set hash context pointer to `NULL`.

# Arguments
* `ctx`:\\[in,out\\] Pointer to hash context
"""
function av_hash_freep(ctx)
    ccall((:av_hash_freep, libavutil), Cvoid, (Ptr{Ptr{AVHashContext}},), ctx)
end

"""
    AVHDRPlusOverlapProcessOption

Option for overlapping elliptical pixel selectors in an image.
"""
const AVHDRPlusOverlapProcessOption = UInt32
const AV_HDR_PLUS_OVERLAP_PROCESS_WEIGHTED_AVERAGING = 0 % UInt32
const AV_HDR_PLUS_OVERLAP_PROCESS_LAYERING = 1 % UInt32

"""
    AVHDRPlusPercentile

Represents the percentile at a specific percentage in a distribution.
"""
struct AVHDRPlusPercentile
    percentage::UInt8
    percentile::AVRational
end

"""
    AVHDRPlusColorTransformParams

Color transform parameters at a processing window in a dynamic metadata for SMPTE 2094-40.
"""
struct AVHDRPlusColorTransformParams
    window_upper_left_corner_x::AVRational
    window_upper_left_corner_y::AVRational
    window_lower_right_corner_x::AVRational
    window_lower_right_corner_y::AVRational
    center_of_ellipse_x::UInt16
    center_of_ellipse_y::UInt16
    rotation_angle::UInt8
    semimajor_axis_internal_ellipse::UInt16
    semimajor_axis_external_ellipse::UInt16
    semiminor_axis_external_ellipse::UInt16
    overlap_process_option::AVHDRPlusOverlapProcessOption
    maxscl::NTuple{3, AVRational}
    average_maxrgb::AVRational
    num_distribution_maxrgb_percentiles::UInt8
    distribution_maxrgb::NTuple{15, AVHDRPlusPercentile}
    fraction_bright_pixels::AVRational
    tone_mapping_flag::UInt8
    knee_point_x::AVRational
    knee_point_y::AVRational
    num_bezier_curve_anchors::UInt8
    bezier_curve_anchors::NTuple{15, AVRational}
    color_saturation_mapping_flag::UInt8
    color_saturation_weight::AVRational
end

"""
    AVDynamicHDRPlus

This struct represents dynamic metadata for color volume transform - application 4 of SMPTE 2094-40:2016 standard.

To be used as payload of a [`AVFrameSideData`](@ref) or [`AVPacketSideData`](@ref) with the appropriate type.

!!! note

    The struct should be allocated with [`av_dynamic_hdr_plus_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVDynamicHDRPlus
    itu_t_t35_country_code::UInt8
    application_version::UInt8
    num_windows::UInt8
    params::NTuple{3, AVHDRPlusColorTransformParams}
    targeted_system_display_maximum_luminance::AVRational
    targeted_system_display_actual_peak_luminance_flag::UInt8
    num_rows_targeted_system_display_actual_peak_luminance::UInt8
    num_cols_targeted_system_display_actual_peak_luminance::UInt8
    targeted_system_display_actual_peak_luminance::NTuple{25, NTuple{25, AVRational}}
    mastering_display_actual_peak_luminance_flag::UInt8
    num_rows_mastering_display_actual_peak_luminance::UInt8
    num_cols_mastering_display_actual_peak_luminance::UInt8
    mastering_display_actual_peak_luminance::NTuple{25, NTuple{25, AVRational}}
end

"""
    av_dynamic_hdr_plus_alloc(size)

Allocate an [`AVDynamicHDRPlus`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVDynamicHDRPlus`](@ref) filled with default values or NULL on failure.
"""
function av_dynamic_hdr_plus_alloc(size)
    ccall((:av_dynamic_hdr_plus_alloc, libavutil), Ptr{AVDynamicHDRPlus}, (Ptr{Csize_t},), size)
end

"""
    av_dynamic_hdr_plus_create_side_data(frame)

Allocate a complete [`AVDynamicHDRPlus`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVDynamicHDRPlus`](@ref) structure to be filled by caller or NULL on failure.
"""
function av_dynamic_hdr_plus_create_side_data(frame)
    ccall((:av_dynamic_hdr_plus_create_side_data, libavutil), Ptr{AVDynamicHDRPlus}, (Ptr{AVFrame},), frame)
end

"""
    av_dynamic_hdr_plus_from_t35(s, data, size::Csize_t)

Parse the user data registered ITU-T T.35 to AVbuffer ([`AVDynamicHDRPlus`](@ref)). The T.35 buffer must begin with the application mode, skipping the country code, terminal provider codes, and application identifier.

# Arguments
* `s`: A pointer containing the decoded [`AVDynamicHDRPlus`](@ref) structure.
* `data`: The byte array containing the raw ITU-T T.35 data.
* `size`: Size of the data array in bytes.
# Returns
>= 0 on success. Otherwise, returns the appropriate [`AVERROR`](@ref).
"""
function av_dynamic_hdr_plus_from_t35(s, data, size::Csize_t)
    ccall((:av_dynamic_hdr_plus_from_t35, libavutil), Cint, (Ptr{AVDynamicHDRPlus}, Ptr{UInt8}, Csize_t), s, data, size)
end

"""
    av_dynamic_hdr_plus_to_t35(s, data, size)

Serialize dynamic HDR10+ metadata to a user data registered ITU-T T.35 buffer, excluding the first 48 bytes of the header, and beginning with the application mode.

# Arguments
* `s`: A pointer containing the decoded [`AVDynamicHDRPlus`](@ref) structure.
* `data`:\\[in,out\\] A pointer to pointer to a byte buffer to be filled with the serialized metadata. If *data is NULL, a buffer be will be allocated and a pointer to it stored in its place. The caller assumes ownership of the buffer. May be NULL, in which case the function will only store the required buffer size in *size.
* `size`:\\[in,out\\] A pointer to a size to be set to the returned buffer's size. If *data is not NULL, *size must contain the size of the input buffer. May be NULL only if *data is NULL.
# Returns
>= 0 on success. Otherwise, returns the appropriate [`AVERROR`](@ref).
"""
function av_dynamic_hdr_plus_to_t35(s, data, size)
    ccall((:av_dynamic_hdr_plus_to_t35, libavutil), Cint, (Ptr{AVDynamicHDRPlus}, Ptr{Ptr{UInt8}}, Ptr{Csize_t}), s, data, size)
end

"""
    AVHDRVivid3SplineParams

HDR Vivid three spline params.
"""
struct AVHDRVivid3SplineParams
    th_mode::Cint
    th_enable_mb::AVRational
    th_enable::AVRational
    th_delta1::AVRational
    th_delta2::AVRational
    enable_strength::AVRational
end

"""
    AVHDRVividColorToneMappingParams

Color tone mapping parameters at a processing window in a dynamic metadata for CUVA 005.1:2021.
"""
struct AVHDRVividColorToneMappingParams
    targeted_system_display_maximum_luminance::AVRational
    base_enable_flag::Cint
    base_param_m_p::AVRational
    base_param_m_m::AVRational
    base_param_m_a::AVRational
    base_param_m_b::AVRational
    base_param_m_n::AVRational
    base_param_k1::Cint
    base_param_k2::Cint
    base_param_k3::Cint
    base_param_Delta_enable_mode::Cint
    base_param_Delta::AVRational
    three_Spline_enable_flag::Cint
    three_Spline_num::Cint
    three_spline::NTuple{2, AVHDRVivid3SplineParams}
end

"""
    AVHDRVividColorTransformParams

Color transform parameters at a processing window in a dynamic metadata for CUVA 005.1:2021.
"""
struct AVHDRVividColorTransformParams
    minimum_maxrgb::AVRational
    average_maxrgb::AVRational
    variance_maxrgb::AVRational
    maximum_maxrgb::AVRational
    tone_mapping_mode_flag::Cint
    tone_mapping_param_num::Cint
    tm_params::NTuple{2, AVHDRVividColorToneMappingParams}
    color_saturation_mapping_flag::Cint
    color_saturation_num::Cint
    color_saturation_gain::NTuple{8, AVRational}
end

"""
    AVDynamicHDRVivid

This struct represents dynamic metadata for color volume transform - CUVA 005.1:2021 standard

To be used as payload of a [`AVFrameSideData`](@ref) or [`AVPacketSideData`](@ref) with the appropriate type.

!!! note

    The struct should be allocated with [`av_dynamic_hdr_vivid_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVDynamicHDRVivid
    system_start_code::UInt8
    num_windows::UInt8
    params::NTuple{3, AVHDRVividColorTransformParams}
end

"""
    av_dynamic_hdr_vivid_alloc(size)

Allocate an [`AVDynamicHDRVivid`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVDynamicHDRVivid`](@ref) filled with default values or NULL on failure.
"""
function av_dynamic_hdr_vivid_alloc(size)
    ccall((:av_dynamic_hdr_vivid_alloc, libavutil), Ptr{AVDynamicHDRVivid}, (Ptr{Csize_t},), size)
end

"""
    av_dynamic_hdr_vivid_create_side_data(frame)

Allocate a complete [`AVDynamicHDRVivid`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVDynamicHDRVivid`](@ref) structure to be filled by caller or NULL on failure.
"""
function av_dynamic_hdr_vivid_create_side_data(frame)
    ccall((:av_dynamic_hdr_vivid_create_side_data, libavutil), Ptr{AVDynamicHDRVivid}, (Ptr{AVFrame},), frame)
end

"""
    AVHMACType

` lavu_hmac HMAC`

` lavu_crypto`

@{
"""
const AVHMACType = UInt32
const AV_HMAC_MD5 = 0 % UInt32
const AV_HMAC_SHA1 = 1 % UInt32
const AV_HMAC_SHA224 = 2 % UInt32
const AV_HMAC_SHA256 = 3 % UInt32
const AV_HMAC_SHA384 = 4 % UInt32
const AV_HMAC_SHA512 = 5 % UInt32

mutable struct AVHMAC end

"""
    av_hmac_alloc(type::AVHMACType)

Allocate an [`AVHMAC`](@ref) context.

# Arguments
* `type`: The hash function used for the HMAC.
"""
function av_hmac_alloc(type::AVHMACType)
    ccall((:av_hmac_alloc, libavutil), Ptr{AVHMAC}, (AVHMACType,), type)
end

"""
    av_hmac_free(ctx)

Free an [`AVHMAC`](@ref) context.

# Arguments
* `ctx`: The context to free, may be NULL
"""
function av_hmac_free(ctx)
    ccall((:av_hmac_free, libavutil), Cvoid, (Ptr{AVHMAC},), ctx)
end

"""
    av_hmac_init(ctx, key, keylen::Integer)

Initialize an [`AVHMAC`](@ref) context with an authentication key.

# Arguments
* `ctx`: The HMAC context
* `key`: The authentication key
* `keylen`: The length of the key, in bytes
"""
function av_hmac_init(ctx, key, keylen::Integer)
    ccall((:av_hmac_init, libavutil), Cvoid, (Ptr{AVHMAC}, Ptr{UInt8}, Cuint), ctx, key, keylen)
end

"""
    av_hmac_update(ctx, data, len::Integer)

Hash data with the HMAC.

# Arguments
* `ctx`: The HMAC context
* `data`: The data to hash
* `len`: The length of the data, in bytes
"""
function av_hmac_update(ctx, data, len::Integer)
    ccall((:av_hmac_update, libavutil), Cvoid, (Ptr{AVHMAC}, Ptr{UInt8}, Cuint), ctx, data, len)
end

"""
    av_hmac_final(ctx, out, outlen::Integer)

Finish hashing and output the HMAC digest.

# Arguments
* `ctx`: The HMAC context
* `out`: The output buffer to write the digest into
* `outlen`: The length of the out buffer, in bytes
# Returns
The number of bytes written to out, or a negative error code.
"""
function av_hmac_final(ctx, out, outlen::Integer)
    ccall((:av_hmac_final, libavutil), Cint, (Ptr{AVHMAC}, Ptr{UInt8}, Cuint), ctx, out, outlen)
end

"""
    av_hmac_calc(ctx, data, len::Integer, key, keylen::Integer, out, outlen::Integer)

Hash an array of data with a key.

# Arguments
* `ctx`: The HMAC context
* `data`: The data to hash
* `len`: The length of the data, in bytes
* `key`: The authentication key
* `keylen`: The length of the key, in bytes
* `out`: The output buffer to write the digest into
* `outlen`: The length of the out buffer, in bytes
# Returns
The number of bytes written to out, or a negative error code.
"""
function av_hmac_calc(ctx, data, len::Integer, key, keylen::Integer, out, outlen::Integer)
    ccall((:av_hmac_calc, libavutil), Cint, (Ptr{AVHMAC}, Ptr{UInt8}, Cuint, Ptr{UInt8}, Cuint, Ptr{UInt8}, Cuint), ctx, data, len, key, keylen, out, outlen)
end

"""
    AVHWDeviceContext

This struct aggregates all the (hardware/vendor-specific) "high-level" state, i.e. state that is not tied to a concrete processing configuration. E.g., in an API that supports hardware-accelerated encoding and decoding, this struct will (if possible) wrap the state that is common to both encoding and decoding and from which specific instances of encoders or decoders can be derived.

This struct is reference-counted with the [`AVBuffer`](@ref) mechanism. The [`av_hwdevice_ctx_alloc`](@ref)() constructor yields a reference, whose data field points to the actual [`AVHWDeviceContext`](@ref). Further objects derived from [`AVHWDeviceContext`](@ref) (such as [`AVHWFramesContext`](@ref), describing a frame pool with specific properties) will hold an internal reference to it. After all the references are released, the [`AVHWDeviceContext`](@ref) itself will be freed, optionally invoking a user-specified callback for uninitializing the hardware state.
"""
struct AVHWDeviceContext
    av_class::Ptr{AVClass}
    type::AVHWDeviceType
    hwctx::Ptr{Cvoid}
    free::Ptr{Cvoid}
    user_opaque::Ptr{Cvoid}
end

"""
    AVHWFramesContext

This struct describes a set or pool of "hardware" frames (i.e. those with data not located in normal system memory). All the frames in the pool are assumed to be allocated in the same way and interchangeable.

This struct is reference-counted with the [`AVBuffer`](@ref) mechanism and tied to a given [`AVHWDeviceContext`](@ref) instance. The [`av_hwframe_ctx_alloc`](@ref)() constructor yields a reference, whose data field points to the actual [`AVHWFramesContext`](@ref) struct.
"""
struct AVHWFramesContext
    av_class::Ptr{AVClass}
    device_ref::Ptr{AVBufferRef}
    device_ctx::Ptr{AVHWDeviceContext}
    hwctx::Ptr{Cvoid}
    free::Ptr{Cvoid}
    user_opaque::Ptr{Cvoid}
    pool::Ptr{AVBufferPool}
    initial_pool_size::Cint
    format::AVPixelFormat
    sw_format::AVPixelFormat
    width::Cint
    height::Cint
end

"""
    av_hwdevice_find_type_by_name(name)

Look up an [`AVHWDeviceType`](@ref) by name.

# Arguments
* `name`: String name of the device type (case-insensitive).
# Returns
The type from enum [`AVHWDeviceType`](@ref), or AV\\_HWDEVICE\\_TYPE\\_NONE if not found.
"""
function av_hwdevice_find_type_by_name(name)
    ccall((:av_hwdevice_find_type_by_name, libavutil), AVHWDeviceType, (Cstring,), name)
end

"""
    av_hwdevice_get_type_name(type::AVHWDeviceType)

Get the string name of an [`AVHWDeviceType`](@ref).

# Arguments
* `type`: Type from enum [`AVHWDeviceType`](@ref).
# Returns
Pointer to a static string containing the name, or NULL if the type is not valid.
"""
function av_hwdevice_get_type_name(type::AVHWDeviceType)
    ccall((:av_hwdevice_get_type_name, libavutil), Cstring, (AVHWDeviceType,), type)
end

"""
    av_hwdevice_iterate_types(prev::AVHWDeviceType)

Iterate over supported device types.

# Arguments
* `prev`: AV\\_HWDEVICE\\_TYPE\\_NONE initially, then the previous type returned by this function in subsequent iterations.
# Returns
The next usable device type from enum [`AVHWDeviceType`](@ref), or AV\\_HWDEVICE\\_TYPE\\_NONE if there are no more.
"""
function av_hwdevice_iterate_types(prev::AVHWDeviceType)
    ccall((:av_hwdevice_iterate_types, libavutil), AVHWDeviceType, (AVHWDeviceType,), prev)
end

"""
    av_hwdevice_ctx_alloc(type::AVHWDeviceType)

Allocate an [`AVHWDeviceContext`](@ref) for a given hardware type.

# Arguments
* `type`: the type of the hardware device to allocate.
# Returns
a reference to the newly created [`AVHWDeviceContext`](@ref) on success or NULL on failure.
"""
function av_hwdevice_ctx_alloc(type::AVHWDeviceType)
    ccall((:av_hwdevice_ctx_alloc, libavutil), Ptr{AVBufferRef}, (AVHWDeviceType,), type)
end

"""
    av_hwdevice_ctx_init(ref)

Finalize the device context before use. This function must be called after the context is filled with all the required information and before it is used in any way.

# Arguments
* `ref`: a reference to the [`AVHWDeviceContext`](@ref)
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function av_hwdevice_ctx_init(ref)
    ccall((:av_hwdevice_ctx_init, libavutil), Cint, (Ptr{AVBufferRef},), ref)
end

"""
    av_hwdevice_ctx_create(device_ctx, type::AVHWDeviceType, device, opts, flags::Integer)

Open a device of the specified type and create an [`AVHWDeviceContext`](@ref) for it.

This is a convenience function intended to cover the simple cases. Callers who need to fine-tune device creation/management should open the device manually and then wrap it in an [`AVHWDeviceContext`](@ref) using [`av_hwdevice_ctx_alloc`](@ref)()/[`av_hwdevice_ctx_init`](@ref)().

The returned context is already initialized and ready for use, the caller should not call [`av_hwdevice_ctx_init`](@ref)() on it. The user\\_opaque/free fields of the created [`AVHWDeviceContext`](@ref) are set by this function and should not be touched by the caller.

# Arguments
* `device_ctx`: On success, a reference to the newly-created device context will be written here. The reference is owned by the caller and must be released with [`av_buffer_unref`](@ref)() when no longer needed. On failure, NULL will be written to this pointer.
* `type`: The type of the device to create.
* `device`: A type-specific string identifying the device to open.
* `opts`: A dictionary of additional (type-specific) options to use in opening the device. The dictionary remains owned by the caller.
* `flags`: currently unused
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_hwdevice_ctx_create(device_ctx, type::AVHWDeviceType, device, opts, flags::Integer)
    ccall((:av_hwdevice_ctx_create, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, AVHWDeviceType, Cstring, Ptr{AVDictionary}, Cint), device_ctx, type, device, opts, flags)
end

"""
    av_hwdevice_ctx_create_derived(dst_ctx, type::AVHWDeviceType, src_ctx, flags::Integer)

Create a new device of the specified type from an existing device.

If the source device is a device of the target type or was originally derived from such a device (possibly through one or more intermediate devices of other types), then this will return a reference to the existing device of the same type as is requested.

Otherwise, it will attempt to derive a new device from the given source device. If direct derivation to the new type is not implemented, it will attempt the same derivation from each ancestor of the source device in turn looking for an implemented derivation method.

# Arguments
* `dst_ctx`: On success, a reference to the newly-created [`AVHWDeviceContext`](@ref).
* `type`: The type of the new device to create.
* `src_ctx`: A reference to an existing [`AVHWDeviceContext`](@ref) which will be used to create the new device.
* `flags`: Currently unused; should be set to zero.
# Returns
Zero on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_hwdevice_ctx_create_derived(dst_ctx, type::AVHWDeviceType, src_ctx, flags::Integer)
    ccall((:av_hwdevice_ctx_create_derived, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, AVHWDeviceType, Ptr{AVBufferRef}, Cint), dst_ctx, type, src_ctx, flags)
end

"""
    av_hwdevice_ctx_create_derived_opts(dst_ctx, type::AVHWDeviceType, src_ctx, options, flags::Integer)

Create a new device of the specified type from an existing device.

This function performs the same action as [`av_hwdevice_ctx_create_derived`](@ref), however, it is able to set options for the new device to be derived.

# Arguments
* `dst_ctx`: On success, a reference to the newly-created [`AVHWDeviceContext`](@ref).
* `type`: The type of the new device to create.
* `src_ctx`: A reference to an existing [`AVHWDeviceContext`](@ref) which will be used to create the new device.
* `options`: Options for the new device to create, same format as in [`av_hwdevice_ctx_create`](@ref).
* `flags`: Currently unused; should be set to zero.
# Returns
Zero on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_hwdevice_ctx_create_derived_opts(dst_ctx, type::AVHWDeviceType, src_ctx, options, flags::Integer)
    ccall((:av_hwdevice_ctx_create_derived_opts, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, AVHWDeviceType, Ptr{AVBufferRef}, Ptr{AVDictionary}, Cint), dst_ctx, type, src_ctx, options, flags)
end

"""
    av_hwframe_ctx_alloc(device_ctx)

Allocate an [`AVHWFramesContext`](@ref) tied to a given device context.

# Arguments
* `device_ctx`: a reference to a [`AVHWDeviceContext`](@ref). This function will make a new reference for internal use, the one passed to the function remains owned by the caller.
# Returns
a reference to the newly created [`AVHWFramesContext`](@ref) on success or NULL on failure.
"""
function av_hwframe_ctx_alloc(device_ctx)
    ccall((:av_hwframe_ctx_alloc, libavutil), Ptr{AVBufferRef}, (Ptr{AVBufferRef},), device_ctx)
end

"""
    av_hwframe_ctx_init(ref)

Finalize the context before use. This function must be called after the context is filled with all the required information and before it is attached to any frames.

# Arguments
* `ref`: a reference to the [`AVHWFramesContext`](@ref)
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function av_hwframe_ctx_init(ref)
    ccall((:av_hwframe_ctx_init, libavutil), Cint, (Ptr{AVBufferRef},), ref)
end

"""
    av_hwframe_get_buffer(hwframe_ctx, frame, flags::Integer)

Allocate a new frame attached to the given [`AVHWFramesContext`](@ref).

# Arguments
* `hwframe_ctx`: a reference to an [`AVHWFramesContext`](@ref)
* `frame`: an empty (freshly allocated or unreffed) frame to be filled with newly allocated buffers.
* `flags`: currently unused, should be set to zero
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
"""
function av_hwframe_get_buffer(hwframe_ctx, frame, flags::Integer)
    ccall((:av_hwframe_get_buffer, libavutil), Cint, (Ptr{AVBufferRef}, Ptr{AVFrame}, Cint), hwframe_ctx, frame, flags)
end

"""
    av_hwframe_transfer_data(dst, src, flags::Integer)

Copy data to or from a hw surface. At least one of dst/src must have an [`AVHWFramesContext`](@ref) attached.

If src has an [`AVHWFramesContext`](@ref) attached, then the format of dst (if set) must use one of the formats returned by [`av_hwframe_transfer_get_formats`](@ref)(src, AV\\_HWFRAME\\_TRANSFER\\_DIRECTION\\_FROM). If dst has an [`AVHWFramesContext`](@ref) attached, then the format of src must use one of the formats returned by [`av_hwframe_transfer_get_formats`](@ref)(dst, AV\\_HWFRAME\\_TRANSFER\\_DIRECTION\\_TO)

dst may be "clean" (i.e. with data/buf pointers unset), in which case the data buffers will be allocated by this function using [`av_frame_get_buffer`](@ref)(). If dst->format is set, then this format will be used, otherwise (when dst->format is AV\\_PIX\\_FMT\\_NONE) the first acceptable format will be chosen.

The two frames must have matching allocated dimensions (i.e. equal to [`AVHWFramesContext`](@ref).width/height), since not all device types support transferring a sub-rectangle of the whole surface. The display dimensions (i.e. [`AVFrame`](@ref).width/height) may be smaller than the allocated dimensions, but also have to be equal for both frames. When the display dimensions are smaller than the allocated dimensions, the content of the padding in the destination frame is unspecified.

# Arguments
* `dst`: the destination frame. dst is not touched on failure.
* `src`: the source frame.
* `flags`: currently unused, should be set to zero
# Returns
0 on success, a negative [`AVERROR`](@ref) error code on failure.
"""
function av_hwframe_transfer_data(dst, src, flags::Integer)
    ccall((:av_hwframe_transfer_data, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}, Cint), dst, src, flags)
end

const AVHWFrameTransferDirection = UInt32
const AV_HWFRAME_TRANSFER_DIRECTION_FROM = 0 % UInt32
const AV_HWFRAME_TRANSFER_DIRECTION_TO = 1 % UInt32

"""
    av_hwframe_transfer_get_formats(hwframe_ctx, dir::AVHWFrameTransferDirection, formats, flags::Integer)

Get a list of possible source or target formats usable in [`av_hwframe_transfer_data`](@ref)().

# Arguments
* `hwframe_ctx`: the frame context to obtain the information for
* `dir`: the direction of the transfer
* `formats`: the pointer to the output format list will be written here. The list is terminated with AV\\_PIX\\_FMT\\_NONE and must be freed by the caller when no longer needed using [`av_free`](@ref)(). If this function returns successfully, the format list will have at least one item (not counting the terminator). On failure, the contents of this pointer are unspecified.
* `flags`: currently unused, should be set to zero
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function av_hwframe_transfer_get_formats(hwframe_ctx, dir::AVHWFrameTransferDirection, formats, flags::Integer)
    ccall((:av_hwframe_transfer_get_formats, libavutil), Cint, (Ptr{AVBufferRef}, AVHWFrameTransferDirection, Ptr{Ptr{AVPixelFormat}}, Cint), hwframe_ctx, dir, formats, flags)
end

"""
    AVHWFramesConstraints

This struct describes the constraints on hardware frames attached to a given device with a hardware-specific configuration. This is returned by [`av_hwdevice_get_hwframe_constraints`](@ref)() and must be freed by [`av_hwframe_constraints_free`](@ref)() after use.
"""
struct AVHWFramesConstraints
    valid_hw_formats::Ptr{AVPixelFormat}
    valid_sw_formats::Ptr{AVPixelFormat}
    min_width::Cint
    min_height::Cint
    max_width::Cint
    max_height::Cint
end

"""
    av_hwdevice_hwconfig_alloc(device_ctx)

Allocate a HW-specific configuration structure for a given HW device. After use, the user must free all members as required by the specific hardware structure being used, then free the structure itself with [`av_free`](@ref)().

# Arguments
* `device_ctx`: a reference to the associated [`AVHWDeviceContext`](@ref).
# Returns
The newly created HW-specific configuration structure on success or NULL on failure.
"""
function av_hwdevice_hwconfig_alloc(device_ctx)
    ccall((:av_hwdevice_hwconfig_alloc, libavutil), Ptr{Cvoid}, (Ptr{AVBufferRef},), device_ctx)
end

"""
    av_hwdevice_get_hwframe_constraints(ref, hwconfig)

Get the constraints on HW frames given a device and the HW-specific configuration to be used with that device. If no HW-specific configuration is provided, returns the maximum possible capabilities of the device.

# Arguments
* `ref`: a reference to the associated [`AVHWDeviceContext`](@ref).
* `hwconfig`: a filled HW-specific configuration structure, or NULL to return the maximum possible capabilities of the device.
# Returns
[`AVHWFramesConstraints`](@ref) structure describing the constraints on the device, or NULL if not available.
"""
function av_hwdevice_get_hwframe_constraints(ref, hwconfig)
    ccall((:av_hwdevice_get_hwframe_constraints, libavutil), Ptr{AVHWFramesConstraints}, (Ptr{AVBufferRef}, Ptr{Cvoid}), ref, hwconfig)
end

"""
    av_hwframe_constraints_free(constraints)

Free an AVHWFrameConstraints structure.

# Arguments
* `constraints`: The (filled or unfilled) AVHWFrameConstraints structure.
"""
function av_hwframe_constraints_free(constraints)
    ccall((:av_hwframe_constraints_free, libavutil), Cvoid, (Ptr{Ptr{AVHWFramesConstraints}},), constraints)
end

"""
    __JL_Ctag_64

Flags to apply to frame mappings.
"""
const __JL_Ctag_64 = UInt32
const AV_HWFRAME_MAP_READ = 1 % UInt32
const AV_HWFRAME_MAP_WRITE = 2 % UInt32
const AV_HWFRAME_MAP_OVERWRITE = 4 % UInt32
const AV_HWFRAME_MAP_DIRECT = 8 % UInt32

"""
    av_hwframe_map(dst, src, flags::Integer)

Map a hardware frame.

This has a number of different possible effects, depending on the format and origin of the src and dst frames. On input, src should be a usable frame with valid buffers and dst should be blank (typically as just created by [`av_frame_alloc`](@ref)()). src should have an associated hwframe context, and dst may optionally have a format and associated hwframe context.

If src was created by mapping a frame from the hwframe context of dst, then this function undoes the mapping - dst is replaced by a reference to the frame that src was originally mapped from.

If both src and dst have an associated hwframe context, then this function attempts to map the src frame from its hardware context to that of dst and then fill dst with appropriate data to be usable there. This will only be possible if the hwframe contexts and associated devices are compatible - given compatible devices, [`av_hwframe_ctx_create_derived`](@ref)() can be used to create a hwframe context for dst in which mapping should be possible.

If src has a hwframe context but dst does not, then the src frame is mapped to normal memory and should thereafter be usable as a normal frame. If the format is set on dst, then the mapping will attempt to create dst with that format and fail if it is not possible. If format is unset (is AV\\_PIX\\_FMT\\_NONE) then dst will be mapped with whatever the most appropriate format to use is (probably the sw\\_format of the src hwframe context).

A return value of [`AVERROR`](@ref)(ENOSYS) indicates that the mapping is not possible with the given arguments and hwframe setup, while other return values indicate that it failed somehow.

On failure, the destination frame will be left blank, except for the hw\\_frames\\_ctx/format fields they may have been set by the caller - those will be preserved as they were.

# Arguments
* `dst`: Destination frame, to contain the mapping.
* `src`: Source frame, to be mapped.
* `flags`: Some combination of AV\\_HWFRAME\\_MAP\\_* flags.
# Returns
Zero on success, negative [`AVERROR`](@ref) code on failure.
"""
function av_hwframe_map(dst, src, flags::Integer)
    ccall((:av_hwframe_map, libavutil), Cint, (Ptr{AVFrame}, Ptr{AVFrame}, Cint), dst, src, flags)
end

"""
    av_hwframe_ctx_create_derived(derived_frame_ctx, format::AVPixelFormat, derived_device_ctx, source_frame_ctx, flags::Integer)

Create and initialise an [`AVHWFramesContext`](@ref) as a mapping of another existing [`AVHWFramesContext`](@ref) on a different device.

[`av_hwframe_ctx_init`](@ref)() should not be called after this.

# Arguments
* `derived_frame_ctx`: On success, a reference to the newly created [`AVHWFramesContext`](@ref).
* `format`: The [`AVPixelFormat`](@ref) for the derived context.
* `derived_device_ctx`: A reference to the device to create the new [`AVHWFramesContext`](@ref) on.
* `source_frame_ctx`: A reference to an existing [`AVHWFramesContext`](@ref) which will be mapped to the derived context.
* `flags`: Some combination of AV\\_HWFRAME\\_MAP\\_* flags, defining the mapping parameters to apply to frames which are allocated in the derived device.
# Returns
Zero on success, negative [`AVERROR`](@ref) code on failure.
"""
function av_hwframe_ctx_create_derived(derived_frame_ctx, format::AVPixelFormat, derived_device_ctx, source_frame_ctx, flags::Integer)
    ccall((:av_hwframe_ctx_create_derived, libavutil), Cint, (Ptr{Ptr{AVBufferRef}}, AVPixelFormat, Ptr{AVBufferRef}, Ptr{AVBufferRef}, Cint), derived_frame_ctx, format, derived_device_ctx, source_frame_ctx, flags)
end

struct AVAMFDeviceContext
    library::Ptr{Cvoid}
    factory::Ptr{Cint}
    trace_writer::Ptr{Cvoid}
    version::Int64
    context::Ptr{Cint}
    memory_type::Cint
end

mutable struct AMF_SURFACE_FORMAT end

function av_av_to_amf_format(fmt::AVPixelFormat)
    ccall((:av_av_to_amf_format, libavutil), AMF_SURFACE_FORMAT, (AVPixelFormat,), fmt)
end

function av_amf_to_av_format(fmt::AMF_SURFACE_FORMAT)
    ccall((:av_amf_to_av_format, libavutil), AVPixelFormat, (AMF_SURFACE_FORMAT,), fmt)
end

mutable struct AVCUDADeviceContextInternal end

struct AVCUDADeviceContext
    cuda_ctx::Cint
    stream::Cint
    internal::Ptr{AVCUDADeviceContextInternal}
end

struct AVD3D11VADeviceContext
    device::Ptr{Cint}
    device_context::Ptr{Cint}
    video_device::Ptr{Cint}
    video_context::Ptr{Cint}
    lock::Ptr{Cvoid}
    unlock::Ptr{Cvoid}
    lock_ctx::Ptr{Cvoid}
end

struct AVD3D11FrameDescriptor
    texture::Ptr{Cint}
    index::intptr_t
end

struct AVD3D11VAFramesContext
    texture::Ptr{Cint}
    BindFlags::Cint
    MiscFlags::Cint
    texture_infos::Ptr{AVD3D11FrameDescriptor}
end

struct AVD3D12VADeviceContext
    device::Ptr{Cint}
    video_device::Ptr{Cint}
    lock::Ptr{Cvoid}
    unlock::Ptr{Cvoid}
    lock_ctx::Ptr{Cvoid}
end

struct AVD3D12VASyncContext
    fence::Ptr{Cint}
    event::Cint
    fence_value::UInt64
end

struct AVD3D12VAFrame
    texture::Ptr{Cint}
    sync_ctx::AVD3D12VASyncContext
end

struct AVD3D12VAFramesContext
    format::Cint
    flags::Cint
end

"""
    __JL_Ctag_68

``

API-specific header for AV\\_HWDEVICE\\_TYPE\\_DRM.

Internal frame allocation is not currently supported - all frames must be allocated by the user. Thus [`AVHWFramesContext`](@ref) is always NULL, though this may change if support for frame allocation is added in future.
"""
const __JL_Ctag_68 = UInt32
const AV_DRM_MAX_PLANES = 4 % UInt32

"""
    AVDRMObjectDescriptor

DRM object descriptor.

Describes a single DRM object, addressing it as a PRIME file descriptor.
"""
struct AVDRMObjectDescriptor
    fd::Cint
    size::Csize_t
    format_modifier::UInt64
end

"""
    AVDRMPlaneDescriptor

DRM plane descriptor.

Describes a single plane of a layer, which is contained within a single object.
"""
struct AVDRMPlaneDescriptor
    object_index::Cint
    offset::Cptrdiff_t
    pitch::Cptrdiff_t
end

"""
    AVDRMLayerDescriptor

DRM layer descriptor.

Describes a single layer within a frame. This has the structure defined by its format, and will contain one or more planes.
"""
struct AVDRMLayerDescriptor
    format::UInt32
    nb_planes::Cint
    planes::NTuple{4, AVDRMPlaneDescriptor}
end

"""
    AVDRMFrameDescriptor

DRM frame descriptor.

This is used as the data pointer for AV\\_PIX\\_FMT\\_DRM\\_PRIME frames. It is also used by user-allocated frame pools - allocating in [`AVHWFramesContext`](@ref).pool must return AVBufferRefs which contain an object of this type.

The fields of this structure should be set such it can be imported directly by EGL using the EGL\\_EXT\\_image\\_dma\\_buf\\_import and EGL\\_EXT\\_image\\_dma\\_buf\\_import\\_modifiers extensions. (Note that the exact layout of a particular format may vary between platforms - we only specify that the same platform should be able to import it.)

The total number of planes must not exceed AV\\_DRM\\_MAX\\_PLANES, and the order of the planes by increasing layer index followed by increasing plane index must be the same as the order which would be used for the data pointers in the equivalent software format.
"""
struct AVDRMFrameDescriptor
    nb_objects::Cint
    objects::NTuple{4, AVDRMObjectDescriptor}
    nb_layers::Cint
    layers::NTuple{4, AVDRMLayerDescriptor}
end

"""
    AVDRMDeviceContext

DRM device.

Allocated as [`AVHWDeviceContext`](@ref).hwctx.
"""
struct AVDRMDeviceContext
    fd::Cint
end

struct AVDXVA2DeviceContext
    devmgr::Ptr{Cint}
end

struct AVDXVA2FramesContext
    surface_type::Cint
    surfaces::Ptr{Ptr{Cint}}
    nb_surfaces::Cint
    decoder_to_release::Ptr{Cint}
end

"""
    AVMediaCodecDeviceContext

MediaCodec details.

Allocated as [`AVHWDeviceContext`](@ref).hwctx
"""
struct AVMediaCodecDeviceContext
    surface::Ptr{Cvoid}
    native_window::Ptr{Cvoid}
    create_window::Cint
end

"""
    AVOHCodecDeviceContext

OpenHarmony codec device
"""
struct AVOHCodecDeviceContext
    native_window::Ptr{Cvoid}
end

"""
    AVOpenCLFrameDescriptor

OpenCL frame descriptor for pool allocation.

In user-allocated pools, [`AVHWFramesContext`](@ref).pool must return AVBufferRefs with the data pointer pointing at an object of this type describing the planes of the frame.
"""
struct AVOpenCLFrameDescriptor
    nb_planes::Cint
    planes::NTuple{8, cl_mem}
end

"""
    AVOpenCLDeviceContext

OpenCL device details.

Allocated as [`AVHWDeviceContext`](@ref).hwctx
"""
struct AVOpenCLDeviceContext
    device_id::cl_device_id
    context::cl_context
    command_queue::cl_command_queue
end

"""
    AVOpenCLFramesContext

OpenCL-specific data associated with a frame pool.

Allocated as [`AVHWFramesContext`](@ref).hwctx.
"""
struct AVOpenCLFramesContext
    command_queue::cl_command_queue
end

struct AVQSVDeviceContext
    session::Cint
    loader::Ptr{Cvoid}
end

struct AVQSVFramesContext
    surfaces::Ptr{Cint}
    nb_surfaces::Cint
    frame_type::Cint
    info::Ptr{Cint}
end

"""
    __JL_Ctag_71

``

API-specific header for AV\\_HWDEVICE\\_TYPE\\_VAAPI.

Dynamic frame pools are supported, but note that any pool used as a render target is required to be of fixed size in order to be be usable as an argument to vaCreateContext().

For user-allocated pools, [`AVHWFramesContext`](@ref).pool must return AVBufferRefs with the data pointer set to a [`VASurfaceID`](@ref).
"""
const __JL_Ctag_71 = UInt32
const AV_VAAPI_DRIVER_QUIRK_USER_SET = 1 % UInt32
const AV_VAAPI_DRIVER_QUIRK_RENDER_PARAM_BUFFERS = 2 % UInt32
const AV_VAAPI_DRIVER_QUIRK_ATTRIB_MEMTYPE = 4 % UInt32
const AV_VAAPI_DRIVER_QUIRK_SURFACE_ATTRIBUTES = 8 % UInt32

"""
    AVVAAPIDeviceContext

VAAPI connection details.

Allocated as [`AVHWDeviceContext`](@ref).hwctx
"""
struct AVVAAPIDeviceContext
    display::VADisplay
    driver_quirks::Cuint
end

"""
    AVVAAPIFramesContext

VAAPI-specific data associated with a frame pool.

Allocated as [`AVHWFramesContext`](@ref).hwctx.
"""
struct AVVAAPIFramesContext
    attributes::Ptr{VASurfaceAttrib}
    nb_attributes::Cint
    surface_ids::Ptr{VASurfaceID}
    nb_surfaces::Cint
end

"""
    AVVAAPIHWConfig

VAAPI hardware pipeline configuration details.

Allocated with [`av_hwdevice_hwconfig_alloc`](@ref)().
"""
struct AVVAAPIHWConfig
    config_id::VAConfigID
end

"""
    AVVDPAUDeviceContext

This struct is allocated as [`AVHWDeviceContext`](@ref).hwctx
"""
struct AVVDPAUDeviceContext
    device::VdpDevice
    get_proc_address::Ptr{VdpGetProcAddress}
end

"""
    AVVTFramesContext

``

An API-specific header for AV\\_HWDEVICE\\_TYPE\\_VIDEOTOOLBOX.

This API supports frame allocation using a native CVPixelBufferPool instead of an [`AVBufferPool`](@ref).

If the API user sets a custom pool, [`AVHWFramesContext`](@ref).pool must return AVBufferRefs whose data pointer is a CVImageBufferRef or CVPixelBufferRef. Note that the underlying CVPixelBuffer could be retained by OS frameworks depending on application usage, so it is preferable to let CoreVideo manage the pool using the default implementation.

Currently [`AVHWDeviceContext`](@ref).hwctx are always NULL.
"""
struct AVVTFramesContext
    color_range::AVColorRange
end

"""
    av_map_videotoolbox_format_to_pixfmt(cv_fmt::Integer)

Convert a VideoToolbox (actually CoreVideo) format to [`AVPixelFormat`](@ref). Returns AV\\_PIX\\_FMT\\_NONE if no known equivalent was found.
"""
function av_map_videotoolbox_format_to_pixfmt(cv_fmt::Integer)
    ccall((:av_map_videotoolbox_format_to_pixfmt, libavutil), AVPixelFormat, (UInt32,), cv_fmt)
end

"""
    av_map_videotoolbox_format_from_pixfmt(pix_fmt::AVPixelFormat)

Convert an [`AVPixelFormat`](@ref) to a VideoToolbox (actually CoreVideo) format. Returns 0 if no known equivalent was found.
"""
function av_map_videotoolbox_format_from_pixfmt(pix_fmt::AVPixelFormat)
    ccall((:av_map_videotoolbox_format_from_pixfmt, libavutil), UInt32, (AVPixelFormat,), pix_fmt)
end

function av_map_videotoolbox_format_from_pixfmt2(pix_fmt::AVPixelFormat, full_range::Integer)
    ccall((:av_map_videotoolbox_format_from_pixfmt2, libavutil), UInt32, (AVPixelFormat, Cint), pix_fmt, full_range)
end

function av_map_videotoolbox_chroma_loc_from_av(loc::AVChromaLocation)
    ccall((:av_map_videotoolbox_chroma_loc_from_av, libavutil), Cint, (AVChromaLocation,), loc)
end

function av_map_videotoolbox_color_matrix_from_av(space::AVColorSpace)
    ccall((:av_map_videotoolbox_color_matrix_from_av, libavutil), Cint, (AVColorSpace,), space)
end

function av_map_videotoolbox_color_primaries_from_av(pri::AVColorPrimaries)
    ccall((:av_map_videotoolbox_color_primaries_from_av, libavutil), Cint, (AVColorPrimaries,), pri)
end

function av_map_videotoolbox_color_trc_from_av(trc::AVColorTransferCharacteristic)
    ccall((:av_map_videotoolbox_color_trc_from_av, libavutil), Cint, (AVColorTransferCharacteristic,), trc)
end

function av_vt_pixbuf_set_attachments(log_ctx, pixbuf::Integer, src)
    ccall((:av_vt_pixbuf_set_attachments, libavutil), Cint, (Ptr{Cvoid}, Cint, Ptr{AVFrame}), log_ctx, pixbuf, src)
end

mutable struct AVVkFrameInternal end

struct AVVkFrame
    img::NTuple{8, Cint}
    tiling::Cint
    mem::NTuple{8, Cint}
    size::NTuple{8, Csize_t}
    flags::Cint
    access::NTuple{8, Cint}
    layout::NTuple{8, Cint}
    sem::NTuple{8, Cint}
    sem_value::NTuple{8, UInt64}
    internal::Ptr{AVVkFrameInternal}
    offset::NTuple{8, Cptrdiff_t}
    queue_family::NTuple{8, UInt32}
end

struct AVVulkanDeviceQueueFamily
    idx::Cint
    num::Cint
    flags::Cint
    video_caps::Cint
end

struct AVVulkanDeviceContext
    alloc::Ptr{Cint}
    get_proc_addr::Cint
    inst::Cint
    phys_dev::Cint
    act_dev::Cint
    device_features::Cint
    enabled_inst_extensions::Ptr{Cstring}
    nb_enabled_inst_extensions::Cint
    enabled_dev_extensions::Ptr{Cstring}
    nb_enabled_dev_extensions::Cint
    queue_family_index::Cint
    nb_graphics_queues::Cint
    queue_family_tx_index::Cint
    nb_tx_queues::Cint
    queue_family_comp_index::Cint
    nb_comp_queues::Cint
    queue_family_encode_index::Cint
    nb_encode_queues::Cint
    queue_family_decode_index::Cint
    nb_decode_queues::Cint
    lock_queue::Ptr{Cvoid}
    unlock_queue::Ptr{Cvoid}
    qf::NTuple{64, AVVulkanDeviceQueueFamily}
    nb_qf::Cint
end

"""
    AVVkFrameFlags

Defines the behaviour of frame allocation.
"""
const AVVkFrameFlags = UInt32
const AV_VK_FRAME_FLAG_NONE = 1 % UInt32
const AV_VK_FRAME_FLAG_DISABLE_MULTIPLANE = 4 % UInt32

struct AVVulkanFramesContext
    tiling::Cint
    usage::Cint
    create_pnext::Ptr{Cvoid}
    alloc_pnext::NTuple{8, Ptr{Cvoid}}
    flags::AVVkFrameFlags
    img_flags::Cint
    format::NTuple{8, Cint}
    nb_layers::Cint
    lock_frame::Ptr{Cvoid}
    unlock_frame::Ptr{Cvoid}
end

"""
    av_vk_frame_alloc()

Allocates a single [`AVVkFrame`](@ref) and initializes everything as 0.

!!! note

    Must be freed via [`av_free`](@ref)()
"""
function av_vk_frame_alloc()
    ccall((:av_vk_frame_alloc, libavutil), Ptr{AVVkFrame}, ())
end

function av_vkfmt_from_pixfmt(p::AVPixelFormat)
    ccall((:av_vkfmt_from_pixfmt, libavutil), Ptr{Cint}, (AVPixelFormat,), p)
end

"""
    AVIAMFAnimationType

` lavu_iamf Immersive Audio Model and Formats`

` lavu_audio`

Immersive Audio Model and Formats related functions and defines

` lavu_iamf_params Parameter Definition`

` lavu_iamf`

@{ Parameters as defined in section 3.6.1 and 3.8 of IAMF. @}

` lavu_iamf_audio Audio Element`

` lavu_iamf`

@{ Audio Elements as defined in section 3.6 of IAMF. @}

` lavu_iamf_mix Mix Presentation`

` lavu_iamf`

@{ Mix Presentations as defined in section 3.7 of IAMF. @}

` lavu_iamf_params`

@{
"""
const AVIAMFAnimationType = UInt32
const AV_IAMF_ANIMATION_TYPE_STEP = 0 % UInt32
const AV_IAMF_ANIMATION_TYPE_LINEAR = 1 % UInt32
const AV_IAMF_ANIMATION_TYPE_BEZIER = 2 % UInt32

"""
    AVIAMFMixGain

Mix Gain Parameter Data as defined in section 3.8.1 of IAMF.

!!! note

    This struct's size is not a part of the public ABI.
"""
struct AVIAMFMixGain
    av_class::Ptr{AVClass}
    subblock_duration::Cuint
    animation_type::AVIAMFAnimationType
    start_point_value::AVRational
    end_point_value::AVRational
    control_point_value::AVRational
    control_point_relative_time::AVRational
end

"""
    AVIAMFDemixingInfo

Demixing Info Parameter Data as defined in section 3.8.2 of IAMF.

!!! note

    This struct's size is not a part of the public ABI.
"""
struct AVIAMFDemixingInfo
    av_class::Ptr{AVClass}
    subblock_duration::Cuint
    dmixp_mode::Cuint
end

"""
    AVIAMFReconGain

Recon Gain Info Parameter Data as defined in section 3.8.3 of IAMF.

!!! note

    This struct's size is not a part of the public ABI.
"""
struct AVIAMFReconGain
    av_class::Ptr{AVClass}
    subblock_duration::Cuint
    recon_gain::NTuple{6, NTuple{12, UInt8}}
end

const AVIAMFParamDefinitionType = UInt32
const AV_IAMF_PARAMETER_DEFINITION_MIX_GAIN = 0 % UInt32
const AV_IAMF_PARAMETER_DEFINITION_DEMIXING = 1 % UInt32
const AV_IAMF_PARAMETER_DEFINITION_RECON_GAIN = 2 % UInt32

"""
    AVIAMFParamDefinition

Parameters as defined in section 3.6.1 of IAMF.

The struct is allocated by [`av_iamf_param_definition_alloc`](@ref)() along with an array of subblocks, its type depending on the value of type. This array is placed subblocks\\_offset bytes after the start of this struct.

!!! note

    This struct's size is not a part of the public ABI.
"""
struct AVIAMFParamDefinition
    av_class::Ptr{AVClass}
    subblocks_offset::Csize_t
    subblock_size::Csize_t
    nb_subblocks::Cuint
    type::AVIAMFParamDefinitionType
    parameter_id::Cuint
    parameter_rate::Cuint
    duration::Cuint
    constant_subblock_duration::Cuint
end

function av_iamf_param_definition_get_class()
    ccall((:av_iamf_param_definition_get_class, libavutil), Ptr{AVClass}, ())
end

"""
    av_iamf_param_definition_alloc(type::AVIAMFParamDefinitionType, nb_subblocks::Integer, size)

Allocates memory for [`AVIAMFParamDefinition`](@ref), plus an array of {

```c++
 nb_subblocks}
 amount of subblocks of the given type and initializes the variables. Can be
 freed with a normal av_free() call.

 @param size if non-NULL, the size in bytes of the resulting data array is written here.
 

```
"""
function av_iamf_param_definition_alloc(type::AVIAMFParamDefinitionType, nb_subblocks::Integer, size)
    ccall((:av_iamf_param_definition_alloc, libavutil), Ptr{AVIAMFParamDefinition}, (AVIAMFParamDefinitionType, Cuint, Ptr{Csize_t}), type, nb_subblocks, size)
end

"""
    av_iamf_param_definition_get_subblock(par, idx::Integer)

Get the subblock at the specified {

```c++
 idx}. Must be between 0 and nb_subblocks - 1.

 The @ref AVIAMFParamDefinition.type "param definition type" defines
 the struct type of the returned pointer.
 

```
"""
function av_iamf_param_definition_get_subblock(par, idx::Integer)
    ccall((:av_iamf_param_definition_get_subblock, libavutil), Ptr{Cvoid}, (Ptr{AVIAMFParamDefinition}, Cuint), par, idx)
end

"""
    AVIAMFAmbisonicsMode

@}

` lavu_iamf_audio`

@{
"""
const AVIAMFAmbisonicsMode = UInt32
const AV_IAMF_AMBISONICS_MODE_MONO = 0 % UInt32
const AV_IAMF_AMBISONICS_MODE_PROJECTION = 1 % UInt32

"""
    AVIAMFLayer

A layer defining a Channel Layout in the Audio Element.

When AVIAMFAudioElement.audio_element_type "the parent's Audio Element type" is AV\\_IAMF\\_AUDIO\\_ELEMENT\\_TYPE\\_CHANNEL, this corresponds to an Scalable Channel Layout layer as defined in section 3.6.2 of IAMF. For AV\\_IAMF\\_AUDIO\\_ELEMENT\\_TYPE\\_SCENE, it is an Ambisonics channel layout as defined in section 3.6.3 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_audio_element_add_layer`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFLayer
    data::NTuple{64, UInt8}
end

function Base.getproperty(x::Ptr{AVIAMFLayer}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :ch_layout && return Ptr{AVChannelLayout}(x + 8)
    f === :flags && return Ptr{Cuint}(x + 32)
    f === :output_gain_flags && return Ptr{Cuint}(x + 36)
    f === :output_gain && return Ptr{AVRational}(x + 40)
    f === :ambisonics_mode && return Ptr{AVIAMFAmbisonicsMode}(x + 48)
    f === :demixing_matrix && return Ptr{Ptr{AVRational}}(x + 56)
    return getfield(x, f)
end

function Base.getproperty(x::AVIAMFLayer, f::Symbol)
    r = Ref{AVIAMFLayer}(x)
    ptr = Base.unsafe_convert(Ptr{AVIAMFLayer}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVIAMFLayer}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVIAMFLayer, private::Bool = false)
    (:av_class, :ch_layout, :flags, :output_gain_flags, :output_gain, :ambisonics_mode, :demixing_matrix, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

const AVIAMFAudioElementType = UInt32
const AV_IAMF_AUDIO_ELEMENT_TYPE_CHANNEL = 0 % UInt32
const AV_IAMF_AUDIO_ELEMENT_TYPE_SCENE = 1 % UInt32

"""
    AVIAMFAudioElement

Information on how to combine one or more audio streams, as defined in section 3.6 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_audio_element_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFAudioElement
    av_class::Ptr{AVClass}
    layers::Ptr{Ptr{AVIAMFLayer}}
    nb_layers::Cuint
    demixing_info::Ptr{AVIAMFParamDefinition}
    recon_gain_info::Ptr{AVIAMFParamDefinition}
    audio_element_type::AVIAMFAudioElementType
    default_w::Cuint
end

function av_iamf_audio_element_get_class()
    ccall((:av_iamf_audio_element_get_class, libavutil), Ptr{AVClass}, ())
end

"""
    av_iamf_audio_element_alloc()

Allocates a [`AVIAMFAudioElement`](@ref), and initializes its fields with default values. No layers are allocated. Must be freed with [`av_iamf_audio_element_free`](@ref)().

# See also
[`av_iamf_audio_element_add_layer`](@ref)()
"""
function av_iamf_audio_element_alloc()
    ccall((:av_iamf_audio_element_alloc, libavutil), Ptr{AVIAMFAudioElement}, ())
end

"""
    av_iamf_audio_element_add_layer(audio_element)

Allocate a layer and add it to a given [`AVIAMFAudioElement`](@ref). It is freed by [`av_iamf_audio_element_free`](@ref)() alongside the rest of the parent [`AVIAMFAudioElement`](@ref).

# Returns
a pointer to the allocated layer.
"""
function av_iamf_audio_element_add_layer(audio_element)
    ccall((:av_iamf_audio_element_add_layer, libavutil), Ptr{AVIAMFLayer}, (Ptr{AVIAMFAudioElement},), audio_element)
end

"""
    av_iamf_audio_element_free(audio_element)

Free an [`AVIAMFAudioElement`](@ref) and all its contents.

# Arguments
* `audio_element`: pointer to pointer to an allocated [`AVIAMFAudioElement`](@ref). upon return, *audio\\_element will be set to NULL.
"""
function av_iamf_audio_element_free(audio_element)
    ccall((:av_iamf_audio_element_free, libavutil), Cvoid, (Ptr{Ptr{AVIAMFAudioElement}},), audio_element)
end

"""
    AVIAMFHeadphonesMode

@}

` lavu_iamf_mix`

@{
"""
const AVIAMFHeadphonesMode = UInt32
const AV_IAMF_HEADPHONES_MODE_STEREO = 0 % UInt32
const AV_IAMF_HEADPHONES_MODE_BINAURAL = 1 % UInt32

"""
    AVIAMFSubmixElement

Submix element as defined in section 3.7 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_submix_add_element`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFSubmixElement
    av_class::Ptr{AVClass}
    audio_element_id::Cuint
    element_mix_config::Ptr{AVIAMFParamDefinition}
    default_mix_gain::AVRational
    headphones_rendering_mode::AVIAMFHeadphonesMode
    annotations::Ptr{AVDictionary}
end

const AVIAMFSubmixLayoutType = UInt32
const AV_IAMF_SUBMIX_LAYOUT_TYPE_LOUDSPEAKERS = 2 % UInt32
const AV_IAMF_SUBMIX_LAYOUT_TYPE_BINAURAL = 3 % UInt32

"""
    AVIAMFSubmixLayout

Submix layout as defined in section 3.7.6 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_submix_add_layout`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFSubmixLayout
    data::NTuple{80, UInt8}
end

function Base.getproperty(x::Ptr{AVIAMFSubmixLayout}, f::Symbol)
    f === :av_class && return Ptr{Ptr{AVClass}}(x + 0)
    f === :layout_type && return Ptr{AVIAMFSubmixLayoutType}(x + 8)
    f === :sound_system && return Ptr{AVChannelLayout}(x + 16)
    f === :integrated_loudness && return Ptr{AVRational}(x + 40)
    f === :digital_peak && return Ptr{AVRational}(x + 48)
    f === :true_peak && return Ptr{AVRational}(x + 56)
    f === :dialogue_anchored_loudness && return Ptr{AVRational}(x + 64)
    f === :album_anchored_loudness && return Ptr{AVRational}(x + 72)
    return getfield(x, f)
end

function Base.getproperty(x::AVIAMFSubmixLayout, f::Symbol)
    r = Ref{AVIAMFSubmixLayout}(x)
    ptr = Base.unsafe_convert(Ptr{AVIAMFSubmixLayout}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVIAMFSubmixLayout}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVIAMFSubmixLayout, private::Bool = false)
    (:av_class, :layout_type, :sound_system, :integrated_loudness, :digital_peak, :true_peak, :dialogue_anchored_loudness, :album_anchored_loudness, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVIAMFSubmix

Submix layout as defined in section 3.7 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_mix_presentation_add_submix`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFSubmix
    av_class::Ptr{AVClass}
    elements::Ptr{Ptr{AVIAMFSubmixElement}}
    nb_elements::Cuint
    layouts::Ptr{Ptr{AVIAMFSubmixLayout}}
    nb_layouts::Cuint
    output_mix_config::Ptr{AVIAMFParamDefinition}
    default_mix_gain::AVRational
end

"""
    AVIAMFMixPresentation

Information on how to render and mix one or more [`AVIAMFAudioElement`](@ref) to generate the final audio output, as defined in section 3.7 of IAMF.

!!! note

    The struct should be allocated with [`av_iamf_mix_presentation_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVIAMFMixPresentation
    av_class::Ptr{AVClass}
    submixes::Ptr{Ptr{AVIAMFSubmix}}
    nb_submixes::Cuint
    annotations::Ptr{AVDictionary}
end

function av_iamf_mix_presentation_get_class()
    ccall((:av_iamf_mix_presentation_get_class, libavutil), Ptr{AVClass}, ())
end

"""
    av_iamf_mix_presentation_alloc()

Allocates a [`AVIAMFMixPresentation`](@ref), and initializes its fields with default values. No submixes are allocated. Must be freed with [`av_iamf_mix_presentation_free`](@ref)().

# See also
[`av_iamf_mix_presentation_add_submix`](@ref)()
"""
function av_iamf_mix_presentation_alloc()
    ccall((:av_iamf_mix_presentation_alloc, libavutil), Ptr{AVIAMFMixPresentation}, ())
end

"""
    av_iamf_mix_presentation_add_submix(mix_presentation)

Allocate a submix and add it to a given [`AVIAMFMixPresentation`](@ref). It is freed by [`av_iamf_mix_presentation_free`](@ref)() alongside the rest of the parent [`AVIAMFMixPresentation`](@ref).

# Returns
a pointer to the allocated submix.
"""
function av_iamf_mix_presentation_add_submix(mix_presentation)
    ccall((:av_iamf_mix_presentation_add_submix, libavutil), Ptr{AVIAMFSubmix}, (Ptr{AVIAMFMixPresentation},), mix_presentation)
end

"""
    av_iamf_submix_add_element(submix)

Allocate a submix element and add it to a given [`AVIAMFSubmix`](@ref). It is freed by [`av_iamf_mix_presentation_free`](@ref)() alongside the rest of the parent [`AVIAMFSubmix`](@ref).

# Returns
a pointer to the allocated submix.
"""
function av_iamf_submix_add_element(submix)
    ccall((:av_iamf_submix_add_element, libavutil), Ptr{AVIAMFSubmixElement}, (Ptr{AVIAMFSubmix},), submix)
end

"""
    av_iamf_submix_add_layout(submix)

Allocate a submix layout and add it to a given [`AVIAMFSubmix`](@ref). It is freed by [`av_iamf_mix_presentation_free`](@ref)() alongside the rest of the parent [`AVIAMFSubmix`](@ref).

# Returns
a pointer to the allocated submix.
"""
function av_iamf_submix_add_layout(submix)
    ccall((:av_iamf_submix_add_layout, libavutil), Ptr{AVIAMFSubmixLayout}, (Ptr{AVIAMFSubmix},), submix)
end

"""
    av_iamf_mix_presentation_free(mix_presentation)

Free an [`AVIAMFMixPresentation`](@ref) and all its contents.

# Arguments
* `mix_presentation`: pointer to pointer to an allocated [`AVIAMFMixPresentation`](@ref). upon return, *mix\\_presentation will be set to NULL.
"""
function av_iamf_mix_presentation_free(mix_presentation)
    ccall((:av_iamf_mix_presentation_free, libavutil), Cvoid, (Ptr{Ptr{AVIAMFMixPresentation}},), mix_presentation)
end

struct AVComponentDescriptor
    plane::Cint
    step::Cint
    offset::Cint
    shift::Cint
    depth::Cint
end

"""
    AVPixFmtDescriptor

Descriptor that unambiguously describes how the bits of a pixel are stored in the up to 4 data planes of an image. It also stores the subsampling factors and number of components.

!!! note

    This is separate of the colorspace (RGB, YCbCr, YPbPr, JPEG-style YUV and all the YUV variants) [`AVPixFmtDescriptor`](@ref) just stores how values are stored not what these values represent.
"""
struct AVPixFmtDescriptor
    name::Cstring
    nb_components::UInt8
    log2_chroma_w::UInt8
    log2_chroma_h::UInt8
    flags::UInt64
    comp::NTuple{4, AVComponentDescriptor}
    alias::Cstring
end

"""
    av_image_fill_max_pixsteps(max_pixsteps, max_pixstep_comps, pixdesc)

Compute the max pixel step for each plane of an image with a format described by pixdesc.

The pixel step is the distance in bytes between the first byte of the group of bytes which describe a pixel component and the first byte of the successive group in the same plane for the same component.

# Arguments
* `max_pixsteps`: an array which is filled with the max pixel step for each plane. Since a plane may contain different pixel components, the computed max\\_pixsteps[plane] is relative to the component in the plane with the max pixel step.
* `max_pixstep_comps`: an array which is filled with the component for each plane which has the max pixel step. May be NULL.
* `pixdesc`: the [`AVPixFmtDescriptor`](@ref) for the image, describing its format
"""
function av_image_fill_max_pixsteps(max_pixsteps, max_pixstep_comps, pixdesc)
    ccall((:av_image_fill_max_pixsteps, libavutil), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{AVPixFmtDescriptor}), max_pixsteps, max_pixstep_comps, pixdesc)
end

"""
    av_image_get_linesize(pix_fmt::AVPixelFormat, width::Integer, plane::Integer)

Compute the size of an image line with format pix\\_fmt and width width for the plane plane.

# Returns
the computed size in bytes
"""
function av_image_get_linesize(pix_fmt::AVPixelFormat, width::Integer, plane::Integer)
    ccall((:av_image_get_linesize, libavutil), Cint, (AVPixelFormat, Cint, Cint), pix_fmt, width, plane)
end

"""
    av_image_fill_linesizes(linesizes, pix_fmt::AVPixelFormat, width::Integer)

Fill plane linesizes for an image with pixel format pix\\_fmt and width width.

# Arguments
* `linesizes`: array to be filled with the linesize for each plane
* `pix_fmt`: the [`AVPixelFormat`](@ref) of the image
* `width`: width of the image in pixels
# Returns
>= 0 in case of success, a negative error code otherwise
"""
function av_image_fill_linesizes(linesizes, pix_fmt::AVPixelFormat, width::Integer)
    ccall((:av_image_fill_linesizes, libavutil), Cint, (Ptr{Cint}, AVPixelFormat, Cint), linesizes, pix_fmt, width)
end

"""
    av_image_fill_plane_sizes(size, pix_fmt::AVPixelFormat, height::Integer, linesizes)

Fill plane sizes for an image with pixel format pix\\_fmt and height height.

!!! note

    The linesize parameters have the type ptrdiff\\_t here, while they are int for [`av_image_fill_linesizes`](@ref)().

# Arguments
* `size`: the array to be filled with the size of each image plane
* `pix_fmt`: the [`AVPixelFormat`](@ref) of the image
* `height`: height of the image in pixels
* `linesizes`: the array containing the linesize for each plane, should be filled by [`av_image_fill_linesizes`](@ref)()
# Returns
>= 0 in case of success, a negative error code otherwise
"""
function av_image_fill_plane_sizes(size, pix_fmt::AVPixelFormat, height::Integer, linesizes)
    ccall((:av_image_fill_plane_sizes, libavutil), Cint, (Ptr{Csize_t}, AVPixelFormat, Cint, Ptr{Cptrdiff_t}), size, pix_fmt, height, linesizes)
end

"""
    av_image_fill_pointers(data, pix_fmt::AVPixelFormat, height::Integer, ptr, linesizes)

Fill plane data pointers for an image with pixel format pix\\_fmt and height height.

# Arguments
* `data`: pointers array to be filled with the pointer for each image plane
* `pix_fmt`: the [`AVPixelFormat`](@ref) of the image
* `height`: height of the image in pixels
* `ptr`: the pointer to a buffer which will contain the image
* `linesizes`: the array containing the linesize for each plane, should be filled by [`av_image_fill_linesizes`](@ref)()
# Returns
the size in bytes required for the image buffer, a negative error code in case of failure
"""
function av_image_fill_pointers(data, pix_fmt::AVPixelFormat, height::Integer, ptr, linesizes)
    ccall((:av_image_fill_pointers, libavutil), Cint, (Ptr{Ptr{UInt8}}, AVPixelFormat, Cint, Ptr{UInt8}, Ptr{Cint}), data, pix_fmt, height, ptr, linesizes)
end

"""
    av_image_alloc(pointers, linesizes, w::Integer, h::Integer, pix_fmt::AVPixelFormat, align::Integer)

Allocate an image with size w and h and pixel format pix\\_fmt, and fill pointers and linesizes accordingly. The allocated image buffer has to be freed by using [`av_freep`](@ref)(&pointers[0]).

# Arguments
* `pointers`: array to be filled with the pointer for each image plane
* `linesizes`: the array filled with the linesize for each plane
* `w`: width of the image in pixels
* `h`: height of the image in pixels
* `pix_fmt`: the [`AVPixelFormat`](@ref) of the image
* `align`: the value to use for buffer size alignment
# Returns
the size in bytes required for the image buffer, a negative error code in case of failure
"""
function av_image_alloc(pointers, linesizes, w::Integer, h::Integer, pix_fmt::AVPixelFormat, align::Integer)
    ccall((:av_image_alloc, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Cint, Cint, AVPixelFormat, Cint), pointers, linesizes, w, h, pix_fmt, align)
end

"""
    av_image_copy_plane(dst, dst_linesize::Integer, src, src_linesize::Integer, bytewidth::Integer, height::Integer)

Copy image plane from src to dst. That is, copy "height" number of lines of "bytewidth" bytes each. The first byte of each successive line is separated by *\\_linesize bytes.

bytewidth must be contained by both absolute values of dst\\_linesize and src\\_linesize, otherwise the function behavior is undefined.

# Arguments
* `dst`: destination plane to copy to
* `dst_linesize`: linesize for the image plane in dst
* `src`: source plane to copy from
* `src_linesize`: linesize for the image plane in src
* `height`: height (number of lines) of the plane
"""
function av_image_copy_plane(dst, dst_linesize::Integer, src, src_linesize::Integer, bytewidth::Integer, height::Integer)
    ccall((:av_image_copy_plane, libavutil), Cvoid, (Ptr{UInt8}, Cint, Ptr{UInt8}, Cint, Cint, Cint), dst, dst_linesize, src, src_linesize, bytewidth, height)
end

"""
    av_image_copy_plane_uc_from(dst, dst_linesize::Cptrdiff_t, src, src_linesize::Cptrdiff_t, bytewidth::Cptrdiff_t, height::Integer)

Copy image data located in uncacheable (e.g. GPU mapped) memory. Where available, this function will use special functionality for reading from such memory, which may result in greatly improved performance compared to plain [`av_image_copy_plane`](@ref)().

bytewidth must be contained by both absolute values of dst\\_linesize and src\\_linesize, otherwise the function behavior is undefined.

!!! note

    The linesize parameters have the type ptrdiff\\_t here, while they are int for [`av_image_copy_plane`](@ref)().

!!! note

    On x86, the linesizes currently need to be aligned to the cacheline size (i.e. 64) to get improved performance.
"""
function av_image_copy_plane_uc_from(dst, dst_linesize::Cptrdiff_t, src, src_linesize::Cptrdiff_t, bytewidth::Cptrdiff_t, height::Integer)
    ccall((:av_image_copy_plane_uc_from, libavutil), Cvoid, (Ptr{UInt8}, Cptrdiff_t, Ptr{UInt8}, Cptrdiff_t, Cptrdiff_t, Cint), dst, dst_linesize, src, src_linesize, bytewidth, height)
end

"""
    av_image_copy(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)

Copy image in src\\_data to dst\\_data.

# Arguments
* `dst_data`: destination image data buffer to copy to
* `dst_linesizes`: linesizes for the image in dst\\_data
* `src_data`: source image data buffer to copy from
* `src_linesizes`: linesizes for the image in src\\_data
* `pix_fmt`: the [`AVPixelFormat`](@ref) of the image
* `width`: width of the image in pixels
* `height`: height of the image in pixels
"""
function av_image_copy(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)
    ccall((:av_image_copy, libavutil), Cvoid, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{Ptr{UInt8}}, Ptr{Cint}, AVPixelFormat, Cint, Cint), dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt, width, height)
end

"""
    av_image_copy2(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)

Wrapper around [`av_image_copy`](@ref)() to workaround the limitation that the conversion from uint8\\_t * const * to const uint8\\_t * const * is not performed automatically in C.

# See also
[`av_image_copy`](@ref)()
"""
function av_image_copy2(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)
    ccall((:av_image_copy2, libavutil), Cvoid, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{Ptr{UInt8}}, Ptr{Cint}, AVPixelFormat, Cint, Cint), dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt, width, height)
end

"""
    av_image_copy_uc_from(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)

Copy image data located in uncacheable (e.g. GPU mapped) memory. Where available, this function will use special functionality for reading from such memory, which may result in greatly improved performance compared to plain [`av_image_copy`](@ref)().

The data pointers and the linesizes must be aligned to the maximum required by the CPU architecture.

!!! note

    The linesize parameters have the type ptrdiff\\_t here, while they are int for [`av_image_copy`](@ref)().

!!! note

    On x86, the linesizes currently need to be aligned to the cacheline size (i.e. 64) to get improved performance.
"""
function av_image_copy_uc_from(dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt::AVPixelFormat, width::Integer, height::Integer)
    ccall((:av_image_copy_uc_from, libavutil), Cvoid, (Ptr{Ptr{UInt8}}, Ptr{Cptrdiff_t}, Ptr{Ptr{UInt8}}, Ptr{Cptrdiff_t}, AVPixelFormat, Cint, Cint), dst_data, dst_linesizes, src_data, src_linesizes, pix_fmt, width, height)
end

"""
    av_image_fill_arrays(dst_data, dst_linesize, src, pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)

Setup the data pointers and linesizes based on the specified image parameters and the provided array.

The fields of the given image are filled in by using the src address which points to the image data buffer. Depending on the specified pixel format, one or multiple image data pointers and line sizes will be set. If a planar format is specified, several pointers will be set pointing to the different picture planes and the line sizes of the different planes will be stored in the lines\\_sizes array. Call with src == NULL to get the required size for the src buffer.

To allocate the buffer and fill in the dst\\_data and dst\\_linesize in one call, use [`av_image_alloc`](@ref)().

# Arguments
* `dst_data`: data pointers to be filled in
* `dst_linesize`: linesizes for the image in dst\\_data to be filled in
* `src`: buffer which will contain or contains the actual image data, can be NULL
* `pix_fmt`: the pixel format of the image
* `width`: the width of the image in pixels
* `height`: the height of the image in pixels
* `align`: the value used in src for linesize alignment
# Returns
the size in bytes required for src, a negative error code in case of failure
"""
function av_image_fill_arrays(dst_data, dst_linesize, src, pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)
    ccall((:av_image_fill_arrays, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{UInt8}, AVPixelFormat, Cint, Cint, Cint), dst_data, dst_linesize, src, pix_fmt, width, height, align)
end

"""
    av_image_get_buffer_size(pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)

Return the size in bytes of the amount of data required to store an image with the given parameters.

# Arguments
* `pix_fmt`: the pixel format of the image
* `width`: the width of the image in pixels
* `height`: the height of the image in pixels
* `align`: the assumed linesize alignment
# Returns
the buffer size in bytes, a negative error code in case of failure
"""
function av_image_get_buffer_size(pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)
    ccall((:av_image_get_buffer_size, libavutil), Cint, (AVPixelFormat, Cint, Cint, Cint), pix_fmt, width, height, align)
end

"""
    av_image_copy_to_buffer(dst, dst_size::Integer, src_data, src_linesize, pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)

Copy image data from an image into a buffer.

[`av_image_get_buffer_size`](@ref)() can be used to compute the required size for the buffer to fill.

# Arguments
* `dst`: a buffer into which picture data will be copied
* `dst_size`: the size in bytes of dst
* `src_data`: pointers containing the source image data
* `src_linesize`: linesizes for the image in src\\_data
* `pix_fmt`: the pixel format of the source image
* `width`: the width of the source image in pixels
* `height`: the height of the source image in pixels
* `align`: the assumed linesize alignment for dst
# Returns
the number of bytes written to dst, or a negative value (error code) on error
"""
function av_image_copy_to_buffer(dst, dst_size::Integer, src_data, src_linesize, pix_fmt::AVPixelFormat, width::Integer, height::Integer, align::Integer)
    ccall((:av_image_copy_to_buffer, libavutil), Cint, (Ptr{UInt8}, Cint, Ptr{Ptr{UInt8}}, Ptr{Cint}, AVPixelFormat, Cint, Cint, Cint), dst, dst_size, src_data, src_linesize, pix_fmt, width, height, align)
end

"""
    av_image_check_size(w::Integer, h::Integer, log_offset::Integer, log_ctx)

Check if the given dimension of an image is valid, meaning that all bytes of the image can be addressed with a signed int.

# Arguments
* `w`: the width of the picture
* `h`: the height of the picture
* `log_offset`: the offset to sum to the log level for logging with log\\_ctx
* `log_ctx`: the parent logging context, it may be NULL
# Returns
>= 0 if valid, a negative error code otherwise
"""
function av_image_check_size(w::Integer, h::Integer, log_offset::Integer, log_ctx)
    ccall((:av_image_check_size, libavutil), Cint, (Cuint, Cuint, Cint, Ptr{Cvoid}), w, h, log_offset, log_ctx)
end

"""
    av_image_check_size2(w::Integer, h::Integer, max_pixels::Int64, pix_fmt::AVPixelFormat, log_offset::Integer, log_ctx)

Check if the given dimension of an image is valid, meaning that all bytes of a plane of an image with the specified pix\\_fmt can be addressed with a signed int.

# Arguments
* `w`: the width of the picture
* `h`: the height of the picture
* `max_pixels`: the maximum number of pixels the user wants to accept
* `pix_fmt`: the pixel format, can be AV\\_PIX\\_FMT\\_NONE if unknown.
* `log_offset`: the offset to sum to the log level for logging with log\\_ctx
* `log_ctx`: the parent logging context, it may be NULL
# Returns
>= 0 if valid, a negative error code otherwise
"""
function av_image_check_size2(w::Integer, h::Integer, max_pixels::Int64, pix_fmt::AVPixelFormat, log_offset::Integer, log_ctx)
    ccall((:av_image_check_size2, libavutil), Cint, (Cuint, Cuint, Int64, AVPixelFormat, Cint, Ptr{Cvoid}), w, h, max_pixels, pix_fmt, log_offset, log_ctx)
end

"""
    av_image_check_sar(w::Integer, h::Integer, sar::AVRational)

Check if the given sample aspect ratio of an image is valid.

It is considered invalid if the denominator is 0 or if applying the ratio to the image size would make the smaller dimension less than 1. If the sar numerator is 0, it is considered unknown and will return as valid.

# Arguments
* `w`: width of the image
* `h`: height of the image
* `sar`: sample aspect ratio of the image
# Returns
0 if valid, a negative [`AVERROR`](@ref) code otherwise
"""
function av_image_check_sar(w::Integer, h::Integer, sar::AVRational)
    ccall((:av_image_check_sar, libavutil), Cint, (Cuint, Cuint, AVRational), w, h, sar)
end

"""
    av_image_fill_black(dst_data, dst_linesize, pix_fmt::AVPixelFormat, range::AVColorRange, width::Integer, height::Integer)

Overwrite the image data with black. This is suitable for filling a sub-rectangle of an image, meaning the padding between the right most pixel and the left most pixel on the next line will not be overwritten. For some formats, the image size might be rounded up due to inherent alignment.

If the pixel format has alpha, the alpha is cleared to opaque.

This can return an error if the pixel format is not supported. Normally, all non-hwaccel pixel formats should be supported.

Passing NULL for dst\\_data is allowed. Then the function returns whether the operation would have succeeded. (It can return an error if the pix\\_fmt is not supported.)

# Arguments
* `dst_data`: data pointers to destination image
* `dst_linesize`: linesizes for the destination image
* `pix_fmt`: the pixel format of the image
* `range`: the color range of the image (important for colorspaces such as YUV)
* `width`: the width of the image in pixels
* `height`: the height of the image in pixels
# Returns
0 if the image data was cleared, a negative [`AVERROR`](@ref) code otherwise
"""
function av_image_fill_black(dst_data, dst_linesize, pix_fmt::AVPixelFormat, range::AVColorRange, width::Integer, height::Integer)
    ccall((:av_image_fill_black, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cptrdiff_t}, AVPixelFormat, AVColorRange, Cint, Cint), dst_data, dst_linesize, pix_fmt, range, width, height)
end

"""
    av_image_fill_color(dst_data, dst_linesize, pix_fmt::AVPixelFormat, color, width::Integer, height::Integer, flags::Integer)

Overwrite the image data with a color. This is suitable for filling a sub-rectangle of an image, meaning the padding between the right most pixel and the left most pixel on the next line will not be overwritten. For some formats, the image size might be rounded up due to inherent alignment.

If the pixel format has alpha, it is also replaced. Color component values are interpreted as native integers (or intfloats) regardless of actual pixel format endianness.

This can return an error if the pixel format is not supported. Normally, all non-hwaccel pixel formats should be supported.

Passing NULL for dst\\_data is allowed. Then the function returns whether the operation would have succeeded. (It can return an error if the pix\\_fmt is not supported.)

# Arguments
* `dst_data`: data pointers to destination image
* `dst_linesize`: linesizes for the destination image
* `pix_fmt`: the pixel format of the image
* `color`: the color components to be used for the fill
* `width`: the width of the image in pixels
* `height`: the height of the image in pixels
* `flags`: currently unused
# Returns
0 if the image data was filled, a negative [`AVERROR`](@ref) code otherwise
"""
function av_image_fill_color(dst_data, dst_linesize, pix_fmt::AVPixelFormat, color, width::Integer, height::Integer, flags::Integer)
    ccall((:av_image_fill_color, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cptrdiff_t}, AVPixelFormat, Ptr{UInt32}, Cint, Cint, Cint), dst_data, dst_linesize, pix_fmt, color, width, height, flags)
end

struct av_intfloat32
    data::NTuple{4, UInt8}
end

function Base.getproperty(x::Ptr{av_intfloat32}, f::Symbol)
    f === :i && return Ptr{UInt32}(x + 0)
    f === :f && return Ptr{Cfloat}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::av_intfloat32, f::Symbol)
    r = Ref{av_intfloat32}(x)
    ptr = Base.unsafe_convert(Ptr{av_intfloat32}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{av_intfloat32}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::av_intfloat32, private::Bool = false)
    (:i, :f, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct av_intfloat64
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{av_intfloat64}, f::Symbol)
    f === :i && return Ptr{UInt64}(x + 0)
    f === :f && return Ptr{Cdouble}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::av_intfloat64, f::Symbol)
    r = Ref{av_intfloat64}(x)
    ptr = Base.unsafe_convert(Ptr{av_intfloat64}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{av_intfloat64}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::av_intfloat64, private::Bool = false)
    (:i, :f, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    av_int2float(i::Integer)

Reinterpret a 32-bit integer as a float.
"""
function av_int2float(i::Integer)
    ccall((:av_int2float, libavutil), Cfloat, (UInt32,), i)
end

"""
    av_float2int(f::Cfloat)

Reinterpret a float as a 32-bit integer.
"""
function av_float2int(f::Cfloat)
    ccall((:av_float2int, libavutil), UInt32, (Cfloat,), f)
end

"""
    av_int2double(i::UInt64)

Reinterpret a 64-bit integer as a double.
"""
function av_int2double(i::UInt64)
    ccall((:av_int2double, libavutil), Cdouble, (UInt64,), i)
end

"""
    av_double2int(f::Cdouble)

Reinterpret a double as a 64-bit integer.
"""
function av_double2int(f::Cdouble)
    ccall((:av_double2int, libavutil), UInt64, (Cdouble,), f)
end

struct av_alias64
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{av_alias64}, f::Symbol)
    f === :u64 && return Ptr{UInt64}(x + 0)
    f === :u32 && return Ptr{NTuple{2, UInt32}}(x + 0)
    f === :u16 && return Ptr{NTuple{4, UInt16}}(x + 0)
    f === :u8 && return Ptr{NTuple{8, UInt8}}(x + 0)
    f === :f64 && return Ptr{Cdouble}(x + 0)
    f === :f32 && return Ptr{NTuple{2, Cfloat}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::av_alias64, f::Symbol)
    r = Ref{av_alias64}(x)
    ptr = Base.unsafe_convert(Ptr{av_alias64}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{av_alias64}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::av_alias64, private::Bool = false)
    (:u64, :u32, :u16, :u8, :f64, :f32, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct av_alias32
    data::NTuple{4, UInt8}
end

function Base.getproperty(x::Ptr{av_alias32}, f::Symbol)
    f === :u32 && return Ptr{UInt32}(x + 0)
    f === :u16 && return Ptr{NTuple{2, UInt16}}(x + 0)
    f === :u8 && return Ptr{NTuple{4, UInt8}}(x + 0)
    f === :f32 && return Ptr{Cfloat}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::av_alias32, f::Symbol)
    r = Ref{av_alias32}(x)
    ptr = Base.unsafe_convert(Ptr{av_alias32}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{av_alias32}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::av_alias32, private::Bool = false)
    (:u32, :u16, :u8, :f32, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct av_alias16
    data::NTuple{2, UInt8}
end

function Base.getproperty(x::Ptr{av_alias16}, f::Symbol)
    f === :u16 && return Ptr{UInt16}(x + 0)
    f === :u8 && return Ptr{NTuple{2, UInt8}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::av_alias16, f::Symbol)
    r = Ref{av_alias16}(x)
    ptr = Base.unsafe_convert(Ptr{av_alias16}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{av_alias16}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::av_alias16, private::Bool = false)
    (:u16, :u8, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct unaligned_64
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{unaligned_64}, f::Symbol)
    f === :l && return Ptr{UInt64}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::unaligned_64, f::Symbol)
    r = Ref{unaligned_64}(x)
    ptr = Base.unsafe_convert(Ptr{unaligned_64}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{unaligned_64}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::unaligned_64, private::Bool = false)
    (:l, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct unaligned_32
    data::NTuple{4, UInt8}
end

function Base.getproperty(x::Ptr{unaligned_32}, f::Symbol)
    f === :l && return Ptr{UInt32}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::unaligned_32, f::Symbol)
    r = Ref{unaligned_32}(x)
    ptr = Base.unsafe_convert(Ptr{unaligned_32}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{unaligned_32}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::unaligned_32, private::Bool = false)
    (:l, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

struct unaligned_16
    data::NTuple{2, UInt8}
end

function Base.getproperty(x::Ptr{unaligned_16}, f::Symbol)
    f === :l && return Ptr{UInt16}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::unaligned_16, f::Symbol)
    r = Ref{unaligned_16}(x)
    ptr = Base.unsafe_convert(Ptr{unaligned_16}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{unaligned_16}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::unaligned_16, private::Bool = false)
    (:l, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    AVLFG

Context structure for the Lagged Fibonacci PRNG. The exact layout, types and content of this struct may change and should not be accessed directly. Only its `sizeof()` is guaranteed to stay the same to allow easy instantiation.
"""
struct AVLFG
    state::NTuple{64, Cuint}
    index::Cint
end

function av_lfg_init(c, seed::Integer)
    ccall((:av_lfg_init, libavutil), Cvoid, (Ptr{AVLFG}, Cuint), c, seed)
end

"""
    av_lfg_init_from_data(c, data, length::Integer)

Seed the state of the ALFG using binary data.

# Returns
0 on success, negative value ([`AVERROR`](@ref)) on failure.
"""
function av_lfg_init_from_data(c, data, length::Integer)
    ccall((:av_lfg_init_from_data, libavutil), Cint, (Ptr{AVLFG}, Ptr{UInt8}, Cuint), c, data, length)
end

"""
    av_lfg_get(c)

Get the next random unsigned 32-bit number using an ALFG.

Please also consider a simple LCG like state= state*1664525+1013904223, it may be good enough and faster for your specific use case.
"""
function av_lfg_get(c)
    ccall((:av_lfg_get, libavutil), Cuint, (Ptr{AVLFG},), c)
end

"""
    av_mlfg_get(c)

Get the next random unsigned 32-bit number using a MLFG.

Please also consider [`av_lfg_get`](@ref)() above, it is faster.
"""
function av_mlfg_get(c)
    ccall((:av_mlfg_get, libavutil), Cuint, (Ptr{AVLFG},), c)
end

"""
    av_bmg_get(lfg, out)

Get the next two numbers generated by a Box-Muller Gaussian generator using the random numbers issued by lfg.

# Arguments
* `lfg`: pointer to the context structure
* `out`: array where the two generated numbers are placed
"""
function av_bmg_get(lfg, out)
    ccall((:av_bmg_get, libavutil), Cvoid, (Ptr{AVLFG}, Ptr{Cdouble}), lfg, out)
end

const AVClassStateFlags = UInt32
const AV_CLASS_STATE_INITIALIZED = 1 % UInt32

"""
    av_log_get_level()

Get the current log level

# Returns
Current log level
# See also
lavu\\_log\\_constants
"""
function av_log_get_level()
    ccall((:av_log_get_level, libavutil), Cint, ())
end

"""
    av_log_set_level(level::Integer)

Set the log level

# Arguments
* `level`: Logging level
# See also
lavu\\_log\\_constants
"""
function av_log_set_level(level::Integer)
    ccall((:av_log_set_level, libavutil), Cvoid, (Cint,), level)
end

"""
    av_log_set_callback(callback)

Set the logging callback

!!! note

    The callback must be thread safe, even if the application does not use threads itself as some codecs are multithreaded.

# Arguments
* `callback`: A logging function with a compatible signature.
# See also
[`av_log_default_callback`](@ref)
"""
function av_log_set_callback(callback)
    ccall((:av_log_set_callback, libavutil), Cvoid, (Ptr{Cvoid},), callback)
end

"""
    av_default_item_name(ctx)

Return the context name

# Arguments
* `ctx`: The [`AVClass`](@ref) context
# Returns
The [`AVClass`](@ref) class\\_name
"""
function av_default_item_name(ctx)
    ccall((:av_default_item_name, libavutil), Cstring, (Ptr{Cvoid},), ctx)
end

function av_default_get_category(ptr)
    ccall((:av_default_get_category, libavutil), AVClassCategory, (Ptr{Cvoid},), ptr)
end

function av_log_set_flags(arg::Integer)
    ccall((:av_log_set_flags, libavutil), Cvoid, (Cint,), arg)
end

function av_log_get_flags()
    ccall((:av_log_get_flags, libavutil), Cint, ())
end

"""
    av_lzo1x_decode(out, outlen, in, inlen)

Decodes LZO 1x compressed data.

Make sure all buffers are appropriately padded, in must provide [`AV_LZO_INPUT_PADDING`](@ref), out must provide [`AV_LZO_OUTPUT_PADDING`](@ref) additional bytes.

# Arguments
* `out`: output buffer
* `outlen`: size of output buffer, number of bytes left are returned here
* `in`: input buffer
* `inlen`: size of input buffer, number of bytes left are returned here
# Returns
0 on success, otherwise a combination of the error flags above
"""
function av_lzo1x_decode(out, outlen, in, inlen)
    ccall((:av_lzo1x_decode, libavutil), Cint, (Ptr{Cvoid}, Ptr{Cint}, Ptr{Cvoid}, Ptr{Cint}), out, outlen, in, inlen)
end

"""
    AVMasteringDisplayMetadata

Mastering display metadata capable of representing the color volume of the display used to master the content (SMPTE 2086:2014).

To be used as payload of a [`AVFrameSideData`](@ref) or [`AVPacketSideData`](@ref) with the appropriate type.

!!! note

    The struct should be allocated with [`av_mastering_display_metadata_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVMasteringDisplayMetadata
    display_primaries::NTuple{3, NTuple{2, AVRational}}
    white_point::NTuple{2, AVRational}
    min_luminance::AVRational
    max_luminance::AVRational
    has_primaries::Cint
    has_luminance::Cint
end

"""
    av_mastering_display_metadata_alloc()

Allocate an [`AVMasteringDisplayMetadata`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVMasteringDisplayMetadata`](@ref) filled with default values or NULL on failure.
"""
function av_mastering_display_metadata_alloc()
    ccall((:av_mastering_display_metadata_alloc, libavutil), Ptr{AVMasteringDisplayMetadata}, ())
end

"""
    av_mastering_display_metadata_alloc_size(size)

Allocate an [`AVMasteringDisplayMetadata`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVMasteringDisplayMetadata`](@ref) filled with default values or NULL on failure.
"""
function av_mastering_display_metadata_alloc_size(size)
    ccall((:av_mastering_display_metadata_alloc_size, libavutil), Ptr{AVMasteringDisplayMetadata}, (Ptr{Csize_t},), size)
end

"""
    av_mastering_display_metadata_create_side_data(frame)

Allocate a complete [`AVMasteringDisplayMetadata`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVMasteringDisplayMetadata`](@ref) structure to be filled by caller.
"""
function av_mastering_display_metadata_create_side_data(frame)
    ccall((:av_mastering_display_metadata_create_side_data, libavutil), Ptr{AVMasteringDisplayMetadata}, (Ptr{AVFrame},), frame)
end

"""
    AVContentLightMetadata

Content light level needed by to transmit HDR over HDMI (CTA-861.3).

To be used as payload of a [`AVFrameSideData`](@ref) or [`AVPacketSideData`](@ref) with the appropriate type.

!!! note

    The struct should be allocated with [`av_content_light_metadata_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVContentLightMetadata
    MaxCLL::Cuint
    MaxFALL::Cuint
end

"""
    av_content_light_metadata_alloc(size)

Allocate an [`AVContentLightMetadata`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVContentLightMetadata`](@ref) filled with default values or NULL on failure.
"""
function av_content_light_metadata_alloc(size)
    ccall((:av_content_light_metadata_alloc, libavutil), Ptr{AVContentLightMetadata}, (Ptr{Csize_t},), size)
end

"""
    av_content_light_metadata_create_side_data(frame)

Allocate a complete [`AVContentLightMetadata`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVContentLightMetadata`](@ref) structure to be filled by caller.
"""
function av_content_light_metadata_create_side_data(frame)
    ccall((:av_content_light_metadata_create_side_data, libavutil), Ptr{AVContentLightMetadata}, (Ptr{AVFrame},), frame)
end

"""
    AVRounding

Rounding methods.
"""
const AVRounding = UInt32
const AV_ROUND_ZERO = 0 % UInt32
const AV_ROUND_INF = 1 % UInt32
const AV_ROUND_DOWN = 2 % UInt32
const AV_ROUND_UP = 3 % UInt32
const AV_ROUND_NEAR_INF = 5 % UInt32
const AV_ROUND_PASS_MINMAX = 8192 % UInt32

"""
    av_gcd(a::Int64, b::Int64)

Compute the greatest common divisor of two integer operands.

# Arguments
* `a`: Operand
* `b`: Operand
# Returns
GCD of a and b up to sign; if a >= 0 and b >= 0, return value is >= 0; if a == 0 and b == 0, returns 0.
"""
function av_gcd(a::Int64, b::Int64)
    ccall((:av_gcd, libavutil), Int64, (Int64, Int64), a, b)
end

"""
    av_rescale(a::Int64, b::Int64, c::Int64)

Rescale a 64-bit integer with rounding to nearest.

The operation is mathematically equivalent to `a * b / c`, but writing that directly can overflow.

This function is equivalent to [`av_rescale_rnd`](@ref)() with #AV\\_ROUND\\_NEAR\\_INF.

# See also
[`av_rescale_rnd`](@ref)(), [`av_rescale_q`](@ref)(), [`av_rescale_q_rnd`](@ref)()
"""
function av_rescale(a::Int64, b::Int64, c::Int64)
    ccall((:av_rescale, libavutil), Int64, (Int64, Int64, Int64), a, b, c)
end

"""
    av_rescale_rnd(a::Int64, b::Int64, c::Int64, rnd::AVRounding)

Rescale a 64-bit integer with specified rounding.

The operation is mathematically equivalent to `a * b / c`, but writing that directly can overflow, and does not support different rounding methods. If the result is not representable then INT64\\_MIN is returned.

# See also
[`av_rescale`](@ref)(), [`av_rescale_q`](@ref)(), [`av_rescale_q_rnd`](@ref)()
"""
function av_rescale_rnd(a::Int64, b::Int64, c::Int64, rnd::AVRounding)
    ccall((:av_rescale_rnd, libavutil), Int64, (Int64, Int64, Int64, AVRounding), a, b, c, rnd)
end

"""
    av_rescale_q(a::Int64, bq::AVRational, cq::AVRational)

Rescale a 64-bit integer by 2 rational numbers.

The operation is mathematically equivalent to `a * bq / cq`.

This function is equivalent to [`av_rescale_q_rnd`](@ref)() with #AV\\_ROUND\\_NEAR\\_INF.

# See also
[`av_rescale`](@ref)(), [`av_rescale_rnd`](@ref)(), [`av_rescale_q_rnd`](@ref)()
"""
function av_rescale_q(a::Int64, bq::AVRational, cq::AVRational)
    ccall((:av_rescale_q, libavutil), Int64, (Int64, AVRational, AVRational), a, bq, cq)
end

"""
    av_rescale_q_rnd(a::Int64, bq::AVRational, cq::AVRational, rnd::AVRounding)

Rescale a 64-bit integer by 2 rational numbers with specified rounding.

The operation is mathematically equivalent to `a * bq / cq`.

# See also
[`av_rescale`](@ref)(), [`av_rescale_rnd`](@ref)(), [`av_rescale_q`](@ref)()
"""
function av_rescale_q_rnd(a::Int64, bq::AVRational, cq::AVRational, rnd::AVRounding)
    ccall((:av_rescale_q_rnd, libavutil), Int64, (Int64, AVRational, AVRational, AVRounding), a, bq, cq, rnd)
end

"""
    av_compare_ts(ts_a::Int64, tb_a::AVRational, ts_b::Int64, tb_b::AVRational)

Compare two timestamps each in its own time base.

!!! warning

    The result of the function is undefined if one of the timestamps is outside the `int64_t` range when represented in the other's timebase.

# Returns
One of the following values: - -1 if `ts_a` is before `ts_b` - 1 if `ts_a` is after `ts_b` - 0 if they represent the same position
"""
function av_compare_ts(ts_a::Int64, tb_a::AVRational, ts_b::Int64, tb_b::AVRational)
    ccall((:av_compare_ts, libavutil), Cint, (Int64, AVRational, Int64, AVRational), ts_a, tb_a, ts_b, tb_b)
end

"""
    av_compare_mod(a::UInt64, b::UInt64, mod::UInt64)

Compare the remainders of two integer operands divided by a common divisor.

In other words, compare the least significant `log2(mod)` bits of integers `a` and `b`.

```c++
{.c}
 av_compare_mod(0x11, 0x02, 0x10) < 0 // since 0x11 % 0x10  (0x1) < 0x02 % 0x10  (0x2)
 av_compare_mod(0x11, 0x02, 0x20) > 0 // since 0x11 % 0x20 (0x11) > 0x02 % 0x20 (0x02)
```

# Arguments
* `a`: Operand
* `b`: Operand
* `mod`: Divisor; must be a power of 2
# Returns
- a negative value if `a % mod < b % mod` - a positive value if `a % mod > b % mod` - zero if `a % mod == b % mod`
"""
function av_compare_mod(a::UInt64, b::UInt64, mod::UInt64)
    ccall((:av_compare_mod, libavutil), Int64, (UInt64, UInt64, UInt64), a, b, mod)
end

"""
    av_rescale_delta(in_tb::AVRational, in_ts::Int64, fs_tb::AVRational, duration::Integer, last, out_tb::AVRational)

Rescale a timestamp while preserving known durations.

This function is designed to be called per audio packet to scale the input timestamp to a different time base. Compared to a simple [`av_rescale_q`](@ref)() call, this function is robust against possible inconsistent frame durations.

The `last` parameter is a state variable that must be preserved for all subsequent calls for the same stream. For the first call, `*last` should be initialized to #[`AV_NOPTS_VALUE`](@ref).

!!! note

    In the context of this function, "duration" is in term of samples, not seconds.

# Arguments
* `in_tb`:\\[in\\] Input time base
* `in_ts`:\\[in\\] Input timestamp
* `fs_tb`:\\[in\\] Duration time base; typically this is finer-grained (greater) than `in_tb` and `out_tb`
* `duration`:\\[in\\] Duration till the next call to this function (i.e. duration of the current packet/frame)
* `last`:\\[in,out\\] Pointer to a timestamp expressed in terms of `fs_tb`, acting as a state variable
* `out_tb`:\\[in\\] Output timebase
# Returns
Timestamp expressed in terms of `out_tb`
"""
function av_rescale_delta(in_tb::AVRational, in_ts::Int64, fs_tb::AVRational, duration::Integer, last, out_tb::AVRational)
    ccall((:av_rescale_delta, libavutil), Int64, (AVRational, Int64, AVRational, Cint, Ptr{Int64}, AVRational), in_tb, in_ts, fs_tb, duration, last, out_tb)
end

"""
    av_add_stable(ts_tb::AVRational, ts::Int64, inc_tb::AVRational, inc::Int64)

Add a value to a timestamp.

This function guarantees that when the same value is repeatedly added that no accumulation of rounding errors occurs.

# Arguments
* `ts`:\\[in\\] Input timestamp
* `ts_tb`:\\[in\\] Input timestamp time base
* `inc`:\\[in\\] Value to be added
* `inc_tb`:\\[in\\] Time base of `inc`
"""
function av_add_stable(ts_tb::AVRational, ts::Int64, inc_tb::AVRational, inc::Int64)
    ccall((:av_add_stable, libavutil), Int64, (AVRational, Int64, AVRational, Int64), ts_tb, ts, inc_tb, inc)
end

"""
    av_bessel_i0(x::Cdouble)

0th order modified bessel function of the first kind.
"""
function av_bessel_i0(x::Cdouble)
    ccall((:av_bessel_i0, libavutil), Cdouble, (Cdouble,), x)
end

mutable struct AVMD5 end

"""
    av_md5_alloc()

Allocate an [`AVMD5`](@ref) context.
"""
function av_md5_alloc()
    ccall((:av_md5_alloc, libavutil), Ptr{AVMD5}, ())
end

"""
    av_md5_init(ctx)

Initialize MD5 hashing.

# Arguments
* `ctx`: pointer to the function context (of size av\\_md5\\_size)
"""
function av_md5_init(ctx)
    ccall((:av_md5_init, libavutil), Cvoid, (Ptr{AVMD5},), ctx)
end

"""
    av_md5_update(ctx, src, len::Csize_t)

Update hash value.

# Arguments
* `ctx`: hash function context
* `src`: input data to update hash with
* `len`: input data length
"""
function av_md5_update(ctx, src, len::Csize_t)
    ccall((:av_md5_update, libavutil), Cvoid, (Ptr{AVMD5}, Ptr{UInt8}, Csize_t), ctx, src, len)
end

"""
    av_md5_final(ctx, dst)

Finish hashing and output digest value.

# Arguments
* `ctx`: hash function context
* `dst`: buffer where output digest value is stored
"""
function av_md5_final(ctx, dst)
    ccall((:av_md5_final, libavutil), Cvoid, (Ptr{AVMD5}, Ptr{UInt8}), ctx, dst)
end

"""
    av_md5_sum(dst, src, len::Csize_t)

Hash an array of data.

# Arguments
* `dst`: The output buffer to write the digest into
* `src`: The data to hash
* `len`: The length of the data, in bytes
"""
function av_md5_sum(dst, src, len::Csize_t)
    ccall((:av_md5_sum, libavutil), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Csize_t), dst, src, len)
end

"""
    av_malloc(size::Csize_t)

Allocate a memory block with alignment suitable for all memory accesses (including vectors if available on the CPU).

# Arguments
* `size`: Size in bytes for the memory block to be allocated
# Returns
Pointer to the allocated block, or `NULL` if the block cannot be allocated
# See also
[`av_mallocz`](@ref)()
"""
function av_malloc(size::Csize_t)
    ccall((:av_malloc, libavutil), Ptr{Cvoid}, (Csize_t,), size)
end

"""
    av_mallocz(size::Csize_t)

Allocate a memory block with alignment suitable for all memory accesses (including vectors if available on the CPU) and zero all the bytes of the block.

# Arguments
* `size`: Size in bytes for the memory block to be allocated
# Returns
Pointer to the allocated block, or `NULL` if it cannot be allocated
# See also
[`av_malloc`](@ref)()
"""
function av_mallocz(size::Csize_t)
    ccall((:av_mallocz, libavutil), Ptr{Cvoid}, (Csize_t,), size)
end

"""
    av_malloc_array(nmemb::Csize_t, size::Csize_t)

Allocate a memory block for an array with [`av_malloc`](@ref)().

The allocated memory will have size `size * nmemb` bytes.

# Arguments
* `nmemb`: Number of element
* `size`: Size of a single element
# Returns
Pointer to the allocated block, or `NULL` if the block cannot be allocated
# See also
[`av_malloc`](@ref)()
"""
function av_malloc_array(nmemb::Csize_t, size::Csize_t)
    ccall((:av_malloc_array, libavutil), Ptr{Cvoid}, (Csize_t, Csize_t), nmemb, size)
end

"""
    av_calloc(nmemb::Csize_t, size::Csize_t)

Allocate a memory block for an array with [`av_mallocz`](@ref)().

The allocated memory will have size `size * nmemb` bytes.

# Arguments
* `nmemb`: Number of elements
* `size`: Size of the single element
# Returns
Pointer to the allocated block, or `NULL` if the block cannot be allocated
# See also
[`av_mallocz`](@ref)(), [`av_malloc_array`](@ref)()
"""
function av_calloc(nmemb::Csize_t, size::Csize_t)
    ccall((:av_calloc, libavutil), Ptr{Cvoid}, (Csize_t, Csize_t), nmemb, size)
end

"""
    av_realloc(ptr, size::Csize_t)

Allocate, reallocate, or free a block of memory.

If `ptr` is `NULL` and `size` > 0, allocate a new block. Otherwise, expand or shrink that block of memory according to `size`.

!!! warning

    Unlike [`av_malloc`](@ref)(), the returned pointer is not guaranteed to be correctly aligned. The returned pointer must be freed after even if size is zero.

# Arguments
* `ptr`: Pointer to a memory block already allocated with [`av_realloc`](@ref)() or `NULL`
* `size`: Size in bytes of the memory block to be allocated or reallocated
# Returns
Pointer to a newly-reallocated block or `NULL` if the block cannot be reallocated
# See also
[`av_fast_realloc`](@ref)(), [`av_reallocp`](@ref)()
"""
function av_realloc(ptr, size::Csize_t)
    ccall((:av_realloc, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Csize_t), ptr, size)
end

"""
    av_reallocp(ptr, size::Csize_t)

Allocate, reallocate, or free a block of memory through a pointer to a pointer.

If `*ptr` is `NULL` and `size` > 0, allocate a new block. If `size` is zero, free the memory block pointed to by `*ptr`. Otherwise, expand or shrink that block of memory according to `size`.

!!! warning

    Unlike [`av_malloc`](@ref)(), the allocated memory is not guaranteed to be correctly aligned.

# Arguments
* `ptr`:\\[in,out\\] Pointer to a pointer to a memory block already allocated with [`av_realloc`](@ref)(), or a pointer to `NULL`. The pointer is updated on success, or freed on failure.
* `size`:\\[in\\] Size in bytes for the memory block to be allocated or reallocated
# Returns
Zero on success, an [`AVERROR`](@ref) error code on failure
"""
function av_reallocp(ptr, size::Csize_t)
    ccall((:av_reallocp, libavutil), Cint, (Ptr{Cvoid}, Csize_t), ptr, size)
end

"""
    av_realloc_f(ptr, nelem::Csize_t, elsize::Csize_t)

Allocate, reallocate, or free a block of memory.

This function does the same thing as [`av_realloc`](@ref)(), except: - It takes two size arguments and allocates `nelem * elsize` bytes, after checking the result of the multiplication for integer overflow. - It frees the input block in case of failure, thus avoiding the memory leak with the classic

```c++
{.c}
   buf = realloc(buf);
   if (!buf)
       return -1;
```

pattern.
"""
function av_realloc_f(ptr, nelem::Csize_t, elsize::Csize_t)
    ccall((:av_realloc_f, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Csize_t, Csize_t), ptr, nelem, elsize)
end

"""
    av_realloc_array(ptr, nmemb::Csize_t, size::Csize_t)

Allocate, reallocate, or free an array.

If `ptr` is `NULL` and `nmemb` > 0, allocate a new block.

!!! warning

    Unlike [`av_malloc`](@ref)(), the allocated memory is not guaranteed to be correctly aligned. The returned pointer must be freed after even if nmemb is zero.

# Arguments
* `ptr`: Pointer to a memory block already allocated with [`av_realloc`](@ref)() or `NULL`
* `nmemb`: Number of elements in the array
* `size`: Size of the single element of the array
# Returns
Pointer to a newly-reallocated block or NULL if the block cannot be reallocated
# See also
[`av_reallocp_array`](@ref)()
"""
function av_realloc_array(ptr, nmemb::Csize_t, size::Csize_t)
    ccall((:av_realloc_array, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Csize_t, Csize_t), ptr, nmemb, size)
end

"""
    av_reallocp_array(ptr, nmemb::Csize_t, size::Csize_t)

Allocate, reallocate an array through a pointer to a pointer.

If `*ptr` is `NULL` and `nmemb` > 0, allocate a new block.

!!! warning

    Unlike [`av_malloc`](@ref)(), the allocated memory is not guaranteed to be correctly aligned. *ptr must be freed after even if nmemb is zero.

# Arguments
* `ptr`:\\[in,out\\] Pointer to a pointer to a memory block already allocated with [`av_realloc`](@ref)(), or a pointer to `NULL`. The pointer is updated on success, or freed on failure.
* `nmemb`:\\[in\\] Number of elements
* `size`:\\[in\\] Size of the single element
# Returns
Zero on success, an [`AVERROR`](@ref) error code on failure
"""
function av_reallocp_array(ptr, nmemb::Csize_t, size::Csize_t)
    ccall((:av_reallocp_array, libavutil), Cint, (Ptr{Cvoid}, Csize_t, Csize_t), ptr, nmemb, size)
end

"""
    av_fast_realloc(ptr, size, min_size::Csize_t)

Reallocate the given buffer if it is not large enough, otherwise do nothing.

If the given buffer is `NULL`, then a new uninitialized buffer is allocated.

If the given buffer is not large enough, and reallocation fails, `NULL` is returned and `*size` is set to 0, but the original buffer is not changed or freed.

A typical use pattern follows:

```c++
{.c}
 uint8_t *buf = ...;
 uint8_t *new_buf = av_fast_realloc(buf, &current_size, size_needed);
 if (!new_buf) {
     // Allocation failed; clean up original buffer
     av_freep(&buf);
     return AVERROR(ENOMEM);
 }
```

# Arguments
* `ptr`:\\[in,out\\] Already allocated buffer, or `NULL`
* `size`:\\[in,out\\] Pointer to the size of buffer `ptr`. `*size` is updated to the new allocated size, in particular 0 in case of failure.
* `min_size`:\\[in\\] Desired minimal size of buffer `ptr`
# Returns
`ptr` if the buffer is large enough, a pointer to newly reallocated buffer if the buffer was not large enough, or `NULL` in case of error
# See also
[`av_realloc`](@ref)(), [`av_fast_malloc`](@ref)()
"""
function av_fast_realloc(ptr, size, min_size::Csize_t)
    ccall((:av_fast_realloc, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Ptr{Cuint}, Csize_t), ptr, size, min_size)
end

"""
    av_fast_malloc(ptr, size, min_size::Csize_t)

Allocate a buffer, reusing the given one if large enough.

Contrary to [`av_fast_realloc`](@ref)(), the current buffer contents might not be preserved and on error the old buffer is freed, thus no special handling to avoid memleaks is necessary.

`*ptr` is allowed to be `NULL`, in which case allocation always happens if `size_needed` is greater than 0.

```c++
{.c}
 uint8_t *buf = ...;
 av_fast_malloc(&buf, &current_size, size_needed);
 if (!buf) {
     // Allocation failed; buf already freed
     return AVERROR(ENOMEM);
 }
```

# Arguments
* `ptr`:\\[in,out\\] Pointer to pointer to an already allocated buffer. `*ptr` will be overwritten with pointer to new buffer on success or `NULL` on failure
* `size`:\\[in,out\\] Pointer to the size of buffer `*ptr`. `*size` is updated to the new allocated size, in particular 0 in case of failure.
* `min_size`:\\[in\\] Desired minimal size of buffer `*ptr`
# See also
[`av_realloc`](@ref)(), [`av_fast_mallocz`](@ref)()
"""
function av_fast_malloc(ptr, size, min_size::Csize_t)
    ccall((:av_fast_malloc, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Cuint}, Csize_t), ptr, size, min_size)
end

"""
    av_fast_mallocz(ptr, size, min_size::Csize_t)

Allocate and clear a buffer, reusing the given one if large enough.

Like [`av_fast_malloc`](@ref)(), but all newly allocated space is initially cleared. Reused buffer is not cleared.

`*ptr` is allowed to be `NULL`, in which case allocation always happens if `size_needed` is greater than 0.

# Arguments
* `ptr`:\\[in,out\\] Pointer to pointer to an already allocated buffer. `*ptr` will be overwritten with pointer to new buffer on success or `NULL` on failure
* `size`:\\[in,out\\] Pointer to the size of buffer `*ptr`. `*size` is updated to the new allocated size, in particular 0 in case of failure.
* `min_size`:\\[in\\] Desired minimal size of buffer `*ptr`
# See also
[`av_fast_malloc`](@ref)()
"""
function av_fast_mallocz(ptr, size, min_size::Csize_t)
    ccall((:av_fast_mallocz, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Cuint}, Csize_t), ptr, size, min_size)
end

"""
    av_free(ptr)

Free a memory block which has been allocated with a function of [`av_malloc`](@ref)() or [`av_realloc`](@ref)() family.

!!! note

    `ptr = NULL` is explicitly allowed.

!!! note

    It is recommended that you use [`av_freep`](@ref)() instead, to prevent leaving behind dangling pointers.

# Arguments
* `ptr`: Pointer to the memory block which should be freed.
# See also
[`av_freep`](@ref)()
"""
function av_free(ptr)
    ccall((:av_free, libavutil), Cvoid, (Ptr{Cvoid},), ptr)
end

"""
    av_freep(ptr)

Free a memory block which has been allocated with a function of [`av_malloc`](@ref)() or [`av_realloc`](@ref)() family, and set the pointer pointing to it to `NULL`.

```c++
{.c}
 uint8_t *buf = av_malloc(16);
 av_free(buf);
 // buf now contains a dangling pointer to freed memory, and accidental
 // dereference of buf will result in a use-after-free, which may be a
 // security risk.

 uint8_t *buf = av_malloc(16);
 av_freep(&buf);
 // buf is now NULL, and accidental dereference will only result in a
 // NULL-pointer dereference.
```

!!! note

    `*ptr = NULL` is safe and leads to no action.

# Arguments
* `ptr`: Pointer to the pointer to the memory block which should be freed
# See also
[`av_free`](@ref)()
"""
function av_freep(ptr)
    ccall((:av_freep, libavutil), Cvoid, (Ptr{Cvoid},), ptr)
end

"""
    av_strdup(s)

Duplicate a string.

# Arguments
* `s`: String to be duplicated
# Returns
Pointer to a newly-allocated string containing a copy of `s` or `NULL` if the string cannot be allocated
# See also
[`av_strndup`](@ref)()
"""
function av_strdup(s)
    ccall((:av_strdup, libavutil), Cstring, (Cstring,), s)
end

"""
    av_strndup(s, len::Csize_t)

Duplicate a substring of a string.

# Arguments
* `s`: String to be duplicated
* `len`: Maximum length of the resulting string (not counting the terminating byte)
# Returns
Pointer to a newly-allocated string containing a substring of `s` or `NULL` if the string cannot be allocated
"""
function av_strndup(s, len::Csize_t)
    ccall((:av_strndup, libavutil), Cstring, (Cstring, Csize_t), s, len)
end

"""
    av_memdup(p, size::Csize_t)

Duplicate a buffer with [`av_malloc`](@ref)().

# Arguments
* `p`: Buffer to be duplicated
* `size`: Size in bytes of the buffer copied
# Returns
Pointer to a newly allocated buffer containing a copy of `p` or `NULL` if the buffer cannot be allocated
"""
function av_memdup(p, size::Csize_t)
    ccall((:av_memdup, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Csize_t), p, size)
end

"""
    av_memcpy_backptr(dst, back::Integer, cnt::Integer)

Overlapping memcpy() implementation.

!!! note

    `cnt > back` is valid, this will copy the bytes we just copied, thus creating a repeating pattern with a period length of `back`.

# Arguments
* `dst`: Destination buffer
* `back`: Number of bytes back to start copying (i.e. the initial size of the overlapping window); must be > 0
* `cnt`: Number of bytes to copy; must be >= 0
"""
function av_memcpy_backptr(dst, back::Integer, cnt::Integer)
    ccall((:av_memcpy_backptr, libavutil), Cvoid, (Ptr{UInt8}, Cint, Cint), dst, back, cnt)
end

"""
    av_dynarray_add(tab_ptr, nb_ptr, elem)

Add the pointer to an element to a dynamic array.

The array to grow is supposed to be an array of pointers to structures, and the element to add must be a pointer to an already allocated structure.

The array is reallocated when its size reaches powers of 2. Therefore, the amortized cost of adding an element is constant.

In case of success, the pointer to the array is updated in order to point to the new grown array, and the number pointed to by `nb_ptr` is incremented. In case of failure, the array is freed, `*tab\\_ptr` is set to `NULL` and `*nb\\_ptr` is set to 0.

# Arguments
* `tab_ptr`:\\[in,out\\] Pointer to the array to grow
* `nb_ptr`:\\[in,out\\] Pointer to the number of elements in the array
* `elem`:\\[in\\] Element to add
# See also
[`av_dynarray_add_nofree`](@ref)(), [`av_dynarray2_add`](@ref)()
"""
function av_dynarray_add(tab_ptr, nb_ptr, elem)
    ccall((:av_dynarray_add, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Cint}, Ptr{Cvoid}), tab_ptr, nb_ptr, elem)
end

"""
    av_dynarray_add_nofree(tab_ptr, nb_ptr, elem)

Add an element to a dynamic array.

Function has the same functionality as [`av_dynarray_add`](@ref)(), but it doesn't free memory on fails. It returns error code instead and leave current buffer untouched.

# Returns
>=0 on success, negative otherwise
# See also
[`av_dynarray_add`](@ref)(), [`av_dynarray2_add`](@ref)()
"""
function av_dynarray_add_nofree(tab_ptr, nb_ptr, elem)
    ccall((:av_dynarray_add_nofree, libavutil), Cint, (Ptr{Cvoid}, Ptr{Cint}, Ptr{Cvoid}), tab_ptr, nb_ptr, elem)
end

"""
    av_dynarray2_add(tab_ptr, nb_ptr, elem_size::Csize_t, elem_data)

Add an element of size `elem_size` to a dynamic array.

The array is reallocated when its number of elements reaches powers of 2. Therefore, the amortized cost of adding an element is constant.

In case of success, the pointer to the array is updated in order to point to the new grown array, and the number pointed to by `nb_ptr` is incremented. In case of failure, the array is freed, `*tab\\_ptr` is set to `NULL` and `*nb\\_ptr` is set to 0.

# Arguments
* `tab_ptr`:\\[in,out\\] Pointer to the array to grow
* `nb_ptr`:\\[in,out\\] Pointer to the number of elements in the array
* `elem_size`:\\[in\\] Size in bytes of an element in the array
* `elem_data`:\\[in\\] Pointer to the data of the element to add. If `NULL`, the space of the newly added element is allocated but left uninitialized.
# Returns
Pointer to the data of the element to copy in the newly allocated space
# See also
[`av_dynarray_add`](@ref)(), [`av_dynarray_add_nofree`](@ref)()
"""
function av_dynarray2_add(tab_ptr, nb_ptr, elem_size::Csize_t, elem_data)
    ccall((:av_dynarray2_add, libavutil), Ptr{Cvoid}, (Ptr{Ptr{Cvoid}}, Ptr{Cint}, Csize_t, Ptr{UInt8}), tab_ptr, nb_ptr, elem_size, elem_data)
end

"""
    av_size_mult(a::Csize_t, b::Csize_t, r)

Multiply two `size_t` values checking for overflow.

# Arguments
* `a`:\\[in\\] Operand of multiplication
* `b`:\\[in\\] Operand of multiplication
* `r`:\\[out\\] Pointer to the result of the operation
# Returns
0 on success, [`AVERROR`](@ref)(EINVAL) on overflow
"""
function av_size_mult(a::Csize_t, b::Csize_t, r)
    ccall((:av_size_mult, libavutil), Cint, (Csize_t, Csize_t, Ptr{Csize_t}), a, b, r)
end

"""
    av_max_alloc(max::Csize_t)

Set the maximum size that may be allocated in one block.

The value specified with this function is effective for all libavutil's lavu_mem_funcs "heap management functions."

By default, the max value is defined as `INT_MAX`.

!!! warning

    Exercise extreme caution when using this function. Don't touch this if you do not understand the full consequence of doing so.

# Arguments
* `max`: Value to be set as the new maximum size
"""
function av_max_alloc(max::Csize_t)
    ccall((:av_max_alloc, libavutil), Cvoid, (Csize_t,), max)
end

struct AVMotionVector
    source::Int32
    w::UInt8
    h::UInt8
    src_x::Int16
    src_y::Int16
    dst_x::Int16
    dst_y::Int16
    flags::UInt64
    motion_x::Int32
    motion_y::Int32
    motion_scale::UInt16
end

mutable struct AVMurMur3 end

"""
    av_murmur3_alloc()

Allocate an [`AVMurMur3`](@ref) hash context.

# Returns
Uninitialized hash context or `NULL` in case of error
"""
function av_murmur3_alloc()
    ccall((:av_murmur3_alloc, libavutil), Ptr{AVMurMur3}, ())
end

"""
    av_murmur3_init_seeded(c, seed::UInt64)

Initialize or reinitialize an [`AVMurMur3`](@ref) hash context with a seed.

# Arguments
* `c`:\\[out\\] Hash context
* `seed`:\\[in\\] Random seed
# See also
[`av_murmur3_init`](@ref)(), lavu_murmur3_seedinfo "Detailed description" on a discussion of seeds for MurmurHash3.
"""
function av_murmur3_init_seeded(c, seed::UInt64)
    ccall((:av_murmur3_init_seeded, libavutil), Cvoid, (Ptr{AVMurMur3}, UInt64), c, seed)
end

"""
    av_murmur3_init(c)

Initialize or reinitialize an [`AVMurMur3`](@ref) hash context.

Equivalent to [`av_murmur3_init_seeded`](@ref)() with a built-in seed.

# Arguments
* `c`:\\[out\\] Hash context
# See also
[`av_murmur3_init_seeded`](@ref)(), lavu_murmur3_seedinfo "Detailed description" on a discussion of seeds for MurmurHash3.
"""
function av_murmur3_init(c)
    ccall((:av_murmur3_init, libavutil), Cvoid, (Ptr{AVMurMur3},), c)
end

"""
    av_murmur3_update(c, src, len::Csize_t)

Update hash context with new data.

# Arguments
* `c`:\\[out\\] Hash context
* `src`:\\[in\\] Input data to update hash with
* `len`:\\[in\\] Number of bytes to read from `src`
"""
function av_murmur3_update(c, src, len::Csize_t)
    ccall((:av_murmur3_update, libavutil), Cvoid, (Ptr{AVMurMur3}, Ptr{UInt8}, Csize_t), c, src, len)
end

"""
    av_murmur3_final(c, dst)

Finish hashing and output digest value.

# Arguments
* `c`:\\[in,out\\] Hash context
* `dst`:\\[out\\] Buffer where output digest value is stored
"""
function av_murmur3_final(c, dst)
    ccall((:av_murmur3_final, libavutil), Cvoid, (Ptr{AVMurMur3}, Ptr{UInt8}), c, dst)
end

function av_opt_set_bin(obj, name, val, size::Integer, search_flags::Integer)
    ccall((:av_opt_set_bin, libavutil), Cint, (Ptr{Cvoid}, Cstring, Ptr{UInt8}, Cint, Cint), obj, name, val, size, search_flags)
end

"""
    AVOptionArrayDef

May be set as default\\_val for AV\\_OPT\\_TYPE\\_FLAG\\_ARRAY options.
"""
struct AVOptionArrayDef
    def::Cstring
    size_min::Cuint
    size_max::Cuint
    sep::Cchar
end

"""
    AVOptionRange

A single allowed range of values, or a single allowed value.
"""
struct AVOptionRange
    str::Cstring
    value_min::Cdouble
    value_max::Cdouble
    component_min::Cdouble
    component_max::Cdouble
    is_range::Cint
end

"""
    AVOptionRanges

List of [`AVOptionRange`](@ref) structs.
"""
struct AVOptionRanges
    range::Ptr{Ptr{AVOptionRange}}
    nb_ranges::Cint
    nb_components::Cint
end

"""
    av_opt_set_defaults(s)

Set the values of all [`AVOption`](@ref) fields to their default values.

# Arguments
* `s`: an [`AVOption`](@ref)-enabled struct (its first member must be a pointer to [`AVClass`](@ref))
"""
function av_opt_set_defaults(s)
    ccall((:av_opt_set_defaults, libavutil), Cvoid, (Ptr{Cvoid},), s)
end

"""
    av_opt_set_defaults2(s, mask::Integer, flags::Integer)

Set the values of all [`AVOption`](@ref) fields to their default values. Only these [`AVOption`](@ref) fields for which (opt->flags & mask) == flags will have their default applied to s.

# Arguments
* `s`: an [`AVOption`](@ref)-enabled struct (its first member must be a pointer to [`AVClass`](@ref))
* `mask`: combination of AV\\_OPT\\_FLAG\\_*
* `flags`: combination of AV\\_OPT\\_FLAG\\_*
"""
function av_opt_set_defaults2(s, mask::Integer, flags::Integer)
    ccall((:av_opt_set_defaults2, libavutil), Cvoid, (Ptr{Cvoid}, Cint, Cint), s, mask, flags)
end

"""
    av_opt_free(obj)

Free all allocated objects in obj.
"""
function av_opt_free(obj)
    ccall((:av_opt_free, libavutil), Cvoid, (Ptr{Cvoid},), obj)
end

"""
    av_opt_next(obj, prev)

Iterate over all AVOptions belonging to obj.

# Arguments
* `obj`: an AVOptions-enabled struct or a double pointer to an [`AVClass`](@ref) describing it.
* `prev`: result of the previous call to [`av_opt_next`](@ref)() on this object or NULL
# Returns
next [`AVOption`](@ref) or NULL
"""
function av_opt_next(obj, prev)
    ccall((:av_opt_next, libavutil), Ptr{AVOption}, (Ptr{Cvoid}, Ptr{AVOption}), obj, prev)
end

"""
    av_opt_child_next(obj, prev)

Iterate over AVOptions-enabled children of obj.

# Arguments
* `prev`: result of a previous call to this function or NULL
# Returns
next AVOptions-enabled child or NULL
"""
function av_opt_child_next(obj, prev)
    ccall((:av_opt_child_next, libavutil), Ptr{Cvoid}, (Ptr{Cvoid}, Ptr{Cvoid}), obj, prev)
end

"""
    av_opt_child_class_iterate(parent, iter)

Iterate over potential AVOptions-enabled children of parent.

# Arguments
* `iter`: a pointer where iteration state is stored.
# Returns
[`AVClass`](@ref) corresponding to next potential child or NULL
"""
function av_opt_child_class_iterate(parent, iter)
    ccall((:av_opt_child_class_iterate, libavutil), Ptr{AVClass}, (Ptr{AVClass}, Ptr{Ptr{Cvoid}}), parent, iter)
end

"""
    av_opt_find(obj, name, unit, opt_flags::Integer, search_flags::Integer)

Look for an option in an object. Consider only options which have all the specified flags set.

!!! note

    Options found with [`AV_OPT_SEARCH_CHILDREN`](@ref) flag may not be settable directly with [`av_opt_set`](@ref)(). Use special calls which take an options [`AVDictionary`](@ref) (e.g. [`avformat_open_input`](@ref)()) to set options found with this flag.

# Arguments
* `obj`:\\[in\\] A pointer to a struct whose first element is a pointer to an [`AVClass`](@ref). Alternatively a double pointer to an [`AVClass`](@ref), if [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) search flag is set.
* `name`:\\[in\\] The name of the option to look for.
* `unit`:\\[in\\] When searching for named constants, name of the unit it belongs to.
* `opt_flags`: Find only options with all the specified flags set (AV\\_OPT\\_FLAG).
* `search_flags`: A combination of AV\\_OPT\\_SEARCH\\_*.
# Returns
A pointer to the option found, or NULL if no option was found.
"""
function av_opt_find(obj, name, unit, opt_flags::Integer, search_flags::Integer)
    ccall((:av_opt_find, libavutil), Ptr{AVOption}, (Ptr{Cvoid}, Cstring, Cstring, Cint, Cint), obj, name, unit, opt_flags, search_flags)
end

"""
    av_opt_find2(obj, name, unit, opt_flags::Integer, search_flags::Integer, target_obj)

Look for an option in an object. Consider only options which have all the specified flags set.

# Arguments
* `obj`:\\[in\\] A pointer to a struct whose first element is a pointer to an [`AVClass`](@ref). Alternatively a double pointer to an [`AVClass`](@ref), if [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) search flag is set.
* `name`:\\[in\\] The name of the option to look for.
* `unit`:\\[in\\] When searching for named constants, name of the unit it belongs to.
* `opt_flags`: Find only options with all the specified flags set (AV\\_OPT\\_FLAG).
* `search_flags`: A combination of AV\\_OPT\\_SEARCH\\_*.
* `target_obj`:\\[out\\] if non-NULL, an object to which the option belongs will be written here. It may be different from obj if [`AV_OPT_SEARCH_CHILDREN`](@ref) is present in search\\_flags. This parameter is ignored if search\\_flags contain [`AV_OPT_SEARCH_FAKE_OBJ`](@ref).
# Returns
A pointer to the option found, or NULL if no option was found.
"""
function av_opt_find2(obj, name, unit, opt_flags::Integer, search_flags::Integer, target_obj)
    ccall((:av_opt_find2, libavutil), Ptr{AVOption}, (Ptr{Cvoid}, Cstring, Cstring, Cint, Cint, Ptr{Ptr{Cvoid}}), obj, name, unit, opt_flags, search_flags, target_obj)
end

"""
    av_opt_show2(obj, av_log_obj, req_flags::Integer, rej_flags::Integer)

Show the obj options.

# Arguments
* `req_flags`: requested flags for the options to show. Show only the options for which it is opt->flags & req\\_flags.
* `rej_flags`: rejected flags for the options to show. Show only the options for which it is !(opt->flags & req\\_flags).
* `av_log_obj`: log context to use for showing the options
"""
function av_opt_show2(obj, av_log_obj, req_flags::Integer, rej_flags::Integer)
    ccall((:av_opt_show2, libavutil), Cint, (Ptr{Cvoid}, Ptr{Cvoid}, Cint, Cint), obj, av_log_obj, req_flags, rej_flags)
end

"""
    av_opt_get_key_value(ropts, key_val_sep, pairs_sep, flags::Integer, rkey, rval)

Extract a key-value pair from the beginning of a string.

# Arguments
* `ropts`: pointer to the options string, will be updated to point to the rest of the string (one of the pairs\\_sep or the final NUL)
* `key_val_sep`: a 0-terminated list of characters used to separate key from value, for example '='
* `pairs_sep`: a 0-terminated list of characters used to separate two pairs from each other, for example ':' or ','
* `flags`: flags; see the AV\\_OPT\\_FLAG\\_* values below
* `rkey`: parsed key; must be freed using [`av_free`](@ref)()
* `rval`: parsed value; must be freed using [`av_free`](@ref)()
# Returns
>=0 for success, or a negative value corresponding to an [`AVERROR`](@ref) code in case of error; in particular: [`AVERROR`](@ref)(EINVAL) if no key is present
"""
function av_opt_get_key_value(ropts, key_val_sep, pairs_sep, flags::Integer, rkey, rval)
    ccall((:av_opt_get_key_value, libavutil), Cint, (Ptr{Cstring}, Cstring, Cstring, Cuint, Ptr{Cstring}, Ptr{Cstring}), ropts, key_val_sep, pairs_sep, flags, rkey, rval)
end

const __JL_Ctag_81 = UInt32
const AV_OPT_FLAG_IMPLICIT_KEY = 1 % UInt32

"""
    av_set_options_string(ctx, opts, key_val_sep, pairs_sep)

Parse the key/value pairs list in opts. For each key/value pair found, stores the value in the field in ctx that is named like the key. ctx must be an [`AVClass`](@ref) context, storing is done using AVOptions.

# Arguments
* `opts`: options string to parse, may be NULL
* `key_val_sep`: a 0-terminated list of characters used to separate key from value
* `pairs_sep`: a 0-terminated list of characters used to separate two pairs from each other
# Returns
the number of successfully set key/value pairs, or a negative value corresponding to an [`AVERROR`](@ref) code in case of error: [`AVERROR`](@ref)(EINVAL) if opts cannot be parsed, the error code issued by [`av_opt_set`](@ref)() if a key/value pair cannot be set
"""
function av_set_options_string(ctx, opts, key_val_sep, pairs_sep)
    ccall((:av_set_options_string, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cstring, Cstring), ctx, opts, key_val_sep, pairs_sep)
end

"""
    av_opt_set_from_string(ctx, opts, shorthand, key_val_sep, pairs_sep)

Parse the key-value pairs list in opts. For each key=value pair found, set the value of the corresponding option in ctx.

Options names must use only the following characters: a-z A-Z 0-9 - . / \\_ Separators must use characters distinct from option names and from each other.

# Arguments
* `ctx`: the [`AVClass`](@ref) object to set options on
* `opts`: the options string, key-value pairs separated by a delimiter
* `shorthand`: a NULL-terminated array of options names for shorthand notation: if the first field in opts has no key part, the key is taken from the first element of shorthand; then again for the second, etc., until either opts is finished, shorthand is finished or a named option is found; after that, all options must be named
* `key_val_sep`: a 0-terminated list of characters used to separate key from value, for example '='
* `pairs_sep`: a 0-terminated list of characters used to separate two pairs from each other, for example ':' or ','
# Returns
the number of successfully set key=value pairs, or a negative value corresponding to an [`AVERROR`](@ref) code in case of error: [`AVERROR`](@ref)(EINVAL) if opts cannot be parsed, the error code issued by av\\_set\\_string3() if a key/value pair cannot be set
"""
function av_opt_set_from_string(ctx, opts, shorthand, key_val_sep, pairs_sep)
    ccall((:av_opt_set_from_string, libavutil), Cint, (Ptr{Cvoid}, Cstring, Ptr{Cstring}, Cstring, Cstring), ctx, opts, shorthand, key_val_sep, pairs_sep)
end

"""
    av_opt_set_dict(obj, options)

Set all the options from a given dictionary on an object.

# Arguments
* `obj`: a struct whose first element is a pointer to [`AVClass`](@ref)
* `options`: options to process. This dictionary will be freed and replaced by a new one containing all options not found in obj. Of course this new dictionary needs to be freed by caller with [`av_dict_free`](@ref)().
# Returns
0 on success, a negative [`AVERROR`](@ref) if some option was found in obj, but could not be set.
# See also
[`av_dict_copy`](@ref)()
"""
function av_opt_set_dict(obj, options)
    ccall((:av_opt_set_dict, libavutil), Cint, (Ptr{Cvoid}, Ptr{Ptr{AVDictionary}}), obj, options)
end

"""
    av_opt_set_dict2(obj, options, search_flags::Integer)

Set all the options from a given dictionary on an object.

# Arguments
* `obj`: a struct whose first element is a pointer to [`AVClass`](@ref)
* `options`: options to process. This dictionary will be freed and replaced by a new one containing all options not found in obj. Of course this new dictionary needs to be freed by caller with [`av_dict_free`](@ref)().
* `search_flags`: A combination of AV\\_OPT\\_SEARCH\\_*.
# Returns
0 on success, a negative [`AVERROR`](@ref) if some option was found in obj, but could not be set.
# See also
[`av_dict_copy`](@ref)()
"""
function av_opt_set_dict2(obj, options, search_flags::Integer)
    ccall((:av_opt_set_dict2, libavutil), Cint, (Ptr{Cvoid}, Ptr{Ptr{AVDictionary}}, Cint), obj, options, search_flags)
end

"""
    av_opt_copy(dest, src)

Copy options from src object into dest object.

The underlying [`AVClass`](@ref) of both src and dest must coincide. The guarantee below does not apply if this is not fulfilled.

Options that require memory allocation (e.g. string or binary) are malloc'ed in dest object. Original memory allocated for such options is freed unless both src and dest options points to the same memory.

Even on error it is guaranteed that allocated options from src and dest no longer alias each other afterwards; in particular calling [`av_opt_free`](@ref)() on both src and dest is safe afterwards if dest has been memdup'ed from src.

# Arguments
* `dest`: Object to copy from
* `src`: Object to copy into
# Returns
0 on success, negative on error
"""
function av_opt_copy(dest, src)
    ccall((:av_opt_copy, libavutil), Cint, (Ptr{Cvoid}, Ptr{Cvoid}), dest, src)
end

"""
    av_opt_set(obj, name, val, search_flags::Integer)

` opt_set_funcs Option setting functions`

@{ Those functions set the field of obj with the given name to value.

# Arguments
* `obj`:\\[in\\] A struct whose first element is a pointer to an [`AVClass`](@ref).
* `name`:\\[in\\] the name of the field to set
* `val`:\\[in\\] The value to set. In case of [`av_opt_set`](@ref)() if the field is not of a string type, then the given string is parsed. SI postfixes and some named scalars are supported. If the field is of a numeric type, it has to be a numeric or named scalar. Behavior with more than one scalar and +- infix operators is undefined. If the field is of a flags type, it has to be a sequence of numeric scalars or named flags separated by '+' or '-'. Prefixing a flag with '+' causes it to be set without affecting the other flags; similarly, '-' unsets a flag. If the field is of a dictionary type, it has to be a ':' separated list of key=value parameters. Values containing ':' special characters must be escaped.
* `search_flags`: flags passed to [`av_opt_find2`](@ref). I.e. if [`AV_OPT_SEARCH_CHILDREN`](@ref) is passed here, then the option may be set on a child of obj.
# Returns
0 if the value has been set, or an [`AVERROR`](@ref) code in case of error: [`AVERROR_OPTION_NOT_FOUND`](@ref) if no matching option exists [`AVERROR`](@ref)(ERANGE) if the value is out of range [`AVERROR`](@ref)(EINVAL) if the value is not valid
"""
function av_opt_set(obj, name, val, search_flags::Integer)
    ccall((:av_opt_set, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cstring, Cint), obj, name, val, search_flags)
end

function av_opt_set_int(obj, name, val::Int64, search_flags::Integer)
    ccall((:av_opt_set_int, libavutil), Cint, (Ptr{Cvoid}, Cstring, Int64, Cint), obj, name, val, search_flags)
end

function av_opt_set_double(obj, name, val::Cdouble, search_flags::Integer)
    ccall((:av_opt_set_double, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cdouble, Cint), obj, name, val, search_flags)
end

function av_opt_set_q(obj, name, val::AVRational, search_flags::Integer)
    ccall((:av_opt_set_q, libavutil), Cint, (Ptr{Cvoid}, Cstring, AVRational, Cint), obj, name, val, search_flags)
end

function av_opt_set_image_size(obj, name, w::Integer, h::Integer, search_flags::Integer)
    ccall((:av_opt_set_image_size, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Cint, Cint), obj, name, w, h, search_flags)
end

function av_opt_set_pixel_fmt(obj, name, fmt::AVPixelFormat, search_flags::Integer)
    ccall((:av_opt_set_pixel_fmt, libavutil), Cint, (Ptr{Cvoid}, Cstring, AVPixelFormat, Cint), obj, name, fmt, search_flags)
end

function av_opt_set_sample_fmt(obj, name, fmt::AVSampleFormat, search_flags::Integer)
    ccall((:av_opt_set_sample_fmt, libavutil), Cint, (Ptr{Cvoid}, Cstring, AVSampleFormat, Cint), obj, name, fmt, search_flags)
end

function av_opt_set_video_rate(obj, name, val::AVRational, search_flags::Integer)
    ccall((:av_opt_set_video_rate, libavutil), Cint, (Ptr{Cvoid}, Cstring, AVRational, Cint), obj, name, val, search_flags)
end

"""
    av_opt_set_chlayout(obj, name, layout, search_flags::Integer)

!!! note

    Any old chlayout present is discarded and replaced with a copy of the new one. The caller still owns layout and is responsible for uninitializing it.
"""
function av_opt_set_chlayout(obj, name, layout, search_flags::Integer)
    ccall((:av_opt_set_chlayout, libavutil), Cint, (Ptr{Cvoid}, Cstring, Ptr{AVChannelLayout}, Cint), obj, name, layout, search_flags)
end

"""
    av_opt_set_dict_val(obj, name, val, search_flags::Integer)

!!! note

    Any old dictionary present is discarded and replaced with a copy of the new one. The caller still owns val is and responsible for freeing it.
"""
function av_opt_set_dict_val(obj, name, val, search_flags::Integer)
    ccall((:av_opt_set_dict_val, libavutil), Cint, (Ptr{Cvoid}, Cstring, Ptr{AVDictionary}, Cint), obj, name, val, search_flags)
end

"""
    av_opt_set_array(obj, name, search_flags::Integer, start_elem::Integer, nb_elems::Integer, val_type::AVOptionType, val)

Add, replace, or remove elements for an array option. Which of these operations is performed depends on the values of val and search\\_flags.

The effect of this function will will be as if av\\_opt\\_setX() was called for each element, where X is specified by type. E.g. AV\\_OPT\\_TYPE\\_STRING corresponds to [`av_opt_set`](@ref)().

Typically this should be the same as the scalarized type of the [`AVOption`](@ref) being set, but certain conversions are also possible - the same as those done by the corresponding [`av_opt_set`](@ref)*() function. E.g. any option type can be set from a string, numeric types can be set from int64, double, or rational, etc.

When NULL, nb\\_elems array elements starting at start\\_elem are removed from the array. Any array elements remaining at the end are shifted by nb\\_elems towards the first element in order to keep the array contiguous.

Otherwise (val is non-NULL), the type of val must match the underlying C type as documented for val\\_type.

When [`AV_OPT_ARRAY_REPLACE`](@ref) is not set in search\\_flags, the array is enlarged by nb\\_elems, and the contents of val are inserted at start\\_elem. Previously existing array elements from start\\_elem onwards (if present) are shifted by nb\\_elems away from the first element in order to make space for the new elements.

When [`AV_OPT_ARRAY_REPLACE`](@ref) is set in search\\_flags, the contents of val replace existing array elements from start\\_elem to start\\_elem+nb\\_elems (if present). New array size is max(start\\_elem + nb\\_elems, old array size).

# Arguments
* `start_elem`: Index of the first array element to modify; must not be larger than array size as returned by [`av_opt_get_array_size`](@ref)().
* `nb_elems`: number of array elements to modify; when val is NULL, start\\_elem+nb\\_elems must not be larger than array size as returned by [`av_opt_get_array_size`](@ref)()
* `val_type`: Option type corresponding to the type of val, ignored when val is NULL.
* `val`: Array with nb\\_elems elements or NULL.
"""
function av_opt_set_array(obj, name, search_flags::Integer, start_elem::Integer, nb_elems::Integer, val_type::AVOptionType, val)
    ccall((:av_opt_set_array, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Cuint, Cuint, AVOptionType, Ptr{Cvoid}), obj, name, search_flags, start_elem, nb_elems, val_type, val)
end

"""
    av_opt_get(obj, name, search_flags::Integer, out_val)

` opt_get_funcs Option getting functions`

@{ Those functions get a value of the option with the given name from an object.

!!! note

    the returned string will be [`av_malloc`](@ref)()ed and must be [`av_free`](@ref)()ed by the caller

!!! note

    if [`AV_OPT_ALLOW_NULL`](@ref) is set in search\\_flags in [`av_opt_get`](@ref), and the option is of type AV\\_OPT\\_TYPE\\_STRING, AV\\_OPT\\_TYPE\\_BINARY or AV\\_OPT\\_TYPE\\_DICT and is set to NULL, *out\\_val will be set to NULL instead of an allocated empty string.

# Arguments
* `obj`:\\[in\\] a struct whose first element is a pointer to an [`AVClass`](@ref).
* `name`:\\[in\\] name of the option to get.
* `search_flags`:\\[in\\] flags passed to [`av_opt_find2`](@ref). I.e. if [`AV_OPT_SEARCH_CHILDREN`](@ref) is passed here, then the option may be found in a child of obj.
* `out_val`:\\[out\\] value of the option will be written here
# Returns
>=0 on success, a negative error code otherwise
"""
function av_opt_get(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Ptr{UInt8}}), obj, name, search_flags, out_val)
end

function av_opt_get_int(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_int, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Int64}), obj, name, search_flags, out_val)
end

function av_opt_get_double(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_double, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Cdouble}), obj, name, search_flags, out_val)
end

function av_opt_get_q(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_q, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{AVRational}), obj, name, search_flags, out_val)
end

function av_opt_get_image_size(obj, name, search_flags::Integer, w_out, h_out)
    ccall((:av_opt_get_image_size, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Cint}, Ptr{Cint}), obj, name, search_flags, w_out, h_out)
end

function av_opt_get_pixel_fmt(obj, name, search_flags::Integer, out_fmt)
    ccall((:av_opt_get_pixel_fmt, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{AVPixelFormat}), obj, name, search_flags, out_fmt)
end

function av_opt_get_sample_fmt(obj, name, search_flags::Integer, out_fmt)
    ccall((:av_opt_get_sample_fmt, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{AVSampleFormat}), obj, name, search_flags, out_fmt)
end

function av_opt_get_video_rate(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_video_rate, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{AVRational}), obj, name, search_flags, out_val)
end

"""
    av_opt_get_chlayout(obj, name, search_flags::Integer, layout)

# Arguments
* `layout`:\\[out\\] The returned layout is a copy of the actual value and must be freed with [`av_channel_layout_uninit`](@ref)() by the caller
"""
function av_opt_get_chlayout(obj, name, search_flags::Integer, layout)
    ccall((:av_opt_get_chlayout, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{AVChannelLayout}), obj, name, search_flags, layout)
end

"""
    av_opt_get_dict_val(obj, name, search_flags::Integer, out_val)

# Arguments
* `out_val`:\\[out\\] The returned dictionary is a copy of the actual value and must be freed with [`av_dict_free`](@ref)() by the caller
"""
function av_opt_get_dict_val(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_dict_val, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Ptr{AVDictionary}}), obj, name, search_flags, out_val)
end

"""
    av_opt_get_array_size(obj, name, search_flags::Integer, out_val)

For an array-type option, get the number of elements in the array.
"""
function av_opt_get_array_size(obj, name, search_flags::Integer, out_val)
    ccall((:av_opt_get_array_size, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Ptr{Cuint}), obj, name, search_flags, out_val)
end

"""
    av_opt_get_array(obj, name, search_flags::Integer, start_elem::Integer, nb_elems::Integer, out_type::AVOptionType, out_val)

For an array-type option, retrieve the values of one or more array elements.

The array elements produced by this function will will be as if av\\_opt\\_getX() was called for each element, where X is specified by out\\_type. E.g. AV\\_OPT\\_TYPE\\_STRING corresponds to [`av_opt_get`](@ref)().

Typically this should be the same as the scalarized type of the [`AVOption`](@ref) being retrieved, but certain conversions are also possible - the same as those done by the corresponding [`av_opt_get`](@ref)*() function. E.g. any option type can be retrieved as a string, numeric types can be retrieved as int64, double, or rational, etc.

For dynamically allocated types (strings, binary, dicts, etc.), the result is owned and freed by the caller.

# Arguments
* `start_elem`: index of the first array element to retrieve
* `nb_elems`: number of array elements to retrieve; start\\_elem+nb\\_elems must not be larger than array size as returned by [`av_opt_get_array_size`](@ref)()
* `out_type`: Option type corresponding to the desired output.
* `out_val`: Array with nb\\_elems members into which the output will be written. The array type must match the underlying C type as documented for out\\_type, and be zeroed on entry to this function.
"""
function av_opt_get_array(obj, name, search_flags::Integer, start_elem::Integer, nb_elems::Integer, out_type::AVOptionType, out_val)
    ccall((:av_opt_get_array, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint, Cuint, Cuint, AVOptionType, Ptr{Cvoid}), obj, name, search_flags, start_elem, nb_elems, out_type, out_val)
end

"""
    av_opt_eval_flags(obj, o, val, flags_out)

` opt_eval_funcs Evaluating option strings`

@{ This group of functions can be used to evaluate option strings and get numbers out of them. They do the same thing as [`av_opt_set`](@ref)(), except the result is written into the caller-supplied pointer.

# Arguments
* `obj`: a struct whose first element is a pointer to [`AVClass`](@ref).
* `o`: an option for which the string is to be evaluated.
* `val`: string to be evaluated.
* `*_out`: value of the string will be written here.
# Returns
0 on success, a negative number on failure.
"""
function av_opt_eval_flags(obj, o, val, flags_out)
    ccall((:av_opt_eval_flags, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Cint}), obj, o, val, flags_out)
end

function av_opt_eval_int(obj, o, val, int_out)
    ccall((:av_opt_eval_int, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Cint}), obj, o, val, int_out)
end

function av_opt_eval_uint(obj, o, val, uint_out)
    ccall((:av_opt_eval_uint, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Cuint}), obj, o, val, uint_out)
end

function av_opt_eval_int64(obj, o, val, int64_out)
    ccall((:av_opt_eval_int64, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Int64}), obj, o, val, int64_out)
end

function av_opt_eval_float(obj, o, val, float_out)
    ccall((:av_opt_eval_float, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Cfloat}), obj, o, val, float_out)
end

function av_opt_eval_double(obj, o, val, double_out)
    ccall((:av_opt_eval_double, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{Cdouble}), obj, o, val, double_out)
end

function av_opt_eval_q(obj, o, val, q_out)
    ccall((:av_opt_eval_q, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}, Cstring, Ptr{AVRational}), obj, o, val, q_out)
end

"""
    av_opt_ptr(avclass, obj, name)

Gets a pointer to the requested field in a struct. This function allows accessing a struct even when its fields are moved or renamed since the application making the access has been compiled,

!!! compat "Deprecated"

    direct access to [`AVOption`](@ref)-exported fields is not supported

# Returns
a pointer to the field, it can be cast to the correct type and read or written to.
"""
function av_opt_ptr(avclass, obj, name)
    ccall((:av_opt_ptr, libavutil), Ptr{Cvoid}, (Ptr{AVClass}, Ptr{Cvoid}, Cstring), avclass, obj, name)
end

"""
    av_opt_is_set_to_default(obj, o)

Check if given option is set to its default value.

Options o must belong to the obj. This function must not be called to check child's options state.

# Arguments
* `obj`: [`AVClass`](@ref) object to check option on
* `o`: option to be checked
# Returns
>0 when option is set to its default, 0 when option is not set its default, <0 on error
# See also
[`av_opt_is_set_to_default_by_name`](@ref)().
"""
function av_opt_is_set_to_default(obj, o)
    ccall((:av_opt_is_set_to_default, libavutil), Cint, (Ptr{Cvoid}, Ptr{AVOption}), obj, o)
end

"""
    av_opt_is_set_to_default_by_name(obj, name, search_flags::Integer)

Check if given option is set to its default value.

# Arguments
* `obj`: [`AVClass`](@ref) object to check option on
* `name`: option name
* `search_flags`: combination of AV\\_OPT\\_SEARCH\\_*
# Returns
>0 when option is set to its default, 0 when option is not set its default, <0 on error
"""
function av_opt_is_set_to_default_by_name(obj, name, search_flags::Integer)
    ccall((:av_opt_is_set_to_default_by_name, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cint), obj, name, search_flags)
end

"""
    av_opt_flag_is_set(obj, field_name, flag_name)

Check whether a particular flag is set in a flags field.

# Arguments
* `field_name`: the name of the flag field option
* `flag_name`: the name of the flag to check
# Returns
non-zero if the flag is set, zero if the flag isn't set, isn't of the right type, or the flags field doesn't exist.
"""
function av_opt_flag_is_set(obj, field_name, flag_name)
    ccall((:av_opt_flag_is_set, libavutil), Cint, (Ptr{Cvoid}, Cstring, Cstring), obj, field_name, flag_name)
end

"""
    av_opt_serialize(obj, opt_flags::Integer, flags::Integer, buffer, key_val_sep::Cchar, pairs_sep::Cchar)

Serialize object's options.

Create a string containing object's serialized options. Such string may be passed back to [`av_opt_set_from_string`](@ref)() in order to restore option values. A key/value or pairs separator occurring in the serialized value or name string are escaped through the [`av_escape`](@ref)() function.

!!! warning

    Separators cannot be neither '\\' nor '\\0'. They also cannot be the same.

# Arguments
* `obj`:\\[in\\] [`AVClass`](@ref) object to serialize
* `opt_flags`:\\[in\\] serialize options with all the specified flags set (AV\\_OPT\\_FLAG)
* `flags`:\\[in\\] combination of AV\\_OPT\\_SERIALIZE\\_* flags
* `buffer`:\\[out\\] Pointer to buffer that will be allocated with string containing serialized options. Buffer must be freed by the caller when is no longer needed.
* `key_val_sep`:\\[in\\] character used to separate key from value
* `pairs_sep`:\\[in\\] character used to separate two pairs from each other
# Returns
>= 0 on success, negative on error
"""
function av_opt_serialize(obj, opt_flags::Integer, flags::Integer, buffer, key_val_sep::Cchar, pairs_sep::Cchar)
    ccall((:av_opt_serialize, libavutil), Cint, (Ptr{Cvoid}, Cint, Cint, Ptr{Cstring}, Cchar, Cchar), obj, opt_flags, flags, buffer, key_val_sep, pairs_sep)
end

"""
    av_opt_freep_ranges(ranges)

Free an [`AVOptionRanges`](@ref) struct and set it to NULL.
"""
function av_opt_freep_ranges(ranges)
    ccall((:av_opt_freep_ranges, libavutil), Cvoid, (Ptr{Ptr{AVOptionRanges}},), ranges)
end

"""
    av_opt_query_ranges(arg1, obj, key, flags::Integer)

Get a list of allowed ranges for the given option.

The returned list may depend on other fields in obj like for example profile.

The result must be freed with [`av_opt_freep_ranges`](@ref).

# Arguments
* `flags`: is a bitmask of flags, undefined flags should not be set and should be ignored [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) indicates that the obj is a double pointer to a [`AVClass`](@ref) instead of a full instance [`AV_OPT_MULTI_COMPONENT_RANGE`](@ref) indicates that function may return more than one component,
# Returns
number of components returned on success, a negative error code otherwise
# See also
[`AVOptionRanges`](@ref)
"""
function av_opt_query_ranges(arg1, obj, key, flags::Integer)
    ccall((:av_opt_query_ranges, libavutil), Cint, (Ptr{Ptr{AVOptionRanges}}, Ptr{Cvoid}, Cstring, Cint), arg1, obj, key, flags)
end

"""
    av_opt_query_ranges_default(arg1, obj, key, flags::Integer)

Get a default list of allowed ranges for the given option.

This list is constructed without using the [`AVClass`](@ref).query\\_ranges() callback and can be used as fallback from within the callback.

The result must be freed with av\\_opt\\_free\\_ranges.

# Arguments
* `flags`: is a bitmask of flags, undefined flags should not be set and should be ignored [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) indicates that the obj is a double pointer to a [`AVClass`](@ref) instead of a full instance [`AV_OPT_MULTI_COMPONENT_RANGE`](@ref) indicates that function may return more than one component,
# Returns
number of components returned on success, a negative error code otherwise
# See also
[`AVOptionRanges`](@ref)
"""
function av_opt_query_ranges_default(arg1, obj, key, flags::Integer)
    ccall((:av_opt_query_ranges_default, libavutil), Cint, (Ptr{Ptr{AVOptionRanges}}, Ptr{Cvoid}, Cstring, Cint), arg1, obj, key, flags)
end

"""
    av_parse_ratio(q, str, max::Integer, log_offset::Integer, log_ctx)

Parse str and store the parsed ratio in q.

Note that a ratio with infinite (1/0) or negative value is considered valid, so you should check on the returned value if you want to exclude those values.

The undefined value can be expressed using the "0:0" string.

# Arguments
* `q`:\\[in,out\\] pointer to the [`AVRational`](@ref) which will contain the ratio
* `str`:\\[in\\] the string to parse: it has to be a string in the format num:den, a float number or an expression
* `max`:\\[in\\] the maximum allowed numerator and denominator
* `log_offset`:\\[in\\] log level offset which is applied to the log level of log\\_ctx
* `log_ctx`:\\[in\\] parent logging context
# Returns
>= 0 on success, a negative error code otherwise
"""
function av_parse_ratio(q, str, max::Integer, log_offset::Integer, log_ctx)
    ccall((:av_parse_ratio, libavutil), Cint, (Ptr{AVRational}, Cstring, Cint, Cint, Ptr{Cvoid}), q, str, max, log_offset, log_ctx)
end

"""
    av_parse_video_size(width_ptr, height_ptr, str)

Parse str and put in width\\_ptr and height\\_ptr the detected values.

# Arguments
* `width_ptr`:\\[in,out\\] pointer to the variable which will contain the detected width value
* `height_ptr`:\\[in,out\\] pointer to the variable which will contain the detected height value
* `str`:\\[in\\] the string to parse: it has to be a string in the format width x height or a valid video size abbreviation.
# Returns
>= 0 on success, a negative error code otherwise
"""
function av_parse_video_size(width_ptr, height_ptr, str)
    ccall((:av_parse_video_size, libavutil), Cint, (Ptr{Cint}, Ptr{Cint}, Cstring), width_ptr, height_ptr, str)
end

"""
    av_parse_video_rate(rate, str)

Parse str and store the detected values in *rate.

# Arguments
* `rate`:\\[in,out\\] pointer to the [`AVRational`](@ref) which will contain the detected frame rate
* `str`:\\[in\\] the string to parse: it has to be a string in the format rate\\_num / rate\\_den, a float number or a valid video rate abbreviation
# Returns
>= 0 on success, a negative error code otherwise
"""
function av_parse_video_rate(rate, str)
    ccall((:av_parse_video_rate, libavutil), Cint, (Ptr{AVRational}, Cstring), rate, str)
end

"""
    av_parse_color(rgba_color, color_string, slen::Integer, log_ctx)

Put the RGBA values that correspond to color\\_string in rgba\\_color.

# Arguments
* `rgba_color`: 4-elements array of uint8\\_t values, where the respective red, green, blue and alpha component values are written.
* `color_string`: a string specifying a color. It can be the name of a color (case insensitive match) or a [0x|#]RRGGBB[AA] sequence, possibly followed by "@" and a string representing the alpha component. The alpha component may be a string composed by "0x" followed by an hexadecimal number or a decimal number between 0.0 and 1.0, which represents the opacity value (0x00/0.0 means completely transparent, 0xff/1.0 completely opaque). If the alpha component is not specified then 0xff is assumed. The string "random" will result in a random color.
* `slen`: length of the initial part of color\\_string containing the color. It can be set to -1 if color\\_string is a null terminated string containing nothing else than the color.
* `log_ctx`: a pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct (used for [`av_log`](@ref)()). Can be NULL.
# Returns
>= 0 in case of success, a negative value in case of failure (for example if color\\_string cannot be parsed).
"""
function av_parse_color(rgba_color, color_string, slen::Integer, log_ctx)
    ccall((:av_parse_color, libavutil), Cint, (Ptr{UInt8}, Cstring, Cint, Ptr{Cvoid}), rgba_color, color_string, slen, log_ctx)
end

"""
    av_get_known_color_name(color_idx::Integer, rgb)

Get the name of a color from the internal table of hard-coded named colors.

This function is meant to enumerate the color names recognized by [`av_parse_color`](@ref)().

# Arguments
* `color_idx`: index of the requested color, starting from 0
* `rgb`: if not NULL, will point to a 3-elements array with the color value in RGB
# Returns
the color name string or NULL if color\\_idx is not in the array
"""
function av_get_known_color_name(color_idx::Integer, rgb)
    ccall((:av_get_known_color_name, libavutil), Cstring, (Cint, Ptr{Ptr{UInt8}}), color_idx, rgb)
end

"""
    av_parse_time(timeval, timestr, duration::Integer)

Parse timestr and return in *time a corresponding number of microseconds.

```c++
 [{YYYY-MM-DD|YYYYMMDD}[T|t| ]]{{HH:MM:SS[.m...]]]}|{HHMMSS[.m...]]]}}[Z]
 now
```

If the value is "now" it takes the current time. Time is local time unless Z is appended, in which case it is interpreted as UTC. If the year-month-day part is not specified it takes the current year-month-day. - If a duration the syntax is:

```c++
 [-][HH:]MM:SS[.m...]
 [-]S+[.m...]
```

# Arguments
* `timeval`: puts here the number of microseconds corresponding to the string in timestr. If the string represents a duration, it is the number of microseconds contained in the time interval. If the string is a date, is the number of microseconds since 1st of January, 1970 up to the time of the parsed date. If timestr cannot be successfully parsed, set *time to INT64\\_MIN.
* `timestr`: a string representing a date or a duration. - If a date the syntax is:
* `duration`: flag which tells how to interpret timestr, if not zero timestr is interpreted as a duration, otherwise as a date
# Returns
>= 0 in case of success, a negative value corresponding to an [`AVERROR`](@ref) code otherwise
"""
function av_parse_time(timeval, timestr, duration::Integer)
    ccall((:av_parse_time, libavutil), Cint, (Ptr{Int64}, Cstring, Cint), timeval, timestr, duration)
end

"""
    av_find_info_tag(arg, arg_size::Integer, tag1, info)

Attempt to find a specific tag in a URL.

syntax: '?tag1=val1&tag2=val2...'. Little URL decoding is done. Return 1 if found.
"""
function av_find_info_tag(arg, arg_size::Integer, tag1, info)
    ccall((:av_find_info_tag, libavutil), Cint, (Cstring, Cint, Cstring, Cstring), arg, arg_size, tag1, info)
end

"""
    av_small_strptime(p, fmt, dt)

Simplified version of strptime

Parse the input string p according to the format string fmt and store its results in the structure dt. This implementation supports only a subset of the formats supported by the standard strptime().

The supported input field descriptors are listed below. - `%H`: the hour as a decimal number, using a 24-hour clock, in the range '00' through '23' - `%J`: hours as a decimal number, in the range '0' through INT\\_MAX - `%M`: the minute as a decimal number, using a 24-hour clock, in the range '00' through '59' - `%S`: the second as a decimal number, using a 24-hour clock, in the range '00' through '59' - `%Y`: the year as a decimal number, using the Gregorian calendar - `%m`: the month as a decimal number, in the range '1' through '12' - `%d`: the day of the month as a decimal number, in the range '1' through '31' - `%T`: alias for `%H:%M:%S` - `%%`: a literal `%`

# Returns
a pointer to the first character not processed in this function call. In case the input string contains more characters than required by the format string the return value points right after the last consumed input character. In case the whole input string is consumed the return value points to the null byte at the end of the string. On failure NULL is returned.
"""
function av_small_strptime(p, fmt, dt)
    ccall((:av_small_strptime, libavutil), Cstring, (Cstring, Cstring, Ptr{tm}), p, fmt, dt)
end

"""
    av_timegm(tm_)

Convert the decomposed UTC time in [`tm`](@ref) to a time\\_t value.
"""
function av_timegm(tm_)
    ccall((:av_timegm, libavutil), time_t, (Ptr{tm},), tm_)
end

"""
    av_get_bits_per_pixel(pixdesc)

Return the number of bits per pixel used by the pixel format described by pixdesc. Note that this is not the same as the number of bits per sample.

The returned number of bits refers to the number of bits actually used for storing the pixel information, that is padding bits are not counted.
"""
function av_get_bits_per_pixel(pixdesc)
    ccall((:av_get_bits_per_pixel, libavutil), Cint, (Ptr{AVPixFmtDescriptor},), pixdesc)
end

"""
    av_get_padded_bits_per_pixel(pixdesc)

Return the number of bits per pixel for the pixel format described by pixdesc, including any padding or unused bits.
"""
function av_get_padded_bits_per_pixel(pixdesc)
    ccall((:av_get_padded_bits_per_pixel, libavutil), Cint, (Ptr{AVPixFmtDescriptor},), pixdesc)
end

"""
    av_pix_fmt_desc_get(pix_fmt::AVPixelFormat)

# Returns
a pixel format descriptor for provided pixel format or NULL if this pixel format is unknown.
"""
function av_pix_fmt_desc_get(pix_fmt::AVPixelFormat)
    ccall((:av_pix_fmt_desc_get, libavutil), Ptr{AVPixFmtDescriptor}, (AVPixelFormat,), pix_fmt)
end

"""
    av_pix_fmt_desc_next(prev)

Iterate over all pixel format descriptors known to libavutil.

# Arguments
* `prev`: previous descriptor. NULL to get the first descriptor.
# Returns
next descriptor or NULL after the last descriptor
"""
function av_pix_fmt_desc_next(prev)
    ccall((:av_pix_fmt_desc_next, libavutil), Ptr{AVPixFmtDescriptor}, (Ptr{AVPixFmtDescriptor},), prev)
end

"""
    av_pix_fmt_desc_get_id(desc)

# Returns
an [`AVPixelFormat`](@ref) id described by desc, or AV\\_PIX\\_FMT\\_NONE if desc is not a valid pointer to a pixel format descriptor.
"""
function av_pix_fmt_desc_get_id(desc)
    ccall((:av_pix_fmt_desc_get_id, libavutil), AVPixelFormat, (Ptr{AVPixFmtDescriptor},), desc)
end

"""
    av_pix_fmt_get_chroma_sub_sample(pix_fmt::AVPixelFormat, h_shift, v_shift)

Utility function to access log2\\_chroma\\_w log2\\_chroma\\_h from the pixel format [`AVPixFmtDescriptor`](@ref).

# Arguments
* `pix_fmt`:\\[in\\] the pixel format
* `h_shift`:\\[out\\] store log2\\_chroma\\_w (horizontal/width shift)
* `v_shift`:\\[out\\] store log2\\_chroma\\_h (vertical/height shift)
# Returns
0 on success, [`AVERROR`](@ref)(ENOSYS) on invalid or unknown pixel format
"""
function av_pix_fmt_get_chroma_sub_sample(pix_fmt::AVPixelFormat, h_shift, v_shift)
    ccall((:av_pix_fmt_get_chroma_sub_sample, libavutil), Cint, (AVPixelFormat, Ptr{Cint}, Ptr{Cint}), pix_fmt, h_shift, v_shift)
end

"""
    av_pix_fmt_count_planes(pix_fmt::AVPixelFormat)

# Returns
number of planes in pix\\_fmt, a negative [`AVERROR`](@ref) if pix\\_fmt is not a valid pixel format.
"""
function av_pix_fmt_count_planes(pix_fmt::AVPixelFormat)
    ccall((:av_pix_fmt_count_planes, libavutil), Cint, (AVPixelFormat,), pix_fmt)
end

"""
    av_color_range_name(range::AVColorRange)

# Returns
the name for provided color range or NULL if unknown.
"""
function av_color_range_name(range::AVColorRange)
    ccall((:av_color_range_name, libavutil), Cstring, (AVColorRange,), range)
end

"""
    av_color_range_from_name(name)

# Returns
the [`AVColorRange`](@ref) value for name or an AVError if not found.
"""
function av_color_range_from_name(name)
    ccall((:av_color_range_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_color_primaries_name(primaries::AVColorPrimaries)

# Returns
the name for provided color primaries or NULL if unknown.
"""
function av_color_primaries_name(primaries::AVColorPrimaries)
    ccall((:av_color_primaries_name, libavutil), Cstring, (AVColorPrimaries,), primaries)
end

"""
    av_color_primaries_from_name(name)

# Returns
the [`AVColorPrimaries`](@ref) value for name or an AVError if not found.
"""
function av_color_primaries_from_name(name)
    ccall((:av_color_primaries_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_color_transfer_name(transfer::AVColorTransferCharacteristic)

# Returns
the name for provided color transfer or NULL if unknown.
"""
function av_color_transfer_name(transfer::AVColorTransferCharacteristic)
    ccall((:av_color_transfer_name, libavutil), Cstring, (AVColorTransferCharacteristic,), transfer)
end

"""
    av_color_transfer_from_name(name)

# Returns
the [`AVColorTransferCharacteristic`](@ref) value for name or an AVError if not found.
"""
function av_color_transfer_from_name(name)
    ccall((:av_color_transfer_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_color_space_name(space::AVColorSpace)

# Returns
the name for provided color space or NULL if unknown.
"""
function av_color_space_name(space::AVColorSpace)
    ccall((:av_color_space_name, libavutil), Cstring, (AVColorSpace,), space)
end

"""
    av_color_space_from_name(name)

# Returns
the [`AVColorSpace`](@ref) value for name or an AVError if not found.
"""
function av_color_space_from_name(name)
    ccall((:av_color_space_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_chroma_location_name(location::AVChromaLocation)

# Returns
the name for provided chroma location or NULL if unknown.
"""
function av_chroma_location_name(location::AVChromaLocation)
    ccall((:av_chroma_location_name, libavutil), Cstring, (AVChromaLocation,), location)
end

"""
    av_chroma_location_from_name(name)

# Returns
the [`AVChromaLocation`](@ref) value for name or an AVError if not found.
"""
function av_chroma_location_from_name(name)
    ccall((:av_chroma_location_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_chroma_location_enum_to_pos(xpos, ypos, pos::AVChromaLocation)

Converts [`AVChromaLocation`](@ref) to swscale x/y chroma position.

The positions represent the chroma (0,0) position in a coordinates system with luma (0,0) representing the origin and luma(1,1) representing 256,256

# Arguments
* `xpos`: horizontal chroma sample position
* `ypos`: vertical chroma sample position
"""
function av_chroma_location_enum_to_pos(xpos, ypos, pos::AVChromaLocation)
    ccall((:av_chroma_location_enum_to_pos, libavutil), Cint, (Ptr{Cint}, Ptr{Cint}, AVChromaLocation), xpos, ypos, pos)
end

"""
    av_chroma_location_pos_to_enum(xpos::Integer, ypos::Integer)

Converts swscale x/y chroma position to [`AVChromaLocation`](@ref).

The positions represent the chroma (0,0) position in a coordinates system with luma (0,0) representing the origin and luma(1,1) representing 256,256

# Arguments
* `xpos`: horizontal chroma sample position
* `ypos`: vertical chroma sample position
"""
function av_chroma_location_pos_to_enum(xpos::Integer, ypos::Integer)
    ccall((:av_chroma_location_pos_to_enum, libavutil), AVChromaLocation, (Cint, Cint), xpos, ypos)
end

"""
    av_get_pix_fmt(name)

Return the pixel format corresponding to name.

If there is no pixel format with name name, then looks for a pixel format with the name corresponding to the native endian format of name. For example in a little-endian system, first looks for "gray16", then for "gray16le".

Finally if no pixel format has been found, returns AV\\_PIX\\_FMT\\_NONE.
"""
function av_get_pix_fmt(name)
    ccall((:av_get_pix_fmt, libavutil), AVPixelFormat, (Cstring,), name)
end

"""
    av_get_pix_fmt_name(pix_fmt::AVPixelFormat)

Return the short name for a pixel format, NULL in case pix\\_fmt is unknown.

# See also
[`av_get_pix_fmt`](@ref)(), [`av_get_pix_fmt_string`](@ref)()
"""
function av_get_pix_fmt_name(pix_fmt::AVPixelFormat)
    ccall((:av_get_pix_fmt_name, libavutil), Cstring, (AVPixelFormat,), pix_fmt)
end

"""
    av_get_pix_fmt_string(buf, buf_size::Integer, pix_fmt::AVPixelFormat)

Print in buf the string corresponding to the pixel format with number pix\\_fmt, or a header if pix\\_fmt is negative.

# Arguments
* `buf`: the buffer where to write the string
* `buf_size`: the size of buf
* `pix_fmt`: the number of the pixel format to print the corresponding info string, or a negative value to print the corresponding header.
"""
function av_get_pix_fmt_string(buf, buf_size::Integer, pix_fmt::AVPixelFormat)
    ccall((:av_get_pix_fmt_string, libavutil), Cstring, (Cstring, Cint, AVPixelFormat), buf, buf_size, pix_fmt)
end

"""
    av_read_image_line2(dst, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer, read_pal_component::Integer, dst_element_size::Integer)

Read a line from an image, and write the values of the pixel format component c to dst.

# Arguments
* `data`: the array containing the pointers to the planes of the image
* `linesize`: the array containing the linesizes of the image
* `desc`: the pixel format descriptor for the image
* `x`: the horizontal coordinate of the first pixel to read
* `y`: the vertical coordinate of the first pixel to read
* `w`: the width of the line to read, that is the number of values to write to dst
* `read_pal_component`: if not zero and the format is a paletted format writes the values corresponding to the palette component c in data[1] to dst, rather than the palette indexes in data[0]. The behavior is undefined if the format is not paletted.
* `dst_element_size`: size of elements in dst array (2 or 4 byte)
"""
function av_read_image_line2(dst, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer, read_pal_component::Integer, dst_element_size::Integer)
    ccall((:av_read_image_line2, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{AVPixFmtDescriptor}, Cint, Cint, Cint, Cint, Cint, Cint), dst, data, linesize, desc, x, y, c, w, read_pal_component, dst_element_size)
end

function av_read_image_line(dst, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer, read_pal_component::Integer)
    ccall((:av_read_image_line, libavutil), Cvoid, (Ptr{UInt16}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{AVPixFmtDescriptor}, Cint, Cint, Cint, Cint, Cint), dst, data, linesize, desc, x, y, c, w, read_pal_component)
end

"""
    av_write_image_line2(src, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer, src_element_size::Integer)

Write the values from src to the pixel format component c of an image line.

# Arguments
* `src`: array containing the values to write
* `data`: the array containing the pointers to the planes of the image to write into. It is supposed to be zeroed.
* `linesize`: the array containing the linesizes of the image
* `desc`: the pixel format descriptor for the image
* `x`: the horizontal coordinate of the first pixel to write
* `y`: the vertical coordinate of the first pixel to write
* `w`: the width of the line to write, that is the number of values to write to the image line
* `src_element_size`: size of elements in src array (2 or 4 byte)
"""
function av_write_image_line2(src, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer, src_element_size::Integer)
    ccall((:av_write_image_line2, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{AVPixFmtDescriptor}, Cint, Cint, Cint, Cint, Cint), src, data, linesize, desc, x, y, c, w, src_element_size)
end

function av_write_image_line(src, data, linesize, desc, x::Integer, y::Integer, c::Integer, w::Integer)
    ccall((:av_write_image_line, libavutil), Cvoid, (Ptr{UInt16}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{AVPixFmtDescriptor}, Cint, Cint, Cint, Cint), src, data, linesize, desc, x, y, c, w)
end

"""
    av_pix_fmt_swap_endianness(pix_fmt::AVPixelFormat)

Utility function to swap the endianness of a pixel format.

# Arguments
* `pix_fmt`:\\[in\\] the pixel format
# Returns
pixel format with swapped endianness if it exists, otherwise AV\\_PIX\\_FMT\\_NONE
"""
function av_pix_fmt_swap_endianness(pix_fmt::AVPixelFormat)
    ccall((:av_pix_fmt_swap_endianness, libavutil), AVPixelFormat, (AVPixelFormat,), pix_fmt)
end

"""
    av_get_pix_fmt_loss(dst_pix_fmt::AVPixelFormat, src_pix_fmt::AVPixelFormat, has_alpha::Integer)

Compute what kind of losses will occur when converting from one specific pixel format to another. When converting from one pixel format to another, information loss may occur. For example, when converting from RGB24 to GRAY, the color information will be lost. Similarly, other losses occur when converting from some formats to other formats. These losses can involve loss of chroma, but also loss of resolution, loss of color depth, loss due to the color space conversion, loss of the alpha bits or loss due to color quantization. av\\_get\\_fix\\_fmt\\_loss() informs you about the various types of losses which will occur when converting from one pixel format to another.

# Arguments
* `dst_pix_fmt`:\\[in\\] destination pixel format
* `src_pix_fmt`:\\[in\\] source pixel format
* `has_alpha`:\\[in\\] Whether the source pixel format alpha channel is used.
# Returns
Combination of flags informing you what kind of losses will occur (maximum loss for an invalid dst\\_pix\\_fmt).
"""
function av_get_pix_fmt_loss(dst_pix_fmt::AVPixelFormat, src_pix_fmt::AVPixelFormat, has_alpha::Integer)
    ccall((:av_get_pix_fmt_loss, libavutil), Cint, (AVPixelFormat, AVPixelFormat, Cint), dst_pix_fmt, src_pix_fmt, has_alpha)
end

"""
    av_find_best_pix_fmt_of_2(dst_pix_fmt1::AVPixelFormat, dst_pix_fmt2::AVPixelFormat, src_pix_fmt::AVPixelFormat, has_alpha::Integer, loss_ptr)

Compute what kind of losses will occur when converting from one specific pixel format to another. When converting from one pixel format to another, information loss may occur. For example, when converting from RGB24 to GRAY, the color information will be lost. Similarly, other losses occur when converting from some formats to other formats. These losses can involve loss of chroma, but also loss of resolution, loss of color depth, loss due to the color space conversion, loss of the alpha bits or loss due to color quantization. av\\_get\\_fix\\_fmt\\_loss() informs you about the various types of losses which will occur when converting from one pixel format to another.

# Arguments
* `dst_pix_fmt`:\\[in\\] destination pixel format
* `src_pix_fmt`:\\[in\\] source pixel format
* `has_alpha`:\\[in\\] Whether the source pixel format alpha channel is used.
# Returns
Combination of flags informing you what kind of losses will occur (maximum loss for an invalid dst\\_pix\\_fmt).
"""
function av_find_best_pix_fmt_of_2(dst_pix_fmt1::AVPixelFormat, dst_pix_fmt2::AVPixelFormat, src_pix_fmt::AVPixelFormat, has_alpha::Integer, loss_ptr)
    ccall((:av_find_best_pix_fmt_of_2, libavutil), AVPixelFormat, (AVPixelFormat, AVPixelFormat, AVPixelFormat, Cint, Ptr{Cint}), dst_pix_fmt1, dst_pix_fmt2, src_pix_fmt, has_alpha, loss_ptr)
end

# typedef int ( * av_pixelutils_sad_fn ) ( const uint8_t * src1 , ptrdiff_t stride1 , const uint8_t * src2 , ptrdiff_t stride2 )
"""
Sum of abs(src1[x] - src2[x])
"""
const av_pixelutils_sad_fn = Ptr{Cvoid}

"""
    av_pixelutils_get_sad_fn(w_bits::Integer, h_bits::Integer, aligned::Integer, log_ctx)

Get a potentially optimized pointer to a Sum-of-absolute-differences function (see the [`av_pixelutils_sad_fn`](@ref) prototype).

# Arguments
* `w_bits`: 1<<w\\_bits is the requested width of the block size
* `h_bits`: 1<<h\\_bits is the requested height of the block size
* `aligned`: If set to 2, the returned sad function will assume src1 and src2 addresses are aligned on the block size. If set to 1, the returned sad function will assume src1 is aligned on the block size. If set to 0, the returned sad function assume no particular alignment.
* `log_ctx`: context used for logging, can be NULL
# Returns
a pointer to the SAD function or NULL in case of error (because of invalid parameters)
"""
function av_pixelutils_get_sad_fn(w_bits::Integer, h_bits::Integer, aligned::Integer, log_ctx)
    ccall((:av_pixelutils_get_sad_fn, libavutil), av_pixelutils_sad_fn, (Cint, Cint, Cint, Ptr{Cvoid}), w_bits, h_bits, aligned, log_ctx)
end

"""
    av_get_random_seed()

Get a seed to use in conjunction with random functions. This function tries to provide a good seed at a best effort bases. Its possible to call this function multiple times if more bits are needed. It can be quite slow, which is why it should only be used as seed for a faster PRNG. The quality of the seed depends on the platform.
"""
function av_get_random_seed()
    ccall((:av_get_random_seed, libavutil), UInt32, ())
end

"""
    av_random_bytes(buf, len::Csize_t)

Generate cryptographically secure random data, i.e. suitable for use as encryption keys and similar.

\\retval0 success, len bytes of random data was written into buf

\\retval"a negative [`AVERROR`](@ref) code" random data could not be generated

# Arguments
* `buf`: buffer into which the random data will be written
* `len`: size of buf in bytes
"""
function av_random_bytes(buf, len::Csize_t)
    ccall((:av_random_bytes, libavutil), Cint, (Ptr{UInt8}, Csize_t), buf, len)
end

"""
    av_make_q(num::Integer, den::Integer)

Create an [`AVRational`](@ref).

Useful for compilers that do not support compound literals.

!!! note

    The return value is not reduced.

# See also
[`av_reduce`](@ref)()
"""
function av_make_q(num::Integer, den::Integer)
    ccall((:av_make_q, libavutil), AVRational, (Cint, Cint), num, den)
end

"""
    av_cmp_q(a::AVRational, b::AVRational)

Compare two rationals.

# Arguments
* `a`: First rational
* `b`: Second rational
# Returns
One of the following values: - 0 if `a == b` - 1 if `a > b` - -1 if `a < b` - `INT_MIN` if one of the values is of the form `0 / 0`
"""
function av_cmp_q(a::AVRational, b::AVRational)
    ccall((:av_cmp_q, libavutil), Cint, (AVRational, AVRational), a, b)
end

"""
    av_q2d(a::AVRational)

Convert an [`AVRational`](@ref) to a `double`.

# Arguments
* `a`: [`AVRational`](@ref) to convert
# Returns
`a` in floating-point form
# See also
[`av_d2q`](@ref)()
"""
function av_q2d(a::AVRational)
    ccall((:av_q2d, libavutil), Cdouble, (AVRational,), a)
end

"""
    av_reduce(dst_num, dst_den, num::Int64, den::Int64, max::Int64)

Reduce a fraction.

This is useful for framerate calculations.

# Arguments
* `dst_num`:\\[out\\] Destination numerator
* `dst_den`:\\[out\\] Destination denominator
* `num`:\\[in\\] Source numerator
* `den`:\\[in\\] Source denominator
* `max`:\\[in\\] Maximum allowed values for `dst_num` & `dst_den`
# Returns
1 if the operation is exact, 0 otherwise
"""
function av_reduce(dst_num, dst_den, num::Int64, den::Int64, max::Int64)
    ccall((:av_reduce, libavutil), Cint, (Ptr{Cint}, Ptr{Cint}, Int64, Int64, Int64), dst_num, dst_den, num, den, max)
end

"""
    av_mul_q(b::AVRational, c::AVRational)

Multiply two rationals.

# Arguments
* `b`: First rational
* `c`: Second rational
# Returns
b*c
"""
function av_mul_q(b::AVRational, c::AVRational)
    ccall((:av_mul_q, libavutil), AVRational, (AVRational, AVRational), b, c)
end

"""
    av_div_q(b::AVRational, c::AVRational)

Divide one rational by another.

# Arguments
* `b`: First rational
* `c`: Second rational
# Returns
b/c
"""
function av_div_q(b::AVRational, c::AVRational)
    ccall((:av_div_q, libavutil), AVRational, (AVRational, AVRational), b, c)
end

"""
    av_add_q(b::AVRational, c::AVRational)

Add two rationals.

# Arguments
* `b`: First rational
* `c`: Second rational
# Returns
b+c
"""
function av_add_q(b::AVRational, c::AVRational)
    ccall((:av_add_q, libavutil), AVRational, (AVRational, AVRational), b, c)
end

"""
    av_sub_q(b::AVRational, c::AVRational)

Subtract one rational from another.

# Arguments
* `b`: First rational
* `c`: Second rational
# Returns
b-c
"""
function av_sub_q(b::AVRational, c::AVRational)
    ccall((:av_sub_q, libavutil), AVRational, (AVRational, AVRational), b, c)
end

"""
    av_inv_q(q::AVRational)

Invert a rational.

# Arguments
* `q`: value
# Returns
1 / q
"""
function av_inv_q(q::AVRational)
    ccall((:av_inv_q, libavutil), AVRational, (AVRational,), q)
end

"""
    av_d2q(d::Cdouble, max::Integer)

Convert a double precision floating point number to a rational.

In case of infinity, the returned value is expressed as `{1, 0}` or `{-1, 0}` depending on the sign.

In general rational numbers with |num| <= 1<<26 && |den| <= 1<<26 can be recovered exactly from their double representation. (no exceptions were found within 1B random ones)

# Arguments
* `d`: `double` to convert
* `max`: Maximum allowed numerator and denominator
# Returns
`d` in [`AVRational`](@ref) form
# See also
[`av_q2d`](@ref)()
"""
function av_d2q(d::Cdouble, max::Integer)
    ccall((:av_d2q, libavutil), AVRational, (Cdouble, Cint), d, max)
end

"""
    av_nearer_q(q::AVRational, q1::AVRational, q2::AVRational)

Find which of the two rationals is closer to another rational.

# Arguments
* `q`: Rational to be compared against
* `q1`: Rational to be tested
* `q2`: Rational to be tested
# Returns
One of the following values: - 1 if `q1` is nearer to `q` than `q2` - -1 if `q2` is nearer to `q` than `q1` - 0 if they have the same distance
"""
function av_nearer_q(q::AVRational, q1::AVRational, q2::AVRational)
    ccall((:av_nearer_q, libavutil), Cint, (AVRational, AVRational, AVRational), q, q1, q2)
end

"""
    av_find_nearest_q_idx(q::AVRational, q_list)

Find the value in a list of rationals nearest a given reference rational.

# Arguments
* `q`: Reference rational
* `q_list`: Array of rationals terminated by `{0, 0}`
# Returns
Index of the nearest value found in the array
"""
function av_find_nearest_q_idx(q::AVRational, q_list)
    ccall((:av_find_nearest_q_idx, libavutil), Cint, (AVRational, Ptr{AVRational}), q, q_list)
end

"""
    av_q2intfloat(q::AVRational)

Convert an [`AVRational`](@ref) to a IEEE 32-bit `float` expressed in fixed-point format.

!!! note

    The returned value is platform-indepedant.

# Arguments
* `q`: Rational to be converted
# Returns
Equivalent floating-point value, expressed as an unsigned 32-bit integer.
"""
function av_q2intfloat(q::AVRational)
    ccall((:av_q2intfloat, libavutil), UInt32, (AVRational,), q)
end

"""
    av_gcd_q(a::AVRational, b::AVRational, max_den::Integer, def::AVRational)

Return the best rational so that a and b are multiple of it. If the resulting denominator is larger than max\\_den, return def.
"""
function av_gcd_q(a::AVRational, b::AVRational, max_den::Integer, def::AVRational)
    ccall((:av_gcd_q, libavutil), AVRational, (AVRational, AVRational, Cint, AVRational), a, b, max_den, def)
end

"""
    AVRC4

` lavu_rc4 RC4`

` lavu_crypto`

@{
"""
struct AVRC4
    state::NTuple{256, UInt8}
    x::Cint
    y::Cint
end

"""
    av_rc4_alloc()

Allocate an [`AVRC4`](@ref) context.
"""
function av_rc4_alloc()
    ccall((:av_rc4_alloc, libavutil), Ptr{AVRC4}, ())
end

"""
    av_rc4_init(d, key, key_bits::Integer, decrypt::Integer)

Initializes an [`AVRC4`](@ref) context.

# Arguments
* `d`: pointer to the [`AVRC4`](@ref) context
* `key`: buffer containing the key
* `key_bits`: must be a multiple of 8
* `decrypt`: 0 for encryption, 1 for decryption, currently has no effect
# Returns
zero on success, negative value otherwise
"""
function av_rc4_init(d, key, key_bits::Integer, decrypt::Integer)
    ccall((:av_rc4_init, libavutil), Cint, (Ptr{AVRC4}, Ptr{UInt8}, Cint, Cint), d, key, key_bits, decrypt)
end

"""
    av_rc4_crypt(d, dst, src, count::Integer, iv, decrypt::Integer)

Encrypts / decrypts using the RC4 algorithm.

# Arguments
* `d`: pointer to the [`AVRC4`](@ref) context
* `count`: number of bytes
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst, may be NULL
* `iv`: not (yet) used for RC4, should be NULL
* `decrypt`: 0 for encryption, 1 for decryption, not (yet) used
"""
function av_rc4_crypt(d, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_rc4_crypt, libavutil), Cvoid, (Ptr{AVRC4}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), d, dst, src, count, iv, decrypt)
end

"""
    AVRefStructOpaque

This union is used for all opaque parameters in this API to spare the user to cast const away in case the opaque to use is const-qualified.

The functions provided by this API with an [`AVRefStructOpaque`](@ref) come in pairs named foo\\_c and foo. The foo function accepts void* as opaque and is just a wrapper around the foo\\_c function; "\\_c" means "(potentially) const".
"""
struct AVRefStructOpaque
    data::NTuple{8, UInt8}
end

function Base.getproperty(x::Ptr{AVRefStructOpaque}, f::Symbol)
    f === :nc && return Ptr{Ptr{Cvoid}}(x + 0)
    f === :c && return Ptr{Ptr{Cvoid}}(x + 0)
    return getfield(x, f)
end

function Base.getproperty(x::AVRefStructOpaque, f::Symbol)
    r = Ref{AVRefStructOpaque}(x)
    ptr = Base.unsafe_convert(Ptr{AVRefStructOpaque}, r)
    fptr = getproperty(ptr, f)
    GC.@preserve r unsafe_load(fptr)
end

function Base.setproperty!(x::Ptr{AVRefStructOpaque}, f::Symbol, v)
    unsafe_store!(getproperty(x, f), v)
end

function Base.propertynames(x::AVRefStructOpaque, private::Bool = false)
    (:nc, :c, if private
            fieldnames(typeof(x))
        else
            ()
        end...)
end

"""
    av_refstruct_alloc_ext_c(size::Csize_t, flags::Integer, opaque::AVRefStructOpaque, free_cb)

Allocate a refcounted object of usable size `size` managed via the RefStruct API.

By default (in the absence of flags to the contrary), the returned object is initially zeroed.

# Arguments
* `size`: Desired usable size of the returned object.
* `flags`: A bitwise combination of AV\\_REFSTRUCT\\_FLAG\\_* flags.
* `opaque`: A pointer that will be passed to the free\\_cb callback.
* `free_cb`: A callback for freeing this object's content when its reference count reaches zero; it must not free the object itself.
# Returns
A pointer to an object of the desired size or NULL on failure.
"""
function av_refstruct_alloc_ext_c(size::Csize_t, flags::Integer, opaque::AVRefStructOpaque, free_cb)
    ccall((:av_refstruct_alloc_ext_c, libavutil), Ptr{Cvoid}, (Csize_t, Cuint, AVRefStructOpaque, Ptr{Cvoid}), size, flags, opaque, free_cb)
end

"""
    av_refstruct_alloc_ext(size::Csize_t, flags::Integer, opaque, free_cb)

A wrapper around [`av_refstruct_alloc_ext_c`](@ref)() for the common case of a non-const qualified opaque.

# See also
[`av_refstruct_alloc_ext_c`](@ref)()
"""
function av_refstruct_alloc_ext(size::Csize_t, flags::Integer, opaque, free_cb)
    ccall((:av_refstruct_alloc_ext, libavutil), Ptr{Cvoid}, (Csize_t, Cuint, Ptr{Cvoid}, Ptr{Cvoid}), size, flags, opaque, free_cb)
end

"""
    av_refstruct_allocz(size::Csize_t)

Equivalent to [`av_refstruct_alloc_ext`](@ref)(size, 0, NULL, NULL)
"""
function av_refstruct_allocz(size::Csize_t)
    ccall((:av_refstruct_allocz, libavutil), Ptr{Cvoid}, (Csize_t,), size)
end

"""
    av_refstruct_unref(objp)

Decrement the reference count of the underlying object and automatically free the object if there are no more references to it.

`*objp == NULL` is legal and a no-op.

# Arguments
* `objp`: Pointer to a pointer that is either NULL or points to an object managed via this API. `*objp` is set to NULL on return.
"""
function av_refstruct_unref(objp)
    ccall((:av_refstruct_unref, libavutil), Cvoid, (Ptr{Cvoid},), objp)
end

"""
    av_refstruct_ref(obj)

Create a new reference to an object managed via this API, i.e. increment the reference count of the underlying object and return obj.

# Returns
a pointer equal to obj.
"""
function av_refstruct_ref(obj)
    ccall((:av_refstruct_ref, libavutil), Ptr{Cvoid}, (Ptr{Cvoid},), obj)
end

"""
    av_refstruct_ref_c(obj)

Analog of [`av_refstruct_ref`](@ref)(), but for constant objects.

# See also
[`av_refstruct_ref`](@ref)()
"""
function av_refstruct_ref_c(obj)
    ccall((:av_refstruct_ref_c, libavutil), Ptr{Cvoid}, (Ptr{Cvoid},), obj)
end

"""
    av_refstruct_replace(dstp, src)

Ensure `*dstp` refers to the same object as src.

If `*dstp` is already equal to src, do nothing. Otherwise unreference `*dstp` and replace it with a new reference to src in case `src != NULL` (this involves incrementing the reference count of src's underlying object) or with NULL otherwise.

# Arguments
* `dstp`: Pointer to a pointer that is either NULL or points to an object managed via this API.
* `src`: A pointer to an object managed via this API or NULL.
"""
function av_refstruct_replace(dstp, src)
    ccall((:av_refstruct_replace, libavutil), Cvoid, (Ptr{Cvoid}, Ptr{Cvoid}), dstp, src)
end

"""
    av_refstruct_exclusive(obj)

Check whether the reference count of an object managed via this API is 1.

# Arguments
* `obj`: A pointer to an object managed via this API.
# Returns
1 if the reference count of obj is 1; 0 otherwise.
"""
function av_refstruct_exclusive(obj)
    ccall((:av_refstruct_exclusive, libavutil), Cint, (Ptr{Cvoid},), obj)
end

mutable struct AVRefStructPool end

"""
    av_refstruct_pool_alloc(size::Csize_t, flags::Integer)

Equivalent to [`av_refstruct_pool_alloc`](@ref)(size, flags, NULL, NULL, NULL, NULL, NULL)
"""
function av_refstruct_pool_alloc(size::Csize_t, flags::Integer)
    ccall((:av_refstruct_pool_alloc, libavutil), Ptr{AVRefStructPool}, (Csize_t, Cuint), size, flags)
end

"""
    av_refstruct_pool_alloc_ext_c(size::Csize_t, flags::Integer, opaque::AVRefStructOpaque, init_cb, reset_cb, free_entry_cb, free_cb)

Allocate an [`AVRefStructPool`](@ref), potentially using complex callbacks.

# Arguments
* `size`: size of the entries of the pool
* `flags`: a bitwise combination of AV\\_REFSTRUCT\\_POOL\\_FLAG\\_* flags
* `opaque`: A pointer that will be passed to the callbacks below.
* `init`: A callback that will be called directly after a new entry has been allocated. obj has already been zeroed unless the [`AV_REFSTRUCT_POOL_FLAG_NO_ZEROING`](@ref) flag is in use.
* `reset`: A callback that will be called after an entry has been returned to the pool and before it is reused.
* `free_entry`: A callback that will be called when an entry is freed after the pool has been marked as to be uninitialized.
* `free`: A callback that will be called when the pool itself is freed (after the last entry has been returned and freed).
"""
function av_refstruct_pool_alloc_ext_c(size::Csize_t, flags::Integer, opaque::AVRefStructOpaque, init_cb, reset_cb, free_entry_cb, free_cb)
    ccall((:av_refstruct_pool_alloc_ext_c, libavutil), Ptr{AVRefStructPool}, (Csize_t, Cuint, AVRefStructOpaque, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}), size, flags, opaque, init_cb, reset_cb, free_entry_cb, free_cb)
end

"""
    av_refstruct_pool_alloc_ext(size::Csize_t, flags::Integer, opaque, init_cb, reset_cb, free_entry_cb, free_cb)

A wrapper around [`av_refstruct_pool_alloc_ext_c`](@ref)() for the common case of a non-const qualified opaque.

# See also
[`av_refstruct_pool_alloc_ext_c`](@ref)()
"""
function av_refstruct_pool_alloc_ext(size::Csize_t, flags::Integer, opaque, init_cb, reset_cb, free_entry_cb, free_cb)
    ccall((:av_refstruct_pool_alloc_ext, libavutil), Ptr{AVRefStructPool}, (Csize_t, Cuint, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}), size, flags, opaque, init_cb, reset_cb, free_entry_cb, free_cb)
end

"""
    av_refstruct_pool_get(pool)

Get an object from the pool, reusing an old one from the pool when available.

Every call to this function must happen before [`av_refstruct_pool_uninit`](@ref)(). Otherwise undefined behaviour may occur.

# Arguments
* `pool`: the pool from which to get the object
# Returns
a reference to the object on success, NULL on error.
"""
function av_refstruct_pool_get(pool)
    ccall((:av_refstruct_pool_get, libavutil), Ptr{Cvoid}, (Ptr{AVRefStructPool},), pool)
end

"""
    av_refstruct_pool_uninit(poolp)

Mark the pool as being available for freeing. It will actually be freed only once all the allocated buffers associated with the pool are released. Thus it is safe to call this function while some of the allocated buffers are still in use.

It is illegal to try to get a new entry after this function has been called.

# Arguments
* `poolp`: pointer to a pointer to either NULL or a pool to be freed. `*poolp` will be set to NULL.
"""
function av_refstruct_pool_uninit(poolp)
    ccall((:av_refstruct_pool_uninit, libavutil), Cvoid, (Ptr{Ptr{AVRefStructPool}},), poolp)
end

"""
    AVReplayGain

ReplayGain information (see http://wiki.hydrogenaudio.org/index.php?title=ReplayGain\\_1.0\\_specification). The size of this struct is a part of the public ABI.
"""
struct AVReplayGain
    track_gain::Int32
    track_peak::UInt32
    album_gain::Int32
    album_peak::UInt32
end

mutable struct AVRIPEMD end

"""
    av_ripemd_alloc()

Allocate an [`AVRIPEMD`](@ref) context.
"""
function av_ripemd_alloc()
    ccall((:av_ripemd_alloc, libavutil), Ptr{AVRIPEMD}, ())
end

"""
    av_ripemd_init(context, bits::Integer)

Initialize RIPEMD hashing.

# Arguments
* `context`: pointer to the function context (of size av\\_ripemd\\_size)
* `bits`: number of bits in digest (128, 160, 256 or 320 bits)
# Returns
zero if initialization succeeded, -1 otherwise
"""
function av_ripemd_init(context, bits::Integer)
    ccall((:av_ripemd_init, libavutil), Cint, (Ptr{AVRIPEMD}, Cint), context, bits)
end

"""
    av_ripemd_update(context, data, len::Csize_t)

Update hash value.

# Arguments
* `context`: hash function context
* `data`: input data to update hash with
* `len`: input data length
"""
function av_ripemd_update(context, data, len::Csize_t)
    ccall((:av_ripemd_update, libavutil), Cvoid, (Ptr{AVRIPEMD}, Ptr{UInt8}, Csize_t), context, data, len)
end

"""
    av_ripemd_final(context, digest)

Finish hashing and output digest value.

# Arguments
* `context`: hash function context
* `digest`: buffer where output digest value is stored
"""
function av_ripemd_final(context, digest)
    ccall((:av_ripemd_final, libavutil), Cvoid, (Ptr{AVRIPEMD}, Ptr{UInt8}), context, digest)
end

"""
    av_get_sample_fmt_name(sample_fmt::AVSampleFormat)

Return the name of sample\\_fmt, or NULL if sample\\_fmt is not recognized.
"""
function av_get_sample_fmt_name(sample_fmt::AVSampleFormat)
    ccall((:av_get_sample_fmt_name, libavutil), Cstring, (AVSampleFormat,), sample_fmt)
end

"""
    av_get_sample_fmt(name)

Return a sample format corresponding to name, or AV\\_SAMPLE\\_FMT\\_NONE on error.
"""
function av_get_sample_fmt(name)
    ccall((:av_get_sample_fmt, libavutil), AVSampleFormat, (Cstring,), name)
end

"""
    av_get_alt_sample_fmt(sample_fmt::AVSampleFormat, planar::Integer)

Return the planar<->packed alternative form of the given sample format, or AV\\_SAMPLE\\_FMT\\_NONE on error. If the passed sample\\_fmt is already in the requested planar/packed format, the format returned is the same as the input.
"""
function av_get_alt_sample_fmt(sample_fmt::AVSampleFormat, planar::Integer)
    ccall((:av_get_alt_sample_fmt, libavutil), AVSampleFormat, (AVSampleFormat, Cint), sample_fmt, planar)
end

"""
    av_get_packed_sample_fmt(sample_fmt::AVSampleFormat)

Get the packed alternative form of the given sample format.

If the passed sample\\_fmt is already in packed format, the format returned is the same as the input.

# Returns
the packed alternative form of the given sample format or AV\\_SAMPLE\\_FMT\\_NONE on error.
"""
function av_get_packed_sample_fmt(sample_fmt::AVSampleFormat)
    ccall((:av_get_packed_sample_fmt, libavutil), AVSampleFormat, (AVSampleFormat,), sample_fmt)
end

"""
    av_get_planar_sample_fmt(sample_fmt::AVSampleFormat)

Get the planar alternative form of the given sample format.

If the passed sample\\_fmt is already in planar format, the format returned is the same as the input.

# Returns
the planar alternative form of the given sample format or AV\\_SAMPLE\\_FMT\\_NONE on error.
"""
function av_get_planar_sample_fmt(sample_fmt::AVSampleFormat)
    ccall((:av_get_planar_sample_fmt, libavutil), AVSampleFormat, (AVSampleFormat,), sample_fmt)
end

"""
    av_get_sample_fmt_string(buf, buf_size::Integer, sample_fmt::AVSampleFormat)

Generate a string corresponding to the sample format with sample\\_fmt, or a header if sample\\_fmt is negative.

# Arguments
* `buf`: the buffer where to write the string
* `buf_size`: the size of buf
* `sample_fmt`: the number of the sample format to print the corresponding info string, or a negative value to print the corresponding header.
# Returns
the pointer to the filled buffer or NULL if sample\\_fmt is unknown or in case of other errors
"""
function av_get_sample_fmt_string(buf, buf_size::Integer, sample_fmt::AVSampleFormat)
    ccall((:av_get_sample_fmt_string, libavutil), Cstring, (Cstring, Cint, AVSampleFormat), buf, buf_size, sample_fmt)
end

"""
    av_get_bytes_per_sample(sample_fmt::AVSampleFormat)

Return number of bytes per sample.

# Arguments
* `sample_fmt`: the sample format
# Returns
number of bytes per sample or zero if unknown for the given sample format
"""
function av_get_bytes_per_sample(sample_fmt::AVSampleFormat)
    ccall((:av_get_bytes_per_sample, libavutil), Cint, (AVSampleFormat,), sample_fmt)
end

"""
    av_sample_fmt_is_planar(sample_fmt::AVSampleFormat)

Check if the sample format is planar.

# Arguments
* `sample_fmt`: the sample format to inspect
# Returns
1 if the sample format is planar, 0 if it is interleaved
"""
function av_sample_fmt_is_planar(sample_fmt::AVSampleFormat)
    ccall((:av_sample_fmt_is_planar, libavutil), Cint, (AVSampleFormat,), sample_fmt)
end

"""
    av_samples_get_buffer_size(linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)

Get the required buffer size for the given audio parameters.

# Arguments
* `linesize`:\\[out\\] calculated linesize, may be NULL
* `nb_channels`: the number of channels
* `nb_samples`: the number of samples in a single channel
* `sample_fmt`: the sample format
* `align`: buffer size alignment (0 = default, 1 = no alignment)
# Returns
required buffer size, or negative error code on failure
"""
function av_samples_get_buffer_size(linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)
    ccall((:av_samples_get_buffer_size, libavutil), Cint, (Ptr{Cint}, Cint, Cint, AVSampleFormat, Cint), linesize, nb_channels, nb_samples, sample_fmt, align)
end

"""
    av_samples_fill_arrays(audio_data, linesize, buf, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)

Fill plane data pointers and linesize for samples with sample format sample\\_fmt.

The audio\\_data array is filled with the pointers to the samples data planes: for planar, set the start point of each channel's data within the buffer, for packed, set the start point of the entire buffer only.

The value pointed to by linesize is set to the aligned size of each channel's data buffer for planar layout, or to the aligned size of the buffer for all channels for packed layout.

The buffer in buf must be big enough to contain all the samples (use [`av_samples_get_buffer_size`](@ref)() to compute its minimum size), otherwise the audio\\_data pointers will point to invalid data.

# Arguments
* `audio_data`:\\[out\\] array to be filled with the pointer for each channel
* `linesize`:\\[out\\] calculated linesize, may be NULL
* `buf`: the pointer to a buffer containing the samples
* `nb_channels`: the number of channels
* `nb_samples`: the number of samples in a single channel
* `sample_fmt`: the sample format
* `align`: buffer size alignment (0 = default, 1 = no alignment)
# Returns
minimum size in bytes required for the buffer on success, or a negative error code on failure
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout.
"""
function av_samples_fill_arrays(audio_data, linesize, buf, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)
    ccall((:av_samples_fill_arrays, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Ptr{UInt8}, Cint, Cint, AVSampleFormat, Cint), audio_data, linesize, buf, nb_channels, nb_samples, sample_fmt, align)
end

"""
    av_samples_alloc(audio_data, linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)

Allocate a samples buffer for nb\\_samples samples, and fill data pointers and linesize accordingly. The allocated samples buffer can be freed by using [`av_freep`](@ref)(&audio\\_data[0]) Allocated data will be initialized to silence.

\\todo return the size of the allocated buffer in case of success at the next bump

# Arguments
* `audio_data`:\\[out\\] array to be filled with the pointer for each channel
* `linesize`:\\[out\\] aligned size for audio buffer(s), may be NULL
* `nb_channels`: number of audio channels
* `nb_samples`: number of samples per channel
* `sample_fmt`: the sample format
* `align`: buffer size alignment (0 = default, 1 = no alignment)
# Returns
>=0 on success or a negative error code on failure
# See also
enum [`AVSampleFormat`](@ref) The documentation for [`AVSampleFormat`](@ref) describes the data layout., [`av_samples_fill_arrays`](@ref)(), [`av_samples_alloc_array_and_samples`](@ref)()
"""
function av_samples_alloc(audio_data, linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)
    ccall((:av_samples_alloc, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Cint}, Cint, Cint, AVSampleFormat, Cint), audio_data, linesize, nb_channels, nb_samples, sample_fmt, align)
end

"""
    av_samples_alloc_array_and_samples(audio_data, linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)

Allocate a data pointers array, samples buffer for nb\\_samples samples, and fill data pointers and linesize accordingly.

This is the same as [`av_samples_alloc`](@ref)(), but also allocates the data pointers array.

# See also
[`av_samples_alloc`](@ref)()
"""
function av_samples_alloc_array_and_samples(audio_data, linesize, nb_channels::Integer, nb_samples::Integer, sample_fmt::AVSampleFormat, align::Integer)
    ccall((:av_samples_alloc_array_and_samples, libavutil), Cint, (Ptr{Ptr{Ptr{UInt8}}}, Ptr{Cint}, Cint, Cint, AVSampleFormat, Cint), audio_data, linesize, nb_channels, nb_samples, sample_fmt, align)
end

"""
    av_samples_copy(dst, src, dst_offset::Integer, src_offset::Integer, nb_samples::Integer, nb_channels::Integer, sample_fmt::AVSampleFormat)

Copy samples from src to dst.

# Arguments
* `dst`: destination array of pointers to data planes
* `src`: source array of pointers to data planes
* `dst_offset`: offset in samples at which the data will be written to dst
* `src_offset`: offset in samples at which the data will be read from src
* `nb_samples`: number of samples to be copied
* `nb_channels`: number of audio channels
* `sample_fmt`: audio sample format
"""
function av_samples_copy(dst, src, dst_offset::Integer, src_offset::Integer, nb_samples::Integer, nb_channels::Integer, sample_fmt::AVSampleFormat)
    ccall((:av_samples_copy, libavutil), Cint, (Ptr{Ptr{UInt8}}, Ptr{Ptr{UInt8}}, Cint, Cint, Cint, Cint, AVSampleFormat), dst, src, dst_offset, src_offset, nb_samples, nb_channels, sample_fmt)
end

"""
    av_samples_set_silence(audio_data, offset::Integer, nb_samples::Integer, nb_channels::Integer, sample_fmt::AVSampleFormat)

Fill an audio buffer with silence.

# Arguments
* `audio_data`: array of pointers to data planes
* `offset`: offset in samples at which to start filling
* `nb_samples`: number of samples to fill
* `nb_channels`: number of audio channels
* `sample_fmt`: audio sample format
"""
function av_samples_set_silence(audio_data, offset::Integer, nb_samples::Integer, nb_channels::Integer, sample_fmt::AVSampleFormat)
    ccall((:av_samples_set_silence, libavutil), Cint, (Ptr{Ptr{UInt8}}, Cint, Cint, Cint, AVSampleFormat), audio_data, offset, nb_samples, nb_channels, sample_fmt)
end

mutable struct AVSHA end

"""
    av_sha_alloc()

Allocate an [`AVSHA`](@ref) context.
"""
function av_sha_alloc()
    ccall((:av_sha_alloc, libavutil), Ptr{AVSHA}, ())
end

"""
    av_sha_init(context, bits::Integer)

Initialize SHA-1 or SHA-2 hashing.

# Arguments
* `context`: pointer to the function context (of size av\\_sha\\_size)
* `bits`: number of bits in digest (SHA-1 - 160 bits, SHA-2 224 or 256 bits)
# Returns
zero if initialization succeeded, -1 otherwise
"""
function av_sha_init(context, bits::Integer)
    ccall((:av_sha_init, libavutil), Cint, (Ptr{AVSHA}, Cint), context, bits)
end

"""
    av_sha_update(ctx, data, len::Csize_t)

Update hash value.

# Arguments
* `ctx`: hash function context
* `data`: input data to update hash with
* `len`: input data length
"""
function av_sha_update(ctx, data, len::Csize_t)
    ccall((:av_sha_update, libavutil), Cvoid, (Ptr{AVSHA}, Ptr{UInt8}, Csize_t), ctx, data, len)
end

"""
    av_sha_final(context, digest)

Finish hashing and output digest value.

# Arguments
* `context`: hash function context
* `digest`: buffer where output digest value is stored
"""
function av_sha_final(context, digest)
    ccall((:av_sha_final, libavutil), Cvoid, (Ptr{AVSHA}, Ptr{UInt8}), context, digest)
end

mutable struct AVSHA512 end

"""
    av_sha512_alloc()

Allocate an [`AVSHA512`](@ref) context.
"""
function av_sha512_alloc()
    ccall((:av_sha512_alloc, libavutil), Ptr{AVSHA512}, ())
end

"""
    av_sha512_init(context, bits::Integer)

Initialize SHA-2 512 hashing.

# Arguments
* `context`: pointer to the function context (of size av\\_sha512\\_size)
* `bits`: number of bits in digest (224, 256, 384 or 512 bits)
# Returns
zero if initialization succeeded, -1 otherwise
"""
function av_sha512_init(context, bits::Integer)
    ccall((:av_sha512_init, libavutil), Cint, (Ptr{AVSHA512}, Cint), context, bits)
end

"""
    av_sha512_update(context, data, len::Csize_t)

Update hash value.

# Arguments
* `context`: hash function context
* `data`: input data to update hash with
* `len`: input data length
"""
function av_sha512_update(context, data, len::Csize_t)
    ccall((:av_sha512_update, libavutil), Cvoid, (Ptr{AVSHA512}, Ptr{UInt8}, Csize_t), context, data, len)
end

"""
    av_sha512_final(context, digest)

Finish hashing and output digest value.

# Arguments
* `context`: hash function context
* `digest`: buffer where output digest value is stored
"""
function av_sha512_final(context, digest)
    ccall((:av_sha512_final, libavutil), Cvoid, (Ptr{AVSHA512}, Ptr{UInt8}), context, digest)
end

"""
    AVSphericalProjection

Projection of the video surface(s) on a sphere.
"""
const AVSphericalProjection = UInt32
const AV_SPHERICAL_EQUIRECTANGULAR = 0 % UInt32
const AV_SPHERICAL_CUBEMAP = 1 % UInt32
const AV_SPHERICAL_EQUIRECTANGULAR_TILE = 2 % UInt32
const AV_SPHERICAL_HALF_EQUIRECTANGULAR = 3 % UInt32
const AV_SPHERICAL_RECTILINEAR = 4 % UInt32
const AV_SPHERICAL_FISHEYE = 5 % UInt32
const AV_SPHERICAL_PARAMETRIC_IMMERSIVE = 6 % UInt32

"""
    AVSphericalMapping

This structure describes how to handle spherical videos, outlining information about projection, initial layout, and any other view modifier.

!!! note

    The struct must be allocated with [`av_spherical_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVSphericalMapping
    projection::AVSphericalProjection
    yaw::Int32
    pitch::Int32
    roll::Int32
    bound_left::UInt32
    bound_top::UInt32
    bound_right::UInt32
    bound_bottom::UInt32
    padding::UInt32
end

"""
    av_spherical_alloc(size)

Allocate a AVSphericalVideo structure and initialize its fields to default values.

# Returns
the newly allocated struct or NULL on failure
"""
function av_spherical_alloc(size)
    ccall((:av_spherical_alloc, libavutil), Ptr{AVSphericalMapping}, (Ptr{Csize_t},), size)
end

"""
    av_spherical_tile_bounds(map, width::Csize_t, height::Csize_t, left, top, right, bottom)

Convert the bounding fields from an AVSphericalVideo from 0.32 fixed point to pixels.

# Arguments
* `map`: The AVSphericalVideo map to read bound values from.
* `width`: Width of the current frame or stream.
* `height`: Height of the current frame or stream.
* `left`: Pixels from the left edge.
* `top`: Pixels from the top edge.
* `right`: Pixels from the right edge.
* `bottom`: Pixels from the bottom edge.
"""
function av_spherical_tile_bounds(map, width::Csize_t, height::Csize_t, left, top, right, bottom)
    ccall((:av_spherical_tile_bounds, libavutil), Cvoid, (Ptr{AVSphericalMapping}, Csize_t, Csize_t, Ptr{Csize_t}, Ptr{Csize_t}, Ptr{Csize_t}, Ptr{Csize_t}), map, width, height, left, top, right, bottom)
end

"""
    av_spherical_projection_name(projection::AVSphericalProjection)

Provide a human-readable name of a given [`AVSphericalProjection`](@ref).

# Arguments
* `projection`: The input [`AVSphericalProjection`](@ref).
# Returns
The name of the [`AVSphericalProjection`](@ref), or "unknown".
"""
function av_spherical_projection_name(projection::AVSphericalProjection)
    ccall((:av_spherical_projection_name, libavutil), Cstring, (AVSphericalProjection,), projection)
end

"""
    av_spherical_from_name(name)

Get the [`AVSphericalProjection`](@ref) form a human-readable name.

# Arguments
* `name`: The input string.
# Returns
The [`AVSphericalProjection`](@ref) value, or -1 if not found.
"""
function av_spherical_from_name(name)
    ccall((:av_spherical_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    AVStereo3DType

List of possible 3D Types
"""
const AVStereo3DType = UInt32
const AV_STEREO3D_2D = 0 % UInt32
const AV_STEREO3D_SIDEBYSIDE = 1 % UInt32
const AV_STEREO3D_TOPBOTTOM = 2 % UInt32
const AV_STEREO3D_FRAMESEQUENCE = 3 % UInt32
const AV_STEREO3D_CHECKERBOARD = 4 % UInt32
const AV_STEREO3D_SIDEBYSIDE_QUINCUNX = 5 % UInt32
const AV_STEREO3D_LINES = 6 % UInt32
const AV_STEREO3D_COLUMNS = 7 % UInt32
const AV_STEREO3D_UNSPEC = 8 % UInt32

"""
    AVStereo3DView

List of possible view types.
"""
const AVStereo3DView = UInt32
const AV_STEREO3D_VIEW_PACKED = 0 % UInt32
const AV_STEREO3D_VIEW_LEFT = 1 % UInt32
const AV_STEREO3D_VIEW_RIGHT = 2 % UInt32
const AV_STEREO3D_VIEW_UNSPEC = 3 % UInt32

"""
    AVStereo3DPrimaryEye

List of possible primary eyes.
"""
const AVStereo3DPrimaryEye = UInt32
const AV_PRIMARY_EYE_NONE = 0 % UInt32
const AV_PRIMARY_EYE_LEFT = 1 % UInt32
const AV_PRIMARY_EYE_RIGHT = 2 % UInt32

"""
    AVStereo3D

Stereo 3D type: this structure describes how two videos are packed within a single video surface, with additional information as needed.

!!! note

    The struct must be allocated with [`av_stereo3d_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AVStereo3D
    type::AVStereo3DType
    flags::Cint
    view::AVStereo3DView
    primary_eye::AVStereo3DPrimaryEye
    baseline::UInt32
    horizontal_disparity_adjustment::AVRational
    horizontal_field_of_view::AVRational
end

"""
    av_stereo3d_alloc()

Allocate an [`AVStereo3D`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVStereo3D`](@ref) filled with default values or NULL on failure.
"""
function av_stereo3d_alloc()
    ccall((:av_stereo3d_alloc, libavutil), Ptr{AVStereo3D}, ())
end

"""
    av_stereo3d_alloc_size(size)

Allocate an [`AVStereo3D`](@ref) structure and set its fields to default values. The resulting struct can be freed using [`av_freep`](@ref)().

# Returns
An [`AVStereo3D`](@ref) filled with default values or NULL on failure.
"""
function av_stereo3d_alloc_size(size)
    ccall((:av_stereo3d_alloc_size, libavutil), Ptr{AVStereo3D}, (Ptr{Csize_t},), size)
end

"""
    av_stereo3d_create_side_data(frame)

Allocate a complete [`AVFrameSideData`](@ref) and add it to the frame.

# Arguments
* `frame`: The frame which side data is added to.
# Returns
The [`AVStereo3D`](@ref) structure to be filled by caller.
"""
function av_stereo3d_create_side_data(frame)
    ccall((:av_stereo3d_create_side_data, libavutil), Ptr{AVStereo3D}, (Ptr{AVFrame},), frame)
end

"""
    av_stereo3d_type_name(type::Integer)

Provide a human-readable name of a given stereo3d type.

# Arguments
* `type`: The input stereo3d type value.
# Returns
The name of the stereo3d value, or "unknown".
"""
function av_stereo3d_type_name(type::Integer)
    ccall((:av_stereo3d_type_name, libavutil), Cstring, (Cuint,), type)
end

"""
    av_stereo3d_from_name(name)

Get the [`AVStereo3DType`](@ref) form a human-readable name.

# Arguments
* `name`: The input string.
# Returns
The [`AVStereo3DType`](@ref) value, or -1 if not found.
"""
function av_stereo3d_from_name(name)
    ccall((:av_stereo3d_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_stereo3d_view_name(view::Integer)

Provide a human-readable name of a given stereo3d view.

# Arguments
* `type`: The input stereo3d view value.
# Returns
The name of the stereo3d view value, or "unknown".
"""
function av_stereo3d_view_name(view::Integer)
    ccall((:av_stereo3d_view_name, libavutil), Cstring, (Cuint,), view)
end

"""
    av_stereo3d_view_from_name(name)

Get the [`AVStereo3DView`](@ref) form a human-readable name.

# Arguments
* `name`: The input string.
# Returns
The [`AVStereo3DView`](@ref) value, or -1 if not found.
"""
function av_stereo3d_view_from_name(name)
    ccall((:av_stereo3d_view_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    av_stereo3d_primary_eye_name(eye::Integer)

Provide a human-readable name of a given stereo3d primary eye.

# Arguments
* `type`: The input stereo3d primary eye value.
# Returns
The name of the stereo3d primary eye value, or "unknown".
"""
function av_stereo3d_primary_eye_name(eye::Integer)
    ccall((:av_stereo3d_primary_eye_name, libavutil), Cstring, (Cuint,), eye)
end

"""
    av_stereo3d_primary_eye_from_name(name)

Get the [`AVStereo3DPrimaryEye`](@ref) form a human-readable name.

# Arguments
* `name`: The input string.
# Returns
The [`AVStereo3DPrimaryEye`](@ref) value, or -1 if not found.
"""
function av_stereo3d_primary_eye_from_name(name)
    ccall((:av_stereo3d_primary_eye_from_name, libavutil), Cint, (Cstring,), name)
end

"""
    AV3DReferenceDisplaysInfo

This structure describes information about the reference display width(s) and reference viewing distance(s) as well as information about the corresponding reference stereo pair(s). See section G.14.3.2.3 of ITU-T H.265 for more information.

!!! note

    The struct must be allocated with [`av_tdrdi_alloc`](@ref)() and its size is not a part of the public ABI.
"""
struct AV3DReferenceDisplaysInfo
    prec_ref_display_width::UInt8
    ref_viewing_distance_flag::UInt8
    prec_ref_viewing_dist::UInt8
    num_ref_displays::UInt8
    entries_offset::Csize_t
    entry_size::Csize_t
end

"""
    AV3DReferenceDisplay

Data structure for single deference display information. It is allocated as a part of [`AV3DReferenceDisplaysInfo`](@ref) and should be retrieved with [`av_tdrdi_get_display`](@ref)().

sizeof([`AV3DReferenceDisplay`](@ref)) is not a part of the ABI and new fields may be added to it.
"""
struct AV3DReferenceDisplay
    left_view_id::UInt16
    right_view_id::UInt16
    exponent_ref_display_width::UInt8
    mantissa_ref_display_width::UInt8
    exponent_ref_viewing_distance::UInt8
    mantissa_ref_viewing_distance::UInt8
    additional_shift_present_flag::UInt8
    num_sample_shift::Int16
end

function av_tdrdi_get_display(tdrdi, idx::Integer)
    ccall((:av_tdrdi_get_display, libavutil), Ptr{AV3DReferenceDisplay}, (Ptr{AV3DReferenceDisplaysInfo}, Cuint), tdrdi, idx)
end

"""
    av_tdrdi_alloc(nb_displays::Integer, size)

Allocate a [`AV3DReferenceDisplaysInfo`](@ref) structure and initialize its fields to default values.

# Returns
the newly allocated struct or NULL on failure
"""
function av_tdrdi_alloc(nb_displays::Integer, size)
    ccall((:av_tdrdi_alloc, libavutil), Ptr{AV3DReferenceDisplaysInfo}, (Cuint, Ptr{Csize_t}), nb_displays, size)
end

mutable struct AVTEA end

"""
    av_tea_alloc()

Allocate an [`AVTEA`](@ref) context To free the struct: [`av_free`](@ref)(ptr)
"""
function av_tea_alloc()
    ccall((:av_tea_alloc, libavutil), Ptr{AVTEA}, ())
end

"""
    av_tea_init(ctx, key, rounds::Integer)

Initialize an [`AVTEA`](@ref) context.

# Arguments
* `ctx`: an [`AVTEA`](@ref) context
* `key`: a key of 16 bytes used for encryption/decryption
* `rounds`: the number of rounds in TEA (64 is the "standard")
"""
function av_tea_init(ctx, key, rounds::Integer)
    ccall((:av_tea_init, libavutil), Cvoid, (Ptr{AVTEA}, Ptr{UInt8}, Cint), ctx, key, rounds)
end

"""
    av_tea_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context.

# Arguments
* `ctx`: an [`AVTEA`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, if NULL then ECB will be used
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_tea_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_tea_crypt, libavutil), Cvoid, (Ptr{AVTEA}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

mutable struct AVThreadMessageQueue end

const AVThreadMessageFlags = UInt32
const AV_THREAD_MESSAGE_NONBLOCK = 1 % UInt32

"""
    av_thread_message_queue_alloc(mq, nelem::Integer, elsize::Integer)

Allocate a new message queue.

# Arguments
* `mq`: pointer to the message queue
* `nelem`: maximum number of elements in the queue
* `elsize`: size of each element in the queue
# Returns
>=0 for success; <0 for error, in particular [`AVERROR`](@ref)(ENOSYS) if lavu was built without thread support
"""
function av_thread_message_queue_alloc(mq, nelem::Integer, elsize::Integer)
    ccall((:av_thread_message_queue_alloc, libavutil), Cint, (Ptr{Ptr{AVThreadMessageQueue}}, Cuint, Cuint), mq, nelem, elsize)
end

"""
    av_thread_message_queue_free(mq)

Free a message queue.

The message queue must no longer be in use by another thread.
"""
function av_thread_message_queue_free(mq)
    ccall((:av_thread_message_queue_free, libavutil), Cvoid, (Ptr{Ptr{AVThreadMessageQueue}},), mq)
end

"""
    av_thread_message_queue_send(mq, msg, flags::Integer)

Send a message on the queue.
"""
function av_thread_message_queue_send(mq, msg, flags::Integer)
    ccall((:av_thread_message_queue_send, libavutil), Cint, (Ptr{AVThreadMessageQueue}, Ptr{Cvoid}, Cuint), mq, msg, flags)
end

"""
    av_thread_message_queue_recv(mq, msg, flags::Integer)

Receive a message from the queue.
"""
function av_thread_message_queue_recv(mq, msg, flags::Integer)
    ccall((:av_thread_message_queue_recv, libavutil), Cint, (Ptr{AVThreadMessageQueue}, Ptr{Cvoid}, Cuint), mq, msg, flags)
end

"""
    av_thread_message_queue_set_err_send(mq, err::Integer)

Set the sending error code.

If the error code is set to non-zero, [`av_thread_message_queue_send`](@ref)() will return it immediately. Conventional values, such as [`AVERROR_EOF`](@ref) or [`AVERROR`](@ref)(EAGAIN), can be used to cause the sending thread to stop or suspend its operation.
"""
function av_thread_message_queue_set_err_send(mq, err::Integer)
    ccall((:av_thread_message_queue_set_err_send, libavutil), Cvoid, (Ptr{AVThreadMessageQueue}, Cint), mq, err)
end

"""
    av_thread_message_queue_set_err_recv(mq, err::Integer)

Set the receiving error code.

If the error code is set to non-zero, [`av_thread_message_queue_recv`](@ref)() will return it immediately when there are no longer available messages. Conventional values, such as [`AVERROR_EOF`](@ref) or [`AVERROR`](@ref)(EAGAIN), can be used to cause the receiving thread to stop or suspend its operation.
"""
function av_thread_message_queue_set_err_recv(mq, err::Integer)
    ccall((:av_thread_message_queue_set_err_recv, libavutil), Cvoid, (Ptr{AVThreadMessageQueue}, Cint), mq, err)
end

"""
    av_thread_message_queue_set_free_func(mq, free_func)

Set the optional free message callback function which will be called if an operation is removing messages from the queue.
"""
function av_thread_message_queue_set_free_func(mq, free_func)
    ccall((:av_thread_message_queue_set_free_func, libavutil), Cvoid, (Ptr{AVThreadMessageQueue}, Ptr{Cvoid}), mq, free_func)
end

"""
    av_thread_message_queue_nb_elems(mq)

Return the current number of messages in the queue.

# Returns
the current number of messages or [`AVERROR`](@ref)(ENOSYS) if lavu was built without thread support
"""
function av_thread_message_queue_nb_elems(mq)
    ccall((:av_thread_message_queue_nb_elems, libavutil), Cint, (Ptr{AVThreadMessageQueue},), mq)
end

"""
    av_thread_message_flush(mq)

Flush the message queue

This function is mostly equivalent to reading and free-ing every message except that it will be done in a single operation (no lock/unlock between reads).
"""
function av_thread_message_flush(mq)
    ccall((:av_thread_message_flush, libavutil), Cvoid, (Ptr{AVThreadMessageQueue},), mq)
end

"""
    av_gettime()

Get the current time in microseconds.
"""
function av_gettime()
    ccall((:av_gettime, libavutil), Int64, ())
end

"""
    av_gettime_relative()

Get the current time in microseconds since some unspecified starting point. On platforms that support it, the time comes from a monotonic clock This property makes this time source ideal for measuring relative time. The returned values may not be monotonic on platforms where a monotonic clock is not available.
"""
function av_gettime_relative()
    ccall((:av_gettime_relative, libavutil), Int64, ())
end

"""
    av_gettime_relative_is_monotonic()

Indicates with a boolean result if the [`av_gettime_relative`](@ref)() time source is monotonic.
"""
function av_gettime_relative_is_monotonic()
    ccall((:av_gettime_relative_is_monotonic, libavutil), Cint, ())
end

"""
    av_usleep(usec::Integer)

Sleep for a period of time. Although the duration is expressed in microseconds, the actual delay may be rounded to the precision of the system timer.

# Arguments
* `usec`: Number of microseconds to sleep.
# Returns
zero on success or (negative) error code.
"""
function av_usleep(usec::Integer)
    ccall((:av_usleep, libavutil), Cint, (Cuint,), usec)
end

const AVTimecodeFlag = UInt32
const AV_TIMECODE_FLAG_DROPFRAME = 1 % UInt32
const AV_TIMECODE_FLAG_24HOURSMAX = 2 % UInt32
const AV_TIMECODE_FLAG_ALLOWNEGATIVE = 4 % UInt32

struct AVTimecode
    start::Cint
    flags::UInt32
    rate::AVRational
    fps::Cuint
end

"""
    av_timecode_adjust_ntsc_framenum2(framenum::Integer, fps::Integer)

Adjust frame number for NTSC drop frame time code.

!!! warning

    adjustment is only valid for multiples of NTSC 29.97

# Arguments
* `framenum`: frame number to adjust
* `fps`: frame per second, multiples of 30
# Returns
adjusted frame number
"""
function av_timecode_adjust_ntsc_framenum2(framenum::Integer, fps::Integer)
    ccall((:av_timecode_adjust_ntsc_framenum2, libavutil), Cint, (Cint, Cint), framenum, fps)
end

"""
    av_timecode_get_smpte_from_framenum(tc, framenum::Integer)

Convert frame number to SMPTE 12M binary representation.

See SMPTE ST 314M-2005 Sec 4.4.2.2.1 "Time code pack (TC)" the format description as follows: bits 0-5: hours, in BCD(6bits) bits 6: BGF1 bits 7: BGF2 (NTSC) or FIELD (PAL) bits 8-14: minutes, in BCD(7bits) bits 15: BGF0 (NTSC) or BGF2 (PAL) bits 16-22: seconds, in BCD(7bits) bits 23: FIELD (NTSC) or BGF0 (PAL) bits 24-29: frames, in BCD(6bits) bits 30: drop frame flag (0: non drop, 1: drop) bits 31: color frame flag (0: unsync mode, 1: sync mode)

!!! note

    BCD numbers (6 or 7 bits): 4 or 5 lower bits for units, 2 higher bits for tens.

!!! note

    Frame number adjustment is automatically done in case of drop timecode, you do NOT have to call [`av_timecode_adjust_ntsc_framenum2`](@ref)().

!!! note

    The frame number is relative to tc->start.

!!! note

    Color frame (CF) and binary group flags (BGF) bits are set to zero.

# Arguments
* `tc`: timecode data correctly initialized
* `framenum`: frame number
# Returns
the SMPTE binary representation
"""
function av_timecode_get_smpte_from_framenum(tc, framenum::Integer)
    ccall((:av_timecode_get_smpte_from_framenum, libavutil), UInt32, (Ptr{AVTimecode}, Cint), tc, framenum)
end

"""
    av_timecode_get_smpte(rate::AVRational, drop::Integer, hh::Integer, mm::Integer, ss::Integer, ff::Integer)

Convert sei info to SMPTE 12M binary representation.

# Arguments
* `rate`: frame rate in rational form
* `drop`: drop flag
* `hh`: hour
* `mm`: minute
* `ss`: second
* `ff`: frame number
# Returns
the SMPTE binary representation
"""
function av_timecode_get_smpte(rate::AVRational, drop::Integer, hh::Integer, mm::Integer, ss::Integer, ff::Integer)
    ccall((:av_timecode_get_smpte, libavutil), UInt32, (AVRational, Cint, Cint, Cint, Cint, Cint), rate, drop, hh, mm, ss, ff)
end

"""
    av_timecode_make_string(tc, buf, framenum::Integer)

Load timecode string in buf.

!!! note

    Timecode representation can be a negative timecode and have more than 24 hours, but will only be honored if the flags are correctly set.

!!! note

    The frame number is relative to tc->start.

# Arguments
* `tc`: timecode data correctly initialized
* `buf`: destination buffer, must be at least [`AV_TIMECODE_STR_SIZE`](@ref) long
* `framenum`: frame number
# Returns
the buf parameter
"""
function av_timecode_make_string(tc, buf, framenum::Integer)
    ccall((:av_timecode_make_string, libavutil), Cstring, (Ptr{AVTimecode}, Cstring, Cint), tc, buf, framenum)
end

"""
    av_timecode_make_smpte_tc_string2(buf, rate::AVRational, tcsmpte::Integer, prevent_df::Integer, skip_field::Integer)

Get the timecode string from the SMPTE timecode format.

In contrast to [`av_timecode_make_smpte_tc_string`](@ref) this function supports 50/60 fps timecodes by using the field bit.

# Arguments
* `buf`: destination buffer, must be at least [`AV_TIMECODE_STR_SIZE`](@ref) long
* `rate`: frame rate of the timecode
* `tcsmpte`: the 32-bit SMPTE timecode
* `prevent_df`: prevent the use of a drop flag when it is known the DF bit is arbitrary
* `skip_field`: prevent the use of a field flag when it is known the field bit is arbitrary (e.g. because it is used as PC flag)
# Returns
the buf parameter
"""
function av_timecode_make_smpte_tc_string2(buf, rate::AVRational, tcsmpte::Integer, prevent_df::Integer, skip_field::Integer)
    ccall((:av_timecode_make_smpte_tc_string2, libavutil), Cstring, (Cstring, AVRational, UInt32, Cint, Cint), buf, rate, tcsmpte, prevent_df, skip_field)
end

"""
    av_timecode_make_smpte_tc_string(buf, tcsmpte::Integer, prevent_df::Integer)

Get the timecode string from the SMPTE timecode format.

# Arguments
* `buf`: destination buffer, must be at least [`AV_TIMECODE_STR_SIZE`](@ref) long
* `tcsmpte`: the 32-bit SMPTE timecode
* `prevent_df`: prevent the use of a drop flag when it is known the DF bit is arbitrary
# Returns
the buf parameter
"""
function av_timecode_make_smpte_tc_string(buf, tcsmpte::Integer, prevent_df::Integer)
    ccall((:av_timecode_make_smpte_tc_string, libavutil), Cstring, (Cstring, UInt32, Cint), buf, tcsmpte, prevent_df)
end

"""
    av_timecode_make_mpeg_tc_string(buf, tc25bit::Integer)

Get the timecode string from the 25-bit timecode format (MPEG GOP format).

# Arguments
* `buf`: destination buffer, must be at least [`AV_TIMECODE_STR_SIZE`](@ref) long
* `tc25bit`: the 25-bits timecode
# Returns
the buf parameter
"""
function av_timecode_make_mpeg_tc_string(buf, tc25bit::Integer)
    ccall((:av_timecode_make_mpeg_tc_string, libavutil), Cstring, (Cstring, UInt32), buf, tc25bit)
end

"""
    av_timecode_init(tc, rate::AVRational, flags::Integer, frame_start::Integer, log_ctx)

Init a timecode struct with the passed parameters.

# Arguments
* `tc`: pointer to an allocated [`AVTimecode`](@ref)
* `rate`: frame rate in rational form
* `flags`: miscellaneous flags such as drop frame, +24 hours, ... (see [`AVTimecodeFlag`](@ref))
* `frame_start`: the first frame number
* `log_ctx`: a pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct (used for [`av_log`](@ref))
# Returns
0 on success, [`AVERROR`](@ref) otherwise
"""
function av_timecode_init(tc, rate::AVRational, flags::Integer, frame_start::Integer, log_ctx)
    ccall((:av_timecode_init, libavutil), Cint, (Ptr{AVTimecode}, AVRational, Cint, Cint, Ptr{Cvoid}), tc, rate, flags, frame_start, log_ctx)
end

"""
    av_timecode_init_from_components(tc, rate::AVRational, flags::Integer, hh::Integer, mm::Integer, ss::Integer, ff::Integer, log_ctx)

Init a timecode struct from the passed timecode components.

# Arguments
* `tc`: pointer to an allocated [`AVTimecode`](@ref)
* `rate`: frame rate in rational form
* `flags`: miscellaneous flags such as drop frame, +24 hours, ... (see [`AVTimecodeFlag`](@ref))
* `hh`: hours
* `mm`: minutes
* `ss`: seconds
* `ff`: frames
* `log_ctx`: a pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct (used for [`av_log`](@ref))
# Returns
0 on success, [`AVERROR`](@ref) otherwise
"""
function av_timecode_init_from_components(tc, rate::AVRational, flags::Integer, hh::Integer, mm::Integer, ss::Integer, ff::Integer, log_ctx)
    ccall((:av_timecode_init_from_components, libavutil), Cint, (Ptr{AVTimecode}, AVRational, Cint, Cint, Cint, Cint, Cint, Ptr{Cvoid}), tc, rate, flags, hh, mm, ss, ff, log_ctx)
end

"""
    av_timecode_init_from_string(tc, rate::AVRational, str, log_ctx)

Parse timecode representation (hh:mm:ss[:;.]ff).

# Arguments
* `tc`: pointer to an allocated [`AVTimecode`](@ref)
* `rate`: frame rate in rational form
* `str`: timecode string which will determine the frame start
* `log_ctx`: a pointer to an arbitrary struct of which the first field is a pointer to an [`AVClass`](@ref) struct (used for [`av_log`](@ref)).
# Returns
0 on success, [`AVERROR`](@ref) otherwise
"""
function av_timecode_init_from_string(tc, rate::AVRational, str, log_ctx)
    ccall((:av_timecode_init_from_string, libavutil), Cint, (Ptr{AVTimecode}, AVRational, Cstring, Ptr{Cvoid}), tc, rate, str, log_ctx)
end

"""
    av_timecode_check_frame_rate(rate::AVRational)

Check if the timecode feature is available for the given frame rate

# Returns
0 if supported, <0 otherwise
"""
function av_timecode_check_frame_rate(rate::AVRational)
    ccall((:av_timecode_check_frame_rate, libavutil), Cint, (AVRational,), rate)
end

"""
    av_ts_make_string(buf, ts::Int64)

Fill the provided buffer with a string containing a timestamp representation.

# Arguments
* `buf`: a buffer with size in bytes of at least [`AV_TS_MAX_STRING_SIZE`](@ref)
* `ts`: the timestamp to represent
# Returns
the buffer in input
"""
function av_ts_make_string(buf, ts::Int64)
    ccall((:av_ts_make_string, libavutil), Cstring, (Cstring, Int64), buf, ts)
end

"""
    av_ts_make_time_string(buf, ts::Int64, tb)

Fill the provided buffer with a string containing a timestamp representation.

# See also
[`av_ts_make_time_string2`](@ref)
"""
function av_ts_make_time_string(buf, ts::Int64, tb)
    ccall((:av_ts_make_time_string, libavutil), Cstring, (Cstring, Int64, Ptr{AVRational}), buf, ts, tb)
end

"""
    av_ts_make_time_string2(buf, ts::Int64, tb::AVRational)

Fill the provided buffer with a string containing a timestamp time representation.

# Arguments
* `buf`: a buffer with size in bytes of at least [`AV_TS_MAX_STRING_SIZE`](@ref)
* `ts`: the timestamp to represent
* `tb`: the timebase of the timestamp
# Returns
the buffer in input
"""
function av_ts_make_time_string2(buf, ts::Int64, tb::AVRational)
    ccall((:av_ts_make_time_string2, libavutil), Cstring, (Cstring, Int64, AVRational), buf, ts, tb)
end

"""
` lavu_tree AVTree`

` lavu_data`

Low-complexity tree container

Insertion, removal, finding equal, largest which is smaller than and smallest which is larger than, all have O(log n) worst-case complexity. @{
"""
mutable struct AVTreeNode end

"""
    av_tree_node_alloc()

Allocate an [`AVTreeNode`](@ref).
"""
function av_tree_node_alloc()
    ccall((:av_tree_node_alloc, libavutil), Ptr{AVTreeNode}, ())
end

"""
    av_tree_find(root, key, cmp, next)

Find an element.

# Arguments
* `root`: a pointer to the root node of the tree
* `next`: If next is not NULL, then next[0] will contain the previous element and next[1] the next element. If either does not exist, then the corresponding entry in next is unchanged.
* `cmp`: compare function used to compare elements in the tree, API identical to that of Standard C's qsort It is guaranteed that the first and only the first argument to cmp() will be the key parameter to [`av_tree_find`](@ref)(), thus it could if the user wants, be a different type (like an opaque context).
# Returns
An element with cmp(key, elem) == 0 or NULL if no such element exists in the tree.
"""
function av_tree_find(root, key, cmp, next)
    ccall((:av_tree_find, libavutil), Ptr{Cvoid}, (Ptr{AVTreeNode}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Ptr{Cvoid}}), root, key, cmp, next)
end

"""
    av_tree_insert(rootp, key, cmp, next)

Insert or remove an element.

If *next is NULL, then the supplied element will be removed if it exists. If *next is non-NULL, then the supplied element will be inserted, unless it already exists in the tree.

```c++
             void *tree_insert(struct AVTreeNode **rootp, void *key,
                               int (*cmp)(void *key, const void *b),
                               AVTreeNode **next)
             {
                 if (!*next)
                     *next = av_mallocz(av_tree_node_size);
                 return av_tree_insert(rootp, key, cmp, next);
             }
             void *tree_remove(struct AVTreeNode **rootp, void *key,
                               int (*cmp)(void *key, const void *b, AVTreeNode **next))
             {
                 av_freep(next);
                 return av_tree_insert(rootp, key, cmp, next);
             }
```

# Arguments
* `rootp`: A pointer to a pointer to the root node of the tree; note that the root node can change during insertions, this is required to keep the tree balanced.
* `key`: pointer to the element key to insert in the tree
* `next`: Used to allocate and free AVTreeNodes. For insertion the user must set it to an allocated and zeroed object of at least av\\_tree\\_node\\_size bytes size. [`av_tree_insert`](@ref)() will set it to NULL if it has been consumed. For deleting elements *next is set to NULL by the user and [`av_tree_insert`](@ref)() will set it to the [`AVTreeNode`](@ref) which was used for the removed element. This allows the use of flat arrays, which have lower overhead compared to many malloced elements. You might want to define a function like:
* `cmp`: compare function used to compare elements in the tree, API identical to that of Standard C's qsort
# Returns
If no insertion happened, the found element; if an insertion or removal happened, then either key or NULL will be returned. Which one it is depends on the tree state and the implementation. You should make no assumptions that it's one or the other in the code.
"""
function av_tree_insert(rootp, key, cmp, next)
    ccall((:av_tree_insert, libavutil), Ptr{Cvoid}, (Ptr{Ptr{AVTreeNode}}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Ptr{AVTreeNode}}), rootp, key, cmp, next)
end

function av_tree_destroy(t)
    ccall((:av_tree_destroy, libavutil), Cvoid, (Ptr{AVTreeNode},), t)
end

"""
    av_tree_enumerate(t, opaque, cmp, enu)

Apply enu(opaque, &elem) to all the elements in the tree in a given range.

!!! note

    The cmp function should use the same ordering used to construct the tree.

# Arguments
* `cmp`: a comparison function that returns < 0 for an element below the range, > 0 for an element above the range and == 0 for an element inside the range
"""
function av_tree_enumerate(t, opaque, cmp, enu)
    ccall((:av_tree_enumerate, libavutil), Cvoid, (Ptr{AVTreeNode}, Ptr{Cvoid}, Ptr{Cvoid}, Ptr{Cvoid}), t, opaque, cmp, enu)
end

mutable struct AVTWOFISH end

"""
    av_twofish_alloc()

Allocate an [`AVTWOFISH`](@ref) context To free the struct: [`av_free`](@ref)(ptr)
"""
function av_twofish_alloc()
    ccall((:av_twofish_alloc, libavutil), Ptr{AVTWOFISH}, ())
end

"""
    av_twofish_init(ctx, key, key_bits::Integer)

Initialize an [`AVTWOFISH`](@ref) context.

# Arguments
* `ctx`: an [`AVTWOFISH`](@ref) context
* `key`: a key of size ranging from 1 to 32 bytes used for encryption/decryption
* `key_bits`: number of keybits: 128, 192, 256 If less than the required, padded with zeroes to nearest valid value; return value is 0 if key\\_bits is 128/192/256, -1 if less than 0, 1 otherwise
"""
function av_twofish_init(ctx, key, key_bits::Integer)
    ccall((:av_twofish_init, libavutil), Cint, (Ptr{AVTWOFISH}, Ptr{UInt8}, Cint), ctx, key, key_bits)
end

"""
    av_twofish_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context

# Arguments
* `ctx`: an [`AVTWOFISH`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 16 byte blocks
* `iv`: initialization vector for CBC mode, NULL for ECB mode
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_twofish_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_twofish_crypt, libavutil), Cvoid, (Ptr{AVTWOFISH}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

mutable struct AVTXContext end

struct AVComplexFloat
    re::Cfloat
    im::Cfloat
end

struct AVComplexDouble
    re::Cdouble
    im::Cdouble
end

struct AVComplexInt32
    re::Int32
    im::Int32
end

const AVTXType = UInt32
const AV_TX_FLOAT_FFT = 0 % UInt32
const AV_TX_DOUBLE_FFT = 2 % UInt32
const AV_TX_INT32_FFT = 4 % UInt32
const AV_TX_FLOAT_MDCT = 1 % UInt32
const AV_TX_DOUBLE_MDCT = 3 % UInt32
const AV_TX_INT32_MDCT = 5 % UInt32
const AV_TX_FLOAT_RDFT = 6 % UInt32
const AV_TX_DOUBLE_RDFT = 7 % UInt32
const AV_TX_INT32_RDFT = 8 % UInt32
const AV_TX_FLOAT_DCT = 9 % UInt32
const AV_TX_DOUBLE_DCT = 10 % UInt32
const AV_TX_INT32_DCT = 11 % UInt32
const AV_TX_FLOAT_DCT_I = 12 % UInt32
const AV_TX_DOUBLE_DCT_I = 13 % UInt32
const AV_TX_INT32_DCT_I = 14 % UInt32
const AV_TX_FLOAT_DST_I = 15 % UInt32
const AV_TX_DOUBLE_DST_I = 16 % UInt32
const AV_TX_INT32_DST_I = 17 % UInt32
const AV_TX_NB = 18 % UInt32

# typedef void ( * av_tx_fn ) ( AVTXContext * s , void * out , void * in , ptrdiff_t stride )
"""
Function pointer to a function to perform the transform.

!!! note

    Using a different context than the one allocated during [`av_tx_init`](@ref)() is not allowed.

The out and in arrays must be aligned to the maximum required by the CPU architecture unless the AV\\_TX\\_UNALIGNED flag was set in [`av_tx_init`](@ref)(). The stride must follow the constraints the transform type has specified.

# Arguments
* `s`: the transform context
* `out`: the output array
* `in`: the input array
* `stride`: the input or output stride in bytes
"""
const av_tx_fn = Ptr{Cvoid}

"""
    AVTXFlags

Flags for [`av_tx_init`](@ref)()
"""
const AVTXFlags = UInt32
const AV_TX_INPLACE = 1 % UInt32
const AV_TX_UNALIGNED = 2 % UInt32
const AV_TX_FULL_IMDCT = 4 % UInt32
const AV_TX_REAL_TO_REAL = 8 % UInt32
const AV_TX_REAL_TO_IMAGINARY = 16 % UInt32

"""
    av_tx_init(ctx, tx, type::AVTXType, inv::Integer, len::Integer, scale, flags::UInt64)

Initialize a transform context with the given configuration (i)MDCTs with an odd length are currently not supported.

# Arguments
* `ctx`: the context to allocate, will be NULL on error
* `tx`: pointer to the transform function pointer to set
* `type`: type the type of transform
* `inv`: whether to do an inverse or a forward transform
* `len`: the size of the transform in samples
* `scale`: pointer to the value to scale the output if supported by type
* `flags`: a bitmask of [`AVTXFlags`](@ref) or 0
# Returns
0 on success, negative error code on failure
"""
function av_tx_init(ctx, tx, type::AVTXType, inv::Integer, len::Integer, scale, flags::UInt64)
    ccall((:av_tx_init, libavutil), Cint, (Ptr{Ptr{AVTXContext}}, Ptr{av_tx_fn}, AVTXType, Cint, Cint, Ptr{Cvoid}, UInt64), ctx, tx, type, inv, len, scale, flags)
end

"""
    av_tx_uninit(ctx)

Frees a context and sets *ctx to NULL, does nothing when *ctx == NULL.
"""
function av_tx_uninit(ctx)
    ccall((:av_tx_uninit, libavutil), Cvoid, (Ptr{Ptr{AVTXContext}},), ctx)
end

const AVUUID = NTuple{16, UInt8}

"""
    av_uuid_parse(in, uu)

Parses a string representation of a UUID formatted according to IETF RFC 4122 into an [`AVUUID`](@ref). The parsing is case-insensitive. The string must be 37 characters long, including the terminating NUL character.

Example string representation: "2fceebd0-7017-433d-bafb-d073a7116696"

# Arguments
* `in`:\\[in\\] String representation of a UUID, e.g. 2fceebd0-7017-433d-bafb-d073a7116696
* `uu`:\\[out\\] [`AVUUID`](@ref)
# Returns
A non-zero value in case of an error.
"""
function av_uuid_parse(in, uu)
    ccall((:av_uuid_parse, libavutil), Cint, (Cstring, Ptr{Cuchar}), in, uu)
end

"""
    av_uuid_urn_parse(in, uu)

Parses a URN representation of a UUID, as specified at IETF RFC 4122, into an [`AVUUID`](@ref). The parsing is case-insensitive. The string must be 46 characters long, including the terminating NUL character.

Example string representation: "urn:uuid:2fceebd0-7017-433d-bafb-d073a7116696"

# Arguments
* `in`:\\[in\\] URN UUID
* `uu`:\\[out\\] [`AVUUID`](@ref)
# Returns
A non-zero value in case of an error.
"""
function av_uuid_urn_parse(in, uu)
    ccall((:av_uuid_urn_parse, libavutil), Cint, (Cstring, Ptr{Cuchar}), in, uu)
end

"""
    av_uuid_parse_range(in_start, in_end, uu)

Parses a string representation of a UUID formatted according to IETF RFC 4122 into an [`AVUUID`](@ref). The parsing is case-insensitive.

# Arguments
* `in_start`:\\[in\\] Pointer to the first character of the string representation
* `in_end`:\\[in\\] Pointer to the character after the last character of the string representation. That memory location is never accessed. It is an error if `in\\_end - in\\_start != 36`.
* `uu`:\\[out\\] [`AVUUID`](@ref)
# Returns
A non-zero value in case of an error.
"""
function av_uuid_parse_range(in_start, in_end, uu)
    ccall((:av_uuid_parse_range, libavutil), Cint, (Cstring, Cstring, Ptr{Cuchar}), in_start, in_end, uu)
end

"""
    av_uuid_unparse(uu, out)

Serializes a [`AVUUID`](@ref) into a string representation according to IETF RFC 4122. The string is lowercase and always 37 characters long, including the terminating NUL character.

# Arguments
* `uu`:\\[in\\] [`AVUUID`](@ref)
* `out`:\\[out\\] Pointer to an array of no less than 37 characters.
"""
function av_uuid_unparse(uu, out)
    ccall((:av_uuid_unparse, libavutil), Cvoid, (Ptr{Cuchar}, Cstring), uu, out)
end

"""
    av_uuid_equal(uu1, uu2)

Compares two UUIDs for equality.

# Arguments
* `uu1`:\\[in\\] [`AVUUID`](@ref)
* `uu2`:\\[in\\] [`AVUUID`](@ref)
# Returns
Nonzero if uu1 and uu2 are identical, 0 otherwise
"""
function av_uuid_equal(uu1, uu2)
    ccall((:av_uuid_equal, libavutil), Cint, (Ptr{Cuchar}, Ptr{Cuchar}), uu1, uu2)
end

"""
    av_uuid_copy(dest, src)

Copies the bytes of src into dest.

# Arguments
* `dest`:\\[out\\] [`AVUUID`](@ref)
* `src`:\\[in\\] [`AVUUID`](@ref)
"""
function av_uuid_copy(dest, src)
    ccall((:av_uuid_copy, libavutil), Cvoid, (Ptr{Cuchar}, Ptr{Cuchar}), dest, src)
end

"""
    av_uuid_nil(uu)

Sets a UUID to the nil UUID, i.e. a UUID with have all its 128 bits set to zero.

# Arguments
* `uu`:\\[in,out\\] UUID to be set to the nil UUID
"""
function av_uuid_nil(uu)
    ccall((:av_uuid_nil, libavutil), Cvoid, (Ptr{Cuchar},), uu)
end

const AVVideoEncParamsType = Int32
const AV_VIDEO_ENC_PARAMS_NONE = -1 % Int32
const AV_VIDEO_ENC_PARAMS_VP9 = 0 % Int32
const AV_VIDEO_ENC_PARAMS_H264 = 1 % Int32
const AV_VIDEO_ENC_PARAMS_MPEG2 = 2 % Int32

"""
    AVVideoEncParams

Video encoding parameters for a given frame. This struct is allocated along with an optional array of per-block [`AVVideoBlockParams`](@ref) descriptors. Must be allocated with [`av_video_enc_params_alloc`](@ref)().
"""
struct AVVideoEncParams
    nb_blocks::Cuint
    blocks_offset::Csize_t
    block_size::Csize_t
    type::AVVideoEncParamsType
    qp::Int32
    delta_qp::NTuple{4, NTuple{2, Int32}}
end

"""
    AVVideoBlockParams

Data structure for storing block-level encoding information. It is allocated as a part of [`AVVideoEncParams`](@ref) and should be retrieved with [`av_video_enc_params_block`](@ref)().

sizeof([`AVVideoBlockParams`](@ref)) is not a part of the ABI and new fields may be added to it.
"""
struct AVVideoBlockParams
    src_x::Cint
    src_y::Cint
    w::Cint
    h::Cint
    delta_qp::Int32
end

"""
    av_video_enc_params_block(par, idx::Integer)

Get the block at the specified {

```c++
 idx}. Must be between 0 and nb_blocks - 1.
 

```
"""
function av_video_enc_params_block(par, idx::Integer)
    ccall((:av_video_enc_params_block, libavutil), Ptr{AVVideoBlockParams}, (Ptr{AVVideoEncParams}, Cuint), par, idx)
end

"""
    av_video_enc_params_alloc(type::AVVideoEncParamsType, nb_blocks::Integer, out_size)

Allocates memory for [`AVVideoEncParams`](@ref) of the given type, plus an array of {

```c++
 nb_blocks} AVVideoBlockParams and initializes the variables. Can be
 freed with a normal av_free() call.

 @param out_size if non-NULL, the size in bytes of the resulting data array is
 written here.
 

```
"""
function av_video_enc_params_alloc(type::AVVideoEncParamsType, nb_blocks::Integer, out_size)
    ccall((:av_video_enc_params_alloc, libavutil), Ptr{AVVideoEncParams}, (AVVideoEncParamsType, Cuint, Ptr{Csize_t}), type, nb_blocks, out_size)
end

"""
    av_video_enc_params_create_side_data(frame, type::AVVideoEncParamsType, nb_blocks::Integer)

Allocates memory for AVEncodeInfoFrame plus an array of {

```c++
 nb_blocks} AVEncodeInfoBlock in the given AVFrame {@code frame}
 as AVFrameSideData of type AV_FRAME_DATA_VIDEO_ENC_PARAMS
 and initializes the variables.
 

```
"""
function av_video_enc_params_create_side_data(frame, type::AVVideoEncParamsType, nb_blocks::Integer)
    ccall((:av_video_enc_params_create_side_data, libavutil), Ptr{AVVideoEncParams}, (Ptr{AVFrame}, AVVideoEncParamsType, Cuint), frame, type, nb_blocks)
end

struct AVVideoRect
    x::UInt32
    y::UInt32
    width::UInt32
    height::UInt32
end

const AVVideoHintType = UInt32
const AV_VIDEO_HINT_TYPE_CONSTANT = 0 % UInt32
const AV_VIDEO_HINT_TYPE_CHANGED = 1 % UInt32

struct AVVideoHint
    nb_rects::Csize_t
    rect_offset::Csize_t
    rect_size::Csize_t
    type::AVVideoHintType
end

function av_video_hint_rects(hints)
    ccall((:av_video_hint_rects, libavutil), Ptr{AVVideoRect}, (Ptr{AVVideoHint},), hints)
end

function av_video_hint_get_rect(hints, idx::Csize_t)
    ccall((:av_video_hint_get_rect, libavutil), Ptr{AVVideoRect}, (Ptr{AVVideoHint}, Csize_t), hints, idx)
end

"""
    av_video_hint_alloc(nb_rects::Csize_t, out_size)

Allocate memory for the [`AVVideoHint`](@ref) struct along with an nb\\_rects-sized arrays of [`AVVideoRect`](@ref).

The side data contains a list of rectangles for the portions of the frame which changed from the last encoded one (and the remainder are assumed to be changed), or, alternately (depending on the type parameter) the unchanged ones (and the remaining ones are those which changed). Macroblocks will thus be hinted either to be P\\_SKIP-ped or go through the regular encoding procedure.

It's responsibility of the caller to fill the AVRects accordingly, and to set the proper [`AVVideoHintType`](@ref) field.

# Arguments
* `out_size`: if non-NULL, the size in bytes of the resulting data array is written here
# Returns
newly allocated [`AVVideoHint`](@ref) struct (must be freed by the caller using [`av_free`](@ref)()) on success, NULL on memory allocation failure
"""
function av_video_hint_alloc(nb_rects::Csize_t, out_size)
    ccall((:av_video_hint_alloc, libavutil), Ptr{AVVideoHint}, (Csize_t, Ptr{Csize_t}), nb_rects, out_size)
end

"""
    av_video_hint_create_side_data(frame, nb_rects::Csize_t)

Same as [`av_video_hint_alloc`](@ref)(), except newly-allocated [`AVVideoHint`](@ref) is attached as side data of type AV\\_FRAME\\_DATA\\_VIDEO\\_HINT\\_INFO to frame.
"""
function av_video_hint_create_side_data(frame, nb_rects::Csize_t)
    ccall((:av_video_hint_create_side_data, libavutil), Ptr{AVVideoHint}, (Ptr{AVFrame}, Csize_t), frame, nb_rects)
end

"""
    AVXTEA

``

Public header for libavutil XTEA algorithm

` lavu_xtea XTEA`

` lavu_crypto`

@{
"""
struct AVXTEA
    key::NTuple{16, UInt32}
end

"""
    av_xtea_alloc()

Allocate an [`AVXTEA`](@ref) context.
"""
function av_xtea_alloc()
    ccall((:av_xtea_alloc, libavutil), Ptr{AVXTEA}, ())
end

"""
    av_xtea_init(ctx, key)

Initialize an [`AVXTEA`](@ref) context.

# Arguments
* `ctx`: an [`AVXTEA`](@ref) context
* `key`: a key of 16 bytes used for encryption/decryption, interpreted as big endian 32 bit numbers
"""
function av_xtea_init(ctx, key)
    ccall((:av_xtea_init, libavutil), Cvoid, (Ptr{AVXTEA}, Ptr{UInt8}), ctx, key)
end

"""
    av_xtea_le_init(ctx, key)

Initialize an [`AVXTEA`](@ref) context.

# Arguments
* `ctx`: an [`AVXTEA`](@ref) context
* `key`: a key of 16 bytes used for encryption/decryption, interpreted as little endian 32 bit numbers
"""
function av_xtea_le_init(ctx, key)
    ccall((:av_xtea_le_init, libavutil), Cvoid, (Ptr{AVXTEA}, Ptr{UInt8}), ctx, key)
end

"""
    av_xtea_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context, in big endian format.

# Arguments
* `ctx`: an [`AVXTEA`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, if NULL then ECB will be used
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_xtea_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_xtea_crypt, libavutil), Cvoid, (Ptr{AVXTEA}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

"""
    av_xtea_le_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)

Encrypt or decrypt a buffer using a previously initialized context, in little endian format.

# Arguments
* `ctx`: an [`AVXTEA`](@ref) context
* `dst`: destination array, can be equal to src
* `src`: source array, can be equal to dst
* `count`: number of 8 byte blocks
* `iv`: initialization vector for CBC mode, if NULL then ECB will be used
* `decrypt`: 0 for encryption, 1 for decryption
"""
function av_xtea_le_crypt(ctx, dst, src, count::Integer, iv, decrypt::Integer)
    ccall((:av_xtea_le_crypt, libavutil), Cvoid, (Ptr{AVXTEA}, Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}, Cint), ctx, dst, src, count, iv, decrypt)
end

"""
    swscale_version()

` libsws libswscale`

Color conversion and scaling library.

@{

Return the [`LIBSWSCALE_VERSION_INT`](@ref) constant.
"""
function swscale_version()
    ccall((:swscale_version, libswscale), Cuint, ())
end

"""
    swscale_configuration()

Return the libswscale build-time configuration.
"""
function swscale_configuration()
    ccall((:swscale_configuration, libswscale), Cstring, ())
end

"""
    swscale_license()

Return the libswscale license.
"""
function swscale_license()
    ccall((:swscale_license, libswscale), Cstring, ())
end

"""
    sws_get_class()

Get the [`AVClass`](@ref) for [`SwsContext`](@ref). It can be used in combination with [`AV_OPT_SEARCH_FAKE_OBJ`](@ref) for examining options.

# See also
[`av_opt_find`](@ref)().
"""
function sws_get_class()
    ccall((:sws_get_class, libswscale), Ptr{AVClass}, ())
end

"""
    SwsDither

**************************** Flags and quality settings *****************************
"""
const SwsDither = UInt32
const SWS_DITHER_NONE = 0 % UInt32
const SWS_DITHER_AUTO = 1 % UInt32
const SWS_DITHER_BAYER = 2 % UInt32
const SWS_DITHER_ED = 3 % UInt32
const SWS_DITHER_A_DITHER = 4 % UInt32
const SWS_DITHER_X_DITHER = 5 % UInt32
const SWS_DITHER_NB = 6 % UInt32

const SwsAlphaBlend = UInt32
const SWS_ALPHA_BLEND_NONE = 0 % UInt32
const SWS_ALPHA_BLEND_UNIFORM = 1 % UInt32
const SWS_ALPHA_BLEND_CHECKERBOARD = 2 % UInt32
const SWS_ALPHA_BLEND_NB = 3 % UInt32

const SwsFlags = UInt32
const SWS_FAST_BILINEAR = 1 % UInt32
const SWS_BILINEAR = 2 % UInt32
const SWS_BICUBIC = 4 % UInt32
const SWS_X = 8 % UInt32
const SWS_POINT = 16 % UInt32
const SWS_AREA = 32 % UInt32
const SWS_BICUBLIN = 64 % UInt32
const SWS_GAUSS = 128 % UInt32
const SWS_SINC = 256 % UInt32
const SWS_LANCZOS = 512 % UInt32
const SWS_SPLINE = 1024 % UInt32
const SWS_STRICT = 2048 % UInt32
const SWS_PRINT_INFO = 4096 % UInt32
const SWS_FULL_CHR_H_INT = 8192 % UInt32
const SWS_FULL_CHR_H_INP = 16384 % UInt32
const SWS_ACCURATE_RND = 262144 % UInt32
const SWS_BITEXACT = 524288 % UInt32
const SWS_DIRECT_BGR = 32768 % UInt32
const SWS_ERROR_DIFFUSION = 8388608 % UInt32

const SwsIntent = UInt32
const SWS_INTENT_PERCEPTUAL = 0 % UInt32
const SWS_INTENT_RELATIVE_COLORIMETRIC = 1 % UInt32
const SWS_INTENT_SATURATION = 2 % UInt32
const SWS_INTENT_ABSOLUTE_COLORIMETRIC = 3 % UInt32
const SWS_INTENT_NB = 4 % UInt32

"""
    SwsContext

Main external API structure. New fields can be added to the end with minor version bumps. Removal, reordering and changes to existing fields require a major version bump. sizeof([`SwsContext`](@ref)) is not part of the ABI.
"""
struct SwsContext
    av_class::Ptr{AVClass}
    opaque::Ptr{Cvoid}
    flags::Cuint
    scaler_params::NTuple{2, Cdouble}
    threads::Cint
    dither::SwsDither
    alpha_blend::SwsAlphaBlend
    gamma_flag::Cint
    src_w::Cint
    src_h::Cint
    dst_w::Cint
    dst_h::Cint
    src_format::Cint
    dst_format::Cint
    src_range::Cint
    dst_range::Cint
    src_v_chr_pos::Cint
    src_h_chr_pos::Cint
    dst_v_chr_pos::Cint
    dst_h_chr_pos::Cint
    intent::Cint
end

"""
    sws_alloc_context()

Allocate an empty [`SwsContext`](@ref) and set its fields to default values.
"""
function sws_alloc_context()
    ccall((:sws_alloc_context, libswscale), Ptr{SwsContext}, ())
end

"""
    sws_free_context(ctx)

Free the context and everything associated with it, and write NULL to the provided pointer.
"""
function sws_free_context(ctx)
    ccall((:sws_free_context, libswscale), Cvoid, (Ptr{Ptr{SwsContext}},), ctx)
end

"""
    sws_test_format(format::AVPixelFormat, output::Integer)

Test if a given pixel format is supported.

# Arguments
* `output`: If 0, test if compatible with the source/input frame; otherwise, with the destination/output frame.
* `format`: The format to check.
# Returns
A positive integer if supported, 0 otherwise.
"""
function sws_test_format(format::AVPixelFormat, output::Integer)
    ccall((:sws_test_format, libswscale), Cint, (AVPixelFormat, Cint), format, output)
end

"""
    sws_test_colorspace(colorspace::AVColorSpace, output::Integer)

Test if a given color space is supported.

# Arguments
* `output`: If 0, test if compatible with the source/input frame; otherwise, with the destination/output frame.
* `colorspace`: The colorspace to check.
# Returns
A positive integer if supported, 0 otherwise.
"""
function sws_test_colorspace(colorspace::AVColorSpace, output::Integer)
    ccall((:sws_test_colorspace, libswscale), Cint, (AVColorSpace, Cint), colorspace, output)
end

"""
    sws_test_primaries(primaries::AVColorPrimaries, output::Integer)

Test if a given set of color primaries is supported.

# Arguments
* `output`: If 0, test if compatible with the source/input frame; otherwise, with the destination/output frame.
* `primaries`: The color primaries to check.
# Returns
A positive integer if supported, 0 otherwise.
"""
function sws_test_primaries(primaries::AVColorPrimaries, output::Integer)
    ccall((:sws_test_primaries, libswscale), Cint, (AVColorPrimaries, Cint), primaries, output)
end

"""
    sws_test_transfer(trc::AVColorTransferCharacteristic, output::Integer)

Test if a given color transfer function is supported.

# Arguments
* `output`: If 0, test if compatible with the source/input frame; otherwise, with the destination/output frame.
* `trc`: The color transfer function to check.
# Returns
A positive integer if supported, 0 otherwise.
"""
function sws_test_transfer(trc::AVColorTransferCharacteristic, output::Integer)
    ccall((:sws_test_transfer, libswscale), Cint, (AVColorTransferCharacteristic, Cint), trc, output)
end

"""
    sws_test_frame(frame, output::Integer)

Helper function to run all sws\\_test\\_* against a frame, as well as testing the basic frame properties for sanity. Ignores irrelevant properties - for example, [`AVColorSpace`](@ref) is not checked for RGB frames.
"""
function sws_test_frame(frame, output::Integer)
    ccall((:sws_test_frame, libswscale), Cint, (Ptr{AVFrame}, Cint), frame, output)
end

"""
    sws_frame_setup(ctx, dst, src)

Like [`sws_scale_frame`](@ref), but without actually scaling. It will instead merely initialize internal state that *would* be required to perform the operation, as well as returning the correct error code for unsupported frame combinations.

# Arguments
* `ctx`: The scaling context.
* `dst`: The destination frame to consider.
* `src`: The source frame to consider.
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function sws_frame_setup(ctx, dst, src)
    ccall((:sws_frame_setup, libswscale), Cint, (Ptr{SwsContext}, Ptr{AVFrame}, Ptr{AVFrame}), ctx, dst, src)
end

"""
    sws_is_noop(dst, src)

Check if a given conversion is a noop. Returns a positive integer if no operation needs to be performed, 0 otherwise.
"""
function sws_is_noop(dst, src)
    ccall((:sws_is_noop, libswscale), Cint, (Ptr{AVFrame}, Ptr{AVFrame}), dst, src)
end

"""
    sws_scale_frame(c, dst, src)

Scale source data from `src` and write the output to `dst`.

This function can be used directly on an allocated context, without setting up any frame properties or calling `[`sws_init_context`](@ref)()`. Such usage is fully dynamic and does not require reallocation if the frame properties change.

Alternatively, this function can be called on a context that has been explicitly initialized. However, this is provided only for backwards compatibility. In this usage mode, all frame properties must be correctly set at init time, and may no longer change after initialization.

# Arguments
* `ctx`: The scaling context.
* `dst`: The destination frame. The data buffers may either be already allocated by the caller or left clear, in which case they will be allocated by the scaler. The latter may have performance advantages - e.g. in certain cases some (or all) output planes may be references to input planes, rather than copies.
* `src`: The source frame. If the data buffers are set to NULL, then this function behaves identically to [`sws_frame_setup`](@ref).
# Returns
>= 0 on success, a negative [`AVERROR`](@ref) code on failure.
"""
function sws_scale_frame(c, dst, src)
    ccall((:sws_scale_frame, libswscale), Cint, (Ptr{SwsContext}, Ptr{AVFrame}, Ptr{AVFrame}), c, dst, src)
end

"""
    sws_getCoefficients(colorspace::Integer)

Return a pointer to yuv<->rgb coefficients for the given colorspace suitable for [`sws_setColorspaceDetails`](@ref)().

# Arguments
* `colorspace`: One of the SWS\\_CS\\_* macros. If invalid, [`SWS_CS_DEFAULT`](@ref) is used.
"""
function sws_getCoefficients(colorspace::Integer)
    ccall((:sws_getCoefficients, libswscale), Ptr{Cint}, (Cint,), colorspace)
end

struct SwsVector
    coeff::Ptr{Cdouble}
    length::Cint
end

struct SwsFilter
    lumH::Ptr{SwsVector}
    lumV::Ptr{SwsVector}
    chrH::Ptr{SwsVector}
    chrV::Ptr{SwsVector}
end

"""
    sws_isSupportedInput(pix_fmt::AVPixelFormat)

Return a positive value if pix\\_fmt is a supported input format, 0 otherwise.
"""
function sws_isSupportedInput(pix_fmt::AVPixelFormat)
    ccall((:sws_isSupportedInput, libswscale), Cint, (AVPixelFormat,), pix_fmt)
end

"""
    sws_isSupportedOutput(pix_fmt::AVPixelFormat)

Return a positive value if pix\\_fmt is a supported output format, 0 otherwise.
"""
function sws_isSupportedOutput(pix_fmt::AVPixelFormat)
    ccall((:sws_isSupportedOutput, libswscale), Cint, (AVPixelFormat,), pix_fmt)
end

"""
    sws_isSupportedEndiannessConversion(pix_fmt::AVPixelFormat)

# Arguments
* `pix_fmt`:\\[in\\] the pixel format
# Returns
a positive value if an endianness conversion for pix\\_fmt is supported, 0 otherwise.
"""
function sws_isSupportedEndiannessConversion(pix_fmt::AVPixelFormat)
    ccall((:sws_isSupportedEndiannessConversion, libswscale), Cint, (AVPixelFormat,), pix_fmt)
end

"""
    sws_init_context(sws_context, srcFilter, dstFilter)

Initialize the swscaler context sws\\_context.

This function is considered deprecated, and provided only for backwards compatibility with [`sws_scale`](@ref)() and sws\\_start\\_frame(). The preferred way to use libswscale is to set all frame properties correctly and call [`sws_scale_frame`](@ref)() directly, without explicitly initializing the context.

# Returns
zero or positive value on success, a negative value on error
"""
function sws_init_context(sws_context, srcFilter, dstFilter)
    ccall((:sws_init_context, libswscale), Cint, (Ptr{SwsContext}, Ptr{SwsFilter}, Ptr{SwsFilter}), sws_context, srcFilter, dstFilter)
end

"""
    sws_freeContext(swsContext)

Free the swscaler context swsContext. If swsContext is NULL, then does nothing.
"""
function sws_freeContext(swsContext)
    ccall((:sws_freeContext, libswscale), Cvoid, (Ptr{SwsContext},), swsContext)
end

"""
    sws_getContext(srcW::Integer, srcH::Integer, srcFormat::AVPixelFormat, dstW::Integer, dstH::Integer, dstFormat::AVPixelFormat, flags::Integer, srcFilter, dstFilter, param)

Allocate and return an [`SwsContext`](@ref). You need it to perform scaling/conversion operations using [`sws_scale`](@ref)().

!!! note

    this function is to be removed after a saner alternative is written

# Arguments
* `srcW`: the width of the source image
* `srcH`: the height of the source image
* `srcFormat`: the source image format
* `dstW`: the width of the destination image
* `dstH`: the height of the destination image
* `dstFormat`: the destination image format
* `flags`: specify which algorithm and options to use for rescaling
* `param`: extra parameters to tune the used scaler For SWS\\_BICUBIC param[0] and [1] tune the shape of the basis function, param[0] tunes f(1) and param[1] f´(1) For SWS\\_GAUSS param[0] tunes the exponent and thus cutoff frequency For SWS\\_LANCZOS param[0] tunes the width of the window function
# Returns
a pointer to an allocated context, or NULL in case of error
"""
function sws_getContext(srcW::Integer, srcH::Integer, srcFormat::AVPixelFormat, dstW::Integer, dstH::Integer, dstFormat::AVPixelFormat, flags::Integer, srcFilter, dstFilter, param)
    ccall((:sws_getContext, libswscale), Ptr{SwsContext}, (Cint, Cint, AVPixelFormat, Cint, Cint, AVPixelFormat, Cint, Ptr{SwsFilter}, Ptr{SwsFilter}, Ptr{Cdouble}), srcW, srcH, srcFormat, dstW, dstH, dstFormat, flags, srcFilter, dstFilter, param)
end

"""
    sws_scale(c, srcSlice, srcStride, srcSliceY::Integer, srcSliceH::Integer, dst, dstStride)

Scale the image slice in srcSlice and put the resulting scaled slice in the image in dst. A slice is a sequence of consecutive rows in an image. Requires a context that has been previously been initialized with [`sws_init_context`](@ref)().

Slices have to be provided in sequential order, either in top-bottom or bottom-top order. If slices are provided in non-sequential order the behavior of the function is undefined.

# Arguments
* `c`: the scaling context previously created with [`sws_getContext`](@ref)()
* `srcSlice`: the array containing the pointers to the planes of the source slice
* `srcStride`: the array containing the strides for each plane of the source image
* `srcSliceY`: the position in the source image of the slice to process, that is the number (counted starting from zero) in the image of the first row of the slice
* `srcSliceH`: the height of the source slice, that is the number of rows in the slice
* `dst`: the array containing the pointers to the planes of the destination image
* `dstStride`: the array containing the strides for each plane of the destination image
# Returns
the height of the output slice
"""
function sws_scale(c, srcSlice, srcStride, srcSliceY::Integer, srcSliceH::Integer, dst, dstStride)
    ccall((:sws_scale, libswscale), Cint, (Ptr{SwsContext}, Ptr{Ptr{UInt8}}, Ptr{Cint}, Cint, Cint, Ptr{Ptr{UInt8}}, Ptr{Cint}), c, srcSlice, srcStride, srcSliceY, srcSliceH, dst, dstStride)
end

"""
    sws_frame_start(c, dst, src)

Initialize the scaling process for a given pair of source/destination frames. Must be called before any calls to [`sws_send_slice`](@ref)() and [`sws_receive_slice`](@ref)(). Requires a context that has been previously been initialized with [`sws_init_context`](@ref)().

This function will retain references to src and dst, so they must both use refcounted buffers (if allocated by the caller, in case of dst).

The data buffers may either be already allocated by the caller or left clear, in which case they will be allocated by the scaler. The latter may have performance advantages - e.g. in certain cases some output planes may be references to input planes, rather than copies.

Output data will be written into this frame in successful [`sws_receive_slice`](@ref)() calls.

# Arguments
* `c`: The scaling context
* `dst`: The destination frame.
* `src`: The source frame. The data buffers must be allocated, but the frame data does not have to be ready at this point. Data availability is then signalled by [`sws_send_slice`](@ref)().
# Returns
0 on success, a negative [`AVERROR`](@ref) code on failure
# See also
[`sws_frame_end`](@ref)()
"""
function sws_frame_start(c, dst, src)
    ccall((:sws_frame_start, libswscale), Cint, (Ptr{SwsContext}, Ptr{AVFrame}, Ptr{AVFrame}), c, dst, src)
end

"""
    sws_frame_end(c)

Finish the scaling process for a pair of source/destination frames previously submitted with [`sws_frame_start`](@ref)(). Must be called after all [`sws_send_slice`](@ref)() and [`sws_receive_slice`](@ref)() calls are done, before any new [`sws_frame_start`](@ref)() calls.

# Arguments
* `c`: The scaling context
"""
function sws_frame_end(c)
    ccall((:sws_frame_end, libswscale), Cvoid, (Ptr{SwsContext},), c)
end

"""
    sws_send_slice(c, slice_start::Integer, slice_height::Integer)

Indicate that a horizontal slice of input data is available in the source frame previously provided to [`sws_frame_start`](@ref)(). The slices may be provided in any order, but may not overlap. For vertically subsampled pixel formats, the slices must be aligned according to subsampling.

# Arguments
* `c`: The scaling context
* `slice_start`: first row of the slice
* `slice_height`: number of rows in the slice
# Returns
a non-negative number on success, a negative [`AVERROR`](@ref) code on failure.
"""
function sws_send_slice(c, slice_start::Integer, slice_height::Integer)
    ccall((:sws_send_slice, libswscale), Cint, (Ptr{SwsContext}, Cuint, Cuint), c, slice_start, slice_height)
end

"""
    sws_receive_slice(c, slice_start::Integer, slice_height::Integer)

Request a horizontal slice of the output data to be written into the frame previously provided to [`sws_frame_start`](@ref)().

# Arguments
* `c`: The scaling context
* `slice_start`: first row of the slice; must be a multiple of [`sws_receive_slice_alignment`](@ref)()
* `slice_height`: number of rows in the slice; must be a multiple of [`sws_receive_slice_alignment`](@ref)(), except for the last slice (i.e. when slice\\_start+slice\\_height is equal to output frame height)
# Returns
a non-negative number if the data was successfully written into the output [`AVERROR`](@ref)(EAGAIN) if more input data needs to be provided before the output can be produced another negative [`AVERROR`](@ref) code on other kinds of scaling failure
"""
function sws_receive_slice(c, slice_start::Integer, slice_height::Integer)
    ccall((:sws_receive_slice, libswscale), Cint, (Ptr{SwsContext}, Cuint, Cuint), c, slice_start, slice_height)
end

"""
    sws_receive_slice_alignment(c)

Get the alignment required for slices. Requires a context that has been previously been initialized with [`sws_init_context`](@ref)().

# Arguments
* `c`: The scaling context
# Returns
alignment required for output slices requested with [`sws_receive_slice`](@ref)(). Slice offsets and sizes passed to [`sws_receive_slice`](@ref)() must be multiples of the value returned from this function.
"""
function sws_receive_slice_alignment(c)
    ccall((:sws_receive_slice_alignment, libswscale), Cuint, (Ptr{SwsContext},), c)
end

"""
    sws_setColorspaceDetails(c, inv_table, srcRange::Integer, table, dstRange::Integer, brightness::Integer, contrast::Integer, saturation::Integer)

# Arguments
* `c`: the scaling context
* `dstRange`: flag indicating the while-black range of the output (1=jpeg / 0=mpeg)
* `srcRange`: flag indicating the while-black range of the input (1=jpeg / 0=mpeg)
* `table`: the yuv2rgb coefficients describing the output yuv space, normally ff\\_yuv2rgb\\_coeffs[x]
* `inv_table`: the yuv2rgb coefficients describing the input yuv space, normally ff\\_yuv2rgb\\_coeffs[x]
* `brightness`: 16.16 fixed point brightness correction
* `contrast`: 16.16 fixed point contrast correction
* `saturation`: 16.16 fixed point saturation correction
# Returns
A negative error code on error, non negative otherwise. If `[`LIBSWSCALE_VERSION_MAJOR`](@ref) < 7`, returns -1 if not supported.
"""
function sws_setColorspaceDetails(c, inv_table, srcRange::Integer, table, dstRange::Integer, brightness::Integer, contrast::Integer, saturation::Integer)
    ccall((:sws_setColorspaceDetails, libswscale), Cint, (Ptr{SwsContext}, Ptr{Cint}, Cint, Ptr{Cint}, Cint, Cint, Cint, Cint), c, inv_table, srcRange, table, dstRange, brightness, contrast, saturation)
end

"""
    sws_getColorspaceDetails(c, inv_table, srcRange, table, dstRange, brightness, contrast, saturation)

# Returns
A negative error code on error, non negative otherwise. If `[`LIBSWSCALE_VERSION_MAJOR`](@ref) < 7`, returns -1 if not supported.
"""
function sws_getColorspaceDetails(c, inv_table, srcRange, table, dstRange, brightness, contrast, saturation)
    ccall((:sws_getColorspaceDetails, libswscale), Cint, (Ptr{SwsContext}, Ptr{Ptr{Cint}}, Ptr{Cint}, Ptr{Ptr{Cint}}, Ptr{Cint}, Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), c, inv_table, srcRange, table, dstRange, brightness, contrast, saturation)
end

"""
    sws_allocVec(length::Integer)

Allocate and return an uninitialized vector with length coefficients.
"""
function sws_allocVec(length::Integer)
    ccall((:sws_allocVec, libswscale), Ptr{SwsVector}, (Cint,), length)
end

"""
    sws_getGaussianVec(variance::Cdouble, quality::Cdouble)

Return a normalized Gaussian curve used to filter stuff quality = 3 is high quality, lower is lower quality.
"""
function sws_getGaussianVec(variance::Cdouble, quality::Cdouble)
    ccall((:sws_getGaussianVec, libswscale), Ptr{SwsVector}, (Cdouble, Cdouble), variance, quality)
end

"""
    sws_scaleVec(a, scalar::Cdouble)

Scale all the coefficients of a by the scalar value.
"""
function sws_scaleVec(a, scalar::Cdouble)
    ccall((:sws_scaleVec, libswscale), Cvoid, (Ptr{SwsVector}, Cdouble), a, scalar)
end

"""
    sws_normalizeVec(a, height::Cdouble)

Scale all the coefficients of a so that their sum equals height.
"""
function sws_normalizeVec(a, height::Cdouble)
    ccall((:sws_normalizeVec, libswscale), Cvoid, (Ptr{SwsVector}, Cdouble), a, height)
end

function sws_freeVec(a)
    ccall((:sws_freeVec, libswscale), Cvoid, (Ptr{SwsVector},), a)
end

function sws_getDefaultFilter(lumaGBlur::Cfloat, chromaGBlur::Cfloat, lumaSharpen::Cfloat, chromaSharpen::Cfloat, chromaHShift::Cfloat, chromaVShift::Cfloat, verbose::Integer)
    ccall((:sws_getDefaultFilter, libswscale), Ptr{SwsFilter}, (Cfloat, Cfloat, Cfloat, Cfloat, Cfloat, Cfloat, Cint), lumaGBlur, chromaGBlur, lumaSharpen, chromaSharpen, chromaHShift, chromaVShift, verbose)
end

function sws_freeFilter(filter)
    ccall((:sws_freeFilter, libswscale), Cvoid, (Ptr{SwsFilter},), filter)
end

"""
    sws_getCachedContext(context, srcW::Integer, srcH::Integer, srcFormat::AVPixelFormat, dstW::Integer, dstH::Integer, dstFormat::AVPixelFormat, flags::Integer, srcFilter, dstFilter, param)

Check if context can be reused, otherwise reallocate a new one.

If context is NULL, just calls [`sws_getContext`](@ref)() to get a new context. Otherwise, checks if the parameters are the ones already saved in context. If that is the case, returns the current context. Otherwise, frees context and gets a new context with the new parameters.

Be warned that srcFilter and dstFilter are not checked, they are assumed to remain the same.
"""
function sws_getCachedContext(context, srcW::Integer, srcH::Integer, srcFormat::AVPixelFormat, dstW::Integer, dstH::Integer, dstFormat::AVPixelFormat, flags::Integer, srcFilter, dstFilter, param)
    ccall((:sws_getCachedContext, libswscale), Ptr{SwsContext}, (Ptr{SwsContext}, Cint, Cint, AVPixelFormat, Cint, Cint, AVPixelFormat, Cint, Ptr{SwsFilter}, Ptr{SwsFilter}, Ptr{Cdouble}), context, srcW, srcH, srcFormat, dstW, dstH, dstFormat, flags, srcFilter, dstFilter, param)
end

"""
    sws_convertPalette8ToPacked32(src, dst, num_pixels::Integer, palette)

Convert an 8-bit paletted frame into a frame with a color depth of 32 bits.

The output frame will have the same packed format as the palette.

# Arguments
* `src`: source frame buffer
* `dst`: destination frame buffer
* `num_pixels`: number of pixels to convert
* `palette`: array with [256] entries, which must match color arrangement (RGB or BGR) of src
"""
function sws_convertPalette8ToPacked32(src, dst, num_pixels::Integer, palette)
    ccall((:sws_convertPalette8ToPacked32, libswscale), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}), src, dst, num_pixels, palette)
end

"""
    sws_convertPalette8ToPacked24(src, dst, num_pixels::Integer, palette)

Convert an 8-bit paletted frame into a frame with a color depth of 24 bits.

With the palette format "ABCD", the destination frame ends up with the format "ABC".

# Arguments
* `src`: source frame buffer
* `dst`: destination frame buffer
* `num_pixels`: number of pixels to convert
* `palette`: array with [256] entries, which must match color arrangement (RGB or BGR) of src
"""
function sws_convertPalette8ToPacked24(src, dst, num_pixels::Integer, palette)
    ccall((:sws_convertPalette8ToPacked24, libswscale), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Cint, Ptr{UInt8}), src, dst, num_pixels, palette)
end

const AV_AAC_ADTS_HEADER_SIZE = 7

const AV_CODEC_FLAG_UNALIGNED = 1 << 0

const AV_CODEC_FLAG_QSCALE = 1 << 1

const AV_CODEC_FLAG_4MV = 1 << 2

const AV_CODEC_FLAG_OUTPUT_CORRUPT = 1 << 3

const AV_CODEC_FLAG_QPEL = 1 << 4

const AV_CODEC_FLAG_RECON_FRAME = 1 << 6

const AV_CODEC_FLAG_COPY_OPAQUE = 1 << 7

const AV_CODEC_FLAG_FRAME_DURATION = 1 << 8

const AV_CODEC_FLAG_PASS1 = 1 << 9

const AV_CODEC_FLAG_PASS2 = 1 << 10

const AV_CODEC_FLAG_LOOP_FILTER = 1 << 11

const AV_CODEC_FLAG_GRAY = 1 << 13

const AV_CODEC_FLAG_PSNR = 1 << 15

const AV_CODEC_FLAG_INTERLACED_DCT = 1 << 18

const AV_CODEC_FLAG_LOW_DELAY = 1 << 19

const AV_CODEC_FLAG_GLOBAL_HEADER = 1 << 22

const AV_CODEC_FLAG_BITEXACT = 1 << 23

const AV_CODEC_FLAG_AC_PRED = 1 << 24

const AV_CODEC_FLAG_INTERLACED_ME = 1 << 29

const AV_CODEC_FLAG_CLOSED_GOP = Cuint(1) << 31

const AV_CODEC_FLAG2_FAST = 1 << 0

const AV_CODEC_FLAG2_NO_OUTPUT = 1 << 2

const AV_CODEC_FLAG2_LOCAL_HEADER = 1 << 3

const AV_CODEC_FLAG2_CHUNKS = 1 << 15

const AV_CODEC_FLAG2_IGNORE_CROP = 1 << 16

const AV_CODEC_FLAG2_SHOW_ALL = 1 << 22

const AV_CODEC_FLAG2_EXPORT_MVS = 1 << 28

const AV_CODEC_FLAG2_SKIP_MANUAL = 1 << 29

const AV_CODEC_FLAG2_RO_FLUSH_NOOP = 1 << 30

const AV_CODEC_FLAG2_ICC_PROFILES = Cuint(1) << 31

const AV_CODEC_EXPORT_DATA_MVS = 1 << 0

const AV_CODEC_EXPORT_DATA_PRFT = 1 << 1

const AV_CODEC_EXPORT_DATA_VIDEO_ENC_PARAMS = 1 << 2

const AV_CODEC_EXPORT_DATA_FILM_GRAIN = 1 << 3

const AV_CODEC_EXPORT_DATA_ENHANCEMENTS = 1 << 4

const AV_GET_BUFFER_FLAG_REF = 1 << 0

const AV_GET_ENCODE_BUFFER_FLAG_REF = 1 << 0

const SLICE_FLAG_CODED_ORDER = 0x0001

const SLICE_FLAG_ALLOW_FIELD = 0x0002

const SLICE_FLAG_ALLOW_PLANE = 0x0004

const FF_CMP_SAD = 0

const FF_CMP_SSE = 1

const FF_CMP_SATD = 2

const FF_CMP_DCT = 3

const FF_CMP_PSNR = 4

const FF_CMP_BIT = 5

const FF_CMP_RD = 6

const FF_CMP_ZERO = 7

const FF_CMP_VSAD = 8

const FF_CMP_VSSE = 9

const FF_CMP_NSSE = 10

const FF_CMP_W53 = 11

const FF_CMP_W97 = 12

const FF_CMP_DCTMAX = 13

const FF_CMP_DCT264 = 14

const FF_CMP_MEDIAN_SAD = 15

const FF_CMP_CHROMA = 256

const FF_MB_DECISION_SIMPLE = 0

const FF_MB_DECISION_BITS = 1

const FF_MB_DECISION_RD = 2

const FF_COMPRESSION_DEFAULT = -1

const FF_BUG_AUTODETECT = 1

const FF_BUG_XVID_ILACE = 4

const FF_BUG_UMP4 = 8

const FF_BUG_NO_PADDING = 16

const FF_BUG_AMV = 32

const FF_BUG_QPEL_CHROMA = 64

const FF_BUG_STD_QPEL = 128

const FF_BUG_QPEL_CHROMA2 = 256

const FF_BUG_DIRECT_BLOCKSIZE = 512

const FF_BUG_EDGE = 1024

const FF_BUG_HPEL_CHROMA = 2048

const FF_BUG_DC_CLIP = 4096

const FF_BUG_MS = 8192

const FF_BUG_TRUNCATED = 16384

const FF_BUG_IEDGE = 32768

const FF_EC_GUESS_MVS = 1

const FF_EC_DEBLOCK = 2

const FF_EC_FAVOR_INTER = 256

const FF_DEBUG_PICT_INFO = 1

const FF_DEBUG_RC = 2

const FF_DEBUG_BITSTREAM = 4

const FF_DEBUG_MB_TYPE = 8

const FF_DEBUG_QP = 16

const FF_DEBUG_DCT_COEFF = 0x00000040

const FF_DEBUG_SKIP = 0x00000080

const FF_DEBUG_STARTCODE = 0x00000100

const FF_DEBUG_ER = 0x00000400

const FF_DEBUG_MMCO = 0x00000800

const FF_DEBUG_BUGS = 0x00001000

const FF_DEBUG_BUFFERS = 0x00008000

const FF_DEBUG_THREADS = 0x00010000

const FF_DEBUG_GREEN_MD = 0x00800000

const FF_DEBUG_NOMC = 0x01000000

const FF_DCT_AUTO = 0

const FF_DCT_FASTINT = 1

const FF_DCT_INT = 2

const FF_DCT_MMX = 3

const FF_DCT_ALTIVEC = 5

const FF_DCT_FAAN = 6

const FF_DCT_NEON = 7

const FF_IDCT_AUTO = 0

const FF_IDCT_INT = 1

const FF_IDCT_SIMPLE = 2

const FF_IDCT_SIMPLEMMX = 3

const FF_IDCT_ARM = 7

const FF_IDCT_ALTIVEC = 8

const FF_IDCT_SIMPLEARM = 10

const FF_IDCT_XVID = 14

const FF_IDCT_SIMPLEARMV5TE = 16

const FF_IDCT_SIMPLEARMV6 = 17

const FF_IDCT_FAAN = 20

const FF_IDCT_SIMPLENEON = 22

const FF_IDCT_SIMPLEAUTO = 128

const FF_THREAD_FRAME = 1

const FF_THREAD_SLICE = 2

const FF_CODEC_PROPERTY_LOSSLESS = 0x00000001

const FF_CODEC_PROPERTY_CLOSED_CAPTIONS = 0x00000002

const FF_CODEC_PROPERTY_FILM_GRAIN = 0x00000004

const FF_SUB_CHARENC_MODE_DO_NOTHING = -1

const FF_SUB_CHARENC_MODE_AUTOMATIC = 0

const FF_SUB_CHARENC_MODE_PRE_DECODER = 1

const FF_SUB_CHARENC_MODE_IGNORE = 2

const AV_HWACCEL_CODEC_CAP_EXPERIMENTAL = 0x0200

const AV_HWACCEL_FLAG_IGNORE_LEVEL = 1 << 0

const AV_HWACCEL_FLAG_ALLOW_HIGH_DEPTH = 1 << 1

const AV_HWACCEL_FLAG_ALLOW_PROFILE_MISMATCH = 1 << 2

const AV_HWACCEL_FLAG_UNSAFE_OUTPUT = 1 << 3

const AV_SUBTITLE_FLAG_FORCED = 0x00000001

const AV_PARSER_PTS_NB = 4

const PARSER_FLAG_COMPLETE_FRAMES = 0x0001

const PARSER_FLAG_ONCE = 0x0002

const PARSER_FLAG_FETCHED_OFFSET = 0x0004

const PARSER_FLAG_USE_CODEC_TS = 0x1000

const AV_CODEC_CAP_DRAW_HORIZ_BAND = 1 << 0

const AV_CODEC_CAP_DR1 = 1 << 1

const AV_CODEC_CAP_DELAY = 1 << 5

const AV_CODEC_CAP_SMALL_LAST_FRAME = 1 << 6

const AV_CODEC_CAP_EXPERIMENTAL = 1 << 9

const AV_CODEC_CAP_CHANNEL_CONF = 1 << 10

const AV_CODEC_CAP_FRAME_THREADS = 1 << 12

const AV_CODEC_CAP_SLICE_THREADS = 1 << 13

const AV_CODEC_CAP_PARAM_CHANGE = 1 << 14

const AV_CODEC_CAP_OTHER_THREADS = 1 << 15

const AV_CODEC_CAP_VARIABLE_FRAME_SIZE = 1 << 16

const AV_CODEC_CAP_AVOID_PROBING = 1 << 17

const AV_CODEC_CAP_HARDWARE = 1 << 18

const AV_CODEC_CAP_HYBRID = 1 << 19

const AV_CODEC_CAP_ENCODER_REORDERED_OPAQUE = 1 << 20

const AV_CODEC_CAP_ENCODER_FLUSH = 1 << 21

const AV_CODEC_CAP_ENCODER_RECON_FRAME = 1 << 22

const AV_CODEC_PROP_INTRA_ONLY = 1 << 0

const AV_CODEC_PROP_LOSSY = 1 << 1

const AV_CODEC_PROP_LOSSLESS = 1 << 2

const AV_CODEC_PROP_REORDER = 1 << 3

const AV_CODEC_PROP_FIELDS = 1 << 4

const AV_CODEC_PROP_BITMAP_SUB = 1 << 16

const AV_CODEC_PROP_TEXT_SUB = 1 << 17

const AV_CODEC_ID_IFF_BYTERUN1 = AV_CODEC_ID_IFF_ILBM

const AV_CODEC_ID_H265 = AV_CODEC_ID_HEVC

const AV_CODEC_ID_H266 = AV_CODEC_ID_VVC

const _WIN32_WINNT = 0x0602

const AV_INPUT_BUFFER_PADDING_SIZE = 64

const AV_EF_CRCCHECK = 1 << 0

const AV_EF_BITSTREAM = 1 << 1

const AV_EF_BUFFER = 1 << 2

const AV_EF_EXPLODE = 1 << 3

const AV_EF_IGNORE_ERR = 1 << 15

const AV_EF_CAREFUL = 1 << 16

const AV_EF_COMPLIANT = 1 << 17

const AV_EF_AGGRESSIVE = 1 << 18

const FF_COMPLIANCE_VERY_STRICT = 2

const FF_COMPLIANCE_STRICT = 1

const FF_COMPLIANCE_NORMAL = 0

const FF_COMPLIANCE_UNOFFICIAL = -1

const FF_COMPLIANCE_EXPERIMENTAL = -2

const AV_PROFILE_UNKNOWN = -99

const AV_PROFILE_RESERVED = -100

const AV_PROFILE_AAC_MAIN = 0

const AV_PROFILE_AAC_LOW = 1

const AV_PROFILE_AAC_SSR = 2

const AV_PROFILE_AAC_LTP = 3

const AV_PROFILE_AAC_HE = 4

const AV_PROFILE_AAC_HE_V2 = 28

const AV_PROFILE_AAC_LD = 22

const AV_PROFILE_AAC_ELD = 38

const AV_PROFILE_AAC_USAC = 41

const AV_PROFILE_MPEG2_AAC_LOW = 128

const AV_PROFILE_MPEG2_AAC_HE = 131

const AV_PROFILE_DNXHD = 0

const AV_PROFILE_DNXHR_LB = 1

const AV_PROFILE_DNXHR_SQ = 2

const AV_PROFILE_DNXHR_HQ = 3

const AV_PROFILE_DNXHR_HQX = 4

const AV_PROFILE_DNXHR_444 = 5

const AV_PROFILE_DTS = 20

const AV_PROFILE_DTS_ES = 30

const AV_PROFILE_DTS_96_24 = 40

const AV_PROFILE_DTS_HD_HRA = 50

const AV_PROFILE_DTS_HD_MA = 60

const AV_PROFILE_DTS_EXPRESS = 70

const AV_PROFILE_DTS_HD_MA_X = 61

const AV_PROFILE_DTS_HD_MA_X_IMAX = 62

const AV_PROFILE_EAC3_DDP_ATMOS = 30

const AV_PROFILE_TRUEHD_ATMOS = 30

const AV_PROFILE_MPEG2_422 = 0

const AV_PROFILE_MPEG2_HIGH = 1

const AV_PROFILE_MPEG2_SS = 2

const AV_PROFILE_MPEG2_SNR_SCALABLE = 3

const AV_PROFILE_MPEG2_MAIN = 4

const AV_PROFILE_MPEG2_SIMPLE = 5

const AV_PROFILE_H264_CONSTRAINED = 1 << 9

const AV_PROFILE_H264_INTRA = 1 << 11

const AV_PROFILE_H264_BASELINE = 66

const AV_PROFILE_H264_CONSTRAINED_BASELINE = 66 | AV_PROFILE_H264_CONSTRAINED

const AV_PROFILE_H264_MAIN = 77

const AV_PROFILE_H264_EXTENDED = 88

const AV_PROFILE_H264_HIGH = 100

const AV_PROFILE_H264_HIGH_10 = 110

const AV_PROFILE_H264_HIGH_10_INTRA = 110 | AV_PROFILE_H264_INTRA

const AV_PROFILE_H264_MULTIVIEW_HIGH = 118

const AV_PROFILE_H264_HIGH_422 = 122

const AV_PROFILE_H264_HIGH_422_INTRA = 122 | AV_PROFILE_H264_INTRA

const AV_PROFILE_H264_STEREO_HIGH = 128

const AV_PROFILE_H264_HIGH_444 = 144

const AV_PROFILE_H264_HIGH_444_PREDICTIVE = 244

const AV_PROFILE_H264_HIGH_444_INTRA = 244 | AV_PROFILE_H264_INTRA

const AV_PROFILE_H264_CAVLC_444 = 44

const AV_PROFILE_VC1_SIMPLE = 0

const AV_PROFILE_VC1_MAIN = 1

const AV_PROFILE_VC1_COMPLEX = 2

const AV_PROFILE_VC1_ADVANCED = 3

const AV_PROFILE_MPEG4_SIMPLE = 0

const AV_PROFILE_MPEG4_SIMPLE_SCALABLE = 1

const AV_PROFILE_MPEG4_CORE = 2

const AV_PROFILE_MPEG4_MAIN = 3

const AV_PROFILE_MPEG4_N_BIT = 4

const AV_PROFILE_MPEG4_SCALABLE_TEXTURE = 5

const AV_PROFILE_MPEG4_SIMPLE_FACE_ANIMATION = 6

const AV_PROFILE_MPEG4_BASIC_ANIMATED_TEXTURE = 7

const AV_PROFILE_MPEG4_HYBRID = 8

const AV_PROFILE_MPEG4_ADVANCED_REAL_TIME = 9

const AV_PROFILE_MPEG4_CORE_SCALABLE = 10

const AV_PROFILE_MPEG4_ADVANCED_CODING = 11

const AV_PROFILE_MPEG4_ADVANCED_CORE = 12

const AV_PROFILE_MPEG4_ADVANCED_SCALABLE_TEXTURE = 13

const AV_PROFILE_MPEG4_SIMPLE_STUDIO = 14

const AV_PROFILE_MPEG4_ADVANCED_SIMPLE = 15

const AV_PROFILE_JPEG2000_CSTREAM_RESTRICTION_0 = 1

const AV_PROFILE_JPEG2000_CSTREAM_RESTRICTION_1 = 2

const AV_PROFILE_JPEG2000_CSTREAM_NO_RESTRICTION = 32768

const AV_PROFILE_JPEG2000_DCINEMA_2K = 3

const AV_PROFILE_JPEG2000_DCINEMA_4K = 4

const AV_PROFILE_VP9_0 = 0

const AV_PROFILE_VP9_1 = 1

const AV_PROFILE_VP9_2 = 2

const AV_PROFILE_VP9_3 = 3

const AV_PROFILE_HEVC_MAIN = 1

const AV_PROFILE_HEVC_MAIN_10 = 2

const AV_PROFILE_HEVC_MAIN_STILL_PICTURE = 3

const AV_PROFILE_HEVC_REXT = 4

const AV_PROFILE_HEVC_MULTIVIEW_MAIN = 6

const AV_PROFILE_HEVC_SCC = 9

const AV_PROFILE_VVC_MAIN_10 = 1

const AV_PROFILE_VVC_MAIN_10_444 = 33

const AV_PROFILE_AV1_MAIN = 0

const AV_PROFILE_AV1_HIGH = 1

const AV_PROFILE_AV1_PROFESSIONAL = 2

const AV_PROFILE_MJPEG_HUFFMAN_BASELINE_DCT = 0xc0

const AV_PROFILE_MJPEG_HUFFMAN_EXTENDED_SEQUENTIAL_DCT = 0xc1

const AV_PROFILE_MJPEG_HUFFMAN_PROGRESSIVE_DCT = 0xc2

const AV_PROFILE_MJPEG_HUFFMAN_LOSSLESS = 0xc3

const AV_PROFILE_MJPEG_JPEG_LS = 0xf7

const AV_PROFILE_SBC_MSBC = 1

const AV_PROFILE_PRORES_PROXY = 0

const AV_PROFILE_PRORES_LT = 1

const AV_PROFILE_PRORES_STANDARD = 2

const AV_PROFILE_PRORES_HQ = 3

const AV_PROFILE_PRORES_4444 = 4

const AV_PROFILE_PRORES_XQ = 5

const AV_PROFILE_PRORES_RAW = 0

const AV_PROFILE_PRORES_RAW_HQ = 1

const AV_PROFILE_ARIB_PROFILE_A = 0

const AV_PROFILE_ARIB_PROFILE_C = 1

const AV_PROFILE_KLVA_SYNC = 0

const AV_PROFILE_KLVA_ASYNC = 1

const AV_PROFILE_EVC_BASELINE = 0

const AV_PROFILE_EVC_MAIN = 1

const AV_PROFILE_APV_422_10 = 33

const AV_PROFILE_APV_422_12 = 44

const AV_PROFILE_APV_444_10 = 55

const AV_PROFILE_APV_444_12 = 66

const AV_PROFILE_APV_4444_10 = 77

const AV_PROFILE_APV_4444_12 = 88

const AV_PROFILE_APV_400_10 = 99

const AV_LEVEL_UNKNOWN = -99

const MAX_DWT_LEVELS = 5

const DV_PROFILE_BYTES = 6 * 80

const AV_PKT_FLAG_KEY = 0x0001

const AV_PKT_FLAG_CORRUPT = 0x0002

const AV_PKT_FLAG_DISCARD = 0x0004

const AV_PKT_FLAG_TRUSTED = 0x0008

const AV_PKT_FLAG_DISPOSABLE = 0x0010

const AV_SMPTE_291M_ANC_PAYLOAD_CAPACITY = 0xff

const AV_SMPTE_436M_CODED_ANC_SAMPLE_CAPACITY = AV_SMPTE_291M_ANC_PAYLOAD_CAPACITY + 4

const AV_SMPTE_436M_CODED_ANC_PAYLOAD_CAPACITY = ((AV_SMPTE_436M_CODED_ANC_SAMPLE_CAPACITY + 2) ÷ 3) * 4

const AV_SMPTE_291M_ANC_DID_CTA_708 = 0x61

const AV_SMPTE_291M_ANC_SDID_CTA_708 = 0x01

const LIBAVCODEC_VERSION_MINOR = 11

const LIBAVCODEC_VERSION_MICRO = 100

const LIBAVCODEC_VERSION_MAJOR = 62

const LIBAVCODEC_VERSION_INT = AV_VERSION_INT(LIBAVCODEC_VERSION_MAJOR, LIBAVCODEC_VERSION_MINOR, LIBAVCODEC_VERSION_MICRO)

const LIBAVCODEC_VERSION = AV_VERSION(LIBAVCODEC_VERSION_MAJOR, LIBAVCODEC_VERSION_MINOR, LIBAVCODEC_VERSION_MICRO)

const LIBAVCODEC_BUILD = LIBAVCODEC_VERSION_INT

const FF_API_INIT_PACKET = LIBAVCODEC_VERSION_MAJOR < 63

const FF_API_V408_CODECID = LIBAVCODEC_VERSION_MAJOR < 63

const FF_API_CODEC_PROPS = LIBAVCODEC_VERSION_MAJOR < 63

const FF_API_EXR_GAMMA = LIBAVCODEC_VERSION_MAJOR < 63

const FF_API_NVDEC_OLD_PIX_FMTS = LIBAVCODEC_VERSION_MAJOR < 63

const FF_CODEC_OMX = LIBAVCODEC_VERSION_MAJOR < 63

const FF_CODEC_SONIC_ENC = LIBAVCODEC_VERSION_MAJOR < 63

const FF_CODEC_SONIC_DEC = LIBAVCODEC_VERSION_MAJOR < 63

const VORBIS_FLAG_HEADER = 0x00000001

const VORBIS_FLAG_COMMENT = 0x00000002

const VORBIS_FLAG_SETUP = 0x00000004

const LIBAVDEVICE_VERSION_MINOR = 1

const LIBAVDEVICE_VERSION_MICRO = 100

const LIBAVDEVICE_VERSION_MAJOR = 62

const LIBAVDEVICE_VERSION_INT = AV_VERSION_INT(LIBAVDEVICE_VERSION_MAJOR, LIBAVDEVICE_VERSION_MINOR, LIBAVDEVICE_VERSION_MICRO)

const LIBAVDEVICE_VERSION = AV_VERSION(LIBAVDEVICE_VERSION_MAJOR, LIBAVDEVICE_VERSION_MINOR, LIBAVDEVICE_VERSION_MICRO)

const LIBAVDEVICE_BUILD = LIBAVDEVICE_VERSION_INT

const FF_API_ALSA_CHANNELS = LIBAVDEVICE_VERSION_MAJOR < 63

const AVFILTER_FLAG_DYNAMIC_INPUTS = 1 << 0

const AVFILTER_FLAG_DYNAMIC_OUTPUTS = 1 << 1

const AVFILTER_FLAG_SLICE_THREADS = 1 << 2

const AVFILTER_FLAG_METADATA_ONLY = 1 << 3

const AVFILTER_FLAG_HWDEVICE = 1 << 4

const AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC = 1 << 16

const AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL = 1 << 17

const AVFILTER_FLAG_SUPPORT_TIMELINE = AVFILTER_FLAG_SUPPORT_TIMELINE_GENERIC | AVFILTER_FLAG_SUPPORT_TIMELINE_INTERNAL

const AVFILTER_THREAD_SLICE = 1 << 0

const AVFILTER_CMD_FLAG_ONE = 1

const AVFILTER_CMD_FLAG_FAST = 2

const AV_BUFFERSINK_FLAG_PEEK = 1

const AV_BUFFERSINK_FLAG_NO_REQUEST = 2

const LIBAVFILTER_VERSION_MINOR = 4

const LIBAVFILTER_VERSION_MICRO = 100

const LIBAVFILTER_VERSION_MAJOR = 11

const LIBAVFILTER_VERSION_INT = AV_VERSION_INT(LIBAVFILTER_VERSION_MAJOR, LIBAVFILTER_VERSION_MINOR, LIBAVFILTER_VERSION_MICRO)

const LIBAVFILTER_VERSION = AV_VERSION(LIBAVFILTER_VERSION_MAJOR, LIBAVFILTER_VERSION_MINOR, LIBAVFILTER_VERSION_MICRO)

const LIBAVFILTER_BUILD = LIBAVFILTER_VERSION_INT

const FF_API_BUFFERSINK_OPTS = LIBAVFILTER_VERSION_MAJOR < 12

const FF_API_CONTEXT_PUBLIC = LIBAVFILTER_VERSION_MAJOR < 12

const AVPROBE_SCORE_RETRY = AVPROBE_SCORE_MAX ÷ 4

const AVPROBE_SCORE_STREAM_RETRY = AVPROBE_SCORE_MAX ÷ 4 - 1

const AVPROBE_SCORE_EXTENSION = 50

const AVPROBE_SCORE_MIME_BONUS = 30

const AVPROBE_PADDING_SIZE = 32

const AVFMT_NOFILE = 0x0001

const AVFMT_NEEDNUMBER = 0x0002

const AVFMT_EXPERIMENTAL = 0x0004

const AVFMT_SHOW_IDS = 0x0008

const AVFMT_GLOBALHEADER = 0x0040

const AVFMT_NOTIMESTAMPS = 0x0080

const AVFMT_GENERIC_INDEX = 0x0100

const AVFMT_TS_DISCONT = 0x0200

const AVFMT_VARIABLE_FPS = 0x0400

const AVFMT_NODIMENSIONS = 0x0800

const AVFMT_NOSTREAMS = 0x1000

const AVFMT_NOBINSEARCH = 0x2000

const AVFMT_NOGENSEARCH = 0x4000

const AVFMT_NO_BYTE_SEEK = 0x8000

const AVFMT_TS_NONSTRICT = 0x00020000

const AVFMT_TS_NEGATIVE = 0x00040000

const AVFMT_SEEK_TO_PTS = 0x04000000

const AVINDEX_KEYFRAME = 0x0001

const AVINDEX_DISCARD_FRAME = 0x0002

const AV_DISPOSITION_DEFAULT = 1 << 0

const AV_DISPOSITION_DUB = 1 << 1

const AV_DISPOSITION_ORIGINAL = 1 << 2

const AV_DISPOSITION_COMMENT = 1 << 3

const AV_DISPOSITION_LYRICS = 1 << 4

const AV_DISPOSITION_KARAOKE = 1 << 5

const AV_DISPOSITION_FORCED = 1 << 6

const AV_DISPOSITION_HEARING_IMPAIRED = 1 << 7

const AV_DISPOSITION_VISUAL_IMPAIRED = 1 << 8

const AV_DISPOSITION_CLEAN_EFFECTS = 1 << 9

const AV_DISPOSITION_ATTACHED_PIC = 1 << 10

const AV_DISPOSITION_TIMED_THUMBNAILS = 1 << 11

const AV_DISPOSITION_NON_DIEGETIC = 1 << 12

const AV_DISPOSITION_CAPTIONS = 1 << 16

const AV_DISPOSITION_DESCRIPTIONS = 1 << 17

const AV_DISPOSITION_METADATA = 1 << 18

const AV_DISPOSITION_DEPENDENT = 1 << 19

const AV_DISPOSITION_STILL_IMAGE = 1 << 20

const AV_DISPOSITION_MULTILAYER = 1 << 21

const AV_PTS_WRAP_IGNORE = 0

const AV_PTS_WRAP_ADD_OFFSET = 1

const AV_PTS_WRAP_SUB_OFFSET = -1

const AVSTREAM_EVENT_FLAG_METADATA_UPDATED = 0x0001

const AVSTREAM_EVENT_FLAG_NEW_PACKETS = 1 << 1

const AV_PROGRAM_RUNNING = 1

const AVFMTCTX_NOHEADER = 0x0001

const AVFMTCTX_UNSEEKABLE = 0x0002

const AVFMT_FLAG_GENPTS = 0x0001

const AVFMT_FLAG_IGNIDX = 0x0002

const AVFMT_FLAG_NONBLOCK = 0x0004

const AVFMT_FLAG_IGNDTS = 0x0008

const AVFMT_FLAG_NOFILLIN = 0x0010

const AVFMT_FLAG_NOPARSE = 0x0020

const AVFMT_FLAG_NOBUFFER = 0x0040

const AVFMT_FLAG_CUSTOM_IO = 0x0080

const AVFMT_FLAG_DISCARD_CORRUPT = 0x0100

const AVFMT_FLAG_FLUSH_PACKETS = 0x0200

const AVFMT_FLAG_BITEXACT = 0x0400

const AVFMT_FLAG_SORT_DTS = 0x00010000

const AVFMT_FLAG_FAST_SEEK = 0x00080000

const AVFMT_FLAG_AUTO_BSF = 0x00200000

const FF_FDEBUG_TS = 0x0001

const AVFMT_EVENT_FLAG_METADATA_UPDATED = 0x0001

const AVFMT_AVOID_NEG_TS_AUTO = -1

const AVFMT_AVOID_NEG_TS_DISABLED = 0

const AVFMT_AVOID_NEG_TS_MAKE_NON_NEGATIVE = 1

const AVFMT_AVOID_NEG_TS_MAKE_ZERO = 2

const AVSEEK_FLAG_BACKWARD = 1

const AVSEEK_FLAG_BYTE = 2

const AVSEEK_FLAG_ANY = 4

const AVSEEK_FLAG_FRAME = 8

const AVSTREAM_INIT_IN_WRITE_HEADER = 0

const AVSTREAM_INIT_IN_INIT_OUTPUT = 1

const AV_FRAME_FILENAME_FLAGS_MULTIPLE = 1

const AVIO_SEEKABLE_NORMAL = 1 << 0

const AVIO_SEEKABLE_TIME = 1 << 1

const AVSEEK_SIZE = 0x00010000

const AVSEEK_FORCE = 0x00020000

const AVIO_FLAG_READ = 1

const AVIO_FLAG_WRITE = 2

const AVIO_FLAG_READ_WRITE = AVIO_FLAG_READ | AVIO_FLAG_WRITE

const AVIO_FLAG_NONBLOCK = 8

const AVIO_FLAG_DIRECT = 0x8000

const LIBAVFORMAT_VERSION_MINOR = 3

const LIBAVFORMAT_VERSION_MICRO = 100

const LIBAVFORMAT_VERSION_MAJOR = 62

const LIBAVFORMAT_VERSION_INT = AV_VERSION_INT(LIBAVFORMAT_VERSION_MAJOR, LIBAVFORMAT_VERSION_MINOR, LIBAVFORMAT_VERSION_MICRO)

const LIBAVFORMAT_VERSION = AV_VERSION(LIBAVFORMAT_VERSION_MAJOR, LIBAVFORMAT_VERSION_MINOR, LIBAVFORMAT_VERSION_MICRO)

const LIBAVFORMAT_BUILD = LIBAVFORMAT_VERSION_INT

const FF_API_COMPUTE_PKT_FIELDS2 = LIBAVFORMAT_VERSION_MAJOR < 63

const FF_API_INTERNAL_TIMING = LIBAVFORMAT_VERSION_MAJOR < 63

const FF_API_NO_DEFAULT_TLS_VERIFY = LIBAVFORMAT_VERSION_MAJOR < 63

const FF_API_R_FRAME_RATE = 1

const AES_CTR_KEY_SIZE = 16

const AES_CTR_IV_SIZE = 8

# Skipping MacroDefinition: av_always_inline __attribute__ ( ( always_inline ) ) inline

# Skipping MacroDefinition: av_extern_inline extern inline

# Skipping MacroDefinition: av_warn_unused_result __attribute__ ( ( warn_unused_result ) )

# Skipping MacroDefinition: av_noinline __attribute__ ( ( noinline ) )

# Skipping MacroDefinition: av_pure __attribute__ ( ( pure ) )

# Skipping MacroDefinition: av_const __attribute__ ( ( const ) )

# Skipping MacroDefinition: av_cold __attribute__ ( ( cold ) )

# Skipping MacroDefinition: attribute_deprecated __attribute__ ( ( deprecated ) )

# Skipping MacroDefinition: av_unused __attribute__ ( ( unused ) )

# Skipping MacroDefinition: av_used __attribute__ ( ( used ) )

# Skipping MacroDefinition: av_alias __attribute__ ( ( may_alias ) )

# Skipping MacroDefinition: av_noreturn __attribute__ ( ( noreturn ) )

const AV_LOG_PANIC = 0

const AV_HAVE_BIGENDIAN = 0

const AV_HAVE_FAST_UNALIGNED = 1

const AV_ESCAPE_FLAG_WHITESPACE = 1 << 0

const AV_ESCAPE_FLAG_STRICT = 1 << 1

const AV_ESCAPE_FLAG_XML_SINGLE_QUOTES = 1 << 2

const AV_ESCAPE_FLAG_XML_DOUBLE_QUOTES = 1 << 3

const AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES = 1

const AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS = 2

const AV_UTF8_FLAG_ACCEPT_SURROGATES = 4

const AV_UTF8_FLAG_EXCLUDE_XML_INVALID_CONTROL_CODES = 8

const AV_UTF8_FLAG_ACCEPT_ALL = (AV_UTF8_FLAG_ACCEPT_INVALID_BIG_CODES | AV_UTF8_FLAG_ACCEPT_NON_CHARACTERS) | AV_UTF8_FLAG_ACCEPT_SURROGATES

const FF_LAMBDA_SHIFT = 7

const FF_LAMBDA_SCALE = 1 << FF_LAMBDA_SHIFT

const FF_QP2LAMBDA = 118

const FF_LAMBDA_MAX = 256 * 128 - 1

const FF_QUALITY_SCALE = FF_LAMBDA_SCALE

const AV_TIME_BASE = 1000000

# Skipping MacroDefinition: AV_TIME_BASE_Q ( AVRational ) { 1 , AV_TIME_BASE }

const AV_FOURCC_MAX_STRING_SIZE = 32

const AV_BF_ROUNDS = 16

const AV_BPRINT_SIZE_AUTOMATIC = 1

const AV_BPRINT_SIZE_COUNT_ONLY = 0

const AV_BUFFER_FLAG_READONLY = 1 << 0

const AV_CH_FRONT_LEFT = Culonglong(1) << AV_CHAN_FRONT_LEFT

const AV_CH_FRONT_RIGHT = Culonglong(1) << AV_CHAN_FRONT_RIGHT

const AV_CH_FRONT_CENTER = Culonglong(1) << AV_CHAN_FRONT_CENTER

const AV_CH_LOW_FREQUENCY = Culonglong(1) << AV_CHAN_LOW_FREQUENCY

const AV_CH_BACK_LEFT = Culonglong(1) << AV_CHAN_BACK_LEFT

const AV_CH_BACK_RIGHT = Culonglong(1) << AV_CHAN_BACK_RIGHT

const AV_CH_FRONT_LEFT_OF_CENTER = Culonglong(1) << AV_CHAN_FRONT_LEFT_OF_CENTER

const AV_CH_FRONT_RIGHT_OF_CENTER = Culonglong(1) << AV_CHAN_FRONT_RIGHT_OF_CENTER

const AV_CH_BACK_CENTER = Culonglong(1) << AV_CHAN_BACK_CENTER

const AV_CH_SIDE_LEFT = Culonglong(1) << AV_CHAN_SIDE_LEFT

const AV_CH_SIDE_RIGHT = Culonglong(1) << AV_CHAN_SIDE_RIGHT

const AV_CH_TOP_CENTER = Culonglong(1) << AV_CHAN_TOP_CENTER

const AV_CH_TOP_FRONT_LEFT = Culonglong(1) << AV_CHAN_TOP_FRONT_LEFT

const AV_CH_TOP_FRONT_CENTER = Culonglong(1) << AV_CHAN_TOP_FRONT_CENTER

const AV_CH_TOP_FRONT_RIGHT = Culonglong(1) << AV_CHAN_TOP_FRONT_RIGHT

const AV_CH_TOP_BACK_LEFT = Culonglong(1) << AV_CHAN_TOP_BACK_LEFT

const AV_CH_TOP_BACK_CENTER = Culonglong(1) << AV_CHAN_TOP_BACK_CENTER

const AV_CH_TOP_BACK_RIGHT = Culonglong(1) << AV_CHAN_TOP_BACK_RIGHT

const AV_CH_STEREO_LEFT = Culonglong(1) << AV_CHAN_STEREO_LEFT

const AV_CH_STEREO_RIGHT = Culonglong(1) << AV_CHAN_STEREO_RIGHT

const AV_CH_WIDE_LEFT = Culonglong(1) << AV_CHAN_WIDE_LEFT

const AV_CH_WIDE_RIGHT = Culonglong(1) << AV_CHAN_WIDE_RIGHT

const AV_CH_SURROUND_DIRECT_LEFT = Culonglong(1) << AV_CHAN_SURROUND_DIRECT_LEFT

const AV_CH_SURROUND_DIRECT_RIGHT = Culonglong(1) << AV_CHAN_SURROUND_DIRECT_RIGHT

const AV_CH_LOW_FREQUENCY_2 = Culonglong(1) << AV_CHAN_LOW_FREQUENCY_2

const AV_CH_TOP_SIDE_LEFT = Culonglong(1) << AV_CHAN_TOP_SIDE_LEFT

const AV_CH_TOP_SIDE_RIGHT = Culonglong(1) << AV_CHAN_TOP_SIDE_RIGHT

const AV_CH_BOTTOM_FRONT_CENTER = Culonglong(1) << AV_CHAN_BOTTOM_FRONT_CENTER

const AV_CH_BOTTOM_FRONT_LEFT = Culonglong(1) << AV_CHAN_BOTTOM_FRONT_LEFT

const AV_CH_BOTTOM_FRONT_RIGHT = Culonglong(1) << AV_CHAN_BOTTOM_FRONT_RIGHT

const AV_CH_SIDE_SURROUND_LEFT = Culonglong(1) << AV_CHAN_SIDE_SURROUND_LEFT

const AV_CH_SIDE_SURROUND_RIGHT = Culonglong(1) << AV_CHAN_SIDE_SURROUND_RIGHT

const AV_CH_TOP_SURROUND_LEFT = Culonglong(1) << AV_CHAN_TOP_SURROUND_LEFT

const AV_CH_TOP_SURROUND_RIGHT = Culonglong(1) << AV_CHAN_TOP_SURROUND_RIGHT

const AV_CH_BINAURAL_LEFT = Culonglong(1) << AV_CHAN_BINAURAL_LEFT

const AV_CH_BINAURAL_RIGHT = Culonglong(1) << AV_CHAN_BINAURAL_RIGHT

const AV_CH_LAYOUT_MONO = AV_CH_FRONT_CENTER

const AV_CH_LAYOUT_STEREO = AV_CH_FRONT_LEFT | AV_CH_FRONT_RIGHT

const AV_CH_LAYOUT_2POINT1 = AV_CH_LAYOUT_STEREO | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_2_1 = AV_CH_LAYOUT_STEREO | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_SURROUND = AV_CH_LAYOUT_STEREO | AV_CH_FRONT_CENTER

const AV_CH_LAYOUT_3POINT1 = AV_CH_LAYOUT_SURROUND | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_4POINT0 = AV_CH_LAYOUT_SURROUND | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_4POINT1 = AV_CH_LAYOUT_4POINT0 | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_2_2 = (AV_CH_LAYOUT_STEREO | AV_CH_SIDE_LEFT) | AV_CH_SIDE_RIGHT

const AV_CH_LAYOUT_QUAD = (AV_CH_LAYOUT_STEREO | AV_CH_BACK_LEFT) | AV_CH_BACK_RIGHT

const AV_CH_LAYOUT_5POINT0 = (AV_CH_LAYOUT_SURROUND | AV_CH_SIDE_LEFT) | AV_CH_SIDE_RIGHT

const AV_CH_LAYOUT_5POINT1 = AV_CH_LAYOUT_5POINT0 | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_5POINT0_BACK = (AV_CH_LAYOUT_SURROUND | AV_CH_BACK_LEFT) | AV_CH_BACK_RIGHT

const AV_CH_LAYOUT_5POINT1_BACK = AV_CH_LAYOUT_5POINT0_BACK | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_6POINT0 = AV_CH_LAYOUT_5POINT0 | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_6POINT0_FRONT = (AV_CH_LAYOUT_2_2 | AV_CH_FRONT_LEFT_OF_CENTER) | AV_CH_FRONT_RIGHT_OF_CENTER

const AV_CH_LAYOUT_HEXAGONAL = AV_CH_LAYOUT_5POINT0_BACK | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_3POINT1POINT2 = (AV_CH_LAYOUT_3POINT1 | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT

const AV_CH_LAYOUT_6POINT1 = AV_CH_LAYOUT_5POINT1 | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_6POINT1_BACK = AV_CH_LAYOUT_5POINT1_BACK | AV_CH_BACK_CENTER

const AV_CH_LAYOUT_6POINT1_FRONT = AV_CH_LAYOUT_6POINT0_FRONT | AV_CH_LOW_FREQUENCY

const AV_CH_LAYOUT_7POINT0 = (AV_CH_LAYOUT_5POINT0 | AV_CH_BACK_LEFT) | AV_CH_BACK_RIGHT

const AV_CH_LAYOUT_7POINT0_FRONT = (AV_CH_LAYOUT_5POINT0 | AV_CH_FRONT_LEFT_OF_CENTER) | AV_CH_FRONT_RIGHT_OF_CENTER

const AV_CH_LAYOUT_7POINT1 = (AV_CH_LAYOUT_5POINT1 | AV_CH_BACK_LEFT) | AV_CH_BACK_RIGHT

const AV_CH_LAYOUT_7POINT1_WIDE = (AV_CH_LAYOUT_5POINT1 | AV_CH_FRONT_LEFT_OF_CENTER) | AV_CH_FRONT_RIGHT_OF_CENTER

const AV_CH_LAYOUT_7POINT1_WIDE_BACK = (AV_CH_LAYOUT_5POINT1_BACK | AV_CH_FRONT_LEFT_OF_CENTER) | AV_CH_FRONT_RIGHT_OF_CENTER

const AV_CH_LAYOUT_5POINT1POINT2 = (AV_CH_LAYOUT_5POINT1 | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT

const AV_CH_LAYOUT_5POINT1POINT2_BACK = (AV_CH_LAYOUT_5POINT1_BACK | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT

const AV_CH_LAYOUT_OCTAGONAL = ((AV_CH_LAYOUT_5POINT0 | AV_CH_BACK_LEFT) | AV_CH_BACK_CENTER) | AV_CH_BACK_RIGHT

const AV_CH_LAYOUT_CUBE = (((AV_CH_LAYOUT_QUAD | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT) | AV_CH_TOP_BACK_LEFT) | AV_CH_TOP_BACK_RIGHT

const AV_CH_LAYOUT_5POINT1POINT4_BACK = (AV_CH_LAYOUT_5POINT1POINT2 | AV_CH_TOP_BACK_LEFT) | AV_CH_TOP_BACK_RIGHT

const AV_CH_LAYOUT_7POINT1POINT2 = (AV_CH_LAYOUT_7POINT1 | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT

const AV_CH_LAYOUT_7POINT1POINT4_BACK = (AV_CH_LAYOUT_7POINT1POINT2 | AV_CH_TOP_BACK_LEFT) | AV_CH_TOP_BACK_RIGHT

const AV_CH_LAYOUT_7POINT2POINT3 = (AV_CH_LAYOUT_7POINT1POINT2 | AV_CH_TOP_BACK_CENTER) | AV_CH_LOW_FREQUENCY_2

const AV_CH_LAYOUT_9POINT1POINT4_BACK = (AV_CH_LAYOUT_7POINT1POINT4_BACK | AV_CH_FRONT_LEFT_OF_CENTER) | AV_CH_FRONT_RIGHT_OF_CENTER

const AV_CH_LAYOUT_9POINT1POINT6 = (AV_CH_LAYOUT_9POINT1POINT4_BACK | AV_CH_TOP_SIDE_LEFT) | AV_CH_TOP_SIDE_RIGHT

const AV_CH_LAYOUT_HEXADECAGONAL = (((((((AV_CH_LAYOUT_OCTAGONAL | AV_CH_WIDE_LEFT) | AV_CH_WIDE_RIGHT) | AV_CH_TOP_BACK_LEFT) | AV_CH_TOP_BACK_RIGHT) | AV_CH_TOP_BACK_CENTER) | AV_CH_TOP_FRONT_CENTER) | AV_CH_TOP_FRONT_LEFT) | AV_CH_TOP_FRONT_RIGHT

const AV_CH_LAYOUT_BINAURAL = AV_CH_BINAURAL_LEFT | AV_CH_BINAURAL_RIGHT

const AV_CH_LAYOUT_STEREO_DOWNMIX = AV_CH_STEREO_LEFT | AV_CH_STEREO_RIGHT

const AV_CH_LAYOUT_22POINT2 = (((((((AV_CH_LAYOUT_9POINT1POINT6 | AV_CH_BACK_CENTER) | AV_CH_LOW_FREQUENCY_2) | AV_CH_TOP_FRONT_CENTER) | AV_CH_TOP_CENTER) | AV_CH_TOP_BACK_CENTER) | AV_CH_BOTTOM_FRONT_CENTER) | AV_CH_BOTTOM_FRONT_LEFT) | AV_CH_BOTTOM_FRONT_RIGHT

const AV_CH_LAYOUT_7POINT1_TOP_BACK = AV_CH_LAYOUT_5POINT1POINT2_BACK

const av_ceil_log2 = av_ceil_log2_c

const av_clip = av_clip_c

const av_clip64 = av_clip64_c

const av_clip_uint8 = av_clip_uint8_c

const av_clip_int8 = av_clip_int8_c

const av_clip_uint16 = av_clip_uint16_c

const av_clip_int16 = av_clip_int16_c

const av_clipl_int32 = av_clipl_int32_c

const av_clip_intp2 = av_clip_intp2_c

const av_clip_uintp2 = av_clip_uintp2_c

const av_sat_add32 = av_sat_add32_c

const av_sat_dadd32 = av_sat_dadd32_c

const av_sat_sub32 = av_sat_sub32_c

const av_sat_dsub32 = av_sat_dsub32_c

const av_sat_add64 = av_sat_add64_c

const av_sat_sub64 = av_sat_sub64_c

const av_clipf = av_clipf_c

const av_clipd = av_clipd_c

const av_zero_extend = av_zero_extend_c

const av_popcount = av_popcount_c

const av_popcount64 = av_popcount64_c

const av_parity = av_parity_c

const av_mod_uintp2 = av_mod_uintp2_c

const AV_CPU_FLAG_FORCE = 0x80000000

const AV_CPU_FLAG_MMX = 0x0001

const AV_CPU_FLAG_MMXEXT = 0x0002

const AV_CPU_FLAG_MMX2 = 0x0002

const AV_CPU_FLAG_3DNOW = 0x0004

const AV_CPU_FLAG_SSE = 0x0008

const AV_CPU_FLAG_SSE2 = 0x0010

const AV_CPU_FLAG_SSE2SLOW = 0x40000000

const AV_CPU_FLAG_3DNOWEXT = 0x0020

const AV_CPU_FLAG_SSE3 = 0x0040

const AV_CPU_FLAG_SSE3SLOW = 0x20000000

const AV_CPU_FLAG_SSSE3 = 0x0080

const AV_CPU_FLAG_SSSE3SLOW = 0x04000000

const AV_CPU_FLAG_ATOM = 0x10000000

const AV_CPU_FLAG_SSE4 = 0x0100

const AV_CPU_FLAG_SSE42 = 0x0200

const AV_CPU_FLAG_AESNI = 0x00080000

const AV_CPU_FLAG_AVX = 0x4000

const AV_CPU_FLAG_AVXSLOW = 0x08000000

const AV_CPU_FLAG_XOP = 0x0400

const AV_CPU_FLAG_FMA4 = 0x0800

const AV_CPU_FLAG_CMOV = 0x1000

const AV_CPU_FLAG_AVX2 = 0x8000

const AV_CPU_FLAG_FMA3 = 0x00010000

const AV_CPU_FLAG_BMI1 = 0x00020000

const AV_CPU_FLAG_BMI2 = 0x00040000

const AV_CPU_FLAG_AVX512 = 0x00100000

const AV_CPU_FLAG_AVX512ICL = 0x00200000

const AV_CPU_FLAG_SLOW_GATHER = 0x02000000

const AV_CPU_FLAG_ALTIVEC = 0x0001

const AV_CPU_FLAG_VSX = 0x0002

const AV_CPU_FLAG_POWER8 = 0x0004

const AV_CPU_FLAG_ARMV5TE = 1 << 0

const AV_CPU_FLAG_ARMV6 = 1 << 1

const AV_CPU_FLAG_ARMV6T2 = 1 << 2

const AV_CPU_FLAG_VFP = 1 << 3

const AV_CPU_FLAG_VFPV3 = 1 << 4

const AV_CPU_FLAG_NEON = 1 << 5

const AV_CPU_FLAG_ARMV8 = 1 << 6

const AV_CPU_FLAG_VFP_VM = 1 << 7

const AV_CPU_FLAG_DOTPROD = 1 << 8

const AV_CPU_FLAG_I8MM = 1 << 9

const AV_CPU_FLAG_SVE = 1 << 10

const AV_CPU_FLAG_SVE2 = 1 << 11

const AV_CPU_FLAG_SETEND = 1 << 16

const AV_CPU_FLAG_MMI = 1 << 0

const AV_CPU_FLAG_MSA = 1 << 1

const AV_CPU_FLAG_LSX = 1 << 0

const AV_CPU_FLAG_LASX = 1 << 1

const AV_CPU_FLAG_RVI = 1 << 0

const AV_CPU_FLAG_RVF = 1 << 1

const AV_CPU_FLAG_RVD = 1 << 2

const AV_CPU_FLAG_RVV_I32 = 1 << 3

const AV_CPU_FLAG_RVV_F32 = 1 << 4

const AV_CPU_FLAG_RVV_I64 = 1 << 5

const AV_CPU_FLAG_RVV_F64 = 1 << 6

const AV_CPU_FLAG_RVB_BASIC = 1 << 7

const AV_CPU_FLAG_RVB_ADDR = 1 << 8

const AV_CPU_FLAG_RV_ZVBB = 1 << 9

const AV_CPU_FLAG_RV_MISALIGNED = 1 << 10

const AV_CPU_FLAG_RVB = 1 << 11

const AV_CPU_FLAG_SIMD128 = 1 << 0

const AV_DETECTION_BBOX_LABEL_NAME_MAX_SIZE = 64

const AV_NUM_DETECTION_BBOX_CLASSIFY = 4

const AV_DICT_MATCH_CASE = 1

const AV_DICT_IGNORE_SUFFIX = 2

const AV_DICT_DONT_STRDUP_KEY = 4

const AV_DICT_DONT_STRDUP_VAL = 8

const AV_DICT_DONT_OVERWRITE = 16

const AV_DICT_APPEND = 32

const AV_DICT_MULTIKEY = 64

const AV_DICT_DEDUP = 128

const AV_DOVI_MAX_PIECES = 8

const AV_DOVI_MAX_EXT_BLOCKS = 32

const AVERROR_BSF_NOT_FOUND = FFERRTAG(0xf8, Cchar('B'), Cchar('S'), Cchar('F'))

const AVERROR_BUG = FFERRTAG(Cchar('B'), Cchar('U'), Cchar('G'), Cchar('!'))

const AVERROR_BUFFER_TOO_SMALL = FFERRTAG(Cchar('B'), Cchar('U'), Cchar('F'), Cchar('S'))

const AVERROR_DECODER_NOT_FOUND = FFERRTAG(0xf8, Cchar('D'), Cchar('E'), Cchar('C'))

const AVERROR_DEMUXER_NOT_FOUND = FFERRTAG(0xf8, Cchar('D'), Cchar('E'), Cchar('M'))

const AVERROR_ENCODER_NOT_FOUND = FFERRTAG(0xf8, Cchar('E'), Cchar('N'), Cchar('C'))

const AVERROR_EOF = FFERRTAG(Cchar('E'), Cchar('O'), Cchar('F'), Cchar(' '))

const AVERROR_EXIT = FFERRTAG(Cchar('E'), Cchar('X'), Cchar('I'), Cchar('T'))

const AVERROR_EXTERNAL = FFERRTAG(Cchar('E'), Cchar('X'), Cchar('T'), Cchar(' '))

const AVERROR_FILTER_NOT_FOUND = FFERRTAG(0xf8, Cchar('F'), Cchar('I'), Cchar('L'))

const AVERROR_INVALIDDATA = FFERRTAG(Cchar('I'), Cchar('N'), Cchar('D'), Cchar('A'))

const AVERROR_MUXER_NOT_FOUND = FFERRTAG(0xf8, Cchar('M'), Cchar('U'), Cchar('X'))

const AVERROR_OPTION_NOT_FOUND = FFERRTAG(0xf8, Cchar('O'), Cchar('P'), Cchar('T'))

const AVERROR_PATCHWELCOME = FFERRTAG(Cchar('P'), Cchar('A'), Cchar('W'), Cchar('E'))

const AVERROR_PROTOCOL_NOT_FOUND = FFERRTAG(0xf8, Cchar('P'), Cchar('R'), Cchar('O'))

const AVERROR_STREAM_NOT_FOUND = FFERRTAG(0xf8, Cchar('S'), Cchar('T'), Cchar('R'))

const AVERROR_BUG2 = FFERRTAG(Cchar('B'), Cchar('U'), Cchar('G'), Cchar(' '))

const AVERROR_UNKNOWN = FFERRTAG(Cchar('U'), Cchar('N'), Cchar('K'), Cchar('N'))

const AVERROR_EXPERIMENTAL = -0x2bb2afa8

const AVERROR_INPUT_CHANGED = -0x636e6701

const AVERROR_OUTPUT_CHANGED = -0x636e6702

const AVERROR_HTTP_BAD_REQUEST = FFERRTAG(0xf8, Cchar('4'), Cchar('0'), Cchar('0'))

const AVERROR_HTTP_UNAUTHORIZED = FFERRTAG(0xf8, Cchar('4'), Cchar('0'), Cchar('1'))

const AVERROR_HTTP_FORBIDDEN = FFERRTAG(0xf8, Cchar('4'), Cchar('0'), Cchar('3'))

const AVERROR_HTTP_NOT_FOUND = FFERRTAG(0xf8, Cchar('4'), Cchar('0'), Cchar('4'))

const AVERROR_HTTP_TOO_MANY_REQUESTS = FFERRTAG(0xf8, Cchar('4'), Cchar('2'), Cchar('9'))

const AVERROR_HTTP_OTHER_4XX = FFERRTAG(0xf8, Cchar('4'), Cchar('X'), Cchar('X'))

const AVERROR_HTTP_SERVER_ERROR = FFERRTAG(0xf8, Cchar('5'), Cchar('X'), Cchar('X'))

const AV_ERROR_MAX_STRING_SIZE = 64

const FFMPEG_VERSION = "n8.0"

const AV_FIFO_FLAG_AUTO_GROW = 1 << 0

const AV_NUM_DATA_POINTERS = 8

const AV_FRAME_FLAG_CORRUPT = 1 << 0

const AV_FRAME_FLAG_KEY = 1 << 1

const AV_FRAME_FLAG_DISCARD = 1 << 2

const AV_FRAME_FLAG_INTERLACED = 1 << 3

const AV_FRAME_FLAG_TOP_FIELD_FIRST = 1 << 4

const AV_FRAME_FLAG_LOSSLESS = 1 << 5

const FF_DECODE_ERROR_INVALID_BITSTREAM = 1

const FF_DECODE_ERROR_MISSING_REFERENCE = 2

const FF_DECODE_ERROR_CONCEALMENT_ACTIVE = 4

const FF_DECODE_ERROR_DECODE_SLICES = 8

const AV_FRAME_SIDE_DATA_FLAG_UNIQUE = 1 << 0

const AV_FRAME_SIDE_DATA_FLAG_REPLACE = 1 << 1

const AV_FRAME_SIDE_DATA_FLAG_NEW_REF = 1 << 2

const AV_HASH_MAX_SIZE = 64

const AV_HDR_PLUS_MAX_PAYLOAD_SIZE = 907

const AV_CUDA_USE_PRIMARY_CONTEXT = 1 << 0

const AV_CUDA_USE_CURRENT_CONTEXT = 1 << 1

const AV_IAMF_LAYER_FLAG_RECON_GAIN = 1 << 0

const AV_LOG_QUIET = -8

const AV_LOG_FATAL = 8

const AV_LOG_ERROR = 16

const AV_LOG_WARNING = 24

const AV_LOG_INFO = 32

const AV_LOG_VERBOSE = 40

const AV_LOG_DEBUG = 48

const AV_LOG_TRACE = 56

const AV_LOG_MAX_OFFSET = AV_LOG_TRACE - AV_LOG_QUIET

const AV_LOG_SKIP_REPEATED = 1

const AV_LOG_PRINT_LEVEL = 2

const AV_LOG_PRINT_TIME = 4

const AV_LOG_PRINT_DATETIME = 8

const AV_LZO_INPUT_DEPLETED = 1

const AV_LZO_OUTPUT_FULL = 2

const AV_LZO_INVALID_BACKPTR = 4

const AV_LZO_ERROR = 8

const AV_LZO_INPUT_PADDING = 8

const AV_LZO_OUTPUT_PADDING = 12

const M_Ef = Float32(2.718281828459045)

const M_LN2f = Float32(0.6931471805599453)

const M_LN10f = Float32(2.302585092994046)

const M_LOG2_10 = 3.321928094887362

const M_LOG2_10f = Float32(3.321928094887362)

const M_PHI = 1.618033988749895

const M_PHIf = Float32(1.618033988749895)

const M_PIf = Float32(3.141592653589793)

const M_PI_2f = Float32(1.5707963267948966)

const M_PI_4f = Float32(0.7853981633974483)

const M_1_PIf = Float32(0.3183098861837907)

const M_2_PIf = Float32(0.6366197723675814)

const M_2_SQRTPIf = Float32(1.1283791670955126)

const M_SQRT1_2f = Float32(0.7071067811865476)

const M_SQRT2f = Float32(1.4142135623730951)

# Skipping MacroDefinition: av_malloc_attrib __attribute__ ( ( __malloc__ ) )

const AV_OPT_FLAG_ENCODING_PARAM = 1 << 0

const AV_OPT_FLAG_DECODING_PARAM = 1 << 1

const AV_OPT_FLAG_AUDIO_PARAM = 1 << 3

const AV_OPT_FLAG_VIDEO_PARAM = 1 << 4

const AV_OPT_FLAG_SUBTITLE_PARAM = 1 << 5

const AV_OPT_FLAG_EXPORT = 1 << 6

const AV_OPT_FLAG_READONLY = 1 << 7

const AV_OPT_FLAG_BSF_PARAM = 1 << 8

const AV_OPT_FLAG_RUNTIME_PARAM = 1 << 15

const AV_OPT_FLAG_FILTERING_PARAM = 1 << 16

const AV_OPT_FLAG_DEPRECATED = 1 << 17

const AV_OPT_FLAG_CHILD_CONSTS = 1 << 18

const AV_OPT_SEARCH_CHILDREN = 1 << 0

const AV_OPT_SEARCH_FAKE_OBJ = 1 << 1

const AV_OPT_ALLOW_NULL = 1 << 2

const AV_OPT_ARRAY_REPLACE = 1 << 3

const AV_OPT_MULTI_COMPONENT_RANGE = 1 << 12

const AV_OPT_SERIALIZE_SKIP_DEFAULTS = 0x00000001

const AV_OPT_SERIALIZE_OPT_FLAGS_EXACT = 0x00000002

const AV_OPT_SERIALIZE_SEARCH_CHILDREN = 0x00000004

const AV_PIX_FMT_FLAG_BE = 1 << 0

const AV_PIX_FMT_FLAG_PAL = 1 << 1

const AV_PIX_FMT_FLAG_BITSTREAM = 1 << 2

const AV_PIX_FMT_FLAG_HWACCEL = 1 << 3

const AV_PIX_FMT_FLAG_PLANAR = 1 << 4

const AV_PIX_FMT_FLAG_RGB = 1 << 5

const AV_PIX_FMT_FLAG_ALPHA = 1 << 7

const AV_PIX_FMT_FLAG_BAYER = 1 << 8

const AV_PIX_FMT_FLAG_FLOAT = 1 << 9

const AV_PIX_FMT_FLAG_XYZ = 1 << 10

const FF_LOSS_RESOLUTION = 0x0001

const FF_LOSS_DEPTH = 0x0002

const FF_LOSS_COLORSPACE = 0x0004

const FF_LOSS_ALPHA = 0x0008

const FF_LOSS_COLORQUANT = 0x0010

const FF_LOSS_CHROMA = 0x0020

const FF_LOSS_EXCESS_RESOLUTION = 0x0040

const FF_LOSS_EXCESS_DEPTH = 0x0080

const AVPALETTE_SIZE = 1024

const AVPALETTE_COUNT = 256

const AV_VIDEO_MAX_PLANES = 4

const AV_PIX_FMT_RGB32 = @AV_PIX_FMT_NE(ARGB, BGRA)

const AV_PIX_FMT_RGB32_1 = @AV_PIX_FMT_NE(RGBA, ABGR)

const AV_PIX_FMT_BGR32 = @AV_PIX_FMT_NE(ABGR, RGBA)

const AV_PIX_FMT_BGR32_1 = @AV_PIX_FMT_NE(BGRA, ARGB)

const AV_PIX_FMT_0RGB32 = @AV_PIX_FMT_NE(0RGB, BGR0)

const AV_PIX_FMT_0BGR32 = @AV_PIX_FMT_NE(0BGR, RGB0)

const AV_PIX_FMT_GRAY9 = @AV_PIX_FMT_NE(GRAY9BE, GRAY9LE)

const AV_PIX_FMT_GRAY10 = @AV_PIX_FMT_NE(GRAY10BE, GRAY10LE)

const AV_PIX_FMT_GRAY12 = @AV_PIX_FMT_NE(GRAY12BE, GRAY12LE)

const AV_PIX_FMT_GRAY14 = @AV_PIX_FMT_NE(GRAY14BE, GRAY14LE)

const AV_PIX_FMT_GRAY16 = @AV_PIX_FMT_NE(GRAY16BE, GRAY16LE)

const AV_PIX_FMT_GRAY32 = @AV_PIX_FMT_NE(GRAY32BE, GRAY32LE)

const AV_PIX_FMT_YA16 = @AV_PIX_FMT_NE(YA16BE, YA16LE)

const AV_PIX_FMT_RGB48 = @AV_PIX_FMT_NE(RGB48BE, RGB48LE)

const AV_PIX_FMT_RGB565 = @AV_PIX_FMT_NE(RGB565BE, RGB565LE)

const AV_PIX_FMT_RGB555 = @AV_PIX_FMT_NE(RGB555BE, RGB555LE)

const AV_PIX_FMT_RGB444 = @AV_PIX_FMT_NE(RGB444BE, RGB444LE)

const AV_PIX_FMT_RGBA64 = @AV_PIX_FMT_NE(RGBA64BE, RGBA64LE)

const AV_PIX_FMT_BGR48 = @AV_PIX_FMT_NE(BGR48BE, BGR48LE)

const AV_PIX_FMT_BGR565 = @AV_PIX_FMT_NE(BGR565BE, BGR565LE)

const AV_PIX_FMT_BGR555 = @AV_PIX_FMT_NE(BGR555BE, BGR555LE)

const AV_PIX_FMT_BGR444 = @AV_PIX_FMT_NE(BGR444BE, BGR444LE)

const AV_PIX_FMT_BGRA64 = @AV_PIX_FMT_NE(BGRA64BE, BGRA64LE)

const AV_PIX_FMT_YUV420P9 = @AV_PIX_FMT_NE(YUV420P9BE, YUV420P9LE)

const AV_PIX_FMT_YUV422P9 = @AV_PIX_FMT_NE(YUV422P9BE, YUV422P9LE)

const AV_PIX_FMT_YUV444P9 = @AV_PIX_FMT_NE(YUV444P9BE, YUV444P9LE)

const AV_PIX_FMT_YUV420P10 = @AV_PIX_FMT_NE(YUV420P10BE, YUV420P10LE)

const AV_PIX_FMT_YUV422P10 = @AV_PIX_FMT_NE(YUV422P10BE, YUV422P10LE)

const AV_PIX_FMT_YUV440P10 = @AV_PIX_FMT_NE(YUV440P10BE, YUV440P10LE)

const AV_PIX_FMT_YUV444P10 = @AV_PIX_FMT_NE(YUV444P10BE, YUV444P10LE)

const AV_PIX_FMT_YUV420P12 = @AV_PIX_FMT_NE(YUV420P12BE, YUV420P12LE)

const AV_PIX_FMT_YUV422P12 = @AV_PIX_FMT_NE(YUV422P12BE, YUV422P12LE)

const AV_PIX_FMT_YUV440P12 = @AV_PIX_FMT_NE(YUV440P12BE, YUV440P12LE)

const AV_PIX_FMT_YUV444P12 = @AV_PIX_FMT_NE(YUV444P12BE, YUV444P12LE)

const AV_PIX_FMT_YUV420P14 = @AV_PIX_FMT_NE(YUV420P14BE, YUV420P14LE)

const AV_PIX_FMT_YUV422P14 = @AV_PIX_FMT_NE(YUV422P14BE, YUV422P14LE)

const AV_PIX_FMT_YUV444P14 = @AV_PIX_FMT_NE(YUV444P14BE, YUV444P14LE)

const AV_PIX_FMT_YUV420P16 = @AV_PIX_FMT_NE(YUV420P16BE, YUV420P16LE)

const AV_PIX_FMT_YUV422P16 = @AV_PIX_FMT_NE(YUV422P16BE, YUV422P16LE)

const AV_PIX_FMT_YUV444P16 = @AV_PIX_FMT_NE(YUV444P16BE, YUV444P16LE)

const AV_PIX_FMT_YUV444P10MSB = @AV_PIX_FMT_NE(YUV444P10MSBBE, YUV444P10MSBLE)

const AV_PIX_FMT_YUV444P12MSB = @AV_PIX_FMT_NE(YUV444P12MSBBE, YUV444P12MSBLE)

const AV_PIX_FMT_GBRP9 = @AV_PIX_FMT_NE(GBRP9BE, GBRP9LE)

const AV_PIX_FMT_GBRP10 = @AV_PIX_FMT_NE(GBRP10BE, GBRP10LE)

const AV_PIX_FMT_GBRP12 = @AV_PIX_FMT_NE(GBRP12BE, GBRP12LE)

const AV_PIX_FMT_GBRP14 = @AV_PIX_FMT_NE(GBRP14BE, GBRP14LE)

const AV_PIX_FMT_GBRP16 = @AV_PIX_FMT_NE(GBRP16BE, GBRP16LE)

const AV_PIX_FMT_GBRAP10 = @AV_PIX_FMT_NE(GBRAP10BE, GBRAP10LE)

const AV_PIX_FMT_GBRAP12 = @AV_PIX_FMT_NE(GBRAP12BE, GBRAP12LE)

const AV_PIX_FMT_GBRAP14 = @AV_PIX_FMT_NE(GBRAP14BE, GBRAP14LE)

const AV_PIX_FMT_GBRAP16 = @AV_PIX_FMT_NE(GBRAP16BE, GBRAP16LE)

const AV_PIX_FMT_GBRAP32 = @AV_PIX_FMT_NE(GBRAP32BE, GBRAP32LE)

const AV_PIX_FMT_GBRP10MSB = @AV_PIX_FMT_NE(GBRP10MSBBE, GBRP10MSBLE)

const AV_PIX_FMT_GBRP12MSB = @AV_PIX_FMT_NE(GBRP12MSBBE, GBRP12MSBLE)

const AV_PIX_FMT_BAYER_BGGR16 = @AV_PIX_FMT_NE(BAYER_BGGR16BE, BAYER_BGGR16LE)

const AV_PIX_FMT_BAYER_RGGB16 = @AV_PIX_FMT_NE(BAYER_RGGB16BE, BAYER_RGGB16LE)

const AV_PIX_FMT_BAYER_GBRG16 = @AV_PIX_FMT_NE(BAYER_GBRG16BE, BAYER_GBRG16LE)

const AV_PIX_FMT_BAYER_GRBG16 = @AV_PIX_FMT_NE(BAYER_GRBG16BE, BAYER_GRBG16LE)

const AV_PIX_FMT_GBRPF16 = @AV_PIX_FMT_NE(GBRPF16BE, GBRPF16LE)

const AV_PIX_FMT_GBRAPF16 = @AV_PIX_FMT_NE(GBRAPF16BE, GBRAPF16LE)

const AV_PIX_FMT_GBRPF32 = @AV_PIX_FMT_NE(GBRPF32BE, GBRPF32LE)

const AV_PIX_FMT_GBRAPF32 = @AV_PIX_FMT_NE(GBRAPF32BE, GBRAPF32LE)

const AV_PIX_FMT_GRAYF16 = @AV_PIX_FMT_NE(GRAYF16BE, GRAYF16LE)

const AV_PIX_FMT_GRAYF32 = @AV_PIX_FMT_NE(GRAYF32BE, GRAYF32LE)

const AV_PIX_FMT_YAF16 = @AV_PIX_FMT_NE(YAF16BE, YAF16LE)

const AV_PIX_FMT_YAF32 = @AV_PIX_FMT_NE(YAF32BE, YAF32LE)

const AV_PIX_FMT_YUVA420P9 = @AV_PIX_FMT_NE(YUVA420P9BE, YUVA420P9LE)

const AV_PIX_FMT_YUVA422P9 = @AV_PIX_FMT_NE(YUVA422P9BE, YUVA422P9LE)

const AV_PIX_FMT_YUVA444P9 = @AV_PIX_FMT_NE(YUVA444P9BE, YUVA444P9LE)

const AV_PIX_FMT_YUVA420P10 = @AV_PIX_FMT_NE(YUVA420P10BE, YUVA420P10LE)

const AV_PIX_FMT_YUVA422P10 = @AV_PIX_FMT_NE(YUVA422P10BE, YUVA422P10LE)

const AV_PIX_FMT_YUVA444P10 = @AV_PIX_FMT_NE(YUVA444P10BE, YUVA444P10LE)

const AV_PIX_FMT_YUVA422P12 = @AV_PIX_FMT_NE(YUVA422P12BE, YUVA422P12LE)

const AV_PIX_FMT_YUVA444P12 = @AV_PIX_FMT_NE(YUVA444P12BE, YUVA444P12LE)

const AV_PIX_FMT_YUVA420P16 = @AV_PIX_FMT_NE(YUVA420P16BE, YUVA420P16LE)

const AV_PIX_FMT_YUVA422P16 = @AV_PIX_FMT_NE(YUVA422P16BE, YUVA422P16LE)

const AV_PIX_FMT_YUVA444P16 = @AV_PIX_FMT_NE(YUVA444P16BE, YUVA444P16LE)

const AV_PIX_FMT_XYZ12 = @AV_PIX_FMT_NE(XYZ12BE, XYZ12LE)

const AV_PIX_FMT_NV20 = @AV_PIX_FMT_NE(NV20BE, NV20LE)

const AV_PIX_FMT_AYUV64 = @AV_PIX_FMT_NE(AYUV64BE, AYUV64LE)

const AV_PIX_FMT_P010 = @AV_PIX_FMT_NE(P010BE, P010LE)

const AV_PIX_FMT_P012 = @AV_PIX_FMT_NE(P012BE, P012LE)

const AV_PIX_FMT_P016 = @AV_PIX_FMT_NE(P016BE, P016LE)

const AV_PIX_FMT_Y210 = @AV_PIX_FMT_NE(Y210BE, Y210LE)

const AV_PIX_FMT_Y212 = @AV_PIX_FMT_NE(Y212BE, Y212LE)

const AV_PIX_FMT_Y216 = @AV_PIX_FMT_NE(Y216BE, Y216LE)

const AV_PIX_FMT_XV30 = @AV_PIX_FMT_NE(XV30BE, XV30LE)

const AV_PIX_FMT_XV36 = @AV_PIX_FMT_NE(XV36BE, XV36LE)

const AV_PIX_FMT_XV48 = @AV_PIX_FMT_NE(XV48BE, XV48LE)

const AV_PIX_FMT_V30X = @AV_PIX_FMT_NE(V30XBE, V30XLE)

const AV_PIX_FMT_X2RGB10 = @AV_PIX_FMT_NE(X2RGB10BE, X2RGB10LE)

const AV_PIX_FMT_X2BGR10 = @AV_PIX_FMT_NE(X2BGR10BE, X2BGR10LE)

const AV_PIX_FMT_P210 = @AV_PIX_FMT_NE(P210BE, P210LE)

const AV_PIX_FMT_P410 = @AV_PIX_FMT_NE(P410BE, P410LE)

const AV_PIX_FMT_P212 = @AV_PIX_FMT_NE(P212BE, P212LE)

const AV_PIX_FMT_P412 = @AV_PIX_FMT_NE(P412BE, P412LE)

const AV_PIX_FMT_P216 = @AV_PIX_FMT_NE(P216BE, P216LE)

const AV_PIX_FMT_P416 = @AV_PIX_FMT_NE(P416BE, P416LE)

const AV_PIX_FMT_RGBF16 = @AV_PIX_FMT_NE(RGBF16BE, RGBF16LE)

const AV_PIX_FMT_RGBAF16 = @AV_PIX_FMT_NE(RGBAF16BE, RGBAF16LE)

const AV_PIX_FMT_RGBF32 = @AV_PIX_FMT_NE(RGBF32BE, RGBF32LE)

const AV_PIX_FMT_RGBAF32 = @AV_PIX_FMT_NE(RGBAF32BE, RGBAF32LE)

const AV_PIX_FMT_RGB96 = @AV_PIX_FMT_NE(RGB96BE, RGB96LE)

const AV_PIX_FMT_RGBA128 = @AV_PIX_FMT_NE(RGBA128BE, RGBA128LE)

const AV_REFSTRUCT_FLAG_NO_ZEROING = 1 << 0

const AV_REFSTRUCT_POOL_FLAG_NO_ZEROING = AV_REFSTRUCT_FLAG_NO_ZEROING

const AV_REFSTRUCT_POOL_FLAG_RESET_ON_INIT_ERROR = 1 << 16

const AV_REFSTRUCT_POOL_FLAG_FREE_ON_INIT_ERROR = 1 << 17

const AV_REFSTRUCT_POOL_FLAG_ZERO_EVERY_TIME = 1 << 18

const AV_STEREO3D_FLAG_INVERT = 1 << 0

const AV_TDRDI_MAX_NUM_REF_DISPLAY = 32

const AV_TIMECODE_STR_SIZE = 23

const AV_TS_MAX_STRING_SIZE = 32

const AV_PRI_UUID = "%02hhx%02hhx%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx%02hhx%02hhx%02hhx%02hhx"

const AV_PRI_URN_UUID = "urn:uuid:%02hhx%02hhx%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx-%02hhx%02hhx%02hhx%02hhx%02hhx%02hhx"

const AV_UUID_LEN = 16

const LIBAVUTIL_VERSION_MAJOR = 60

const LIBAVUTIL_VERSION_MINOR = 8

const LIBAVUTIL_VERSION_MICRO = 100

const LIBAVUTIL_VERSION_INT = AV_VERSION_INT(LIBAVUTIL_VERSION_MAJOR, LIBAVUTIL_VERSION_MINOR, LIBAVUTIL_VERSION_MICRO)

const LIBAVUTIL_VERSION = AV_VERSION(LIBAVUTIL_VERSION_MAJOR, LIBAVUTIL_VERSION_MINOR, LIBAVUTIL_VERSION_MICRO)

const LIBAVUTIL_BUILD = LIBAVUTIL_VERSION_INT

const FF_API_MOD_UINTP2 = LIBAVUTIL_VERSION_MAJOR < 61

const FF_API_RISCV_FD_ZBA = LIBAVUTIL_VERSION_MAJOR < 61

const FF_API_VULKAN_FIXED_QUEUES = LIBAVUTIL_VERSION_MAJOR < 61

const FF_API_OPT_INT_LIST = LIBAVUTIL_VERSION_MAJOR < 61

const FF_API_OPT_PTR = LIBAVUTIL_VERSION_MAJOR < 61

const SWS_SRC_V_CHR_DROP_MASK = 0x00030000

const SWS_SRC_V_CHR_DROP_SHIFT = 16

const SWS_PARAM_DEFAULT = 123456

const SWS_MAX_REDUCE_CUTOFF = 0.002

const SWS_CS_ITU709 = 1

const SWS_CS_FCC = 4

const SWS_CS_ITU601 = 5

const SWS_CS_ITU624 = 5

const SWS_CS_SMPTE170M = 5

const SWS_CS_SMPTE240M = 7

const SWS_CS_DEFAULT = 5

const SWS_CS_BT2020 = 9

const LIBSWSCALE_VERSION_MINOR = 1

const LIBSWSCALE_VERSION_MICRO = 100

const LIBSWSCALE_VERSION_MAJOR = 9

const LIBSWSCALE_VERSION_INT = AV_VERSION_INT(LIBSWSCALE_VERSION_MAJOR, LIBSWSCALE_VERSION_MINOR, LIBSWSCALE_VERSION_MICRO)

const LIBSWSCALE_VERSION = AV_VERSION(LIBSWSCALE_VERSION_MAJOR, LIBSWSCALE_VERSION_MINOR, LIBSWSCALE_VERSION_MICRO)

const LIBSWSCALE_BUILD = LIBSWSCALE_VERSION_INT

struct_types = Type[]
# Export everything
for name in names(@__MODULE__, all = true)
    name in [Symbol("#eval"), Symbol("#include"), :include, :eval] && continue
    @eval begin
        export $name
        $name isa Type && isstructtype($name) && push!(struct_types, $name)
    end
end

function Base.getproperty(x::Ptr{<:Union{struct_types...}}, f::Symbol)
    T = eltype(x)
    fieldpos = Base.fieldindex(T, f)
    field_pointer = convert(Ptr{fieldtype(T, fieldpos)}, x + fieldoffset(T, fieldpos))
    return field_pointer
end


end # module
