/*
 * Decompiled with CFR 0.152.
 */
package org.scalasbt.ipcsocket;

import java.io.IOException;
import org.scalasbt.ipcsocket.NativeErrorException;
import org.scalasbt.ipcsocket.UnixDomainSocketLibraryProvider;

public class ReferenceCountedFileDescriptor {
    private int fd;
    private int fdRefCount;
    private boolean closePending;
    private final UnixDomainSocketLibraryProvider provider;

    public ReferenceCountedFileDescriptor(int n, UnixDomainSocketLibraryProvider unixDomainSocketLibraryProvider) {
        this.provider = unixDomainSocketLibraryProvider;
        this.fd = n;
        this.fdRefCount = 0;
        this.closePending = false;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public synchronized int acquire() {
        ++this.fdRefCount;
        return this.fd;
    }

    public synchronized void release() throws IOException {
        --this.fdRefCount;
        if (this.fdRefCount == 0 && this.closePending && this.fd != -1) {
            this.doClose();
        }
    }

    public synchronized void close() throws IOException {
        if (this.fd == -1 || this.closePending) {
            return;
        }
        if (this.fdRefCount == 0) {
            this.doClose();
        } else {
            this.closePending = true;
        }
    }

    private void doClose() throws IOException {
        try {
            this.provider.close(this.fd);
            this.fd = -1;
        }
        catch (NativeErrorException nativeErrorException) {
            throw new IOException(nativeErrorException);
        }
    }
}

