/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class Breakpoint
implements IBreakpoint {
    private VirtualMachine vm = null;
    private IEventHub eventHub = null;
    private String className = null;
    private int lineNumber = 0;
    private int hitCount = 0;
    private String condition = null;
    private String logMessage = null;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Breakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n) {
        this(virtualMachine, iEventHub, string, n, 0, null);
    }

    Breakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2) {
        this(virtualMachine, iEventHub, string, n, n2, null);
    }

    Breakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2, String string2) {
        this.vm = virtualMachine;
        this.eventHub = iEventHub;
        this.className = string;
        this.lineNumber = n;
        this.hitCount = n2;
        this.condition = string2;
    }

    Breakpoint(VirtualMachine virtualMachine, IEventHub iEventHub, String string, int n, int n2, String string2, String string3) {
        this(virtualMachine, iEventHub, string, n, n2, string2);
        this.logMessage = string3;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(disposable -> disposable.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IBreakpoint)) {
            return super.equals(object);
        }
        IBreakpoint iBreakpoint = (IBreakpoint)object;
        return Objects.equals(this.className(), iBreakpoint.className()) && this.getLineNumber() == iBreakpoint.getLineNumber();
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int n) {
        this.hitCount = n;
        Observable.fromIterable(this.requests()).filter(eventRequest -> eventRequest instanceof BreakpointRequest).subscribe(eventRequest -> {
            eventRequest.addCountFilter(n);
            eventRequest.enable();
        });
    }

    @Override
    public void setCondition(String string) {
        this.condition = string;
    }

    @Override
    public void setLogMessage(String string) {
        this.logMessage = string;
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        ClassPrepareRequest classPrepareRequest2 = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest2.addClassFilter(this.className + "$*");
        classPrepareRequest2.enable();
        this.requests.add(classPrepareRequest2);
        CompletableFuture<IBreakpoint> completableFuture = new CompletableFuture<IBreakpoint>();
        Disposable disposable = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && (classPrepareRequest.equals(debugEvent.event.request()) || classPrepareRequest2.equals(debugEvent.event.request()))).subscribe(debugEvent -> {
            ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)debugEvent.event;
            List<BreakpointRequest> list = this.createBreakpointRequests(classPrepareEvent.referenceType(), this.lineNumber, this.hitCount, false);
            this.requests.addAll(list);
            if (!list.isEmpty() && !completableFuture.isDone()) {
                this.putProperty("verified", true);
                completableFuture.complete(this);
            }
        });
        this.subscriptions.add(disposable);
        List<ReferenceType> list = this.vm.classesByName(this.className);
        List<BreakpointRequest> list2 = this.createBreakpointRequests(list, this.lineNumber, this.hitCount, true);
        this.requests.addAll(list2);
        if (!list2.isEmpty() && !completableFuture.isDone()) {
            this.putProperty("verified", true);
            completableFuture.complete(this);
        }
        return completableFuture;
    }

    private static List<Location> collectLocations(ReferenceType referenceType, int n) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        try {
            arrayList.addAll(referenceType.locationsOfLine(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private static List<Location> collectLocations(List<ReferenceType> list, int n, boolean bl) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        try {
            list.forEach(referenceType -> {
                List<Location> list2 = Breakpoint.collectLocations(referenceType, n);
                if (!list2.isEmpty()) {
                    arrayList.addAll(list2);
                } else if (bl) {
                    for (ReferenceType referenceType2 : referenceType.nestedTypes()) {
                        List<Location> list3 = Breakpoint.collectLocations(referenceType2, n);
                        if (list3.isEmpty()) continue;
                        arrayList.addAll(list3);
                        break;
                    }
                }
            });
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return arrayList;
    }

    private List<BreakpointRequest> createBreakpointRequests(ReferenceType referenceType, int n, int n2, boolean bl) {
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        arrayList.add(referenceType);
        return this.createBreakpointRequests(arrayList, n, n2, bl);
    }

    private List<BreakpointRequest> createBreakpointRequests(List<ReferenceType> list, int n, int n2, boolean bl) {
        List<Location> list3 = Breakpoint.collectLocations(list, n, bl);
        ArrayList arrayList = new ArrayList(this.requests.size());
        Observable.fromIterable(this.requests).filter(eventRequest -> eventRequest instanceof BreakpointRequest).map(eventRequest -> ((BreakpointRequest)eventRequest).location()).toList().subscribe(list2 -> arrayList.addAll(list2));
        ArrayList arrayList2 = new ArrayList(list3.size());
        Observable.fromIterable(list3).filter(location -> !arrayList.contains(location)).toList().subscribe(list2 -> arrayList2.addAll(list2));
        ArrayList<BreakpointRequest> arrayList3 = new ArrayList<BreakpointRequest>(arrayList2.size());
        arrayList2.forEach(location -> {
            try {
                BreakpointRequest breakpointRequest = this.vm.eventRequestManager().createBreakpointRequest((Location)location);
                breakpointRequest.setSuspendPolicy(1);
                if (n2 > 0) {
                    breakpointRequest.addCountFilter(n2);
                }
                breakpointRequest.enable();
                arrayList3.add(breakpointRequest);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        });
        return arrayList3;
    }

    @Override
    public void putProperty(Object object, Object object2) {
        this.propertyMap.put(object, object2);
    }

    @Override
    public Object getProperty(Object object) {
        return this.propertyMap.get(object);
    }
}

