/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.LoggerFactory;
import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.DebugAdapter;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapter;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.protocol.AbstractProtocolServer;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.sun.jdi.VMDisconnectedException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtocolServer
extends AbstractProtocolServer {
    private IDebugAdapter debugAdapter;
    private UsageDataSession usageDataSession;
    private Object lock = new Object();
    private boolean isDispatchingRequest = false;
    private ConcurrentLinkedQueue<Events.DebugEvent> eventQueue = new ConcurrentLinkedQueue();

    public ProtocolServer(InputStream inputStream, OutputStream outputStream, IProviderContext iProviderContext, LoggerFactory loggerFactory) {
        super(inputStream, outputStream, loggerFactory.create("java-debug"));
        this.debugAdapter = new DebugAdapter(this, iProviderContext, this.logger);
        this.usageDataSession = new UsageDataSession(this.logger, loggerFactory);
    }

    public ProtocolServer(InputStream inputStream, OutputStream outputStream, IProviderContext iProviderContext) {
        this(inputStream, outputStream, iProviderContext, Logger::getLogger);
    }

    @Override
    public void run() {
        this.usageDataSession.reportStart();
        super.run();
        this.usageDataSession.reportStop();
        this.usageDataSession.submitUsageData();
    }

    @Override
    public void sendResponse(Messages.Response response) {
        this.usageDataSession.recordResponse(response);
        super.sendResponse(response);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request) {
        this.usageDataSession.recordRequest(request);
        return super.sendRequest(request);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request, long l) {
        this.usageDataSession.recordRequest(request);
        return super.sendRequest(request, l);
    }

    @Override
    public void sendEvent(Events.DebugEvent debugEvent) {
        if (debugEvent instanceof Events.StoppedEvent) {
            this.sendEventLater(debugEvent);
        } else {
            super.sendEvent(debugEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventLater(Events.DebugEvent debugEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDispatchingRequest) {
                this.eventQueue.offer(debugEvent);
            } else {
                super.sendEvent(debugEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchRequest(Messages.Request request) {
        Object object;
        this.usageDataSession.recordRequest(request);
        try {
            object = this.lock;
            synchronized (object) {
                this.isDispatchingRequest = true;
            }
            ((CompletableFuture)((CompletableFuture)this.debugAdapter.dispatchRequest(request).thenCompose(response -> {
                CompletableFuture completableFuture = new CompletableFuture();
                if (response != null) {
                    this.sendResponse((Messages.Response)response);
                    completableFuture.complete(null);
                } else {
                    completableFuture.completeExceptionally(new DebugException("The request dispatcher should not return null response.", ErrorCode.UNKNOWN_FAILURE.getId()));
                }
                return completableFuture;
            })).exceptionally(throwable -> {
                Messages.Response response = new Messages.Response(request.seq, request.command);
                if (throwable instanceof CompletionException && throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof VMDisconnectedException) {
                    response.success = true;
                    this.sendResponse(response);
                } else {
                    boolean bl;
                    String string = throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
                    ErrorCode errorCode = throwable instanceof DebugException ? ErrorCode.parse(((DebugException)throwable).getErrorCode()) : ErrorCode.UNKNOWN_FAILURE;
                    boolean bl2 = bl = throwable instanceof DebugException && ((DebugException)throwable).isUserError();
                    if (bl) {
                        this.usageDataSession.recordUserError(errorCode);
                    } else {
                        this.logger.log(Level.SEVERE, String.format("[error response][%s]: %s", request.command, string), (Throwable)throwable);
                    }
                    this.sendResponse(AdapterUtils.setErrorResponse(response, errorCode, string));
                }
                return null;
            })).join();
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.isDispatchingRequest = false;
            }
            while (this.eventQueue.peek() != null) {
                super.sendEvent(this.eventQueue.poll());
            }
        }
    }
}

