/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.handler.AbstractLaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class LaunchWithoutDebuggingDelegate
extends AbstractLaunchDelegate {
    protected static final String TERMINAL_TITLE = "Java Process Console";
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;
    private Consumer<IDebugAdapterContext> terminateHandler;

    public LaunchWithoutDebuggingDelegate(Consumer<IDebugAdapterContext> consumer, Logger logger) {
        super(logger);
        this.terminateHandler = consumer;
    }

    @Override
    public Process launch(Requests.LaunchArguments launchArguments, final IDebugAdapterContext iDebugAdapterContext) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        String[] stringArray = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, null);
        File file = null;
        if (launchArguments.cwd != null && Files.isDirectory(Paths.get(launchArguments.cwd, new String[0]), new LinkOption[0])) {
            file = new File(launchArguments.cwd);
        }
        final Process process = Runtime.getRuntime().exec(stringArray, this.constructEnvironmentVariables(launchArguments), file);
        new Thread(){

            @Override
            public void run() {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    LaunchWithoutDebuggingDelegate.this.logger.warning(String.format("Current thread is interrupted. Reason: %s", interruptedException.toString()));
                    process.destroy();
                }
                finally {
                    LaunchWithoutDebuggingDelegate.this.terminateHandler.accept(iDebugAdapterContext);
                }
            }
        }.start();
        this.logger.info("Launching debuggee proccess succeeded.");
        return process;
    }

    @Override
    public void postLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext iDebugAdapterContext) {
    }

    @Override
    public CompletableFuture<Messages.Response> launchInTerminal(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext iDebugAdapterContext) {
        CompletableFuture<Messages.Response> completableFuture = new CompletableFuture<Messages.Response>();
        String[] stringArray = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, null);
        Requests.RunInTerminalRequestArguments runInTerminalRequestArguments = null;
        runInTerminalRequestArguments = launchArguments.console == Requests.CONSOLE.integratedTerminal ? Requests.RunInTerminalRequestArguments.createIntegratedTerminal(stringArray, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE) : Requests.RunInTerminalRequestArguments.createExternalTerminal(stringArray, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE);
        Messages.Request request = new Messages.Request(Requests.Command.RUNINTERMINAL.getName(), (JsonObject)JsonUtils.toJsonTree(runInTerminalRequestArguments, Requests.RunInTerminalRequestArguments.class));
        iDebugAdapterContext.getProtocolServer().sendRequest(request, 10000L).whenComplete((response2, throwable) -> {
            if (response2 != null) {
                if (response2.success) {
                    iDebugAdapterContext.getProtocolServer().sendEvent(new Events.TerminatedEvent());
                    completableFuture.complete(response);
                } else {
                    completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", response2.message), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                }
            } else {
                if (throwable instanceof CompletionException && throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                String string = String.format("Failed to launch debuggee in terminal. Reason: %s", throwable != null ? throwable.toString() : "Null response");
                completableFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", string), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
            }
        });
        return completableFuture;
    }

    @Override
    public void preLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext iDebugAdapterContext) {
        iDebugAdapterContext.setSourcePaths(launchArguments.sourcePaths);
    }
}

