/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;

public class JsonUtils {
    private static final Gson GSON = new Gson();

    public static <T> T fromJson(String string, Class<T> clazz) throws JsonSyntaxException {
        return (T)GSON.fromJson(string, clazz);
    }

    public static <T> T fromJson(String string, Type type) throws JsonSyntaxException {
        return (T)GSON.fromJson(string, type);
    }

    public static <T> T fromJson(JsonElement jsonElement, Class<T> clazz) throws JsonSyntaxException {
        return (T)GSON.fromJson(jsonElement, clazz);
    }

    public <T> T fromJson(JsonElement jsonElement, Type type) throws JsonSyntaxException {
        return (T)GSON.fromJson(jsonElement, type);
    }

    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    public static String toJson(Object object, Type type) {
        return GSON.toJson(object, type);
    }

    public static JsonElement toJsonTree(Object object, Type type) {
        return GSON.toJsonTree(object, type);
    }

    public static int getInt(JsonObject jsonObject, String string, int n) {
        try {
            return jsonObject.getAsInt();
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String getString(JsonObject jsonObject, String string, String string2) {
        String string3 = null;
        try {
            JsonElement jsonElement = jsonObject.get(string);
            string3 = jsonElement.getAsString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 == null) {
            return string2;
        }
        if ((string3 = string3.trim()).length() == 0) {
            return string2;
        }
        return string3;
    }

    public static boolean getBoolean(JsonObject jsonObject, String string, boolean bl) {
        try {
            JsonElement jsonElement = jsonObject.get(string);
            return jsonElement.getAsBoolean();
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public static String[] getStringArray(JsonElement jsonElement, String string) {
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            int n = jsonArray.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = jsonArray.get(i).getAsString();
            }
            return stringArray;
        }
        return new String[0];
    }
}

