/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.JdiMethodResult;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import io.reactivex.disposables.Disposable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StepRequestManager {
    private final Map<Long, ThreadState> threadStates = Collections.synchronizedMap(new HashMap());

    public ThreadState setThreadState(Requests.Command command, ThreadReference threadReference) throws IncompatibleThreadStateException {
        long l = threadReference.uniqueID();
        int n = threadReference.frameCount();
        Location location = threadReference.frame(0).location();
        ThreadState threadState = new ThreadState(l, command, n, location);
        this.threadStates.put(l, threadState);
        return threadState;
    }

    public ThreadState getThreadState(long l) {
        return this.threadStates.get(l);
    }

    public void setMethodResult(long l, JdiMethodResult jdiMethodResult) {
        ThreadState threadState = this.getThreadState(l);
        threadState.methodResult = jdiMethodResult;
    }

    public JdiMethodResult getMethodResult(long l) {
        ThreadState threadState = this.getThreadState(l);
        if (threadState == null) {
            return null;
        }
        return threadState.methodResult;
    }

    public void deletePendingStep(long l, EventRequestManager eventRequestManager) {
        ThreadState threadState = this.getThreadState(l);
        if (threadState != null) {
            threadState.deletePendingStep(eventRequestManager);
        }
    }

    public void deleteAllPendingSteps(EventRequestManager eventRequestManager) {
        this.threadStates.forEach((l, threadState) -> threadState.deletePendingStep(eventRequestManager));
    }

    public void removeMethodResult(long l) {
        ThreadState threadState = this.getThreadState(l);
        if (threadState == null) {
            return;
        }
        threadState.methodResult = null;
    }

    public void removeAllMethodResults() {
        this.threadStates.forEach((l, threadState) -> {
            threadState.methodResult = null;
        });
    }

    public static class ThreadState {
        long threadId;
        Requests.Command stepType;
        StepRequest pendingStepRequest = null;
        MethodExitRequest pendingMethodExitRequest = null;
        int stackDepth;
        Location stepLocation;
        Disposable eventSubscription = null;
        JdiMethodResult methodResult = null;

        public ThreadState(long l, Requests.Command command, int n, Location location) {
            this.threadId = l;
            this.stepType = command;
            this.stackDepth = n;
            this.stepLocation = location;
        }

        public long getThreadId() {
            return this.threadId;
        }

        public Requests.Command getStepType() {
            return this.stepType;
        }

        public void setPendingMethodExitRequest(MethodExitRequest methodExitRequest) {
            this.pendingMethodExitRequest = methodExitRequest;
        }

        public MethodExitRequest getPendingMethodExitRequest() {
            return this.pendingMethodExitRequest;
        }

        public void setPendingStepRequest(StepRequest stepRequest) {
            this.pendingStepRequest = stepRequest;
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public StepRequest getPendingStepRequest() {
            return this.pendingStepRequest;
        }

        public Location getStepLocation() {
            return this.stepLocation;
        }

        public void setEventSubscription(Disposable disposable) {
            this.eventSubscription = disposable;
        }

        public void deletePendingStep(EventRequestManager eventRequestManager) {
            this.deleteStepRequest(eventRequestManager);
            this.deleteMethodExitRequest(eventRequestManager);
            this.eventSubscription.dispose();
        }

        public void deleteStepRequest(EventRequestManager eventRequestManager) {
            if (this.pendingStepRequest == null) {
                return;
            }
            DebugUtility.deleteEventRequestSafely(eventRequestManager, this.pendingStepRequest);
            this.pendingStepRequest = null;
        }

        private void deleteMethodExitRequest(EventRequestManager eventRequestManager) {
            if (this.pendingMethodExitRequest == null) {
                return;
            }
            DebugUtility.deleteEventRequestSafely(eventRequestManager, this.pendingMethodExitRequest);
            this.pendingMethodExitRequest = null;
        }
    }
}

