/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.formatter.ArrayObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.BooleanFormatter;
import com.microsoft.java.debug.core.adapter.formatter.CharacterFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ClassObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NullObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatter;
import com.microsoft.java.debug.core.adapter.formatter.ObjectFormatter;
import com.microsoft.java.debug.core.adapter.formatter.SimpleTypeFormatter;
import com.microsoft.java.debug.core.adapter.formatter.StringObjectFormatter;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.VariableFormatter;

public final class VariableFormatterFactory {
    private VariableFormatterFactory() {
    }

    public static IVariableFormatter createVariableFormatter() {
        VariableFormatter variableFormatter = new VariableFormatter();
        variableFormatter.registerTypeFormatter(new SimpleTypeFormatter(), 1);
        variableFormatter.registerValueFormatter(new BooleanFormatter(), 1);
        variableFormatter.registerValueFormatter(new CharacterFormatter(), 1);
        variableFormatter.registerValueFormatter(new NumericFormatter(), 1);
        variableFormatter.registerValueFormatter(new ObjectFormatter(variableFormatter::typeToString), 1);
        variableFormatter.registerValueFormatter(new NullObjectFormatter(), 1);
        variableFormatter.registerValueFormatter(new StringObjectFormatter(), 2);
        variableFormatter.registerValueFormatter(new ArrayObjectFormatter(variableFormatter::typeToString), 2);
        variableFormatter.registerValueFormatter(new ClassObjectFormatter(variableFormatter::typeToString), 2);
        return variableFormatter;
    }
}

