/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import java.nio.file.Paths;

public class Types {

    public static class Capabilities {
        public boolean supportsConfigurationDoneRequest;
        public boolean supportsHitConditionalBreakpoints;
        public boolean supportsConditionalBreakpoints;
        public boolean supportsEvaluateForHovers;
        public boolean supportsCompletionsRequest;
        public boolean supportsRestartFrame;
        public boolean supportsSetVariable;
        public boolean supportsRestartRequest;
        public boolean supportTerminateDebuggee;
        public boolean supportsDelayedStackTraceLoading;
        public boolean supportsLogPoints;
        public boolean supportsExceptionInfoRequest;
        public ExceptionBreakpointFilter[] exceptionBreakpointFilters = new ExceptionBreakpointFilter[0];
        public boolean supportsDataBreakpoints;
        public boolean supportsClipboardContext;
    }

    public static class ExceptionDetails {
        public String message;
        public String typeName;
        public String fullTypeName;
        public String evaluateName;
        public String stackTrace;
        public ExceptionDetails[] innerException;
    }

    public static enum ExceptionBreakMode {
        NEVER,
        ALWAYS,
        UNHANDLED,
        USERUNHANDLED;

    }

    public static class ExceptionBreakpointFilter {
        public static final String UNCAUGHT_EXCEPTION_FILTER_NAME = "uncaught";
        public static final String CAUGHT_EXCEPTION_FILTER_NAME = "caught";
        public static final String UNCAUGHT_EXCEPTION_FILTER_LABEL = "Uncaught Exceptions";
        public static final String CAUGHT_EXCEPTION_FILTER_LABEL = "Caught Exceptions";
        public String label;
        public String filter;
        public static final ExceptionBreakpointFilter UNCAUGHT_EXCEPTION_FILTER = new ExceptionBreakpointFilter("uncaught", "Uncaught Exceptions");
        public static final ExceptionBreakpointFilter CAUGHT_EXCEPTION_FILTER = new ExceptionBreakpointFilter("caught", "Caught Exceptions");

        public ExceptionBreakpointFilter(String string, String string2) {
            this.filter = string;
            this.label = string2;
        }
    }

    public static class CompletionItem {
        public String label;
        public String text;
        public String type;
        public String sortText;
        public int start;
        public int number;

        public CompletionItem() {
        }

        public CompletionItem(String string, String string2) {
            this.label = string;
            this.text = string2;
        }
    }

    public static class DataBreakpoint {
        public String dataId;
        public DataBreakpointAccessType accessType;
        public String condition;
        public String hitCondition;

        public DataBreakpoint(String string) {
            this.dataId = string;
        }

        public DataBreakpoint(String string, DataBreakpointAccessType dataBreakpointAccessType) {
            this.dataId = string;
            this.accessType = dataBreakpointAccessType;
        }

        public DataBreakpoint(String string, DataBreakpointAccessType dataBreakpointAccessType, String string2, String string3) {
            this.dataId = string;
            this.accessType = dataBreakpointAccessType;
            this.condition = string2;
            this.hitCondition = string3;
        }
    }

    public static enum DataBreakpointAccessType {
        READ("read"),
        WRITE("write"),
        READWRITE("readWrite");

        String label;

        private DataBreakpointAccessType(String string2) {
            this.label = string2;
        }

        public String label() {
            return this.label;
        }
    }

    public static class FunctionBreakpoint {
        public String name;
        public String condition;
        public String hitCondition;

        public FunctionBreakpoint() {
        }

        public FunctionBreakpoint(String string) {
            this.name = string;
        }
    }

    public static class SourceBreakpoint {
        public int line;
        public String hitCondition;
        public String condition;
        public String logMessage;

        public SourceBreakpoint() {
        }

        public SourceBreakpoint(int n, String string, String string2) {
            this.line = n;
            this.condition = string;
            this.hitCondition = string2;
        }
    }

    public static class Breakpoint {
        public int id;
        public boolean verified;
        public int line;
        public String message;

        public Breakpoint(boolean bl) {
            this.verified = bl;
        }

        public Breakpoint(int n, boolean bl) {
            this.id = n;
            this.verified = bl;
        }

        public Breakpoint(int n, boolean bl, int n2, String string) {
            this.id = n;
            this.verified = bl;
            this.line = n2;
            this.message = string;
        }
    }

    public static class Source {
        public String name;
        public String path;
        public int sourceReference;

        public Source() {
        }

        public Source(String string, String string2, int n) {
            this.name = string;
            this.path = string2;
            this.sourceReference = n;
        }

        public Source(String string, int n) {
            this.name = Paths.get(string, new String[0]).getFileName().toString();
            this.path = string;
            this.sourceReference = n;
        }
    }

    public static class Thread {
        public long id;
        public String name;

        public Thread(long l, String string) {
            this.id = l;
            this.name = string == null || string.length() == 0 ? String.format("Thread #%d", l) : string;
        }
    }

    public static class Variable {
        public String name;
        public String value;
        public String type;
        public int variablesReference;
        public int namedVariables;
        public int indexedVariables;
        public String evaluateName;

        public Variable(String string, String string2, String string3, int n, String string4) {
            this.name = string;
            this.value = string2;
            this.type = string3;
            this.variablesReference = n;
            this.evaluateName = string4;
        }

        public Variable(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }

    public static class Scope {
        public String name;
        public int variablesReference;
        public boolean expensive;

        public Scope(String string, int n, boolean bl) {
            this.name = string;
            this.variablesReference = n;
            this.expensive = bl;
        }
    }

    public static class StackFrame {
        public int id;
        public Source source;
        public int line;
        public int column;
        public String name;
        public String presentationHint;

        public StackFrame(int n, String string, Source source, int n2, int n3, String string2) {
            this.id = n;
            this.name = string;
            this.source = source;
            this.line = n2;
            this.column = n3;
            this.presentationHint = string2;
        }
    }

    public static class Message {
        public int id;
        public String format;

        public Message(int n, String string) {
            this.id = n;
            this.format = string;
        }
    }
}

