/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.scala.debugadapter.internal;

import ch.epfl.scala.debugadapter.ClassEntry;
import ch.epfl.scala.debugadapter.DebugToolsResolver;
import ch.epfl.scala.debugadapter.Debuggee;
import ch.epfl.scala.debugadapter.Library;
import ch.epfl.scala.debugadapter.Logger;
import ch.epfl.scala.debugadapter.ManagedEntry;
import ch.epfl.scala.debugadapter.Module;
import ch.epfl.scala.debugadapter.ScalaVersion;
import ch.epfl.scala.debugadapter.ScalaVersion$;
import ch.epfl.scala.debugadapter.internal.DebugTools;
import ch.epfl.scala.debugadapter.internal.ScalaExtension$;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider;
import ch.epfl.scala.debugadapter.internal.SourceLookUpProvider$;
import ch.epfl.scala.debugadapter.internal.TimeUtils$;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler;
import ch.epfl.scala.debugadapter.internal.evaluator.ExpressionCompiler$;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.io.File$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class DebugTools$ {
    public static final DebugTools$ MODULE$ = new DebugTools$();
    private static ClassLoader jdiClassLoader;
    private static final TrieMap<Seq<Path>, ClassLoader> decoderCache;
    private static final Set<String> optionsToRemove;
    private static volatile boolean bitmap$0;

    static {
        decoderCache = TrieMap$.MODULE$.empty();
        optionsToRemove = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Xfatal-warnings", "-Werror", "-indent", "-rewrite"}));
    }

    private TrieMap<Seq<Path>, ClassLoader> decoderCache() {
        return decoderCache;
    }

    private ClassLoader jdiClassLoader$lzycompute() {
        DebugTools$ debugTools$ = this;
        synchronized (debugTools$) {
            if (!bitmap$0) {
                ClassLoader debugAdapterClassLoader = this.getClass().getClassLoader();
                jdiClassLoader = new ClassLoader(debugAdapterClassLoader){
                    private final ClassLoader debugAdapterClassLoader$1;

                    public Class<?> loadClass(String name, boolean resolve) {
                        if (name.startsWith("com.sun.jdi")) {
                            Class<?> cls = this.debugAdapterClassLoader$1.loadClass(name);
                            if (resolve) {
                                this.resolveClass(cls);
                            }
                            return cls;
                        }
                        return super.loadClass(name, resolve);
                    }
                    {
                        this.debugAdapterClassLoader$1 = debugAdapterClassLoader$1;
                        super(null);
                    }
                };
                bitmap$0 = true;
            }
        }
        return jdiClassLoader;
    }

    private ClassLoader jdiClassLoader() {
        if (!bitmap$0) {
            return this.jdiClassLoader$lzycompute();
        }
        return jdiClassLoader;
    }

    public DebugTools none(Logger logger) {
        return new DebugTools((Map<ClassEntry, ExpressionCompiler>)Predef$.MODULE$.Map().empty(), (Option<ClassLoader>)None$.MODULE$, SourceLookUpProvider$.MODULE$.empty(logger));
    }

    public DebugTools apply(Debuggee debuggee, DebugToolsResolver resolver, Logger logger) {
        Map allCompilers = (Map)TimeUtils$.MODULE$.logTime(logger, "Loaded expression compiler", (Function0 & Serializable)() -> MODULE$.loadExpressionCompilers(debuggee, resolver, logger));
        None$ decoder = debuggee.scalaVersion().isScala3() ? (Option)TimeUtils$.MODULE$.logTime(logger, "Loaded step filter", (Function0 & Serializable)() -> MODULE$.loadDecoder(debuggee.scalaVersion(), resolver, logger)) : None$.MODULE$;
        SourceLookUpProvider sourceLookUp = (SourceLookUpProvider)TimeUtils$.MODULE$.logTime(logger, "Loaded all sources and classes", (Function0 & Serializable)() -> {
            Seq<ClassEntry> classEntries = debuggee.classEntries();
            Seq distinctEntries = ((IterableOnceOps)classEntries.groupBy((Function1 & Serializable)e -> e.name()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Seq group = (Seq)tuple2._2();
                    if (group.size() > 1) {
                        logger.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Found duplicate entry ").append(name).append(" in debuggee ").append(debuggee.name()).toString());
                    }
                    return (ClassEntry)group.head();
                }
                throw new MatchError((Object)tuple2);
            })).toSeq();
            return SourceLookUpProvider$.MODULE$.apply((Seq<ClassEntry>)distinctEntries, logger);
        });
        return new DebugTools((Map<ClassEntry, ExpressionCompiler>)allCompilers, (Option<ClassLoader>)decoder, sourceLookUp);
    }

    private Option<ClassLoader> loadDecoder(ScalaVersion scalaVersion, DebugToolsResolver resolver, Logger logger) {
        Option<Seq<Path>> classpath2 = ScalaExtension$.MODULE$.TryExtension(resolver.resolveDecoder(scalaVersion)).warnFailure(logger, new StringBuilder(30).append("Cannot fetch decoder of Scala ").append(scalaVersion).toString());
        return classpath2.map((Function1 & Serializable)classpath -> {
            LazyRef classLoader$lzy = new LazyRef();
            return (ClassLoader)MODULE$.decoderCache().getOrElseUpdate(classpath, (Function0 & Serializable)() -> DebugTools$.classLoader$1(classLoader$lzy, classpath));
        });
    }

    private Map<ClassEntry, ExpressionCompiler> loadExpressionCompilers(Debuggee debuggee, DebugToolsResolver resolver, Logger logger) {
        Seq scala2Entries = (Seq)debuggee.managedEntries().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isScala2()));
        Seq scala3Entries = (Seq)debuggee.managedEntries().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isScala3()));
        ScalaVersion scala2Version = debuggee.scalaVersion().isScala2() ? debuggee.scalaVersion() : (ScalaVersion)debuggee.libraries().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DebugTools$.$anonfun$loadExpressionCompilers$3(x$4))).flatMap((Function1 & Serializable)x$5 -> x$5.scalaVersion()).getOrElse((Function0 & Serializable)() -> ScalaVersion$.MODULE$.2$u002E13());
        ScalaVersion scala3Version = debuggee.scalaVersion().isScala3() ? debuggee.scalaVersion() : (ScalaVersion)debuggee.libraries().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DebugTools$.$anonfun$loadExpressionCompilers$6(x$6))).map((Function1 & Serializable)lib -> new ScalaVersion(lib.version())).getOrElse((Function0 & Serializable)() -> ScalaVersion$.MODULE$.3$u002E1$plus());
        None$ scala3Loader = scala3Entries.isEmpty() ? None$.MODULE$ : DebugTools$.resolveCompilerClassLoader$1(scala3Version, resolver, logger);
        None$ scala2Loader = scala2Entries.isEmpty() ? None$.MODULE$ : DebugTools$.resolveCompilerClassLoader$1(scala2Version, resolver, logger);
        .colon.colon defaultScala2Options = scala3Entries.nonEmpty() ? new .colon.colon((Object)"-Xsource:3", (List)new .colon.colon((Object)"-Ytasty-reader", (List)Nil$.MODULE$)) : new .colon.colon((Object)"-Xsource:3", (List)Nil$.MODULE$);
        String classPath = debuggee.classPath().mkString(File$.MODULE$.pathSeparator());
        return ((IterableOnceOps)debuggee.managedEntries().flatMap(arg_0 -> DebugTools$.$anonfun$loadExpressionCompilers$12(this, (Seq)defaultScala2Options, (Option)scala2Loader, (Option)scala3Loader, classPath, logger, arg_0))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Set<String> optionsToRemove() {
        return optionsToRemove;
    }

    private Seq<String> prepareOptions(Seq<String> options, Seq<String> toAdd) {
        Seq withoutRemoved = (Seq)options.filter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)DebugTools$.$anonfun$prepareOptions$1(o)));
        Seq withAdded = (Seq)withoutRemoved.$plus$plus((IterableOnce)toAdd.filter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)DebugTools$.$anonfun$prepareOptions$2(options, o))));
        return withAdded;
    }

    private static final /* synthetic */ URLClassLoader classLoader$lzycompute$1(LazyRef classLoader$lzy$1, Seq classpath$1) {
        URLClassLoader uRLClassLoader;
        LazyRef lazyRef = classLoader$lzy$1;
        synchronized (lazyRef) {
            uRLClassLoader = classLoader$lzy$1.initialized() ? (URLClassLoader)classLoader$lzy$1.value() : (URLClassLoader)classLoader$lzy$1.initialize((Object)new URLClassLoader((URL[])((IterableOnceOps)classpath$1.map((Function1 & Serializable)x$1 -> x$1.toUri().toURL())).toArray(ClassTag$.MODULE$.apply(URL.class)), MODULE$.jdiClassLoader()));
        }
        return uRLClassLoader;
    }

    private static final URLClassLoader classLoader$1(LazyRef classLoader$lzy$1, Seq classpath$1) {
        if (classLoader$lzy$1.initialized()) {
            return (URLClassLoader)classLoader$lzy$1.value();
        }
        return DebugTools$.classLoader$lzycompute$1(classLoader$lzy$1, classpath$1);
    }

    public static final /* synthetic */ boolean $anonfun$loadExpressionCompilers$3(Library x$4) {
        String string = x$4.artifactId();
        String string2 = "scala-library";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$loadExpressionCompilers$6(Library x$6) {
        return x$6.artifactId().startsWith("scala3-library");
    }

    private static final Option resolveCompilerClassLoader$1(ScalaVersion scalaVersion, DebugToolsResolver resolver$2, Logger logger$2) {
        return ScalaExtension$.MODULE$.TryExtension(resolver$2.resolveExpressionCompiler(scalaVersion)).warnFailure(logger$2, new StringBuilder(42).append("Cannot fetch expression compiler of Scala ").append(scalaVersion).toString());
    }

    private final Option loadExpressionCompiler$1(ManagedEntry entry, Seq defaultScala2Options$1, Option scala2Loader$1, Option scala3Loader$1, String classPath$1, Logger logger$2) {
        Seq<String> seq;
        Seq<String> optionsToAdd = entry.isScala2() ? defaultScala2Options$1 : (Seq)package$.MODULE$.Seq().empty();
        ManagedEntry managedEntry = entry;
        if (managedEntry instanceof Module) {
            Module module = (Module)managedEntry;
            seq = this.prepareOptions(module.scalacOptions(), optionsToAdd);
        } else if (managedEntry instanceof Library) {
            seq = optionsToAdd;
        } else {
            throw new MatchError((Object)managedEntry);
        }
        Seq<String> scalacOptions = seq;
        return (entry.isScala2() ? scala2Loader$1 : (entry.isScala3() ? scala3Loader$1 : None$.MODULE$)).flatMap((Function1 & Serializable)classLoader -> entry.scalaVersion().flatMap((Function1 & Serializable)scalaVersion -> ScalaExtension$.MODULE$.TryExtension(ExpressionCompiler$.MODULE$.apply((ScalaVersion)scalaVersion, scalacOptions, classPath$1, (ClassLoader)classLoader)).warnFailure(logger$2, new StringBuilder(41).append("Cannot load expression compiler of Scala ").append(scalaVersion).toString()).map((Function1 & Serializable)compiler -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry), compiler))));
    }

    public static final /* synthetic */ Option $anonfun$loadExpressionCompilers$12(DebugTools$ $this, Seq defaultScala2Options$1, Option scala2Loader$1, Option scala3Loader$1, String classPath$1, Logger logger$2, ManagedEntry entry) {
        return $this.loadExpressionCompiler$1(entry, defaultScala2Options$1, scala2Loader$1, scala3Loader$1, classPath$1, logger$2);
    }

    public static final /* synthetic */ boolean $anonfun$prepareOptions$1(String o) {
        return !MODULE$.optionsToRemove().contains((Object)o);
    }

    public static final /* synthetic */ boolean $anonfun$prepareOptions$2(Seq options$1, String o) {
        return !options$1.contains((Object)o);
    }

    private DebugTools$() {
    }
}

