/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatAuxiliary;
import gov.nasa.giss.data.nc.exc.NcNullException;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatAuxiliary;
import gov.nasa.giss.math.GeometryUtils;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatAuxiliary3D
extends NcArray2D
implements NcArrayLonLat,
NcArrayLonLatAuxiliary {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double RAD_PER_DEG = Math.PI / 180;
    private VariableDS lonVarDS_;
    private VariableDS latVarDS_;
    private Array lonArray_;
    private Array latArray_;
    private Index lonIndex_;
    private Index latIndex_;
    private int numXs_;
    private int numYs_;
    private int numOs_;
    protected int oDimIndex_ = -1;
    protected int oOffset_;
    protected int xCoordDimIndex_ = -1;
    protected int yCoordDimIndex_ = -1;
    protected int oCoordDimIndex_ = -1;
    private boolean hasBounds_;
    private Array lonBoundsArray_;
    private Array latBoundsArray_;
    private Index lonBoundsIndex_;
    private Index latBoundsIndex_;

    public NcArrayLonLatAuxiliary3D(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.createAxes();
        this.measureAxes();
        this.initGridArrays();
        this.initGridBounds();
        LOGGER.trace("rows  {}", (Object)this.getRowCount());
        LOGGER.trace("cols  {}", (Object)this.getColumnCount());
        LOGGER.trace("other {}", (Object)this.numOs_);
        if (this.lonBoundsIndex_ == null || this.latBoundsIndex_ == null) {
            LOGGER.trace("hasBounds was true but now disabled");
            this.hasBounds_ = false;
        } else {
            LOGGER.trace("hasBounds {}", (Object)this.hasBounds_);
        }
        if (LOGGER.isTraceEnabled()) {
            if (this.hasBounds_) {
                double[][] bcorners = this.getCornersFromBounds(0, 0);
                LOGGER.trace("bcorners {}", (Object)Arrays.deepToString((Object[])bcorners));
            }
            double[][] ecorners = this.estimateCellCornersFor(0, 0);
            LOGGER.trace("ecorners {}", (Object)Arrays.deepToString((Object[])ecorners));
        }
    }

    @Override
    protected void createAxes() {
        VariableDS[] gridvars = NcArrayLonLatAuxiliary.getCoordinateVars(this.dataset_, this.ncvar_.getGrouping(), this.njvarDS_, 3);
        if (gridvars == null) {
            throw new NcNullException("Found null when retrieving auxiliary coordinate vars.");
        }
        this.lonVarDS_ = gridvars[0];
        this.latVarDS_ = gridvars[1];
        int[] gridVarIndices = NcArrayLonLatAuxiliary.getGridVarDimIndices3D(this.dataset_, this.lonVarDS_);
        if (gridVarIndices == null) {
            throw new NcException("Could not isolate the auxiliary grid's 'other' dimension.");
        }
        this.yCoordDimIndex_ = Math.min(gridVarIndices[0], gridVarIndices[1]);
        this.xCoordDimIndex_ = Math.max(gridVarIndices[0], gridVarIndices[1]);
        this.oCoordDimIndex_ = gridVarIndices[2];
        LOGGER.trace("coord y {}, x {}, o {}", this.yCoordDimIndex_, this.xCoordDimIndex_, this.oCoordDimIndex_);
        Dimension xdim = this.lonVarDS_.getDimension(this.xCoordDimIndex_);
        Dimension ydim = this.lonVarDS_.getDimension(this.yCoordDimIndex_);
        Dimension odim = this.lonVarDS_.getDimension(this.oCoordDimIndex_);
        String xname = xdim.getShortName();
        String yname = ydim.getShortName();
        String oname = odim.getShortName();
        LOGGER.trace("names y {}, x {}, o {}", yname, xname, oname);
        this.xDimIndex_ = this.findDimensionIndex(xdim);
        this.yDimIndex_ = this.findDimensionIndex(ydim);
        this.oDimIndex_ = this.findDimensionIndex(odim);
        LOGGER.trace("dim x {}, y {}, o {}", this.xDimIndex_, this.yDimIndex_, this.oDimIndex_);
        if (this.xDimIndex_ < 0) {
            throw new NcException("Could not find dimension " + xname);
        }
        if (this.yDimIndex_ < 0) {
            throw new NcException("Could not find dimension " + yname);
        }
        if (this.oDimIndex_ < 0) {
            throw new NcException("Could not find other dimension " + oname);
        }
        this.numXs_ = xdim.getLength();
        this.numYs_ = ydim.getLength();
        this.numOs_ = odim.getLength();
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, xname, this.numXs_);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, yname, this.numYs_);
    }

    private void initGridArrays() {
        if (this.lonVarDS_ == null) {
            throw new NcNullException("Found null when retrieving auxiliary grid longitude variable.");
        }
        if (this.latVarDS_ == null) {
            throw new NcNullException("Found null when retrieving auxiliary grid latitude variable.");
        }
        try {
            this.lonArray_ = this.lonVarDS_.read();
            this.lonIndex_ = this.lonArray_.getIndex();
            int vrank = this.lonVarDS_.getRank();
            int arank = this.lonArray_.getRank();
            int irank = this.lonIndex_.getRank();
            if (vrank != 3 || arank != 3 || irank != 3) {
                throw new NcException("Lon coordinates variable/array does not have rank 3.");
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read longitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read longitude coordinates array.", exc);
        }
        try {
            this.latArray_ = this.latVarDS_.read();
            this.latIndex_ = this.latArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.debug("Could not read latitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read latitude coordinates array.", exc);
        }
    }

    private void initGridBounds() {
        String lonBoundsName = null;
        String latBoundsName = null;
        try {
            lonBoundsName = this.lonVarDS_.findAttribute("bounds").getStringValue();
        }
        catch (Exception exc) {
            LOGGER.trace("No bounds attribute for longitude.");
        }
        try {
            latBoundsName = this.latVarDS_.findAttribute("bounds").getStringValue();
        }
        catch (Exception exc) {
            LOGGER.trace("No bounds attribute for latitude.");
        }
        if (lonBoundsName == null || latBoundsName == null) {
            return;
        }
        LOGGER.trace("Longitude bounds attribute has value {}", (Object)lonBoundsName);
        LOGGER.trace("Latitude bounds attribute has value {}", (Object)latBoundsName);
        NcDataset dataset = this.getDataset();
        VariableDS lonBoundsVar = dataset.getVariableDS(lonBoundsName);
        VariableDS latBoundsVar = dataset.getVariableDS(latBoundsName);
        if (lonBoundsVar == null || latBoundsVar == null) {
            LOGGER.warn("Unable to find variables matching lon/lat bounds attributes.");
            return;
        }
        LOGGER.trace("Longitude bounds var has rank {}", (Object)lonBoundsVar.getRank());
        LOGGER.trace("Latitude bounds var has rank {}", (Object)latBoundsVar.getRank());
        if (lonBoundsVar.getRank() != 4 || latBoundsVar.getRank() != 4) {
            LOGGER.trace("Bounds var does not have rank 4.");
            return;
        }
        int[] lonbShape = lonBoundsVar.getShape();
        int[] latbShape = lonBoundsVar.getShape();
        if (lonbShape[3] != 4) {
            LOGGER.trace("Lon bounds var appears to define {} corners", (Object)lonbShape[3]);
            return;
        }
        if (latbShape[3] != 4) {
            LOGGER.trace("Lat bounds var appears to define {} corners", (Object)latbShape[3]);
            return;
        }
        int[] lonShape = this.lonVarDS_.getShape();
        for (int i = 0; i < 4; ++i) {
            if (i < 3 && lonShape[i] != lonbShape[i]) {
                LOGGER.trace("Lon and lon bounds vars have mismatch at dimension {}", (Object)i);
                return;
            }
            if (lonbShape[i] == latbShape[i]) continue;
            LOGGER.trace("Lon bounds and lat bounds vars have mismatch at dimension {}", (Object)i);
            return;
        }
        try {
            this.lonBoundsArray_ = lonBoundsVar.read();
            this.lonBoundsIndex_ = this.lonBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read lon axis bounds array");
            return;
        }
        try {
            this.latBoundsArray_ = latBoundsVar.read();
            this.latBoundsIndex_ = this.latBoundsArray_.getIndex();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read lat axis bounds array");
            return;
        }
        this.hasBounds_ = true;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum == this.oDimIndex_) {
            LOGGER.trace("Set other ({}) dim index {}", (Object)dimNum, (Object)index);
            this.oOffset_ = index;
        } else {
            LOGGER.trace("Set dim {} index {}", (Object)dimNum, (Object)index);
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    public double longitudeAt(int col, int row) {
        try {
            switch (this.oCoordDimIndex_) {
                case 0: {
                    this.lonIndex_.set(this.oOffset_, row, col);
                    break;
                }
                case 1: {
                    this.lonIndex_.set(row, this.oOffset_, col);
                    break;
                }
                default: {
                    this.lonIndex_.set(row, col, this.oOffset_);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("lonindex shape {}", (Object)this.lonIndex_.getShape());
                switch (this.oCoordDimIndex_) {
                    case 0: {
                        LOGGER.trace("Requested o {}, row {}, col {}", this.oOffset_, row, col);
                        break;
                    }
                    case 1: {
                        LOGGER.trace("Requested row {}, o {}, col {}", row, this.oOffset_, col);
                        break;
                    }
                    default: {
                        LOGGER.trace("Requested row {}, col {}, b", row, col, this.oOffset_);
                    }
                }
            }
            throw new NcException("Array index out of bounds exc reading lon coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        return this.lonArray_.getDouble(this.lonIndex_);
    }

    @Override
    public double latitudeAt(int col, int row) {
        try {
            switch (this.oCoordDimIndex_) {
                case 0: {
                    this.latIndex_.set(this.oOffset_, row, col);
                    break;
                }
                case 1: {
                    this.latIndex_.set(row, this.oOffset_, col);
                    break;
                }
                default: {
                    this.latIndex_.set(row, col, this.oOffset_);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new NcException("Array index out of bounds exc reading lat coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        double lat = this.latArray_.getDouble(this.latIndex_);
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return Double.NaN;
        }
        return lat;
    }

    @Override
    public PointLL lonLatAt(int col, int row) {
        if (col < 0 || row < 0 || col >= this.numXs_ || row >= this.numYs_) {
            return null;
        }
        return new PointLL(this.longitudeAt(col, row), this.latitudeAt(col, row));
    }

    @Override
    public boolean doCellsAbut(int col1, int row1, int col2, int row2) {
        double[][] cx1 = this.cornerLonLats(col1, row1);
        if (cx1 == null) {
            return false;
        }
        double[][] cx2 = this.cornerLonLats(col2, row2);
        if (cx2 == null) {
            return false;
        }
        double lon11 = cx1[0][0];
        double lon12 = cx1[1][0];
        double lon13 = cx1[2][0];
        double lon14 = cx1[3][0];
        double lon21 = cx2[0][0];
        double lon22 = cx2[1][0];
        double lon23 = cx2[2][0];
        double lon24 = cx2[3][0];
        if (lon21 - 90.0 > lon11) {
            lon21 -= 360.0;
            lon22 -= 360.0;
            lon23 -= 360.0;
            lon24 -= 360.0;
        } else if (lon11 - 90.0 > lon21) {
            lon21 += 360.0;
            lon22 += 360.0;
            lon23 += 360.0;
            lon24 += 360.0;
        }
        if (Math.abs(lon11 - lon21) > 30.0) {
            return false;
        }
        double lat11 = cx1[0][1];
        double lat12 = cx1[1][1];
        double lat13 = cx1[2][1];
        double lat14 = cx1[3][1];
        double lat21 = cx2[0][1];
        double lat22 = cx2[1][1];
        double lat23 = cx2[2][1];
        double lat24 = cx2[3][1];
        double eps = 0.001 * Math.max(Math.abs(lon11 - 0.25 * (lon11 + lon12 + lon13 + lon14)), Math.abs(lat11 - 0.25 * (lat11 + lat12 + lat13 + lat14)));
        if (MathUtils.dequals(lon11, lon22, eps) && MathUtils.dequals(lat11, lat22, eps) && MathUtils.dequals(lon14, lon23, eps) && MathUtils.dequals(lat14, lat23, eps)) {
            return true;
        }
        if (MathUtils.dequals(lon11, lon24, eps) && MathUtils.dequals(lat11, lat24, eps) && MathUtils.dequals(lon12, lon23, eps) && MathUtils.dequals(lat12, lat23, eps)) {
            return true;
        }
        if (MathUtils.dequals(lon13, lon22, eps) && MathUtils.dequals(lat13, lat22, eps) && MathUtils.dequals(lon14, lon21, eps) && MathUtils.dequals(lat14, lat21, eps)) {
            return true;
        }
        return MathUtils.dequals(lon13, lon24, eps) && MathUtils.dequals(lat13, lat24, eps) && MathUtils.dequals(lon12, lon21, eps) && MathUtils.dequals(lat12, lat21, eps);
    }

    @Override
    public double[][] cornerLonLats(int col, int row) {
        if (this.hasBounds_) {
            return this.getCornersFromBounds(col, row);
        }
        return this.estimateCellCornersFor(col, row);
    }

    private double[][] getCornersFromBounds(int col, int row) {
        double lat0;
        double lon0 = this.longitudeAt(col, row);
        if (NcArrayLonLat.isBadLonLat(lon0, lat0 = this.latitudeAt(col, row))) {
            return null;
        }
        if (lon0 > 180.0) {
            lon0 -= 360.0;
        }
        if (lon0 < -180.0) {
            lon0 += 360.0;
        }
        double lon1 = this.boundsCornerLongitudeAt(col, row, 0);
        double lon2 = this.boundsCornerLongitudeAt(col, row, 1);
        double lon3 = this.boundsCornerLongitudeAt(col, row, 2);
        double lon4 = this.boundsCornerLongitudeAt(col, row, 3);
        if (lon0 - lon1 > 45.0) {
            lon1 += 360.0;
        }
        if (lon0 - lon2 > 45.0) {
            lon2 += 360.0;
        }
        if (lon0 - lon3 > 45.0) {
            lon3 += 360.0;
        }
        if (lon0 - lon4 > 45.0) {
            lon4 += 360.0;
        }
        if (lon1 - lon0 > 45.0) {
            lon1 -= 360.0;
        }
        if (lon2 - lon0 > 45.0) {
            lon2 -= 360.0;
        }
        if (lon3 - lon0 > 45.0) {
            lon3 -= 360.0;
        }
        if (lon4 - lon0 > 45.0) {
            lon4 -= 360.0;
        }
        double lat1 = this.boundsCornerLatitudeAt(col, row, 0);
        double lat2 = this.boundsCornerLatitudeAt(col, row, 1);
        double lat3 = this.boundsCornerLatitudeAt(col, row, 2);
        double lat4 = this.boundsCornerLatitudeAt(col, row, 3);
        if (Double.isNaN(lat1)) {
            lat1 = lat0;
        }
        if (Double.isNaN(lat2)) {
            lat2 = lat0;
        }
        if (Double.isNaN(lat3)) {
            lat3 = lat0;
        }
        if (Double.isNaN(lat4)) {
            lat4 = lat0;
        }
        return new double[][]{{lon1, lat1}, {lon2, lat2}, {lon3, lat3}, {lon4, lat4}};
    }

    private double boundsCornerLongitudeAt(int col, int row, int corner) {
        try {
            switch (this.oCoordDimIndex_) {
                case 0: {
                    this.lonBoundsIndex_.set(this.oOffset_, row, col, corner);
                    break;
                }
                case 1: {
                    this.lonBoundsIndex_.set(row, this.oOffset_, col, corner);
                    break;
                }
                default: {
                    this.lonBoundsIndex_.set(row, col, this.oOffset_, corner);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("lonBoundsIndex_ shape {}", (Object)this.lonIndex_.getShape());
                switch (this.oCoordDimIndex_) {
                    case 0: {
                        LOGGER.trace("Requested o {}, row {}, col {}, cnr {}", this.oOffset_, row, col, corner);
                        break;
                    }
                    case 1: {
                        LOGGER.trace("Requested row {}, o {}, col {}, cnr {}", row, this.oOffset_, col, corner);
                        break;
                    }
                    default: {
                        LOGGER.trace("Requested row {}, col {}, o {}, cnr {}", row, col, this.oOffset_, corner);
                    }
                }
            }
            throw new NcException("Array index out of bounds exc reading lon bound coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        return this.lonBoundsArray_.getDouble(this.lonBoundsIndex_);
    }

    private double boundsCornerLatitudeAt(int col, int row, int corner) {
        try {
            switch (this.oCoordDimIndex_) {
                case 0: {
                    this.latBoundsIndex_.set(this.oOffset_, row, col, corner);
                    break;
                }
                case 1: {
                    this.latBoundsIndex_.set(row, this.oOffset_, col, corner);
                    break;
                }
                default: {
                    this.latBoundsIndex_.set(row, col, this.oOffset_, corner);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("latBoundsIndex_ shape {}", (Object)this.latIndex_.getShape());
                switch (this.oCoordDimIndex_) {
                    case 0: {
                        LOGGER.trace("Requested o {}, row {}, col {}, cnr {}", this.oOffset_, row, col, corner);
                        break;
                    }
                    case 1: {
                        LOGGER.trace("Requested row {}, o {}, col {}, cnr {}", row, this.oOffset_, col, corner);
                        break;
                    }
                    default: {
                        LOGGER.trace("Requested row {}, col {}, o {}, cnr {}", row, col, this.oOffset_, corner);
                    }
                }
            }
            throw new NcException("Array index out of bounds exc reading lat bound coordinates.");
        }
        catch (Exception exc) {
            throw exc;
        }
        return this.latBoundsArray_.getDouble(this.latBoundsIndex_);
    }

    private double[][] estimateCellCornersFor(int col, int row) {
        double lat00;
        double lon00 = this.longitudeAt(col, row);
        if (NcArrayLonLat.isBadLonLat(lon00, lat00 = this.latitudeAt(col, row))) {
            return null;
        }
        if (lon00 > 180.0) {
            lon00 -= 360.0;
        }
        if (lon00 < -180.0) {
            lon00 += 360.0;
        }
        int i = col;
        int j = row;
        int im1 = Math.max(i - 1, 0);
        int ip1 = Math.min(i + 1, this.numXs_ - 1);
        int jm1 = Math.max(j - 1, 0);
        int jp1 = Math.min(j + 1, this.numYs_ - 1);
        double lonMM = this.longitudeAt(im1, jm1);
        double lon0M = this.longitudeAt(i, jm1);
        double lonPM = this.longitudeAt(ip1, jm1);
        double lonP0 = this.longitudeAt(ip1, j);
        double lonPP = this.longitudeAt(ip1, jp1);
        double lon0P = this.longitudeAt(i, jp1);
        double lonMP = this.longitudeAt(im1, jp1);
        double lonM0 = this.longitudeAt(im1, j);
        double latMM = this.latitudeAt(im1, jm1);
        double lat0M = this.latitudeAt(i, jm1);
        double latPM = this.latitudeAt(ip1, jm1);
        double latP0 = this.latitudeAt(ip1, j);
        double latPP = this.latitudeAt(ip1, jp1);
        double lat0P = this.latitudeAt(i, jp1);
        double latMP = this.latitudeAt(im1, jp1);
        double latM0 = this.latitudeAt(im1, j);
        if (NcArrayLonLat.isBadLonLat(lonM0, latM0)) {
            lonM0 = lon00;
            latM0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMM, latMM)) {
            lonMM = lon00;
            latMM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0M, lat0M)) {
            lon0M = lon00;
            lat0M = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPM, latPM)) {
            lonPM = lon00;
            latPM = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonP0, latP0)) {
            lonP0 = lon00;
            latP0 = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonPP, latPP)) {
            lonPP = lon00;
            latPP = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lon0P, lat0P)) {
            lon0P = lon00;
            lat0P = lat00;
        }
        if (NcArrayLonLat.isBadLonLat(lonMP, latMP)) {
            lonMP = lon00;
            latMP = lat00;
        }
        if (lon00 - lonMM > 45.0) {
            lonMM += 360.0;
        }
        if (lon00 - lon0M > 45.0) {
            lon0M += 360.0;
        }
        if (lon00 - lonPM > 45.0) {
            lonPM += 360.0;
        }
        if (lon00 - lonP0 > 45.0) {
            lonP0 += 360.0;
        }
        if (lon00 - lonPP > 45.0) {
            lonPP += 360.0;
        }
        if (lon00 - lon0P > 45.0) {
            lon0P += 360.0;
        }
        if (lon00 - lonMP > 45.0) {
            lonMP += 360.0;
        }
        if (lon00 - lonM0 > 45.0) {
            lonM0 += 360.0;
        }
        if (lonMM - lon00 > 45.0) {
            lonMM -= 360.0;
        }
        if (lon0M - lon00 > 45.0) {
            lon0M -= 360.0;
        }
        if (lonPM - lon00 > 45.0) {
            lonPM -= 360.0;
        }
        if (lonP0 - lon00 > 45.0) {
            lonP0 -= 360.0;
        }
        if (lonPP - lon00 > 45.0) {
            lonPP -= 360.0;
        }
        if (lon0P - lon00 > 45.0) {
            lon0P -= 360.0;
        }
        if (lonMP - lon00 > 45.0) {
            lonMP -= 360.0;
        }
        if (lonM0 - lon00 > 45.0) {
            lonM0 -= 360.0;
        }
        if (lonM0 == lon00 && latM0 == lat00) {
            lonMM = lon0M - (lonPM - lon0M);
            latMM = lat0M - (latPM - lat0M);
            lonM0 = lon00 - (lonP0 - lon00);
            latM0 = lat00 - (latP0 - lat00);
            lonMP = lon0P - (lonPP - lon0P);
            latMP = lat0P - (latPP - lat0P);
        } else if (lonP0 == lon00 && latP0 == lat00) {
            lonPM = lon0M + (lon0M - lonMM);
            latPM = lat0M + (lat0M - latMM);
            lonP0 = lon00 + (lon00 - lonM0);
            latP0 = lat00 + (lat00 - latM0);
            lonPP = lon0P + (lon0P - lonMP);
            latPP = lat0P + (lat0P - latMP);
        }
        if (lon0M == lon00 && lat0M == lat00) {
            lonMM = lonM0 - (lonMP - lonM0);
            latMM = latM0 - (latMP - latM0);
            lon0M = lon00 - (lon0P - lon00);
            lat0M = lat00 - (lat0P - lat00);
            lonPM = lonP0 - (lonPP - lonP0);
            latPM = latP0 - (latPP - latP0);
        } else if (lon0P == lon00 && lat0P == lat00) {
            lonMP = lonM0 + (lonM0 - lonMM);
            latMP = latM0 + (latM0 - latMM);
            lon0P = lon00 + (lon00 - lon0M);
            lat0P = lat00 + (lat00 - lat0M);
            lonPP = lonP0 + (lonP0 - lonPM);
            latPP = latP0 + (latP0 - latPM);
        }
        double[] cornerMM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonMM, latMM, lonM0, latM0);
        double[] cornerPM = this.aveFourLL(lon00, lat00, lon0M, lat0M, lonPM, latPM, lonP0, latP0);
        double[] cornerPP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonPP, latPP, lonP0, latP0);
        double[] cornerMP = this.aveFourLL(lon00, lat00, lon0P, lat0P, lonMP, latMP, lonM0, latM0);
        return new double[][]{cornerMM, cornerPM, cornerPP, cornerMP};
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double mindist = Double.POSITIVE_INFINITY;
        double cosLat = Math.cos(lat * (Math.PI / 180));
        double sinLat = Math.sin(lat * (Math.PI / 180));
        int col = -1;
        int row = -1;
        for (int i = 0; i < this.numXs_; ++i) {
            for (int j = 0; j < this.numYs_; ++j) {
                double lat1;
                double lon1;
                try {
                    lon1 = this.longitudeAt(i, j);
                    lat1 = this.latitudeAt(i, j);
                }
                catch (Exception exc) {
                    continue;
                }
                if (Double.isNaN(lon1) || Double.isNaN(lat1)) continue;
                double dlon = lon1 - lon;
                double cosLat1 = Math.cos(lat1 * (Math.PI / 180));
                double sinLat1 = Math.sin(lat1 * (Math.PI / 180));
                double cosAngle = cosLat * cosLat1 * Math.cos(dlon * (Math.PI / 180)) + sinLat * sinLat1;
                double angle = Math.acos(cosAngle);
                if (angle == 0.0) {
                    return new int[]{i, j};
                }
                if (!(angle < mindist)) continue;
                mindist = angle;
                col = i;
                row = j;
            }
        }
        if (col < 0) {
            return null;
        }
        LOGGER.trace("lon,lat {},{}", (Object)lon, (Object)lat);
        LOGGER.trace("col,row {},{}", (Object)col, (Object)row);
        double[][] corners = this.cornerLonLats(col, row);
        if (corners == null) {
            return null;
        }
        if (GeometryUtils.isPointInQuadrilateral(lon, lat, corners[0][0], corners[0][1], corners[1][0], corners[1][1], corners[2][0], corners[2][1], corners[3][0], corners[3][1])) {
            LOGGER.trace("appears to be within quad bound by");
            LOGGER.trace("A {}, {}", (Object)corners[0][0], (Object)corners[0][1]);
            LOGGER.trace("B {}, {}", (Object)corners[1][0], (Object)corners[1][1]);
            LOGGER.trace("C {}, {}", (Object)corners[2][0], (Object)corners[2][1]);
            LOGGER.trace("D {}, {}", (Object)corners[3][0], (Object)corners[3][1]);
            return new int[]{col, row};
        }
        LOGGER.trace("appears to be outside quad");
        return null;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatAuxiliary();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        PointLL ll = this.lonLatAt(col, row);
        double lon = ll.getLon();
        double lat = ll.getLat();
        double gv = this.valueAt(col, row);
        sb.append("Cell [").append(col + 1).append(',').append(row + 1).append(']').append(" at [").append(NcUtils.formatLongitude(lon)).append(' ').append(NcUtils.formatLatitude(lat)).append("] ").append(", value = ").append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsStr();
        if (unitsStr != null && !unitsStr.isEmpty() && !"1".equals(unitsStr)) {
            sb.append(' ').append(unitsStr);
        }
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        NcDataGrouping ncg = ncvar.getGrouping();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatAuxiliary3D.canGridVariable(ncd, ncg, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, NcDataGrouping ncg, VariableDS varDS) {
        VariableDS[] gridvars = NcArrayLonLatAuxiliary.getCoordinateVars(ncd, ncg, varDS, 3);
        boolean canGrid = gridvars != null;
        LOGGER.trace("{}", (Object)canGrid);
        return canGrid;
    }
}

