/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcAxisMethod;
import gov.nasa.giss.data.nc.gridder.NcGridder2D;
import gov.nasa.giss.data.nc.gridder.NcGridderUtils;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.units.Converter;
import ucar.units.Unit;

public class NcGridderXY
extends NcGridder2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double MIN_EXP_FOR_LOG_AXIS = -50.0;
    private static final double MIN_FOR_LOG_AXIS = 1.0E-50;
    protected NcAxisMethod xaxisMethod_ = NcAxisMethod.SCALAR;
    protected NcAxisMethod yaxisMethod_ = NcAxisMethod.SCALAR;
    protected Unit xAxisUdunits_;
    protected Unit yAxisUdunits_;

    public NcGridderXY() {
        this(100, 50);
    }

    public NcGridderXY(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridderXY(int w, int h) {
        this.setSize(w, h);
        this.setBounds(0.0, 0.0, 1.0, 1.0);
    }

    public void setXAxisMethod(NcAxisMethod method) {
        this.xaxisMethod_ = method;
    }

    public void setXAxisUdunits(Unit unit) {
        this.xAxisUdunits_ = unit;
    }

    protected Converter getXAxisUnitsConverter(NcArray2D nca2D) {
        Unit udunits = nca2D.getXAxis().getUdunits();
        if (udunits == null) {
            return null;
        }
        try {
            return udunits.getConverterTo(this.xAxisUdunits_);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setYAxisMethod(NcAxisMethod method) {
        this.yaxisMethod_ = method;
    }

    public void setYAxisUdunits(Unit unit) {
        this.yAxisUdunits_ = unit;
    }

    protected Converter getYAxisUnitsConverter(NcArray2D nca2D) {
        Unit udunits = nca2D.getYAxis().getUdunits();
        if (udunits == null) {
            return null;
        }
        try {
            return udunits.getConverterTo(this.yAxisUdunits_);
        }
        catch (Exception exc) {
            return null;
        }
    }

    protected void prepareGridAxes() {
        this.colXX_ = new double[this.gridWidth_];
        this.rowYY_ = new double[this.gridHeight_];
        if (this.xaxisMethod_ == NcAxisMethod.LOG10) {
            if (this.lBound_ <= 0.0) {
                this.lBound_ = 1.0E-50;
            }
            if (this.rBound_ <= 0.0) {
                this.rBound_ = 1.0E-50;
            }
            double logLBound = Math.log10(this.lBound_);
            double logRBound = Math.log10(this.rBound_);
            double xUnitPerPxl = (logRBound - logLBound) / (double)this.gridWidth_;
            for (int i = 0; i < this.gridWidth_; ++i) {
                this.colXX_[i] = logLBound + ((double)i + 0.5) * xUnitPerPxl;
            }
        } else {
            double xUnitPerPxl = (this.rBound_ - this.lBound_) / (double)this.gridWidth_;
            for (int i = 0; i < this.gridWidth_; ++i) {
                this.colXX_[i] = this.lBound_ + ((double)i + 0.5) * xUnitPerPxl;
            }
        }
        if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
            if (this.tBound_ <= 0.0) {
                this.tBound_ = 1.0E-50;
            }
            if (this.bBound_ <= 0.0) {
                this.bBound_ = 1.0E-50;
            }
            double logTBound = Math.log10(this.tBound_);
            double logBBound = Math.log10(this.bBound_);
            double yUnitPerPxl = (logBBound - logTBound) / (double)this.gridHeight_;
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowYY_[j] = logTBound + ((double)j + 0.5) * yUnitPerPxl;
            }
        } else {
            double yUnitPerPxl = (this.bBound_ - this.tBound_) / (double)this.gridHeight_;
            for (int j = 0; j < this.gridHeight_; ++j) {
                this.rowYY_[j] = this.tBound_ + ((double)j + 0.5) * yUnitPerPxl;
            }
        }
    }

    @Override
    public void regridNoInterpolate(NcArray nca, double[] target) {
        int j;
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        Converter xAxisUnitsConverter = this.getXAxisUnitsConverter(nca2D);
        Converter yAxisUnitsConverter = this.getYAxisUnitsConverter(nca2D);
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        int numXs = xAxis.getValues().length;
        int numYs = yAxis.getValues().length;
        double[][] xBounds = xAxis.getBounds();
        double[][] yBounds = yAxis.getBounds();
        int[] srcRow = new int[this.gridHeight_];
        int[] srcCol = new int[this.gridWidth_];
        block0: for (j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            double top = 0.0;
            double bottom = 0.0;
            for (int jj = 0; jj < numYs; ++jj) {
                if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                    top = jj;
                    bottom = jj + 1;
                } else {
                    top = yBounds[jj][0];
                    bottom = yBounds[jj][1];
                    if (yAxisUnitsConverter != null) {
                        top = yAxisUnitsConverter.convert(top);
                        bottom = yAxisUnitsConverter.convert(bottom);
                    }
                    if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                        top = top > 0.0 ? Math.log10(top) : -50.0;
                        bottom = bottom > 0.0 ? Math.log10(bottom) : -50.0;
                    }
                }
                if (!(this.rowYY_[j] <= top && this.rowYY_[j] > bottom) && (!(this.rowYY_[j] > top) || !(this.rowYY_[j] <= bottom))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        LOGGER.trace("find cols");
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            double left = 0.0;
            double right = 0.0;
            for (int ii = 0; ii < numXs; ++ii) {
                if (this.xaxisMethod_ == NcAxisMethod.INDEX) {
                    left = ii;
                    right = ii + 1;
                } else {
                    left = xBounds[ii][0];
                    right = xBounds[ii][1];
                    if (xAxisUnitsConverter != null) {
                        left = xAxisUnitsConverter.convert(left);
                        right = xAxisUnitsConverter.convert(right);
                    }
                    if (this.xaxisMethod_ == NcAxisMethod.LOG10) {
                        left = left > 0.0 ? Math.log10(left) : -50.0;
                        right = right > 0.0 ? Math.log10(right) : -50.0;
                    }
                }
                if (!(this.colXX_[i] <= left && this.colXX_[i] > right) && (!(this.colXX_[i] > left) || !(this.colXX_[i] <= right))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        LOGGER.trace("do gridding");
        for (j = 0; j < this.gridHeight_; ++j) {
            int i;
            if (srcRow[j] < 0) {
                for (i = 0; i < this.gridWidth_; ++i) {
                    this.setValue(target, i, j, Double.NaN);
                }
                continue;
            }
            for (i = 0; i < this.gridWidth_; ++i) {
                if (srcCol[i] < 0) {
                    this.setValue(target, i, j, Double.NaN);
                    continue;
                }
                double value = nca2D.valueAt(srcCol[i], srcRow[j]);
                if (hasBad && nca2D.isMissingOrInvalid(value)) {
                    value = Double.NaN;
                }
                this.setValue(target, i, j, value);
            }
        }
    }

    @Override
    public void regridInterpolate(NcArray nca, double[] target) {
        this.prepareGridAxes();
        NcArray2D nca2D = (NcArray2D)nca;
        Converter xAxisUnitsConverter = this.getXAxisUnitsConverter(nca2D);
        Converter yAxisUnitsConverter = this.getYAxisUnitsConverter(nca2D);
        boolean hasBad = nca2D.hasBadValues();
        NcAxis xAxis = nca2D.getXAxis();
        NcAxis yAxis = nca2D.getYAxis();
        double[] xVals = xAxis.getValues();
        double[] yVals = yAxis.getValues();
        int numXs = xVals.length;
        int numYs = yVals.length;
        int lastX = numXs - 1;
        int lastY = numYs - 1;
        int[] srcCol = new int[this.gridWidth_];
        int[] srcRow = new int[this.gridHeight_];
        block0: for (int j = 0; j < this.gridHeight_; ++j) {
            srcRow[j] = -1;
            for (int jj = 0; jj < lastY; ++jj) {
                double ynext;
                double ythis;
                if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                    ythis = (double)jj + 0.5;
                    ynext = (double)jj + 1.5;
                } else {
                    ythis = yVals[jj];
                    ynext = yVals[jj + 1];
                    if (yAxisUnitsConverter != null) {
                        ythis = yAxisUnitsConverter.convert(ythis);
                        ynext = yAxisUnitsConverter.convert(ynext);
                    }
                    if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                        if (!(ythis > 0.0)) continue;
                        ythis = Math.log10(ythis);
                        if (!(ynext > 0.0)) continue;
                        ynext = Math.log10(ynext);
                    }
                }
                if (!(this.rowYY_[j] >= ythis && this.rowYY_[j] < ynext) && (!(this.rowYY_[j] <= ythis) || !(this.rowYY_[j] > ynext))) continue;
                srcRow[j] = jj;
                continue block0;
            }
        }
        block2: for (int i = 0; i < this.gridWidth_; ++i) {
            srcCol[i] = -1;
            for (int ii = 0; ii < lastX; ++ii) {
                double xnext;
                double xthis;
                if (this.xaxisMethod_ == NcAxisMethod.INDEX) {
                    xthis = (double)ii + 0.5;
                    xnext = (double)ii + 1.5;
                } else {
                    xthis = xVals[ii];
                    xnext = xVals[ii + 1];
                    if (xAxisUnitsConverter != null) {
                        xthis = xAxisUnitsConverter.convert(xthis);
                        xnext = xAxisUnitsConverter.convert(xnext);
                    }
                    if (this.xaxisMethod_ == NcAxisMethod.LOG10) {
                        if (!(xthis > 0.0)) continue;
                        xthis = Math.log10(xthis);
                        if (!(xnext > 0.0)) continue;
                        xnext = Math.log10(xnext);
                    }
                }
                if (!(this.colXX_[i] >= xthis && this.colXX_[i] < xnext) && (!(this.colXX_[i] <= xthis) || !(this.colXX_[i] > xnext))) continue;
                srcCol[i] = ii;
                continue block2;
            }
        }
        for (int j = 0; j < this.gridHeight_; ++j) {
            double ynext;
            double ythis;
            int rowJ = srcRow[j];
            int rowJP1 = srcRow[j] + 1;
            if (rowJ < 0) continue;
            if (this.yaxisMethod_ == NcAxisMethod.INDEX) {
                ythis = (double)rowJ + 0.5;
                ynext = (double)rowJP1 + 0.5;
            } else {
                ythis = yVals[rowJ];
                ynext = yVals[rowJP1];
                if (yAxisUnitsConverter != null) {
                    ythis = yAxisUnitsConverter.convert(ythis);
                    ynext = yAxisUnitsConverter.convert(ynext);
                }
                if (this.yaxisMethod_ == NcAxisMethod.LOG10) {
                    ythis = Math.log10(ythis);
                    ynext = Math.log10(ynext);
                }
            }
            double yPct = (this.rowYY_[j] - ythis) / (ynext - ythis);
            for (int i = 0; i < this.gridWidth_; ++i) {
                double xnext;
                double xthis;
                int colI = srcCol[i];
                int colIP1 = srcCol[i] + 1;
                if (colI < 0) continue;
                if (this.xaxisMethod_ == NcAxisMethod.INDEX) {
                    xthis = (double)colI + 0.5;
                    xnext = (double)colIP1 + 0.5;
                } else {
                    xthis = xVals[colI];
                    xnext = xVals[colIP1];
                    if (xAxisUnitsConverter != null) {
                        xthis = xAxisUnitsConverter.convert(xthis);
                        xnext = xAxisUnitsConverter.convert(xnext);
                    }
                    if (this.xaxisMethod_ == NcAxisMethod.LOG10) {
                        xthis = Math.log10(xthis);
                        xnext = Math.log10(xnext);
                    }
                }
                double xPct = (this.colXX_[i] - xthis) / (xnext - xthis);
                double valTL = nca2D.valueAt(colI, rowJ);
                double valTR = nca2D.valueAt(colIP1, rowJ);
                double valBL = nca2D.valueAt(colI, rowJP1);
                double valBR = nca2D.valueAt(colIP1, rowJP1);
                if (hasBad) {
                    if (nca2D.isMissingOrInvalid(valTL)) {
                        valTL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valTR)) {
                        valTR = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBL)) {
                        valBL = Double.NaN;
                    }
                    if (nca2D.isMissingOrInvalid(valBR)) {
                        valBR = Double.NaN;
                    }
                }
                double value = NcGridderUtils.bilinearInterpolate(xPct, yPct, valTL, valTR, valBL, valBR);
                this.setValue(target, i, j, value);
            }
        }
    }

    protected void setValue(double[] array, int col, int row, double value) {
        if (col < 0 || col >= this.gridWidth_) {
            return;
        }
        if (row < 0 || row >= this.gridHeight_) {
            return;
        }
        int index = row * this.gridWidth_ + col;
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Index out of bounds.");
        }
        array[index] = value;
    }
}

