/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.BinaryColorTable;
import java.awt.Color;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdobeColorTable
extends BinaryColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AdobeColorTable() {
        this(256);
    }

    public AdobeColorTable(int count) {
        this.initiateVariableSizeArray(count, 256);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("ACT");
    }

    public AdobeColorTable(File f) throws FileNotFoundException, IOException {
        super(f, 768, 772);
    }

    public AdobeColorTable(URL url) throws IOException {
        super(url, 768, 772);
    }

    public AdobeColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("ACT");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        AdobeColorTable c = new AdobeColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public byte[] getBytes() {
        int i;
        byte[] b = new byte[772];
        int isize = this.getColorCount();
        for (i = 0; i < isize; ++i) {
            Color c = this.getColorAt(i);
            b[i * 3 + 0] = (byte)c.getRed();
            b[i * 3 + 1] = (byte)c.getGreen();
            b[i * 3 + 2] = (byte)c.getBlue();
        }
        for (i = isize; i < 256; ++i) {
            b[i * 3 + 0] = 0;
            b[i * 3 + 1] = 0;
            b[i * 3 + 2] = 0;
        }
        if (isize == 256) {
            b[768] = 1;
            b[769] = 0;
        } else {
            b[768] = 0;
            b[769] = (byte)isize;
        }
        b[770] = 1;
        b[771] = 0;
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws EOFException {
        if (b.length < 768) {
            throw new EOFException("Not a valid ACT color table");
        }
        int size = 256;
        if (b.length >= 770) {
            byte byte768 = b[768];
            byte byte769 = b[769];
            if (byte768 == 1 && byte769 == 0) {
                size = 256;
            } else if (byte768 == 0 && byte769 == 0) {
                size = 256;
            } else if (byte768 == 0) {
                size = byte769 & 0xFF;
            } else {
                LOGGER.warn("Color table {} tries to define {} > 256 colors", (Object)this.getName(), (Object)size);
                size = 256;
            }
        }
        this.initiateVariableSizeArray(size, 256);
        for (int i = 0; i < size; ++i) {
            int ii = i * 3;
            this.setColorAt(i, new Color(0xFF & b[ii], 0xFF & b[ii + 1], 0xFF & b[ii + 2]));
        }
    }
}

