/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.CmykColor;
import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.HsvColor;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.io.FileUtils;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CptColorTable
extends AbstractColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int FAUX_BINS = 800;
    private Model model_ = Model.RGB;
    private boolean devo_;

    public CptColorTable() {
        this(100);
    }

    public CptColorTable(int count) {
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("CPT");
    }

    public CptColorTable(File f) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        try (FileReader fr = new FileReader(f);
             BufferedReader br = new BufferedReader(fr);){
            this.parseColorTable(br);
        }
    }

    public CptColorTable(URL url) throws IOException, ParseException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             InputStreamReader isr = new InputStreamReader(bis);
             BufferedReader br = new BufferedReader(isr);){
            this.parseColorTable(br);
        }
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        CptColorTable c = new CptColorTable(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        int i;
        String oneLine;
        Color bColor = null;
        Color fColor = null;
        Color nColor = null;
        this.model_ = null;
        ArrayList<Segment> segList = new ArrayList<Segment>(100);
        int linesRead = 0;
        while ((oneLine = bReader.readLine()) != null) {
            ++linesRead;
            if (oneLine.length() == 0) {
                LOGGER.trace("Line {} is empty", (Object)linesRead);
                continue;
            }
            if (oneLine.charAt(0) == '#') {
                if (oneLine.contains("GISS_DEVO")) {
                    this.devo_ = true;
                    continue;
                }
                if (!oneLine.contains("COLOR_MODEL")) continue;
                if (this.model_ != null) {
                    LOGGER.debug("Cannot set CPT color model twice in {}", (Object)this.getName());
                    throw new ParseException("Cannot set color model twice.", linesRead);
                }
                if (oneLine.contains("RGB")) {
                    this.model_ = Model.RGB;
                    continue;
                }
                if (oneLine.contains("CMYK")) {
                    this.model_ = Model.CMYK;
                    continue;
                }
                if (oneLine.contains("HSV")) {
                    this.model_ = Model.HSV;
                    continue;
                }
                LOGGER.debug("Unknown color model in line {}", (Object)linesRead);
                throw new ParseException("CPT file has unknown color model.", linesRead);
            }
            if (this.model_ == null) {
                this.model_ = Model.RGB;
            }
            oneLine = oneLine.replaceFirst("^\\*.*", "");
            oneLine = oneLine.replaceFirst("^\\;.*", "");
            oneLine = oneLine.replaceFirst("^\\s(L|U|B)\\s.*", "");
            oneLine = oneLine.replaceFirst("^\\s+", "");
            String[] tokens = (oneLine = oneLine.replaceFirst("\\s+$", "")).split("\\s+");
            int numTokens = tokens.length;
            if (numTokens < 1 || numTokens == 1 && tokens[0].length() == 0) continue;
            try {
                double v2;
                if (tokens[0].equals("B") || tokens[0].equals("F") || tokens[0].equals("N")) {
                    Object c;
                    if (numTokens == 2) {
                        c = tokens[1].equals("-") ? UNDEFINED_COLOR : this.lookupColor(tokens[1]);
                    } else if (numTokens == 5 && this.model_ == Model.CMYK) {
                        c = this.getCmykColor(tokens[1], tokens[2], tokens[3], tokens[4]);
                    } else if (numTokens == 4 && this.model_ == Model.RGB) {
                        c = this.getRGBColor(tokens[1], tokens[2], tokens[3]);
                    } else if (numTokens == 4 && this.model_ == Model.HSV) {
                        c = this.getHsvColor(tokens[1], tokens[2], tokens[3]);
                    } else {
                        throw new Exception("Bad token count for '" + tokens[0] + "' color");
                    }
                    if (tokens[0].equals("B")) {
                        bColor = c;
                        continue;
                    }
                    if (tokens[0].equals("F")) {
                        fColor = c;
                        continue;
                    }
                    nColor = c;
                    continue;
                }
                if (numTokens == 4) {
                    double v1 = Double.parseDouble(tokens[0]);
                    v2 = Double.parseDouble(tokens[2]);
                    if (tokens[1].equals("-") || tokens[3].equals("-")) {
                        segList.add(new Segment(v1, v2, null, null));
                        continue;
                    }
                    Color color1 = this.lookupColor(tokens[1]);
                    Color color2 = this.lookupColor(tokens[3]);
                    segList.add(new Segment(v1, v2, color1, color2));
                    continue;
                }
                if (numTokens >= 10 && this.model_ == Model.CMYK) {
                    double v1 = Double.parseDouble(tokens[0]);
                    v2 = Double.parseDouble(tokens[5]);
                    segList.add(new Segment(v1, v2, this.getCmykColor(tokens[1], tokens[2], tokens[3], tokens[4]), this.getCmykColor(tokens[6], tokens[7], tokens[8], tokens[9])));
                    continue;
                }
                if (numTokens >= 8 && this.model_ == Model.RGB) {
                    double v1 = Double.parseDouble(tokens[0]);
                    v2 = Double.parseDouble(tokens[4]);
                    segList.add(new Segment(v1, v2, this.getRGBColor(tokens[1], tokens[2], tokens[3]), this.getRGBColor(tokens[5], tokens[6], tokens[7])));
                    continue;
                }
                if (numTokens >= 8 && this.model_ == Model.HSV) {
                    double v1 = Double.parseDouble(tokens[0]);
                    v2 = Double.parseDouble(tokens[4]);
                    segList.add(new Segment(v1, v2, this.getHsvColor(tokens[1], tokens[2], tokens[3]), this.getHsvColor(tokens[5], tokens[6], tokens[7])));
                    continue;
                }
                throw new Exception("Bad token count: " + numTokens);
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new ParseException("Exception parsing CPT file", linesRead);
            }
        }
        if (nColor == null) {
            nColor = UNDEFINED_COLOR;
            this.setNanColor(UNDEFINED_COLOR);
        } else if (nColor instanceof HsvColor) {
            this.setNanColor(((HsvColor)((Object)nColor)).toRGBColor());
        } else if (nColor instanceof CmykColor) {
            this.setNanColor(((CmykColor)((Object)nColor)).toRGBColor());
        } else {
            this.setNanColor(nColor);
        }
        for (int i2 = 0; i2 < segList.size(); ++i2) {
            Segment seg = (Segment)segList.get(i2);
            if (seg.color1_ != null && seg.color2_ != null) continue;
            if (nColor == null) {
                throw new ParseException("Zone " + (i2 + 1) + " uses undefined NaN color", 0);
            }
            seg.color1_ = nColor;
            seg.color2_ = nColor;
        }
        Comparator<Segment> segmentsCmp = new Comparator<Segment>(){

            @Override
            public int compare(Segment seg1, Segment seg2) {
                Double d1 = seg1.val1_;
                Double d2 = seg2.val1_;
                return d1.compareTo(d2);
            }
        };
        Collections.sort(segList, segmentsCmp);
        this.initiateFixedSizeArray(800);
        double rmin = ((Segment)segList.get((int)0)).val1_;
        double rmax = ((Segment)segList.get((int)(segList.size() - 1))).val2_;
        this.setRangeMinimum(rmin);
        this.setRangeMaximum(rmax);
        double range = rmax - rmin;
        double delta = range / 800.0;
        int lastjj = 0;
        block4: for (i = 0; i < 800; ++i) {
            double val = rmin + delta * (0.5 + (double)i);
            for (int j = lastjj; j < segList.size(); ++j) {
                Segment seg = (Segment)segList.get(j);
                if (val < seg.val1_ || val >= seg.val2_) continue;
                double pct = (val - seg.val1_) / (seg.val2_ - seg.val1_);
                Object o1 = seg.color1_;
                Object o2 = seg.color2_;
                if (o1 instanceof HsvColor && o2 instanceof HsvColor) {
                    HsvColor hsv1 = (HsvColor)o1;
                    HsvColor hsv2 = (HsvColor)o2;
                    float h = hsv1.getH() + (float)pct * (hsv2.getH() - hsv1.getH());
                    float s = hsv1.getS() + (float)pct * (hsv2.getS() - hsv1.getS());
                    float v = hsv1.getV() + (float)pct * (hsv2.getV() - hsv1.getV());
                    this.setColorAt(i, Color.getHSBColor(h, s, v));
                } else {
                    Color c1 = o1 instanceof HsvColor ? ((HsvColor)o1).toRGBColor() : (o1 instanceof CmykColor ? ((CmykColor)o1).toRGBColor() : (Color)o1);
                    Color c2 = o2 instanceof HsvColor ? ((HsvColor)o2).toRGBColor() : (o2 instanceof CmykColor ? ((CmykColor)o2).toRGBColor() : (Color)o2);
                    int r1 = c1.getRed();
                    int r2 = c2.getRed();
                    int g1 = c1.getGreen();
                    int g2 = c2.getGreen();
                    int b1 = c1.getBlue();
                    int b2 = c2.getBlue();
                    int r = (int)((double)r1 + pct * (double)(r2 - r1));
                    int g = (int)((double)g1 + pct * (double)(g2 - g1));
                    int b = (int)((double)b1 + pct * (double)(b2 - b1));
                    this.setColorAt(i, new Color(r, g, b));
                }
                lastjj = j;
                continue block4;
            }
        }
        for (i = 0; i < 800; ++i) {
            if (this.getColorAt(i) != null) continue;
            this.setColorAt(i, UNDEFINED_COLOR);
        }
        if (bColor == null) {
            this.setMinOutlierColor(this.getColorAt(0));
        } else if (bColor instanceof HsvColor) {
            this.setMinOutlierColor(((HsvColor)((Object)bColor)).toRGBColor());
        } else if (nColor instanceof CmykColor) {
            this.setMinOutlierColor(((CmykColor)((Object)bColor)).toRGBColor());
        } else {
            this.setMinOutlierColor(bColor);
        }
        if (fColor == null) {
            this.setMaxOutlierColor(this.getColorAt(799));
        } else if (fColor instanceof HsvColor) {
            this.setMaxOutlierColor(((HsvColor)((Object)fColor)).toRGBColor());
        } else if (nColor instanceof CmykColor) {
            this.setMaxOutlierColor(((CmykColor)((Object)fColor)).toRGBColor());
        } else {
            this.setMaxOutlierColor(fColor);
        }
    }

    private Color lookupColor(String name) throws ParseException {
        try {
            int shade = Integer.parseInt(name);
            if (this.model_ == Model.CMYK) {
                float f = 0.01f * (100.0f - (float)shade);
                return new Color(f, f, f);
            }
            return new Color(shade, shade, shade);
        }
        catch (Exception exception) {
            return ColorUtils.parseColor(name);
        }
    }

    private Color getRGBColor(String r, String g, String b) {
        try {
            int r1 = Integer.parseInt(r);
            if (r1 < 0 || r1 > 255) {
                throw new IllegalArgumentException("R value out range 0 to 255");
            }
            int g1 = Integer.parseInt(g);
            if (g1 < 0 || g1 > 255) {
                throw new IllegalArgumentException("G value out range 0 to 255");
            }
            int b1 = Integer.parseInt(b);
            if (b1 < 0 || b1 > 255) {
                throw new IllegalArgumentException("B value out range 0 to 255");
            }
            return new Color(r1, g1, b1);
        }
        catch (Exception r1) {
            if (this.devo_) {
                try {
                    float r12 = Float.parseFloat(r);
                    r12 = Math.max(r12, 0.0f);
                    r12 = Math.min(r12, 1.0f);
                    float g1 = Float.parseFloat(g);
                    g1 = Math.max(g1, 0.0f);
                    g1 = Math.min(g1, 1.0f);
                    float b1 = Float.parseFloat(b);
                    b1 = Math.max(b1, 0.0f);
                    b1 = Math.min(b1, 1.0f);
                    return new Color(r12, g1, b1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Could not parse RGB vals");
        }
    }

    private CmykColor getCmykColor(String c, String m, String y, String k) {
        int c1 = Integer.parseInt(c);
        if (c1 < 0 || c1 > 100) {
            throw new IllegalArgumentException("C value outside valid range");
        }
        int m1 = Integer.parseInt(m);
        if (m1 < 0 || m1 > 100) {
            throw new IllegalArgumentException("M value outside valid range");
        }
        int y1 = Integer.parseInt(y);
        if (y1 < 0 || y1 > 100) {
            throw new IllegalArgumentException("Y value outside valid range");
        }
        int k1 = Integer.parseInt(k);
        if (k1 < 0 || k1 > 100) {
            throw new IllegalArgumentException("K value outside valid range");
        }
        return new CmykColor(c1, m1, y1, k1);
    }

    private HsvColor getHsvColor(String h, String s, String v) {
        float h1 = (float)Integer.parseInt(h) * 0.0027777778f;
        if (h1 < 0.0f || h1 > 1.0f) {
            throw new IllegalArgumentException("H value outside valid range");
        }
        float s1 = Float.parseFloat(s);
        if (s1 < 0.0f || s1 > 100.0f) {
            throw new IllegalArgumentException("S value outside valid range");
        }
        float v1 = Float.parseFloat(v);
        if (v1 < 0.0f || v1 > 100.0f) {
            throw new IllegalArgumentException("V value outside valid range");
        }
        return new HsvColor(h1, s1, v1);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        try (FileWriter fw = new FileWriter(f);){
            boolean bl;
            try (BufferedWriter out = new BufferedWriter(fw);){
                String froot = FileUtils.extractFnameRoot(f.getName());
                out.write("# Color table " + froot + "\n");
                out.write("# Generated by GissUtils.CptColorTable\n");
                out.write("#\n");
                switch (this.model_) {
                    case CMYK: {
                        out.write("# Converted from CMYK input\n");
                        out.write("#\n");
                        break;
                    }
                    case HSV: {
                        out.write("# Converted from HSV input\n");
                        out.write("#\n");
                        break;
                    }
                }
                out.write("# COLOR_MODEL = RGB\n");
                int ccount = this.getColorCount();
                for (int i = 0; i < ccount; ++i) {
                    Color c = this.getColorAt(i);
                    String cstr = this.getColorString(c);
                    out.write(i + ".0\t");
                    out.write(cstr);
                    out.write("\t" + (i + 1) + ".0\t");
                    out.write(cstr);
                    out.write("\n");
                }
                out.write("B\t");
                out.write(this.getColorString(this.getMinOutlierColor()));
                out.write("\n");
                out.write("F\t");
                out.write(this.getColorString(this.getMaxOutlierColor()));
                out.write("\n");
                out.write("N\t");
                out.write(this.getColorString(this.getNanColor()));
                out.write("\n");
                bl = true;
            }
            return bl;
        }
        catch (Exception exc) {
            LOGGER.error("Failed to save CPT color table due to {}", (Object)exc.getMessage());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
    }

    private String getColorString(Color c) {
        switch (this.model_) {
            case CMYK: {
                return null;
            }
            case HSV: {
                return null;
            }
        }
        return c.getRed() + "\t" + c.getGreen() + "\t" + c.getBlue();
    }

    private final class Segment {
        final double val1_;
        final double val2_;
        Object color1_;
        Object color2_;

        Segment(double val1, double val2, Object color1, Object color2) {
            this.val1_ = val1;
            this.val2_ = val2;
            this.color1_ = color1;
            this.color2_ = color2;
        }
    }

    private static enum Model {
        RGB,
        CMYK,
        HSV;

    }
}

