/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalPseudocylindric
extends QuadSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int PROPERTIES = 8;
    private boolean global_ = true;

    public GlobalPseudocylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    public boolean isGlobal() {
        return this.global_;
    }

    protected final void setGlobalProj(boolean global) {
        this.global_ = global;
        this.autoscale();
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Point2D.Double dot;
        if (this.global_) {
            this.drawMeridianNoLabel(g2d, this.lambdaC_ - 179.99999, 90.0);
            this.drawMeridianNoLabel(g2d, this.lambdaC_ + 179.99999, 90.0);
        } else {
            this.drawMeridianNoLabel(g2d, this.lambdaC_ - 89.99999, 90.0);
            this.drawMeridianNoLabel(g2d, this.lambdaC_ + 89.99999, 90.0);
        }
        Point2D.Double double_ = dot = this.global_ ? this.transformLL2XY(this.lambdaC_ + 179.99999, 90.0) : this.transformLL2XY(this.lambdaC_ + 89.99999, 90.0);
        if (dot == null) {
            LOGGER.debug("NPE getting NP dot");
            return;
        }
        LOGGER.trace("NP dot {}", (Object)dot);
        if (Math.abs(dot.x - (double)this.outCenterX_) < 1.0E-5) {
            LOGGER.trace("NP looks like point pole");
            return;
        }
        GraphicUtils.drawLine(g2d, dot.x, dot.y, 2.0 * (double)this.outCenterX_ - dot.x, dot.y);
        GraphicUtils.drawLine(g2d, dot.x, 2.0 * (double)this.outCenterY_ - dot.y, 2.0 * (double)this.outCenterX_ - dot.x, 2.0 * (double)this.outCenterY_ - dot.y);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double llon = this.global_ ? this.lambdaC_ - 179.99999 : this.lambdaC_ - 89.99999;
        double rlon = this.global_ ? this.lambdaC_ + 179.99999 : this.lambdaC_ + 89.99999;
        Point2D.Double dot1 = this.transformLL2XY(llon, lat);
        Point2D.Double dot2 = this.transformLL2XY(rlon, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        FontMetrics fm = g2x.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dot2.x - (double)fh2 - (double)w);
        g2x.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)(0.5f * (float)des)));
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot1, dot2);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (this.global_ ? absLambda > 179.99999 : absLambda > 89.99999) {
            return;
        }
        if (label == null || label.length() == 0) {
            this.drawMeridianNoLabel(g2d, lon, maxLat);
            return;
        }
        Point2D.Double dot1 = this.transformLL2XY(lon, -62.0);
        Point2D.Double dot2 = this.transformLL2XY(lon, -64.5);
        if (dot1 == null || dot2 == null) {
            return;
        }
        double xave = 0.5 * (dot1.x + dot2.x);
        float ybot = (float)dot2.y;
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(xave - 0.5 * (double)w);
        g2d.drawString(label, labelx, ybot - (float)des);
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, ybot - (float)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        this.drawMeridianNoLabel(g2x, lon, maxLat);
        g2x.dispose();
    }

    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double pt;
        double absLambda = Math.abs(this.lonToLambda(lon));
        if (absLambda < 1.0E-5) {
            Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>(1000);
        double lat = -maxLat;
        while (lat < maxLat) {
            pt = this.transformLL2XY(lon, lat);
            if (pt == null) {
                LOGGER.trace("null pt at LL {},{}", (Object)lon, (Object)lat);
            }
            pts.add(pt);
            if (Math.abs(lat) > maxLat - 0.5) {
                lat += 0.05;
                continue;
            }
            if (Math.abs(lat) > 85.0) {
                lat += 0.15;
                continue;
            }
            lat += 0.4;
        }
        pt = this.transformLL2XY(lon, maxLat);
        pts.add(pt);
        ProjGraphicUtils.drawBezier(g2d, pts);
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }
}

