/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ProjExtraParameter;
import java.util.Objects;

public class ProjIntegerParameter
extends ProjExtraParameter {
    private int value_;
    private int defaultValue_;
    private int min_;
    private int max_;
    private boolean minAllowed_ = true;
    private boolean maxAllowed_ = true;

    public ProjIntegerParameter(String description, String label, String units, int value) {
        this(description, label, units, value, Integer.MIN_VALUE, Integer.MAX_VALUE, true, true);
    }

    public ProjIntegerParameter(String description, String label, String units, int value, int min, int max) {
        this(description, label, units, value, min, max, true, true);
    }

    public ProjIntegerParameter(String description, String label, String units, int value, int min, int max, boolean minAllowed, boolean maxAllowed) {
        super(description, label, units);
        this.min_ = min;
        this.max_ = max;
        this.minAllowed_ = minAllowed;
        this.maxAllowed_ = maxAllowed;
        this.defaultValue_ = value;
        this.setValue(this.defaultValue_);
    }

    @Override
    public final void reset() {
        this.setValue(this.defaultValue_);
    }

    public final int getDefault() {
        return this.defaultValue_;
    }

    public final int getValue() {
        return this.value_;
    }

    public int getMinimum() {
        return this.min_;
    }

    public int getMaximum() {
        return this.max_;
    }

    public final boolean isMinimumInclusive() {
        return this.minAllowed_;
    }

    public final boolean isMaximumInclusive() {
        return this.maxAllowed_;
    }

    @Override
    public final Object getDefaultObject() {
        return this.defaultValue_;
    }

    @Override
    public final Object getValueObject() {
        return this.value_;
    }

    @Override
    public final void setValue(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value is not an Integer.");
        }
        this.setValue((Integer)value);
    }

    @Override
    public final void setValue(String value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "Value must not be null.");
        try {
            int i = Integer.parseInt(value);
            this.setValue(i);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not an integer: " + value);
        }
    }

    public final void setValue(int newval) throws IllegalArgumentException {
        if (newval == this.value_) {
            return;
        }
        if (newval < this.min_) {
            throw new IllegalArgumentException("Value less than min: " + newval + " < " + this.min_);
        }
        if (newval <= this.min_ && !this.minAllowed_) {
            throw new IllegalArgumentException("Value must be greater than min: " + newval + " <= " + this.min_);
        }
        if (newval > this.max_) {
            throw new IllegalArgumentException("Value greater than max: " + newval + " > " + this.max_);
        }
        if (newval >= this.max_ && !this.maxAllowed_) {
            throw new IllegalArgumentException("Value must be less than max: " + newval + " >= " + this.max_);
        }
        this.value_ = newval;
        this.fireChange();
    }
}

