/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnyderMEFlatPole
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Snyder Minimum-Error Flat Pole";
    private static final double B1 = 1.24126;
    private static final double B3 = 0.3197;
    private static final double B5 = -0.00768;
    private static final double MAX_X_OVER_RS = 2.530970669795041;
    private static final double MAX_Y_OVER_RS = SnyderMEFlatPole.getYForPhi(1.5707963267948966);

    public SnyderMEFlatPole(int width, int height) {
        this(width, height, 0, 0);
    }

    public SnyderMEFlatPole(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.530970669795041, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(Math.abs(lat));
        double phiRad2 = phiRad * phiRad;
        double y = SnyderMEFlatPole.getYForPhi(phiRad);
        double f1 = 1.24126 + phiRad2 * (0.3197 + -0.00768 * phiRad2);
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = lambdaRad / f1;
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        if (Double.isNaN(phiRad) || phiRad > 1.5707963267948966) {
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double f1 = 1.24126 + phiRad2 * (0.3197 + -0.00768 * phiRad2);
        double lambdaRad = absXOverRS * f1;
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SnyderMEFlatPole snyderMEFlatPole = this;
        synchronized (snyderMEFlatPole) {
            double y;
            double yOverRS;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = this.iteratePhiRad(Math.abs(yOverRS = (y = (double)iy + 0.5) * this.invRS_))) > 1.5707963267948966); ++iy) {
                double x;
                double xOverRS;
                double lambdaRad;
                double phiRad2 = phiRad * phiRad;
                double f1 = 1.24126 + phiRad2 * (0.3197 + -0.00768 * phiRad2);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (xOverRS = (x = (double)ix + 0.5) * this.invRS_) * f1) > Math.PI); ++ix) {
                    double phi = Math.toDegrees(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    private static double getYForPhi(double phiRad) {
        if (Math.abs(phiRad) < 1.0E-5) {
            return 0.0;
        }
        if (Math.abs(phiRad - 1.5707963267948966) < 1.0E-5) {
            double phiTerm1 = 0.4674011002723395;
            double phiTerm2 = 6.088068189625152;
            return 1.3870074534618446;
        }
        double phiRad2 = phiRad * phiRad;
        double phiRad3 = phiRad * phiRad2;
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double phiTerm1 = phiRad2 * sinPhi + 2.0 * phiRad * cosPhi - 2.0 * sinPhi;
        double phiTerm2 = phiRad3 * (phiRad * sinPhi + 4.0 * cosPhi);
        return 1.24126 * sinPhi + 0.3197 * phiTerm1 + -0.00768 * (phiTerm2 - 12.0 * phiTerm1);
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * (yOverRS / MAX_Y_OVER_RS);
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double phiRad3 = phiRad * phiRad2;
            double cosPhi = Math.cos(phiRad);
            double sinPhi = Math.sin(phiRad);
            double phiTerm1 = phiRad2 * sinPhi + 2.0 * phiRad * cosPhi - 2.0 * sinPhi;
            double phiTerm2 = phiRad3 * (phiRad * sinPhi + 4.0 * cosPhi);
            double func = 1.24126 * sinPhi + 0.3197 * phiTerm1 + -0.00768 * (phiTerm2 - 12.0 * phiTerm1) - yOverRS;
            double dfunc = (1.24126 + 0.3197 * phiRad2 + -0.00768 * phiRad2 * phiRad2) * cosPhi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }
}

