/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiltedPerspective
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Tilted Perspective";
    public static final int PROPERTIES = 0xA00000;
    private static final double DEFAULT_P = 2.0;
    private double pDist_;
    private double invP_;
    private double pMinus1_;
    private double capH_;
    private double pPlus1_;
    private double maxZ_;
    private double rhoEdgeOverR_;
    private double yshift_;
    private double cosGamma_;
    private double sinGamma_;
    private double omega_;
    private double cosOmega_;
    private double sinOmega_;
    private double sinOmegaOverH_;
    private final ProjDoubleParameter pDistParam_;
    private final ProjDoubleParameter azimParam_;
    private final ProjDoubleParameter tiltParam_;
    private final ProjDoubleParameter scalingParam_;
    private static final double MIN_SCALING = 0.75;
    private static final double MAX_SCALING = 10.0;
    private static final double DFLT_SCALING = 1.5;
    private double cosPhiC_;
    private double sinPhiC_;

    public TiltedPerspective(int width, int height) {
        this(width, height, 0, 0);
    }

    public TiltedPerspective(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0xA00000, width, height, xmargin, ymargin, 1.0, 1.0);
        this.setCenter(this.lambdaC_, this.phiC_);
        this.pDistParam_ = new ProjDoubleParameter("Distance between observer and center of body", "Center distance", "Radii (P>1)", 2.0, 1.0, Double.POSITIVE_INFINITY, false, true);
        this.azimParam_ = new ProjDoubleParameter("Azimuth (clockwise)", "Azimuth", "\u00b0", 0.0, -360.0, 360.0, true, true);
        this.tiltParam_ = new ProjDoubleParameter("Tilt-up angle", "Tilt-up angle", "\u00b0", 0.0, -90.0, 90.0, false, false);
        this.scalingParam_ = new ProjDoubleParameter("Scaling", "Scaling", "\u2009(0.75\u2009\u2264\u2009S\u2009\u2264\u200910.0)", 1.5, 0.75, 10.0, true, true);
        this.addParameter(this.pDistParam_);
        this.addParameter(this.azimParam_);
        this.addParameter(this.tiltParam_);
        this.addParameter(this.scalingParam_);
        this.finishConstruction();
    }

    @Override
    public final boolean isScalingEnabled() {
        return true;
    }

    @Override
    public final ProjDoubleParameter getScalingParameter() {
        return this.scalingParam_;
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.cosPhiC_ = Math.cos(this.phiCRad_);
        this.sinPhiC_ = Math.sin(this.phiCRad_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null) {
            this.setObserverDistance(this.pDistParam_.getValue());
            this.setAzimuthAngle(this.azimParam_.getValue());
            this.setTiltUpAngle(this.tiltParam_.getValue());
            this.setScaling(this.scalingParam_.getValue());
        } else if (p.equals(this.pDistParam_)) {
            this.setObserverDistance(this.pDistParam_.getValue());
        } else if (p.equals(this.azimParam_)) {
            this.setAzimuthAngle(this.azimParam_.getValue());
        } else if (p.equals(this.tiltParam_)) {
            this.setTiltUpAngle(this.tiltParam_.getValue());
        } else if (p.equals(this.scalingParam_)) {
            this.setScaling(this.scalingParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setObserverDistance(double pDist) {
        if (pDist <= 1.0) {
            throw new IllegalArgumentException("Distance P must be greater than 1.");
        }
        this.pDist_ = pDist;
        this.pMinus1_ = this.pDist_ - 1.0;
        this.pPlus1_ = this.pDist_ + 1.0;
        this.invP_ = 1.0 / this.pDist_;
        this.capH_ = this.pMinus1_;
        this.autoscale();
    }

    private void setTiltUpAngle(double omega) {
        this.omega_ = omega;
        double omegaRad = Math.toRadians(omega);
        this.cosOmega_ = Math.cos(omegaRad);
        this.sinOmega_ = Math.sin(omegaRad);
        this.autoscale();
    }

    private void setAzimuthAngle(double gamma) {
        double gammaRad = Math.toRadians(gamma);
        this.cosGamma_ = Math.cos(gammaRad);
        this.sinGamma_ = Math.sin(gammaRad);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.maxZ_ = Math.toDegrees(Math.acos(this.invP_));
        this.rhoEdgeOverR_ = Math.sqrt(this.pMinus1_ / this.pPlus1_);
        this.sinOmegaOverH_ = this.sinOmega_ / this.capH_;
        double yfac1 = Math.abs(this.rhoEdgeOverR_ / (this.rhoEdgeOverR_ * this.sinOmegaOverH_ + this.cosOmega_));
        double yfac2 = Math.abs(-this.rhoEdgeOverR_ / (-this.rhoEdgeOverR_ * this.sinOmegaOverH_ + this.cosOmega_));
        double yfac = Math.min(yfac1, yfac2);
        double xfac = yfac * (double)this.getUsedWidth() / (double)this.getUsedHeight();
        this.setMaxXYOverRS(xfac, yfac);
    }

    @Override
    protected final void finishScaling() {
        double fraction = 1.0 / this.scalingParam_.getValue();
        this.yshift_ = fraction == 1.0 ? 0.0 : (1.0 / fraction - 1.0) * 0.5 * (double)this.getUsedHeight() * Math.signum(this.sinOmega_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double yt;
        double xt;
        double lambdaRad = this.lonToLambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double sinLambda = Math.sin(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double cosZ = this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda;
        if (cosZ < this.invP_) {
            return null;
        }
        double kP = this.pMinus1_ / (this.pDist_ - cosZ);
        double xVP = kP * cosPhi * sinLambda;
        double yVP = kP * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        double xpp = xVP * this.cosGamma_ - yVP * this.sinGamma_;
        double ypp = yVP * this.cosGamma_ + xVP * this.sinGamma_;
        if (this.cosOmega_ < 1.0) {
            double capA = ypp * this.sinOmegaOverH_ + this.cosOmega_;
            if (capA < 0.0) {
                return null;
            }
            double invA = 1.0 / capA;
            xt = xpp * this.cosOmega_ * invA;
            yt = ypp * invA;
        } else {
            xt = xpp;
            yt = ypp;
        }
        xt = (double)this.outCenterX_ + xt * this.rS_;
        yt = (double)this.outCenterY_ - yt * this.rS_ + this.yshift_;
        return new Point2D.Double(xt, yt);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double capQ;
        double capM;
        double xxx = xx - (double)this.outCenterX_;
        double yyy = (double)this.outCenterY_ - yy + this.yshift_;
        double xt = xxx * this.invRS_;
        double yt = yyy * this.invRS_;
        if (this.cosOmega_ < 0.0) {
            double invHMinusYtSinOmega = 1.0 / (this.capH_ - yt * this.sinOmega_);
            if (invHMinusYtSinOmega < 0.0) {
                return null;
            }
            capM = this.capH_ * xt * invHMinusYtSinOmega;
            capQ = this.capH_ * yt * this.cosOmega_ * invHMinusYtSinOmega;
        } else {
            capM = xt;
            capQ = yt * this.cosOmega_;
        }
        double xVP = capM * this.cosGamma_ + capQ * this.sinGamma_;
        double yVP = capQ * this.cosGamma_ - capM * this.sinGamma_;
        double rho = Math.hypot(xVP, yVP);
        if (rho > this.rhoEdgeOverR_) {
            return null;
        }
        double[] lambdaPhi = this.invertVerticalPerspective(xVP, yVP, rho);
        if (lambdaPhi == null) {
            return null;
        }
        double lambda = lambdaPhi[0];
        double phi = lambdaPhi[1];
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TiltedPerspective tiltedPerspective = this;
        synchronized (tiltedPerspective) {
            if (this.pMinus1_ <= 0.0) {
                return;
            }
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double invHMinusYtSinOmega;
                double yyy = (double)iy + 0.5 + this.yshift_;
                double yt = yyy * this.invRS_;
                double d = invHMinusYtSinOmega = this.cosOmega_ < 1.0 ? 1.0 / (this.capH_ - yt * this.sinOmega_) : 1.0 / this.capH_;
                if (invHMinusYtSinOmega < 0.0) continue;
                double capQ = this.cosOmega_ < 1.0 ? this.capH_ * yt * this.cosOmega_ * invHMinusYtSinOmega : yt * this.cosOmega_;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double yVP;
                    double xxx = (double)ix + 0.5;
                    double xt = xxx * this.invRS_;
                    double capM = this.cosOmega_ < 1.0 ? this.capH_ * xt * invHMinusYtSinOmega : xt;
                    double xVP = capM * this.cosGamma_ + capQ * this.sinGamma_;
                    double rho = Math.hypot(xVP, yVP = capQ * this.cosGamma_ - capM * this.sinGamma_);
                    if (rho > this.rhoEdgeOverR_) {
                        if (ix <= 0) continue;
                        continue block3;
                    }
                    double[] lambdaPhi = this.invertVerticalPerspective(xVP, yVP, rho);
                    if (lambdaPhi == null) continue;
                    double lambda = lambdaPhi[0];
                    double phi = lambdaPhi[1];
                    this.setInvPoint(ix, iy, this.lambdaC_ + lambda, phi);
                }
            }
        }
    }

    private double[] invertVerticalPerspective(double x, double y, double rho) {
        double upper = this.pDist_ - Math.sqrt(1.0 - rho * rho * this.pPlus1_ / this.pMinus1_);
        double lower = this.pMinus1_ / rho + rho / this.pMinus1_;
        double sinZ = upper / lower;
        double zRad = Math.asin(sinZ);
        double cosZ = Math.cos(zRad);
        double sinPhi = cosZ * this.sinPhiC_ + y * sinZ * this.cosPhiC_ / rho;
        double phiRad = Math.asin(sinPhi);
        double lambdaRad = Math.atan2(x * sinZ, rho * this.cosPhiC_ * cosZ - y * this.sinPhiC_ * sinZ);
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Area border1 = new Area(this.getMarginRect0());
        if (this.cosOmega_ == 1.0) {
            double radius = this.rhoEdgeOverR_ * this.rS_;
            Area border2 = new Area(new Ellipse2D.Double((double)this.outCenterX_ - radius, (double)this.outCenterY_ - radius + this.yshift_, 2.0 * radius, 2.0 * radius));
            border1.intersect(border2);
        } else {
            int perdeg = 3;
            int steps = 1080;
            double stepsize = 0.3333333333333333;
            double start = this.omega_ > 0.0 ? 180.0 : 0.0;
            ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>(1080);
            for (int i = 0; i <= 1080; ++i) {
                double theta = start + (double)i * 0.3333333333333333;
                double thetaRad = Math.toRadians(theta);
                double xpp = this.rhoEdgeOverR_ * Math.sin(thetaRad);
                double ypp = this.rhoEdgeOverR_ * Math.cos(thetaRad);
                double capA = ypp * this.sinOmegaOverH_ + this.cosOmega_;
                if (capA <= 0.0) continue;
                double invA = 1.0 / capA;
                double xt = xpp * this.cosOmega_ * invA;
                double yt = ypp * invA;
                xt = (double)this.outCenterX_ + xt * this.rS_;
                yt = (double)this.outCenterY_ - yt * this.rS_ + this.yshift_;
                pts.add(new Point2D.Double(xt, yt));
            }
            Bezier bezier = new Bezier(false, pts);
            Path2D.Double bpath = bezier.getPath();
            bpath.closePath();
            Area border2 = new Area(bpath);
            border1.intersect(border2);
        }
        g2d.draw(border1);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        ArrayList<PointLL> llpts = new ArrayList<PointLL>(500);
        boolean nearPole = Math.abs(this.phiC_) + this.maxZ_ > 90.0;
        double startLon = nearPole ? -180.0 : this.lambdaC_ - this.maxZ_;
        double endLon = nearPole ? 180.0 : this.lambdaC_ + this.maxZ_;
        double step = Math.max(0.01, (endLon - startLon) / 500.0);
        for (double lon = startLon; lon < endLon; lon += step) {
            llpts.add(new PointLL(lon, lat));
        }
        llpts.add(new PointLL(endLon, lat));
        PointLL[] llPtArray = llpts.toArray(new PointLL[llpts.size()]);
        ProjGraphicUtils.drawBezier(g2d, this.translatePath(llPtArray));
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        ArrayList<PointLL> llpts = new ArrayList<PointLL>(500);
        double maxLatX = Math.min(this.phiC_ + this.maxZ_, maxLat);
        double step = Math.max(0.01, this.maxZ_ / 500.0);
        for (double lat = Math.max(this.phiC_ - this.maxZ_, -maxLat); lat < maxLatX; lat += step) {
            llpts.add(new PointLL(lon, lat));
        }
        llpts.add(new PointLL(lon, maxLatX));
        PointLL[] llPtArray = llpts.toArray(new PointLL[llpts.size()]);
        ProjGraphicUtils.drawBezier(g2d, this.translatePath(llPtArray));
    }
}

