/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner1
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner I";
    private ProjListParameter variantParam_ = new ProjListParameter("Variant", "Variant", Variant.class, 0);
    private Variant variant_;
    private double cx_ = 1.0;
    private double cy_ = 1.0;
    private double cm_ = 1.0;
    private double invCx_ = 1.0;
    private double invCy_ = 1.0;
    private double invCm_ = 1.0;
    private double invCxRS_ = 1.0;
    private double invCyRS_ = 1.0;

    public Wagner1(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner1(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.cx_ = this.variant_.getCx();
        this.cy_ = this.variant_.getCy();
        this.cm_ = this.variant_.getCm();
        this.invCx_ = 1.0 / this.cx_;
        this.invCy_ = 1.0 / this.cy_;
        this.invCm_ = 1.0 / this.cm_;
        double wfactor = this.cx_ * Math.PI;
        double hfactor = this.cy_ * Math.asin(this.cm_);
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final void finishScaling() {
        this.invCxRS_ = this.invCx_ * this.invRS_;
        this.invCyRS_ = this.invCy_ * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double psiRad = Math.asin(this.cm_ * Math.sin(Math.toRadians(lat)));
        double x = this.cx_ * this.lonToLambdaRad(lon) * Math.cos(psiRad);
        double y = this.cy_ * psiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double psiRad = y * this.invCyRS_;
        double d = phiRad = psiRad == 0.0 ? 0.0 : Math.asin(Math.sin(psiRad) * this.invCm_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double d2 = lambdaRad = x == 0.0 ? 0.0 : x * this.invCxRS_ / Math.cos(psiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner1 wagner1 = this;
        synchronized (wagner1) {
            double y;
            double psiRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin(Math.sin(psiRad = (y = (double)iy + 0.5) * this.invCyRS_) * this.invCm_)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invCxRS_ / Math.cos(psiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private static enum Variant implements ProjListEnum
    {
        WAGNER1("Wagner I", 0.8660254037844386, 0.6666666666666666),
        CANTERSW01("Canters W01", 0.6938, 0.5158);

        private String text_;
        private double cx_;
        private double cy_;
        private double cm_;

        private Variant(String text, double m, double n2) {
            this.text_ = text;
            this.cx_ = n2 / Math.sqrt(n2 * m);
            this.cy_ = 1.0 / Math.sqrt(n2 * m);
            this.cm_ = m;
        }

        double getCx() {
            return this.cx_;
        }

        double getCy() {
            return this.cy_;
        }

        double getCm() {
            return this.cm_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

