/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjIntegerParameter;
import gov.nasa.giss.map.proj.ui.ProjParamComponent;
import gov.nasa.giss.ui.spinner.IntSpinner;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjIntegerComponent
extends ProjParamComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 181L;
    private ProjIntegerParameter parameter_;
    private IntSpinner spinner_;

    public ProjIntegerComponent(ProjIntegerParameter xparam) {
        this(xparam, xparam.getDefault());
    }

    public ProjIntegerComponent(ProjIntegerParameter xparam, int value) {
        super(xparam);
        this.parameter_ = xparam;
        this.createLayout(value);
        this.attachListeners();
    }

    @Override
    public JComponent getComponent() {
        return this.spinner_;
    }

    private void createLayout(int value) {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        JLabel nLabel = new JLabel(this.parameter_.getLabel() + ":\u2009");
        nLabel.setOpaque(false);
        this.add(nLabel);
        int min = this.parameter_.getMinimum();
        int max = this.parameter_.getMaximum();
        this.spinner_ = new IntSpinner(value, min, max, 1);
        this.add(this.spinner_);
        String punits = this.parameter_.getUnits();
        if (punits != null && punits.length() > 0) {
            JLabel uLabel = new JLabel(punits);
            uLabel.setOpaque(false);
            this.add(uLabel);
        }
    }

    private void attachListeners() {
        this.spinner_.addChangeListener(e -> {
            try {
                this.spinner_.commitEdit();
            }
            catch (Exception exc) {
                LOGGER.warn("Failed attaching listener {}", (Object)e);
            }
            this.handleChange();
        });
    }

    @Override
    public void reset() {
        this.spinner_.setValue(this.parameter_.getDefault());
        this.handleChange();
    }

    @Override
    public String getStringValue() {
        return this.getValue().toString();
    }

    public int getIntegerValue() {
        return this.parameter_.getValue();
    }

    public int getMinValue() {
        return this.parameter_.getMinimum();
    }

    public int getMaxValue() {
        return this.parameter_.getMaximum();
    }

    @Override
    public Object getValue() {
        return this.parameter_.getValue();
    }

    @Override
    public void setValue(String sval) {
        Objects.requireNonNull(sval, "Value must not be null.");
        try {
            this.setValue(Integer.parseInt(sval));
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Value is not an Integer: " + sval);
        }
    }

    public void setValue(int ival) {
        this.spinner_.setValue(ival);
        this.parameter_.setValue(ival);
        this.spinner_.repaint();
        this.fireValueChanged();
    }

    @Override
    protected void handleChange() {
        int oldval;
        int newval = this.spinner_.getIntValue();
        if (newval == (oldval = this.parameter_.getValue())) {
            return;
        }
        this.parameter_.setValue(newval);
        this.fireValueChanged();
    }
}

