/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj.ui;

import gov.nasa.giss.map.proj.ProjExtraParameter;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProjParamComponent
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long serialVersionUID = 181L;
    private final Object lock_ = new Object();
    private final EventListenerList listenerList_ = new EventListenerList();
    private final ProjExtraParameter parameter_;

    public ProjParamComponent(ProjExtraParameter xparam) {
        this.parameter_ = xparam;
    }

    public ProjExtraParameter getParameter() {
        return this.parameter_;
    }

    public abstract JComponent getComponent();

    public abstract void reset();

    public abstract void setValue(String var1);

    public abstract String getStringValue();

    public abstract Object getValue();

    protected abstract void handleChange();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.add(ChangeListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.remove(ChangeListener.class, l);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList_.getListeners(ChangeListener.class);
    }

    protected void fireValueChanged() {
        ChangeListener[] listeners;
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : listeners = (ChangeListener[])this.listenerList_.getListeners(ChangeListener.class)) {
            try {
                l.stateChanged(e);
            }
            catch (Exception exc) {
                LOGGER.debug("Exc {}", (Object)exc.getMessage());
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
    }
}

