/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.menu.PanAbstractBookmarksMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.prefs.PanBookmark;
import gov.nasa.giss.panoply.prefs.PanBookmarkType;
import gov.nasa.giss.panoply.prefs.PanHistoryFolder;
import gov.nasa.giss.panoply.prefs.PanHistoryList;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PanHistoryMenu
extends PanAbstractBookmarksMenu {
    private final int topItemsCount_;
    private final JMenuItem miLastDataset_;
    private final JMenuItem miLastCatalog_;
    private final JMenuItem miClearRecent_;
    private PanBookmark lastDataset_;
    private PanBookmark lastCatalog_;

    public PanHistoryMenu(final PanFrame parent) {
        super(parent, "history-menu");
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanHistoryMenu.this.lastDataset_ != null) {
                    PanHistoryMenu.this.lastDataset_.open(parent);
                }
                PanHistoryMenu.this.refreshPrivate();
            }
        };
        this.miLastDataset_ = this.makeItemFromProperties("reopen-last-dataset", a);
        this.add(this.miLastDataset_);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PanHistoryMenu.this.lastCatalog_ != null) {
                    PanHistoryMenu.this.lastCatalog_.open(parent);
                }
                PanHistoryMenu.this.refreshPrivate();
            }
        };
        this.miLastCatalog_ = this.makeItemFromProperties("reopen-last-catalog", a);
        this.add(this.miLastCatalog_);
        this.addSeparator();
        this.topItemsCount_ = this.getItemCount();
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanHistoryList.getSharedInstance().clear();
                PanHistoryMenu.this.refreshPrivate();
            }
        };
        this.miClearRecent_ = this.makeItemFromProperties("clear-history", a);
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        int msize = this.getItemCount();
        for (int i = this.topItemsCount_; i < msize; ++i) {
            this.remove(this.topItemsCount_);
        }
        TreeTableNode[] bobs = PanHistoryList.getSharedInstance().getChildren();
        this.lastDataset_ = null;
        this.lastCatalog_ = null;
        for (TreeTableNode o : bobs) {
            if (o instanceof PanHistoryFolder) {
                PanHistoryFolder hf = (PanHistoryFolder)o;
                for (TreeTableNode child : hf.getChildren()) {
                    if (child instanceof PanBookmark) {
                        PanBookmark b = (PanBookmark)child;
                        if (b.getAccessType() == PanBookmarkType.CATALOG) {
                            if (this.lastCatalog_ == null) {
                                this.lastCatalog_ = b;
                            }
                        } else if (this.lastDataset_ == null) {
                            this.lastDataset_ = b;
                        }
                    }
                    if (this.lastDataset_ != null && this.lastCatalog_ != null) break;
                }
            }
            if (this.lastDataset_ != null && this.lastCatalog_ != null) break;
        }
        boolean animating = PanPlotFrame.isAnimationInProgress();
        this.miLastDataset_.setEnabled(this.lastDataset_ != null && !animating);
        this.miLastCatalog_.setEnabled(this.lastCatalog_ != null && !animating);
        for (TreeTableNode bob : bobs) {
            if (bob instanceof PanHistoryFolder && ((PanHistoryFolder)bob).isTodayFolder()) {
                PanHistoryFolder today = ((PanHistoryFolder)bob).copy();
                int isize = Math.min(12, today.getChildCount());
                for (int i = 0; i < isize; ++i) {
                    PanBookmark b = (PanBookmark)today.remove(0);
                    this.addBookmarkNode(this, b);
                }
                if (today.getChildCount() > 0 || bobs.length > 1) {
                    this.addSeparator();
                }
                if (today.getChildCount() <= 0) continue;
                this.addBookmarkNode(this, today);
                continue;
            }
            this.addBookmarkNode(this, bob);
        }
        if (bobs.length > 0) {
            this.addSeparator();
            this.add(this.miClearRecent_).setEnabled(true);
        } else {
            this.add(this.miClearRecent_).setEnabled(false);
        }
    }
}

