/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanGridLabelStep;
import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPlotConstraints {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int MIN_SIZE_FACTOR = 80;
    public static final int MAX_SIZE_FACTOR = 300;
    public static final int MAX_SIZE_FACTOR_CL = 500;
    public static final int MIN_HEIGHT_FACTOR = 20;
    public static final int MAX_HEIGHT_FACTOR = 400;
    public static final int MIN_WIDTH_FACTOR = 20;
    public static final int MAX_WIDTH_FACTOR = 100;
    public static final int MIN_CBAR_LENGTH = 50;
    public static final int MAX_CBAR_LENGTH = 100;
    public static final int MIN_BORDER_WGT = 25;
    public static final int MAX_BORDER_WGT = 300;
    public static final int MIN_AXIS_TICK_WGT = 25;
    public static final int MAX_AXIS_TICK_WGT = 200;
    public static final int MIN_CBAR_BORDER_WGT = 0;
    public static final int MAX_CBAR_BORDER_WGT = 150;
    public static final int MIN_LINE_STROKE_WGT = 0;
    public static final int MAX_LINE_STROKE_WGT = 500;
    public static final int MIN_TRAJ_STROKE_WGT = 0;
    public static final int MAX_TRAJ_STROKE_WGT = 250;
    public static final int MIN_CONTOUR_WGT = 0;
    public static final int MAX_CONTOUR_WGT = 500;
    public static final int MIN_GRID_WGT = 0;
    public static final int MAX_GRID_WGT = 200;
    public static final int MIN_OVERLAY_WGT = 0;
    public static final int MAX_OVERLAY_WGT = 400;
    public static final int MIN_VECTOR_WGT = 0;
    public static final int MAX_VECTOR_WGT = 500;
    public static final float MIN_TITLE_SIZE = 8.0f;
    public static final float MAX_TITLE_SIZE = 40.0f;
    public static final float MIN_SUBTITLE_SIZE = 8.0f;
    public static final float MAX_SUBTITLE_SIZE = 40.0f;
    public static final float MIN_FOOTNOTE_SIZE = 5.0f;
    public static final float MAX_FOOTNOTE_SIZE = 24.0f;
    public static final float MIN_AXIS_LABEL_SIZE = 5.0f;
    public static final float MAX_AXIS_LABEL_SIZE = 32.0f;
    public static final float MIN_AXIS_TICK_LABEL_SIZE = 5.0f;
    public static final float MAX_AXIS_TICK_LABEL_SIZE = 24.0f;
    public static final float MIN_SCALE_LABEL_SIZE = 5.0f;
    public static final float MAX_SCALE_LABEL_SIZE = 32.0f;
    public static final float MIN_SCALE_TICK_LABEL_SIZE = 5.0f;
    public static final float MAX_SCALE_TICK_LABEL_SIZE = 24.0f;
    public static final float MIN_STROKE_LABEL_SIZE = 5.0f;
    public static final float MAX_STROKE_LABEL_SIZE = 24.0f;
    public static final float MIN_GRID_LABEL_SIZE = 5.0f;
    public static final float MAX_GRID_LABEL_SIZE = 15.0f;
    public static final float MIN_CONTOUR_LABEL_SIZE = 5.0f;
    public static final float MAX_CONTOUR_LABEL_SIZE = 15.0f;
    public static final float MIN_NUMBERLAY_LABEL_SIZE = 2.0f;
    public static final float MAX_NUMBERLAY_LABEL_SIZE = 10.0f;
    public static final int MIN_SCALE_DIVS = 1;
    public static final int MAX_SCALE_DIVS = 20;
    public static final int MIN_AXIS_DIVS = 1;
    public static final int MAX_AXIS_DIVS = 20;
    public static final float MIN_POINT_SYMBOL_SIZE = 2.0f;
    public static final float MAX_POINT_SYMBOL_SIZE = 16.0f;
    public static final double MAX_SCALE_COEFF = 1000.0;
    public static final int MAX_SCALE_EXP = 50;
    public static final int MIN_GRID_LABEL_STEP = PanGridLabelStep.getMin();
    public static final int MAX_GRID_LABEL_STEP = PanGridLabelStep.getMax();

    public static int constrainSizeFactor(int szfactor) {
        int sfactor = szfactor;
        if (sfactor == 0) {
            PanPreferences prefs = PanPreferences.getSharedInstance();
            sfactor = prefs.getInt("plot:size.factor");
        } else if (sfactor < 80) {
            LOGGER.warn("Size factor {} too small; using min {}.", (Object)sfactor, (Object)80);
            sfactor = 80;
        } else if (PlatformUtils.isHeadless() && sfactor > 500) {
            LOGGER.warn("Size factor {} too big; using CL max {}.", (Object)sfactor, (Object)500);
            sfactor = 500;
        } else if (sfactor > 300) {
            LOGGER.warn("Size factor {} too big; using max {}.", (Object)sfactor, (Object)300);
            sfactor = 300;
        }
        return sfactor;
    }

    public static int constrainWidthFactor(int wfactor) {
        if (wfactor < 20) {
            LOGGER.warn("Width factor {} too small; using min {}.", (Object)wfactor, (Object)20);
            return 20;
        }
        if (wfactor > 100) {
            LOGGER.warn("Width factor {} too big; using max {}.", (Object)wfactor, (Object)100);
            return 100;
        }
        return wfactor;
    }

    public static int constrainHeightFactor(int hfactor) {
        if (hfactor < 20) {
            LOGGER.warn("Height factor {} too small; using min {}.", (Object)hfactor, (Object)20);
            return 20;
        }
        if (hfactor > 400) {
            LOGGER.warn("Height factor {} too big; using max {}.", (Object)hfactor, (Object)400);
            return 400;
        }
        return hfactor;
    }

    public static int constrainColorbarLength(int value) {
        return MathUtils.constrain(50, 100, value);
    }

    public static int constrainBorderWeight(int value) {
        return MathUtils.constrain(25, 300, value);
    }

    public static int constrainAxisTickWeight(int value) {
        return MathUtils.constrain(25, 200, value);
    }

    public static int constrainColorbarBorderWeight(int value) {
        return MathUtils.constrain(0, 150, value);
    }

    public static int constrainGridWeight(int value) {
        return MathUtils.constrain(25, 200, value);
    }

    public static int constrainOverlayWeight(int value) {
        return MathUtils.constrain(0, 400, value);
    }

    public static int constrainContourWeight(int value) {
        return MathUtils.constrain(0, 500, value);
    }

    public static int constrainVectorWeight(int value) {
        return MathUtils.constrain(0, 500, value);
    }

    public static float constrainTitleSize(float value) {
        return MathUtils.constrain(8.0f, 40.0f, value);
    }

    public static float constrainSubtitleSize(float value) {
        return MathUtils.constrain(8.0f, 40.0f, value);
    }

    public static float constrainFootnoteSize(float value) {
        return MathUtils.constrain(5.0f, 24.0f, value);
    }

    public static float constrainAxisLabelSize(float value) {
        return MathUtils.constrain(5.0f, 32.0f, value);
    }

    public static float constrainAxisTickLabelSize(float value) {
        return MathUtils.constrain(5.0f, 24.0f, value);
    }

    public static float constrainGridLabelSize(float value) {
        return MathUtils.constrain(5.0f, 15.0f, value);
    }

    public static float constrainContourLabelSize(float value) {
        if (value == 0.0f) {
            return 0.0f;
        }
        return MathUtils.constrain(5.0f, 15.0f, value);
    }

    public static float constrainScaleLabelSize(float value) {
        return MathUtils.constrain(5.0f, 32.0f, value);
    }

    public static float constrainScaleTickLabelSize(float value) {
        return MathUtils.constrain(5.0f, 24.0f, value);
    }

    public static float constrainStrokeLabelSize(float value) {
        return MathUtils.constrain(5.0f, 24.0f, value);
    }

    public static int constrainAxisDivs(int value) {
        return MathUtils.constrain(1, 20, value);
    }

    public static int constrainScaleDivs(int value) {
        return MathUtils.constrain(1, 20, value);
    }

    public static float constrainPointSymbolSize(float value) {
        return MathUtils.constrain(2.0f, 16.0f, value);
    }

    public static int constrainGridLabelStep(int value) {
        return MathUtils.constrain(MIN_GRID_LABEL_STEP, MAX_GRID_LABEL_STEP, value);
    }

    private PanPlotConstraints() {
    }
}

