/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plotui.PanLonLatMapControls;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotGlass;
import gov.nasa.giss.panoply.plotui.PanPlotHolder;
import gov.nasa.giss.panoply.plotui.PanPlotMouseListener;
import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.ui.cursor.CursorUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMouseListenerLonLat
extends PanPlotMouseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanProjectionMeta projmeta_;

    public PanPlotMouseListenerLonLat(PanPlotFrame frame, PanPlotMeta pmeta) {
        super(frame);
        this.projmeta_ = pmeta.getProjectionMeta();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Component c = e.getComponent();
        if (!(c instanceof PanPlotHolder)) {
            return;
        }
        PanPlotHolder ph = (PanPlotHolder)c;
        ph.requestFocusInWindow();
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        glass.setContentType(PanPlotGlass.ContentType.NONE);
        glass.setVisible(false);
        if (e.isPopupTrigger()) {
            return;
        }
        Point eventPt = e.getPoint();
        PointLL ll = this.transformXY2LL(eventPt);
        if (ll == null) {
            this.updateCursor(e);
            return;
        }
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 1) {
            this.getMapControlsPanel().recenter(ll.getLon(), ll.getLat());
        } else if (keyModifiers == 4096) {
            if (this.projmeta_.canZoomIn()) {
                this.getMapControlsPanel().zoomIn(ll.getLon(), ll.getLat());
            }
        } else if (keyModifiers == 16) {
            Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
            String text = ph.describePoint(eventPt.x, eventPt.y);
            if (text == null || text.isEmpty()) {
                glass.setContentType(PanPlotGlass.ContentType.NONE);
                glass.setVisible(false);
            } else {
                glass.setPoint(glassPt);
                glass.setText(text);
                glass.setContentType(PanPlotGlass.ContentType.TEXT_BOX);
                glass.setVisible(true);
                glass.repaint();
            }
        } else if (keyModifiers == 4112 && this.projmeta_.canZoomOut()) {
            this.getMapControlsPanel().zoomOut(ll.getLon(), ll.getLat());
        }
        this.updateCursor(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pholder_.requestFocusInWindow();
        PanLonLatPlot llplot = (PanLonLatPlot)this.getPlot();
        if (!llplot.isZoomableMap()) {
            CursorUtils.setDefaultCursor(this.pholder_);
            return;
        }
        this.pressPt_ = e.getPoint();
        PointLL ll = this.transformXY2LL(this.pressPt_);
        if (ll == null) {
            return;
        }
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point glassPt = SwingUtilities.convertPoint(this.pholder_, this.pressPt_, glass);
        this.currentRect_ = new Rectangle(glassPt.x, glassPt.y, 0, 0);
        this.updateDrawableRect(glass);
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.setVisible(true);
        glass.repaint();
        this.dragInProgress_ = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragInProgress_ = false;
        int keyModifiers = this.getModifiers(e);
        PanLonLatPlot llplot = (PanLonLatPlot)this.getPlot();
        if (llplot.isZoomableMap() && keyModifiers == 4096) {
            this.updateDragRect(e);
            if (this.rectToDraw_ != null && (this.rectToDraw_.width > 1 || this.rectToDraw_.height > 1)) {
                Point releasePt = e.getPoint();
                Point centerPt = new Point((int)(0.5 * (double)(this.pressPt_.x + releasePt.x)), (int)(0.5 * (double)(this.pressPt_.y + releasePt.y)));
                PointLL ll0 = this.transformXY2LL(centerPt);
                PointLL ll1 = this.transformXY2LL(this.pressPt_);
                PointLL ll2 = this.transformXY2LL(releasePt);
                if (ll0 != null && ll1 != null && ll2 != null) {
                    double b;
                    double l = this.pressPt_.x < releasePt.x ? ll1.getLon() : ll2.getLon();
                    double t = this.pressPt_.y < releasePt.y ? ll1.getLat() : ll2.getLat();
                    double r = this.pressPt_.x < releasePt.x ? ll2.getLon() : ll1.getLon();
                    double d = b = this.pressPt_.y < releasePt.y ? ll2.getLat() : ll1.getLat();
                    if (r < l) {
                        r += 360.0;
                    }
                    this.getMapControlsPanel().dragZoom(ll0.getLon(), ll0.getLat(), l, t, r, b);
                }
            }
        }
        CursorUtils.setDefaultCursor(this.pholder_);
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        glass.setVisible(false);
        glass.setContentType(PanPlotGlass.ContentType.NONE);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        PanLonLatPlot llplot = (PanLonLatPlot)this.getPlot();
        if (llplot.isZoomableMap()) {
            this.updateDragRect(e);
        } else {
            CursorUtils.setDefaultCursor(this.pholder_);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.dragInProgress_) {
            return;
        }
        this.updateCursor(e);
        Component c = e.getComponent();
        if (!(c instanceof PanPlotHolder)) {
            return;
        }
        PanPlotHolder ph = (PanPlotHolder)c;
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point eventPt = e.getPoint();
        Point glassPt = SwingUtilities.convertPoint(ph, eventPt, glass);
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 1) {
            glass.setPoint(glassPt);
            glass.setContentType(PanPlotGlass.ContentType.CROSSHAIRS);
            glass.setVisible(true);
            glass.repaint();
        } else {
            glass.setVisible(false);
            glass.setContentType(PanPlotGlass.ContentType.NONE);
        }
    }

    @Override
    protected void handleKeyEvent(KeyEvent e) {
        if (!this.pholder_.isVisible()) {
            return;
        }
        if (this.dragInProgress_) {
            int keyModifiers = this.getModifiers(e);
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            Component c = e.getComponent();
            if (keyModifiers == 4096 || keyModifiers == 4112) {
                CursorUtils.setZoomInCursor(this.pholder_);
            } else if (crw < 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                c.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                c.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                c.setCursor(Cursor.getPredefinedCursor(5));
            }
        } else {
            this.updateCursor(e);
        }
    }

    @Override
    protected void updateCursor(InputEvent e) {
        Point framePt = this.pframe_.getMousePosition(true);
        if (framePt == null) {
            CursorUtils.setDefaultCursor(this.pholder_);
            return;
        }
        Point phPt = SwingUtilities.convertPoint(this.pframe_, framePt, this.pholder_);
        PointLL ll = this.transformXY2LL(phPt);
        if (ll == null) {
            CursorUtils.setDefaultCursor(this.pholder_);
            return;
        }
        PanLonLatPlot llplot = (PanLonLatPlot)this.getPlot();
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 1) {
            CursorUtils.setCrosshairCursor(this.pholder_);
        } else if (keyModifiers == 4096) {
            if (llplot.isZoomableMap()) {
                if (this.projmeta_.canZoomIn()) {
                    CursorUtils.setZoomInCursor(this.pholder_);
                } else {
                    CursorUtils.setNoZoomCursor(this.pholder_);
                }
            } else {
                CursorUtils.setDefaultCursor(this.pholder_);
            }
        } else if (keyModifiers == 16) {
            CursorUtils.setHelpCursor(this.pholder_);
        } else if (keyModifiers == 4112) {
            if (llplot.isZoomableMap()) {
                if (this.projmeta_.canZoomOut()) {
                    CursorUtils.setZoomOutCursor(this.pholder_);
                } else {
                    CursorUtils.setNoZoomCursor(this.pholder_);
                }
            } else {
                CursorUtils.setDefaultCursor(this.pholder_);
            }
        } else {
            CursorUtils.setDefaultCursor(this.pholder_);
        }
    }

    private void updateDragRect(MouseEvent e) {
        if (e.getID() == 500) {
            this.rectToDraw_ = null;
            return;
        }
        Point eventPt = new Point(e.getPoint());
        PointLL ll = this.transformXY2LL(eventPt);
        if (ll == null) {
            return;
        }
        PanPlotGlass glass = (PanPlotGlass)this.pframe_.getGlassPane();
        Point glassPt = SwingUtilities.convertPoint(this.pholder_, eventPt, glass);
        if (glassPt == null) {
            return;
        }
        this.currentRect_.setSize(glassPt.x - this.currentRect_.x, glassPt.y - this.currentRect_.y);
        this.updateDrawableRect(glass);
        Rectangle repaintRect = this.rectToDraw_.union(this.previousRectDrawn_);
        --repaintRect.x;
        --repaintRect.y;
        repaintRect.width += 2;
        repaintRect.height += 2;
        glass.setRectangle(this.rectToDraw_);
        glass.setContentType(PanPlotGlass.ContentType.DRAG_FRAME);
        glass.setVisible(true);
        glass.repaint(repaintRect.x, repaintRect.y, repaintRect.width, repaintRect.height);
        int keyModifiers = this.getModifiers(e);
        if (keyModifiers == 4096 || keyModifiers == 4112) {
            CursorUtils.setZoomInCursor(this.pframe_);
        } else {
            int crw = this.currentRect_.width;
            int crh = this.currentRect_.height;
            if (crw < 0 && crh < 0) {
                this.pframe_.setCursor(Cursor.getPredefinedCursor(6));
            } else if (crw >= 0 && crh < 0) {
                this.pframe_.setCursor(Cursor.getPredefinedCursor(7));
            } else if (crw < 0 && crh >= 0) {
                this.pframe_.setCursor(Cursor.getPredefinedCursor(4));
            } else {
                this.pframe_.setCursor(Cursor.getPredefinedCursor(5));
            }
        }
    }

    private PointLL transformXY2LL(Point pt) {
        try {
            PanLonLatPlot llplot = (PanLonLatPlot)this.getPlot();
            return llplot.transformXY2LL(pt.x - llplot.getLocation().x, pt.y - llplot.getLocation().y);
        }
        catch (Exception exc) {
            LOGGER.debug("{} performing map transform", (Object)exc.getClass().getSimpleName());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return null;
        }
    }

    private PanLonLatMapControls getMapControlsPanel() {
        return (PanLonLatMapControls)this.pframe_.getControlsPanel(PanPlotControlsID.MAP);
    }
}

