/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanLinePlotStrokePrefsPanel
extends PanAbstractPrefsPanel {
    private ColorComboBox[] strokeColorCombos_ = new ColorComboBox[2];
    private DescribedEnumComboBox[] strokeStyleMenus_ = new DescribedEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];
    private FloatComboBox captionSizeCombo_;
    private boolean refreshing_;

    public PanLinePlotStrokePrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Line Plot Strokes"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a line plot, set\u2026");
        JLabel t1Label = new JLabel("Stroke 1:\u2009");
        JLabel t2Label = new JLabel("Stroke 2:\u2009");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            JLabel t1StrokeLabel1 = new JLabel("Style:\u2009");
            JLabel t2StrokeLabel1 = new JLabel("Color:\u2009");
            JLabel t2StrokeLabel2 = new JLabel("\u2014 Weight:\u2009");
            JLabel t2StrokeLabel3 = new JLabel("%");
            this.strokeStyleMenus_[i] = new DescribedEnumComboBox(PanStrokePattern.class);
            this.strokeStyleMenus_[i].setName(PanParamKeys.P_LINE_STROKE_STYLE[i]);
            this.strokeStyleMenus_[i].removeItem(PanStrokePattern.NONE);
            this.strokeStyleMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_LINE_STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = new ColorComboBox();
            this.strokeColorCombos_[i].setName(PanParamKeys.P_LINE_STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_LINE_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.weightX5(PanParamKeys.P_LINE_STROKE_WGT[i], prefs_.getInt(PanParamKeys.P_LINE_STROKE_WGT[i]), 0, 500);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel1, this.strokeColorCombos_[i], t2StrokeLabel2, this.strokeWeightSpinners_[i], t2StrokeLabel3, Box.createHorizontalStrut(12));
            GuiUtils.matchLabelWidths(t1StrokeLabel1, t2StrokeLabel1);
        }
        JLabel captionLabel = new JLabel("Caption: ");
        this.captionSizeCombo_ = FloatComboBox.create(5.0f, 24.0f);
        this.captionSizeCombo_.setValue(prefs_.getFloat("plot:stroke.label.size"));
        QuickBox captionSizeBox = QuickBox.createLeftBox(new JLabel("Size:\u2009"), this.captionSizeCombo_);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 6, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setRigidHeight(true);
        this.setLayout(fgl);
        this.add((Component)topText, new FGConstraint(0, 0, 3, 1));
        this.add((Component)t1Label, new FGConstraint(0, 1));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, 1));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, 2));
        this.add((Component)t2Label, new FGConstraint(0, 3));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(1, 3));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(1, 4));
        this.add((Component)captionLabel, new FGConstraint(0, 5));
        this.add((Component)captionSizeBox, new FGConstraint(1, 5));
    }

    private void attachListeners() {
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strokeColorCombos_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_LINE_STROKE_COLOR[ii], this.strokeColorCombos_[ii].getSelectedColor());
            });
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_LINE_STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getEnumName());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParamKeys.P_LINE_STROKE_WGT[ii], this.strokeWeightSpinners_[ii].getIntValue());
            });
        }
        this.captionSizeCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:stroke.label.size", Float.valueOf(this.captionSizeCombo_.getValue()));
        });
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (int i = 0; i < 2; ++i) {
            this.strokeStyleMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_LINE_STROKE_STYLE[i]));
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_LINE_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i].setValue(prefs_.getInt(PanParamKeys.P_LINE_STROKE_WGT[i]));
        }
        this.captionSizeCombo_.setValue(prefs_.getFloat("plot:stroke.label.size"));
        this.refreshing_ = false;
    }
}

