/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.map.kml.KMLDataFilenameFilter;
import gov.nasa.giss.map.kml.KMLDataResourceList;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTablePanel;
import gov.nasa.giss.panoply.prefsui.PanUnderlayTableModel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;

public class PanUnderlayPrefsPanel
extends PanCommonPrefsTablePanel
implements DropTargetListener {
    private static final String P_ALWAYS_IMPORT_UNDERLAYS = "files:autoimport.underlays";
    private boolean refreshing_;

    public PanUnderlayPrefsPanel() {
        this.createLayout();
        this.attachListeners();
    }

    @Override
    public void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Underlays Library"));
        this.setOpaque(false);
        this.table_ = new PanCommonPrefsTable(new PanUnderlayTableModel());
        this.tspane_ = new JScrollPane(this.table_);
        this.tspane_.setOpaque(false);
        this.tspane_.setMinimumSize(new Dimension(this.getPreferredSize().width / 2, 160));
        Border ob = this.tspane_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_UNFOCUSED_BORDER, ob);
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.tspane_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setMinusEnabled(false);
        JLabel bText = new JLabel("Built-in underlays cannot be removed.");
        GuiUtils.setSizeSmall(bText);
        this.autoimportCB_ = PanCheckBox.create("Always import new KMZ map underlays into support library", false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 3, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        fgl.setColumnWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)this.tspane_, new FGConstraint(0, 0, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 1));
        this.add((Component)bText, new FGConstraint(1, 1, 1.0, 0.5));
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 2, 2, 1, 0.5, 0.5));
    }

    private void attachListeners() {
        this.autoimportCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            prefs_.setBoolean(P_ALWAYS_IMPORT_UNDERLAYS, this.autoimportCB_.isSelected());
        });
        this.pmwidget_.addActionListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getID() == 2000) {
                this.additionRequested();
            } else if (e.getID() == 2001) {
                int row = this.table_.getSelectedRow();
                this.deletionRequested(row);
            }
        });
        this.table_.getModel().addTableModelListener(e -> this.refresh());
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanUnderlayPrefsPanel.this.refresh();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PanUnderlayPrefsPanel.this.refresh();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                Point p = e.getPoint();
                int row = PanUnderlayPrefsPanel.this.table_.rowAtPoint(p);
                PanUnderlayPrefsPanel.this.displaySelection(row);
            }
        });
        ActionMap am = this.table_.getActionMap();
        Object cutKey = GuiUtils.getCutKey(am);
        InputMap im = this.table_.getInputMap(1);
        this.cutKS_ = null;
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.table_.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row = PanUnderlayPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if (PanUnderlayPrefsPanel.this.cutKS_ != null && ks.equals(PanUnderlayPrefsPanel.this.cutKS_)) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int row = PanUnderlayPrefsPanel.this.table_.getSelectedRow();
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                } else if (PanUnderlayPrefsPanel.this.cutKS_ != null && ks.equals(PanUnderlayPrefsPanel.this.cutKS_)) {
                    PanUnderlayPrefsPanel.this.deletionRequested(row);
                }
            }
        });
    }

    @Override
    void displaySelection(int index) {
    }

    @Override
    void additionRequested() {
        PanFrame pf = (PanFrame)this.getTopLevelAncestor();
        File[] ff = PanFileUtils.showOpenKMLFileChooser(pf);
        if (ff != null) {
            PanResourceUtils.getUnderlayList().addAlphabetic((Component)pf, ff);
        }
    }

    @Override
    void deletionRequested(int index) {
        this.table_.clearSelection();
        KMLDataResourceList list = PanResourceUtils.getUnderlayList();
        list.remove(index);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
        this.table_.repaint();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.autoimportCB_.setSelected(prefs_.getBoolean(P_ALWAYS_IMPORT_UNDERLAYS));
        this.pmwidget_.setPlusEnabled(true);
        int row = this.table_.getSelectedRow();
        KMLDataResourceList kset = PanResourceUtils.getUnderlayList();
        if (row < 0 || row >= kset.getSize()) {
            this.pmwidget_.setMinusEnabled(false);
        } else {
            this.pmwidget_.setMinusEnabled(kset.canRemove(row));
        }
        this.refreshing_ = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!KMLDataFilenameFilter.isKMLName(f)) continue;
                    addlist.add(f);
                }
                PanResourceUtils.getUnderlayList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.tspane_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.tspane_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

