/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.graphics.GraphicUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Path2D;
import java.lang.invoke.MethodHandles;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelSectionHeader
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color BACKGROUND = new Color(85, 85, 85, 51);
    private static final BasicStroke DISABLED_STROKE = new BasicStroke(0.67f, 2, 0);
    private static float trisize_ = 9.0f;
    private static float margin_ = 4.0f;
    private static Font hfont_;
    private static float fsize_;
    private String title_;
    private int titleWidth_;
    private boolean measured_;
    private boolean expanded_;
    private static Path2D.Float collapsedTriangle_;
    private static Path2D.Float expandedTriangle_;

    public PanelSectionHeader(String title) {
        this(title, true);
    }

    public PanelSectionHeader(String title, boolean expanded) {
        this.title_ = title;
        this.setFont(hfont_);
        this.setOpaque(false);
        this.setExpanded(expanded);
    }

    public void setTitle(String title) {
        this.title_ = title;
        this.measured_ = false;
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean expanded) {
        this.expanded_ = expanded;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        int lwidth = Math.max(this.titleWidth_, 72);
        int hwidth = (int)(margin_ + trisize_ + margin_ + (float)lwidth + margin_);
        return new Dimension(hwidth, (int)(margin_ + trisize_ + margin_));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d = new Dimension(this.getPreferredSize());
        d.width = 4000;
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.measured_) {
            this.measure();
        }
        super.paintComponent(g);
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        g2d.setColor(BACKGROUND);
        int ww = this.getWidth();
        int hh = this.getHeight();
        GraphicUtils.fillRect(g2d, 0.0, 0.0, ww, hh);
        if (this.isEnabled()) {
            g2d.setColor(new Color(0, 0, 0));
        } else {
            g2d.setColor(new Color(0, 0, 0, 102));
        }
        g2d.translate(margin_, margin_);
        if (this.isEnabled()) {
            if (this.expanded_) {
                g2d.fill(expandedTriangle_);
            } else {
                g2d.fill(collapsedTriangle_);
            }
        } else {
            g2d.setStroke(DISABLED_STROKE);
            if (this.expanded_) {
                g2d.draw(expandedTriangle_);
            } else {
                g2d.draw(collapsedTriangle_);
            }
        }
        g2d.translate(-margin_, -margin_);
        if (this.titleWidth_ > 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int lineAscent = fm.getAscent();
            int lineDescent = fm.getDescent();
            int x = (int)(margin_ + trisize_ + margin_);
            int y = (int)(0.5 * (double)hh - 0.5 * (double)(lineAscent + lineDescent) + (double)lineAscent);
            g2d.drawString(this.title_, x, y);
        }
        g2d.dispose();
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
        this.measured_ = true;
    }

    public boolean inDisclosureButton(Point pt) {
        return (float)pt.x >= margin_ && (float)pt.x < margin_ + trisize_;
    }

    static {
        collapsedTriangle_ = new Path2D.Float();
        collapsedTriangle_.moveTo(0.0f, 0.0f);
        collapsedTriangle_.lineTo(0.0f + trisize_, 0.0f + 0.5f * trisize_);
        collapsedTriangle_.lineTo(0.0f, 0.0f + trisize_);
        collapsedTriangle_.closePath();
        expandedTriangle_ = new Path2D.Float();
        expandedTriangle_.moveTo(0.0f, 0.0f);
        expandedTriangle_.lineTo(0.0f + trisize_, 0.0f);
        expandedTriangle_.lineTo(0.0f + 0.5f * trisize_, 0.0f + trisize_);
        expandedTriangle_.closePath();
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f != null) {
            fsize_ = 0.85f * f.getSize2D();
            hfont_ = f.deriveFont(fsize_);
        }
    }
}

