/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.ClipKey;
import io.sf.carte.echosvg.svggen.SVGClipDescriptor;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.w3c.dom.Element;

public class SVGClip
extends AbstractSVGConverter {
    public static final Shape ORIGIN = new Line2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public static final SVGClipDescriptor NO_CLIP = new SVGClipDescriptor("none", null);
    private SVGShape shapeConverter;

    public SVGClip(SVGGeneratorContext generatorContext) {
        super(generatorContext);
        this.shapeConverter = new SVGShape(generatorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext gc) {
        Shape clip = gc.getClip();
        SVGClipDescriptor clipDesc = null;
        if (clip != null) {
            StringBuilder clipPathAttrBuf = new StringBuilder("url(");
            GeneralPath clipPath = new GeneralPath(clip);
            ClipKey clipKey = new ClipKey(clipPath, this.getGeneratorContext());
            clipDesc = (SVGClipDescriptor)this.descMap.get(clipKey);
            if (clipDesc == null) {
                Element clipDef = this.clipToSVG(clip);
                if (clipDef == null) {
                    clipDesc = NO_CLIP;
                } else {
                    clipPathAttrBuf.append("#");
                    clipPathAttrBuf.append(clipDef.getAttributeNS(null, "id"));
                    clipPathAttrBuf.append(")");
                    clipDesc = new SVGClipDescriptor(clipPathAttrBuf.toString(), clipDef);
                    this.descMap.put(clipKey, clipDesc);
                    this.defSet.add(clipDef);
                }
            }
        } else {
            clipDesc = NO_CLIP;
        }
        return clipDesc;
    }

    private Element clipToSVG(Shape clip) {
        Element clipDef = this.getGeneratorContext().getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "clipPath");
        clipDef.setAttributeNS(null, "clipPathUnits", "userSpaceOnUse");
        clipDef.setAttributeNS(null, "id", this.getGeneratorContext().getIDGenerator().generateID("clipPath"));
        Element clipPath = this.shapeConverter.toSVG(clip);
        if (clipPath != null) {
            clipDef.appendChild(clipPath);
            return clipDef;
        }
        clipDef.appendChild(this.shapeConverter.toSVG(ORIGIN));
        return clipDef;
    }
}

