/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatReduced;
import gov.nasa.giss.map.LonLatEdges;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatReducedISCCP
extends NcArrayLonLatReduced {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcArrayLonLatReducedISCCP(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.initMe();
    }

    private void initMe() {
        int i;
        Array latArray;
        Array lonArray;
        Object njo = this.getNjObject();
        if (!(njo instanceof VariableDS)) {
            throw new NcException("Backing object is not a VariableDS");
        }
        VariableDS njvarDS = (VariableDS)njo;
        if (this.rank_ < 1) {
            throw new NcException("Variable has rank 0.");
        }
        this.reduceDimIndex_ = NcArrayLonLatReducedISCCP.getEQCellIndex(njvarDS);
        if (this.reduceDimIndex_ < 0) {
            throw new NcException("Could not find eqcell dimension.");
        }
        VariableDS[] llvars = NcArrayLonLatReducedISCCP.getLonLatVars(this.dataset_, njvarDS);
        if (llvars == null) {
            throw new NcException("Could not construct lon and lat vars.");
        }
        this.lonVarDS_ = llvars[0];
        this.latVarDS_ = llvars[1];
        try {
            lonArray = this.lonVarDS_.read();
        }
        catch (Exception exc) {
            LOGGER.warn("Could not read longitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read longitude coordinates array.", exc);
        }
        try {
            latArray = this.latVarDS_.read();
        }
        catch (Exception exc) {
            LOGGER.debug("Could not read latitude coordinates array: {}", (Object)exc.getMessage());
            throw new NcException("Could not read latitude coordinates array.", exc);
        }
        this.numPts_ = (int)lonArray.getSize();
        this.rawLonValues_ = new double[this.numPts_];
        this.rawLatValues_ = new double[this.numPts_];
        for (int i2 = 0; i2 < this.numPts_; ++i2) {
            this.rawLonValues_[i2] = lonArray.getDouble(i2);
            this.rawLatValues_[i2] = latArray.getDouble(i2);
        }
        ArrayList<Double> latValuesAL = new ArrayList<Double>((int)Math.sqrt(this.numPts_));
        ArrayList<Integer> latOffsetsAL = new ArrayList<Integer>(latValuesAL.size());
        double lastLat = -9999.0;
        for (i = 0; i < this.numPts_; ++i) {
            double lat = this.rawLatValues_[i];
            if (lat == lastLat) continue;
            lastLat = lat;
            latValuesAL.add(lat);
            latOffsetsAL.add(i);
        }
        this.numRows_ = latValuesAL.size();
        this.rowLatValues_ = new double[this.numRows_];
        this.latOffsets_ = new int[this.numRows_];
        for (i = 0; i < this.numRows_; ++i) {
            this.rowLatValues_[i] = (Double)latValuesAL.get(i);
            this.latOffsets_[i] = (Integer)latOffsetsAL.get(i);
        }
        this.cellsInRow_ = new int[this.numRows_];
        for (i = 0; i < this.numRows_; ++i) {
            this.cellsInRow_[i] = i < this.numRows_ - 1 ? this.latOffsets_[i + 1] - this.latOffsets_[i] : this.numPts_ - this.latOffsets_[i];
            if (this.cellsInRow_[i] <= this.maxCols_) continue;
            this.maxCols_ = this.cellsInRow_[i];
        }
        this.yAxis_ = new NcAxis(NcAxisType.LAT, "Latitude", this.rowLatValues_);
    }

    public static boolean canGridVariable(NcVariable ncvar) {
        NcDataset ncd = ncvar.getDataset();
        VariableDS varDS = (VariableDS)ncvar.getObject();
        return NcArrayLonLatReducedISCCP.canGridVariable(ncd, varDS);
    }

    public static boolean canGridVariable(NcDataset ncd, VariableDS varDS) {
        return NcArrayLonLatReducedISCCP.getLonLatVars(ncd, varDS) != null;
    }

    private static int getEQCellIndex(VariableDS varDS) {
        int rank = varDS.getRank();
        if (rank < 1) {
            return -1;
        }
        for (int i = 0; i < rank; ++i) {
            Dimension d = varDS.getDimension(i);
            if (d == null || d.getShortName() == null || !"eqcell".equalsIgnoreCase(d.getShortName())) continue;
            return i;
        }
        return -1;
    }

    private static VariableDS[] getLonLatVars(NcDataset ncd, VariableDS varDS) {
        int latrank;
        int eqIndex = NcArrayLonLatReducedISCCP.getEQCellIndex(varDS);
        if (eqIndex < 0) {
            return null;
        }
        Dimension eqd = varDS.getDimension(eqIndex);
        if (eqd == null) {
            return null;
        }
        String fname = varDS.getFullName();
        Object lonName = null;
        Object latName = null;
        int slash = fname.lastIndexOf(47);
        if (slash > -1) {
            lonName = fname.substring(0, slash + 1) + "eqlon";
            latName = fname.substring(0, slash + 1) + "eqlat";
        } else {
            lonName = "eqlon";
            latName = "eqlat";
        }
        VariableDS lonVarDS = ncd.getVariableDS((String)lonName);
        VariableDS latVarDS = ncd.getVariableDS((String)latName);
        if (lonVarDS == null || latVarDS == null) {
            return null;
        }
        int lonrank = lonVarDS.getRank();
        if (lonrank != (latrank = latVarDS.getRank()) || lonrank != 1 || latrank != 1) {
            return null;
        }
        int[] lonshape = lonVarDS.getShape();
        int[] latshape = latVarDS.getShape();
        if (lonshape.length != 1 || latshape.length != 1) {
            return null;
        }
        if (lonshape[0] < 2 || latshape[0] < 2) {
            return null;
        }
        if (lonshape[0] != latshape[0] || lonshape[0] != eqd.getLength()) {
            return null;
        }
        String lonUnits = NcUtils.getUnitsStr(lonVarDS);
        String latUnits = NcUtils.getUnitsStr(latVarDS);
        if (!NcUnitUtils.isDegreesEast(lonUnits)) {
            return null;
        }
        if (!NcUnitUtils.isDegreesNorth(latUnits)) {
            return null;
        }
        return new VariableDS[]{lonVarDS, latVarDS};
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }
}

