/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Fournier2
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Fournier II";
    public static final int PROPERTIES = 8;
    private static final double SQRT_PI_OVER_2 = 0.886226925452758;
    private static final double INV_SQRT_PI = 0.5641895835477563;
    private static final double TWO_OVER_SQRT_PI = 1.1283791670955126;
    private static final double MAX_X_OVER_RS = 1.772453850905516;
    private static final double MAX_Y_OVER_RS = 0.886226925452758;

    public Fournier2(int width, int height) {
        this(width, height, 0, 0);
    }

    public Fournier2(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 1.772453850905516, 0.886226925452758);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = 0.5641895835477563 * lambdaRad * Math.cos(phiRad);
        double y = 0.886226925452758 * Math.sin(phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        if (absXOverRS < 1.0E-10 && absYOverRS < 1.0E-10) {
            return new PointLL(this.lambdaC_, 0.0);
        }
        double sinPhi = absYOverRS * 1.1283791670955126;
        double phiRad = Math.asin(sinPhi);
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        if (absXOverRS < 1.0E-10) {
            return new PointLL(this.lambdaC_, phi);
        }
        double d = lambdaRad = phiRad == 0.0 ? this.lambdaC_ : absXOverRS * 1.772453850905516 / Math.cos(phiRad);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Fournier2 fournier2 = this;
        synchronized (fournier2) {
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double sinPhi = y * this.invRS_ * 1.1283791670955126;
                double phiRad = Math.asin(sinPhi);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_ * 1.772453850905516 / Math.cos(phiRad)) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (dotN == null || dotS == null) {
            return;
        }
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        if (absLambda < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        Point2D.Double dotNP = maxLat > 89.99999 ? dotN : this.transformLL2XY(lon, 90.0);
        Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
        Point2D.Double dotSP = maxLat > 89.99999 ? dotS : this.transformLL2XY(lon, -90.0);
        double hw = Math.abs(dotEq.x - dotNP.x);
        double rectX = dotNP.x - hw;
        double rectW = 2.0 * hw;
        double rectH = dotSP.y - dotNP.y;
        if (lambda > 0.0) {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotS, dotN);
        } else {
            GraphicUtils.drawEllipticArc(g2d, rectX, dotNP.y, rectW, rectH, dotN, dotS);
        }
    }
}

