/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanShowPlotTabAction;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.ui.menu.GissRadioButtonMenuItem;
import java.lang.invoke.MethodHandles;
import javax.swing.ButtonGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanViewPlotMenu
extends PanMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanViewPlotMenu(PanFrame parent) {
        super(parent, "view-plot-menu");
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        PanShowPlotTabAction a1 = null;
        PanShowPlotTabAction a2 = null;
        PanShowPlotTabAction a3 = null;
        if (parentIsPlot) {
            PanPlotFrame pframe = (PanPlotFrame)parent;
            a1 = new PanShowPlotTabAction(pframe, "show-plot", 0);
            a2 = new PanShowPlotTabAction(pframe, "show-array-1", 1);
            a3 = new PanShowPlotTabAction(pframe, "show-array-2", 2);
        }
        GissRadioButtonMenuItem mi1 = this.makeRadioButtonItemFromProperties("show-plot", a1);
        GissRadioButtonMenuItem mi2 = this.makeRadioButtonItemFromProperties("show-array-1", a2);
        GissRadioButtonMenuItem mi3 = this.makeRadioButtonItemFromProperties("show-array-2", a3);
        this.add(mi1).setEnabled(parentIsPlot);
        this.add(mi2).setEnabled(parentIsPlot);
        this.add(mi3).setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(mi1);
        bg.add(mi2);
        bg.add(mi3);
        this.addSeparator();
        this.refreshPrivate();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (!(this.pframe_ instanceof PanPlotFrame)) {
            return;
        }
        PanPlotFrame pframe = (PanPlotFrame)this.pframe_;
        if (pframe.isAnimating()) {
            return;
        }
    }
}

