/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.data.ContourLine;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.MathUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.panoply.data.PanDataLonLatGridded;
import gov.nasa.giss.panoply.plot.PanLLPlotMapInsert;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.util.PanCombinationType;
import gov.nasa.giss.panoply.util.PanContourStyle;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.panoply.util.PanVectorStyle;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLLPlotColorContourInsert
extends PanLLPlotMapInsert {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final float RAD_135 = (float)Math.toRadians(135.0);
    private boolean contoursLabeled_;
    private int contourWeight_;
    private ContourLevels contourLevels_;
    private BasicStroke contourStrokeSolid_;
    private BasicStroke contourStrokeDotted_;
    private Font contourFont_;
    private PanVectorStyle vectorStyle_;
    private int vectorWeight_;
    private Color vectorColor_;
    private BasicStroke vectorStroke_;
    private PrintfFormat scaleFormatter_ = new PrintfFormat("%G");
    private boolean numberlayEnabled_;
    private Font numbersFont_;

    public PanLLPlotColorContourInsert(PanPlotMeta pmeta) {
        super(pmeta);
        this.setOpaque(false);
        this.parameterChangedPrivate("all");
    }

    @Override
    protected void paintMap(Graphics2D g2d, boolean printing, AbstractProjection projection, boolean knockout, boolean borderVis) {
        Graphics2D g2dx;
        block4: {
            BufferedImage tempImage = this.beginMap(knockout);
            tempImage = this.paintUnderlay(tempImage);
            tempImage = this.paintSourceImage(tempImage);
            tempImage = this.paintPanMaskOverlays(tempImage);
            tempImage = this.paintNightShading(tempImage);
            LonLatEdges llbounds = new LonLatEdges(this.srcLeft_, this.srcTop_, this.srcRight_, this.srcBottom_);
            projection.setSourceImage(tempImage, llbounds);
            g2dx = (Graphics2D)g2d.create();
            if (printing) {
                projection.drawMapVectorized(g2dx);
            } else {
                projection.paintMap(g2dx);
            }
            this.drawOutlineOverlays(g2dx, projection);
            try {
                this.drawContours(g2dx, projection);
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
        this.drawVectors(g2dx, projection);
        this.drawNumberlay(g2dx);
        this.drawGridAndBorder(g2dx, projection, borderVis);
        g2dx.dispose();
    }

    private BufferedImage paintSourceImage(BufferedImage tempImage) {
        if (this.alphaEnabled_ && this.alphaLevel1_ == 0 && this.alphaLevel2_ == 0) {
            return tempImage;
        }
        Graphics2D tg2d = tempImage.createGraphics();
        tg2d.drawImage((Image)this.dataImage_, 0, 0, this);
        tg2d.dispose();
        return tempImage;
    }

    protected void drawContours(Graphics2D g2d, AbstractProjection proj) {
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        if (this.contourWeight_ < 1) {
            return;
        }
        String style = this.pmeta_.getString("contour.style").toLowerCase();
        if (PanContourStyle.NONE.matches(style)) {
            return;
        }
        if (this.contourLevels_ == null) {
            return;
        }
        int levelcount = this.contourLevels_.size();
        if (levelcount == 0) {
            return;
        }
        Color color = this.pmeta_.getColor("contour.color");
        PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
        for (ContourLevel level : this.contourLevels_) {
            double value = level.getValue();
            String labelstr = this.scaleFormatter_.sprintfx(value);
            BasicStroke stroke = PanContourStyle.DOTNEG.matches(style) ? (value < 0.0 ? this.contourStrokeDotted_ : this.contourStrokeSolid_) : (PanContourStyle.DOTMINOR.matches(style) ? (level.isLabeled() ? this.contourStrokeSolid_ : this.contourStrokeDotted_) : (PanContourStyle.DOTS.matches(style) ? this.contourStrokeDotted_ : this.contourStrokeSolid_));
            int levelsize = level.size();
            for (int ii = 0; ii < levelsize; ++ii) {
                ContourLine line = (ContourLine)level.get(ii);
                Point2D.Double[] points = line.toArray(new Point2D.Double[0]);
                PointLL[] llPoints = new PointLL[points.length];
                for (int iii = 0; iii < points.length; ++iii) {
                    if (points[iii] == null) {
                        llPoints[iii] = null;
                        continue;
                    }
                    Point2D.Double ll = lldata.getXY(points[iii].x, points[iii].y);
                    llPoints[iii] = new PointLL(ll.x, ll.y);
                }
                proj.setPathStroke(stroke);
                proj.setPathColor(color);
                if (this.contourFont_ != null && this.contoursLabeled_ && level.isLabeled()) {
                    proj.drawPath(g2d, llPoints, labelstr, this.contourFont_);
                    continue;
                }
                proj.drawPath(g2d, llPoints);
            }
        }
    }

    protected void drawNumberlay(Graphics2D g2d) {
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        if (!this.numberlayEnabled_) {
            return;
        }
        boolean hideInvalids = !this.pmeta_.getBoolean("beta.numberlay.invalids");
        g2d.setColor(this.pmeta_.getColor("beta.numberlay.color"));
        g2d.setFont(this.numbersFont_);
        double lonStep = this.pmeta_.getDouble("beta.numberlay.lon.spacing");
        double latStep = this.pmeta_.getDouble("beta.numberlay.lat.spacing");
        boolean lonOffset = this.pmeta_.getBoolean("beta.numberlay.lon.offset");
        boolean latOffset = this.pmeta_.getBoolean("beta.numberlay.lat.offset");
        FontMetrics fm = g2d.getFontMetrics();
        float fh2 = 0.5f * (float)fm.getHeight();
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
        PointLL ll = new PointLL();
        block2: for (int ii = 0; ii < 32000; ++ii) {
            double lon = lonStep * (double)ii;
            if (lonOffset) {
                lon += 0.5 * lonStep;
            }
            if (lon >= 360.0) break;
            for (int jj = 0; jj <= 32000; ++jj) {
                double lat = latStep * (double)jj;
                if (latOffset) {
                    lat += 0.5 * latStep;
                }
                if (lat >= 90.0) continue block2;
                for (int kk = 0; kk < 2; ++kk) {
                    String label;
                    double value;
                    if (kk == 1 && lat == 0.0) continue;
                    ll.setLon(lon);
                    if (kk == 0) {
                        ll.setLat(lat);
                    } else {
                        ll.setLat(-lat);
                    }
                    Point2D.Double xy = proj.transformLL2XY(ll);
                    if (xy == null) continue;
                    try {
                        value = lldata.valueAt(ll);
                    }
                    catch (Exception exc) {
                        continue;
                    }
                    if (hideInvalids && Double.isNaN(value)) continue;
                    String labelstr = this.scaleFormatter_.sprintfx(value);
                    String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
                    if (label == null) continue;
                    float w = GraphicUtils.stringWidth(label, g2d);
                    float labelx = (float)(xy.x - (double)(0.5f * w));
                    float labely = (float)(xy.y + (double)fh2);
                    GraphicUtils.drawString(g2d, (Object)label, labelx, labely);
                }
            }
        }
    }

    protected void drawVectors(Graphics2D g2d, AbstractProjection proj) {
        int ystart;
        boolean counterclockwise;
        double baseAzimuthRad;
        if (!(this.data_ instanceof PanDataLonLatGridded)) {
            return;
        }
        if (this.vectorWeight_ < 1) {
            return;
        }
        if (this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        double referenceVal = this.pmeta_.getDouble("vector.refvalue");
        if (referenceVal <= 0.0) {
            return;
        }
        Color color = this.vectorColor_;
        BasicStroke stroke = this.vectorStroke_;
        g2d.setColor(color);
        g2d.setStroke(stroke);
        PanDataLonLatGridded lldata = (PanDataLonLatGridded)this.data_;
        if (lldata.isVectorMagAngle()) {
            baseAzimuthRad = this.getMAVectorBaseAngle();
            counterclockwise = false;
        } else {
            Object[] baseAngleData = this.getXYVectorBaseAngle();
            if (baseAngleData == null) {
                return;
            }
            baseAzimuthRad = (Double)baseAngleData[0];
            counterclockwise = (Boolean)baseAngleData[1];
        }
        int sww = this.dataImage_.getWidth();
        int shh = this.dataImage_.getHeight();
        int vlength = this.pmeta_.getLayout().getInt("vector.length");
        if ((double)vlength == 0.0) {
            LOGGER.trace("vlength == 0; I will not draw vectors");
            return;
        }
        float spacePct = 0.01f * (float)this.pmeta_.getInt("vector.spacing");
        int spacing = (int)((float)vlength * spacePct);
        int iheight = this.getHeight();
        int iwidth = this.getWidth();
        GeneralPath arrow = new GeneralPath();
        int xstart = iwidth / 2 - spacing * (iwidth / 2 / spacing);
        for (int y = ystart = iheight / 2 - spacing * (iheight / 2 / spacing); y < iheight; y += spacing) {
            for (int x = xstart; x < iwidth; x += spacing) {
                float ytip;
                float xtip;
                float factor;
                float length;
                double azimuthRad;
                double mag;
                double lon;
                PointLL lonlat = this.transformXY2LL(x, y);
                if (lonlat == null) continue;
                double lat = lonlat.getLat();
                for (lon = lonlat.getLon(); lon < this.srcLeft_; lon += 360.0) {
                }
                while (lon > this.srcRight_) {
                    lon -= 360.0;
                }
                double col = (lon - this.srcLeft_) * (double)sww / (this.srcRight_ - this.srcLeft_);
                double row = (lat - this.srcTop_) * (double)shh / (this.srcBottom_ - this.srcTop_);
                if (col < 0.0 || col >= (double)sww || row < 0.0 || row >= (double)shh || Double.isNaN(mag = lldata.valueAt((int)col, (int)row)) || mag == 0.0 || Double.isNaN(azimuthRad = lldata.secondValueAt((int)col, (int)row))) continue;
                azimuthRad = counterclockwise ? baseAzimuthRad - azimuthRad : baseAzimuthRad + azimuthRad;
                if (Double.isNaN(azimuthRad = proj.transformLLAngle2XYAngle(lonlat, azimuthRad)) || (double)(length = (float)vlength * (factor = (float)(mag / referenceVal))) == 0.0) continue;
                float xorig = (float)x + 0.5f;
                float yorig = (float)y + 0.5f;
                if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
                    double radius = Math.sqrt(0.2 * (double)length);
                    if (radius < 1.0) {
                        radius = 1.0;
                    }
                    g2d.fill(new Ellipse2D.Double((double)xorig - radius, (double)yorig - radius, radius * 2.0, radius * 2.0));
                }
                if (this.transformXY2LL(xtip = (float)((double)xorig + (double)length * Math.sin(azimuthRad)), ytip = (float)((double)yorig - (double)length * Math.cos(azimuthRad))) == null) {
                    float xmin = xorig;
                    float ymin = yorig;
                    float xmax = xtip;
                    float ymax = ytip;
                    for (int iterate = 0; iterate < 5; ++iterate) {
                        xtip = 0.5f * (xmin + xmax);
                        ytip = 0.5f * (ymin + ymax);
                        if (this.transformXY2LL(xtip, ytip) == null) {
                            xmax = xtip;
                            ymax = ytip;
                            continue;
                        }
                        xmin = xtip;
                        ymin = ytip;
                    }
                    GraphicUtils.drawLine(g2d, xorig, yorig, xtip, ytip);
                    continue;
                }
                GraphicUtils.drawLine(g2d, xorig, yorig, xtip, ytip);
                if (this.vectorStyle_ != PanVectorStyle.ARROW) continue;
                float hlengthX = 0.175f * (float)vlength * Math.max(0.5f, factor);
                float x1 = (float)((double)xtip + (double)hlengthX * Math.sin(azimuthRad - (double)RAD_135));
                float y1 = (float)((double)ytip - (double)hlengthX * Math.cos(azimuthRad - (double)RAD_135));
                float x2 = (float)((double)xtip + (double)hlengthX * Math.sin(azimuthRad + (double)RAD_135));
                float y2 = (float)((double)ytip - (double)hlengthX * Math.cos(azimuthRad + (double)RAD_135));
                arrow.reset();
                arrow.moveTo(x1, y1);
                arrow.lineTo(xtip, ytip);
                arrow.lineTo(x2, y2);
                g2d.draw(arrow);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] getXYVectorBaseAngle() {
        boolean counterclockwise;
        double baseAzimuthRad;
        String dir1 = this.pmeta_.getString("vector.dir1");
        String dir2 = this.pmeta_.getString("vector.dir2");
        if (dir2.equalsIgnoreCase("North")) {
            baseAzimuthRad = 0.0;
            if (dir1.equalsIgnoreCase("East")) {
                counterclockwise = false;
                return new Object[]{baseAzimuthRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("West")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAzimuthRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("East")) {
            baseAzimuthRad = 1.5707963267948966;
            if (dir1.equalsIgnoreCase("North")) {
                counterclockwise = true;
                return new Object[]{baseAzimuthRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("South")) return null;
                counterclockwise = false;
            }
            return new Object[]{baseAzimuthRad, counterclockwise};
        } else if (dir2.equalsIgnoreCase("South")) {
            baseAzimuthRad = Math.PI;
            if (dir1.equalsIgnoreCase("West")) {
                counterclockwise = false;
                return new Object[]{baseAzimuthRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("East")) return null;
                counterclockwise = true;
            }
            return new Object[]{baseAzimuthRad, counterclockwise};
        } else {
            if (!dir2.equalsIgnoreCase("West")) return null;
            baseAzimuthRad = 4.71238898038469;
            if (dir1.equalsIgnoreCase("North")) {
                counterclockwise = false;
                return new Object[]{baseAzimuthRad, counterclockwise};
            } else {
                if (!dir1.equalsIgnoreCase("South")) return null;
                counterclockwise = true;
            }
        }
        return new Object[]{baseAzimuthRad, counterclockwise};
    }

    private double getMAVectorBaseAngle() {
        String dir1 = this.pmeta_.getString("vector.dir1");
        String dir2 = this.pmeta_.getString("vector.dir2");
        double baseAzimuthRad = 0.0;
        if ("upstream".equalsIgnoreCase(dir1) || "upstream".equalsIgnoreCase(dir2)) {
            baseAzimuthRad = Math.PI;
        }
        return baseAzimuthRad;
    }

    public void setContours(ContourLevels levels) {
        this.contourLevels_ = levels;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll = pname == null || "all".equals(pname);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj == null) {
            return;
        }
        if (changeAll || pname.contains("contour.label.vis")) {
            this.contoursLabeled_ = this.pmeta_.getBoolean("contour.label.vis");
        }
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains("contour.color") || pname.contains("contour.weight") || pname.contains("contour.style")) {
            String style = this.pmeta_.getString("contour.style");
            this.contourWeight_ = PanStringUtils.isNoneString(style) ? 0 : PanPlotConstraints.constrainContourWeight(this.pmeta_.getInt("contour.weight"));
            this.contourStrokeSolid_ = PanGraphicUtils.roundStroke(PanStrokePattern.SOLID, this.contourWeight_, sfactor);
            this.contourStrokeDotted_ = PanGraphicUtils.roundStroke(PanStrokePattern.DOTS, this.contourWeight_, sfactor);
        }
        if (changeAll || pname.contains("scale.tick.format")) {
            String s = this.pmeta_.getString("scale.tick.format");
            if (s == null) {
                LOGGER.debug("Property {} has null value", (Object)"scale.tick.format");
                throw new RuntimeException("Null format string");
            }
            this.scaleFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("combination") || pname.contains("vector.color") || pname.contains("vector.weight") || pname.contains("vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = PanCombinationType.matching(this.pmeta_.getString("combination"));
            boolean bl = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanPlotConstraints.constrainVectorWeight(this.pmeta_.getInt("vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanPlotConstraints.constrainVectorWeight(this.pmeta_.getInt("vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            if (this.vectorWeight_ > 0) {
                this.vectorColor_ = this.pmeta_.getColor("vector.color");
                this.vectorStroke_ = GraphicUtils.buttMiterStroke(this.vectorWeight_);
            } else {
                this.vectorColor_ = null;
                this.vectorStroke_ = null;
            }
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("contour.label.size")) {
            String fn = this.pmeta_.getString("labels.font");
            float scaling = 0.01f * (float)sfactor;
            float cfhgt = scaling * PanPlotConstraints.constrainContourLabelSize(this.pmeta_.getFloat("contour.label.size"));
            this.contourFont_ = null;
            if (cfhgt > 0.0f) {
                this.contourFont_ = PanGraphicUtils.getFont(fn, cfhgt);
            }
        }
        PanPreferences prefs = PanPreferences.getSharedInstance();
        if (PanUtils.isBeta() && prefs.getBoolean("beta:numberlays")) {
            if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("beta.numberlay.size")) {
                String fn = this.pmeta_.getString("labels.font");
                float scaling = 0.01f * (float)sfactor;
                float nfhgt = scaling * this.pmeta_.getFloat("beta.numberlay.size");
                this.numbersFont_ = null;
                if (nfhgt > 0.0f) {
                    nfhgt = MathUtils.constrain(2.0f, 36.0f, nfhgt);
                    this.numbersFont_ = PanGraphicUtils.getFont(fn, nfhgt);
                }
            }
            if (changeAll || pname.contains("beta.numberlay.enabled") || pname.contains("beta.numberlay.invalids") || pname.contains("beta.numberlay.color") || pname.contains("beta.numberlay.lon.spacing") || pname.contains("beta.numberlay.lat.spacing") || pname.contains("beta.numberlay.lon.offset") || pname.contains("beta.numberlay.lat.offset") || pname.contains("size.factor")) {
                this.numberlayEnabled_ = this.pmeta_.getBoolean("beta.numberlay.enabled");
            }
        }
    }
}

