/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.graphics.clut.ColorTableOutlierShape;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import gov.nasa.giss.panoply.data.PanData;
import gov.nasa.giss.panoply.plot.PanPlotConstraints;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.panoply.util.PanColorbarLabelLocation;
import gov.nasa.giss.panoply.util.PanColorbarLocation;
import gov.nasa.giss.panoply.util.PanColorbarOutlierGap;
import gov.nasa.giss.panoply.util.PanColorbarOutlierSide;
import gov.nasa.giss.panoply.util.PanColorbarTickLength;
import gov.nasa.giss.panoply.util.PanGraphicUtils;
import gov.nasa.giss.panoply.util.PanScaleMethod;
import gov.nasa.giss.panoply.util.PanStringUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanVerticalColorbar
extends PanPlotPiece {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanData data_;
    private AbstractColorTable clut_;
    private boolean clutReversed_;
    private float lengthFrac_ = 0.5f;
    private boolean useCustomCaption_;
    private String customCaption_ = "";
    private PanColorbarLabelLocation captionLoc_ = PanColorbarLabelLocation.ABOVE;
    private Font captionFont_;
    private float captionX_;
    private float barThickness_;
    private float barLength_;
    private float barTopX_;
    private float barBottomX_;
    private float barLeftY_;
    private float barRightY_;
    private Font ticksFont_;
    private float ticksX_;
    private PanColorbarOutlierSide oside_;
    private ColorTableOutlierShape oshape_;
    private PanColorbarOutlierGap ogap_ = PanColorbarOutlierGap.THIN;
    private boolean outlierOnLeft_;
    private boolean outlierOnRight_;
    private boolean outlierFlushLeft_;
    private boolean outlierFlushRight_;
    private float outlierGap_;
    private float outlierWidth_;
    private BasicStroke borderStroke_;
    private int borderWgt_;
    private PanColorbarTickLength tickLength_ = PanColorbarTickLength.SHORT;
    private BasicStroke tickStroke_;
    private boolean needsMeasurement_ = true;

    public PanVerticalColorbar(PanPlotMeta pmeta) {
        super(pmeta);
        this.data_ = pmeta.getData();
        this.setOpaque(false);
        this.setClippingDisabled(true);
        this.parameterChangedPrivate("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsMeasurement_ = true;
    }

    @Override
    protected void prepareToPaint() {
        String caption;
        if (PanColorbarLocation.matching(this.pmeta_.getString("colorbar.location")).isHorizontal()) {
            LOGGER.trace("Colorbar place has changed; skipping paint.");
            return;
        }
        super.prepareToPaint();
        if (!this.needsMeasurement_) {
            return;
        }
        String fn = this.pmeta_.getString("labels.font");
        PlotPieceMargins margins = this.getMargins();
        float scaling = 0.01f * (float)this.pmeta_.getInt("size.factor");
        this.barThickness_ = scaling * 14.0f + 0.5f;
        float tickBaseSize = PanPlotConstraints.constrainScaleTickLabelSize(this.pmeta_.getFloat("scale.tick.size"));
        float captionBaseSize = PanPlotConstraints.constrainScaleLabelSize(this.pmeta_.getFloat("scale.label.size"));
        float captionFHeight = scaling * captionBaseSize + 0.5f;
        float ticksFHeight = scaling * tickBaseSize + 0.5f;
        int gap1 = Math.max(4, (int)(scaling * 5.0f + 0.5f));
        this.captionFont_ = PanGraphicUtils.getFont(fn, captionFHeight);
        this.ticksFont_ = PanGraphicUtils.getFont(fn, ticksFHeight);
        String string = caption = this.useCustomCaption_ ? this.customCaption_ : this.data_.getDescription();
        if (caption == null || caption.isEmpty() || this.captionLoc_ == PanColorbarLabelLocation.NONE) {
            this.captionX_ = 0.0f;
            this.barTopX_ = margins.getTop() + 1;
            this.barBottomX_ = this.barTopX_ + this.barThickness_;
        } else if (this.captionLoc_ == PanColorbarLabelLocation.ABOVE) {
            this.captionX_ = (float)margins.getLeft() + captionFHeight;
            this.barTopX_ = this.captionX_ + 1.5f * (float)gap1;
            this.barBottomX_ = this.barTopX_ + this.barThickness_;
        } else if (this.captionLoc_ == PanColorbarLabelLocation.BELOW) {
            this.captionX_ = 0.0f;
            this.barTopX_ = margins.getTop() + 1;
            this.barBottomX_ = this.barTopX_ + this.barThickness_;
        }
        this.ticksX_ = this.barBottomX_ + (float)gap1;
        switch (this.ogap_) {
            case THIN: {
                this.outlierGap_ = 0.25f * this.barThickness_;
                break;
            }
            case WIDE: {
                this.outlierGap_ = 0.5f * this.barThickness_;
                break;
            }
            default: {
                this.outlierGap_ = 0.0f;
            }
        }
        if (this.oside_ == PanColorbarOutlierSide.NONE) {
            this.outlierWidth_ = 0.0f;
            this.outlierGap_ = 0.0f;
        } else {
            switch (this.oshape_) {
                case TRIANGLE: {
                    this.outlierWidth_ = this.barThickness_;
                    break;
                }
                case TRIANGLE_2: {
                    this.outlierWidth_ = 2.0f * this.barThickness_;
                    break;
                }
                case TRIANGLE_3: {
                    this.outlierWidth_ = 3.0f * this.barThickness_;
                    break;
                }
                case RECTANGLE: {
                    this.outlierWidth_ = 0.5f * this.barThickness_;
                    break;
                }
                default: {
                    this.outlierWidth_ = this.barThickness_;
                }
            }
        }
        int height = this.getHeight();
        this.barLength_ = this.lengthFrac_ * (float)height - 2.0f * (this.outlierGap_ + this.outlierWidth_);
        this.barLeftY_ = 0.5f * ((float)height + this.barLength_);
        this.barRightY_ = this.barLeftY_ - this.barLength_;
        this.needsMeasurement_ = false;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        if (PanColorbarLocation.matching(this.pmeta_.getString("colorbar.location")).isHorizontal()) {
            LOGGER.trace("Colorbar place has changed; skipping paint.");
            return;
        }
        if (this.clut_ == null) {
            LOGGER.warn("Color table is null; skipping paint.");
            return;
        }
        this.drawCaption(gx);
        this.drawColorbar(gx);
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        switch (smethod) {
            case LOG10: 
            case LOG_E: {
                this.drawLogTicks(gx);
                break;
            }
            default: {
                this.drawStandardTicks(gx);
            }
        }
    }

    private void drawCaption(Graphics2D g2d) {
        String labelstr;
        if (this.captionLoc_ != PanColorbarLabelLocation.ABOVE) {
            return;
        }
        String string = labelstr = this.useCustomCaption_ ? this.customCaption_ : this.data_.getDescription();
        if (labelstr == null || labelstr.isEmpty()) {
            return;
        }
        int hh = this.getHeight();
        g2d.setColor(this.getForeground());
        g2d.setFont(this.captionFont_);
        labelstr = GraphicUtils.trimStringToFit(labelstr, g2d, hh);
        String label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
        int labelWidth = (int)GraphicUtils.stringWidth(label, g2d);
        float x = this.captionX_;
        float y = (hh + labelWidth) / 2;
        g2d.translate(x, y);
        g2d.rotate(-1.5707963267948966);
        GraphicUtils.drawString(g2d, (Object)label, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-x, -y);
    }

    private void drawColorbar(Graphics2D g2d) {
        if (this.clut_ == null) {
            return;
        }
        float yleft = this.barLeftY_ + this.outlierGap_;
        float yright = this.barRightY_ - this.outlierGap_;
        GeneralPath path = new GeneralPath();
        switch (this.oshape_) {
            case TRIANGLE: 
            case TRIANGLE_2: 
            case TRIANGLE_3: {
                if (this.outlierOnLeft_) {
                    path.reset();
                    path.moveTo(this.barTopX_, yleft);
                    path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, yleft + this.outlierWidth_);
                    path.lineTo(this.barBottomX_, yleft);
                    path.closePath();
                    g2d.setColor(this.clut_.getMinOutlierColor(this.clutReversed_));
                    g2d.fill(path);
                }
                if (!this.outlierOnRight_) break;
                path.reset();
                path.moveTo(this.barTopX_, yright);
                path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, yright - this.outlierWidth_);
                path.lineTo(this.barBottomX_, yright);
                path.closePath();
                g2d.setColor(this.clut_.getMaxOutlierColor(this.clutReversed_));
                g2d.fill(path);
                break;
            }
            case RECTANGLE: {
                if (this.outlierOnLeft_) {
                    g2d.setColor(this.clut_.getMinOutlierColor(this.clutReversed_));
                    GraphicUtils.fillRect(g2d, this.barTopX_, yleft, this.barThickness_, this.outlierWidth_);
                }
                if (!this.outlierOnRight_) break;
                g2d.setColor(this.clut_.getMaxOutlierColor(this.clutReversed_));
                GraphicUtils.fillRect(g2d, this.barTopX_, yright - this.outlierWidth_, this.barThickness_, this.outlierWidth_);
                break;
            }
            default: {
                LOGGER.debug("Switch default case: How did we get here? {}", (Object)this.oshape_);
            }
        }
        int colorCount = this.clut_.getColorCount();
        float binWidth = this.barLength_ / (float)colorCount;
        for (int i = 0; i < colorCount; ++i) {
            Color c2;
            float binOffset = binWidth * (float)i;
            float binLeft = this.barLeftY_ - binOffset;
            Color c1 = this.clut_.getColorAt(i, this.clutReversed_);
            int iwidth = 1;
            for (int j = i + 1; j < colorCount && (c2 = this.clut_.getColorAt(j, this.clutReversed_)).equals(c1); ++j) {
                ++iwidth;
            }
            float colorWidth = binWidth * (float)iwidth;
            i += iwidth - 1;
            if (binLeft + (colorWidth += 0.75f) > this.barRightY_) {
                colorWidth = binLeft - this.barRightY_;
            }
            float binRight = binLeft - colorWidth;
            g2d.setColor(this.clut_.getColorAt(i, this.clutReversed_));
            GraphicUtils.fillRect(g2d, this.barTopX_, binRight, this.barThickness_, colorWidth);
        }
        if (this.borderStroke_ == null) {
            return;
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.borderStroke_);
        if (this.oside_ == PanColorbarOutlierSide.NONE) {
            GraphicUtils.drawRect(g2d, this.barTopX_, this.barRightY_, this.barThickness_, this.barLength_);
        } else if (this.ogap_ == PanColorbarOutlierGap.NONE) {
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    path.reset();
                    path.moveTo(this.barTopX_, this.barLeftY_);
                    path.lineTo(this.barTopX_, this.barRightY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, this.barRightY_ - this.outlierWidth_);
                    }
                    path.lineTo(this.barBottomX_, this.barRightY_);
                    path.lineTo(this.barBottomX_, this.barLeftY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, this.barLeftY_ + this.outlierWidth_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    path.reset();
                    path.moveTo(this.barTopX_, this.barLeftY_);
                    path.lineTo(this.barTopX_, this.barRightY_);
                    if (this.outlierOnRight_) {
                        path.lineTo(this.barTopX_, this.barRightY_ - this.outlierWidth_);
                        path.lineTo(this.barBottomX_, this.barRightY_ - this.outlierWidth_);
                    }
                    path.lineTo(this.barBottomX_, this.barRightY_);
                    path.lineTo(this.barBottomX_, this.barLeftY_);
                    if (this.outlierOnLeft_) {
                        path.lineTo(this.barBottomX_, this.barLeftY_ + this.outlierWidth_);
                        path.lineTo(this.barTopX_, this.barLeftY_ + this.outlierWidth_);
                    }
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
            }
        } else {
            GraphicUtils.drawRect(g2d, this.barTopX_, this.barRightY_, this.barThickness_, this.barLength_);
            switch (this.oshape_) {
                case TRIANGLE: 
                case TRIANGLE_2: 
                case TRIANGLE_3: {
                    if (this.outlierOnLeft_) {
                        path.reset();
                        path.moveTo(this.barTopX_, yleft);
                        path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, yleft + this.outlierWidth_);
                        path.lineTo(this.barBottomX_, yleft);
                        path.closePath();
                        g2d.draw(path);
                    }
                    if (!this.outlierOnRight_) break;
                    path.reset();
                    path.moveTo(this.barTopX_, yright);
                    path.lineTo(this.barTopX_ + 0.5f * this.barThickness_, yright - this.outlierWidth_);
                    path.lineTo(this.barBottomX_, yright);
                    path.closePath();
                    g2d.draw(path);
                    break;
                }
                case RECTANGLE: {
                    g2d.setColor(this.getForeground());
                    if (this.outlierOnLeft_) {
                        GraphicUtils.drawRect(g2d, this.barTopX_, yleft, this.barThickness_, this.outlierWidth_);
                    }
                    if (!this.outlierOnRight_) break;
                    GraphicUtils.drawRect(g2d, this.barTopX_, yright - this.outlierWidth_, this.barThickness_, this.outlierWidth_);
                    break;
                }
            }
        }
    }

    private void drawStandardTicks(Graphics2D g2d) {
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PrintfFormat formatter = smeta.getFormatter();
        float tlength = this.tickLength_.getLength();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        double scaleRange = Math.max(scaleMax - scaleMin, 1.0E-25);
        double mstep = (double)this.barLength_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.tickStroke_);
        g2d.setFont(this.ticksFont_);
        FontMetrics fm = g2d.getFontMetrics();
        float labelYOffset = 0.33f * (float)fm.getAscent();
        for (PanScaleTick tick : smeta.getTicks()) {
            String label;
            float tright;
            float tleft;
            double value = tick.getValue();
            float tickY = (float)((double)this.barLeftY_ - (value - scaleMin) * mstep);
            boolean longTick = false;
            boolean endTick = false;
            if (tick.isEndPoint()) {
                longTick = true;
                if (value - scaleMin == 0.0 && !this.outlierFlushLeft_) {
                    endTick = true;
                } else if (value - scaleMax == 0.0 && !this.outlierFlushRight_) {
                    endTick = true;
                }
            } else {
                longTick = tick.isMajor();
            }
            if (longTick) {
                tleft = this.barBottomX_ - tlength * this.barThickness_;
                tright = this.barBottomX_ + 0.2f * this.barThickness_;
            } else if (endTick) {
                tleft = this.barBottomX_;
                tright = this.barBottomX_ + 0.2f * this.barThickness_;
            } else {
                tleft = this.barBottomX_ - 0.2f * this.barThickness_;
                tright = this.barBottomX_;
            }
            if (Math.abs(tickY - this.barLeftY_) < 0.25f && !this.outlierFlushLeft_) {
                tleft = this.barBottomX_;
            } else if (Math.abs(tickY - this.barRightY_) < 0.25f && !this.outlierFlushLeft_) {
                tleft = this.barBottomX_;
            }
            if (tleft != tright) {
                GraphicUtils.drawLine(g2d, tleft, tickY, tright, tickY);
            }
            if (!tick.isMajor()) continue;
            float y = tickY + labelYOffset;
            String labelstr = formatter.sprintfx(value);
            String string = label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
            if (label == null) continue;
            GraphicUtils.drawString(g2d, (Object)label, this.ticksX_, y);
        }
    }

    private void drawLogTicks(Graphics2D g2d) {
        double logScaleMax;
        double logScaleMin;
        PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
        PanScaleMethod smethod = smeta.getMethod();
        PrintfFormat formatter = smeta.getFormatter();
        float tlength = this.tickLength_.getLength();
        FontMetrics fm = g2d.getFontMetrics();
        float labelYOffset = 0.33f * (float)fm.getAscent();
        double scaleMin = smeta.getScaleMinimum();
        double scaleMax = smeta.getScaleMaximum();
        switch (smethod) {
            case LOG_E: {
                logScaleMin = Math.log(scaleMin);
                logScaleMax = Math.log(scaleMax);
                break;
            }
            default: {
                logScaleMin = Math.log10(scaleMin);
                logScaleMax = Math.log10(scaleMax);
            }
        }
        double scaleRange = Math.max(logScaleMax - logScaleMin, 1.0E-25);
        double mstep = (double)this.barLength_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(this.tickStroke_);
        g2d.setFont(this.ticksFont_);
        for (PanScaleTick tick : smeta.getTicks()) {
            float tright;
            float tleft;
            double value = tick.getValue();
            double logValue = tick.getAlternativeValue();
            float tickY = (float)((double)this.barLeftY_ - (logValue - logScaleMin) * mstep);
            switch (tick.getType()) {
                case MAJOR: {
                    Object label;
                    tleft = this.barBottomX_ - tlength * this.barThickness_;
                    tright = this.barBottomX_ + 0.2f * this.barThickness_;
                    switch (smethod) {
                        case LOG_E: {
                            label = PanStringUtils.getSuperscriptedE(logValue, g2d);
                            break;
                        }
                        default: {
                            String labelstr = formatter.sprintfx(value);
                            label = this.pmeta_.getBoolean("labels.super10") ? PanStringUtils.convertENotationToSuperscript(labelstr, g2d) : labelstr;
                        }
                    }
                    float y = tickY + labelYOffset;
                    if (label == null) break;
                    GraphicUtils.drawString(g2d, label, this.ticksX_, y);
                    break;
                }
                case MINOR: {
                    tleft = this.barBottomX_ - 0.2f * this.barThickness_;
                    tright = this.barBottomX_ + 0.1f * this.barThickness_;
                    break;
                }
                default: {
                    tleft = this.barBottomX_ - 0.1f * this.barThickness_;
                    tright = this.barBottomX_;
                }
            }
            if (Math.abs(tickY - this.barLeftY_) < 0.25f && !this.outlierFlushLeft_) {
                tleft = this.barBottomX_;
            } else if (Math.abs(tickY - this.barRightY_) < 0.25f && !this.outlierFlushLeft_) {
                tleft = this.barBottomX_;
            }
            if (tleft == tright) continue;
            GraphicUtils.drawLine(g2d, tleft, tickY, tright, tickY);
        }
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.parameterChangedPrivate(pname);
    }

    private void parameterChangedPrivate(String pname) {
        boolean changeAll = pname == null || "all".equals(pname);
        int sfactor = this.pmeta_.getInt("size.factor");
        if (changeAll || pname.contains("color.background")) {
            this.setBackground(this.pmeta_.getColor("color.background"));
        }
        if (changeAll || pname.contains("size.factor") || pname.contains("colorbar.border.weight")) {
            this.tickStroke_ = PanGraphicUtils.solidStroke(100, sfactor);
            this.borderWgt_ = PanPlotConstraints.constrainColorbarBorderWeight(this.pmeta_.getInt("colorbar.border.weight"));
            this.borderStroke_ = PanGraphicUtils.solidStroke(this.borderWgt_, sfactor);
        }
        if (changeAll || pname.contains("scale.label.custom") || pname.contains("scale.label.text")) {
            this.useCustomCaption_ = this.pmeta_.getBoolean("scale.label.custom");
            this.customCaption_ = this.pmeta_.getString("scale.label.text");
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.label.location")) {
            String s = this.pmeta_.getString("colorbar.label.location");
            this.captionLoc_ = PanColorbarLabelLocation.matching(s);
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.name")) {
            this.clut_ = this.pmeta_.getScaleMeta().getColorTable();
        }
        if (changeAll || pname.contains("colorbar.length")) {
            this.lengthFrac_ = 0.01f * (float)PanPlotConstraints.constrainColorbarLength(this.pmeta_.getInt("colorbar.length"));
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.reverse")) {
            this.clutReversed_ = this.pmeta_.getBoolean("colorbar.reverse");
        }
        if (changeAll || pname.contains("colorbar.tick.length")) {
            this.tickLength_ = PanColorbarTickLength.matching(this.pmeta_.getString("colorbar.tick.length"));
            if (this.tickLength_ == null) {
                this.tickLength_ = PanColorbarTickLength.SHORT;
            }
        }
        if (changeAll || pname.contains("labels.font") || pname.contains("size.factor") || pname.contains("scale.tick.size") || pname.contains("scale.label.size")) {
            this.needsMeasurement_ = true;
        }
        if (changeAll || pname.contains("colorbar.outlier.side") || pname.contains("colorbar.outlier.shape") || pname.contains("colorbar.outlier.gap")) {
            this.oside_ = PanColorbarOutlierSide.matching(this.pmeta_.getString("colorbar.outlier.side"));
            this.oshape_ = ColorTableOutlierShape.matching(this.pmeta_.getString("colorbar.outlier.shape"));
            this.ogap_ = PanColorbarOutlierGap.matching(this.pmeta_.getString("colorbar.outlier.gap"));
            if (this.oside_ == null) {
                LOGGER.warn("No outlier side for {} ({})", (Object)this.pmeta_.getString("colorbar.outlier.side"), (Object)pname);
            }
            if (this.oshape_ == null) {
                LOGGER.warn("No outlier shape for {} ({})", (Object)this.pmeta_.getString("colorbar.outlier.shape"), (Object)pname);
            }
            if (this.ogap_ == null) {
                LOGGER.warn("No outlier gap for {} ({})", (Object)this.pmeta_.getString("colorbar.outlier.gap"), (Object)pname);
            }
            this.outlierOnLeft_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.LEFT;
            this.outlierOnRight_ = this.oside_ == PanColorbarOutlierSide.BOTH || this.oside_ == PanColorbarOutlierSide.RIGHT;
            this.outlierFlushLeft_ = this.outlierOnLeft_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.outlierFlushRight_ = this.outlierOnRight_ && this.ogap_ == PanColorbarOutlierGap.NONE;
            this.needsMeasurement_ = true;
        }
    }
}

