/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.util.PanPlotControlsID;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Objects;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanPlotControlsMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FLOATING = "floating";
    private static final String UNIFIED = "unified";
    private static final Hashtable<PanPlotControlsID, Boolean> VISIBILITY = new Hashtable(15);
    private static final Hashtable<PanPlotControlsID, Boolean> COLLAPSED = new Hashtable(15);
    private static final Hashtable<PanPlotControlsID, Point> LOCATION = new Hashtable(15);
    private static boolean floatingThisSession_;
    private static boolean floatingNextSession_;
    private static boolean unifiedThisSession_;
    private static boolean unifiedNextSession_;

    public static void restore() {
        floatingThisSession_ = true;
        floatingNextSession_ = true;
        unifiedThisSession_ = true;
        unifiedNextSession_ = true;
        VISIBILITY.put(PanPlotControlsID.ALPHA, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.ARRAYS, Boolean.TRUE);
        VISIBILITY.put(PanPlotControlsID.CONTOURS, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.GRID, Boolean.TRUE);
        VISIBILITY.put(PanPlotControlsID.LABELS, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.LAYOUT, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.MAP, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.NUMBERLAY, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.OVERLAYS, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.SCALE, Boolean.TRUE);
        VISIBILITY.put(PanPlotControlsID.SHADING, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.STROKE, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.TRAJECTORY, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.VECTORS, Boolean.FALSE);
        VISIBILITY.put(PanPlotControlsID.UNIFIED, Boolean.TRUE);
        COLLAPSED.put(PanPlotControlsID.ALPHA, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.ARRAYS, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.CONTOURS, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.GRID, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.LABELS, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.LAYOUT, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.MAP, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.NUMBERLAY, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.OVERLAYS, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.SCALE, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.SHADING, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.STROKE, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.TRAJECTORY, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.VECTORS, Boolean.FALSE);
        COLLAPSED.put(PanPlotControlsID.UNIFIED, Boolean.FALSE);
        LOCATION.put(PanPlotControlsID.ALPHA, new Point(105, 380));
        LOCATION.put(PanPlotControlsID.ARRAYS, new Point(50, 50));
        LOCATION.put(PanPlotControlsID.CONTOURS, new Point(50, 1090));
        LOCATION.put(PanPlotControlsID.GRID, new Point(50, 500));
        LOCATION.put(PanPlotControlsID.LABELS, new Point(50, 850));
        LOCATION.put(PanPlotControlsID.LAYOUT, new Point(625, 190));
        LOCATION.put(PanPlotControlsID.MAP, new Point(50, 690));
        LOCATION.put(PanPlotControlsID.NUMBERLAY, new Point(100, 350));
        LOCATION.put(PanPlotControlsID.OVERLAYS, new Point(500, 500));
        LOCATION.put(PanPlotControlsID.SCALE, new Point(50, 190));
        LOCATION.put(PanPlotControlsID.SHADING, new Point(680, 1090));
        LOCATION.put(PanPlotControlsID.STROKE, new Point(50, 1090));
        LOCATION.put(PanPlotControlsID.TRAJECTORY, new Point(350, 1090));
        LOCATION.put(PanPlotControlsID.VECTORS, new Point(325, 1090));
        LOCATION.put(PanPlotControlsID.UNIFIED, new Point(50, 50));
        Rectangle msr = GuiUtils.getMainScreenBounds();
        msr.width -= 36;
        msr.height -= 36;
        for (PanPlotControlsID cid : PanPlotControlsID.values()) {
            Point cpt = LOCATION.get(cid);
            if (msr.contains(cpt)) continue;
            cpt.x = msr.x + 72;
            cpt.y = msr.y + msr.height - 36;
            LOCATION.put(cid, cpt);
        }
    }

    public static boolean isFloating() {
        return floatingThisSession_;
    }

    public static void setFloating(boolean floating) {
        floatingNextSession_ = floating;
    }

    public static boolean isUnified() {
        return unifiedThisSession_;
    }

    public static void setUnified(boolean unified) {
        unifiedNextSession_ = unified;
    }

    public static boolean isVisible(PanPlotControlsID cid) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        return VISIBILITY.get(cid);
    }

    public static void putVisible(PanPlotControlsID cid, boolean vis) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        VISIBILITY.put(cid, vis);
    }

    public static boolean isCollapsed(PanPlotControlsID cid) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        return COLLAPSED.get(cid);
    }

    public static void putCollapsed(PanPlotControlsID cid, boolean collapsed) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        COLLAPSED.put(cid, collapsed);
    }

    public static Point getLocation(PanPlotControlsID cid) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        return LOCATION.get(cid);
    }

    public static void putLocation(PanPlotControlsID cid, int x, int y) {
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        PanPlotControlsMeta.putLocation(cid, new Point(x, y));
    }

    public static void putLocation(PanPlotControlsID cid, Point pt) {
        GraphicsDevice[] screens;
        Objects.requireNonNull(cid, "Controls ID cannot be null.");
        boolean goodPt = false;
        for (GraphicsDevice screen : screens = GuiUtils.getScreens()) {
            Rectangle srec;
            GraphicsConfiguration gc = screen.getDefaultConfiguration();
            if (gc == null || !(srec = gc.getBounds()).contains(pt)) continue;
            goodPt = true;
            break;
        }
        if (!goodPt) {
            LOGGER.trace("Bad pt {},{} for {}", pt.x, pt.y, cid);
            Rectangle srec = GuiUtils.getMainScreenBounds();
            Insets ins = GuiUtils.getMainScreenInsets();
            pt.x = srec.x + ins.left + 36;
            pt.y = srec.y + ins.top + 36;
        }
        LOCATION.put(cid, pt);
    }

    public static void read(Element controls) {
        Iterator<Element> piter = controls.getChildren().iterator();
        if (!piter.hasNext()) {
            return;
        }
        boolean oneIsVisible = false;
        while (piter.hasNext()) {
            Element child = piter.next();
            String childName = child.getName();
            String pkey = child.getAttribute("key").getValue();
            if ("property".equals(childName)) {
                String pvalue = child.getAttribute("value").getValue();
                if (FLOATING.equals(pkey)) {
                    floatingNextSession_ = floatingThisSession_ = Boolean.valueOf(pvalue).booleanValue();
                    LOGGER.trace("floating, {}", (Object)floatingThisSession_);
                    continue;
                }
                if (UNIFIED.equals(pkey)) {
                    unifiedNextSession_ = unifiedThisSession_ = Boolean.valueOf(pvalue).booleanValue();
                    LOGGER.trace("unified, {}", (Object)unifiedThisSession_);
                    continue;
                }
                LOGGER.trace("Unknown controls property key {}", (Object)pkey);
                continue;
            }
            if ("group".equals(childName)) {
                if (UNIFIED.equalsIgnoreCase(pkey)) {
                    PanPlotControlsMeta.readGroup(child);
                    continue;
                }
                oneIsVisible = PanPlotControlsMeta.readGroup(child) || oneIsVisible;
                continue;
            }
            LOGGER.trace("Unknown controls pref item {}", (Object)childName);
        }
        if (PanPlotControlsMeta.isFloating()) {
            if (PanPlotControlsMeta.isUnified()) {
                PanPlotControlsMeta.putVisible(PanPlotControlsID.UNIFIED, true);
            } else if (!oneIsVisible) {
                PanPlotControlsMeta.putVisible(PanPlotControlsID.ARRAYS, true);
                PanPlotControlsMeta.putVisible(PanPlotControlsID.GRID, true);
                PanPlotControlsMeta.putVisible(PanPlotControlsID.SCALE, true);
            }
        }
    }

    private static boolean readGroup(Element controls) {
        String key = controls.getAttribute("key").getValue();
        if (key == null || key.isEmpty()) {
            return false;
        }
        PanPlotControlsID cid = PanPlotControlsID.matching(key);
        if (cid == null) {
            LOGGER.trace("No PlotControlsID matching {}", (Object)key);
            return false;
        }
        Iterator<Element> piter = controls.getChildren().iterator();
        if (!piter.hasNext()) {
            return false;
        }
        boolean isVis = false;
        while (piter.hasNext()) {
            Element lchild = piter.next();
            String lchildName = lchild.getName();
            if ("property".equals(lchildName)) {
                Point pt;
                String pkey = null;
                String pvalue = null;
                try {
                    pkey = lchild.getAttribute("key").getValue();
                    pvalue = lchild.getAttribute("value").getValue();
                }
                catch (Exception exc) {
                    LOGGER.warn("Unable to parse a controls property.");
                }
                if (pkey == null || pkey.isEmpty() || pvalue == null || pvalue.isEmpty()) continue;
                if ("vis".equals(pkey)) {
                    boolean bvalue = Boolean.valueOf(pvalue);
                    isVis = bvalue || isVis;
                    PanPlotControlsMeta.putVisible(cid, bvalue);
                    continue;
                }
                int ivalue = Integer.valueOf(pvalue);
                if ("left".equals(pkey) || "x".equals(pkey)) {
                    pt = LOCATION.get(cid);
                    pt.x = ivalue;
                    PanPlotControlsMeta.putLocation(cid, pt);
                    continue;
                }
                if (!"top".equals(pkey) && !"y".equals(pkey)) continue;
                pt = LOCATION.get(cid);
                pt.y = ivalue;
                PanPlotControlsMeta.putLocation(cid, pt);
                continue;
            }
            LOGGER.debug("Unknown {} controls setting '{}'", (Object)key, (Object)lchildName);
        }
        return isVis;
    }

    public static void write(Element parent) throws IOException {
        Element controls = new Element("group");
        controls.setAttribute("key", "controls");
        Element ex = new Element("property");
        ex.setAttribute("key", FLOATING);
        ex.setAttribute("value", Boolean.toString(floatingNextSession_));
        controls.addContent(ex);
        ex = new Element("property");
        ex.setAttribute("key", UNIFIED);
        ex.setAttribute("value", Boolean.toString(unifiedNextSession_));
        controls.addContent(ex);
        for (PanPlotControlsID cid : PanPlotControlsID.values()) {
            Element cgroup = new Element("group");
            cgroup.setAttribute("key", cid.name());
            Element cprop = new Element("property");
            cprop.setAttribute("key", "vis");
            cprop.setAttribute("value", Boolean.toString(PanPlotControlsMeta.isVisible(cid)));
            cgroup.addContent(cprop);
            cprop = new Element("property");
            cprop.setAttribute("key", "left");
            cprop.setAttribute("value", Integer.toString(PanPlotControlsMeta.getLocation((PanPlotControlsID)cid).x));
            cgroup.addContent(cprop);
            cprop = new Element("property");
            cprop.setAttribute("key", "top");
            cprop.setAttribute("value", Integer.toString(PanPlotControlsMeta.getLocation((PanPlotControlsID)cid).y));
            cgroup.addContent(cprop);
            controls.addContent(cgroup);
        }
        parent.addContent(controls);
    }

    private PanPlotControlsMeta() {
    }
}

