/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.graphics.ColorTableFilenameFilter;
import gov.nasa.giss.graphics.ColorTableResourceList;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.colortable.PanColorTableFrame;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.prefsui.PanColorbarTableModel;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTable;
import gov.nasa.giss.panoply.prefsui.PanCommonPrefsTablePanel;
import gov.nasa.giss.panoply.prefsui.PanPrefsTableScrollPane;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.util.PanResourceUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;
import net.schmunk.ui.PlusMinus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanColorTableLibPrefsPanel
extends PanCommonPrefsTablePanel
implements DropTargetListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    void createLayout() {
        LOGGER.trace("");
        this.setBorder(GuiUtils.createPaddedTitleBorder("Color Tables Library"));
        this.setOpaque(false);
        MultiLineLabel tText = new MultiLineLabel("Color tables selected as favorites will be listed at the top of\ncolor table drop-down menus in plot controls.", 0);
        this.checkMinBtn_ = PanButton.small("Check Minimal");
        this.checkAllBtn_ = PanButton.small("Check All");
        QuickBox buttonBox = QuickBox.createCenterBox(this.checkMinBtn_, this.checkAllBtn_);
        this.tmodel_ = new PanColorbarTableModel();
        this.table_ = new PanCommonPrefsTable(this.tmodel_);
        this.tspane_ = new PanPrefsTableScrollPane(this.table_);
        Border ob = this.tspane_.getBorder();
        this.focusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_FOCUSED_BORDER, ob);
        this.unfocusedTableBorder_ = new CompoundBorder(PanGuiUtils.THIN_UNFOCUSED_BORDER, ob);
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        GuiUtils.makeRecursiveDropTarget(this.tspane_, this);
        this.pmwidget_ = new PlusMinus();
        this.pmwidget_.setMaximumSize(this.pmwidget_.getPreferredSize());
        this.pmwidget_.setMinusEnabled(false);
        JLabel bText = new JLabel("Built-in color tables cannot be removed.");
        GuiUtils.setSizeSmall(bText);
        this.autoimportCB_ = PanCheckBox.create("Always import new color tables into support library", false);
        FlexingGridLayout fgl = new FlexingGridLayout(2, 5, 12, 2);
        fgl.setRowWeight(1, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)tText, new FGConstraint(0, 0, 2, 1, 0.5, 0.5));
        this.add((Component)buttonBox, new FGConstraint(0, 1, 2, 1, 0.5, 0.5));
        this.add((Component)this.tspane_, new FGConstraint(0, 2, 2, 1, true));
        this.add((Component)this.pmwidget_, new FGConstraint(0, 3));
        this.add((Component)bText, new FGConstraint(1, 3, 1.0));
        this.add((Component)this.autoimportCB_, new FGConstraint(0, 4, 2, 1, 0.5, 0.5));
    }

    @Override
    void displaySelection(int index) {
        Object o = this.table_.getValueAt(index, 1);
        if (o instanceof AbstractColorTable) {
            AbstractColorTable clut = (AbstractColorTable)o;
            PanColorTableFrame.getSharedInstance().reveal();
            PanColorTableFrame.getSharedInstance().setColorTable(clut);
        }
    }

    @Override
    void additionRequested() {
        PanFrame pf = (PanFrame)this.getTopLevelAncestor();
        File[] ff = PanFileUtils.showOpenColorTableFileChooser(pf);
        if (ff != null) {
            PanResourceUtils.getColorTableList().addAlphabetic((Component)pf, ff);
        }
    }

    @Override
    void deletionRequested(int index) {
        this.table_.clearSelection();
        ColorTableResourceList reslist = PanResourceUtils.getColorTableList();
        reslist.remove(index);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
        this.table_.repaint();
    }

    private void refreshPrivate() {
        LOGGER.trace("");
        this.autoimportCB_.setSelected(prefs_.getBoolean("files:autoimport.colorbars"));
        this.pmwidget_.setPlusEnabled(true);
        int row = this.table_.getSelectedRow();
        ColorTableResourceList reslist = PanResourceUtils.getColorTableList();
        if (row < 0 || row >= reslist.getSize()) {
            this.pmwidget_.setMinusEnabled(false);
        } else {
            this.pmwidget_.setMinusEnabled(reslist.canRemove(row));
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            List<File> droplist = FileUtils.getTransferredFileList(t);
            if (droplist != null) {
                ArrayList<File> addlist = new ArrayList<File>();
                for (File f : droplist) {
                    if (!ColorTableFilenameFilter.isColorTableName(f)) continue;
                    addlist.add(f);
                }
                PanResourceUtils.getColorTableList().addAlphabetic((Component)this, addlist);
            }
            e.dropComplete(true);
            this.repaint();
        } else {
            e.rejectDrop();
        }
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.tspane_.invalidate();
        this.validate();
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.tspane_.setBorder(this.unfocusedTableBorder_);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
            this.tspane_.setBorder(this.focusedTableBorder_);
            this.repaint();
        } else {
            e.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.tspane_.setBorder(this.focusedTableBorder_);
        this.repaint();
    }
}

