/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.prefsui;

import gov.nasa.giss.map.symbol.SymbolID;
import gov.nasa.giss.panoply.prefsui.PanAbstractPrefsPanel;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanParamKeys;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.FloatComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.color.PaletteType;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class PanTrajectoryPrefsPanel
extends PanAbstractPrefsPanel {
    private ColorComboBox[] strokeColorCombos_ = new ColorComboBox[2];
    private DescribedEnumComboBox[] strokeStyleMenus_ = new DescribedEnumComboBox[2];
    private PanIntSpinner[] strokeWeightSpinners_ = new PanIntSpinner[2];
    private DescribedEnumComboBox[] ptSymbolMenus_ = new DescribedEnumComboBox[2];
    private FloatComboBox[] ptSymbolSizeCombos_ = new FloatComboBox[2];
    private ColorComboBox backgroundCombo_;
    private PanCheckBox skipNaNsCB_;
    private boolean refreshing_;

    public PanTrajectoryPrefsPanel() {
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createLayout() {
        this.setBorder(GuiUtils.createPaddedTitleBorder("Lon-Lat Trajectory Plots"));
        this.setOpaque(false);
        JLabel topText = new JLabel("When creating a trajectory map plot, set\u2026");
        JLabel bgLabel1 = new JLabel("Background:\u2009");
        this.backgroundCombo_ = new ColorComboBox(PaletteType.GRAYSCALE);
        this.backgroundCombo_.setName("plot:feature.background");
        this.skipNaNsCB_ = PanCheckBox.create("plot:feature.nanskip", "Skip points with NaN value", prefs_.getBoolean("plot:feature.nanskip"));
        JLabel t1Label = new JLabel("Trajectory 1:\u2009");
        JLabel t2Label = new JLabel("Trajectory 2:\u2009");
        QuickBox[] strokeStyleBoxes = new QuickBox[2];
        QuickBox[] strokeColorBoxes = new QuickBox[2];
        QuickBox[] symbolBoxes = new QuickBox[2];
        for (int i = 0; i < 2; ++i) {
            JLabel t1SymbolLabel1 = new JLabel("Point:\u2009");
            JLabel t1SymbolLabel2 = new JLabel("Symbol:\u2009");
            JLabel t1SymbolLabel3 = new JLabel("\u2014 Size:\u2009");
            this.ptSymbolMenus_[i] = new DescribedEnumComboBox(SymbolID.class);
            this.ptSymbolMenus_[i].setName(PanParamKeys.P_FEATURE_SYMBOL_ID[i]);
            this.ptSymbolMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i] = FloatComboBox.create(2.0f, 16.0f);
            this.ptSymbolSizeCombos_[i].setName(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i]);
            this.ptSymbolSizeCombos_[i].setValue(prefs_.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i]));
            symbolBoxes[i] = QuickBox.createLeftBox(t1SymbolLabel1, t1SymbolLabel2, this.ptSymbolMenus_[i], t1SymbolLabel3, this.ptSymbolSizeCombos_[i]);
            JLabel t1StrokeLabel1 = new JLabel("Stroke:\u2009");
            JLabel t1StrokeLabel2 = new JLabel("Style:\u2009");
            JLabel t2StrokeLabel2 = new JLabel(" ");
            JLabel t2StrokeLabel3 = new JLabel("Color:\u2009");
            JLabel t2StrokeLabel4 = new JLabel("\u2014 Weight:\u2009");
            JLabel t2StrokeLabel5 = new JLabel("%");
            this.strokeStyleMenus_[i] = new DescribedEnumComboBox(PanStrokePattern.class);
            this.strokeStyleMenus_[i].setName(PanParamKeys.P_TRAJ_STROKE_STYLE[i]);
            this.strokeStyleMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i] = new ColorComboBox();
            this.strokeColorCombos_[i].setName(PanParamKeys.P_TRAJ_STROKE_COLOR[i]);
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i] = PanIntSpinner.weightX5(PanParamKeys.P_TRAJ_STROKE_WGT[i], prefs_.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[i]), 0, 250);
            strokeStyleBoxes[i] = QuickBox.createLeftBox(t1StrokeLabel1, t1StrokeLabel2, this.strokeStyleMenus_[i]);
            strokeColorBoxes[i] = QuickBox.createLeftBox(t2StrokeLabel2, t2StrokeLabel3, this.strokeColorCombos_[i], t2StrokeLabel4, this.strokeWeightSpinners_[i], t2StrokeLabel5, Box.createHorizontalStrut(12));
            GuiUtils.matchLabelWidths(t1StrokeLabel1, t2StrokeLabel2, t1SymbolLabel1);
            GuiUtils.matchLabelWidths(t1StrokeLabel2, t2StrokeLabel3, t1SymbolLabel2);
        }
        GuiUtils.matchLabelWidths(bgLabel1, t1Label, t2Label);
        FlexingGridLayout fgl = new FlexingGridLayout(3, 13, 0, 2);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setPadBottom(true);
        this.setLayout(fgl);
        int row = 0;
        this.add((Component)topText, new FGConstraint(0, row, 2, 1));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, ++row));
        this.add((Component)bgLabel1, new FGConstraint(0, ++row));
        this.add((Component)this.backgroundCombo_, new FGConstraint(1, row));
        this.add((Component)this.skipNaNsCB_, new FGConstraint(1, ++row));
        this.add(Box.createVerticalStrut(8), new FGConstraint(0, ++row));
        this.add((Component)new JSeparator(), new FGConstraint(0, ++row, 3, 1));
        this.add((Component)t1Label, new FGConstraint(0, ++row));
        this.add((Component)symbolBoxes[0], new FGConstraint(1, row));
        this.add((Component)strokeStyleBoxes[0], new FGConstraint(1, ++row));
        this.add((Component)strokeColorBoxes[0], new FGConstraint(1, ++row));
        this.add((Component)new JSeparator(), new FGConstraint(0, ++row, 3, 1));
        this.add((Component)t2Label, new FGConstraint(0, ++row));
        this.add((Component)symbolBoxes[1], new FGConstraint(1, row));
        this.add((Component)strokeStyleBoxes[1], new FGConstraint(1, ++row));
        this.add((Component)strokeColorBoxes[1], new FGConstraint(1, ++row));
        this.refreshPrivate();
    }

    private void attachListeners() {
        this.backgroundCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            prefs_.set("plot:feature.background", this.backgroundCombo_.getSelectedColor());
        });
        this.skipNaNsCB_.addItemListener(e -> {
            boolean checked = this.skipNaNsCB_.isSelected();
            prefs_.setBoolean("plot:feature.nanskip", checked);
        });
        int i = 0;
        while (i < 2) {
            int ii = i++;
            this.strokeStyleMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_TRAJ_STROKE_STYLE[ii], this.strokeStyleMenus_[ii].getEnumName());
            });
            this.strokeColorCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (this.refreshing_) {
                    return;
                }
                prefs_.set(PanParamKeys.P_TRAJ_STROKE_COLOR[ii], this.strokeColorCombos_[ii].getSelectedColor());
            });
            this.strokeWeightSpinners_[ii].addChangeListener(e -> {
                if (this.refreshing_) {
                    return;
                }
                prefs_.setInt(PanParamKeys.P_TRAJ_STROKE_WGT[ii], this.strokeWeightSpinners_[ii].getIntValue());
            });
            this.ptSymbolMenus_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.set(PanParamKeys.P_FEATURE_SYMBOL_ID[ii], this.ptSymbolMenus_[ii].getEnumName());
            });
            this.ptSymbolSizeCombos_[ii].addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                prefs_.setFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[ii], this.ptSymbolSizeCombos_[ii].getValue());
            });
        }
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        for (int i = 0; i < 2; ++i) {
            this.strokeStyleMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_TRAJ_STROKE_STYLE[i]));
            this.strokeColorCombos_[i].setSelectedColor(prefs_.getColor(PanParamKeys.P_TRAJ_STROKE_COLOR[i]));
            this.strokeWeightSpinners_[i].setValue(prefs_.getInt(PanParamKeys.P_TRAJ_STROKE_WGT[i]));
            this.ptSymbolMenus_[i].setSelItemMatching(prefs_.getString(PanParamKeys.P_FEATURE_SYMBOL_ID[i]));
            this.ptSymbolSizeCombos_[i].setValue(prefs_.getFloat(PanParamKeys.P_FEATURE_SYMBOL_SIZE[i]));
        }
        this.backgroundCombo_.setSelectedColor(prefs_.getColor("plot:feature.background"));
        this.refreshing_ = false;
    }
}

