/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.sources;

import gov.nasa.giss.data.nc.NcVarVisibility;
import gov.nasa.giss.data.nc.ui.NcDataTreeTablePanel;
import gov.nasa.giss.img.ImageUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.sources.PanDnVPanelDropTargetAdapter;
import gov.nasa.giss.panoply.sources.PanSourcesFrame;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.lang.invoke.MethodHandles;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDnVTreeTablePanel
extends NcDataTreeTablePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PanDnVTreeTablePanel() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        this.setBorder(PanGuiUtils.NO_BORDER);
        this.setOpaque(true);
        this.setSorting(prefs.getString("sources:datasets.sorting"));
        this.setExpandNewNodes(prefs.getBoolean("sources:nodes.expanded"));
        String vclassStr = prefs.getString("sources:datasets.varclass");
        NcVarVisibility vclass = NcVarVisibility.matching(vclassStr);
        if (vclass == null) {
            this.setVisibleVarClass(NcVarVisibility.ALL);
        } else {
            this.setVisibleVarClass(vclass);
        }
        try {
            ImageIcon licon = ImageUtils.getImageIconOfSize(PanSourcesFrame.class.getResource("resources/ttleaf_64x64.png"), 16, 16);
            this.getTreeTable().setLeafIcon(licon);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load treetable leaf icon");
        }
        try {
            ImageIcon oicon = ImageUtils.getImageIconOfSize(PanSourcesFrame.class.getResource("resources/ttfolder_64x64.png"), 16, 16);
            ImageIcon cicon = ImageUtils.getImageIconOfSize(PanSourcesFrame.class.getResource("resources/ttfolder_64x64.png"), 16, 16);
            this.getTreeTable().setOpenIcon(oicon);
            this.getTreeTable().setClosedIcon(cicon);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load treetable folder icon");
        }
        PanDnVPanelDropTargetAdapter dta = new PanDnVPanelDropTargetAdapter(this);
        new DropTarget(this, dta);
        new DropTarget(this.getTreeTable(), dta);
        for (Component c : this.getComponents()) {
            new DropTarget(c, dta);
        }
    }
}

