/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.ui;

import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.ui.SizeVariant;
import gov.nasa.giss.ui.spinner.IntSpinner;

public final class PanIntSpinner
extends IntSpinner {
    private PanIntSpinner(SizeVariant size, String name, int value, int min, int max, int step) {
        super(value, min, max, step);
        if (value < min) {
            this.setValue(min);
        } else if (value > max) {
            this.setValue(max);
        }
        if (name != null) {
            this.setName(name);
        }
        PanGuiUtils.setSizeVariant(this, size);
    }

    public static PanIntSpinner create(String name, int value, int min, int max, int step) {
        return new PanIntSpinner(SizeVariant.REGULAR, name, value, min, max, step);
    }

    public static PanIntSpinner create(int value, int min, int max, int step) {
        return new PanIntSpinner(SizeVariant.REGULAR, null, value, min, max, step);
    }

    public static PanIntSpinner small(String name, int value, int min, int max, int step) {
        return new PanIntSpinner(SizeVariant.SMALL, name, value, min, max, step);
    }

    public static PanIntSpinner small(int value, int min, int max, int step) {
        return new PanIntSpinner(SizeVariant.SMALL, null, value, min, max, step);
    }

    public static PanIntSpinner weight(String name, int value, int min, int max) {
        return new PanIntSpinner(SizeVariant.REGULAR, name, value, min, max, 1);
    }

    public static PanIntSpinner smallWeight(String name, int value, int min, int max) {
        return new PanIntSpinner(SizeVariant.SMALL, name, value, min, max, 1);
    }

    public static PanIntSpinner weightX5(String name, int value, int min, int max) {
        return new PanIntSpinner(SizeVariant.REGULAR, name, value, min, max, 5);
    }

    public static PanIntSpinner smallWeightX5(String name, int value, int min, int max) {
        return new PanIntSpinner(SizeVariant.SMALL, name, value, min, max, 5);
    }

    public static PanIntSpinner createPct(int value) {
        return new PanIntSpinner(SizeVariant.REGULAR, null, value, 0, 100, 1);
    }

    public static PanIntSpinner smallPct(String name, int value) {
        return new PanIntSpinner(SizeVariant.SMALL, name, value, 0, 100, 1);
    }
}

