/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.panoply.util.PanProperties;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanUtils {
    private static final boolean BETA_MODE = PanProperties.VERSION_PROPS.getString("is-beta").equalsIgnoreCase("true");
    private static final boolean DEVO_MODE = BETA_MODE && PanProperties.VERSION_PROPS.getString("is-devo").equalsIgnoreCase("true");
    private static final String SOFTWARE_ID;
    private static final String USER_AGENT;

    public static void printIdentity() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        String version = PanProperties.VERSION_PROPS.getString("version");
        String buildID = PanProperties.VERSION_PROPS.getString("build-id");
        System.out.printf("Panoply %s (%s)%n", version, buildID);
        System.out.printf("Java %s from %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
        System.out.printf("%s %s (%s)%n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        if (logger.isTraceEnabled()) {
            logger.trace("* max heap {} MiB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            if (PanProperties.DEVO_PROPS.getString("debug.CLASSPATH").equalsIgnoreCase("true")) {
                String[] ptokens = System.getProperty("java.class.path").split(":");
                logger.trace("* Classpath:");
                for (String ptoken : ptokens) {
                    logger.trace("* * {}", (Object)ptoken);
                }
            }
            if (PanUtils.isDevo()) {
                logger.trace("* is devoRelease");
            } else if (PanUtils.isBeta()) {
                logger.trace("* is betaRelease");
            }
            if (PanUtils.isDebugBordersEnabled()) {
                logger.trace("* debugBordersEnabled enabled");
            }
            if (PanUtils.isDebugMemoryLogging()) {
                logger.trace("* debugMemoryLogging enabled");
            }
            if (PanUtils.isDevoBuffering()) {
                logger.trace("* devoBuffering enabled");
            }
            if (PanUtils.isDevoSavedSettings()) {
                logger.trace("* devoSavedSettings enabled");
            }
            if (PanUtils.isDevoLogEScale()) {
                logger.trace("* devoLogEScale enabled");
            }
            logger.trace("* userAgent '{}'", (Object)PanUtils.getUserAgent());
        }
    }

    public static void initMiscProperties() {
        System.setProperty("http.agent", PanUtils.getUserAgent());
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
    }

    public static String getSoftwareID() {
        return SOFTWARE_ID;
    }

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public static boolean isBeta() {
        return BETA_MODE;
    }

    public static boolean isDevo() {
        return DEVO_MODE;
    }

    public static boolean isDebugBordersEnabled() {
        return DEVO_MODE && PanProperties.DEVO_PROPS.getString("debug.BORDERS").equalsIgnoreCase("true");
    }

    public static boolean isDebugMemoryLogging() {
        return BETA_MODE && PanProperties.DEVO_PROPS.getString("debug.MEMORY").equalsIgnoreCase("true");
    }

    public static boolean isDevoBuffering() {
        return DEVO_MODE && PanProperties.DEVO_PROPS.getString("devo.BUFFERING").equalsIgnoreCase("true");
    }

    public static boolean isDevoSavedSettings() {
        return DEVO_MODE && PanProperties.DEVO_PROPS.getString("devo.SAVED_SETTINGS").equalsIgnoreCase("true");
    }

    public static boolean isDevoZarrDirectoryStore() {
        return DEVO_MODE && PanProperties.DEVO_PROPS.getString("devo.ZARR_DIR").equalsIgnoreCase("true");
    }

    public static boolean isDevoLogEScale() {
        return DEVO_MODE && PanProperties.DEVO_PROPS.getString("devo.LOG_E_SCALE").equalsIgnoreCase("true");
    }

    private PanUtils() {
    }

    static {
        StringBuilder sbid = new StringBuilder("Panoply ").append(PanProperties.VERSION_PROPS.getString("version"));
        StringBuilder sbua = new StringBuilder("Panoply/").append(PanProperties.VERSION_PROPS.getString("version")).append(" (").append(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version")).append(" (").append(System.getProperty("os.arch")).append("); ").append("Java ").append(System.getProperty("java.version")).append(')');
        SOFTWARE_ID = sbid.toString();
        USER_AGENT = sbua.toString();
    }
}

