/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import java.lang.invoke.MethodHandles;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintfFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Locale locale_;
    private String format_;
    private boolean isSimpleF_;
    private boolean isSimpleG_;
    private static boolean initted_;

    private void init() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        logger.debug("Default locale is '{}'", (Object)Locale.getDefault());
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        logger.debug("Default MINUS_CHAR is '{}'", (Object)Character.valueOf(dfs.getMinusSign()));
        logger.debug("Default DECIMAL_CHAR is '{}'", (Object)Character.valueOf(dfs.getDecimalSeparator()));
        initted_ = true;
    }

    public PrintfFormat(String format) {
        this(Locale.getDefault(), format);
    }

    public PrintfFormat(Locale l, String format) {
        if (!initted_) {
            this.init();
        }
        Objects.requireNonNull(l, "Locale cannot be null");
        this.locale_ = l;
        this.format_ = format;
        this.isSimpleF_ = this.format_.matches("%\\d*\\.\\d+f") || this.format_.matches("%\\d*\\.\\d+F");
        this.isSimpleG_ = this.format_.matches("%\\d*\\.\\d+g") || this.format_.matches("%\\d*\\.\\d+G");
    }

    public String getFormat() {
        return this.format_;
    }

    public static String format(Locale l, String format, Object arg) {
        PrintfFormat pf = new PrintfFormat(l, format);
        return pf.sprintf(arg);
    }

    public static String format(Locale l, String format, Object ... args) {
        PrintfFormat pf = new PrintfFormat(l, format);
        return pf.sprintf(args);
    }

    public String sprintf(Object ... args) {
        return String.format(this.locale_, this.format_, args);
    }

    public String sprintfx(Object arg) {
        String sval = this.sprintf(arg);
        if (this.isSimpleG_) {
            sval = this.trimSimpleG(sval);
        } else if (this.isSimpleF_) {
            sval = this.trimSimpleF(sval);
        }
        return sval;
    }

    public String sprintfx0(Object arg) {
        String sval = this.sprintf(arg);
        if (this.isSimpleG_) {
            sval = this.trimSimpleG0(sval);
        } else if (this.isSimpleF_) {
            sval = this.trimSimpleF(sval);
        }
        return sval;
    }

    private String trimSimpleF(String str) {
        String sval = str;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.locale_);
        char minusChar = dfs.getMinusSign();
        String minus0 = minusChar + "0";
        if (!sval.startsWith(minus0)) {
            return sval;
        }
        if (sval.equals(minus0)) {
            return "0";
        }
        char decimalChar = dfs.getDecimalSeparator();
        String minus0Decimal = minus0 + decimalChar;
        if (sval.startsWith(minus0Decimal)) {
            if (sval.length() > 3) {
                String decimals = sval.substring(3);
                if (decimals.matches("0*")) {
                    return sval.substring(1);
                }
            } else {
                return sval.substring(1);
            }
        }
        return sval;
    }

    private String trimSimpleG(String str) {
        Object sval = str;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.locale_);
        char decimalChar = dfs.getDecimalSeparator();
        int decimalIndex = ((String)sval).indexOf(decimalChar);
        if (decimalIndex < 0) {
            return sval;
        }
        String expString = null;
        String lcExponentStr = dfs.getExponentSeparator().toLowerCase();
        int expIndex = ((String)sval).toLowerCase().indexOf(lcExponentStr);
        if (expIndex > 0) {
            expString = ((String)sval).substring(expIndex);
            sval = ((String)sval).substring(0, expIndex);
        }
        if (((String)sval).endsWith("0")) {
            while (((String)sval).endsWith("00")) {
                sval = ((String)sval).substring(0, ((String)sval).length() - 1);
            }
            if (!((String)sval).endsWith(decimalChar + "0") && ((String)sval).endsWith("0")) {
                sval = ((String)sval).substring(0, ((String)sval).length() - 1);
            }
        }
        if (expString != null) {
            sval = (String)sval + expString;
        }
        return sval;
    }

    private String trimSimpleG0(String str) {
        Object sval = str;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.locale_);
        char decimalChar = dfs.getDecimalSeparator();
        int decimalIndex = ((String)sval).indexOf(decimalChar);
        if (decimalIndex < 0) {
            return sval;
        }
        String expString = null;
        String lcExponentStr = dfs.getExponentSeparator().toLowerCase();
        int expIndex = ((String)sval).toLowerCase().indexOf(lcExponentStr);
        if (expIndex > 0) {
            expString = ((String)sval).substring(expIndex);
            sval = ((String)sval).substring(0, expIndex);
        }
        while (((String)sval).endsWith("0")) {
            sval = ((String)sval).substring(0, ((String)sval).length() - 1);
        }
        if (((String)sval).endsWith("" + decimalChar)) {
            sval = ((String)sval).substring(0, ((String)sval).length() - 1);
        }
        if (expString != null) {
            sval = (String)sval + expString;
        }
        return sval;
    }
}

