/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color.chooser;

import gov.nasa.giss.ui.color.chooser.ColorChooserPanel;
import gov.nasa.giss.ui.color.chooser.ColorChooserSlider;
import gov.nasa.giss.ui.color.chooser.ColorComponentID;
import java.awt.Color;

class RgbSlider
extends ColorChooserSlider {
    RgbSlider(ColorChooserPanel panel, ColorComponentID compID) {
        super(panel, compID);
    }

    @Override
    Color getColorAt(Color c, float pct) {
        int ii = (int)(255.0f * pct);
        switch (this.compID_) {
            case RED: {
                return new Color(ii, c.getGreen(), c.getBlue());
            }
            case GREEN: {
                return new Color(c.getRed(), ii, c.getBlue());
            }
            case BLUE: {
                return new Color(c.getRed(), c.getGreen(), ii);
            }
        }
        return c;
    }

    @Override
    float getTickXPct(Color c) {
        switch (this.compID_) {
            case RED: {
                return (float)c.getRed() / 255.0f;
            }
            case GREEN: {
                return (float)c.getGreen() / 255.0f;
            }
            case BLUE: {
                return (float)c.getBlue() / 255.0f;
            }
        }
        return 0.0f;
    }
}

