/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GissComboBoxRenderer
extends JComponent
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color MAC_FOCUS_BKGD = new Color(0, 105, 217);
    private static final String CHECK = "\u2713";
    protected static final int GAP = 6;
    protected static boolean iconTested_;
    protected static boolean iconIsGood_;
    private static Icon checkIcon_;
    private static Icon invertIcon_;
    protected static int iconWidth_;
    protected static int iconHeight_;
    protected String text_;
    protected boolean isSelected_;
    protected boolean hasFocus_;
    protected boolean isOffset_;
    protected int prefWidth_;
    protected int prefHeight_;
    protected int lineHeight_;
    protected int lineAscent_;
    protected boolean measured_;

    public GissComboBoxRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.setOpaque(false);
        this.createCheckIcon();
    }

    private void createCheckIcon() {
        if (!iconTested_) {
            iconTested_ = true;
            checkIcon_ = UIManager.getIcon("CheckBoxMenuItem.checkIcon");
            if (checkIcon_ == null) {
                LOGGER.trace("checkIcon_ is null");
            } else {
                LOGGER.trace("checkIcon_ is {}", (Object)checkIcon_.getClass());
            }
            try {
                int w = checkIcon_.getIconWidth();
                int h = checkIcon_.getIconHeight();
                int isize = w * h;
                BufferedImage bi = new BufferedImage(w, h, 2);
                BufferedImage bix = new BufferedImage(w, h, 2);
                Graphics2D g2d = bi.createGraphics();
                checkIcon_.paintIcon(null, g2d, 0, 0);
                int[] pixels = bi.getRGB(0, 0, w, h, null, 0, w);
                for (int i = 0; i < isize; ++i) {
                    int rgb = pixels[i];
                    int a = rgb >> 24 & 0xFF;
                    int r = 255;
                    int g = 255;
                    int b = 255;
                    pixels[i] = a << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                }
                bix.setRGB(0, 0, w, h, pixels, 0, w);
                invertIcon_ = new ImageIcon(bix);
                g2d.dispose();
                iconWidth_ = w;
                iconHeight_ = h;
                iconIsGood_ = true;
            }
            catch (Exception exc) {
                LOGGER.trace("exc {}", (Object)exc.getClass().getSimpleName());
                checkIcon_ = null;
                invertIcon_ = null;
                iconWidth_ = 11;
                iconHeight_ = 11;
                iconIsGood_ = false;
            }
            LOGGER.trace("invert iconIsGood_ {}", (Object)iconIsGood_);
        }
    }

    public void setText(String s) {
        this.text_ = s;
        this.measured_ = false;
        this.repaint();
    }

    public void setOffset(boolean b) {
        this.isOffset_ = b;
        this.measured_ = false;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measured_ = false;
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured_) {
            this.measure();
        }
        Insets ins = this.getInsets();
        return new Dimension(this.prefWidth_ + ins.left + ins.right, this.prefHeight_ + ins.top + ins.bottom);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.measured_) {
            this.measure();
        }
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Insets ins = this.getInsets();
        int contentX = ins.left;
        if (this.isOffset_) {
            contentX += 2 + iconWidth_ + 6;
        }
        this.paintBackground(g2d);
        this.paintCheckIcon(g2d);
        this.paintContent(g2d, contentX);
        g2d.dispose();
    }

    private void paintBackground(Graphics2D g2d) {
        Dimension size = this.getSize();
        if (this.hasFocus_) {
            if (PlatformUtils.isMacintosh()) {
                g2d.setColor(MAC_FOCUS_BKGD);
                g2d.fillRect(0, 0, size.width, size.height);
            } else {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, size.width, size.height);
            }
        } else {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, size.width, size.height);
        }
    }

    private void paintCheckIcon(Graphics2D g2d) {
        if (!this.isSelected_) {
            return;
        }
        Dimension size = this.getSize();
        Insets ins = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int checkWidth = fm.stringWidth(CHECK);
        int x = ins.left + 2;
        if (iconIsGood_ && checkIcon_ != null && invertIcon_ != null) {
            int xx = x + (iconWidth_ - checkWidth) / 2;
            int yy = (this.getSize().height - iconHeight_) / 2 + this.lineAscent_;
            g2d.setColor(this.getForeground());
            g2d.drawString(CHECK, xx, yy);
        } else {
            int xx = x + (iconWidth_ - checkWidth) / 2;
            int yy = (this.getSize().height - iconHeight_) / 2 + this.lineAscent_;
            g2d.setColor(this.getForeground());
            g2d.drawString(CHECK, xx, yy);
        }
    }

    protected void paintContent(Graphics2D g2d, int xOffset) {
        String str;
        Dimension size = this.getSize();
        if (this.text_ == null || this.text_.isEmpty()) {
            return;
        }
        boolean disabled = this.text_.startsWith("* ");
        String string = str = disabled ? this.text_.substring(2) : this.text_;
        if (disabled) {
            Color fg = this.getForeground();
            Color cc = new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), fg.getAlpha() / 2);
            g2d.setColor(cc);
        } else {
            g2d.setColor(this.getForeground());
        }
        g2d.drawString(str, xOffset, (size.height - this.lineHeight_) / 2 + this.lineAscent_);
    }

    protected synchronized void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.lineHeight_ = fm.getHeight();
        this.lineAscent_ = fm.getAscent();
        String str = this.text_.startsWith("* ") ? this.text_.substring(2) : this.text_;
        this.prefWidth_ = fm.stringWidth(str);
        this.prefHeight_ = this.lineHeight_ + 1;
        if (this.isOffset_) {
            this.prefWidth_ += 2 + iconWidth_ + 6;
        }
        this.measured_ = true;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            this.isSelected_ = false;
            this.hasFocus_ = false;
            return new JSeparator();
        }
        if (value instanceof String && ((String)value).startsWith("* ")) {
            this.isSelected_ = false;
            this.hasFocus_ = false;
        } else {
            this.isSelected_ = isSelected && index > -1;
            this.hasFocus_ = cellHasFocus;
        }
        this.setOffset(false);
        if (this.hasFocus_) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        this.setText(value.toString());
        this.measured_ = false;
        return this;
    }
}

