/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn;

import com.ghostchu.peerbanhelper.DownloaderServer;
import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.btn.ability.BtnAbility;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityHeartBeat;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityIPAllowList;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityIPDenyList;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityIpQuery;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityReconfigure;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilityRules;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilitySubmitBans;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilitySubmitHistory;
import com.ghostchu.peerbanhelper.btn.ability.impl.BtnAbilitySubmitSwarm;
import com.ghostchu.peerbanhelper.btn.ability.impl.legacy.LegacyBtnAbilitySubmitBans;
import com.ghostchu.peerbanhelper.btn.ability.impl.legacy.LegacyBtnAbilitySubmitPeers;
import com.ghostchu.peerbanhelper.database.dao.impl.HistoryDao;
import com.ghostchu.peerbanhelper.database.dao.impl.MetadataDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerRecordDao;
import com.ghostchu.peerbanhelper.database.dao.impl.tmp.TrackedSwarmDao;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.pow.PoWClient;
import com.ghostchu.peerbanhelper.util.rule.ModuleMatchCache;
import com.ghostchu.peerbanhelper.util.scriptengine.ScriptEngine;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import com.google.common.hash.Hashing;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import oshi.SystemInfo;

@Component
public final class BtnNetwork
implements Reloadable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnNetwork.class);
    private final Map<Class<? extends BtnAbility>, BtnAbility> abilities = Collections.synchronizedMap(new HashMap());
    private final ScriptEngine scriptEngine;
    private final AtomicBoolean configSuccess = new AtomicBoolean(false);
    private final SystemInfo systemInfo;
    private TranslationComponent configResult;
    private boolean scriptExecute;
    private ScheduledExecutorService scheduler = null;
    private String configUrl;
    private boolean submit;
    private String appId;
    private String appSecret;
    private OkHttpClient httpClient;
    private final DownloaderServer server;
    private final PeerRecordDao peerRecordDao;
    private final TrackedSwarmDao trackedSwarmDao;
    private final MetadataDao metadataDao;
    private final HistoryDao historyDao;
    private final HTTPUtil httpUtil;
    private final ModuleMatchCache moduleMatchCache;
    private boolean enabled;
    private String powCaptchaEndpoint;
    private long nextConfigAttemptTime = 0L;

    public BtnNetwork(ScriptEngine scriptEngine, ModuleMatchCache moduleMatchCache, DownloaderServer downloaderServer, HTTPUtil httpUtil, MetadataDao metadataDao, HistoryDao historyDao, TrackedSwarmDao trackedSwarmDao, PeerRecordDao peerRecordDao, SystemInfo systemInfo) {
        this.server = downloaderServer;
        this.scriptEngine = scriptEngine;
        this.moduleMatchCache = moduleMatchCache;
        this.httpUtil = httpUtil;
        this.metadataDao = metadataDao;
        this.historyDao = historyDao;
        this.peerRecordDao = peerRecordDao;
        this.trackedSwarmDao = trackedSwarmDao;
        new Thread(() -> {
            Main.getReloadManager().register((Reloadable)this);
            this.reloadConfig();
        }).start();
        this.systemInfo = systemInfo;
    }

    public ReloadResult reloadModule() throws Exception {
        new Thread(this::reloadConfig).start();
        return super.reloadModule();
    }

    public synchronized void reloadConfig() {
        log.info("Reconfiguring BtnNetwork...");
        this.enabled = Main.getMainConfig().getBoolean("btn.enabled");
        this.configUrl = Main.getMainConfig().getString("btn.config-url");
        this.submit = Main.getMainConfig().getBoolean("btn.submit");
        this.appId = Main.getMainConfig().getString("btn.app-id");
        this.appSecret = Main.getMainConfig().getString("btn.app-secret");
        this.scriptExecute = Main.getMainConfig().getBoolean("btn.allow-script-execute");
        this.configSuccess.set(false);
        this.configResult = null;
        this.nextConfigAttemptTime = System.currentTimeMillis();
        this.resetAbilities();
        this.setupHttpClient();
        this.resetScheduler();
        this.checkIfNeedRetryConfig();
        log.info("BtnNetwork reloaded");
    }

    private void resetAbilities() {
        this.abilities.values().forEach(BtnAbility::unload);
        this.abilities.clear();
    }

    private void resetScheduler() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.enabled) {
            this.scheduler = Executors.newScheduledThreadPool(2);
            this.scheduler.scheduleWithFixedDelay(this::checkIfNeedRetryConfig, 0L, 600L, TimeUnit.SECONDS);
        } else {
            this.scheduler = null;
        }
    }

    public synchronized void configBtnNetwork() {
        Request request = new Request.Builder().url(this.configUrl).get().build();
        try (Response resp = this.httpClient.newCall(request).execute();){
            int statusCode = resp.code();
            if (!resp.isSuccessful()) {
                String response = resp.body().string();
                log.error(TextManager.tlUI(Lang.BTN_CONFIG_FAILS, statusCode + " - " + response, 600));
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_HTTP_REQUEST, this.configUrl, statusCode, response);
                return;
            }
            String response = resp.body().string();
            JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
            if (!json.has("min_protocol_version")) {
                throw new IllegalStateException(TextManager.tlUI(Lang.MISSING_VERSION_PROTOCOL_FIELD, new Object[0]));
            }
            int min_protocol_version = json.get("min_protocol_version").getAsInt();
            if (20 < min_protocol_version) {
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_INCOMPATIBLE_BTN_PROTOCOL_VERSION_CLIENT, 20, min_protocol_version);
                throw new IllegalStateException(TextManager.tlUI(this.configResult));
            }
            int max_protocol_version = json.get("max_protocol_version").getAsInt();
            if (20 > max_protocol_version) {
                this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_UNSUCCESSFUL_INCOMPATIBLE_BTN_PROTOCOL_VERSION_SERVER, 20, max_protocol_version);
                throw new IllegalStateException(TextManager.tlUI(Lang.BTN_INCOMPATIBLE_SERVER, new Object[0]));
            }
            boolean useLegacyAbilities = min_protocol_version < 20;
            this.resetScheduler();
            this.abilities.values().forEach(BtnAbility::unload);
            this.abilities.clear();
            if (json.has("proof_of_work_captcha") && !json.isJsonNull()) {
                JsonObject powCaptcha = json.get("proof_of_work_captcha").getAsJsonObject();
                this.powCaptchaEndpoint = powCaptcha.get("endpoint").getAsString();
            }
            JsonObject ability = json.get("ability").getAsJsonObject();
            if (useLegacyAbilities) {
                if (ability.has("submit_peers") && this.submit) {
                    this.abilities.put(LegacyBtnAbilitySubmitPeers.class, new LegacyBtnAbilitySubmitPeers(this, ability.get("submit_peers").getAsJsonObject()));
                }
                if (ability.has("submit_bans") && this.submit) {
                    this.abilities.put(LegacyBtnAbilitySubmitBans.class, new LegacyBtnAbilitySubmitBans(this, ability.get("submit_bans").getAsJsonObject()));
                }
                if (ability.has("rules")) {
                    this.abilities.put(BtnAbilityRules.class, new BtnAbilityRules(this, this.metadataDao, this.scriptEngine, ability.get("rules").getAsJsonObject(), this.scriptExecute));
                }
            } else {
                if (ability.has("submit_bans") && this.submit) {
                    this.abilities.put(BtnAbilitySubmitBans.class, new BtnAbilitySubmitBans(this, ability.get("submit_bans").getAsJsonObject(), this.metadataDao, this.historyDao));
                }
                if (ability.has("submit_swarm") && this.submit) {
                    this.abilities.put(BtnAbilitySubmitSwarm.class, new BtnAbilitySubmitSwarm(this, ability.get("submit_swarm").getAsJsonObject(), this.metadataDao, this.trackedSwarmDao));
                }
                if (ability.has("ip_denylist")) {
                    this.abilities.put(BtnAbilityIPDenyList.class, new BtnAbilityIPDenyList(this, this.metadataDao, ability.get("ip_denylist").getAsJsonObject()));
                }
                if (ability.has("ip_allowlist")) {
                    this.abilities.put(BtnAbilityIPAllowList.class, new BtnAbilityIPAllowList(this, this.metadataDao, ability.get("ip_allowlist").getAsJsonObject()));
                }
                if (ability.has("rule_peer_identity")) {
                    this.abilities.put(BtnAbilityRules.class, new BtnAbilityRules(this, this.metadataDao, this.scriptEngine, ability.get("rule_peer_identity").getAsJsonObject(), this.scriptExecute));
                }
            }
            if (ability.has("submit_histories") && this.submit) {
                this.abilities.put(BtnAbilitySubmitHistory.class, new BtnAbilitySubmitHistory(this, this.metadataDao, ability.get("submit_histories").getAsJsonObject()));
            }
            if (ability.has("reconfigure")) {
                this.abilities.put(BtnAbilityReconfigure.class, new BtnAbilityReconfigure(this, ability.get("reconfigure").getAsJsonObject()));
            }
            if (ability.has("heartbeat")) {
                this.abilities.put(BtnAbilityHeartBeat.class, new BtnAbilityHeartBeat(this, ability.get("heartbeat").getAsJsonObject()));
            }
            if (ability.has("ip_query")) {
                this.abilities.put(BtnAbilityIpQuery.class, new BtnAbilityIpQuery(this, ability.get("ip_query").getAsJsonObject()));
            }
            this.abilities.values().forEach(a -> {
                try {
                    a.load();
                }
                catch (Exception e) {
                    log.error(TextManager.tlUI(Lang.UNABLE_LOAD_BTN_ABILITY, a.getClass().getSimpleName()), (Throwable)e);
                }
            });
            this.configSuccess.set(true);
            this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_SUCCESSFUL);
        }
        catch (Throwable e) {
            log.error(TextManager.tlUI(Lang.BTN_CONFIG_FAILS, e.getMessage()), e);
            this.configResult = new TranslationComponent(Lang.BTN_CONFIG_STATUS_EXCEPTION, e.getClass().getName(), e.getMessage());
            this.configSuccess.set(false);
            this.nextConfigAttemptTime = System.currentTimeMillis() + 600000L;
        }
    }

    public void gatherAndSolveCaptchaBlocking(@NotNull Request.Builder requestBuilder, @NotNull String type) {
        if (this.powCaptchaEndpoint == null) {
            return;
        }
        Request request = new Request.Builder().url(this.powCaptchaEndpoint + "?type=" + type).get().build();
        try (Response resp = this.httpClient.newCall(request).execute();){
            String respContent = resp.body().string();
            if (!resp.isSuccessful()) {
                log.error(TextManager.tlUI(Lang.BTN_POW_CAPTCHA_LOAD_FROM_REMOTE, resp.code(), respContent));
                return;
            }
            PowCaptchaData powCaptchaData = (PowCaptchaData)JsonUtil.standard().fromJson(respContent, PowCaptchaData.class);
            long startTime = System.currentTimeMillis();
            try (PoWClient poWClient = new PoWClient();){
                log.debug(TextManager.tlUI(Lang.BTN_POW_CAPTCHA_COMPUTING, new Object[0]));
                byte[] nonce = poWClient.solve(Base64.getDecoder().decode(powCaptchaData.getChallengeBase64()), powCaptchaData.getDifficultyBits(), powCaptchaData.getAlgorithm());
                requestBuilder.header("X-BTN-PowID", powCaptchaData.getId()).header("X-BTN-PowSolution", Base64.getEncoder().encodeToString(nonce));
                long costTime = System.currentTimeMillis() - startTime;
                log.debug(TextManager.tlUI(Lang.BTN_POW_CAPTCHA_COMPUTE_COMPLETED, costTime));
            }
        }
        catch (Throwable e) {
            log.error("Unable to gather or solve PoW Captcha", e);
        }
    }

    private void checkIfNeedRetryConfig() {
        try {
            if (this.enabled) {
                if (!this.configSuccess.get() && System.currentTimeMillis() > this.nextConfigAttemptTime) {
                    this.configBtnNetwork();
                }
            } else {
                this.configSuccess.set(false);
            }
        }
        catch (Throwable throwable) {
            log.error(TextManager.tlUI(Lang.UNABLE_COMPLETE_SCHEDULE_TASKS, new Object[0]), throwable);
        }
    }

    private void setupHttpClient() {
        this.httpClient = this.httpUtil.newBuilder().addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("User-Agent", Main.getUserAgent()).header("Content-Type", "application/json").header("BTN-AppID", this.appId).header("BTN-AppSecret", this.appSecret).header("X-BTN-AppID", this.appId).header("X-BTN-AppSecret", this.appSecret).header("Authentication", "Bearer " + this.appId + "@" + this.appSecret);
            if (this.appId == null || this.appId.isBlank() || this.appId.equals("example-app-id") || this.appSecret == null || this.appSecret.isBlank() || this.appSecret.equals("example-app-secret")) {
                requestBuilder.header("X-BTN-InstallationID", this.getInstallationId());
            }
            return chain.proceed(requestBuilder.build());
        }).authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + this.appId + "@" + this.appSecret).build()).callTimeout(Duration.ofMinutes(1L)).build();
    }

    @NotNull
    public String getInstallationId() {
        return Main.getMainConfig().getString("installation-id", "");
    }

    @NotNull
    public String getBtnHardwareId() {
        return Hashing.sha256().hashString((CharSequence)this.systemInfo.getHardware().getComputerSystem().getHardwareUUID(), StandardCharsets.UTF_8).toString();
    }

    public void close() {
        log.info(TextManager.tlUI(Lang.BTN_SHUTTING_DOWN, new Object[0]));
        this.scheduler.shutdown();
        this.abilities.values().forEach(BtnAbility::unload);
        this.abilities.clear();
    }

    @Generated
    public Map<Class<? extends BtnAbility>, BtnAbility> getAbilities() {
        return this.abilities;
    }

    @Generated
    public AtomicBoolean getConfigSuccess() {
        return this.configSuccess;
    }

    @Generated
    public TranslationComponent getConfigResult() {
        return this.configResult;
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public String getConfigUrl() {
        return this.configUrl;
    }

    @Generated
    public boolean isSubmit() {
        return this.submit;
    }

    @Generated
    public String getAppId() {
        return this.appId;
    }

    @Generated
    public String getAppSecret() {
        return this.appSecret;
    }

    @Generated
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public DownloaderServer getServer() {
        return this.server;
    }

    @Generated
    public PeerRecordDao getPeerRecordDao() {
        return this.peerRecordDao;
    }

    @Generated
    public TrackedSwarmDao getTrackedSwarmDao() {
        return this.trackedSwarmDao;
    }

    @Generated
    public MetadataDao getMetadataDao() {
        return this.metadataDao;
    }

    @Generated
    public HistoryDao getHistoryDao() {
        return this.historyDao;
    }

    @Generated
    public HTTPUtil getHttpUtil() {
        return this.httpUtil;
    }

    @Generated
    public ModuleMatchCache getModuleMatchCache() {
        return this.moduleMatchCache;
    }

    public static class PowCaptchaData {
        private String id;
        private String challengeBase64;
        private int difficultyBits;
        private String algorithm;
        private long expireAt;

        @Generated
        public PowCaptchaData(String id, String challengeBase64, int difficultyBits, String algorithm, long expireAt) {
            this.id = id;
            this.challengeBase64 = challengeBase64;
            this.difficultyBits = difficultyBits;
            this.algorithm = algorithm;
            this.expireAt = expireAt;
        }

        @Generated
        public PowCaptchaData() {
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getChallengeBase64() {
            return this.challengeBase64;
        }

        @Generated
        public int getDifficultyBits() {
            return this.difficultyBits;
        }

        @Generated
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Generated
        public long getExpireAt() {
            return this.expireAt;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setChallengeBase64(String challengeBase64) {
            this.challengeBase64 = challengeBase64;
        }

        @Generated
        public void setDifficultyBits(int difficultyBits) {
            this.difficultyBits = difficultyBits;
        }

        @Generated
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Generated
        public void setExpireAt(long expireAt) {
            this.expireAt = expireAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PowCaptchaData)) {
                return false;
            }
            PowCaptchaData other = (PowCaptchaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDifficultyBits() != other.getDifficultyBits()) {
                return false;
            }
            if (this.getExpireAt() != other.getExpireAt()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$challengeBase64 = this.getChallengeBase64();
            String other$challengeBase64 = other.getChallengeBase64();
            if (this$challengeBase64 == null ? other$challengeBase64 != null : !this$challengeBase64.equals(other$challengeBase64)) {
                return false;
            }
            String this$algorithm = this.getAlgorithm();
            String other$algorithm = other.getAlgorithm();
            return !(this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PowCaptchaData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDifficultyBits();
            long $expireAt = this.getExpireAt();
            result = result * 59 + (int)($expireAt >>> 32 ^ $expireAt);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $challengeBase64 = this.getChallengeBase64();
            result = result * 59 + ($challengeBase64 == null ? 43 : $challengeBase64.hashCode());
            String $algorithm = this.getAlgorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnNetwork.PowCaptchaData(id=" + this.getId() + ", challengeBase64=" + this.getChallengeBase64() + ", difficultyBits=" + this.getDifficultyBits() + ", algorithm=" + this.getAlgorithm() + ", expireAt=" + this.getExpireAt() + ")";
        }
    }
}

