/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.configuration.pf4j;

import jakarta.annotation.PostConstruct;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginManager;
import org.pf4j.PluginState;
import org.pf4j.PluginStateEvent;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.ExtensionsInjector;
import org.pf4j.spring.SpringExtensionFactory;
import org.pf4j.spring.SpringPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PBHSpringPluginManager
extends SpringPluginManager
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PBHSpringPluginManager.class);
    private ApplicationContext applicationContext;

    public PBHSpringPluginManager() {
    }

    public PBHSpringPluginManager(Path ... pluginsRoots) {
        super(pluginsRoots);
    }

    public PBHSpringPluginManager(List<Path> pluginsRoots) {
        super(pluginsRoots);
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory((PluginManager)this);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    @PostConstruct
    public void init() {
        this.loadPlugins();
        this.startPlugins();
        AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        ExtensionsInjector extensionsInjector = new ExtensionsInjector(this, beanFactory);
        extensionsInjector.injectExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlugins() {
        for (PluginWrapper pluginWrapper : this.resolvedPlugins) {
            PluginState pluginState = pluginWrapper.getPluginState();
            if (pluginState.isDisabled() || pluginState.isStarted()) continue;
            try {
                log.info("Start plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                pluginWrapper.getPlugin().start();
                pluginWrapper.setPluginState(PluginState.STARTED);
                pluginWrapper.setFailedException(null);
                this.startedPlugins.add(pluginWrapper);
            }
            catch (Throwable e) {
                pluginWrapper.setPluginState(PluginState.FAILED);
                pluginWrapper.setFailedException(e);
                log.error("Unable to start plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()), (Object)e);
            }
            finally {
                this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
            }
        }
    }

    public void stopPlugins() {
        Collections.reverse(this.startedPlugins);
        Iterator itr = this.startedPlugins.iterator();
        while (itr.hasNext()) {
            PluginWrapper pluginWrapper = (PluginWrapper)itr.next();
            PluginState pluginState = pluginWrapper.getPluginState();
            if (pluginState.isStarted()) {
                try {
                    log.info("Stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
                    pluginWrapper.getPlugin().stop();
                    pluginWrapper.setPluginState(PluginState.STOPPED);
                    itr.remove();
                    this.firePluginStateEvent(new PluginStateEvent((PluginManager)this, pluginWrapper, pluginState));
                }
                catch (Throwable e) {
                    log.error("Unable to stop plugin '{}'", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()), (Object)e);
                }
                continue;
            }
            log.debug("Plugin '{}' is not started, nothing to stop", (Object)this.getPluginLabel(pluginWrapper.getDescriptor()));
        }
    }
}

